// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/icons.html.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss } from './tab_organization_selector_button.css.js';
import { getHtml } from './tab_organization_selector_button.html.js';
export class TabOrganizationSelectorButtonElement extends CrLitElement {
    static get is() {
        return 'tab-organization-selector-button';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            bottom: { type: Boolean, reflect: true },
            disabled: { type: Boolean, reflect: true },
            heading: { type: String },
            icon: { type: String },
            subheading: { type: String },
            top: { type: Boolean, reflect: true },
        };
    }
    #bottom_accessor_storage = false;
    get bottom() { return this.#bottom_accessor_storage; }
    set bottom(value) { this.#bottom_accessor_storage = value; }
    #disabled_accessor_storage = false;
    get disabled() { return this.#disabled_accessor_storage; }
    set disabled(value) { this.#disabled_accessor_storage = value; }
    #heading_accessor_storage = '';
    get heading() { return this.#heading_accessor_storage; }
    set heading(value) { this.#heading_accessor_storage = value; }
    #icon_accessor_storage = 'cr:error';
    get icon() { return this.#icon_accessor_storage; }
    set icon(value) { this.#icon_accessor_storage = value; }
    #subheading_accessor_storage = '';
    get subheading() { return this.#subheading_accessor_storage; }
    set subheading(value) { this.#subheading_accessor_storage = value; }
    #top_accessor_storage = false;
    get top() { return this.#top_accessor_storage; }
    set top(value) { this.#top_accessor_storage = value; }
    focus() {
        this.$.button.focus();
    }
    getAriaLabel_() {
        return loadTimeData.getStringF('selectorAriaLabel', this.heading, this.subheading);
    }
}
customElements.define(TabOrganizationSelectorButtonElement.is, TabOrganizationSelectorButtonElement);
