// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import{assert}from"chrome://resources/js/assert.js";import{CustomElement}from"chrome://resources/js/custom_element.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{getTemplate}from"./alert_indicator.html.js";import{TabAlertState}from"./tabs.mojom-webui.js";const MAX_WIDTH="16px";function getAriaLabel(alertState){switch(alertState){case TabAlertState.kMediaRecording:return loadTimeData.getStringF("mediaRecording","");case TabAlertState.kAudioRecording:return loadTimeData.getStringF("audioRecording","");case TabAlertState.kVideoRecording:return loadTimeData.getStringF("videoRecording","");case TabAlertState.kTabCapturing:return loadTimeData.getStringF("tabCapturing","");case TabAlertState.kAudioPlaying:return loadTimeData.getStringF("audioPlaying","");case TabAlertState.kAudioMuting:return loadTimeData.getStringF("audioMuting","");case TabAlertState.kBluetoothConnected:case TabAlertState.kBluetoothScanActive:return loadTimeData.getStringF("bluetoothConnected","");case TabAlertState.kUsbConnected:return loadTimeData.getStringF("usbConnected","");case TabAlertState.kHidConnected:return loadTimeData.getStringF("hidConnected","");case TabAlertState.kSerialConnected:return loadTimeData.getStringF("serialConnected","");case TabAlertState.kPipPlaying:return loadTimeData.getStringF("pipPlaying","");case TabAlertState.kDesktopCapturing:return loadTimeData.getStringF("desktopCapturing","");case TabAlertState.kVrPresentingInHeadset:return loadTimeData.getStringF("vrPresenting","");default:return""}}const ALERT_STATE_MAP=new Map([[TabAlertState.kMediaRecording,"media-recording"],[TabAlertState.kAudioRecording,"audio-recording"],[TabAlertState.kVideoRecording,"video-recording"],[TabAlertState.kTabCapturing,"tab-capturing"],[TabAlertState.kAudioPlaying,"audio-playing"],[TabAlertState.kAudioMuting,"audio-muting"],[TabAlertState.kBluetoothConnected,"bluetooth-connected"],[TabAlertState.kBluetoothScanActive,"bluetooth-connected"],[TabAlertState.kUsbConnected,"usb-connected"],[TabAlertState.kHidConnected,"hid-connected"],[TabAlertState.kSerialConnected,"serial-connected"],[TabAlertState.kPipPlaying,"pip-playing"],[TabAlertState.kDesktopCapturing,"desktop-capturing"],[TabAlertState.kVrPresentingInHeadset,"vr-presenting"]]);function getAlertStateAttribute(alertState){return ALERT_STATE_MAP.get(alertState)||""}export class AlertIndicatorElement extends CustomElement{static get template(){return getTemplate()}alertState_=null;fadeDurationMs_=125;fadeInAnimation_;fadeOutAnimation_;fadeOutAnimationPromise_;constructor(){super();this.fadeInAnimation_=null;this.fadeOutAnimation_=null;this.fadeOutAnimationPromise_=null}get alertState(){assert(this.alertState_!==null);return this.alertState_}set alertState(alertState){this.setAttribute("alert-state_",getAlertStateAttribute(alertState));this.setAttribute("aria-label",getAriaLabel(alertState));this.alertState_=alertState}overrideFadeDurationForTesting(duration){this.fadeDurationMs_=duration}show(){if(this.fadeOutAnimation_){this.fadeOutAnimation_.cancel();this.fadeOutAnimation_=null;this.fadeOutAnimationPromise_=null}if(this.fadeInAnimation_){return}if(this.alertState_===TabAlertState.kMediaRecording||this.alertState_===TabAlertState.kAudioRecording||this.alertState_===TabAlertState.kVideoRecording||this.alertState_===TabAlertState.kTabCapturing||this.alertState_===TabAlertState.kDesktopCapturing){const totalDuration=2600;this.fadeInAnimation_=this.animate([{opacity:0,maxWidth:0,offset:0},{opacity:1,maxWidth:MAX_WIDTH,offset:200/totalDuration},{opacity:0,maxWidth:MAX_WIDTH,offset:1200/totalDuration},{opacity:1,maxWidth:MAX_WIDTH,offset:1400/totalDuration},{opacity:0,maxWidth:MAX_WIDTH,offset:2400/totalDuration},{opacity:1,maxWidth:MAX_WIDTH,offset:1}],{duration:totalDuration,easing:"linear",fill:"forwards"})}else{this.fadeInAnimation_=this.animate([{opacity:0,maxWidth:0},{opacity:1,maxWidth:MAX_WIDTH}],{duration:this.fadeDurationMs_,fill:"forwards"})}}hide(){if(this.fadeInAnimation_){this.fadeInAnimation_.cancel();this.fadeInAnimation_=null}if(this.fadeOutAnimationPromise_){return this.fadeOutAnimationPromise_}this.fadeOutAnimationPromise_=new Promise(((resolve,reject)=>{this.fadeOutAnimation_=this.animate([{opacity:1,maxWidth:MAX_WIDTH},{opacity:0,maxWidth:0}],{duration:this.fadeDurationMs_,fill:"forwards"});this.fadeOutAnimation_.addEventListener("cancel",(()=>{reject()}));this.fadeOutAnimation_.addEventListener("finish",(()=>{this.remove();this.fadeOutAnimation_=null;this.fadeOutAnimationPromise_=null;resolve()}))}));return this.fadeOutAnimationPromise_}}customElements.define("tabstrip-alert-indicator",AlertIndicatorElement);