// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import"../alert_indicators.js";import{TabStripService}from"/tab_strip_api/tab_strip_api.mojom-webui.js";import{NetworkState}from"/tab_strip_api/tab_strip_api_data_model.mojom-webui.js";import{assert}from"chrome://resources/js/assert.js";import{CustomElement}from"chrome://resources/js/custom_element.js";import{getFavicon}from"chrome://resources/js/icon.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{isRTL}from"chrome://resources/js/util.js";import{getTemplate}from"../tab.html.js";function getPaddingInlineEndProperty(){return isRTL()?"paddingLeft":"paddingRight"}export class TabElement extends CustomElement{static get template(){return getTemplate()}alertIndicatorsEl_;closeButtonEl_;tabEl_;faviconEl_;thumbnail_;tab_=null;titleTextEl_;onTabActivating_;dragHandler_;isActive=false;isPinned=false;blocked=false;crashed=false;showIcon=false;get draggable(){return this.hasAttribute("draggable")}set draggable(isDraggable){this.toggleAttribute("draggable",isDraggable)}constructor(){super();this.alertIndicatorsEl_=this.getRequiredElement("tabstrip-alert-indicators");customElements.upgrade(this.alertIndicatorsEl_);this.closeButtonEl_=this.getRequiredElement("#close");this.closeButtonEl_.setAttribute("aria-label",loadTimeData.getString("closeTab"));this.tabEl_=this.getRequiredElement("#tab");this.faviconEl_=this.getRequiredElement("#favicon");this.thumbnail_=this.getRequiredElement("#thumbnailImg");this.titleTextEl_=this.getRequiredElement("#titleText");this.dragHandler_=()=>0;this.tabEl_.addEventListener("click",(()=>this.onClick_()));this.addEventListener("dragend",(event=>this.dragHandler_(this,event.clientX,event.clientY)));this.closeButtonEl_.addEventListener("click",(e=>this.onClose_(e)));this.onTabActivating_=tabId=>TabStripService.getRemote().activateTab(tabId)}get tab(){assert(this.tab_);return this.tab_}set dragEndHandler(handler){this.dragHandler_=handler}set tab(tab){this.toggleAttribute("active",this.isActive);this.toggleAttribute("hide-icon_",!this.showIcon);this.toggleAttribute("waiting_",tab.networkState===NetworkState.kWaiting);this.toggleAttribute("loading_",tab.networkState===NetworkState.kLoading);this.toggleAttribute("pinned",this.isPinned);this.setAttribute("draggable","true");this.toggleAttribute("blocked_",this.blocked);this.toggleAttribute("crashed_",this.crashed);if(tab.title){this.titleTextEl_.textContent=tab.title}else if(tab.networkState===NetworkState.kWaiting||tab.networkState===NetworkState.kLoading){this.titleTextEl_.textContent=loadTimeData.getString("loadingTab")}else{this.titleTextEl_.textContent=loadTimeData.getString("defaultTabTitle")}this.titleTextEl_.setAttribute("aria-label",tab.title);if(tab.networkState===NetworkState.kWaiting){this.faviconEl_.style.backgroundImage="none"}else if(tab.favicon){this.faviconEl_.style.backgroundImage=`url(${tab.favicon.dataUrl.url})`}else{this.faviconEl_.style.backgroundImage=getFavicon("")}this.setAttribute("data-tab-id",tab.id);this.alertIndicatorsEl_.updateAlertStates(tab.alertStates).then((alertIndicatorsCount=>{this.toggleAttribute("has-alert-states_",alertIndicatorsCount>0)}));this.tab_=Object.freeze(tab)}focus(){this.tabEl_.focus()}updateThumbnail(imgData){this.thumbnail_.src=imgData}onClick_(){if(this.tab_){this.onTabActivating_(this.tab_.id)}else{console.warn("Tab data is not available for onClick event.")}}onClose_(event){assert(this.tab_);event.stopPropagation();console.info("Close tab",this.tab_.id);TabStripService.getRemote().closeTabs([this.tab_.id])}slideOut(){assert(this.tab_);return new Promise((resolve=>{const finishCallback=()=>{this.remove();resolve()};this.animate({transform:["translateY(0)","translateY(-100%)"]},{duration:150,easing:"cubic-bezier(.4, 0, 1, 1)",fill:"forwards"});this.animate({opacity:[1,0]},{delay:97.5,duration:50,fill:"forwards"});const widthAnimationKeyframes={maxWidth:["var(--tabstrip-tab-width)",0],[getPaddingInlineEndProperty()]:["var(--tabstrip-tab-spacing)",0]};const widthAnimation=this.animate(widthAnimationKeyframes,{delay:97.5,duration:300,easing:"cubic-bezier(.4, 0, 0, 1)",fill:"forwards"});const visibilityChangeListener=()=>{console.info("Visibility change listener triggered")};document.addEventListener("visibilitychange",visibilityChangeListener,{once:true});widthAnimation.onfinish=()=>{document.removeEventListener("visibilitychange",visibilityChangeListener);finishCallback()}}))}}customElements.define("tabstrip-tab-playground",TabElement);export function isTabElement(element){return element.tagName==="TABSTRIP-TAB-PLAYGROUND"}