import { getTrustedHTML } from '//resources/js/static_types.js';
export function getTemplate() {
    return getTrustedHTML `<!--_html_template_start_--><style>:host{--tabstrip-tab-transition-duration:250ms;display:block;height:var(--tabstrip-tab-height);padding-inline-end:var(--tabstrip-tab-spacing);position:relative;transform-origin:top left;width:var(--tabstrip-tab-width)}:host-context([dir='rtl']){transform-origin:top right}:host([dragged-out_]){display:none}tabstrip-alert-indicators{--indicator-color:var(--color-web-ui-tab-strip-tab-text)}#tab{background:var(--color-web-ui-tab-strip-tab-background);border-radius:var(--tabstrip-tab-border-radius);box-shadow:0 0 0 1px var(--color-web-ui-tab-strip-tab-separator);color:var(--color-web-ui-tab-strip-tab-text);display:flex;flex-direction:column;height:var(--tabstrip-tab-height);overflow:hidden;width:var(--tabstrip-tab-width)}#tab:focus{outline:none}:host-context(.focus-outline-visible) #tab:focus{box-shadow:0 0 0 2px var(--color-web-ui-tab-strip-focus-outline)}:host([active]) #title{background-color:var(--color-web-ui-tab-strip-tab-active-title-background)}:host([active]) #titleText{color:var(--color-web-ui-tab-strip-tab-active-title-content)}:host([active]) #titleText::after{background:linear-gradient(to right,transparent,var(--color-web-ui-tab-strip-tab-active-title-background))}:host-context([dir='rtl']):host([active]) #titleText::after{background:linear-gradient(to left,transparent,var(--color-web-ui-tab-strip-tab-active-title-background))}:host([active]) tabstrip-alert-indicators{--indicator-color:var(--color-web-ui-tab-strip-tab-active-title-content);--tabstrip-indicator-capturing-color:var(--color-web-ui-tab-strip-tab-active-title-content);--tabstrip-indicator-pip-color:var(--color-web-ui-tab-strip-tab-active-title-content)}:host([active]) #closeIcon{background-color:var(--color-web-ui-tab-strip-tab-active-title-content)}#title{align-items:center;border-block-end:1px solid var(--color-web-ui-tab-strip-tab-separator);box-sizing:border-box;display:flex;height:var(--tabstrip-tab-title-height);justify-content:center;margin:0;overflow:hidden}#faviconContainer{--favicon-size:16px;flex-shrink:0;height:var(--favicon-size);margin-inline-end:8px;margin-inline-start:12px;max-width:var(--favicon-size);position:relative;transition:margin var(--tabstrip-tab-transition-duration),max-width var(--tabstrip-tab-transition-duration),opacity 0ms linear var(--tabstrip-tab-transition-duration);width:var(--favicon-size)}:host([hide-icon_]) #faviconContainer{margin-inline-end:0;max-width:0;opacity:0;transition:margin var(--tabstrip-tab-transition-duration),max-width var(--tabstrip-tab-transition-duration),opacity 0ms}:host([pinned]) #faviconContainer{margin:0}:host([touch_pressed_]) #dragImage{transform:scale(1.1);transform-origin:center;transition-duration:300ms}#progressSpinner,#favicon,#crashedIcon{height:var(--favicon-size);left:50%;position:absolute;top:50%;transform:translate(-50%,-50%);width:var(--favicon-size)}#progressSpinner{-webkit-mask:url(chrome://resources/images/throbber_small.svg) center/contain no-repeat;display:none}#favicon{background-size:contain;transition:border-radius var(--tabstrip-tab-transition-duration)}#crashedIcon{-webkit-mask:url(chrome://theme/IDR_CRASH_SAD_FAVICON@2x) center/contain no-repeat;background-color:currentColor;opacity:0;transform:translate(-50%,100%)}#blocked{background:var(--color-web-ui-tab-strip-tab-blocked);border:solid 1px var(--color-web-ui-tab-strip-tab-background);border-radius:50%;bottom:0;display:none;height:6px;position:absolute;right:0;transform:translate(50%,50%);width:6px}:host([waiting_]) #progressSpinner,:host([loading_]) #progressSpinner{display:block}:host([loading_]) #favicon{border-radius:50%;height:calc(var(--favicon-size) - 6px);overflow:hidden;width:calc(var(--favicon-size) - 6px)}:host([waiting_]) #progressSpinner{background-color:var(--color-web-ui-tab-strip-tab-waiting-spinning);transform:translate(-50%,-50%) scaleX(-1)}:host([active][waiting_]) #progressSpinner{background-color:var(--color-web-ui-tab-strip-tab-active-title-content)}:host([waiting_]) #favicon{display:none}:host([loading_]) #progressSpinner{background-color:var(--color-web-ui-tab-strip-tab-loading-spinning)}:host([active][loading_]) #progressSpinner{background-color:var(--color-web-ui-tab-strip-tab-active-title-content)}:host([crashed_]) #favicon{opacity:0;transform:translate(-50%,100%);transition:opacity var(--tabstrip-tab-transition-duration),transform var(--tabstrip-tab-transition-duration)}:host([crashed_]) #crashedIcon{opacity:1;transform:translate(-50%,-50%);transition:opacity var(--tabstrip-tab-transition-duration),transform var(--tabstrip-tab-transition-duration);transition-delay:var(--tabstrip-tab-transition-duration)}:host([blocked_]) #blocked{display:block}:host([active][blocked_]) #blocked{display:none}#titleText{flex:1;font-size:100%;font-weight:normal;overflow:hidden;position:relative;white-space:nowrap}#titleText::after{background:linear-gradient(to right,transparent,var(--color-web-ui-tab-strip-tab-background));content:'';display:block;height:100%;position:absolute;right:0;top:0;width:3ch}:host-context([dir='rtl']) #titleText::after{background:linear-gradient(to left,transparent,var(--color-web-ui-tab-strip-tab-background));left:0;right:auto}:host([has-alert-states_]) #titleText{margin-inline-end:4px}#close{-webkit-appearance:none;-webkit-tap-highlight-color:transparent;align-items:center;background-color:transparent;border:0;color:inherit;cursor:pointer;display:flex;flex-shrink:0;height:100%;justify-content:center;outline:none;padding:0;position:relative;width:36px}#closeIcon{-webkit-mask:url(chrome://resources/images/icon_clear.svg) center/contain no-repeat;background-color:currentColor;display:block;height:18px;position:relative;width:18px}:host-context(.focus-outline-visible) #close:focus #closeIconFocus{background:currentColor;border-radius:50%;height:24px;opacity:0.16;position:absolute;width:24px}#thumbnail{align-items:flex-start;background:var(--color-web-ui-tab-strip-tab-background);display:flex;flex:1;height:var(--tabstrip-tab-thumbnail-height);justify-content:center;width:var(--tabstrip-tab-thumbnail-width)}#thumbnailImg{min-height:100%;object-fit:cover;pointer-events:none;width:100%}#thumbnailImg:not([src]){display:none;pointer-events:none;width:100%}:host([pinned]){--tabstrip-tab-height:var(--tabstrip-pinned-tab-size);--tabstrip-tab-width:var(--tabstrip-pinned-tab-size)}:host([pinned]) #title{border-block-end:0;height:100%}:host([pinned]) #titleText,:host([pinned]) #close,:host([pinned]) #thumbnail{display:none}:host([pinned][has-alert-states_]) #faviconContainer{display:none}:host([dragging_]) #dragPlaceholder{background:var(--color-web-ui-tab-strip-tab-background);border-radius:var(--tabstrip-tab-border-radius);height:100%;opacity:0.5;width:100%}:host([dragging_]) #dragImage{--drag-image-padding:25px;height:100%;padding:var(--drag-image-padding);position:absolute;top:100vh;width:100%}:host([dragging_]) #tab{box-shadow:var(--tabstrip-tab-dragging-shadow);transform:scale(var(--tabstrip-tab-drag-image-scale))}</style>

<div id="dragPlaceholder"></div>

<!--
  #dragImage is a wrapper that wraps the entire #tab contents so that #tab can
  be styled with properties, such as box-shadow, that extend beyond #tab's
  boundaries and #dragImage can add padding to itself to contain all of #tab's
  styles. When the tab is not being dragged, the #dragImage parent has no use.
-->
<div id="dragImage">
  <div id="tab" role="tab" tabindex="0"
      aria-labelledby="titleText alertIndicators">
    <header id="title">
      <div id="faviconContainer" aria-hidden="true">
        <div id="progressSpinner"></div>
        <div id="favicon"></div>
        <div id="crashedIcon"></div>
        <div id="blocked"></div>
      </div>
      <h2 id="titleText"></h2>
      <tabstrip-alert-indicators id="alertIndicators">
      </tabstrip-alert-indicators>
      <button id="close" aria-describedby="titleText">
        <span id="closeIconFocus"></span>
        <span id="closeIcon"></span>
      </button>
    </header>

    <div id="thumbnail">
      <img id="thumbnailImg">
    </div>
  </div>
</div>
<!--_html_template_end_-->`;
}
