// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_tree/cr_tree.js";import"chrome://resources/cr_elements/cr_tree/cr_tree_item.js";import{assert}from"chrome://resources/js/assert.js";import{UsbControlTransferRecipient,UsbControlTransferType,UsbTransferStatus}from"./usb_device.mojom-webui.js";const INPUT_TYPE_DECIMAL_WITH_DROPDOWN=0;const INPUT_TYPE_HEX_BYTE=1;const GET_DESCRIPTOR_REQUEST=6;const CONTROL_TRANSFER_DIRECTION_HOST_TO_DEVICE=0;const CONTROL_TRANSFER_DIRECTION_DEVICE_TO_HOST=1;const DEVICE_DESCRIPTOR_TYPE=1;const CONFIGURATION_DESCRIPTOR_TYPE=2;const STRING_DESCRIPTOR_TYPE=3;const INTERFACE_DESCRIPTOR_TYPE=4;const ENDPOINT_DESCRIPTOR_TYPE=5;const BOS_DESCRIPTOR_TYPE=15;const DEVICE_CAPABILITY_DESCRIPTOR_TYPE=16;const DEVICE_CAPABILITY_DESCRIPTOR_TYPE_PLATFORM_TYPE=5;const DEVICE_DESCRIPTOR_LENGTH=18;const CONFIGURATION_DESCRIPTOR_LENGTH=9;const MAX_STRING_DESCRIPTOR_LENGTH=255;const INTERFACE_DESCRIPTOR_LENGTH=9;const ENDPOINT_DESCRIPTOR_LENGTH=7;const BOS_DESCRIPTOR_HEADER_LENGTH=5;const MAX_URL_DESCRIPTOR_LENGTH=255;const CONTROL_TRANSFER_TIMEOUT_MS=2e3;const STANDARD_DESCRIPTOR_LENGTH_OFFSET=0;const STANDARD_DESCRIPTOR_TYPE_OFFSET=1;const CONFIGURATION_DESCRIPTOR_TOTAL_LENGTH_OFFSET=2;const CONFIGURATION_DESCRIPTOR_NUM_INTERFACES_OFFSET=4;const INTERFACE_DESCRIPTOR_NUM_ENDPOINTS_OFFSET=4;const BOS_DESCRIPTOR_TOTAL_LENGTH_OFFSET=2;const BOS_DESCRIPTOR_NUM_DEVICE_CAPABILITIES_OFFSET=4;const BOS_DESCRIPTOR_DEVICE_CAPABILITY_TYPE_OFFSET=2;const LANGUAGE_CODE_EN_US=1033;const WIN_81_HEADER=100859904;const GET_URL_REQUEST=2;const WEB_USB_VENDOR_CODE_OFFSET=22;const WEB_USB_URL_DESCRIPTOR_INDEX_OFFSET=23;const WEB_USB_CAPABILITY_UUID=[56,182,8,52,169,9,160,71,139,253,160,118,136,21,182,101];const MS_OS_20_DESCRIPTOR_INDEX=7;const MS_OS_20_SET_ALT_ENUMERATION=8;const MS_OS_20_SET_TOTAL_LENGTH_OFFSET=4;const MS_OS_20_VENDOR_CODE_ITEM_OFFSET=6;const MS_OS_20_ALT_ENUM_CODE_ITEM_OFFSET=7;const MS_OS_20_DESCRIPTOR_LENGTH_OFFSET=0;const MS_OS_20_DESCRIPTOR_TYPE_OFFSET=2;const MS_OS_20_REGISTRY_PROPERTY_DESCRIPTOR_PROPERTY_DATA_TYPE_OFFSET=4;const MS_OS_20_REGISTRY_PROPERTY_DESCRIPTOR_NAME_LENGTH_OFFSET=6;const MS_OS_20_SET_HEADER_DESCRIPTOR=0;const MS_OS_20_SUBSET_HEADER_CONFIGURATION=1;const MS_OS_20_SUBSET_HEADER_FUNCTION=2;const MS_OS_20_FEATURE_COMPATIBLE_ID=3;const MS_OS_20_FEATURE_REG_PROPERTY=4;const MS_OS_20_FEATURE_MIN_RESUME_TIME=5;const MS_OS_20_FEATURE_MODEL_ID=6;const MS_OS_20_FEATURE_CCGP_DEVICE=7;const MS_OS_20_FEATURE_VENDOR_REVISION=8;const MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_SZ=1;const MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_EXPAND_SZ=2;const MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_BINARY=3;const MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_DWORD_LITTLE_ENDIAN=4;const MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_DWORD_BIG_ENDIAN=5;const MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_LINK=6;const MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_MULTI_SZ=7;const MS_OS_20_PLATFORM_CAPABILITY_UUID=[223,96,221,216,137,69,199,76,156,210,101,157,158,100,138,159];export class DescriptorPanel{usbDeviceProxy_;rootElement_;stringDescriptorPanel_=null;languageCodesListElement_=null;indexInput_=null;stringDescriptorIndexes=new Set;indexesListElement=null;constructor(usbDeviceProxy,rootElement){this.usbDeviceProxy_=usbDeviceProxy;this.rootElement_=rootElement}setStringDescriptorPanel(stringDescriptorPanel){this.stringDescriptorPanel_=stringDescriptorPanel}clearView(){this.rootElement_.querySelectorAll("descriptorpanel").forEach((el=>el.remove()));this.rootElement_.querySelectorAll("error").forEach((el=>el.remove()));this.rootElement_.querySelectorAll("descriptorpaneltitle").forEach((el=>el.remove()))}getButtonElementFromTemplate_(){const buttonTemplate=this.rootElement_.getRootNode().querySelector("#raw-data-tree-button");assert(buttonTemplate);const button=document.importNode(buttonTemplate.content,true).querySelector("button");assert(button);return button}renderIndexItem_(rawData,offset,item,fieldLabel){const index=rawData[offset];if(index>0){assert(this.stringDescriptorPanel_);if(!this.stringDescriptorPanel_.stringDescriptorIndexes.has(index)){const optionElement=document.createElement("option");optionElement.label=index.toString();optionElement.value=index.toString();assert(this.stringDescriptorPanel_.indexesListElement);this.stringDescriptorPanel_.indexesListElement.appendChild(optionElement);this.stringDescriptorPanel_.stringDescriptorIndexes.add(index)}const button=this.getButtonElementFromTemplate_();item.labelElement.appendChild(button);button.style.marginInlineStart="16px";button.addEventListener("click",(event=>{event.stopPropagation();const children=item.shadowRoot.querySelector(".tree-children");assert(children);children.textContent="";assert(this.stringDescriptorPanel_);this.stringDescriptorPanel_.clearView();this.stringDescriptorPanel_.getStringDescriptorForAllLanguages_(index,item)}))}else if(index<0){const fieldName=fieldLabel.slice(0,-2);showError(`Invalid String Descriptor occurs in field ${fieldName} of this descriptor.`,this.rootElement_)}}renderUrlDescriptorIndexItem_(rawData,offset,item,_fieldLabel){const index=rawData[offset];if(index>0){const button=this.getButtonElementFromTemplate_();item.labelElement.appendChild(button);button.addEventListener("click",(event=>{event.stopPropagation();const children=item.shadowRoot.querySelector(".tree-children");assert(children);children.textContent="";this.getUrlDescriptor_(rawData,offset-WEB_USB_URL_DESCRIPTOR_INDEX_OFFSET,item)}))}}renderMsOs20DescriptorVendorSpecific_(rawData,offset,item){const vendorCode=rawData[offset+MS_OS_20_VENDOR_CODE_ITEM_OFFSET];const data=new DataView(rawData.buffer,offset);const msOs20DescriptorSetLength=data.getUint16(MS_OS_20_SET_TOTAL_LENGTH_OFFSET,true);const button=this.getButtonElementFromTemplate_();item.labelElement.appendChild(button);button.addEventListener("click",(async event=>{event.stopPropagation();Array.from(this.rootElement_.querySelectorAll("descriptorpanel")).slice(1).forEach((el=>el.remove()));this.rootElement_.querySelectorAll("descriptorpaneltitle").forEach((el=>el.remove()));const msOs20RawData=await this.getMsOs20DescriptorSet_(vendorCode,msOs20DescriptorSetLength);this.renderMsOs20DescriptorSet_(msOs20RawData)}))}renderMsOs20DescriptorSetAltEnum_(rawData,offset,item){const altEnumCode=rawData[offset+MS_OS_20_ALT_ENUM_CODE_ITEM_OFFSET];if(altEnumCode!==0){const vendorCode=rawData[offset+MS_OS_20_VENDOR_CODE_ITEM_OFFSET];const button=this.getButtonElementFromTemplate_();item.labelElement.appendChild(button);button.addEventListener("click",(async event=>{event.stopPropagation();await this.sendMsOs20DescriptorSetAltEnumCommand_(vendorCode,altEnumCode)}))}}renderFeatureRegistryPropertyDataItem_(rawData,offset,item,_fieldLabel,featureRegistryPropertyDataType,length){let data;switch(featureRegistryPropertyDataType){case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_BINARY:break;case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_DWORD_LITTLE_ENDIAN:data=new DataView(rawData.buffer,offset);item.label+=data.getUint32(0,true);break;case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_DWORD_BIG_ENDIAN:data=new DataView(rawData.buffer,offset);item.label+=data.getUint32(0,false);break;case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_SZ:case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_EXPAND_SZ:case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_LINK:case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_MULTI_SZ:item.label+=decodeUtf16Array(rawData.slice(offset,offset+length),true);break;case 0:default:item.label+=`Illegal Data Type. (${featureRegistryPropertyDataType} should be reserved.)`;break}}async renderStandardDescriptor_(data,languageCode=0,treeItem){const displayElement=addNewDescriptorDisplayElement(this.rootElement_);const rawDataTreeRoot=displayElement.rawDataTreeRoot;const rawDataByteElement=displayElement.rawDataByteElement;renderRawDataBytes(rawDataByteElement,data);let offset=0;let indexInterface=0;let indexEndpoint=0;let indexUnknown=0;let indexDevCapability=0;let expectNumInterfaces=0;let expectNumEndpoints=0;let expectNumDevCapabilities=0;let lastInterfaceItem;while(offset+STANDARD_DESCRIPTOR_TYPE_OFFSET<data.length){const length=data[offset+STANDARD_DESCRIPTOR_LENGTH_OFFSET];const descriptorType=data[offset+STANDARD_DESCRIPTOR_TYPE_OFFSET];switch(descriptorType){case DEVICE_DESCRIPTOR_TYPE:this.renderDeviceDescriptor_(rawDataTreeRoot,rawDataByteElement,data,offset);break;case CONFIGURATION_DESCRIPTOR_TYPE:if(CONFIGURATION_DESCRIPTOR_NUM_INTERFACES_OFFSET<length){expectNumInterfaces=data[offset+CONFIGURATION_DESCRIPTOR_NUM_INTERFACES_OFFSET]}this.renderConfigurationDescriptor_(rawDataTreeRoot,rawDataByteElement,data,offset);break;case STRING_DESCRIPTOR_TYPE:this.renderStringDescriptorForLanguageCode_(rawDataTreeRoot,rawDataByteElement,data,offset,languageCode,treeItem);break;case INTERFACE_DESCRIPTOR_TYPE:if(INTERFACE_DESCRIPTOR_NUM_ENDPOINTS_OFFSET<length){expectNumEndpoints+=data[offset+INTERFACE_DESCRIPTOR_NUM_ENDPOINTS_OFFSET]}lastInterfaceItem=this.renderInterfaceDescriptor_(rawDataTreeRoot,rawDataByteElement,data,offset,indexInterface);indexInterface++;break;case ENDPOINT_DESCRIPTOR_TYPE:const treeRoot=lastInterfaceItem||rawDataTreeRoot;this.renderEndpointDescriptor_(treeRoot,rawDataByteElement,data,offset,indexEndpoint);indexEndpoint++;break;case BOS_DESCRIPTOR_TYPE:this.renderBosDescriptor_(rawDataTreeRoot,rawDataByteElement,data,offset);expectNumDevCapabilities=data[BOS_DESCRIPTOR_NUM_DEVICE_CAPABILITIES_OFFSET];break;case DEVICE_CAPABILITY_DESCRIPTOR_TYPE:await this.renderDeviceCapabilityDescriptor_(rawDataTreeRoot,rawDataByteElement,data,offset,indexDevCapability);indexDevCapability++;break;default:this.renderUnknownDescriptor_(rawDataTreeRoot,rawDataByteElement,data,offset,indexUnknown);indexUnknown++;break}offset+=length}if(expectNumInterfaces!==indexInterface){showError(`Expected to find ${expectNumInterfaces} interface descriptors `+`but only encountered ${indexInterface}.`,this.rootElement_)}if(expectNumEndpoints!==indexEndpoint){showError(`Expected to find ${expectNumEndpoints} interface descriptors `+`but only encountered ${indexEndpoint}.`,this.rootElement_)}if(expectNumDevCapabilities!==indexDevCapability){showError(`Expected to find ${expectNumDevCapabilities} `+`device capability descriptors but only encountered ${indexDevCapability}.`,this.rootElement_)}addMappingAction(rawDataTreeRoot,rawDataByteElement)}async getDeviceDescriptor(){const usbControlTransferParams={type:UsbControlTransferType.STANDARD,recipient:UsbControlTransferRecipient.DEVICE,request:GET_DESCRIPTOR_REQUEST,value:DEVICE_DESCRIPTOR_TYPE<<8,index:0};try{await this.usbDeviceProxy_.open();const response=await this.usbDeviceProxy_.controlTransferIn(usbControlTransferParams,DEVICE_DESCRIPTOR_LENGTH,CONTROL_TRANSFER_TIMEOUT_MS);checkTransferSuccess(response.status,"Failed to read the device descriptor.",this.rootElement_);this.renderStandardDescriptor_(new Uint8Array(response.data.buffer))}catch(e){showError(e.message,this.rootElement_)}finally{await this.usbDeviceProxy_.close()}}renderDeviceDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,offset){const fields=[{label:`Length (should be ${DEVICE_DESCRIPTOR_LENGTH}): `,size:1,formatter:formatByte},{label:"Descriptor Type (should be 0x01): ",size:1,formatter:formatDescriptorType},{label:"USB Version: ",size:2,formatter:formatUsbVersion},{label:"Class Code: ",size:1,formatter:formatClassCode},{label:"Subclass Code: ",size:1,formatter:formatByte},{label:"Protocol Code: ",size:1,formatter:formatByte},{label:"Control Pipe Maximum Packet Size: ",size:1,formatter:formatByte},{label:"Vendor ID: ",size:2,formatter:formatTwoBytesToHex},{label:"Product ID: ",size:2,formatter:formatTwoBytesToHex},{label:"Device Version: ",size:2,formatter:formatUsbVersion},{label:"Manufacturer String Index: ",size:1,formatter:formatByte,extraTreeItemFormatter:this.renderIndexItem_.bind(this)},{label:"Product String Index: ",size:1,formatter:formatByte,extraTreeItemFormatter:this.renderIndexItem_.bind(this)},{label:"Serial Number Index: ",size:1,formatter:formatByte,extraTreeItemFormatter:this.renderIndexItem_.bind(this)},{label:"Number of Configurations: ",size:1,formatter:formatByte}];renderRawDataTree(rawDataTreeRoot,rawDataByteElement,fields,rawData,offset,this.rootElement_);document.body.dispatchEvent(new CustomEvent("device-descriptor-complete-for-test",{bubbles:true,composed:true}))}async getConfigurationDescriptor(){const usbControlTransferParams={type:UsbControlTransferType.STANDARD,recipient:UsbControlTransferRecipient.DEVICE,request:GET_DESCRIPTOR_REQUEST,value:CONFIGURATION_DESCRIPTOR_TYPE<<8,index:0};try{await this.usbDeviceProxy_.open();let response=await this.usbDeviceProxy_.controlTransferIn(usbControlTransferParams,CONFIGURATION_DESCRIPTOR_LENGTH,CONTROL_TRANSFER_TIMEOUT_MS);checkTransferSuccess(response.status,"Failed to read the device configuration descriptor to determine "+"the total descriptor length.",this.rootElement_);const dataView=new DataView(new Uint8Array(response.data.buffer).buffer);const length=dataView.getUint16(CONFIGURATION_DESCRIPTOR_TOTAL_LENGTH_OFFSET,true);response=await this.usbDeviceProxy_.controlTransferIn(usbControlTransferParams,length,CONTROL_TRANSFER_TIMEOUT_MS);checkTransferSuccess(response.status,"Failed to read the complete configuration descriptor.",this.rootElement_);this.renderStandardDescriptor_(new Uint8Array(response.data.buffer))}catch(e){showError(e.message,this.rootElement_)}finally{await this.usbDeviceProxy_.close()}}renderConfigurationDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,offset){const fields=[{label:`Length (should be ${CONFIGURATION_DESCRIPTOR_LENGTH}): `,size:1,formatter:formatByte},{label:"Descriptor Type (should be 0x02): ",size:1,formatter:formatDescriptorType},{label:"Total Length: ",size:2,formatter:formatShort},{label:"Number of Interfaces: ",size:1,formatter:formatByte},{label:"Configuration Value: ",size:1,formatter:formatByte},{label:"Configuration String Index: ",size:1,formatter:formatByte,extraTreeItemFormatter:this.renderIndexItem_.bind(this)},{label:"Attribute Bitmap: ",size:1,formatter:formatBitmap},{label:"Max Power (2mA increments): ",size:1,formatter:formatByte}];renderRawDataTree(rawDataTreeRoot,rawDataByteElement,fields,rawData,offset,this.rootElement_)}renderInterfaceDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,offset,indexInterface){const parentClassName=`descriptor-interface-${indexInterface}`;const interfaceItem=customTreeItem(`Interface ${indexInterface}`,parentClassName);rawDataTreeRoot.add(interfaceItem);const fields=[{label:`Length (should be ${INTERFACE_DESCRIPTOR_LENGTH}): `,size:1,formatter:formatByte},{label:"Descriptor Type (should be 0x04): ",size:1,formatter:formatDescriptorType},{label:"Interface Number: ",size:1,formatter:formatByte},{label:"Alternate String: ",size:1,formatter:formatByte},{label:"Number of Endpoint: ",size:1,formatter:formatByte},{label:"Interface Class Code: ",size:1,formatter:formatByte},{label:"Interface Subclass Code: ",size:1,formatter:formatByte},{label:"Interface Protocol Code: ",size:1,formatter:formatByte},{label:"Interface String Index: ",size:1,formatter:formatByte,extraTreeItemFormatter:this.renderIndexItem_.bind(this)}];renderRawDataTree(interfaceItem,rawDataByteElement,fields,rawData,offset,this.rootElement_,parentClassName);return interfaceItem}renderEndpointDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,offset,indexEndpoint){const parentClassName=`descriptor-endpoint-${indexEndpoint}`;const endpointItem=customTreeItem(`Endpoint ${indexEndpoint}`,parentClassName);rawDataTreeRoot.add(endpointItem);const fields=[{label:`Length (should be ${ENDPOINT_DESCRIPTOR_LENGTH}): `,size:1,formatter:formatByte},{label:"Descriptor Type (should be 0x05): ",size:1,formatter:formatDescriptorType},{label:"EndPoint Address: ",size:1,formatter:formatByte},{label:"Attribute Bitmap: ",size:1,formatter:formatBitmap},{label:"Max Packet Size: ",size:2,formatter:formatShort},{label:"Interval: ",size:1,formatter:formatByte}];renderRawDataTree(endpointItem,rawDataByteElement,fields,rawData,offset,this.rootElement_,parentClassName)}renderUnknownDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,originalOffset,indexUnknown){const length=rawData[originalOffset+STANDARD_DESCRIPTOR_LENGTH_OFFSET];const parentClassName=`descriptor-unknown-${indexUnknown}`;const unknownItem=customTreeItem(`Unknown Descriptor ${indexUnknown}`,parentClassName);rawDataTreeRoot.add(unknownItem);const fields=[{label:"Length: ",size:1,formatter:formatByte},{label:"Descriptor Type: ",size:1,formatter:formatDescriptorType}];let offset=renderRawDataTree(unknownItem,rawDataByteElement,fields,rawData,originalOffset,this.rootElement_,parentClassName);const rawDataByteElements=rawDataByteElement.querySelectorAll("span");for(;offset<originalOffset+length;offset++){rawDataByteElements[offset].classList.add(`field-offset-${offset}`);rawDataByteElements[offset].classList.add(parentClassName)}}async getAllLanguageCodes(){const usbControlTransferParams={type:UsbControlTransferType.STANDARD,recipient:UsbControlTransferRecipient.DEVICE,request:GET_DESCRIPTOR_REQUEST,value:STRING_DESCRIPTOR_TYPE<<8,index:0};let response;try{await this.usbDeviceProxy_.open();response=await this.usbDeviceProxy_.controlTransferIn(usbControlTransferParams,MAX_STRING_DESCRIPTOR_LENGTH,CONTROL_TRANSFER_TIMEOUT_MS);checkTransferSuccess(response.status,"Failed to read the device string descriptor to determine "+"all supported languages.",this.rootElement_)}catch(e){showError(e.message,this.rootElement_);return[]}finally{await this.usbDeviceProxy_.close()}const responseData=new Uint8Array(response.data.buffer);assert(this.languageCodesListElement_);this.languageCodesListElement_.innerText="";const optionAllElement=document.createElement("option");optionAllElement.value="All";this.languageCodesListElement_.appendChild(optionAllElement);const languageCodesList=[];for(let i=2;i<responseData.length;i+=2){const languageCode=parseShort(responseData,i);const optionElement=document.createElement("option");optionElement.label=parseLanguageCode(languageCode);optionElement.value=`0x${toHex(languageCode,4)}`;this.languageCodesListElement_.appendChild(optionElement);languageCodesList.push(languageCode)}return languageCodesList}async getStringDescriptorForLanguageCode_(index,languageCode,treeItem){const usbControlTransferParams={type:UsbControlTransferType.STANDARD,recipient:UsbControlTransferRecipient.DEVICE,request:GET_DESCRIPTOR_REQUEST,index:languageCode,value:STRING_DESCRIPTOR_TYPE<<8|index};try{await this.usbDeviceProxy_.open();const response=await this.usbDeviceProxy_.controlTransferIn(usbControlTransferParams,MAX_STRING_DESCRIPTOR_LENGTH,CONTROL_TRANSFER_TIMEOUT_MS);checkTransferSuccess(response.status,`Failed to read the device string descriptor of index: ${index}, language: ${parseLanguageCode(languageCode)}.`,this.rootElement_);assert(this.indexInput_);this.indexInput_.value=index.toString();this.renderStandardDescriptor_(new Uint8Array(response.data.buffer),languageCode,treeItem)}catch(e){showError(e.message,this.rootElement_)}finally{await this.usbDeviceProxy_.close()}}renderStringDescriptorForLanguageCode_(rawDataTreeRoot,rawDataByteElement,rawData,offset,languageCode=0,treeItem){this.rootElement_.hidden=false;const languageStr=parseLanguageCode(languageCode);const fields=[{label:"Length: ",size:1,formatter:formatByte},{label:"Descriptor Type (should be 0x03): ",size:1,formatter:formatDescriptorType}];for(let i=2;i<rawData.length;i+=2){const field={label:"",size:2,formatter:formatLetter};fields.push(field)}const stringDescriptor=decodeUtf16Array(rawData.slice(2),true);const parentClassName=`descriptor-string-language-${languageStr}`;const stringDescriptorItem=customTreeItem(`${languageStr}: ${stringDescriptor}`,parentClassName);rawDataTreeRoot.add(stringDescriptorItem);if(treeItem){treeItem.add(customTreeItem(`${languageStr}: ${stringDescriptor}`));treeItem.toggleAttribute("expanded",true)}renderRawDataTree(stringDescriptorItem,rawDataByteElement,fields,rawData,offset,this.rootElement_,parentClassName)}async getStringDescriptorForAllLanguages_(index,treeItem){this.rootElement_.hidden=false;assert(this.indexInput_);this.indexInput_.value=index.toString();const languageCodesList=await this.getAllLanguageCodes();assert(treeItem);for(const languageCode of languageCodesList){await this.getStringDescriptorForLanguageCode_(index,languageCode,treeItem)}}initialStringDescriptorPanel(tabId){this.rootElement_.querySelectorAll("input").forEach((el=>el.setAttribute("list",`${el.getAttribute("list")}-${tabId}`)));this.rootElement_.querySelectorAll("datalist").forEach((el=>el.id=`${el.id}-${tabId}`));const button=this.rootElement_.querySelector("button");assert(button);const indexInput=this.rootElement_.querySelector("#index-input");this.indexInput_=indexInput;const languageCodeInput=this.rootElement_.querySelector("#language-code-input");assert(languageCodeInput);button.addEventListener("click",(async()=>{this.clearView();assert(this.indexInput_);const index=Number.parseInt(this.indexInput_.value,10);if(this.checkParamValid_(index,"Index",1,255)){if(languageCodeInput.value==="All"){await this.getStringDescriptorForAllLanguages_(index)}else{const languageCode=Number.parseInt(languageCodeInput.value,10);if(this.checkParamValid_(languageCode,"Language Code",0,65535)){await this.getStringDescriptorForLanguageCode_(index,languageCode)}}}}));this.stringDescriptorIndexes=new Set;this.indexesListElement=this.rootElement_.querySelector(`#indexes-${tabId}`);assert(this.indexesListElement);this.languageCodesListElement_=this.rootElement_.querySelector(`#languages-${tabId}`);assert(this.languageCodesListElement_)}async getBosDescriptor(){const usbControlTransferParams={type:UsbControlTransferType.STANDARD,recipient:UsbControlTransferRecipient.DEVICE,request:GET_DESCRIPTOR_REQUEST,value:BOS_DESCRIPTOR_TYPE<<8,index:0};try{await this.usbDeviceProxy_.open();let response=await this.usbDeviceProxy_.controlTransferIn(usbControlTransferParams,BOS_DESCRIPTOR_HEADER_LENGTH,CONTROL_TRANSFER_TIMEOUT_MS);checkTransferSuccess(response.status,"Failed to read the device BOS descriptor to determine "+"the total descriptor length.",this.rootElement_);const dataView=new DataView(new Uint8Array(response.data.buffer).buffer);const length=dataView.getUint16(BOS_DESCRIPTOR_TOTAL_LENGTH_OFFSET,true);response=await this.usbDeviceProxy_.controlTransferIn(usbControlTransferParams,length,CONTROL_TRANSFER_TIMEOUT_MS);checkTransferSuccess(response.status,"Failed to read the complete BOS descriptor.",this.rootElement_);await this.renderStandardDescriptor_(new Uint8Array(response.data.buffer))}catch(e){showError(e.message,this.rootElement_)}finally{await this.usbDeviceProxy_.close()}}renderBosDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,offset){const fields=[{label:"Length (should be 5): ",size:1,formatter:formatByte},{label:"Descriptor Type (should be 0x0F): ",size:1,formatter:formatDescriptorType},{label:"Total Length: ",size:2,formatter:formatShort},{label:"Number of Device Capability Descriptors: ",size:1,formatter:formatByte}];renderRawDataTree(rawDataTreeRoot,rawDataByteElement,fields,rawData,offset,this.rootElement_)}renderDeviceCapabilityDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,offset,indexDevCapability){switch(rawData[offset+BOS_DESCRIPTOR_DEVICE_CAPABILITY_TYPE_OFFSET]){case DEVICE_CAPABILITY_DESCRIPTOR_TYPE_PLATFORM_TYPE:if(isSameUuid(rawData,offset,WEB_USB_CAPABILITY_UUID)){this.renderWebUsbPlatformDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,offset,indexDevCapability);break}else if(isSameUuid(rawData,offset,MS_OS_20_PLATFORM_CAPABILITY_UUID)){this.renderMsOs20PlatformDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,offset,indexDevCapability);break}else{this.renderUnknownBosDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,offset,indexDevCapability);break}default:this.renderUnknownBosDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,offset,indexDevCapability)}}renderWebUsbPlatformDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,offset,indexWebUsb){const parentClassName=`descriptor-webusb-${indexWebUsb}`;const webUsbItem=customTreeItem("WebUSB Descriptor",parentClassName);rawDataTreeRoot.add(webUsbItem);const fields=[{label:"Length (should be 24): ",size:1,formatter:formatByte},{label:"Descriptor Type (should be 0x10): ",size:1,formatter:formatDescriptorType},{label:"Device Capability Descriptor Type (should be 0x05): ",size:1,formatter:formatDescriptorType},{label:"Reserved (should be 0): ",size:1,formatter:formatByte},{label:"Platform Capability UUID: ",size:16,formatter:formatUuid},{label:"Protocol Version Supported (should be 1.0.0): ",size:2,formatter:formatUsbVersion},{label:"Vendor Code: ",size:1,formatter:formatByte},{label:"Landing Page: ",size:1,formatter:formatByte,extraTreeItemFormatter:this.renderUrlDescriptorIndexItem_.bind(this)}];renderRawDataTree(webUsbItem,rawDataByteElement,fields,rawData,offset,this.rootElement_,parentClassName)}renderMsOs20PlatformDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,offset,indexMsOs20){const parentClassName=`descriptor-ms-os-20-${indexMsOs20}`;const msOs20Item=customTreeItem(`Microsoft OS 2.0 Descriptor`,parentClassName);rawDataTreeRoot.add(msOs20Item);const fields=[{label:"Length: ",size:1,formatter:formatByte},{label:"Descriptor Type (should be 0x10): ",size:1,formatter:formatDescriptorType},{label:"Device Capability Descriptor Type (should be 0x05): ",size:1,formatter:formatDescriptorType},{label:"Reserved (should be 0): ",size:1,formatter:formatByte},{label:"Platform Capability UUID: ",size:16,formatter:formatUuid}];offset=renderRawDataTree(msOs20Item,rawDataByteElement,fields,rawData,offset,this.rootElement_,parentClassName);let indexMsOs20DescriptorSetInfo=0;while(offset<rawData.length){offset=this.renderMsOs20DescriptorSetInfo_(msOs20Item,rawDataByteElement,rawData,offset,indexMsOs20DescriptorSetInfo,indexMsOs20);indexMsOs20DescriptorSetInfo++}}renderMsOs20DescriptorSetInfo_(rawDataTreeRoot,rawDataByteElement,rawData,offset,indexMsOs20DescriptorSetInfo,indexMsOs20){const parentClassName=`descriptor-ms-os-20-set-info-${indexMsOs20DescriptorSetInfo}`;const msOs20SetInfoItem=customTreeItem(`Microsoft OS 2.0 Descriptor Set Information`,parentClassName);rawDataTreeRoot.add(msOs20SetInfoItem);const fields=[{label:"Windows Version: ",size:4,formatter:formatWindowsVersion},{label:"Total Length: ",size:2,formatter:formatShort},{label:"Vendor Code: ",size:1,formatter:formatByte,extraTreeItemFormatter:(rawData,offset,item,_fieldLabel)=>this.renderMsOs20DescriptorVendorSpecific_(rawData,offset-MS_OS_20_VENDOR_CODE_ITEM_OFFSET,item)},{label:"Alternate Enumeration Code: ",size:1,formatter:formatByte,extraTreeItemFormatter:(rawData,offset,item,_fieldLabel)=>this.renderMsOs20DescriptorSetAltEnum_(rawData,offset-MS_OS_20_ALT_ENUM_CODE_ITEM_OFFSET,item)}];return renderRawDataTree(msOs20SetInfoItem,rawDataByteElement,fields,rawData,offset,this.rootElement_,parentClassName,`descriptor-ms-os-20-${indexMsOs20}`)}renderUnknownBosDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,originalOffset,indexUnknownDevCapability){const length=rawData[originalOffset+STANDARD_DESCRIPTOR_LENGTH_OFFSET];const parentClassName=`descriptor-unknownbos-${indexUnknownDevCapability}`;const unknownBosItem=customTreeItem(`Unknown BOS Descriptor`,parentClassName);rawDataTreeRoot.add(unknownBosItem);const fields=[{label:"Length: ",size:1,formatter:formatByte},{label:"Descriptor Type: ",size:1,formatter:formatDescriptorType},{label:"Device Capability Descriptor Type: ",size:1,formatter:formatByte}];let offset=renderRawDataTree(unknownBosItem,rawDataByteElement,fields,rawData,originalOffset,this.rootElement_,parentClassName);const rawDataByteElements=rawDataByteElement.querySelectorAll("span");for(;offset<originalOffset+length;offset++){rawDataByteElements[offset].classList.add(`field-offset-${offset}`);rawDataByteElements[offset].classList.add(parentClassName)}}async getUrlDescriptor_(rawData,offset,item){const vendorCode=rawData[offset+WEB_USB_VENDOR_CODE_OFFSET];const urlIndex=rawData[offset+WEB_USB_URL_DESCRIPTOR_INDEX_OFFSET];const usbControlTransferParams={recipient:UsbControlTransferRecipient.DEVICE,type:UsbControlTransferType.VENDOR,request:vendorCode,value:urlIndex,index:GET_URL_REQUEST};try{await this.usbDeviceProxy_.open();const urlResponse=await this.usbDeviceProxy_.controlTransferIn(usbControlTransferParams,MAX_URL_DESCRIPTOR_LENGTH,CONTROL_TRANSFER_TIMEOUT_MS);checkTransferSuccess(urlResponse.status,"Failed to read the device URL descriptor.",this.rootElement_);let url="";switch(urlResponse.data.buffer[2]){case 0:url="http://";break;case 1:url="https://";break;case 255:default:url=""}url+=decodeUtf8Array(new Uint8Array(urlResponse.data.buffer.slice(3)));const landingPageItem=customTreeItem(url,"descriptor-url");landingPageItem.labelElement.addEventListener("click",(()=>window.open(url,"_blank")));item.add(landingPageItem);item.expanded=true}catch(e){showError(e.message,this.rootElement_)}finally{await this.usbDeviceProxy_.close()}}async getMsOs20DescriptorSet_(vendorCode,msOs20DescriptorSetLength){const usbControlTransferParams={recipient:UsbControlTransferRecipient.DEVICE,type:UsbControlTransferType.VENDOR,request:vendorCode,value:0,index:MS_OS_20_DESCRIPTOR_INDEX};let response;try{await this.usbDeviceProxy_.open();response=await this.usbDeviceProxy_.controlTransferIn(usbControlTransferParams,msOs20DescriptorSetLength,CONTROL_TRANSFER_TIMEOUT_MS);checkTransferSuccess(response.status,"Failed to read the Microsoft OS 2.0 descriptor set.",this.rootElement_)}catch(e){showError(e.message,this.rootElement_);return new Uint8Array(0)}finally{await this.usbDeviceProxy_.close()}return new Uint8Array(response.data.buffer)}async sendMsOs20DescriptorSetAltEnumCommand_(vendorCode,altEnumCode){const usbControlTransferParams={recipient:UsbControlTransferRecipient.DEVICE,type:UsbControlTransferType.VENDOR,request:vendorCode,value:altEnumCode,index:MS_OS_20_SET_ALT_ENUMERATION};try{await this.usbDeviceProxy_.open();const response=await this.usbDeviceProxy_.controlTransferOut(usbControlTransferParams,{buffer:[]},CONTROL_TRANSFER_TIMEOUT_MS);checkTransferSuccess(response.status,"Failed to read the Microsoft OS 2.0 descriptor "+"alternate enumeration set.",this.rootElement_)}catch(e){showError(e.message,this.rootElement_)}finally{await this.usbDeviceProxy_.close()}}renderMsOs20DescriptorSet_(msOs20RawData){const displayElement=addNewDescriptorDisplayElement(this.rootElement_,"Microsoft OS 2.0 Descriptor Set");const rawDataTreeRoot=displayElement.rawDataTreeRoot;const rawDataByteElement=displayElement.rawDataByteElement;renderRawDataBytes(rawDataByteElement,msOs20RawData);let msOs20DescriptorOffset=0;let indexMsOs20Descriptor=0;const data=new DataView(msOs20RawData.buffer);while(msOs20DescriptorOffset+MS_OS_20_DESCRIPTOR_TYPE_OFFSET+1<msOs20RawData.length){const msOs20DescriptorType=data.getUint16(msOs20DescriptorOffset+MS_OS_20_DESCRIPTOR_TYPE_OFFSET,true);switch(msOs20DescriptorType){case MS_OS_20_SET_HEADER_DESCRIPTOR:msOs20DescriptorOffset=this.renderMsOs20SetHeader_(rawDataTreeRoot,rawDataByteElement,msOs20RawData,msOs20DescriptorOffset);break;case MS_OS_20_SUBSET_HEADER_CONFIGURATION:msOs20DescriptorOffset=this.renderMsOs20ConfigurationSubsetHeader_(rawDataTreeRoot,rawDataByteElement,msOs20RawData,msOs20DescriptorOffset,indexMsOs20Descriptor);indexMsOs20Descriptor++;break;case MS_OS_20_SUBSET_HEADER_FUNCTION:msOs20DescriptorOffset=this.renderMsOs20FunctionSubsetHeader_(rawDataTreeRoot,rawDataByteElement,msOs20RawData,msOs20DescriptorOffset,indexMsOs20Descriptor);indexMsOs20Descriptor++;break;case MS_OS_20_FEATURE_COMPATIBLE_ID:msOs20DescriptorOffset=this.renderMsOs20FeatureCompatibleId_(rawDataTreeRoot,rawDataByteElement,msOs20RawData,msOs20DescriptorOffset,indexMsOs20Descriptor);indexMsOs20Descriptor++;break;case MS_OS_20_FEATURE_REG_PROPERTY:msOs20DescriptorOffset=this.renderMsOs20FeatureRegistryProperty_(rawDataTreeRoot,rawDataByteElement,msOs20RawData,msOs20DescriptorOffset,indexMsOs20Descriptor);indexMsOs20Descriptor++;break;case MS_OS_20_FEATURE_MIN_RESUME_TIME:msOs20DescriptorOffset=this.renderMsOs20FeatureMinResumeTime_(rawDataTreeRoot,rawDataByteElement,msOs20RawData,msOs20DescriptorOffset,indexMsOs20Descriptor);indexMsOs20Descriptor++;break;case MS_OS_20_FEATURE_MODEL_ID:msOs20DescriptorOffset=this.renderMsOs20FeatureModelId_(rawDataTreeRoot,rawDataByteElement,msOs20RawData,msOs20DescriptorOffset,indexMsOs20Descriptor);indexMsOs20Descriptor++;break;case MS_OS_20_FEATURE_CCGP_DEVICE:msOs20DescriptorOffset=this.renderMsOs20FeatureCcgpDevice_(rawDataTreeRoot,rawDataByteElement,msOs20RawData,msOs20DescriptorOffset,indexMsOs20Descriptor);indexMsOs20Descriptor++;break;case MS_OS_20_FEATURE_VENDOR_REVISION:msOs20DescriptorOffset=this.renderMsOs20FeatureVendorRevision_(rawDataTreeRoot,rawDataByteElement,msOs20RawData,msOs20DescriptorOffset,indexMsOs20Descriptor);indexMsOs20Descriptor++;break;default:msOs20DescriptorOffset=this.renderUnknownMsOs20DescriptorDescriptor_(rawDataTreeRoot,rawDataByteElement,msOs20RawData,msOs20DescriptorOffset,indexMsOs20Descriptor);indexMsOs20Descriptor++}}addMappingAction(rawDataTreeRoot,rawDataByteElement)}renderMsOs20SetHeader_(rawDataTreeRoot,rawDataByteElement,rawData,originalOffset){const data=new DataView(rawData.buffer);const length=data.getUint16(originalOffset+MS_OS_20_DESCRIPTOR_LENGTH_OFFSET,true);const fields=[{label:"Length (should be 10): ",size:2,formatter:formatShort},{label:"MS OS 2.0 Descriptor Type (should be 0): ",size:2,formatter:formatShort},{label:"Windows Version: ",size:4,formatter:formatWindowsVersion},{label:"Total Length: ",size:2,formatter:formatShort}];const offset=renderRawDataTree(rawDataTreeRoot,rawDataByteElement,fields,rawData,originalOffset,this.rootElement_);if(offset!==originalOffset+length){showError("An error occurred while rendering Microsoft OS 2.0 Descriptor "+"Set header.",this.rootElement_)}return offset}renderMsOs20ConfigurationSubsetHeader_(rawDataTreeRoot,rawDataByteElement,rawData,originalOffset,indexMsOs20Descriptor){const parentClassName=`descriptor-ms-os-20-subdescriptor-${indexMsOs20Descriptor}`;const item=customTreeItem("Microsoft OS 2.0 Configuration Subset Header",parentClassName);rawDataTreeRoot.add(item);const data=new DataView(rawData.buffer);const length=data.getUint16(originalOffset+MS_OS_20_DESCRIPTOR_LENGTH_OFFSET,true);const fields=[{label:"Length (should be 8): ",size:2,formatter:formatShort},{label:"MS OS 2.0 Descriptor Type (should be 1): ",size:2,formatter:formatShort},{label:"Configuration Value: ",size:1,formatter:formatByte},{label:"Reserved (should be 0): ",size:1,formatter:formatByte},{label:"Total Length: ",size:2,formatter:formatShort}];const offset=renderRawDataTree(item,rawDataByteElement,fields,rawData,originalOffset,this.rootElement_,parentClassName);if(offset!==originalOffset+length){showError("An error occurred while rendering Microsoft OS 2.0 "+"Configuration Subset Header.",this.rootElement_)}return offset}renderMsOs20FunctionSubsetHeader_(rawDataTreeRoot,rawDataByteElement,rawData,originalOffset,indexMsOs20Descriptor){const parentClassName=`descriptor-ms-os-20-subdescriptor-${indexMsOs20Descriptor}`;const item=customTreeItem("Microsoft OS 2.0 Function Subset Header",parentClassName);rawDataTreeRoot.add(item);const data=new DataView(rawData.buffer);const length=data.getUint16(originalOffset+MS_OS_20_DESCRIPTOR_LENGTH_OFFSET,true);const fields=[{label:"Length (should be 8): ",size:2,formatter:formatShort},{label:"MS OS 2.0 Descriptor Type (should be 2): ",size:2,formatter:formatShort},{label:"First Interface Number: ",size:1,formatter:formatByte},{label:"Reserved (should be 0): ",size:1,formatter:formatByte},{label:"Total Length: ",size:2,formatter:formatShort}];const offset=renderRawDataTree(item,rawDataByteElement,fields,rawData,originalOffset,this.rootElement_,parentClassName);if(offset!==originalOffset+length){showError("An error occurred while rendering Microsoft OS 2.0 "+"Function Subset Header.",this.rootElement_)}return offset}renderMsOs20FeatureCompatibleId_(rawDataTreeRoot,rawDataByteElement,rawData,originalOffset,indexMsOs20Descriptor){const parentClassName=`descriptor-ms-os-20-subdescriptor-${indexMsOs20Descriptor}`;const item=customTreeItem("Microsoft OS 2.0 Compatible ID Descriptor",parentClassName);rawDataTreeRoot.add(item);const data=new DataView(rawData.buffer);const length=data.getUint16(originalOffset+MS_OS_20_DESCRIPTOR_LENGTH_OFFSET,true);const fields=[{label:"Length (should be 20): ",size:2,formatter:formatShort},{label:"MS OS 2.0 Descriptor Type (should be 3): ",size:2,formatter:formatShort},{label:"Compatible ID String: ",size:8,formatter:formatCompatibleIdString},{label:"Sub-compatible ID String: ",size:8,formatter:formatCompatibleIdString}];const offset=renderRawDataTree(item,rawDataByteElement,fields,rawData,originalOffset,this.rootElement_,parentClassName);if(offset!==originalOffset+length){showError("An error occurred while rendering Microsoft OS 2.0 "+"Compatible ID Descriptor.",this.rootElement_)}return offset}renderMsOs20FeatureRegistryProperty_(rawDataTreeRoot,rawDataByteElement,rawData,originalOffset,indexMsOs20Descriptor){const parentClassName=`descriptor-ms-os-20-subdescriptor-${indexMsOs20Descriptor}`;const item=customTreeItem("Microsoft OS 2.0 Registry Property Descriptor",parentClassName);rawDataTreeRoot.add(item);const data=new DataView(rawData.buffer);const length=data.getUint16(originalOffset+MS_OS_20_DESCRIPTOR_LENGTH_OFFSET,true);const featureRegistryPropertyDataType=data.getUint16(originalOffset+MS_OS_20_REGISTRY_PROPERTY_DESCRIPTOR_PROPERTY_DATA_TYPE_OFFSET,true);const propertyNameLength=data.getUint16(originalOffset+MS_OS_20_REGISTRY_PROPERTY_DESCRIPTOR_NAME_LENGTH_OFFSET,true);const fields=[{label:"Length: ",size:2,formatter:formatShort},{label:"MS OS 2.0 Descriptor Type (should be 4): ",size:2,formatter:formatShort},{label:"Property Data Type: ",size:2,formatter:formatFeatureRegistryPropertyDataType},{label:"Property Name Length: ",size:2,formatter:formatShort},{label:"Property Name: ",size:propertyNameLength,formatter:formatUnknown,extraTreeItemFormatter:(rawData,offset,item,fieldLabel)=>this.renderFeatureRegistryPropertyDataItem_(rawData,offset,item,fieldLabel,featureRegistryPropertyDataType,propertyNameLength)}];let offset=renderRawDataTree(item,rawDataByteElement,fields,rawData,originalOffset,this.rootElement_,parentClassName);while(offset<originalOffset+length){const propertyDataLength=data.getUint16(offset,true);const propertyDataFields=[{label:"Property Data Length: ",size:2,formatter:formatShort},{label:"Property Data: ",size:propertyDataLength,formatter:formatUnknown,extraTreeItemFormatter:(rawData,offset,item,fieldLabel)=>this.renderFeatureRegistryPropertyDataItem_(rawData,offset,item,fieldLabel,featureRegistryPropertyDataType,propertyDataLength)}];offset=renderRawDataTree(item,rawDataByteElement,propertyDataFields,rawData,offset,this.rootElement_,parentClassName)}if(offset!==originalOffset+length){showError("An error occurred while rendering Microsoft OS 2.0 "+"Registry Property Descriptor.",this.rootElement_)}return offset}renderMsOs20FeatureMinResumeTime_(rawDataTreeRoot,rawDataByteElement,rawData,originalOffset,indexMsOs20Descriptor){const parentClassName=`descriptor-ms-os-20-subdescriptor-${indexMsOs20Descriptor}`;const item=customTreeItem("Microsoft OS 2.0 Minimum USB Resume Time Descriptor",parentClassName);rawDataTreeRoot.add(item);const data=new DataView(rawData.buffer);const length=data.getUint16(originalOffset+MS_OS_20_DESCRIPTOR_LENGTH_OFFSET,true);const fields=[{label:"Length (should be 6): ",size:2,formatter:formatShort},{label:"MS OS 2.0 Descriptor Type (should be 5): ",size:2,formatter:formatShort},{label:"Resume Recovery Time (milliseconds): ",size:1,formatter:formatByte},{label:"Resume Signaling Time (milliseconds): ",size:1,formatter:formatByte}];const offset=renderRawDataTree(item,rawDataByteElement,fields,rawData,originalOffset,this.rootElement_,parentClassName);if(offset!==originalOffset+length){showError("An error occurred while rendering Microsoft OS 2.0 "+"Minimum USB Resume Time Descriptor.",this.rootElement_)}return offset}renderMsOs20FeatureModelId_(rawDataTreeRoot,rawDataByteElement,rawData,originalOffset,indexMsOs20Descriptor){const parentClassName=`descriptor-ms-os-20-subdescriptor-${indexMsOs20Descriptor}`;const item=customTreeItem("Microsoft OS 2.0 Model ID Descriptor",parentClassName);rawDataTreeRoot.add(item);const data=new DataView(rawData.buffer);const length=data.getUint16(originalOffset+MS_OS_20_DESCRIPTOR_LENGTH_OFFSET,true);const fields=[{label:"Length (should be 20): ",size:2,formatter:formatShort},{label:"MS OS 2.0 Descriptor Type (should be 6): ",size:2,formatter:formatShort},{label:"Model ID: ",size:16,formatter:formatUuid}];const offset=renderRawDataTree(item,rawDataByteElement,fields,rawData,originalOffset,this.rootElement_,parentClassName);if(offset!==originalOffset+length){showError("An error occurred while rendering Microsoft OS 2.0 "+"Model ID Descriptor.",this.rootElement_)}return offset}renderMsOs20FeatureCcgpDevice_(rawDataTreeRoot,rawDataByteElement,rawData,originalOffset,indexMsOs20Descriptor){const parentClassName=`descriptor-ms-os-20-subdescriptor-${indexMsOs20Descriptor}`;const item=customTreeItem("Microsoft OS 2.0 Common Class Generic Parent (CCGP) Device "+"Descriptor",parentClassName);rawDataTreeRoot.add(item);const data=new DataView(rawData.buffer);const length=data.getUint16(originalOffset+MS_OS_20_DESCRIPTOR_LENGTH_OFFSET,true);const fields=[{label:"Length (should be 4): ",size:2,formatter:formatShort},{label:"MS OS 2.0 Descriptor Type (should be 7): ",size:2,formatter:formatShort}];const offset=renderRawDataTree(item,rawDataByteElement,fields,rawData,originalOffset,this.rootElement_,parentClassName);if(offset!==originalOffset+length){showError("An error occurred while rendering Microsoft OS 2.0 "+"CCGP Device Descriptor.",this.rootElement_)}return offset}renderMsOs20FeatureVendorRevision_(rawDataTreeRoot,rawDataByteElement,rawData,originalOffset,indexMsOs20Descriptor){const parentClassName=`descriptor-ms-os-20-subdescriptor-${indexMsOs20Descriptor}`;const item=customTreeItem("Microsoft OS 2.0 Vendor Revision Descriptor",parentClassName);rawDataTreeRoot.add(item);const data=new DataView(rawData.buffer);const length=data.getUint16(originalOffset+MS_OS_20_DESCRIPTOR_LENGTH_OFFSET,true);const fields=[{label:"Length (should be 6): ",size:2,formatter:formatShort},{label:"MS OS 2.0 Descriptor Type (should be 8): ",size:2,formatter:formatShort},{label:"Vendor Revision: ",size:2,formatter:formatShort}];const offset=renderRawDataTree(item,rawDataByteElement,fields,rawData,originalOffset,this.rootElement_,parentClassName);if(offset!==originalOffset+length){showError("An error occurred while rendering Microsoft OS 2.0 "+"Vendor Revision Descriptor.",this.rootElement_)}return offset}renderUnknownMsOs20DescriptorDescriptor_(rawDataTreeRoot,rawDataByteElement,rawData,originalOffset,indexDescriptor){const parentClassName=`descriptor-ms-os-20-subdescriptor-${indexDescriptor}`;const item=customTreeItem("Microsoft OS 2.0 Descriptor Unknown Descriptor",parentClassName);rawDataTreeRoot.add(item);const data=new DataView(rawData.buffer);const length=data.getUint16(originalOffset+MS_OS_20_DESCRIPTOR_LENGTH_OFFSET,true);const fields=[{label:"Length: ",size:2,formatter:formatShort},{label:"MS OS 2.0 Descriptor Type: ",size:2,formatter:formatShort}];let offset=renderRawDataTree(item,rawDataByteElement,fields,rawData,originalOffset,this.rootElement_,parentClassName);const rawDataByteElements=rawDataByteElement.querySelectorAll("span");for(;offset<originalOffset+length;offset++){rawDataByteElements[offset].classList.add(`field-offset-${offset}`,parentClassName)}if(offset!==originalOffset+length){showError("An error occurred while rendering Microsoft OS 2.0 "+"Unknown Descriptor.",this.rootElement_)}return offset}async sendTestingRequest_(usbControlTransferParams,length,direction){try{await this.usbDeviceProxy_.open();if(direction==="Device-to-Host"){const response=await this.usbDeviceProxy_.controlTransferIn(usbControlTransferParams,length,CONTROL_TRANSFER_TIMEOUT_MS);checkTransferSuccess(response.status,"Failed to send request.",this.rootElement_);this.renderTestingData_(new Uint8Array(response.data.buffer))}else if(direction==="Host-to-Device"){const textarea=this.rootElement_.querySelector("textarea");assert(textarea);const dataString=textarea.value;const data=[];for(let i=0;i<dataString.length;i+=2){data.push(Number.parseInt(dataString.substring(i,i+2),16))}const response=await this.usbDeviceProxy_.controlTransferOut(usbControlTransferParams,{buffer:data},CONTROL_TRANSFER_TIMEOUT_MS);checkTransferSuccess(response.status,"Failed to send request.",this.rootElement_)}}catch(e){showError(e.message,this.rootElement_);return}finally{await this.usbDeviceProxy_.close()}}renderTestingData_(rawData){const displayElement=addNewDescriptorDisplayElement(this.rootElement_);const rawDataTreeRoot=displayElement.rawDataTreeRoot;rawDataTreeRoot.style.display="none";const rawDataByteElement=displayElement.rawDataByteElement;renderRawDataBytes(rawDataByteElement,rawData)}initialTestingToolPanel(){showWarn("Warning: This tool can send arbitrary commands to the device. "+"Invalid commands may cause unexpected results.",this.rootElement_);const tbody=this.rootElement_.querySelector("tbody");assert(tbody);const inputTableRows=tbody.querySelectorAll("tr");const buttons=tbody.querySelectorAll("button");const dataInputArea=this.rootElement_.querySelector("textarea");assert(dataInputArea);dataInputArea.addEventListener("keypress",(()=>{const index=dataInputArea.selectionStart;dataInputArea.value=dataInputArea.value.substring(0,index)+dataInputArea.value.substring(index+1);dataInputArea.selectionEnd=index}));const testingToolPanelInputTypeSelector=this.rootElement_.querySelector("#input-type");assert(testingToolPanelInputTypeSelector);testingToolPanelInputTypeSelector.addEventListener("change",(()=>{this.clearView();const index=testingToolPanelInputTypeSelector.selectedIndex;inputTableRows.forEach((row=>row.hidden=true));const rowAtIndex=inputTableRows[index];assert(rowAtIndex);rowAtIndex.hidden=false;const direction=getRequestTypeDirection(rowAtIndex,index);const length=getRequestLength(rowAtIndex,index);const area=this.rootElement_.querySelector("#data-input-area");assert(area);area.hidden=direction!=="Host-to-Device";dataInputArea.value="00".repeat(length);dataInputArea.maxLength=length*2}));inputTableRows.forEach(((el,i)=>{const inputTableRow=el;let directionInputElement=null;switch(i){case INPUT_TYPE_DECIMAL_WITH_DROPDOWN:directionInputElement=inputTableRow.querySelector("#transfer-direction");break;case INPUT_TYPE_HEX_BYTE:directionInputElement=inputTableRow.querySelector("#query-request-type");break}assert(directionInputElement);directionInputElement.addEventListener("change",(()=>{const area=this.rootElement_.querySelector("#data-input-area");assert(area);area.hidden=getRequestTypeDirection(inputTableRow,i)!=="Host-to-Device"}));inputTableRow.querySelector("#query-length").addEventListener("blur",(()=>{const length=getRequestLength(inputTableRow,i);dataInputArea.value="00".repeat(length);dataInputArea.maxLength=length*2}))}));buttons.forEach(((button,i)=>{button.addEventListener("click",(()=>{this.clearView();const row=inputTableRows[i];assert(row);const direction=getRequestTypeDirection(row,i);const type=getRequestType(row,i);const recipient=getRequestTypeRecipient(row,i);const request=getRequestCode(row,i);const value=getRequestValue(row,i);const index=getRequestIndex(row,i);const dataLength=getRequestLength(row,i);const transferType=this.convertStringToTransferType_(type);const transferRecipient=this.convertStringToTransferRecipient_(recipient);if(transferType!==null&&transferRecipient!==null&&this.checkParamValid_(request,"Transfer Request",0,255)&&this.checkParamValid_(value,"wValue",0,65535)&&this.checkParamValid_(index,"wIndex",0,65535)&&this.checkParamValid_(dataLength,"Length",0,65535)){const usbControlTransferParams={type:transferType,recipient:transferRecipient,request:request,value:value,index:index};this.sendTestingRequest_(usbControlTransferParams,dataLength,direction)}}))}))}checkParamValid_(paramValue,paramName,min,max){if(Number.isNaN(paramValue)||paramValue<min||paramValue>max){showError(`Invalid ${paramName}.`,this.rootElement_);return false}return true}convertStringToTransferType_(enumString){if(enumString==="STANDARD"){return UsbControlTransferType.STANDARD}if(enumString==="CLASS"){return UsbControlTransferType.CLASS}if(enumString==="VENDOR"){return UsbControlTransferType.VENDOR}if(enumString==="RESERVED"){return UsbControlTransferType.RESERVED}showError("Invalid Transfer Type",this.rootElement_);return null}convertStringToTransferRecipient_(enumString){if(enumString==="DEVICE"){return UsbControlTransferRecipient.DEVICE}if(enumString==="INTERFACE"){return UsbControlTransferRecipient.INTERFACE}if(enumString==="ENDPOINT"){return UsbControlTransferRecipient.ENDPOINT}if(enumString==="OTHER"){return UsbControlTransferRecipient.OTHER}showError("Invalid Transfer Recipient",this.rootElement_);return null}}function getRequestType(inputRow,inputType){switch(inputType){case INPUT_TYPE_DECIMAL_WITH_DROPDOWN:const select=inputRow.querySelector("#transfer-type");assert(select);return select.value;case INPUT_TYPE_HEX_BYTE:const input=inputRow.querySelector("#query-request-type");assert(input);const value=Number.parseInt(input.value,16);switch(value>>5&3){case 0:return"STANDARD";case 1:return"CLASS";case 2:return"VENDOR"}return"";default:return""}}function getRequestTypeRecipient(inputRow,inputType){switch(inputType){case INPUT_TYPE_DECIMAL_WITH_DROPDOWN:const select=inputRow.querySelector("#transfer-recipient");assert(select);return select.value;case INPUT_TYPE_HEX_BYTE:const input=inputRow.querySelector("#query-request-type");assert(input);const value=Number.parseInt(input.value,16);switch(value&31){case 0:return"DEVICE";case 1:return"INTERFACE";case 2:return"ENDPOINT";case 3:return"OTHER"}return"";default:return""}}function getRequestTypeDirection(inputRow,inputType){switch(inputType){case INPUT_TYPE_DECIMAL_WITH_DROPDOWN:const select=inputRow.querySelector("#transfer-direction");assert(select);return select.value;case INPUT_TYPE_HEX_BYTE:const input=inputRow.querySelector("#query-request-type");assert(input);const value=Number.parseInt(input.value,16);switch(value>>7){case CONTROL_TRANSFER_DIRECTION_HOST_TO_DEVICE:return"Host-to-Device";case CONTROL_TRANSFER_DIRECTION_DEVICE_TO_HOST:return"Device-to-Host"}return"Device-to-Host";default:return"Device-to-Host"}}function getDecimalOrHex(inputRow,inputType,selector){const input=inputRow.querySelector(selector);switch(inputType){case INPUT_TYPE_DECIMAL_WITH_DROPDOWN:assert(input);return Number.parseInt(input.value,10);case INPUT_TYPE_HEX_BYTE:assert(input);return Number.parseInt(input.value,16);default:return Number.NaN}}function getRequestCode(inputRow,inputType){return getDecimalOrHex(inputRow,inputType,"#query-request")}function getRequestValue(inputRow,inputType){return getDecimalOrHex(inputRow,inputType,"#query-value")}function getRequestIndex(inputRow,inputType){return getDecimalOrHex(inputRow,inputType,"#query-index")}function getRequestLength(inputRow,inputType){return getDecimalOrHex(inputRow,inputType,"#query-length")}function addNewDescriptorDisplayElement(rootElement,descriptorPanelTitle){const descriptorPanelTemplate=rootElement.getRootNode().querySelector("#descriptor-panel-template");assert(descriptorPanelTemplate);const descriptorPanelClone=document.importNode(descriptorPanelTemplate.content,true);const rawDataTreeRoot=descriptorPanelClone.querySelector(".raw-data-tree-view");assert(rawDataTreeRoot);const rawDataByteElement=descriptorPanelClone.querySelector(".raw-data-byte-view");assert(rawDataByteElement);rawDataTreeRoot.detail={payload:{},children:{}};if(descriptorPanelTitle){const descriptorPanelTitleTemplate=rootElement.getRootNode().querySelector("#descriptor-panel-title");assert(descriptorPanelTitleTemplate);const clone=document.importNode(descriptorPanelTitleTemplate.content,true).querySelector("descriptorpaneltitle");assert(clone);clone.textContent=descriptorPanelTitle;rootElement.appendChild(clone)}rootElement.appendChild(descriptorPanelClone);return{rawDataTreeRoot:rawDataTreeRoot,rawDataByteElement:rawDataByteElement}}function showError(message,rootElement){const errorElement=document.createElement("error");errorElement.textContent=message;rootElement.prepend(errorElement)}function showWarn(message,rootElement){const warnElement=document.createElement("warn");warnElement.textContent=message;rootElement.prepend(warnElement)}function customTreeItem(itemLabel,className){const item=document.createElement("cr-tree-item");item.label=itemLabel;if(className){item.classList.add(className)}return item}function addMappingAction(rawDataTreeRoot,rawDataByteElement){function mapElement(el){const classList=el.classList;const fieldOffsetOrDescriptorClass=classList[0];assert(fieldOffsetOrDescriptorClass.startsWith("field-offset-")||fieldOffsetOrDescriptorClass.startsWith("descriptor-"));el.rowElement.addEventListener("pointerenter",(event=>{rawDataByteElement.querySelectorAll(`.${fieldOffsetOrDescriptorClass}`).forEach((el=>el.classList.add("hovered-field")));event.stopPropagation()}));el.rowElement.addEventListener("pointerleave",(()=>{rawDataByteElement.querySelectorAll(`.${fieldOffsetOrDescriptorClass}`).forEach((el=>el.classList.remove("hovered-field")))}));el.rowElement.addEventListener("click",(event=>{if(event.target.className!=="expand-icon"){rawDataByteElement.querySelectorAll(".raw-data-byte-view span").forEach((el=>el.classList.remove("selected-field")));rawDataByteElement.querySelectorAll(`.${fieldOffsetOrDescriptorClass}`).forEach((el=>el.classList.add("selected-field")))}}));el.items.forEach((item=>mapElement(item)))}rawDataTreeRoot.items.forEach((item=>mapElement(item)));const rawDataByteElements=rawDataByteElement.querySelectorAll("span");rawDataByteElements.forEach((el=>{const classList=el.classList;if(!classList[0]){return}const fieldOffsetClass=classList[0];assert(fieldOffsetClass.startsWith("field-offset-"));function configureMatchingItem(className,callback,root){if(root.tagName==="CR-TREE-ITEM"&&root.classList.contains(className)){callback(root);return true}for(const item of root.items){if(configureMatchingItem(className,callback,item)){return true}}return false}el.addEventListener("pointerenter",(()=>{rawDataByteElement.querySelectorAll(`.${fieldOffsetClass}`).forEach((el=>el.classList.add("hovered-field")));configureMatchingItem(fieldOffsetClass,(el=>el.forceHoverStyle(true)),rawDataTreeRoot)}));el.addEventListener("pointerleave",(()=>{rawDataByteElement.querySelectorAll(`.${fieldOffsetClass}`).forEach((el=>el.classList.remove("hovered-field")));configureMatchingItem(fieldOffsetClass,(el=>el.forceHoverStyle(false)),rawDataTreeRoot)}));el.addEventListener("click",(()=>{configureMatchingItem(fieldOffsetClass,(el=>el.rowElement.click()),rawDataTreeRoot)}))}))}function renderRawDataTree(root,rawDataByteElement,fields,rawData,offset,rootElement,...parentClassNames){const rawDataByteElements=rawDataByteElement.querySelectorAll("span");for(const field of fields){const className=`field-offset-${offset}`;let item;try{item=customTreeItem(`${field.label}${field.formatter(rawData,offset)}`,className);for(let i=0;i<field.size;i++){rawDataByteElements[offset+i].classList.add(className);for(const parentClassName of parentClassNames){rawDataByteElements[offset+i].classList.add(parentClassName)}}}catch(e){showError(`Field at offset ${offset} is invalid.`,rootElement);break}root.add(item);try{if(field.extraTreeItemFormatter){field.extraTreeItemFormatter(rawData,offset,item,field.label)}}catch(e){const message=e.message;showError(`Error at rendering field at index ${offset}: ${message}`,rootElement)}offset+=field.size}return offset}function renderRawDataBytes(rawDataByteElement,rawData){const rawDataByteContainerTemplate=rawDataByteElement.getRootNode().querySelector("#raw-data-byte-container-template");assert(rawDataByteContainerTemplate);const rawDataByteContainerClone=document.importNode(rawDataByteContainerTemplate.content,true);const rawDataByteContainerElement=rawDataByteContainerClone.querySelector("div");assert(rawDataByteContainerElement);const rawDataByteTemplate=rawDataByteElement.getRootNode().querySelector("#raw-data-byte-template");assert(rawDataByteTemplate);for(const value of rawData){const rawDataByteClone=document.importNode(rawDataByteTemplate.content,true);const rawDataByteSpan=rawDataByteClone.querySelector("span");assert(rawDataByteSpan);rawDataByteSpan.textContent=toHex(value,2);rawDataByteContainerElement.appendChild(rawDataByteSpan)}rawDataByteElement.appendChild(rawDataByteContainerElement)}function checkTransferSuccess(status,defaultMessage,rootElement){let failReason="";switch(status){case UsbTransferStatus.COMPLETED:return;case UsbTransferStatus.SHORT_PACKET:showError("Descriptor is too short.",rootElement);return;case UsbTransferStatus.BABBLE:showError("Descriptor is too long.",rootElement);return;case UsbTransferStatus.TRANSFER_ERROR:failReason="Transfer Error";break;case UsbTransferStatus.TIMEOUT:failReason="Timeout";break;case UsbTransferStatus.CANCELLED:failReason="Transfer was cancelled";break;case UsbTransferStatus.STALLED:failReason="Transfer Error";break;case UsbTransferStatus.DISCONNECT:failReason="Transfer stalled";break;case UsbTransferStatus.PERMISSION_DENIED:failReason="Permission denied";break}throw new Error(`${defaultMessage} (Reason: ${failReason})`)}function toHex(number,numOfDigits){return number.toString(16).padStart(numOfDigits,"0").toUpperCase()}function decodeUtf16Array(arr,isLittleEndian=false){let str="";const data=new DataView(arr.buffer);for(let i=0;i<arr.length;i+=2){str+=String.fromCodePoint(data.getUint16(i,isLittleEndian))}return str}function decodeUtf8Array(arr){return String.fromCodePoint(...arr)}function formatByte(rawData,offset){return rawData[offset].toString()}function parseShort(rawData,offset){const data=new DataView(rawData.buffer);return data.getUint16(offset,true)}function formatShort(rawData,offset){return parseShort(rawData,offset).toString()}function formatLetter(rawData,offset){const num=parseShort(rawData,offset);return String.fromCodePoint(num)}function formatTwoBytesToHex(rawData,offset){const num=parseShort(rawData,offset);return`0x${toHex(num,4)}`}function formatUsbVersion(rawData,offset){return`${rawData[offset+1]}.${rawData[offset]>>4}.${rawData[offset]&15}`}function formatBitmap(rawData,offset){return rawData[offset].toString(2).padStart(8,"0")}function formatDescriptorType(rawData,offset){return`0x${toHex(rawData[offset],2)}`}function formatUuid(rawData,offset){let uuidStr="";const data=new DataView(rawData.buffer);uuidStr+=toHex(data.getUint32(offset,true),8);uuidStr+="-";uuidStr+=toHex(data.getUint16(offset+4,true),4);uuidStr+="-";uuidStr+=toHex(data.getUint16(offset+6,true),4);uuidStr+="-";uuidStr+=toHex(data.getUint8(offset+8),2);uuidStr+=toHex(data.getUint8(offset+9),2);uuidStr+="-";uuidStr+=toHex(data.getUint8(offset+10),2);uuidStr+=toHex(data.getUint8(offset+11),2);uuidStr+=toHex(data.getUint8(offset+12),2);uuidStr+=toHex(data.getUint8(offset+13),2);uuidStr+=toHex(data.getUint8(offset+14),2);uuidStr+=toHex(data.getUint8(offset+15),2);return uuidStr}function formatCompatibleIdString(rawData,offset){return decodeUtf8Array(rawData.slice(offset,offset+8))}function formatWindowsVersion(rawData,offset){const data=new DataView(rawData.buffer);const windowsVersion=data.getUint32(offset,true);switch(windowsVersion){case WIN_81_HEADER:return"Windows 8.1";default:return`0x${toHex(windowsVersion,8)}`}}function formatFeatureRegistryPropertyDataType(rawData,offset){const data=new DataView(rawData.buffer);const propertyDataType=data.getUint16(offset,true);switch(propertyDataType){case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_SZ:return"A NULL-terminated Unicode String (REG_SZ)";case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_EXPAND_SZ:return"A NULL-terminated Unicode String that includes environment "+"variables (REG_EXPAND_SZ)";case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_BINARY:return"Free-form binary (REG_BINARY)";case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_DWORD_LITTLE_ENDIAN:return"A little-endian 32-bit integer (REG_DWORD_LITTLE_ENDIAN)";case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_DWORD_BIG_ENDIAN:return"A big-endian 32-bit integer (REG_DWORD_BIG_ENDIAN)";case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_LINK:return"A NULL-terminated Unicode string that contains a symbolic "+"link (REG_LINK)";case MS_OS_20_FEATURE_REG_PROPERTY_DATA_TYPE_REG_MULTI_SZ:return"Multiple NULL-terminated Unicode strings (REG_MULTI_SZ)";default:return"Reserved"}}function formatUnknown(_rawData,_offset){return""}function formatClassCode(rawData,offset){return renderClassCodeWithDescription(rawData[offset])}export function renderClassCodeWithDescription(classCode){const blockedByWebUsb="(blocked by WebUSB)";switch(classCode){case 0:return`${classCode} (Device)`;case 1:return`${classCode} (Audio) ${blockedByWebUsb}`;case 2:return`${classCode} (Communications and CDC Control)`;case 3:return`${classCode} (HID) ${blockedByWebUsb}`;case 5:return`${classCode} (Physical)`;case 6:return`${classCode} (Still Imaging)`;case 7:return`${classCode} (Printer)`;case 8:return`${classCode} (Mass Storage) ${blockedByWebUsb}`;case 9:return`${classCode} (Hub)`;case 10:return`${classCode} (CDC-Data)`;case 11:return`${classCode} (Smart Card) ${blockedByWebUsb}`;case 13:return`${classCode} (Content Security)`;case 14:return`${classCode} (Video) ${blockedByWebUsb}`;case 15:return`${classCode} (Personal Healthcare)`;case 16:return`${classCode} (Audio/Video Devices) ${blockedByWebUsb}`;case 17:return`${classCode} (Billboard Device)`;case 18:return`${classCode} (USB Type-C Bridge Device)`;case 220:return`${classCode} (Diagnostic Device)`;case 224:return`${classCode} (Wireless Controller) ${blockedByWebUsb}`;case 239:return`${classCode} (Miscellaneous)`;case 254:return`${classCode} (Application Specific)`;case 255:return`${classCode} (Vendor Specific)`}return`${classCode}`}function parseLanguageCode(languageCode){switch(languageCode){case LANGUAGE_CODE_EN_US:return"en-US";default:return`0x${toHex(languageCode,4)}`}}function isSameUuid(rawData,offset,uuidArr){if(offset+20>rawData.length){return false}for(const[i,num]of rawData.slice(offset+4,offset+20).entries()){if(num!==uuidArr[i]){return false}}return true}