// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";import{CrLitElement,html}from"//resources/lit/v3_0/lit.rollup.js";import{GuestHandlerRemote}from"./browser.mojom-webui.js";import{BrowserProxy}from"./browser_proxy.js";import{getCss}from"./webview.css.js";export class WebviewElement extends CrLitElement{static get is(){return"cr-webview"}static get styles(){return getCss()}render(){return html`<iframe id="iframe"></iframe>`}static get properties(){return{guestId:{type:Number}}}#guestId_accessor_storage=-1;get guestId(){return this.#guestId_accessor_storage}set guestId(value){this.#guestId_accessor_storage=value}attached=false;async connectedCallback(){super.connectedCallback();await this.tryToAttach()}async tryToAttach(){if(this.attached||this.guestId===-1){return}this.attached=true;if(!this.$.iframe.contentWindow){await this.whenIframeContentWindowAvailable_(this.$.iframe)}this.attachGuestToIframe(this.guestId,this.$.iframe)}attachGuestToIframe(guestId,iframe){const iframeContentWindow=iframe.contentWindow;assert(iframeContentWindow);chrome.browser.attachIframeGuest(guestId,iframeContentWindow)}async whenIframeContentWindowAvailable_(iframe){return new Promise((resolve=>{const intervalId=setInterval((()=>{if(!iframe.contentWindow){return}clearInterval(intervalId);resolve()}),100)}))}}export class TabWebviewElement extends WebviewElement{static get is(){return"cr-tab-webview"}tabId;guestHandler=new GuestHandlerRemote;constructor(tabId){super();this.tabId=tabId;this.attachTabContents()}setActive(active){if(active){this.classList.add("active");this.$.iframe.focus()}else{this.classList.remove("active")}}openPageInfoMenu(){this.guestHandler.openPageInfoMenu()}async getSecurityIcon(){const{securityIcon:securityIcon}=await this.guestHandler.getSecurityIcon();return securityIcon}attachTabContents(){BrowserProxy.getPageHandler().getGuestIdForTabId(this.tabId,this.guestHandler.$.bindNewPipeAndPassReceiver()).then((({guestId:guestId})=>{this.guestId=guestId;this.tryToAttach()}))}goBack(){this.guestHandler.goBack()}goForward(){this.guestHandler.goForward()}reload(){this.guestHandler.reload()}stopLoading(){this.guestHandler.stopLoading()}async canGoBack(){const{canGoBack:canGoBack}=await this.guestHandler.canGoBack();return canGoBack}async canGoForward(){const{canGoForward:canGoForward}=await this.guestHandler.canGoForward();return canGoForward}}customElements.define(WebviewElement.is,WebviewElement);customElements.define(TabWebviewElement.is,TabWebviewElement);