// chrome/browser/ui/webui/ash/lobster/lobster.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('url.mojom.Url');




goog.provide('lobster.mojom.StatusCode');
goog.provide('lobster.mojom.StatusCodeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
lobster.mojom.StatusCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
lobster.mojom.StatusCode = {
  
  kUnknown: 0,
  kOk: 1,
  kBlockedOutputs: 2,
  kNoInternetConnection: 3,
  kResourceExhausted: 4,
  kInvalidArgument: 5,
  kBackendFailure: 6,
  kUnsupportedLanguage: 7,
  kRestrictedRegion: 8,
  kContainsPeople: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};

goog.provide('lobster.mojom.WebUIMetricEvent');
goog.provide('lobster.mojom.WebUIMetricEventSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
lobster.mojom.WebUIMetricEventSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
lobster.mojom.WebUIMetricEvent = {
  
  kUnknown: 0,
  kQueryPageImpression: 1,
  kRequestInitialCandidates: 2,
  kRequestInitialCandidatesSuccess: 3,
  kRequestInitialCandidatesError: 4,
  kInitialCandidatesImpression: 5,
  kRequestMoreCandidates: 6,
  kRequestMoreCandidatesSuccess: 7,
  kRequestMoreCandidatesError: 8,
  kMoreCandidatesAppended: 9,
  kFeedbackThumbsUp: 10,
  kFeedbackThumbsDown: 11,
  MIN_VALUE: 0,
  MAX_VALUE: 11,
};



goog.provide('lobster.mojom.UntrustedLobsterPageHandler');
goog.provide('lobster.mojom.UntrustedLobsterPageHandlerReceiver');
goog.provide('lobster.mojom.UntrustedLobsterPageHandlerCallbackRouter');
goog.provide('lobster.mojom.UntrustedLobsterPageHandlerInterface');
goog.provide('lobster.mojom.UntrustedLobsterPageHandlerRemote');
goog.provide('lobster.mojom.UntrustedLobsterPageHandlerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandlerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        lobster.mojom.UntrustedLobsterPageHandler.$interfaceName,
        scope);
  }
};

/** @interface */
lobster.mojom.UntrustedLobsterPageHandlerInterface = class {
  
  /**
   * @param { !string } query
   * @param { !number } numCandidates
   * @return {!Promise<{
        response: !lobster.mojom.Response,
   *  }>}
   */

  requestCandidates(query, numCandidates) {}
  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  downloadCandidate(candidateId) {}
  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  commitAsInsert(candidateId) {}
  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  commitAsDownload(candidateId) {}
  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        preview: !lobster.mojom.FeedbackPreview,
   *  }>}
   */

  previewFeedback(candidateId) {}
  
  /**
   * @param { !number } candidateId
   * @param { !string } description
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  submitFeedback(candidateId, description) {}
  
  /**
   */

  showUI() {}
  
  /**
   */

  closeUI() {}
  
  /**
   * @param { !lobster.mojom.WebUIMetricEvent } metricEvent
   */

  emitMetricEvent(metricEvent) {}
  
  /**
   * @param { !url.mojom.Url } url
   */

  openUrlInNewWindow(url) {}
};

/**
 * @export
 * @implements { lobster.mojom.UntrustedLobsterPageHandlerInterface }
 */
lobster.mojom.UntrustedLobsterPageHandlerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!lobster.mojom.UntrustedLobsterPageHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          lobster.mojom.UntrustedLobsterPageHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!lobster.mojom.UntrustedLobsterPageHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } query
   * @param { !number } numCandidates
   * @return {!Promise<{
        response: !lobster.mojom.Response,
   *  }>}
   */

  requestCandidates(
      query,
      numCandidates) {
    return this.proxy.sendMessage(
        0,
        lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ResponseParamsSpec.$,
        [
          query,
          numCandidates
        ],
        false);
  }

  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  downloadCandidate(
      candidateId) {
    return this.proxy.sendMessage(
        1,
        lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ResponseParamsSpec.$,
        [
          candidateId
        ],
        false);
  }

  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  commitAsInsert(
      candidateId) {
    return this.proxy.sendMessage(
        2,
        lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ResponseParamsSpec.$,
        [
          candidateId
        ],
        false);
  }

  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  commitAsDownload(
      candidateId) {
    return this.proxy.sendMessage(
        3,
        lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ResponseParamsSpec.$,
        [
          candidateId
        ],
        false);
  }

  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        preview: !lobster.mojom.FeedbackPreview,
   *  }>}
   */

  previewFeedback(
      candidateId) {
    return this.proxy.sendMessage(
        4,
        lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ResponseParamsSpec.$,
        [
          candidateId
        ],
        false);
  }

  
  /**
   * @param { !number } candidateId
   * @param { !string } description
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  submitFeedback(
      candidateId,
      description) {
    return this.proxy.sendMessage(
        5,
        lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ResponseParamsSpec.$,
        [
          candidateId,
          description
        ],
        false);
  }

  
  /**
   */

  showUI() {
    this.proxy.sendMessage(
        6,
        lobster.mojom.UntrustedLobsterPageHandler_ShowUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  closeUI() {
    this.proxy.sendMessage(
        7,
        lobster.mojom.UntrustedLobsterPageHandler_CloseUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !lobster.mojom.WebUIMetricEvent } metricEvent
   */

  emitMetricEvent(
      metricEvent) {
    this.proxy.sendMessage(
        8,
        lobster.mojom.UntrustedLobsterPageHandler_EmitMetricEvent_ParamsSpec.$,
        null,
        [
          metricEvent
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   */

  openUrlInNewWindow(
      url) {
    this.proxy.sendMessage(
        9,
        lobster.mojom.UntrustedLobsterPageHandler_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UntrustedLobsterPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandlerReceiver = class {
  /**
   * @param {!lobster.mojom.UntrustedLobsterPageHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!lobster.mojom.UntrustedLobsterPageHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        lobster.mojom.UntrustedLobsterPageHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!lobster.mojom.UntrustedLobsterPageHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ResponseParamsSpec.$,
        impl.requestCandidates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ResponseParamsSpec.$,
        impl.downloadCandidate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ResponseParamsSpec.$,
        impl.commitAsInsert.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ResponseParamsSpec.$,
        impl.commitAsDownload.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ResponseParamsSpec.$,
        impl.previewFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ResponseParamsSpec.$,
        impl.submitFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        lobster.mojom.UntrustedLobsterPageHandler_ShowUI_ParamsSpec.$,
        null,
        impl.showUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        lobster.mojom.UntrustedLobsterPageHandler_CloseUI_ParamsSpec.$,
        null,
        impl.closeUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        lobster.mojom.UntrustedLobsterPageHandler_EmitMetricEvent_ParamsSpec.$,
        null,
        impl.emitMetricEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        lobster.mojom.UntrustedLobsterPageHandler_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        impl.openUrlInNewWindow.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
lobster.mojom.UntrustedLobsterPageHandler = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "lobster.mojom.UntrustedLobsterPageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!lobster.mojom.UntrustedLobsterPageHandlerRemote}
   * @export
   */
  static getRemote() {
    let remote = new lobster.mojom.UntrustedLobsterPageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the UntrustedLobsterPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandlerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      lobster.mojom.UntrustedLobsterPageHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!lobster.mojom.UntrustedLobsterPageHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestCandidates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ResponseParamsSpec.$,
        this.requestCandidates.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.downloadCandidate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ResponseParamsSpec.$,
        this.downloadCandidate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.commitAsInsert =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ResponseParamsSpec.$,
        this.commitAsInsert.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.commitAsDownload =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ResponseParamsSpec.$,
        this.commitAsDownload.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.previewFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ResponseParamsSpec.$,
        this.previewFeedback.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submitFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ParamsSpec.$,
        lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ResponseParamsSpec.$,
        this.submitFeedback.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        lobster.mojom.UntrustedLobsterPageHandler_ShowUI_ParamsSpec.$,
        null,
        this.showUI.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        lobster.mojom.UntrustedLobsterPageHandler_CloseUI_ParamsSpec.$,
        null,
        this.closeUI.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.emitMetricEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        lobster.mojom.UntrustedLobsterPageHandler_EmitMetricEvent_ParamsSpec.$,
        null,
        this.emitMetricEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openUrlInNewWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        lobster.mojom.UntrustedLobsterPageHandler_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        this.openUrlInNewWindow.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('lobster.mojom.CandidateSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.CandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.ErrorSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.ErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.FeedbackPreviewSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.FeedbackPreviewSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_ShowUI_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_ShowUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_CloseUI_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_CloseUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_EmitMetricEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_EmitMetricEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.UntrustedLobsterPageHandler_OpenUrlInNewWindow_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
lobster.mojom.UntrustedLobsterPageHandler_OpenUrlInNewWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('lobster.mojom.ResponseSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
lobster.mojom.ResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    lobster.mojom.CandidateSpec.$,
    'Candidate',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dataUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('lobster.mojom.Candidate');

/** @record */
lobster.mojom.Candidate = class {
  constructor() {
    /** @export { !number } */
    this.id;
    /** @export { !url.mojom.Url } */
    this.dataUrl;
  }
};



mojo.internal.Struct(
    lobster.mojom.ErrorSpec.$,
    'Error',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        lobster.mojom.StatusCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('lobster.mojom.Error');

/** @record */
lobster.mojom.Error = class {
  constructor() {
    /** @export { !lobster.mojom.StatusCode } */
    this.code;
    /** @export { !string } */
    this.message;
  }
};



mojo.internal.Struct(
    lobster.mojom.FeedbackPreviewSpec.$,
    'FeedbackPreview',
    [
      mojo.internal.StructField(
        'fields', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'previewDataUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('lobster.mojom.FeedbackPreview');

/** @record */
lobster.mojom.FeedbackPreview = class {
  constructor() {
    /** @export { !Object<!string, !string> } */
    this.fields;
    /** @export { !url.mojom.Url } */
    this.previewDataUrl;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ParamsSpec.$,
    'UntrustedLobsterPageHandler_RequestCandidates_Params',
    [
      mojo.internal.StructField(
        'query', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numCandidates', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_Params');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_Params = class {
  constructor() {
    /** @export { !string } */
    this.query;
    /** @export { !number } */
    this.numCandidates;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ResponseParamsSpec.$,
    'UntrustedLobsterPageHandler_RequestCandidates_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        lobster.mojom.ResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ResponseParams');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_RequestCandidates_ResponseParams = class {
  constructor() {
    /** @export { !lobster.mojom.Response } */
    this.response;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ParamsSpec.$,
    'UntrustedLobsterPageHandler_DownloadCandidate_Params',
    [
      mojo.internal.StructField(
        'candidateId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_Params');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_Params = class {
  constructor() {
    /** @export { !number } */
    this.candidateId;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ResponseParamsSpec.$,
    'UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.status;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ParamsSpec.$,
    'UntrustedLobsterPageHandler_CommitAsInsert_Params',
    [
      mojo.internal.StructField(
        'candidateId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_Params');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_Params = class {
  constructor() {
    /** @export { !number } */
    this.candidateId;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ResponseParamsSpec.$,
    'UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.status;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ParamsSpec.$,
    'UntrustedLobsterPageHandler_CommitAsDownload_Params',
    [
      mojo.internal.StructField(
        'candidateId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_Params');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_Params = class {
  constructor() {
    /** @export { !number } */
    this.candidateId;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ResponseParamsSpec.$,
    'UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.status;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ParamsSpec.$,
    'UntrustedLobsterPageHandler_PreviewFeedback_Params',
    [
      mojo.internal.StructField(
        'candidateId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_Params');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_Params = class {
  constructor() {
    /** @export { !number } */
    this.candidateId;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ResponseParamsSpec.$,
    'UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams',
    [
      mojo.internal.StructField(
        'preview', 0,
        0,
        lobster.mojom.FeedbackPreviewSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams = class {
  constructor() {
    /** @export { !lobster.mojom.FeedbackPreview } */
    this.preview;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ParamsSpec.$,
    'UntrustedLobsterPageHandler_SubmitFeedback_Params',
    [
      mojo.internal.StructField(
        'candidateId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_Params');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_Params = class {
  constructor() {
    /** @export { !number } */
    this.candidateId;
    /** @export { !string } */
    this.description;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ResponseParamsSpec.$,
    'UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.status;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_ShowUI_ParamsSpec.$,
    'UntrustedLobsterPageHandler_ShowUI_Params',
    [
    ],
    [[0, 8],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_ShowUI_Params');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_ShowUI_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_CloseUI_ParamsSpec.$,
    'UntrustedLobsterPageHandler_CloseUI_Params',
    [
    ],
    [[0, 8],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_CloseUI_Params');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_CloseUI_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_EmitMetricEvent_ParamsSpec.$,
    'UntrustedLobsterPageHandler_EmitMetricEvent_Params',
    [
      mojo.internal.StructField(
        'metricEvent', 0,
        0,
        lobster.mojom.WebUIMetricEventSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_EmitMetricEvent_Params');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_EmitMetricEvent_Params = class {
  constructor() {
    /** @export { !lobster.mojom.WebUIMetricEvent } */
    this.metricEvent;
  }
};



mojo.internal.Struct(
    lobster.mojom.UntrustedLobsterPageHandler_OpenUrlInNewWindow_ParamsSpec.$,
    'UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('lobster.mojom.UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params');

/** @record */
lobster.mojom.UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};

goog.provide('lobster.mojom.Response');


mojo.internal.Union(
    lobster.mojom.ResponseSpec.$, 'Response',
    {
      'candidates': {
        'ordinal': 0,
        'type': mojo.internal.Array(lobster.mojom.CandidateSpec.$, false),
      },
      'error': {
        'ordinal': 1,
        'type': lobster.mojom.ErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   candidates: (!Array<!lobster.mojom.Candidate>|undefined),
 *   error: (!lobster.mojom.Error|undefined),
 * } }
 */
lobster.mojom.Response;
