// chrome/browser/ui/webui/ash/lobster/lobster.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chrome/browser/ui/webui/ash/lobster/lobster.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('lobster.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../../url/mojom/url.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }


  var StatusCode = {};
  StatusCode.kUnknown = 0;
  StatusCode.kOk = 1;
  StatusCode.kBlockedOutputs = 2;
  StatusCode.kNoInternetConnection = 3;
  StatusCode.kResourceExhausted = 4;
  StatusCode.kInvalidArgument = 5;
  StatusCode.kBackendFailure = 6;
  StatusCode.kUnsupportedLanguage = 7;
  StatusCode.kRestrictedRegion = 8;
  StatusCode.kContainsPeople = 9;
  StatusCode.MIN_VALUE = 0;
  StatusCode.MAX_VALUE = 9;
  StatusCode.DEFAULT_VALUE = 0;

  StatusCode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
      return true;
    }
    return false;
  };

  StatusCode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  StatusCode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WebUIMetricEvent = {};
  WebUIMetricEvent.kUnknown = 0;
  WebUIMetricEvent.kQueryPageImpression = 1;
  WebUIMetricEvent.kRequestInitialCandidates = 2;
  WebUIMetricEvent.kRequestInitialCandidatesSuccess = 3;
  WebUIMetricEvent.kRequestInitialCandidatesError = 4;
  WebUIMetricEvent.kInitialCandidatesImpression = 5;
  WebUIMetricEvent.kRequestMoreCandidates = 6;
  WebUIMetricEvent.kRequestMoreCandidatesSuccess = 7;
  WebUIMetricEvent.kRequestMoreCandidatesError = 8;
  WebUIMetricEvent.kMoreCandidatesAppended = 9;
  WebUIMetricEvent.kFeedbackThumbsUp = 10;
  WebUIMetricEvent.kFeedbackThumbsDown = 11;
  WebUIMetricEvent.MIN_VALUE = 0;
  WebUIMetricEvent.MAX_VALUE = 11;
  WebUIMetricEvent.DEFAULT_VALUE = 0;

  WebUIMetricEvent.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
      return true;
    }
    return false;
  };

  WebUIMetricEvent.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  WebUIMetricEvent.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function Candidate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Candidate.prototype.initDefaults_ = function() {
    this.id = 0;
    this.dataUrl = null;
  };
  Candidate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Candidate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Candidate.dataUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Candidate.encodedSize = codec.kStructHeaderSize + 16;

  Candidate.decode = function(decoder) {
    var packed;
    var val = new Candidate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.dataUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  Candidate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Candidate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.id);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(url$.Url, val.dataUrl);
  };
  function Error(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Error.prototype.initDefaults_ = function() {
    this.code = 0;
    this.message = null;
  };
  Error.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Error.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Error.code
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, StatusCode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Error.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Error.encodedSize = codec.kStructHeaderSize + 16;

  Error.decode = function(decoder) {
    var packed;
    var val = new Error();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(new codec.Enum(StatusCode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.message =
        decoder.decodeStruct(codec.String);
    return val;
  };

  Error.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Error.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.code);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.message);
  };
  function FeedbackPreview(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FeedbackPreview.prototype.initDefaults_ = function() {
    this.fields = null;
    this.previewDataUrl = null;
  };
  FeedbackPreview.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FeedbackPreview.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FeedbackPreview.fields
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FeedbackPreview.previewDataUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FeedbackPreview.encodedSize = codec.kStructHeaderSize + 16;

  FeedbackPreview.decode = function(decoder) {
    var packed;
    var val = new FeedbackPreview();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.fields =
        decoder.decodeMapPointer(codec.String, codec.String);
    val.previewDataUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  FeedbackPreview.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FeedbackPreview.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, codec.String, val.fields);
    encoder.encodeStructPointer(url$.Url, val.previewDataUrl);
  };
  function UntrustedLobsterPageHandler_RequestCandidates_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_RequestCandidates_Params.prototype.initDefaults_ = function() {
    this.query = null;
    this.numCandidates = 0;
  };
  UntrustedLobsterPageHandler_RequestCandidates_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_RequestCandidates_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustedLobsterPageHandler_RequestCandidates_Params.query
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_RequestCandidates_Params.encodedSize = codec.kStructHeaderSize + 16;

  UntrustedLobsterPageHandler_RequestCandidates_Params.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_RequestCandidates_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.query =
        decoder.decodeStruct(codec.String);
    val.numCandidates =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UntrustedLobsterPageHandler_RequestCandidates_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_RequestCandidates_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.query);
    encoder.encodeStruct(codec.Uint32, val.numCandidates);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UntrustedLobsterPageHandler_RequestCandidates_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_RequestCandidates_ResponseParams.prototype.initDefaults_ = function() {
    this.response = null;
  };
  UntrustedLobsterPageHandler_RequestCandidates_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_RequestCandidates_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustedLobsterPageHandler_RequestCandidates_ResponseParams.response
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, Response, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_RequestCandidates_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  UntrustedLobsterPageHandler_RequestCandidates_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_RequestCandidates_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.response =
        decoder.decodeStruct(Response);
    return val;
  };

  UntrustedLobsterPageHandler_RequestCandidates_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_RequestCandidates_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(Response, val.response);
  };
  function UntrustedLobsterPageHandler_DownloadCandidate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_DownloadCandidate_Params.prototype.initDefaults_ = function() {
    this.candidateId = 0;
  };
  UntrustedLobsterPageHandler_DownloadCandidate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_DownloadCandidate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_DownloadCandidate_Params.encodedSize = codec.kStructHeaderSize + 8;

  UntrustedLobsterPageHandler_DownloadCandidate_Params.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_DownloadCandidate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.candidateId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UntrustedLobsterPageHandler_DownloadCandidate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_DownloadCandidate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.candidateId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams.prototype.initDefaults_ = function() {
    this.status = false;
  };
  UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.status = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.status & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UntrustedLobsterPageHandler_CommitAsInsert_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_CommitAsInsert_Params.prototype.initDefaults_ = function() {
    this.candidateId = 0;
  };
  UntrustedLobsterPageHandler_CommitAsInsert_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_CommitAsInsert_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_CommitAsInsert_Params.encodedSize = codec.kStructHeaderSize + 8;

  UntrustedLobsterPageHandler_CommitAsInsert_Params.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_CommitAsInsert_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.candidateId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UntrustedLobsterPageHandler_CommitAsInsert_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_CommitAsInsert_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.candidateId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams.prototype.initDefaults_ = function() {
    this.status = false;
  };
  UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.status = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.status & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UntrustedLobsterPageHandler_CommitAsDownload_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_CommitAsDownload_Params.prototype.initDefaults_ = function() {
    this.candidateId = 0;
  };
  UntrustedLobsterPageHandler_CommitAsDownload_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_CommitAsDownload_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_CommitAsDownload_Params.encodedSize = codec.kStructHeaderSize + 8;

  UntrustedLobsterPageHandler_CommitAsDownload_Params.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_CommitAsDownload_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.candidateId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UntrustedLobsterPageHandler_CommitAsDownload_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_CommitAsDownload_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.candidateId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams.prototype.initDefaults_ = function() {
    this.status = false;
  };
  UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.status = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.status & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UntrustedLobsterPageHandler_PreviewFeedback_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_PreviewFeedback_Params.prototype.initDefaults_ = function() {
    this.candidateId = 0;
  };
  UntrustedLobsterPageHandler_PreviewFeedback_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_PreviewFeedback_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_PreviewFeedback_Params.encodedSize = codec.kStructHeaderSize + 8;

  UntrustedLobsterPageHandler_PreviewFeedback_Params.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_PreviewFeedback_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.candidateId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UntrustedLobsterPageHandler_PreviewFeedback_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_PreviewFeedback_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.candidateId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams.prototype.initDefaults_ = function() {
    this.preview = null;
  };
  UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams.preview
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, FeedbackPreview, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.preview =
        decoder.decodeStructPointer(FeedbackPreview);
    return val;
  };

  UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(FeedbackPreview, val.preview);
  };
  function UntrustedLobsterPageHandler_SubmitFeedback_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_SubmitFeedback_Params.prototype.initDefaults_ = function() {
    this.candidateId = 0;
    this.description = null;
  };
  UntrustedLobsterPageHandler_SubmitFeedback_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_SubmitFeedback_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate UntrustedLobsterPageHandler_SubmitFeedback_Params.description
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_SubmitFeedback_Params.encodedSize = codec.kStructHeaderSize + 16;

  UntrustedLobsterPageHandler_SubmitFeedback_Params.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_SubmitFeedback_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.candidateId =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.description =
        decoder.decodeStruct(codec.String);
    return val;
  };

  UntrustedLobsterPageHandler_SubmitFeedback_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_SubmitFeedback_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.candidateId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.description);
  };
  function UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams.prototype.initDefaults_ = function() {
    this.status = false;
  };
  UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.status = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.status & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UntrustedLobsterPageHandler_ShowUI_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_ShowUI_Params.prototype.initDefaults_ = function() {
  };
  UntrustedLobsterPageHandler_ShowUI_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_ShowUI_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_ShowUI_Params.encodedSize = codec.kStructHeaderSize + 0;

  UntrustedLobsterPageHandler_ShowUI_Params.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_ShowUI_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  UntrustedLobsterPageHandler_ShowUI_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_ShowUI_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function UntrustedLobsterPageHandler_CloseUI_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_CloseUI_Params.prototype.initDefaults_ = function() {
  };
  UntrustedLobsterPageHandler_CloseUI_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_CloseUI_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_CloseUI_Params.encodedSize = codec.kStructHeaderSize + 0;

  UntrustedLobsterPageHandler_CloseUI_Params.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_CloseUI_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  UntrustedLobsterPageHandler_CloseUI_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_CloseUI_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function UntrustedLobsterPageHandler_EmitMetricEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_EmitMetricEvent_Params.prototype.initDefaults_ = function() {
    this.metricEvent = 0;
  };
  UntrustedLobsterPageHandler_EmitMetricEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_EmitMetricEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustedLobsterPageHandler_EmitMetricEvent_Params.metricEvent
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, WebUIMetricEvent);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_EmitMetricEvent_Params.encodedSize = codec.kStructHeaderSize + 8;

  UntrustedLobsterPageHandler_EmitMetricEvent_Params.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_EmitMetricEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.metricEvent =
        decoder.decodeStruct(new codec.Enum(WebUIMetricEvent));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UntrustedLobsterPageHandler_EmitMetricEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_EmitMetricEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.metricEvent);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params.prototype.initDefaults_ = function() {
    this.url = null;
  };
  UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params.encodedSize = codec.kStructHeaderSize + 8;

  UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params.decode = function(decoder) {
    var packed;
    var val = new UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
  };

  function Response(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  Response.Tags = {
    candidates: 0,
    error: 1,
  };

  Response.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  Response.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "candidates",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a Response member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(Response.prototype, "candidates", {
    get: function() {
      if (this.$tag != Response.Tags.candidates) {
        throw new ReferenceError(
            "Response.candidates is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = Response.Tags.candidates;
      this.$data = value;
    }
  });
  Object.defineProperty(Response.prototype, "error", {
    get: function() {
      if (this.$tag != Response.Tags.error) {
        throw new ReferenceError(
            "Response.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = Response.Tags.error;
      this.$data = value;
    }
  });


    Response.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case Response.Tags.candidates:
          encoder.encodeArrayPointer(new codec.PointerTo(Candidate), val.candidates);
          break;
        case Response.Tags.error:
          encoder.encodeStructPointer(Error, val.error);
          break;
      }
      encoder.align();
    };


    Response.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new Response();
      var tag = decoder.readUint32();
      switch (tag) {
        case Response.Tags.candidates:
          result.candidates = decoder.decodeArrayPointer(new codec.PointerTo(Candidate));
          break;
        case Response.Tags.error:
          result.error = decoder.decodeStructPointer(Error);
          break;
      }
      decoder.align();

      return result;
    };


    Response.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case Response.Tags.candidates:
          

    // validate Response.candidates
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(Candidate), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case Response.Tags.error:
          

    // validate Response.error
    err = messageValidator.validateStructPointer(data_offset, Error, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  Response.encodedSize = 16;
  var kUntrustedLobsterPageHandler_RequestCandidates_Name = 0;
  var kUntrustedLobsterPageHandler_DownloadCandidate_Name = 1;
  var kUntrustedLobsterPageHandler_CommitAsInsert_Name = 2;
  var kUntrustedLobsterPageHandler_CommitAsDownload_Name = 3;
  var kUntrustedLobsterPageHandler_PreviewFeedback_Name = 4;
  var kUntrustedLobsterPageHandler_SubmitFeedback_Name = 5;
  var kUntrustedLobsterPageHandler_ShowUI_Name = 6;
  var kUntrustedLobsterPageHandler_CloseUI_Name = 7;
  var kUntrustedLobsterPageHandler_EmitMetricEvent_Name = 8;
  var kUntrustedLobsterPageHandler_OpenUrlInNewWindow_Name = 9;

  function UntrustedLobsterPageHandlerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(UntrustedLobsterPageHandler,
                                                   handleOrPtrInfo);
  }

  function UntrustedLobsterPageHandlerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        UntrustedLobsterPageHandler, associatedInterfacePtrInfo);
  }

  UntrustedLobsterPageHandlerAssociatedPtr.prototype =
      Object.create(UntrustedLobsterPageHandlerPtr.prototype);
  UntrustedLobsterPageHandlerAssociatedPtr.prototype.constructor =
      UntrustedLobsterPageHandlerAssociatedPtr;

  function UntrustedLobsterPageHandlerProxy(receiver) {
    this.receiver_ = receiver;
  }
  UntrustedLobsterPageHandlerPtr.prototype.requestCandidates = function() {
    return UntrustedLobsterPageHandlerProxy.prototype.requestCandidates
        .apply(this.ptr.getProxy(), arguments);
  };

  UntrustedLobsterPageHandlerProxy.prototype.requestCandidates = function(query, numCandidates) {
    var params_ = new UntrustedLobsterPageHandler_RequestCandidates_Params();
    params_.query = query;
    params_.numCandidates = numCandidates;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kUntrustedLobsterPageHandler_RequestCandidates_Name,
          codec.align(UntrustedLobsterPageHandler_RequestCandidates_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(UntrustedLobsterPageHandler_RequestCandidates_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(UntrustedLobsterPageHandler_RequestCandidates_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  UntrustedLobsterPageHandlerPtr.prototype.downloadCandidate = function() {
    return UntrustedLobsterPageHandlerProxy.prototype.downloadCandidate
        .apply(this.ptr.getProxy(), arguments);
  };

  UntrustedLobsterPageHandlerProxy.prototype.downloadCandidate = function(candidateId) {
    var params_ = new UntrustedLobsterPageHandler_DownloadCandidate_Params();
    params_.candidateId = candidateId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kUntrustedLobsterPageHandler_DownloadCandidate_Name,
          codec.align(UntrustedLobsterPageHandler_DownloadCandidate_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(UntrustedLobsterPageHandler_DownloadCandidate_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  UntrustedLobsterPageHandlerPtr.prototype.commitAsInsert = function() {
    return UntrustedLobsterPageHandlerProxy.prototype.commitAsInsert
        .apply(this.ptr.getProxy(), arguments);
  };

  UntrustedLobsterPageHandlerProxy.prototype.commitAsInsert = function(candidateId) {
    var params_ = new UntrustedLobsterPageHandler_CommitAsInsert_Params();
    params_.candidateId = candidateId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kUntrustedLobsterPageHandler_CommitAsInsert_Name,
          codec.align(UntrustedLobsterPageHandler_CommitAsInsert_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(UntrustedLobsterPageHandler_CommitAsInsert_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  UntrustedLobsterPageHandlerPtr.prototype.commitAsDownload = function() {
    return UntrustedLobsterPageHandlerProxy.prototype.commitAsDownload
        .apply(this.ptr.getProxy(), arguments);
  };

  UntrustedLobsterPageHandlerProxy.prototype.commitAsDownload = function(candidateId) {
    var params_ = new UntrustedLobsterPageHandler_CommitAsDownload_Params();
    params_.candidateId = candidateId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kUntrustedLobsterPageHandler_CommitAsDownload_Name,
          codec.align(UntrustedLobsterPageHandler_CommitAsDownload_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(UntrustedLobsterPageHandler_CommitAsDownload_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  UntrustedLobsterPageHandlerPtr.prototype.previewFeedback = function() {
    return UntrustedLobsterPageHandlerProxy.prototype.previewFeedback
        .apply(this.ptr.getProxy(), arguments);
  };

  UntrustedLobsterPageHandlerProxy.prototype.previewFeedback = function(candidateId) {
    var params_ = new UntrustedLobsterPageHandler_PreviewFeedback_Params();
    params_.candidateId = candidateId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kUntrustedLobsterPageHandler_PreviewFeedback_Name,
          codec.align(UntrustedLobsterPageHandler_PreviewFeedback_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(UntrustedLobsterPageHandler_PreviewFeedback_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  UntrustedLobsterPageHandlerPtr.prototype.submitFeedback = function() {
    return UntrustedLobsterPageHandlerProxy.prototype.submitFeedback
        .apply(this.ptr.getProxy(), arguments);
  };

  UntrustedLobsterPageHandlerProxy.prototype.submitFeedback = function(candidateId, description) {
    var params_ = new UntrustedLobsterPageHandler_SubmitFeedback_Params();
    params_.candidateId = candidateId;
    params_.description = description;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kUntrustedLobsterPageHandler_SubmitFeedback_Name,
          codec.align(UntrustedLobsterPageHandler_SubmitFeedback_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(UntrustedLobsterPageHandler_SubmitFeedback_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  UntrustedLobsterPageHandlerPtr.prototype.showUI = function() {
    return UntrustedLobsterPageHandlerProxy.prototype.showUI
        .apply(this.ptr.getProxy(), arguments);
  };

  UntrustedLobsterPageHandlerProxy.prototype.showUI = function() {
    var params_ = new UntrustedLobsterPageHandler_ShowUI_Params();
    var builder = new codec.MessageV0Builder(
        kUntrustedLobsterPageHandler_ShowUI_Name,
        codec.align(UntrustedLobsterPageHandler_ShowUI_Params.encodedSize));
    builder.encodeStruct(UntrustedLobsterPageHandler_ShowUI_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  UntrustedLobsterPageHandlerPtr.prototype.closeUI = function() {
    return UntrustedLobsterPageHandlerProxy.prototype.closeUI
        .apply(this.ptr.getProxy(), arguments);
  };

  UntrustedLobsterPageHandlerProxy.prototype.closeUI = function() {
    var params_ = new UntrustedLobsterPageHandler_CloseUI_Params();
    var builder = new codec.MessageV0Builder(
        kUntrustedLobsterPageHandler_CloseUI_Name,
        codec.align(UntrustedLobsterPageHandler_CloseUI_Params.encodedSize));
    builder.encodeStruct(UntrustedLobsterPageHandler_CloseUI_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  UntrustedLobsterPageHandlerPtr.prototype.emitMetricEvent = function() {
    return UntrustedLobsterPageHandlerProxy.prototype.emitMetricEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  UntrustedLobsterPageHandlerProxy.prototype.emitMetricEvent = function(metricEvent) {
    var params_ = new UntrustedLobsterPageHandler_EmitMetricEvent_Params();
    params_.metricEvent = metricEvent;
    var builder = new codec.MessageV0Builder(
        kUntrustedLobsterPageHandler_EmitMetricEvent_Name,
        codec.align(UntrustedLobsterPageHandler_EmitMetricEvent_Params.encodedSize));
    builder.encodeStruct(UntrustedLobsterPageHandler_EmitMetricEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  UntrustedLobsterPageHandlerPtr.prototype.openUrlInNewWindow = function() {
    return UntrustedLobsterPageHandlerProxy.prototype.openUrlInNewWindow
        .apply(this.ptr.getProxy(), arguments);
  };

  UntrustedLobsterPageHandlerProxy.prototype.openUrlInNewWindow = function(url) {
    var params_ = new UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params();
    params_.url = url;
    var builder = new codec.MessageV0Builder(
        kUntrustedLobsterPageHandler_OpenUrlInNewWindow_Name,
        codec.align(UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params.encodedSize));
    builder.encodeStruct(UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function UntrustedLobsterPageHandlerStub(delegate) {
    this.delegate_ = delegate;
  }
  UntrustedLobsterPageHandlerStub.prototype.requestCandidates = function(query, numCandidates) {
    return this.delegate_ && this.delegate_.requestCandidates && this.delegate_.requestCandidates(query, numCandidates);
  }
  UntrustedLobsterPageHandlerStub.prototype.downloadCandidate = function(candidateId) {
    return this.delegate_ && this.delegate_.downloadCandidate && this.delegate_.downloadCandidate(candidateId);
  }
  UntrustedLobsterPageHandlerStub.prototype.commitAsInsert = function(candidateId) {
    return this.delegate_ && this.delegate_.commitAsInsert && this.delegate_.commitAsInsert(candidateId);
  }
  UntrustedLobsterPageHandlerStub.prototype.commitAsDownload = function(candidateId) {
    return this.delegate_ && this.delegate_.commitAsDownload && this.delegate_.commitAsDownload(candidateId);
  }
  UntrustedLobsterPageHandlerStub.prototype.previewFeedback = function(candidateId) {
    return this.delegate_ && this.delegate_.previewFeedback && this.delegate_.previewFeedback(candidateId);
  }
  UntrustedLobsterPageHandlerStub.prototype.submitFeedback = function(candidateId, description) {
    return this.delegate_ && this.delegate_.submitFeedback && this.delegate_.submitFeedback(candidateId, description);
  }
  UntrustedLobsterPageHandlerStub.prototype.showUI = function() {
    return this.delegate_ && this.delegate_.showUI && this.delegate_.showUI();
  }
  UntrustedLobsterPageHandlerStub.prototype.closeUI = function() {
    return this.delegate_ && this.delegate_.closeUI && this.delegate_.closeUI();
  }
  UntrustedLobsterPageHandlerStub.prototype.emitMetricEvent = function(metricEvent) {
    return this.delegate_ && this.delegate_.emitMetricEvent && this.delegate_.emitMetricEvent(metricEvent);
  }
  UntrustedLobsterPageHandlerStub.prototype.openUrlInNewWindow = function(url) {
    return this.delegate_ && this.delegate_.openUrlInNewWindow && this.delegate_.openUrlInNewWindow(url);
  }

  UntrustedLobsterPageHandlerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kUntrustedLobsterPageHandler_ShowUI_Name:
      var params = reader.decodeStruct(UntrustedLobsterPageHandler_ShowUI_Params);
      this.showUI();
      return true;
    case kUntrustedLobsterPageHandler_CloseUI_Name:
      var params = reader.decodeStruct(UntrustedLobsterPageHandler_CloseUI_Params);
      this.closeUI();
      return true;
    case kUntrustedLobsterPageHandler_EmitMetricEvent_Name:
      var params = reader.decodeStruct(UntrustedLobsterPageHandler_EmitMetricEvent_Params);
      this.emitMetricEvent(params.metricEvent);
      return true;
    case kUntrustedLobsterPageHandler_OpenUrlInNewWindow_Name:
      var params = reader.decodeStruct(UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params);
      this.openUrlInNewWindow(params.url);
      return true;
    default:
      return false;
    }
  };

  UntrustedLobsterPageHandlerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kUntrustedLobsterPageHandler_RequestCandidates_Name:
      var params = reader.decodeStruct(UntrustedLobsterPageHandler_RequestCandidates_Params);
      this.requestCandidates(params.query, params.numCandidates).then(function(response) {
        var responseParams =
            new UntrustedLobsterPageHandler_RequestCandidates_ResponseParams();
        responseParams.response = response.response;
        var builder = new codec.MessageV1Builder(
            kUntrustedLobsterPageHandler_RequestCandidates_Name,
            codec.align(UntrustedLobsterPageHandler_RequestCandidates_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(UntrustedLobsterPageHandler_RequestCandidates_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kUntrustedLobsterPageHandler_DownloadCandidate_Name:
      var params = reader.decodeStruct(UntrustedLobsterPageHandler_DownloadCandidate_Params);
      this.downloadCandidate(params.candidateId).then(function(response) {
        var responseParams =
            new UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kUntrustedLobsterPageHandler_DownloadCandidate_Name,
            codec.align(UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kUntrustedLobsterPageHandler_CommitAsInsert_Name:
      var params = reader.decodeStruct(UntrustedLobsterPageHandler_CommitAsInsert_Params);
      this.commitAsInsert(params.candidateId).then(function(response) {
        var responseParams =
            new UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kUntrustedLobsterPageHandler_CommitAsInsert_Name,
            codec.align(UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kUntrustedLobsterPageHandler_CommitAsDownload_Name:
      var params = reader.decodeStruct(UntrustedLobsterPageHandler_CommitAsDownload_Params);
      this.commitAsDownload(params.candidateId).then(function(response) {
        var responseParams =
            new UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kUntrustedLobsterPageHandler_CommitAsDownload_Name,
            codec.align(UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kUntrustedLobsterPageHandler_PreviewFeedback_Name:
      var params = reader.decodeStruct(UntrustedLobsterPageHandler_PreviewFeedback_Params);
      this.previewFeedback(params.candidateId).then(function(response) {
        var responseParams =
            new UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams();
        responseParams.preview = response.preview;
        var builder = new codec.MessageV1Builder(
            kUntrustedLobsterPageHandler_PreviewFeedback_Name,
            codec.align(UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kUntrustedLobsterPageHandler_SubmitFeedback_Name:
      var params = reader.decodeStruct(UntrustedLobsterPageHandler_SubmitFeedback_Params);
      this.submitFeedback(params.candidateId, params.description).then(function(response) {
        var responseParams =
            new UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kUntrustedLobsterPageHandler_SubmitFeedback_Name,
            codec.align(UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateUntrustedLobsterPageHandlerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kUntrustedLobsterPageHandler_RequestCandidates_Name:
        if (message.expectsResponse())
          paramsClass = UntrustedLobsterPageHandler_RequestCandidates_Params;
      break;
      case kUntrustedLobsterPageHandler_DownloadCandidate_Name:
        if (message.expectsResponse())
          paramsClass = UntrustedLobsterPageHandler_DownloadCandidate_Params;
      break;
      case kUntrustedLobsterPageHandler_CommitAsInsert_Name:
        if (message.expectsResponse())
          paramsClass = UntrustedLobsterPageHandler_CommitAsInsert_Params;
      break;
      case kUntrustedLobsterPageHandler_CommitAsDownload_Name:
        if (message.expectsResponse())
          paramsClass = UntrustedLobsterPageHandler_CommitAsDownload_Params;
      break;
      case kUntrustedLobsterPageHandler_PreviewFeedback_Name:
        if (message.expectsResponse())
          paramsClass = UntrustedLobsterPageHandler_PreviewFeedback_Params;
      break;
      case kUntrustedLobsterPageHandler_SubmitFeedback_Name:
        if (message.expectsResponse())
          paramsClass = UntrustedLobsterPageHandler_SubmitFeedback_Params;
      break;
      case kUntrustedLobsterPageHandler_ShowUI_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = UntrustedLobsterPageHandler_ShowUI_Params;
      break;
      case kUntrustedLobsterPageHandler_CloseUI_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = UntrustedLobsterPageHandler_CloseUI_Params;
      break;
      case kUntrustedLobsterPageHandler_EmitMetricEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = UntrustedLobsterPageHandler_EmitMetricEvent_Params;
      break;
      case kUntrustedLobsterPageHandler_OpenUrlInNewWindow_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateUntrustedLobsterPageHandlerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kUntrustedLobsterPageHandler_RequestCandidates_Name:
        if (message.isResponse())
          paramsClass = UntrustedLobsterPageHandler_RequestCandidates_ResponseParams;
        break;
      case kUntrustedLobsterPageHandler_DownloadCandidate_Name:
        if (message.isResponse())
          paramsClass = UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams;
        break;
      case kUntrustedLobsterPageHandler_CommitAsInsert_Name:
        if (message.isResponse())
          paramsClass = UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams;
        break;
      case kUntrustedLobsterPageHandler_CommitAsDownload_Name:
        if (message.isResponse())
          paramsClass = UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams;
        break;
      case kUntrustedLobsterPageHandler_PreviewFeedback_Name:
        if (message.isResponse())
          paramsClass = UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams;
        break;
      case kUntrustedLobsterPageHandler_SubmitFeedback_Name:
        if (message.isResponse())
          paramsClass = UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var UntrustedLobsterPageHandler = {
    name: 'lobster.mojom.UntrustedLobsterPageHandler',
    kVersion: 5,
    ptrClass: UntrustedLobsterPageHandlerPtr,
    proxyClass: UntrustedLobsterPageHandlerProxy,
    stubClass: UntrustedLobsterPageHandlerStub,
    validateRequest: validateUntrustedLobsterPageHandlerRequest,
    validateResponse: validateUntrustedLobsterPageHandlerResponse,
  };
  UntrustedLobsterPageHandlerStub.prototype.validator = validateUntrustedLobsterPageHandlerRequest;
  UntrustedLobsterPageHandlerProxy.prototype.validator = validateUntrustedLobsterPageHandlerResponse;
  exports.StatusCode = StatusCode;
  exports.WebUIMetricEvent = WebUIMetricEvent;
  exports.Candidate = Candidate;
  exports.Error = Error;
  exports.FeedbackPreview = FeedbackPreview;
  exports.Response = Response;
  exports.UntrustedLobsterPageHandler = UntrustedLobsterPageHandler;
  exports.UntrustedLobsterPageHandlerPtr = UntrustedLobsterPageHandlerPtr;
  exports.UntrustedLobsterPageHandlerAssociatedPtr = UntrustedLobsterPageHandlerAssociatedPtr;
})();