// chrome/browser/ui/webui/ash/lobster/lobster.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../../url/mojom/url.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const StatusCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const StatusCode = {
  
  kUnknown: 0,
  kOk: 1,
  kBlockedOutputs: 2,
  kNoInternetConnection: 3,
  kResourceExhausted: 4,
  kInvalidArgument: 5,
  kBackendFailure: 6,
  kUnsupportedLanguage: 7,
  kRestrictedRegion: 8,
  kContainsPeople: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebUIMetricEventSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebUIMetricEvent = {
  
  kUnknown: 0,
  kQueryPageImpression: 1,
  kRequestInitialCandidates: 2,
  kRequestInitialCandidatesSuccess: 3,
  kRequestInitialCandidatesError: 4,
  kInitialCandidatesImpression: 5,
  kRequestMoreCandidates: 6,
  kRequestMoreCandidatesSuccess: 7,
  kRequestMoreCandidatesError: 8,
  kMoreCandidatesAppended: 9,
  kFeedbackThumbsUp: 10,
  kFeedbackThumbsDown: 11,
  MIN_VALUE: 0,
  MAX_VALUE: 11,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class UntrustedLobsterPageHandlerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'lobster.mojom.UntrustedLobsterPageHandler', scope);
  }
}

/** @interface */
export class UntrustedLobsterPageHandlerInterface {
  
  /**
   * @param { !string } query
   * @param { !number } numCandidates
   * @return {!Promise<{
        response: !Response,
   *  }>}
   */

  requestCandidates(query, numCandidates) {}
  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  downloadCandidate(candidateId) {}
  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  commitAsInsert(candidateId) {}
  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  commitAsDownload(candidateId) {}
  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        preview: !FeedbackPreview,
   *  }>}
   */

  previewFeedback(candidateId) {}
  
  /**
   * @param { !number } candidateId
   * @param { !string } description
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  submitFeedback(candidateId, description) {}
  
  /**
   */

  showUI() {}
  
  /**
   */

  closeUI() {}
  
  /**
   * @param { !WebUIMetricEvent } metricEvent
   */

  emitMetricEvent(metricEvent) {}
  
  /**
   * @param { !url_mojom_Url } url
   */

  openUrlInNewWindow(url) {}
}

/**
 * @implements { UntrustedLobsterPageHandlerInterface }
 */
export class UntrustedLobsterPageHandlerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!UntrustedLobsterPageHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UntrustedLobsterPageHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!UntrustedLobsterPageHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } query
   * @param { !number } numCandidates
   * @return {!Promise<{
        response: !Response,
   *  }>}
   */

  requestCandidates(
      query,
      numCandidates) {
    return this.proxy.sendMessage(
        0,
        UntrustedLobsterPageHandler_RequestCandidates_ParamsSpec.$,
        UntrustedLobsterPageHandler_RequestCandidates_ResponseParamsSpec.$,
        [
          query,
          numCandidates
        ],
        false);
  }

  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  downloadCandidate(
      candidateId) {
    return this.proxy.sendMessage(
        1,
        UntrustedLobsterPageHandler_DownloadCandidate_ParamsSpec.$,
        UntrustedLobsterPageHandler_DownloadCandidate_ResponseParamsSpec.$,
        [
          candidateId
        ],
        false);
  }

  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  commitAsInsert(
      candidateId) {
    return this.proxy.sendMessage(
        2,
        UntrustedLobsterPageHandler_CommitAsInsert_ParamsSpec.$,
        UntrustedLobsterPageHandler_CommitAsInsert_ResponseParamsSpec.$,
        [
          candidateId
        ],
        false);
  }

  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  commitAsDownload(
      candidateId) {
    return this.proxy.sendMessage(
        3,
        UntrustedLobsterPageHandler_CommitAsDownload_ParamsSpec.$,
        UntrustedLobsterPageHandler_CommitAsDownload_ResponseParamsSpec.$,
        [
          candidateId
        ],
        false);
  }

  
  /**
   * @param { !number } candidateId
   * @return {!Promise<{
        preview: !FeedbackPreview,
   *  }>}
   */

  previewFeedback(
      candidateId) {
    return this.proxy.sendMessage(
        4,
        UntrustedLobsterPageHandler_PreviewFeedback_ParamsSpec.$,
        UntrustedLobsterPageHandler_PreviewFeedback_ResponseParamsSpec.$,
        [
          candidateId
        ],
        false);
  }

  
  /**
   * @param { !number } candidateId
   * @param { !string } description
   * @return {!Promise<{
        status: !boolean,
   *  }>}
   */

  submitFeedback(
      candidateId,
      description) {
    return this.proxy.sendMessage(
        5,
        UntrustedLobsterPageHandler_SubmitFeedback_ParamsSpec.$,
        UntrustedLobsterPageHandler_SubmitFeedback_ResponseParamsSpec.$,
        [
          candidateId,
          description
        ],
        false);
  }

  
  /**
   */

  showUI() {
    this.proxy.sendMessage(
        6,
        UntrustedLobsterPageHandler_ShowUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  closeUI() {
    this.proxy.sendMessage(
        7,
        UntrustedLobsterPageHandler_CloseUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !WebUIMetricEvent } metricEvent
   */

  emitMetricEvent(
      metricEvent) {
    this.proxy.sendMessage(
        8,
        UntrustedLobsterPageHandler_EmitMetricEvent_ParamsSpec.$,
        null,
        [
          metricEvent
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   */

  openUrlInNewWindow(
      url) {
    this.proxy.sendMessage(
        9,
        UntrustedLobsterPageHandler_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }
}

/**
 * An object which receives request messages for the UntrustedLobsterPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UntrustedLobsterPageHandlerReceiver {
  /**
   * @param {!UntrustedLobsterPageHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!UntrustedLobsterPageHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UntrustedLobsterPageHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UntrustedLobsterPageHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UntrustedLobsterPageHandler_RequestCandidates_ParamsSpec.$,
        UntrustedLobsterPageHandler_RequestCandidates_ResponseParamsSpec.$,
        impl.requestCandidates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        UntrustedLobsterPageHandler_DownloadCandidate_ParamsSpec.$,
        UntrustedLobsterPageHandler_DownloadCandidate_ResponseParamsSpec.$,
        impl.downloadCandidate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        UntrustedLobsterPageHandler_CommitAsInsert_ParamsSpec.$,
        UntrustedLobsterPageHandler_CommitAsInsert_ResponseParamsSpec.$,
        impl.commitAsInsert.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        UntrustedLobsterPageHandler_CommitAsDownload_ParamsSpec.$,
        UntrustedLobsterPageHandler_CommitAsDownload_ResponseParamsSpec.$,
        impl.commitAsDownload.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        UntrustedLobsterPageHandler_PreviewFeedback_ParamsSpec.$,
        UntrustedLobsterPageHandler_PreviewFeedback_ResponseParamsSpec.$,
        impl.previewFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        UntrustedLobsterPageHandler_SubmitFeedback_ParamsSpec.$,
        UntrustedLobsterPageHandler_SubmitFeedback_ResponseParamsSpec.$,
        impl.submitFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        UntrustedLobsterPageHandler_ShowUI_ParamsSpec.$,
        null,
        impl.showUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        UntrustedLobsterPageHandler_CloseUI_ParamsSpec.$,
        null,
        impl.closeUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        UntrustedLobsterPageHandler_EmitMetricEvent_ParamsSpec.$,
        null,
        impl.emitMetricEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        UntrustedLobsterPageHandler_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        impl.openUrlInNewWindow.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UntrustedLobsterPageHandler {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "lobster.mojom.UntrustedLobsterPageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!UntrustedLobsterPageHandlerRemote}
   */
  static getRemote() {
    let remote = new UntrustedLobsterPageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the UntrustedLobsterPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UntrustedLobsterPageHandlerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UntrustedLobsterPageHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UntrustedLobsterPageHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestCandidates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UntrustedLobsterPageHandler_RequestCandidates_ParamsSpec.$,
        UntrustedLobsterPageHandler_RequestCandidates_ResponseParamsSpec.$,
        this.requestCandidates.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.downloadCandidate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        UntrustedLobsterPageHandler_DownloadCandidate_ParamsSpec.$,
        UntrustedLobsterPageHandler_DownloadCandidate_ResponseParamsSpec.$,
        this.downloadCandidate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.commitAsInsert =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        UntrustedLobsterPageHandler_CommitAsInsert_ParamsSpec.$,
        UntrustedLobsterPageHandler_CommitAsInsert_ResponseParamsSpec.$,
        this.commitAsInsert.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.commitAsDownload =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        UntrustedLobsterPageHandler_CommitAsDownload_ParamsSpec.$,
        UntrustedLobsterPageHandler_CommitAsDownload_ResponseParamsSpec.$,
        this.commitAsDownload.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.previewFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        UntrustedLobsterPageHandler_PreviewFeedback_ParamsSpec.$,
        UntrustedLobsterPageHandler_PreviewFeedback_ResponseParamsSpec.$,
        this.previewFeedback.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submitFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        UntrustedLobsterPageHandler_SubmitFeedback_ParamsSpec.$,
        UntrustedLobsterPageHandler_SubmitFeedback_ResponseParamsSpec.$,
        this.submitFeedback.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        UntrustedLobsterPageHandler_ShowUI_ParamsSpec.$,
        null,
        this.showUI.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        UntrustedLobsterPageHandler_CloseUI_ParamsSpec.$,
        null,
        this.closeUI.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.emitMetricEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        UntrustedLobsterPageHandler_EmitMetricEvent_ParamsSpec.$,
        null,
        this.emitMetricEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openUrlInNewWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        UntrustedLobsterPageHandler_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        this.openUrlInNewWindow.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FeedbackPreviewSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_RequestCandidates_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_RequestCandidates_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_DownloadCandidate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_DownloadCandidate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_CommitAsInsert_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_CommitAsInsert_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_CommitAsDownload_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_CommitAsDownload_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_PreviewFeedback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_PreviewFeedback_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_SubmitFeedback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_SubmitFeedback_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_ShowUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_CloseUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_EmitMetricEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UntrustedLobsterPageHandler_OpenUrlInNewWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const ResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CandidateSpec.$,
    'Candidate',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dataUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Candidate {
  constructor() {
    /** @type { !number } */
    this.id;
    /** @type { !url_mojom_Url } */
    this.dataUrl;
  }
}



mojo.internal.Struct(
    ErrorSpec.$,
    'Error',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        StatusCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Error {
  constructor() {
    /** @type { !StatusCode } */
    this.code;
    /** @type { !string } */
    this.message;
  }
}



mojo.internal.Struct(
    FeedbackPreviewSpec.$,
    'FeedbackPreview',
    [
      mojo.internal.StructField(
        'fields', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'previewDataUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FeedbackPreview {
  constructor() {
    /** @type { !Object<!string, !string> } */
    this.fields;
    /** @type { !url_mojom_Url } */
    this.previewDataUrl;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_RequestCandidates_ParamsSpec.$,
    'UntrustedLobsterPageHandler_RequestCandidates_Params',
    [
      mojo.internal.StructField(
        'query', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numCandidates', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_RequestCandidates_Params {
  constructor() {
    /** @type { !string } */
    this.query;
    /** @type { !number } */
    this.numCandidates;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_RequestCandidates_ResponseParamsSpec.$,
    'UntrustedLobsterPageHandler_RequestCandidates_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        ResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_RequestCandidates_ResponseParams {
  constructor() {
    /** @type { !Response } */
    this.response;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_DownloadCandidate_ParamsSpec.$,
    'UntrustedLobsterPageHandler_DownloadCandidate_Params',
    [
      mojo.internal.StructField(
        'candidateId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_DownloadCandidate_Params {
  constructor() {
    /** @type { !number } */
    this.candidateId;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_DownloadCandidate_ResponseParamsSpec.$,
    'UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_DownloadCandidate_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.status;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_CommitAsInsert_ParamsSpec.$,
    'UntrustedLobsterPageHandler_CommitAsInsert_Params',
    [
      mojo.internal.StructField(
        'candidateId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_CommitAsInsert_Params {
  constructor() {
    /** @type { !number } */
    this.candidateId;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_CommitAsInsert_ResponseParamsSpec.$,
    'UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_CommitAsInsert_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.status;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_CommitAsDownload_ParamsSpec.$,
    'UntrustedLobsterPageHandler_CommitAsDownload_Params',
    [
      mojo.internal.StructField(
        'candidateId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_CommitAsDownload_Params {
  constructor() {
    /** @type { !number } */
    this.candidateId;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_CommitAsDownload_ResponseParamsSpec.$,
    'UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_CommitAsDownload_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.status;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_PreviewFeedback_ParamsSpec.$,
    'UntrustedLobsterPageHandler_PreviewFeedback_Params',
    [
      mojo.internal.StructField(
        'candidateId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_PreviewFeedback_Params {
  constructor() {
    /** @type { !number } */
    this.candidateId;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_PreviewFeedback_ResponseParamsSpec.$,
    'UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams',
    [
      mojo.internal.StructField(
        'preview', 0,
        0,
        FeedbackPreviewSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_PreviewFeedback_ResponseParams {
  constructor() {
    /** @type { !FeedbackPreview } */
    this.preview;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_SubmitFeedback_ParamsSpec.$,
    'UntrustedLobsterPageHandler_SubmitFeedback_Params',
    [
      mojo.internal.StructField(
        'candidateId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_SubmitFeedback_Params {
  constructor() {
    /** @type { !number } */
    this.candidateId;
    /** @type { !string } */
    this.description;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_SubmitFeedback_ResponseParamsSpec.$,
    'UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_SubmitFeedback_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.status;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_ShowUI_ParamsSpec.$,
    'UntrustedLobsterPageHandler_ShowUI_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_ShowUI_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_CloseUI_ParamsSpec.$,
    'UntrustedLobsterPageHandler_CloseUI_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_CloseUI_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_EmitMetricEvent_ParamsSpec.$,
    'UntrustedLobsterPageHandler_EmitMetricEvent_Params',
    [
      mojo.internal.StructField(
        'metricEvent', 0,
        0,
        WebUIMetricEventSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_EmitMetricEvent_Params {
  constructor() {
    /** @type { !WebUIMetricEvent } */
    this.metricEvent;
  }
}



mojo.internal.Struct(
    UntrustedLobsterPageHandler_OpenUrlInNewWindow_ParamsSpec.$,
    'UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UntrustedLobsterPageHandler_OpenUrlInNewWindow_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
  }
}

mojo.internal.Union(
    ResponseSpec.$, 'Response',
    {
      'candidates': {
        'ordinal': 0,
        'type': mojo.internal.Array(CandidateSpec.$, false),
      },
      'error': {
        'ordinal': 1,
        'type': ErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   candidates: (!Array<!Candidate>|undefined),
 *   error: (!Error|undefined),
 * } }
 */
export const Response = {};
