// chromeos/ash/components/enhanced_network_tts/mojom/enhanced_network_tts.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('ash.enhancedNetworkTts.mojom');




/**
 * @const { !number }
 * @export
 */
ash.enhancedNetworkTts.mojom.ENHANCED_NETWORK_TTS_MAX_CHARACTER_SIZE = 1000;


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.enhancedNetworkTts.mojom.TtsRequestErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.enhancedNetworkTts.mojom.TtsRequestError = {
  
  kEmptyUtterance: 0,
  kOverLength: 1,
  kServerError: 2,
  kReceivedUnexpectedData: 3,
  kRequestOverride: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.enhancedNetworkTts.mojom.EnhancedNetworkTts.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsInterface }
 */
ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.enhancedNetworkTts.mojom.TtsRequest } request
   * @return {!Promise<{
        observer: !ash.enhancedNetworkTts.mojom.AudioDataObserverPendingReceiver,
   *  }>}
   */

  getAudioData(
      request) {
    return this.proxy.sendMessage(
        0,
        ash.enhancedNetworkTts.mojom.EnhancedNetworkTts_GetAudioData_ParamsSpec.$,
        ash.enhancedNetworkTts.mojom.EnhancedNetworkTts_GetAudioData_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }
};

/**
 * An object which receives request messages for the EnhancedNetworkTts
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsReceiver = class {
  /**
   * @param {!ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.enhancedNetworkTts.mojom.EnhancedNetworkTts_GetAudioData_ParamsSpec.$,
        ash.enhancedNetworkTts.mojom.EnhancedNetworkTts_GetAudioData_ResponseParamsSpec.$,
        impl.getAudioData.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.enhancedNetworkTts.mojom.EnhancedNetworkTts = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.enhanced_network_tts.mojom.EnhancedNetworkTts";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the EnhancedNetworkTts
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.enhancedNetworkTts.mojom.EnhancedNetworkTtsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAudioData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.enhancedNetworkTts.mojom.EnhancedNetworkTts_GetAudioData_ParamsSpec.$,
        ash.enhancedNetworkTts.mojom.EnhancedNetworkTts_GetAudioData_ResponseParamsSpec.$,
        this.getAudioData.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.enhancedNetworkTts.mojom.AudioDataObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.enhancedNetworkTts.mojom.AudioDataObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.enhancedNetworkTts.mojom.AudioDataObserverInterface }
 */
ash.enhancedNetworkTts.mojom.AudioDataObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.enhancedNetworkTts.mojom.AudioDataObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.enhancedNetworkTts.mojom.AudioDataObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.enhancedNetworkTts.mojom.AudioDataObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.enhancedNetworkTts.mojom.TtsResponse } response
   */

  onAudioDataReceived(
      response) {
    this.proxy.sendMessage(
        0,
        ash.enhancedNetworkTts.mojom.AudioDataObserver_OnAudioDataReceived_ParamsSpec.$,
        null,
        [
          response
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioDataObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.enhancedNetworkTts.mojom.AudioDataObserverReceiver = class {
  /**
   * @param {!ash.enhancedNetworkTts.mojom.AudioDataObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.enhancedNetworkTts.mojom.AudioDataObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.enhancedNetworkTts.mojom.AudioDataObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.enhancedNetworkTts.mojom.AudioDataObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.enhancedNetworkTts.mojom.AudioDataObserver_OnAudioDataReceived_ParamsSpec.$,
        null,
        impl.onAudioDataReceived.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.enhancedNetworkTts.mojom.AudioDataObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.enhanced_network_tts.mojom.AudioDataObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.enhancedNetworkTts.mojom.AudioDataObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.enhancedNetworkTts.mojom.AudioDataObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioDataObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.enhancedNetworkTts.mojom.AudioDataObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.enhancedNetworkTts.mojom.AudioDataObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.enhancedNetworkTts.mojom.AudioDataObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAudioDataReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.enhancedNetworkTts.mojom.AudioDataObserver_OnAudioDataReceived_ParamsSpec.$,
        null,
        this.onAudioDataReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.enhancedNetworkTts.mojom.TtsRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.enhancedNetworkTts.mojom.TimingInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.enhancedNetworkTts.mojom.TtsDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.enhancedNetworkTts.mojom.EnhancedNetworkTts_GetAudioData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.enhancedNetworkTts.mojom.EnhancedNetworkTts_GetAudioData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.enhancedNetworkTts.mojom.AudioDataObserver_OnAudioDataReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
ash.enhancedNetworkTts.mojom.TtsResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ash.enhancedNetworkTts.mojom.TtsRequestSpec.$,
    'TtsRequest',
    [
      mojo.internal.StructField(
        'utterance', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rate', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'voice', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lang', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
ash.enhancedNetworkTts.mojom.TtsRequest = class {
  constructor() {
    /** @export { !string } */
    this.utterance;
    /** @export { !number } */
    this.rate;
    /** @export { (string|undefined) } */
    this.voice;
    /** @export { (string|undefined) } */
    this.lang;
  }
};



mojo.internal.Struct(
    ash.enhancedNetworkTts.mojom.TimingInfoSpec.$,
    'TimingInfo',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textOffset', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeOffset', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'duration', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
ash.enhancedNetworkTts.mojom.TimingInfo = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { !number } */
    this.textOffset;
    /** @export { !string } */
    this.timeOffset;
    /** @export { !string } */
    this.duration;
  }
};



mojo.internal.Struct(
    ash.enhancedNetworkTts.mojom.TtsDataSpec.$,
    'TtsData',
    [
      mojo.internal.StructField(
        'audio', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeInfo', 8,
        0,
        mojo.internal.Array(ash.enhancedNetworkTts.mojom.TimingInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lastData', 16,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
ash.enhancedNetworkTts.mojom.TtsData = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.audio;
    /** @export { !Array<!ash.enhancedNetworkTts.mojom.TimingInfo> } */
    this.timeInfo;
    /** @export { !boolean } */
    this.lastData;
  }
};



mojo.internal.Struct(
    ash.enhancedNetworkTts.mojom.EnhancedNetworkTts_GetAudioData_ParamsSpec.$,
    'EnhancedNetworkTts_GetAudioData_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        ash.enhancedNetworkTts.mojom.TtsRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.enhancedNetworkTts.mojom.EnhancedNetworkTts_GetAudioData_Params = class {
  constructor() {
    /** @export { !ash.enhancedNetworkTts.mojom.TtsRequest } */
    this.request;
  }
};



mojo.internal.Struct(
    ash.enhancedNetworkTts.mojom.EnhancedNetworkTts_GetAudioData_ResponseParamsSpec.$,
    'EnhancedNetworkTts_GetAudioData_ResponseParams',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceRequest(ash.enhancedNetworkTts.mojom.AudioDataObserverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.enhancedNetworkTts.mojom.EnhancedNetworkTts_GetAudioData_ResponseParams = class {
  constructor() {
    /** @export { !ash.enhancedNetworkTts.mojom.AudioDataObserverPendingReceiver } */
    this.observer;
  }
};



mojo.internal.Struct(
    ash.enhancedNetworkTts.mojom.AudioDataObserver_OnAudioDataReceived_ParamsSpec.$,
    'AudioDataObserver_OnAudioDataReceived_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        ash.enhancedNetworkTts.mojom.TtsResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.enhancedNetworkTts.mojom.AudioDataObserver_OnAudioDataReceived_Params = class {
  constructor() {
    /** @export { !ash.enhancedNetworkTts.mojom.TtsResponse } */
    this.response;
  }
};



mojo.internal.Union(
    ash.enhancedNetworkTts.mojom.TtsResponseSpec.$, 'TtsResponse',
    {
      'errorCode': {
        'ordinal': 0,
        'type': ash.enhancedNetworkTts.mojom.TtsRequestErrorSpec.$,
      },
      'data': {
        'ordinal': 1,
        'type': ash.enhancedNetworkTts.mojom.TtsDataSpec.$,
      },
    });

/**
 * @typedef { {
 *   errorCode: (!ash.enhancedNetworkTts.mojom.TtsRequestError|undefined),
 *   data: (!ash.enhancedNetworkTts.mojom.TtsData|undefined),
 * } }
 */
ash.enhancedNetworkTts.mojom.TtsResponse;
