// chromeos/ash/components/enhanced_network_tts/mojom/enhanced_network_tts.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/ash/components/enhanced_network_tts/mojom/enhanced_network_tts.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ash.enhancedNetworkTts.mojom');


  var ENHANCED_NETWORK_TTS_MAX_CHARACTER_SIZE = 1000;
  var TtsRequestError = {};
  TtsRequestError.kEmptyUtterance = 0;
  TtsRequestError.kOverLength = 1;
  TtsRequestError.kServerError = 2;
  TtsRequestError.kReceivedUnexpectedData = 3;
  TtsRequestError.kRequestOverride = 4;
  TtsRequestError.MIN_VALUE = 0;
  TtsRequestError.MAX_VALUE = 4;

  TtsRequestError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  TtsRequestError.toKnownEnumValue = function(value) {
    return value;
  };

  TtsRequestError.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function TtsRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TtsRequest.prototype.initDefaults_ = function() {
    this.utterance = null;
    this.rate = 0;
    this.voice = null;
    this.lang = null;
  };
  TtsRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TtsRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TtsRequest.utterance
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate TtsRequest.voice
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TtsRequest.lang
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TtsRequest.encodedSize = codec.kStructHeaderSize + 32;

  TtsRequest.decode = function(decoder) {
    var packed;
    var val = new TtsRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.utterance =
        decoder.decodeStruct(codec.String);
    val.rate =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.voice =
        decoder.decodeStruct(codec.String);
    val.lang =
        decoder.decodeStruct(codec.String);
    return val;
  };

  TtsRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TtsRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.utterance);
    encoder.encodeStruct(codec.Float, val.rate);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.voice);
    encoder.encodeStruct(codec.String, val.lang);
  };
  function TimingInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TimingInfo.prototype.initDefaults_ = function() {
    this.text = null;
    this.textOffset = 0;
    this.timeOffset = null;
    this.duration = null;
  };
  TimingInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TimingInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TimingInfo.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate TimingInfo.timeOffset
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TimingInfo.duration
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TimingInfo.encodedSize = codec.kStructHeaderSize + 32;

  TimingInfo.decode = function(decoder) {
    var packed;
    var val = new TimingInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.textOffset =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.timeOffset =
        decoder.decodeStruct(codec.String);
    val.duration =
        decoder.decodeStruct(codec.String);
    return val;
  };

  TimingInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TimingInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStruct(codec.Uint32, val.textOffset);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.timeOffset);
    encoder.encodeStruct(codec.String, val.duration);
  };
  function TtsData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TtsData.prototype.initDefaults_ = function() {
    this.audio = null;
    this.timeInfo = null;
    this.lastData = false;
  };
  TtsData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TtsData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TtsData.audio
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TtsData.timeInfo
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(TimingInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  TtsData.encodedSize = codec.kStructHeaderSize + 24;

  TtsData.decode = function(decoder) {
    var packed;
    var val = new TtsData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.audio =
        decoder.decodeArrayPointer(codec.Uint8);
    val.timeInfo =
        decoder.decodeArrayPointer(new codec.PointerTo(TimingInfo));
    packed = decoder.readUint8();
    val.lastData = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TtsData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TtsData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.audio);
    encoder.encodeArrayPointer(new codec.PointerTo(TimingInfo), val.timeInfo);
    packed = 0;
    packed |= (val.lastData & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EnhancedNetworkTts_GetAudioData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EnhancedNetworkTts_GetAudioData_Params.prototype.initDefaults_ = function() {
    this.request = null;
  };
  EnhancedNetworkTts_GetAudioData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EnhancedNetworkTts_GetAudioData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EnhancedNetworkTts_GetAudioData_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, TtsRequest, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EnhancedNetworkTts_GetAudioData_Params.encodedSize = codec.kStructHeaderSize + 8;

  EnhancedNetworkTts_GetAudioData_Params.decode = function(decoder) {
    var packed;
    var val = new EnhancedNetworkTts_GetAudioData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(TtsRequest);
    return val;
  };

  EnhancedNetworkTts_GetAudioData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EnhancedNetworkTts_GetAudioData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(TtsRequest, val.request);
  };
  function EnhancedNetworkTts_GetAudioData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EnhancedNetworkTts_GetAudioData_ResponseParams.prototype.initDefaults_ = function() {
    this.observer = new bindings.InterfaceRequest();
  };
  EnhancedNetworkTts_GetAudioData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EnhancedNetworkTts_GetAudioData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EnhancedNetworkTts_GetAudioData_ResponseParams.observer
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EnhancedNetworkTts_GetAudioData_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  EnhancedNetworkTts_GetAudioData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new EnhancedNetworkTts_GetAudioData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  EnhancedNetworkTts_GetAudioData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EnhancedNetworkTts_GetAudioData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.observer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AudioDataObserver_OnAudioDataReceived_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioDataObserver_OnAudioDataReceived_Params.prototype.initDefaults_ = function() {
    this.response = null;
  };
  AudioDataObserver_OnAudioDataReceived_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioDataObserver_OnAudioDataReceived_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioDataObserver_OnAudioDataReceived_Params.response
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, TtsResponse, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioDataObserver_OnAudioDataReceived_Params.encodedSize = codec.kStructHeaderSize + 16;

  AudioDataObserver_OnAudioDataReceived_Params.decode = function(decoder) {
    var packed;
    var val = new AudioDataObserver_OnAudioDataReceived_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.response =
        decoder.decodeStruct(TtsResponse);
    return val;
  };

  AudioDataObserver_OnAudioDataReceived_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioDataObserver_OnAudioDataReceived_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(TtsResponse, val.response);
  };

  function TtsResponse(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  TtsResponse.Tags = {
    errorCode: 0,
    data: 1,
  };

  TtsResponse.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  TtsResponse.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "errorCode",
        "data",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a TtsResponse member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(TtsResponse.prototype, "errorCode", {
    get: function() {
      if (this.$tag != TtsResponse.Tags.errorCode) {
        throw new ReferenceError(
            "TtsResponse.errorCode is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TtsResponse.Tags.errorCode;
      this.$data = value;
    }
  });
  Object.defineProperty(TtsResponse.prototype, "data", {
    get: function() {
      if (this.$tag != TtsResponse.Tags.data) {
        throw new ReferenceError(
            "TtsResponse.data is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TtsResponse.Tags.data;
      this.$data = value;
    }
  });


    TtsResponse.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case TtsResponse.Tags.errorCode:
          encoder.encodeStruct(codec.Int32, val.errorCode);
          break;
        case TtsResponse.Tags.data:
          encoder.encodeStructPointer(TtsData, val.data);
          break;
      }
      encoder.align();
    };


    TtsResponse.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new TtsResponse();
      var tag = decoder.readUint32();
      switch (tag) {
        case TtsResponse.Tags.errorCode:
          result.errorCode = decoder.decodeStruct(new codec.Enum(TtsRequestError));
          break;
        case TtsResponse.Tags.data:
          result.data = decoder.decodeStructPointer(TtsData);
          break;
      }
      decoder.align();

      return result;
    };


    TtsResponse.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case TtsResponse.Tags.errorCode:
          

    // validate TtsResponse.errorCode
    err = messageValidator.validateEnum(data_offset, TtsRequestError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TtsResponse.Tags.data:
          

    // validate TtsResponse.data
    err = messageValidator.validateStructPointer(data_offset, TtsData, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  TtsResponse.encodedSize = 16;
  var kEnhancedNetworkTts_GetAudioData_Name = 0;

  function EnhancedNetworkTtsPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(EnhancedNetworkTts,
                                                   handleOrPtrInfo);
  }

  function EnhancedNetworkTtsAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        EnhancedNetworkTts, associatedInterfacePtrInfo);
  }

  EnhancedNetworkTtsAssociatedPtr.prototype =
      Object.create(EnhancedNetworkTtsPtr.prototype);
  EnhancedNetworkTtsAssociatedPtr.prototype.constructor =
      EnhancedNetworkTtsAssociatedPtr;

  function EnhancedNetworkTtsProxy(receiver) {
    this.receiver_ = receiver;
  }
  EnhancedNetworkTtsPtr.prototype.getAudioData = function() {
    return EnhancedNetworkTtsProxy.prototype.getAudioData
        .apply(this.ptr.getProxy(), arguments);
  };

  EnhancedNetworkTtsProxy.prototype.getAudioData = function(request) {
    var params_ = new EnhancedNetworkTts_GetAudioData_Params();
    params_.request = request;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kEnhancedNetworkTts_GetAudioData_Name,
          codec.align(EnhancedNetworkTts_GetAudioData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(EnhancedNetworkTts_GetAudioData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(EnhancedNetworkTts_GetAudioData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function EnhancedNetworkTtsStub(delegate) {
    this.delegate_ = delegate;
  }
  EnhancedNetworkTtsStub.prototype.getAudioData = function(request) {
    return this.delegate_ && this.delegate_.getAudioData && this.delegate_.getAudioData(request);
  }

  EnhancedNetworkTtsStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  EnhancedNetworkTtsStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kEnhancedNetworkTts_GetAudioData_Name:
      var params = reader.decodeStruct(EnhancedNetworkTts_GetAudioData_Params);
      this.getAudioData(params.request).then(function(response) {
        var responseParams =
            new EnhancedNetworkTts_GetAudioData_ResponseParams();
        responseParams.observer = response.observer;
        var builder = new codec.MessageV1Builder(
            kEnhancedNetworkTts_GetAudioData_Name,
            codec.align(EnhancedNetworkTts_GetAudioData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(EnhancedNetworkTts_GetAudioData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateEnhancedNetworkTtsRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kEnhancedNetworkTts_GetAudioData_Name:
        if (message.expectsResponse())
          paramsClass = EnhancedNetworkTts_GetAudioData_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateEnhancedNetworkTtsResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kEnhancedNetworkTts_GetAudioData_Name:
        if (message.isResponse())
          paramsClass = EnhancedNetworkTts_GetAudioData_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var EnhancedNetworkTts = {
    name: 'ash.enhanced_network_tts.mojom.EnhancedNetworkTts',
    kVersion: 0,
    ptrClass: EnhancedNetworkTtsPtr,
    proxyClass: EnhancedNetworkTtsProxy,
    stubClass: EnhancedNetworkTtsStub,
    validateRequest: validateEnhancedNetworkTtsRequest,
    validateResponse: validateEnhancedNetworkTtsResponse,
  };
  EnhancedNetworkTtsStub.prototype.validator = validateEnhancedNetworkTtsRequest;
  EnhancedNetworkTtsProxy.prototype.validator = validateEnhancedNetworkTtsResponse;
  var kAudioDataObserver_OnAudioDataReceived_Name = 0;

  function AudioDataObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AudioDataObserver,
                                                   handleOrPtrInfo);
  }

  function AudioDataObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AudioDataObserver, associatedInterfacePtrInfo);
  }

  AudioDataObserverAssociatedPtr.prototype =
      Object.create(AudioDataObserverPtr.prototype);
  AudioDataObserverAssociatedPtr.prototype.constructor =
      AudioDataObserverAssociatedPtr;

  function AudioDataObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  AudioDataObserverPtr.prototype.onAudioDataReceived = function() {
    return AudioDataObserverProxy.prototype.onAudioDataReceived
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioDataObserverProxy.prototype.onAudioDataReceived = function(response) {
    var params_ = new AudioDataObserver_OnAudioDataReceived_Params();
    params_.response = response;
    var builder = new codec.MessageV0Builder(
        kAudioDataObserver_OnAudioDataReceived_Name,
        codec.align(AudioDataObserver_OnAudioDataReceived_Params.encodedSize));
    builder.encodeStruct(AudioDataObserver_OnAudioDataReceived_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AudioDataObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  AudioDataObserverStub.prototype.onAudioDataReceived = function(response) {
    return this.delegate_ && this.delegate_.onAudioDataReceived && this.delegate_.onAudioDataReceived(response);
  }

  AudioDataObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAudioDataObserver_OnAudioDataReceived_Name:
      var params = reader.decodeStruct(AudioDataObserver_OnAudioDataReceived_Params);
      this.onAudioDataReceived(params.response);
      return true;
    default:
      return false;
    }
  };

  AudioDataObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAudioDataObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAudioDataObserver_OnAudioDataReceived_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioDataObserver_OnAudioDataReceived_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAudioDataObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AudioDataObserver = {
    name: 'ash.enhanced_network_tts.mojom.AudioDataObserver',
    kVersion: 0,
    ptrClass: AudioDataObserverPtr,
    proxyClass: AudioDataObserverProxy,
    stubClass: AudioDataObserverStub,
    validateRequest: validateAudioDataObserverRequest,
    validateResponse: null,
  };
  AudioDataObserverStub.prototype.validator = validateAudioDataObserverRequest;
  AudioDataObserverProxy.prototype.validator = null;
  exports.ENHANCED_NETWORK_TTS_MAX_CHARACTER_SIZE = ENHANCED_NETWORK_TTS_MAX_CHARACTER_SIZE;
  exports.TtsRequestError = TtsRequestError;
  exports.TtsRequest = TtsRequest;
  exports.TimingInfo = TimingInfo;
  exports.TtsData = TtsData;
  exports.TtsResponse = TtsResponse;
  exports.EnhancedNetworkTts = EnhancedNetworkTts;
  exports.EnhancedNetworkTtsPtr = EnhancedNetworkTtsPtr;
  exports.EnhancedNetworkTtsAssociatedPtr = EnhancedNetworkTtsAssociatedPtr;
  exports.AudioDataObserver = AudioDataObserver;
  exports.AudioDataObserverPtr = AudioDataObserverPtr;
  exports.AudioDataObserverAssociatedPtr = AudioDataObserverAssociatedPtr;
})();