// chromeos/ash/components/enhanced_network_tts/mojom/enhanced_network_tts.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';


/**
 * @const { !number }
 */
export const ENHANCED_NETWORK_TTS_MAX_CHARACTER_SIZE = 1000;


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TtsRequestErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TtsRequestError = {
  
  kEmptyUtterance: 0,
  kOverLength: 1,
  kServerError: 2,
  kReceivedUnexpectedData: 3,
  kRequestOverride: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class EnhancedNetworkTtsPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.enhanced_network_tts.mojom.EnhancedNetworkTts', scope);
  }
}

/** @interface */
export class EnhancedNetworkTtsInterface {
  
  /**
   * @param { !TtsRequest } request
   * @return {!Promise<{
        observer: !AudioDataObserverPendingReceiver,
   *  }>}
   */

  getAudioData(request) {}
}

/**
 * @implements { EnhancedNetworkTtsInterface }
 */
export class EnhancedNetworkTtsRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!EnhancedNetworkTtsPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          EnhancedNetworkTtsPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!EnhancedNetworkTtsPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !TtsRequest } request
   * @return {!Promise<{
        observer: !AudioDataObserverPendingReceiver,
   *  }>}
   */

  getAudioData(
      request) {
    return this.proxy.sendMessage(
        0,
        EnhancedNetworkTts_GetAudioData_ParamsSpec.$,
        EnhancedNetworkTts_GetAudioData_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }
}

/**
 * An object which receives request messages for the EnhancedNetworkTts
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class EnhancedNetworkTtsReceiver {
  /**
   * @param {!EnhancedNetworkTtsInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!EnhancedNetworkTtsRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        EnhancedNetworkTtsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EnhancedNetworkTtsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        EnhancedNetworkTts_GetAudioData_ParamsSpec.$,
        EnhancedNetworkTts_GetAudioData_ResponseParamsSpec.$,
        impl.getAudioData.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class EnhancedNetworkTts {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.enhanced_network_tts.mojom.EnhancedNetworkTts";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!EnhancedNetworkTtsRemote}
   */
  static getRemote() {
    let remote = new EnhancedNetworkTtsRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the EnhancedNetworkTts
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class EnhancedNetworkTtsCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      EnhancedNetworkTtsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EnhancedNetworkTtsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAudioData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        EnhancedNetworkTts_GetAudioData_ParamsSpec.$,
        EnhancedNetworkTts_GetAudioData_ResponseParamsSpec.$,
        this.getAudioData.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioDataObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.enhanced_network_tts.mojom.AudioDataObserver', scope);
  }
}

/** @interface */
export class AudioDataObserverInterface {
  
  /**
   * @param { !TtsResponse } response
   */

  onAudioDataReceived(response) {}
}

/**
 * @implements { AudioDataObserverInterface }
 */
export class AudioDataObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioDataObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioDataObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioDataObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !TtsResponse } response
   */

  onAudioDataReceived(
      response) {
    this.proxy.sendMessage(
        0,
        AudioDataObserver_OnAudioDataReceived_ParamsSpec.$,
        null,
        [
          response
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioDataObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioDataObserverReceiver {
  /**
   * @param {!AudioDataObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioDataObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioDataObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioDataObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioDataObserver_OnAudioDataReceived_ParamsSpec.$,
        null,
        impl.onAudioDataReceived.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioDataObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.enhanced_network_tts.mojom.AudioDataObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioDataObserverRemote}
   */
  static getRemote() {
    let remote = new AudioDataObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioDataObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioDataObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioDataObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioDataObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAudioDataReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioDataObserver_OnAudioDataReceived_ParamsSpec.$,
        null,
        this.onAudioDataReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TtsRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TimingInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TtsDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EnhancedNetworkTts_GetAudioData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EnhancedNetworkTts_GetAudioData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioDataObserver_OnAudioDataReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const TtsResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    TtsRequestSpec.$,
    'TtsRequest',
    [
      mojo.internal.StructField(
        'utterance', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rate', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'voice', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lang', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class TtsRequest {
  constructor() {
    /** @type { !string } */
    this.utterance;
    /** @type { !number } */
    this.rate;
    /** @type { (string|undefined) } */
    this.voice;
    /** @type { (string|undefined) } */
    this.lang;
  }
}



mojo.internal.Struct(
    TimingInfoSpec.$,
    'TimingInfo',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textOffset', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeOffset', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'duration', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class TimingInfo {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { !number } */
    this.textOffset;
    /** @type { !string } */
    this.timeOffset;
    /** @type { !string } */
    this.duration;
  }
}



mojo.internal.Struct(
    TtsDataSpec.$,
    'TtsData',
    [
      mojo.internal.StructField(
        'audio', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeInfo', 8,
        0,
        mojo.internal.Array(TimingInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastData', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TtsData {
  constructor() {
    /** @type { !Array<!number> } */
    this.audio;
    /** @type { !Array<!TimingInfo> } */
    this.timeInfo;
    /** @type { !boolean } */
    this.lastData;
  }
}



mojo.internal.Struct(
    EnhancedNetworkTts_GetAudioData_ParamsSpec.$,
    'EnhancedNetworkTts_GetAudioData_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        TtsRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EnhancedNetworkTts_GetAudioData_Params {
  constructor() {
    /** @type { !TtsRequest } */
    this.request;
  }
}



mojo.internal.Struct(
    EnhancedNetworkTts_GetAudioData_ResponseParamsSpec.$,
    'EnhancedNetworkTts_GetAudioData_ResponseParams',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceRequest(AudioDataObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EnhancedNetworkTts_GetAudioData_ResponseParams {
  constructor() {
    /** @type { !AudioDataObserverPendingReceiver } */
    this.observer;
  }
}



mojo.internal.Struct(
    AudioDataObserver_OnAudioDataReceived_ParamsSpec.$,
    'AudioDataObserver_OnAudioDataReceived_Params',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        TtsResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioDataObserver_OnAudioDataReceived_Params {
  constructor() {
    /** @type { !TtsResponse } */
    this.response;
  }
}

mojo.internal.Union(
    TtsResponseSpec.$, 'TtsResponse',
    {
      'errorCode': {
        'ordinal': 0,
        'type': TtsRequestErrorSpec.$,
      },
      'data': {
        'ordinal': 1,
        'type': TtsDataSpec.$,
      },
    });

/**
 * @typedef { {
 *   errorCode: (!TtsRequestError|undefined),
 *   data: (!TtsData|undefined),
 * } }
 */
export const TtsResponse = {};
