// chromeos/ash/components/language_packs/public/mojom/language_packs.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('ash.language.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.language.mojom.FeatureIdSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.language.mojom.FeatureId = {
  
  UNSUPPORTED_UNKNOWN: 0,
  HANDWRITING_RECOGNITION: 1,
  TTS: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.language.mojom.PackStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.language.mojom.PackState = {
  
  ERROR: 0,
  NOT_INSTALLED: 1,
  INSTALLING: 2,
  INSTALLED: 3,
  UNKNOWN: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.language.mojom.ErrorCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.language.mojom.ErrorCode = {
  
  kUnknown: 0,
  kNone: 1,
  kOther: 2,
  kWrongId: 3,
  kNeedReboot: 4,
  kAllocation: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.language.mojom.LanguagePacksObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.language.mojom.LanguagePacksObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.language.mojom.LanguagePacksObserverInterface }
 */
ash.language.mojom.LanguagePacksObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.language.mojom.LanguagePacksObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.language.mojom.LanguagePacksObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.language.mojom.LanguagePacksObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.language.mojom.LanguagePackInfo } info
   */

  onPackStateChanged(
      info) {
    this.proxy.sendMessage(
        0,
        ash.language.mojom.LanguagePacksObserver_OnPackStateChanged_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LanguagePacksObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.language.mojom.LanguagePacksObserverReceiver = class {
  /**
   * @param {!ash.language.mojom.LanguagePacksObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.language.mojom.LanguagePacksObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.language.mojom.LanguagePacksObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.language.mojom.LanguagePacksObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.language.mojom.LanguagePacksObserver_OnPackStateChanged_ParamsSpec.$,
        null,
        impl.onPackStateChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.language.mojom.LanguagePacksObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.language.mojom.LanguagePacksObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.language.mojom.LanguagePacksObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.language.mojom.LanguagePacksObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the LanguagePacksObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.language.mojom.LanguagePacksObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.language.mojom.LanguagePacksObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.language.mojom.LanguagePacksObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPackStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.language.mojom.LanguagePacksObserver_OnPackStateChanged_ParamsSpec.$,
        null,
        this.onPackStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.language.mojom.LanguagePacksPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.language.mojom.LanguagePacks.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.language.mojom.LanguagePacksInterface }
 */
ash.language.mojom.LanguagePacksRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.language.mojom.LanguagePacksPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.language.mojom.LanguagePacksPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.language.mojom.LanguagePacksPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.language.mojom.FeatureId } featureId
   * @param { !string } language
   * @return {!Promise<{
        info: !ash.language.mojom.LanguagePackInfo,
   *  }>}
   */

  getPackInfo(
      featureId,
      language) {
    return this.proxy.sendMessage(
        0,
        ash.language.mojom.LanguagePacks_GetPackInfo_ParamsSpec.$,
        ash.language.mojom.LanguagePacks_GetPackInfo_ResponseParamsSpec.$,
        [
          featureId,
          language
        ],
        false);
  }

  
  /**
   * @param { !ash.language.mojom.FeatureId } featureId
   * @param { !string } language
   * @return {!Promise<{
        info: !ash.language.mojom.LanguagePackInfo,
   *  }>}
   */

  installPack(
      featureId,
      language) {
    return this.proxy.sendMessage(
        1,
        ash.language.mojom.LanguagePacks_InstallPack_ParamsSpec.$,
        ash.language.mojom.LanguagePacks_InstallPack_ResponseParamsSpec.$,
        [
          featureId,
          language
        ],
        false);
  }

  
  /**
   * @param { !ash.language.mojom.FeatureId } featureId
   * @return {!Promise<{
        info: !ash.language.mojom.BasePackInfo,
   *  }>}
   */

  installBasePack(
      featureId) {
    return this.proxy.sendMessage(
        2,
        ash.language.mojom.LanguagePacks_InstallBasePack_ParamsSpec.$,
        ash.language.mojom.LanguagePacks_InstallBasePack_ResponseParamsSpec.$,
        [
          featureId
        ],
        false);
  }

  
  /**
   * @param { !ash.language.mojom.FeatureId } featureId
   * @param { !string } language
   * @return {!Promise}
   */

  uninstallPack(
      featureId,
      language) {
    return this.proxy.sendMessage(
        3,
        ash.language.mojom.LanguagePacks_UninstallPack_ParamsSpec.$,
        ash.language.mojom.LanguagePacks_UninstallPack_ResponseParamsSpec.$,
        [
          featureId,
          language
        ],
        false);
  }

  
  /**
   * @param { !Object } observer
   */

  addObserver(
      observer) {
    this.proxy.sendMessage(
        4,
        ash.language.mojom.LanguagePacks_AddObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LanguagePacks
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.language.mojom.LanguagePacksReceiver = class {
  /**
   * @param {!ash.language.mojom.LanguagePacksInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.language.mojom.LanguagePacksRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.language.mojom.LanguagePacksRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.language.mojom.LanguagePacksRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.language.mojom.LanguagePacks_GetPackInfo_ParamsSpec.$,
        ash.language.mojom.LanguagePacks_GetPackInfo_ResponseParamsSpec.$,
        impl.getPackInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.language.mojom.LanguagePacks_InstallPack_ParamsSpec.$,
        ash.language.mojom.LanguagePacks_InstallPack_ResponseParamsSpec.$,
        impl.installPack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.language.mojom.LanguagePacks_InstallBasePack_ParamsSpec.$,
        ash.language.mojom.LanguagePacks_InstallBasePack_ResponseParamsSpec.$,
        impl.installBasePack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ash.language.mojom.LanguagePacks_UninstallPack_ParamsSpec.$,
        ash.language.mojom.LanguagePacks_UninstallPack_ResponseParamsSpec.$,
        impl.uninstallPack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ash.language.mojom.LanguagePacks_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.language.mojom.LanguagePacks = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.language.mojom.LanguagePacks";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.language.mojom.LanguagePacksRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.language.mojom.LanguagePacksRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the LanguagePacks
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.language.mojom.LanguagePacksCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.language.mojom.LanguagePacksRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.language.mojom.LanguagePacksRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPackInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.language.mojom.LanguagePacks_GetPackInfo_ParamsSpec.$,
        ash.language.mojom.LanguagePacks_GetPackInfo_ResponseParamsSpec.$,
        this.getPackInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.installPack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.language.mojom.LanguagePacks_InstallPack_ParamsSpec.$,
        ash.language.mojom.LanguagePacks_InstallPack_ResponseParamsSpec.$,
        this.installPack.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.installBasePack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.language.mojom.LanguagePacks_InstallBasePack_ParamsSpec.$,
        ash.language.mojom.LanguagePacks_InstallBasePack_ResponseParamsSpec.$,
        this.installBasePack.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.uninstallPack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ash.language.mojom.LanguagePacks_UninstallPack_ParamsSpec.$,
        ash.language.mojom.LanguagePacks_UninstallPack_ResponseParamsSpec.$,
        this.uninstallPack.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ash.language.mojom.LanguagePacks_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.language.mojom.LanguagePackInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.language.mojom.BasePackInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.language.mojom.LanguagePacksObserver_OnPackStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.language.mojom.LanguagePacks_GetPackInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.language.mojom.LanguagePacks_GetPackInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.language.mojom.LanguagePacks_InstallPack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.language.mojom.LanguagePacks_InstallPack_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.language.mojom.LanguagePacks_InstallBasePack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.language.mojom.LanguagePacks_InstallBasePack_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.language.mojom.LanguagePacks_UninstallPack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.language.mojom.LanguagePacks_UninstallPack_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.language.mojom.LanguagePacks_AddObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ash.language.mojom.LanguagePackInfoSpec.$,
    'LanguagePackInfo',
    [
      mojo.internal.StructField(
        'packState', 0,
        0,
        ash.language.mojom.PackStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'path', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 4,
        0,
        ash.language.mojom.ErrorCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'featureId', 16,
        0,
        ash.language.mojom.FeatureIdSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'locale', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[2, 24],[3, 40],]);





/** @record */
ash.language.mojom.LanguagePackInfo = class {
  constructor() {
    /** @export { !ash.language.mojom.PackState } */
    this.packState;
    /** @export { !string } */
    this.path;
    /** @export { !ash.language.mojom.ErrorCode } */
    this.error;
    /** @export { !ash.language.mojom.FeatureId } */
    this.featureId;
    /** @export { (string|undefined) } */
    this.locale;
  }
};



mojo.internal.Struct(
    ash.language.mojom.BasePackInfoSpec.$,
    'BasePackInfo',
    [
      mojo.internal.StructField(
        'packState', 0,
        0,
        ash.language.mojom.PackStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'path', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 4,
        0,
        ash.language.mojom.ErrorCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[2, 24],]);





/** @record */
ash.language.mojom.BasePackInfo = class {
  constructor() {
    /** @export { !ash.language.mojom.PackState } */
    this.packState;
    /** @export { !string } */
    this.path;
    /** @export { !ash.language.mojom.ErrorCode } */
    this.error;
  }
};



mojo.internal.Struct(
    ash.language.mojom.LanguagePacksObserver_OnPackStateChanged_ParamsSpec.$,
    'LanguagePacksObserver_OnPackStateChanged_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        ash.language.mojom.LanguagePackInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.language.mojom.LanguagePacksObserver_OnPackStateChanged_Params = class {
  constructor() {
    /** @export { !ash.language.mojom.LanguagePackInfo } */
    this.info;
  }
};



mojo.internal.Struct(
    ash.language.mojom.LanguagePacks_GetPackInfo_ParamsSpec.$,
    'LanguagePacks_GetPackInfo_Params',
    [
      mojo.internal.StructField(
        'featureId', 0,
        0,
        ash.language.mojom.FeatureIdSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'language', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.language.mojom.LanguagePacks_GetPackInfo_Params = class {
  constructor() {
    /** @export { !ash.language.mojom.FeatureId } */
    this.featureId;
    /** @export { !string } */
    this.language;
  }
};



mojo.internal.Struct(
    ash.language.mojom.LanguagePacks_GetPackInfo_ResponseParamsSpec.$,
    'LanguagePacks_GetPackInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        ash.language.mojom.LanguagePackInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.language.mojom.LanguagePacks_GetPackInfo_ResponseParams = class {
  constructor() {
    /** @export { !ash.language.mojom.LanguagePackInfo } */
    this.info;
  }
};



mojo.internal.Struct(
    ash.language.mojom.LanguagePacks_InstallPack_ParamsSpec.$,
    'LanguagePacks_InstallPack_Params',
    [
      mojo.internal.StructField(
        'featureId', 0,
        0,
        ash.language.mojom.FeatureIdSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'language', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.language.mojom.LanguagePacks_InstallPack_Params = class {
  constructor() {
    /** @export { !ash.language.mojom.FeatureId } */
    this.featureId;
    /** @export { !string } */
    this.language;
  }
};



mojo.internal.Struct(
    ash.language.mojom.LanguagePacks_InstallPack_ResponseParamsSpec.$,
    'LanguagePacks_InstallPack_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        ash.language.mojom.LanguagePackInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.language.mojom.LanguagePacks_InstallPack_ResponseParams = class {
  constructor() {
    /** @export { !ash.language.mojom.LanguagePackInfo } */
    this.info;
  }
};



mojo.internal.Struct(
    ash.language.mojom.LanguagePacks_InstallBasePack_ParamsSpec.$,
    'LanguagePacks_InstallBasePack_Params',
    [
      mojo.internal.StructField(
        'featureId', 0,
        0,
        ash.language.mojom.FeatureIdSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.language.mojom.LanguagePacks_InstallBasePack_Params = class {
  constructor() {
    /** @export { !ash.language.mojom.FeatureId } */
    this.featureId;
  }
};



mojo.internal.Struct(
    ash.language.mojom.LanguagePacks_InstallBasePack_ResponseParamsSpec.$,
    'LanguagePacks_InstallBasePack_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        ash.language.mojom.BasePackInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.language.mojom.LanguagePacks_InstallBasePack_ResponseParams = class {
  constructor() {
    /** @export { !ash.language.mojom.BasePackInfo } */
    this.info;
  }
};



mojo.internal.Struct(
    ash.language.mojom.LanguagePacks_UninstallPack_ParamsSpec.$,
    'LanguagePacks_UninstallPack_Params',
    [
      mojo.internal.StructField(
        'featureId', 0,
        0,
        ash.language.mojom.FeatureIdSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'language', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.language.mojom.LanguagePacks_UninstallPack_Params = class {
  constructor() {
    /** @export { !ash.language.mojom.FeatureId } */
    this.featureId;
    /** @export { !string } */
    this.language;
  }
};



mojo.internal.Struct(
    ash.language.mojom.LanguagePacks_UninstallPack_ResponseParamsSpec.$,
    'LanguagePacks_UninstallPack_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
ash.language.mojom.LanguagePacks_UninstallPack_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.language.mojom.LanguagePacks_AddObserver_ParamsSpec.$,
    'LanguagePacks_AddObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(ash.language.mojom.LanguagePacksObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.language.mojom.LanguagePacks_AddObserver_Params = class {
  constructor() {
    /** @export { !Object } */
    this.observer;
  }
};

