// chromeos/ash/components/language_packs/public/mojom/language_packs.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/ash/components/language_packs/public/mojom/language_packs.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ash.language.mojom');


  var FeatureId = {};
  FeatureId.UNSUPPORTED_UNKNOWN = 0;
  FeatureId.HANDWRITING_RECOGNITION = 1;
  FeatureId.TTS = 2;
  FeatureId.MIN_VALUE = 0;
  FeatureId.MAX_VALUE = 2;

  FeatureId.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  FeatureId.toKnownEnumValue = function(value) {
    return value;
  };

  FeatureId.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var PackState = {};
  PackState.ERROR = 0;
  PackState.NOT_INSTALLED = 1;
  PackState.INSTALLING = 2;
  PackState.INSTALLED = 3;
  PackState.UNKNOWN = 4;
  PackState.MIN_VALUE = 0;
  PackState.MAX_VALUE = 4;
  PackState.DEFAULT_VALUE = 4;

  PackState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  PackState.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  PackState.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ErrorCode = {};
  ErrorCode.kUnknown = 0;
  ErrorCode.kNone = 1;
  ErrorCode.kOther = 2;
  ErrorCode.kWrongId = 3;
  ErrorCode.kNeedReboot = 4;
  ErrorCode.kAllocation = 5;
  ErrorCode.MIN_VALUE = 0;
  ErrorCode.MAX_VALUE = 5;
  ErrorCode.DEFAULT_VALUE = 0;

  ErrorCode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  ErrorCode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  ErrorCode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function LanguagePackInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguagePackInfo.prototype.initDefaults_ = function() {
    this.packState = 0;
    this.error = 0;
    this.path = null;
    this.featureId = 0;
    this.locale = null;
  };
  LanguagePackInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguagePackInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 2, numBytes: 24},
      {version: 3, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePackInfo.packState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, PackState);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePackInfo.path
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;



    // version check LanguagePackInfo.error
    if (!messageValidator.isFieldInStructVersion(offset, 2))
      return validator.validationError.NONE;
    // validate LanguagePackInfo.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ErrorCode);
    if (err !== validator.validationError.NONE)
        return err;



    // version check LanguagePackInfo.featureId
    if (!messageValidator.isFieldInStructVersion(offset, 3))
      return validator.validationError.NONE;
    // validate LanguagePackInfo.featureId
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, FeatureId);
    if (err !== validator.validationError.NONE)
        return err;



    // version check LanguagePackInfo.locale
    if (!messageValidator.isFieldInStructVersion(offset, 3))
      return validator.validationError.NONE;
    // validate LanguagePackInfo.locale
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LanguagePackInfo.encodedSize = codec.kStructHeaderSize + 32;

  LanguagePackInfo.decode = function(decoder) {
    var packed;
    var val = new LanguagePackInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.packState =
        decoder.decodeStruct(new codec.Enum(PackState));
    if (version >= 2) {
      val.error =
          decoder.decodeStruct(new codec.Enum(ErrorCode));
    } else {
      val.error = null;
    }
    val.path =
        decoder.decodeStruct(codec.String);
    if (version >= 3) {
      val.featureId =
          decoder.decodeStruct(new codec.Enum(FeatureId));
    } else {
      val.featureId = null;
    }
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 3) {
      val.locale =
          decoder.decodeStruct(codec.String);
    } else {
      val.locale = null;
    }
    return val;
  };

  LanguagePackInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguagePackInfo.encodedSize);
    encoder.writeUint32(3);
    encoder.encodeStruct(codec.Int32, val.packState);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.encodeStruct(codec.String, val.path);
    encoder.encodeStruct(codec.Int32, val.featureId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.locale);
  };
  function BasePackInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BasePackInfo.prototype.initDefaults_ = function() {
    this.packState = 0;
    this.error = 0;
    this.path = null;
  };
  BasePackInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BasePackInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 2, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BasePackInfo.packState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, PackState);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BasePackInfo.path
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;



    // version check BasePackInfo.error
    if (!messageValidator.isFieldInStructVersion(offset, 2))
      return validator.validationError.NONE;
    // validate BasePackInfo.error
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ErrorCode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BasePackInfo.encodedSize = codec.kStructHeaderSize + 16;

  BasePackInfo.decode = function(decoder) {
    var packed;
    var val = new BasePackInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.packState =
        decoder.decodeStruct(new codec.Enum(PackState));
    if (version >= 2) {
      val.error =
          decoder.decodeStruct(new codec.Enum(ErrorCode));
    } else {
      val.error = null;
    }
    val.path =
        decoder.decodeStruct(codec.String);
    return val;
  };

  BasePackInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BasePackInfo.encodedSize);
    encoder.writeUint32(2);
    encoder.encodeStruct(codec.Int32, val.packState);
    encoder.encodeStruct(codec.Int32, val.error);
    encoder.encodeStruct(codec.String, val.path);
  };
  function LanguagePacksObserver_OnPackStateChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguagePacksObserver_OnPackStateChanged_Params.prototype.initDefaults_ = function() {
    this.info = null;
  };
  LanguagePacksObserver_OnPackStateChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguagePacksObserver_OnPackStateChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePacksObserver_OnPackStateChanged_Params.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, LanguagePackInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LanguagePacksObserver_OnPackStateChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  LanguagePacksObserver_OnPackStateChanged_Params.decode = function(decoder) {
    var packed;
    var val = new LanguagePacksObserver_OnPackStateChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(LanguagePackInfo);
    return val;
  };

  LanguagePacksObserver_OnPackStateChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguagePacksObserver_OnPackStateChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(LanguagePackInfo, val.info);
  };
  function LanguagePacks_GetPackInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguagePacks_GetPackInfo_Params.prototype.initDefaults_ = function() {
    this.featureId = 0;
    this.language = null;
  };
  LanguagePacks_GetPackInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguagePacks_GetPackInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePacks_GetPackInfo_Params.featureId
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, FeatureId);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePacks_GetPackInfo_Params.language
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LanguagePacks_GetPackInfo_Params.encodedSize = codec.kStructHeaderSize + 16;

  LanguagePacks_GetPackInfo_Params.decode = function(decoder) {
    var packed;
    var val = new LanguagePacks_GetPackInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.featureId =
        decoder.decodeStruct(new codec.Enum(FeatureId));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.language =
        decoder.decodeStruct(codec.String);
    return val;
  };

  LanguagePacks_GetPackInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguagePacks_GetPackInfo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.featureId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.language);
  };
  function LanguagePacks_GetPackInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguagePacks_GetPackInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.info = null;
  };
  LanguagePacks_GetPackInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguagePacks_GetPackInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePacks_GetPackInfo_ResponseParams.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, LanguagePackInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LanguagePacks_GetPackInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  LanguagePacks_GetPackInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new LanguagePacks_GetPackInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(LanguagePackInfo);
    return val;
  };

  LanguagePacks_GetPackInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguagePacks_GetPackInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(LanguagePackInfo, val.info);
  };
  function LanguagePacks_InstallPack_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguagePacks_InstallPack_Params.prototype.initDefaults_ = function() {
    this.featureId = 0;
    this.language = null;
  };
  LanguagePacks_InstallPack_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguagePacks_InstallPack_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePacks_InstallPack_Params.featureId
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, FeatureId);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePacks_InstallPack_Params.language
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LanguagePacks_InstallPack_Params.encodedSize = codec.kStructHeaderSize + 16;

  LanguagePacks_InstallPack_Params.decode = function(decoder) {
    var packed;
    var val = new LanguagePacks_InstallPack_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.featureId =
        decoder.decodeStruct(new codec.Enum(FeatureId));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.language =
        decoder.decodeStruct(codec.String);
    return val;
  };

  LanguagePacks_InstallPack_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguagePacks_InstallPack_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.featureId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.language);
  };
  function LanguagePacks_InstallPack_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguagePacks_InstallPack_ResponseParams.prototype.initDefaults_ = function() {
    this.info = null;
  };
  LanguagePacks_InstallPack_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguagePacks_InstallPack_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePacks_InstallPack_ResponseParams.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, LanguagePackInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LanguagePacks_InstallPack_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  LanguagePacks_InstallPack_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new LanguagePacks_InstallPack_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(LanguagePackInfo);
    return val;
  };

  LanguagePacks_InstallPack_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguagePacks_InstallPack_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(LanguagePackInfo, val.info);
  };
  function LanguagePacks_InstallBasePack_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguagePacks_InstallBasePack_Params.prototype.initDefaults_ = function() {
    this.featureId = 0;
  };
  LanguagePacks_InstallBasePack_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguagePacks_InstallBasePack_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePacks_InstallBasePack_Params.featureId
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, FeatureId);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LanguagePacks_InstallBasePack_Params.encodedSize = codec.kStructHeaderSize + 8;

  LanguagePacks_InstallBasePack_Params.decode = function(decoder) {
    var packed;
    var val = new LanguagePacks_InstallBasePack_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.featureId =
        decoder.decodeStruct(new codec.Enum(FeatureId));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LanguagePacks_InstallBasePack_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguagePacks_InstallBasePack_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.featureId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LanguagePacks_InstallBasePack_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguagePacks_InstallBasePack_ResponseParams.prototype.initDefaults_ = function() {
    this.info = null;
  };
  LanguagePacks_InstallBasePack_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguagePacks_InstallBasePack_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePacks_InstallBasePack_ResponseParams.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, BasePackInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LanguagePacks_InstallBasePack_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  LanguagePacks_InstallBasePack_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new LanguagePacks_InstallBasePack_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(BasePackInfo);
    return val;
  };

  LanguagePacks_InstallBasePack_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguagePacks_InstallBasePack_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(BasePackInfo, val.info);
  };
  function LanguagePacks_UninstallPack_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguagePacks_UninstallPack_Params.prototype.initDefaults_ = function() {
    this.featureId = 0;
    this.language = null;
  };
  LanguagePacks_UninstallPack_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguagePacks_UninstallPack_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePacks_UninstallPack_Params.featureId
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, FeatureId);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePacks_UninstallPack_Params.language
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LanguagePacks_UninstallPack_Params.encodedSize = codec.kStructHeaderSize + 16;

  LanguagePacks_UninstallPack_Params.decode = function(decoder) {
    var packed;
    var val = new LanguagePacks_UninstallPack_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.featureId =
        decoder.decodeStruct(new codec.Enum(FeatureId));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.language =
        decoder.decodeStruct(codec.String);
    return val;
  };

  LanguagePacks_UninstallPack_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguagePacks_UninstallPack_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.featureId);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.language);
  };
  function LanguagePacks_UninstallPack_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguagePacks_UninstallPack_ResponseParams.prototype.initDefaults_ = function() {
  };
  LanguagePacks_UninstallPack_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguagePacks_UninstallPack_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LanguagePacks_UninstallPack_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  LanguagePacks_UninstallPack_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new LanguagePacks_UninstallPack_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  LanguagePacks_UninstallPack_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguagePacks_UninstallPack_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function LanguagePacks_AddObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LanguagePacks_AddObserver_Params.prototype.initDefaults_ = function() {
    this.observer = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  LanguagePacks_AddObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LanguagePacks_AddObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LanguagePacks_AddObserver_Params.observer
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LanguagePacks_AddObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  LanguagePacks_AddObserver_Params.decode = function(decoder) {
    var packed;
    var val = new LanguagePacks_AddObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    return val;
  };

  LanguagePacks_AddObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LanguagePacks_AddObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.observer);
  };
  var kLanguagePacksObserver_OnPackStateChanged_Name = 0;

  function LanguagePacksObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(LanguagePacksObserver,
                                                   handleOrPtrInfo);
  }

  function LanguagePacksObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        LanguagePacksObserver, associatedInterfacePtrInfo);
  }

  LanguagePacksObserverAssociatedPtr.prototype =
      Object.create(LanguagePacksObserverPtr.prototype);
  LanguagePacksObserverAssociatedPtr.prototype.constructor =
      LanguagePacksObserverAssociatedPtr;

  function LanguagePacksObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  LanguagePacksObserverPtr.prototype.onPackStateChanged = function() {
    return LanguagePacksObserverProxy.prototype.onPackStateChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  LanguagePacksObserverProxy.prototype.onPackStateChanged = function(info) {
    var params_ = new LanguagePacksObserver_OnPackStateChanged_Params();
    params_.info = info;
    var builder = new codec.MessageV0Builder(
        kLanguagePacksObserver_OnPackStateChanged_Name,
        codec.align(LanguagePacksObserver_OnPackStateChanged_Params.encodedSize));
    builder.encodeStruct(LanguagePacksObserver_OnPackStateChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function LanguagePacksObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  LanguagePacksObserverStub.prototype.onPackStateChanged = function(info) {
    return this.delegate_ && this.delegate_.onPackStateChanged && this.delegate_.onPackStateChanged(info);
  }

  LanguagePacksObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kLanguagePacksObserver_OnPackStateChanged_Name:
      var params = reader.decodeStruct(LanguagePacksObserver_OnPackStateChanged_Params);
      this.onPackStateChanged(params.info);
      return true;
    default:
      return false;
    }
  };

  LanguagePacksObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateLanguagePacksObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kLanguagePacksObserver_OnPackStateChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LanguagePacksObserver_OnPackStateChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateLanguagePacksObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var LanguagePacksObserver = {
    name: 'ash.language.mojom.LanguagePacksObserver',
    kVersion: 0,
    ptrClass: LanguagePacksObserverPtr,
    proxyClass: LanguagePacksObserverProxy,
    stubClass: LanguagePacksObserverStub,
    validateRequest: validateLanguagePacksObserverRequest,
    validateResponse: null,
  };
  LanguagePacksObserverStub.prototype.validator = validateLanguagePacksObserverRequest;
  LanguagePacksObserverProxy.prototype.validator = null;
  var kLanguagePacks_GetPackInfo_Name = 0;
  var kLanguagePacks_InstallPack_Name = 1;
  var kLanguagePacks_InstallBasePack_Name = 2;
  var kLanguagePacks_UninstallPack_Name = 3;
  var kLanguagePacks_AddObserver_Name = 4;

  function LanguagePacksPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(LanguagePacks,
                                                   handleOrPtrInfo);
  }

  function LanguagePacksAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        LanguagePacks, associatedInterfacePtrInfo);
  }

  LanguagePacksAssociatedPtr.prototype =
      Object.create(LanguagePacksPtr.prototype);
  LanguagePacksAssociatedPtr.prototype.constructor =
      LanguagePacksAssociatedPtr;

  function LanguagePacksProxy(receiver) {
    this.receiver_ = receiver;
  }
  LanguagePacksPtr.prototype.getPackInfo = function() {
    return LanguagePacksProxy.prototype.getPackInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  LanguagePacksProxy.prototype.getPackInfo = function(featureId, language) {
    var params_ = new LanguagePacks_GetPackInfo_Params();
    params_.featureId = featureId;
    params_.language = language;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kLanguagePacks_GetPackInfo_Name,
          codec.align(LanguagePacks_GetPackInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(LanguagePacks_GetPackInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(LanguagePacks_GetPackInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  LanguagePacksPtr.prototype.installPack = function() {
    return LanguagePacksProxy.prototype.installPack
        .apply(this.ptr.getProxy(), arguments);
  };

  LanguagePacksProxy.prototype.installPack = function(featureId, language) {
    var params_ = new LanguagePacks_InstallPack_Params();
    params_.featureId = featureId;
    params_.language = language;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kLanguagePacks_InstallPack_Name,
          codec.align(LanguagePacks_InstallPack_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(LanguagePacks_InstallPack_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(LanguagePacks_InstallPack_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  LanguagePacksPtr.prototype.installBasePack = function() {
    return LanguagePacksProxy.prototype.installBasePack
        .apply(this.ptr.getProxy(), arguments);
  };

  LanguagePacksProxy.prototype.installBasePack = function(featureId) {
    var params_ = new LanguagePacks_InstallBasePack_Params();
    params_.featureId = featureId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kLanguagePacks_InstallBasePack_Name,
          codec.align(LanguagePacks_InstallBasePack_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(LanguagePacks_InstallBasePack_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(LanguagePacks_InstallBasePack_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  LanguagePacksPtr.prototype.uninstallPack = function() {
    return LanguagePacksProxy.prototype.uninstallPack
        .apply(this.ptr.getProxy(), arguments);
  };

  LanguagePacksProxy.prototype.uninstallPack = function(featureId, language) {
    var params_ = new LanguagePacks_UninstallPack_Params();
    params_.featureId = featureId;
    params_.language = language;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kLanguagePacks_UninstallPack_Name,
          codec.align(LanguagePacks_UninstallPack_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(LanguagePacks_UninstallPack_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(LanguagePacks_UninstallPack_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  LanguagePacksPtr.prototype.addObserver = function() {
    return LanguagePacksProxy.prototype.addObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  LanguagePacksProxy.prototype.addObserver = function(observer) {
    var params_ = new LanguagePacks_AddObserver_Params();
    params_.observer = observer;
    var builder = new codec.MessageV2Builder(
        kLanguagePacks_AddObserver_Name,
        codec.align(LanguagePacks_AddObserver_Params.encodedSize));
    builder.setPayload(LanguagePacks_AddObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function LanguagePacksStub(delegate) {
    this.delegate_ = delegate;
  }
  LanguagePacksStub.prototype.getPackInfo = function(featureId, language) {
    return this.delegate_ && this.delegate_.getPackInfo && this.delegate_.getPackInfo(featureId, language);
  }
  LanguagePacksStub.prototype.installPack = function(featureId, language) {
    return this.delegate_ && this.delegate_.installPack && this.delegate_.installPack(featureId, language);
  }
  LanguagePacksStub.prototype.installBasePack = function(featureId) {
    return this.delegate_ && this.delegate_.installBasePack && this.delegate_.installBasePack(featureId);
  }
  LanguagePacksStub.prototype.uninstallPack = function(featureId, language) {
    return this.delegate_ && this.delegate_.uninstallPack && this.delegate_.uninstallPack(featureId, language);
  }
  LanguagePacksStub.prototype.addObserver = function(observer) {
    return this.delegate_ && this.delegate_.addObserver && this.delegate_.addObserver(observer);
  }

  LanguagePacksStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kLanguagePacks_AddObserver_Name:
      var params = reader.decodeStruct(LanguagePacks_AddObserver_Params);
      this.addObserver(params.observer);
      return true;
    default:
      return false;
    }
  };

  LanguagePacksStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kLanguagePacks_GetPackInfo_Name:
      var params = reader.decodeStruct(LanguagePacks_GetPackInfo_Params);
      this.getPackInfo(params.featureId, params.language).then(function(response) {
        var responseParams =
            new LanguagePacks_GetPackInfo_ResponseParams();
        responseParams.info = response.info;
        var builder = new codec.MessageV1Builder(
            kLanguagePacks_GetPackInfo_Name,
            codec.align(LanguagePacks_GetPackInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(LanguagePacks_GetPackInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kLanguagePacks_InstallPack_Name:
      var params = reader.decodeStruct(LanguagePacks_InstallPack_Params);
      this.installPack(params.featureId, params.language).then(function(response) {
        var responseParams =
            new LanguagePacks_InstallPack_ResponseParams();
        responseParams.info = response.info;
        var builder = new codec.MessageV1Builder(
            kLanguagePacks_InstallPack_Name,
            codec.align(LanguagePacks_InstallPack_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(LanguagePacks_InstallPack_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kLanguagePacks_InstallBasePack_Name:
      var params = reader.decodeStruct(LanguagePacks_InstallBasePack_Params);
      this.installBasePack(params.featureId).then(function(response) {
        var responseParams =
            new LanguagePacks_InstallBasePack_ResponseParams();
        responseParams.info = response.info;
        var builder = new codec.MessageV1Builder(
            kLanguagePacks_InstallBasePack_Name,
            codec.align(LanguagePacks_InstallBasePack_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(LanguagePacks_InstallBasePack_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kLanguagePacks_UninstallPack_Name:
      var params = reader.decodeStruct(LanguagePacks_UninstallPack_Params);
      this.uninstallPack(params.featureId, params.language).then(function(response) {
        var responseParams =
            new LanguagePacks_UninstallPack_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kLanguagePacks_UninstallPack_Name,
            codec.align(LanguagePacks_UninstallPack_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(LanguagePacks_UninstallPack_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateLanguagePacksRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kLanguagePacks_GetPackInfo_Name:
        if (message.expectsResponse())
          paramsClass = LanguagePacks_GetPackInfo_Params;
      break;
      case kLanguagePacks_InstallPack_Name:
        if (message.expectsResponse())
          paramsClass = LanguagePacks_InstallPack_Params;
      break;
      case kLanguagePacks_InstallBasePack_Name:
        if (message.expectsResponse())
          paramsClass = LanguagePacks_InstallBasePack_Params;
      break;
      case kLanguagePacks_UninstallPack_Name:
        if (message.expectsResponse())
          paramsClass = LanguagePacks_UninstallPack_Params;
      break;
      case kLanguagePacks_AddObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LanguagePacks_AddObserver_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateLanguagePacksResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kLanguagePacks_GetPackInfo_Name:
        if (message.isResponse())
          paramsClass = LanguagePacks_GetPackInfo_ResponseParams;
        break;
      case kLanguagePacks_InstallPack_Name:
        if (message.isResponse())
          paramsClass = LanguagePacks_InstallPack_ResponseParams;
        break;
      case kLanguagePacks_InstallBasePack_Name:
        if (message.isResponse())
          paramsClass = LanguagePacks_InstallBasePack_ResponseParams;
        break;
      case kLanguagePacks_UninstallPack_Name:
        if (message.isResponse())
          paramsClass = LanguagePacks_UninstallPack_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var LanguagePacks = {
    name: 'ash.language.mojom.LanguagePacks',
    kVersion: 1,
    ptrClass: LanguagePacksPtr,
    proxyClass: LanguagePacksProxy,
    stubClass: LanguagePacksStub,
    validateRequest: validateLanguagePacksRequest,
    validateResponse: validateLanguagePacksResponse,
  };
  LanguagePacksStub.prototype.validator = validateLanguagePacksRequest;
  LanguagePacksProxy.prototype.validator = validateLanguagePacksResponse;
  exports.FeatureId = FeatureId;
  exports.PackState = PackState;
  exports.ErrorCode = ErrorCode;
  exports.LanguagePackInfo = LanguagePackInfo;
  exports.BasePackInfo = BasePackInfo;
  exports.LanguagePacksObserver = LanguagePacksObserver;
  exports.LanguagePacksObserverPtr = LanguagePacksObserverPtr;
  exports.LanguagePacksObserverAssociatedPtr = LanguagePacksObserverAssociatedPtr;
  exports.LanguagePacks = LanguagePacks;
  exports.LanguagePacksPtr = LanguagePacksPtr;
  exports.LanguagePacksAssociatedPtr = LanguagePacksAssociatedPtr;
})();