// chromeos/ash/components/language_packs/public/mojom/language_packs.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FeatureIdSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FeatureId = {
  
  UNSUPPORTED_UNKNOWN: 0,
  HANDWRITING_RECOGNITION: 1,
  TTS: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PackStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PackState = {
  
  ERROR: 0,
  NOT_INSTALLED: 1,
  INSTALLING: 2,
  INSTALLED: 3,
  UNKNOWN: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ErrorCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ErrorCode = {
  
  kUnknown: 0,
  kNone: 1,
  kOther: 2,
  kWrongId: 3,
  kNeedReboot: 4,
  kAllocation: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class LanguagePacksObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.language.mojom.LanguagePacksObserver', scope);
  }
}

/** @interface */
export class LanguagePacksObserverInterface {
  
  /**
   * @param { !LanguagePackInfo } info
   */

  onPackStateChanged(info) {}
}

/**
 * @implements { LanguagePacksObserverInterface }
 */
export class LanguagePacksObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!LanguagePacksObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LanguagePacksObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!LanguagePacksObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !LanguagePackInfo } info
   */

  onPackStateChanged(
      info) {
    this.proxy.sendMessage(
        0,
        LanguagePacksObserver_OnPackStateChanged_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }
}

/**
 * An object which receives request messages for the LanguagePacksObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LanguagePacksObserverReceiver {
  /**
   * @param {!LanguagePacksObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!LanguagePacksObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LanguagePacksObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LanguagePacksObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LanguagePacksObserver_OnPackStateChanged_ParamsSpec.$,
        null,
        impl.onPackStateChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LanguagePacksObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.language.mojom.LanguagePacksObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!LanguagePacksObserverRemote}
   */
  static getRemote() {
    let remote = new LanguagePacksObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the LanguagePacksObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LanguagePacksObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LanguagePacksObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LanguagePacksObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPackStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LanguagePacksObserver_OnPackStateChanged_ParamsSpec.$,
        null,
        this.onPackStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class LanguagePacksPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.language.mojom.LanguagePacks', scope);
  }
}

/** @interface */
export class LanguagePacksInterface {
  
  /**
   * @param { !FeatureId } featureId
   * @param { !string } language
   * @return {!Promise<{
        info: !LanguagePackInfo,
   *  }>}
   */

  getPackInfo(featureId, language) {}
  
  /**
   * @param { !FeatureId } featureId
   * @param { !string } language
   * @return {!Promise<{
        info: !LanguagePackInfo,
   *  }>}
   */

  installPack(featureId, language) {}
  
  /**
   * @param { !FeatureId } featureId
   * @return {!Promise<{
        info: !BasePackInfo,
   *  }>}
   */

  installBasePack(featureId) {}
  
  /**
   * @param { !FeatureId } featureId
   * @param { !string } language
   * @return {!Promise}
   */

  uninstallPack(featureId, language) {}
  
  /**
   * @param { !Object } observer
   */

  addObserver(observer) {}
}

/**
 * @implements { LanguagePacksInterface }
 */
export class LanguagePacksRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!LanguagePacksPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LanguagePacksPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!LanguagePacksPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !FeatureId } featureId
   * @param { !string } language
   * @return {!Promise<{
        info: !LanguagePackInfo,
   *  }>}
   */

  getPackInfo(
      featureId,
      language) {
    return this.proxy.sendMessage(
        0,
        LanguagePacks_GetPackInfo_ParamsSpec.$,
        LanguagePacks_GetPackInfo_ResponseParamsSpec.$,
        [
          featureId,
          language
        ],
        false);
  }

  
  /**
   * @param { !FeatureId } featureId
   * @param { !string } language
   * @return {!Promise<{
        info: !LanguagePackInfo,
   *  }>}
   */

  installPack(
      featureId,
      language) {
    return this.proxy.sendMessage(
        1,
        LanguagePacks_InstallPack_ParamsSpec.$,
        LanguagePacks_InstallPack_ResponseParamsSpec.$,
        [
          featureId,
          language
        ],
        false);
  }

  
  /**
   * @param { !FeatureId } featureId
   * @return {!Promise<{
        info: !BasePackInfo,
   *  }>}
   */

  installBasePack(
      featureId) {
    return this.proxy.sendMessage(
        2,
        LanguagePacks_InstallBasePack_ParamsSpec.$,
        LanguagePacks_InstallBasePack_ResponseParamsSpec.$,
        [
          featureId
        ],
        false);
  }

  
  /**
   * @param { !FeatureId } featureId
   * @param { !string } language
   * @return {!Promise}
   */

  uninstallPack(
      featureId,
      language) {
    return this.proxy.sendMessage(
        3,
        LanguagePacks_UninstallPack_ParamsSpec.$,
        LanguagePacks_UninstallPack_ResponseParamsSpec.$,
        [
          featureId,
          language
        ],
        false);
  }

  
  /**
   * @param { !Object } observer
   */

  addObserver(
      observer) {
    this.proxy.sendMessage(
        4,
        LanguagePacks_AddObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the LanguagePacks
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LanguagePacksReceiver {
  /**
   * @param {!LanguagePacksInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!LanguagePacksRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LanguagePacksRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LanguagePacksRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LanguagePacks_GetPackInfo_ParamsSpec.$,
        LanguagePacks_GetPackInfo_ResponseParamsSpec.$,
        impl.getPackInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        LanguagePacks_InstallPack_ParamsSpec.$,
        LanguagePacks_InstallPack_ResponseParamsSpec.$,
        impl.installPack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        LanguagePacks_InstallBasePack_ParamsSpec.$,
        LanguagePacks_InstallBasePack_ResponseParamsSpec.$,
        impl.installBasePack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        LanguagePacks_UninstallPack_ParamsSpec.$,
        LanguagePacks_UninstallPack_ResponseParamsSpec.$,
        impl.uninstallPack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        LanguagePacks_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LanguagePacks {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.language.mojom.LanguagePacks";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!LanguagePacksRemote}
   */
  static getRemote() {
    let remote = new LanguagePacksRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the LanguagePacks
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LanguagePacksCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LanguagePacksRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LanguagePacksRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPackInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LanguagePacks_GetPackInfo_ParamsSpec.$,
        LanguagePacks_GetPackInfo_ResponseParamsSpec.$,
        this.getPackInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.installPack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        LanguagePacks_InstallPack_ParamsSpec.$,
        LanguagePacks_InstallPack_ResponseParamsSpec.$,
        this.installPack.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.installBasePack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        LanguagePacks_InstallBasePack_ParamsSpec.$,
        LanguagePacks_InstallBasePack_ResponseParamsSpec.$,
        this.installBasePack.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.uninstallPack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        LanguagePacks_UninstallPack_ParamsSpec.$,
        LanguagePacks_UninstallPack_ResponseParamsSpec.$,
        this.uninstallPack.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        LanguagePacks_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguagePackInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BasePackInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguagePacksObserver_OnPackStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguagePacks_GetPackInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguagePacks_GetPackInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguagePacks_InstallPack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguagePacks_InstallPack_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguagePacks_InstallBasePack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguagePacks_InstallBasePack_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguagePacks_UninstallPack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguagePacks_UninstallPack_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LanguagePacks_AddObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    LanguagePackInfoSpec.$,
    'LanguagePackInfo',
    [
      mojo.internal.StructField(
        'packState', 0,
        0,
        PackStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'path', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 4,
        0,
        ErrorCodeSpec.$,
        0,
        false /* nullable */,
        2,
      ),
      mojo.internal.StructField(
        'featureId', 16,
        0,
        FeatureIdSpec.$,
        0,
        false /* nullable */,
        3,
      ),
      mojo.internal.StructField(
        'locale', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        3,
      ),
    ],
    [[0, 24],[2, 24],[3, 40],]);



/**
 * @record
 */
export class LanguagePackInfo {
  constructor() {
    /** @type { !PackState } */
    this.packState;
    /** @type { !string } */
    this.path;
    /** @type { !ErrorCode } */
    this.error;
    /** @type { !FeatureId } */
    this.featureId;
    /** @type { (string|undefined) } */
    this.locale;
  }
}



mojo.internal.Struct(
    BasePackInfoSpec.$,
    'BasePackInfo',
    [
      mojo.internal.StructField(
        'packState', 0,
        0,
        PackStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'path', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 4,
        0,
        ErrorCodeSpec.$,
        0,
        false /* nullable */,
        2,
      ),
    ],
    [[0, 24],[2, 24],]);



/**
 * @record
 */
export class BasePackInfo {
  constructor() {
    /** @type { !PackState } */
    this.packState;
    /** @type { !string } */
    this.path;
    /** @type { !ErrorCode } */
    this.error;
  }
}



mojo.internal.Struct(
    LanguagePacksObserver_OnPackStateChanged_ParamsSpec.$,
    'LanguagePacksObserver_OnPackStateChanged_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        LanguagePackInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LanguagePacksObserver_OnPackStateChanged_Params {
  constructor() {
    /** @type { !LanguagePackInfo } */
    this.info;
  }
}



mojo.internal.Struct(
    LanguagePacks_GetPackInfo_ParamsSpec.$,
    'LanguagePacks_GetPackInfo_Params',
    [
      mojo.internal.StructField(
        'featureId', 0,
        0,
        FeatureIdSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'language', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LanguagePacks_GetPackInfo_Params {
  constructor() {
    /** @type { !FeatureId } */
    this.featureId;
    /** @type { !string } */
    this.language;
  }
}



mojo.internal.Struct(
    LanguagePacks_GetPackInfo_ResponseParamsSpec.$,
    'LanguagePacks_GetPackInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        LanguagePackInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LanguagePacks_GetPackInfo_ResponseParams {
  constructor() {
    /** @type { !LanguagePackInfo } */
    this.info;
  }
}



mojo.internal.Struct(
    LanguagePacks_InstallPack_ParamsSpec.$,
    'LanguagePacks_InstallPack_Params',
    [
      mojo.internal.StructField(
        'featureId', 0,
        0,
        FeatureIdSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'language', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LanguagePacks_InstallPack_Params {
  constructor() {
    /** @type { !FeatureId } */
    this.featureId;
    /** @type { !string } */
    this.language;
  }
}



mojo.internal.Struct(
    LanguagePacks_InstallPack_ResponseParamsSpec.$,
    'LanguagePacks_InstallPack_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        LanguagePackInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LanguagePacks_InstallPack_ResponseParams {
  constructor() {
    /** @type { !LanguagePackInfo } */
    this.info;
  }
}



mojo.internal.Struct(
    LanguagePacks_InstallBasePack_ParamsSpec.$,
    'LanguagePacks_InstallBasePack_Params',
    [
      mojo.internal.StructField(
        'featureId', 0,
        0,
        FeatureIdSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LanguagePacks_InstallBasePack_Params {
  constructor() {
    /** @type { !FeatureId } */
    this.featureId;
  }
}



mojo.internal.Struct(
    LanguagePacks_InstallBasePack_ResponseParamsSpec.$,
    'LanguagePacks_InstallBasePack_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        BasePackInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LanguagePacks_InstallBasePack_ResponseParams {
  constructor() {
    /** @type { !BasePackInfo } */
    this.info;
  }
}



mojo.internal.Struct(
    LanguagePacks_UninstallPack_ParamsSpec.$,
    'LanguagePacks_UninstallPack_Params',
    [
      mojo.internal.StructField(
        'featureId', 0,
        0,
        FeatureIdSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'language', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LanguagePacks_UninstallPack_Params {
  constructor() {
    /** @type { !FeatureId } */
    this.featureId;
    /** @type { !string } */
    this.language;
  }
}



mojo.internal.Struct(
    LanguagePacks_UninstallPack_ResponseParamsSpec.$,
    'LanguagePacks_UninstallPack_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class LanguagePacks_UninstallPack_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    LanguagePacks_AddObserver_ParamsSpec.$,
    'LanguagePacks_AddObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(LanguagePacksObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LanguagePacks_AddObserver_Params {
  constructor() {
    /** @type { !Object } */
    this.observer;
  }
}

