// chromeos/ash/components/mantis/mojom/mantis_processor.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');





goog.provide('mantis.mojom.MantisError');
goog.provide('mantis.mojom.MantisErrorSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mantis.mojom.MantisErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mantis.mojom.MantisError = {
  
  kUnknownError: 0,
  kProcessorNotInitialized: 1,
  kInputError: 2,
  kProcessFailed: 3,
  kMissingSegmenter: 4,
  kInputSafetyError: 5,
  kOutputSafetyError: 6,
  kPromptSafetyError: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

goog.provide('mantis.mojom.SafetyClassifierVerdict');
goog.provide('mantis.mojom.SafetyClassifierVerdictSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mantis.mojom.SafetyClassifierVerdictSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mantis.mojom.SafetyClassifierVerdict = {
  
  kPass: 0,
  kFail: 1,
  kFailedText: 2,
  kFailedImage: 3,
  kServiceNotAvailable: 4,
  kNoInternetConnection: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

goog.provide('mantis.mojom.SegmentationMode');
goog.provide('mantis.mojom.SegmentationModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mantis.mojom.SegmentationModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mantis.mojom.SegmentationMode = {
  
  kScribble: 0,
  kLasso: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('mantis.mojom.MantisProcessor');
goog.provide('mantis.mojom.MantisProcessorReceiver');
goog.provide('mantis.mojom.MantisProcessorCallbackRouter');
goog.provide('mantis.mojom.MantisProcessorInterface');
goog.provide('mantis.mojom.MantisProcessorRemote');
goog.provide('mantis.mojom.MantisProcessorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
mantis.mojom.MantisProcessorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        mantis.mojom.MantisProcessor.$interfaceName,
        scope);
  }
};

/** @interface */
mantis.mojom.MantisProcessorInterface = class {
  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } mask
   * @param { !number } seed
   * @return {!Promise<{
        result: !mantis.mojom.MantisResult,
   *  }>}
   */

  inpainting(image, mask, seed) {}
  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } mask
   * @param { !number } seed
   * @param { !string } prompt
   * @return {!Promise<{
        result: !mantis.mojom.MantisResult,
   *  }>}
   */

  generativeFill(image, mask, seed, prompt) {}
  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } prior
   * @return {!Promise<{
        result: !mantis.mojom.MantisResult,
   *  }>}
   */

  segmentation(image, prior) {}
  
  /**
   * @param { !Array<!number> } image
   * @return {!Promise<{
        verdict: !mantis.mojom.SafetyClassifierVerdict,
   *  }>}
   */

  classifyImageSafety(image) {}
  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } mask
   * @param { !number } seed
   * @return {!Promise<{
        result: !mantis.mojom.MantisResult,
   *  }>}
   */

  outpainting(image, mask, seed) {}
  
  /**
   * @param { !Array<!mantis.mojom.TouchPoint> } gesture
   * @return {!Promise<{
        mode: !mantis.mojom.SegmentationMode,
   *  }>}
   */

  inferSegmentationMode(gesture) {}
};

/**
 * @export
 * @implements { mantis.mojom.MantisProcessorInterface }
 */
mantis.mojom.MantisProcessorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!mantis.mojom.MantisProcessorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          mantis.mojom.MantisProcessorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!mantis.mojom.MantisProcessorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } mask
   * @param { !number } seed
   * @return {!Promise<{
        result: !mantis.mojom.MantisResult,
   *  }>}
   */

  inpainting(
      image,
      mask,
      seed) {
    return this.proxy.sendMessage(
        0,
        mantis.mojom.MantisProcessor_Inpainting_ParamsSpec.$,
        mantis.mojom.MantisProcessor_Inpainting_ResponseParamsSpec.$,
        [
          image,
          mask,
          seed
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } mask
   * @param { !number } seed
   * @param { !string } prompt
   * @return {!Promise<{
        result: !mantis.mojom.MantisResult,
   *  }>}
   */

  generativeFill(
      image,
      mask,
      seed,
      prompt) {
    return this.proxy.sendMessage(
        1,
        mantis.mojom.MantisProcessor_GenerativeFill_ParamsSpec.$,
        mantis.mojom.MantisProcessor_GenerativeFill_ResponseParamsSpec.$,
        [
          image,
          mask,
          seed,
          prompt
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } prior
   * @return {!Promise<{
        result: !mantis.mojom.MantisResult,
   *  }>}
   */

  segmentation(
      image,
      prior) {
    return this.proxy.sendMessage(
        2,
        mantis.mojom.MantisProcessor_Segmentation_ParamsSpec.$,
        mantis.mojom.MantisProcessor_Segmentation_ResponseParamsSpec.$,
        [
          image,
          prior
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } image
   * @return {!Promise<{
        verdict: !mantis.mojom.SafetyClassifierVerdict,
   *  }>}
   */

  classifyImageSafety(
      image) {
    return this.proxy.sendMessage(
        3,
        mantis.mojom.MantisProcessor_ClassifyImageSafety_ParamsSpec.$,
        mantis.mojom.MantisProcessor_ClassifyImageSafety_ResponseParamsSpec.$,
        [
          image
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } mask
   * @param { !number } seed
   * @return {!Promise<{
        result: !mantis.mojom.MantisResult,
   *  }>}
   */

  outpainting(
      image,
      mask,
      seed) {
    return this.proxy.sendMessage(
        4,
        mantis.mojom.MantisProcessor_Outpainting_ParamsSpec.$,
        mantis.mojom.MantisProcessor_Outpainting_ResponseParamsSpec.$,
        [
          image,
          mask,
          seed
        ],
        false);
  }

  
  /**
   * @param { !Array<!mantis.mojom.TouchPoint> } gesture
   * @return {!Promise<{
        mode: !mantis.mojom.SegmentationMode,
   *  }>}
   */

  inferSegmentationMode(
      gesture) {
    return this.proxy.sendMessage(
        5,
        mantis.mojom.MantisProcessor_InferSegmentationMode_ParamsSpec.$,
        mantis.mojom.MantisProcessor_InferSegmentationMode_ResponseParamsSpec.$,
        [
          gesture
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MantisProcessor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
mantis.mojom.MantisProcessorReceiver = class {
  /**
   * @param {!mantis.mojom.MantisProcessorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!mantis.mojom.MantisProcessorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        mantis.mojom.MantisProcessorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mantis.mojom.MantisProcessorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        mantis.mojom.MantisProcessor_Inpainting_ParamsSpec.$,
        mantis.mojom.MantisProcessor_Inpainting_ResponseParamsSpec.$,
        impl.inpainting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        mantis.mojom.MantisProcessor_GenerativeFill_ParamsSpec.$,
        mantis.mojom.MantisProcessor_GenerativeFill_ResponseParamsSpec.$,
        impl.generativeFill.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        mantis.mojom.MantisProcessor_Segmentation_ParamsSpec.$,
        mantis.mojom.MantisProcessor_Segmentation_ResponseParamsSpec.$,
        impl.segmentation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        mantis.mojom.MantisProcessor_ClassifyImageSafety_ParamsSpec.$,
        mantis.mojom.MantisProcessor_ClassifyImageSafety_ResponseParamsSpec.$,
        impl.classifyImageSafety.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        mantis.mojom.MantisProcessor_Outpainting_ParamsSpec.$,
        mantis.mojom.MantisProcessor_Outpainting_ResponseParamsSpec.$,
        impl.outpainting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        mantis.mojom.MantisProcessor_InferSegmentationMode_ParamsSpec.$,
        mantis.mojom.MantisProcessor_InferSegmentationMode_ResponseParamsSpec.$,
        impl.inferSegmentationMode.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
mantis.mojom.MantisProcessor = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "mantis.mojom.MantisProcessor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!mantis.mojom.MantisProcessorRemote}
   * @export
   */
  static getRemote() {
    let remote = new mantis.mojom.MantisProcessorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MantisProcessor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
mantis.mojom.MantisProcessorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      mantis.mojom.MantisProcessorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mantis.mojom.MantisProcessorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.inpainting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        mantis.mojom.MantisProcessor_Inpainting_ParamsSpec.$,
        mantis.mojom.MantisProcessor_Inpainting_ResponseParamsSpec.$,
        this.inpainting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.generativeFill =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        mantis.mojom.MantisProcessor_GenerativeFill_ParamsSpec.$,
        mantis.mojom.MantisProcessor_GenerativeFill_ResponseParamsSpec.$,
        this.generativeFill.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.segmentation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        mantis.mojom.MantisProcessor_Segmentation_ParamsSpec.$,
        mantis.mojom.MantisProcessor_Segmentation_ResponseParamsSpec.$,
        this.segmentation.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.classifyImageSafety =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        mantis.mojom.MantisProcessor_ClassifyImageSafety_ParamsSpec.$,
        mantis.mojom.MantisProcessor_ClassifyImageSafety_ResponseParamsSpec.$,
        this.classifyImageSafety.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.outpainting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        mantis.mojom.MantisProcessor_Outpainting_ParamsSpec.$,
        mantis.mojom.MantisProcessor_Outpainting_ResponseParamsSpec.$,
        this.outpainting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.inferSegmentationMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        mantis.mojom.MantisProcessor_InferSegmentationMode_ParamsSpec.$,
        mantis.mojom.MantisProcessor_InferSegmentationMode_ResponseParamsSpec.$,
        this.inferSegmentationMode.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('mantis.mojom.TouchPointSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.TouchPointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisProcessor_Inpainting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisProcessor_Inpainting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisProcessor_Inpainting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisProcessor_Inpainting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisProcessor_GenerativeFill_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisProcessor_GenerativeFill_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisProcessor_GenerativeFill_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisProcessor_GenerativeFill_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisProcessor_Segmentation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisProcessor_Segmentation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisProcessor_Segmentation_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisProcessor_Segmentation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisProcessor_ClassifyImageSafety_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisProcessor_ClassifyImageSafety_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisProcessor_ClassifyImageSafety_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisProcessor_ClassifyImageSafety_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisProcessor_Outpainting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisProcessor_Outpainting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisProcessor_Outpainting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisProcessor_Outpainting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisProcessor_InferSegmentationMode_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisProcessor_InferSegmentationMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisProcessor_InferSegmentationMode_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisProcessor_InferSegmentationMode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
mantis.mojom.MantisResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    mantis.mojom.TouchPointSpec.$,
    'TouchPoint',
    [
      mojo.internal.StructField(
        'x', 0,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'y', 4,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('mantis.mojom.TouchPoint');

/** @record */
mantis.mojom.TouchPoint = class {
  constructor() {
    /** @export { !number } */
    this.x;
    /** @export { !number } */
    this.y;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisProcessor_Inpainting_ParamsSpec.$,
    'MantisProcessor_Inpainting_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mask', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'seed', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('mantis.mojom.MantisProcessor_Inpainting_Params');

/** @record */
mantis.mojom.MantisProcessor_Inpainting_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.image;
    /** @export { !Array<!number> } */
    this.mask;
    /** @export { !number } */
    this.seed;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisProcessor_Inpainting_ResponseParamsSpec.$,
    'MantisProcessor_Inpainting_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mantis.mojom.MantisResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('mantis.mojom.MantisProcessor_Inpainting_ResponseParams');

/** @record */
mantis.mojom.MantisProcessor_Inpainting_ResponseParams = class {
  constructor() {
    /** @export { !mantis.mojom.MantisResult } */
    this.result;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisProcessor_GenerativeFill_ParamsSpec.$,
    'MantisProcessor_GenerativeFill_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mask', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'seed', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'prompt', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('mantis.mojom.MantisProcessor_GenerativeFill_Params');

/** @record */
mantis.mojom.MantisProcessor_GenerativeFill_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.image;
    /** @export { !Array<!number> } */
    this.mask;
    /** @export { !number } */
    this.seed;
    /** @export { !string } */
    this.prompt;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisProcessor_GenerativeFill_ResponseParamsSpec.$,
    'MantisProcessor_GenerativeFill_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mantis.mojom.MantisResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('mantis.mojom.MantisProcessor_GenerativeFill_ResponseParams');

/** @record */
mantis.mojom.MantisProcessor_GenerativeFill_ResponseParams = class {
  constructor() {
    /** @export { !mantis.mojom.MantisResult } */
    this.result;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisProcessor_Segmentation_ParamsSpec.$,
    'MantisProcessor_Segmentation_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'prior', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('mantis.mojom.MantisProcessor_Segmentation_Params');

/** @record */
mantis.mojom.MantisProcessor_Segmentation_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.image;
    /** @export { !Array<!number> } */
    this.prior;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisProcessor_Segmentation_ResponseParamsSpec.$,
    'MantisProcessor_Segmentation_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mantis.mojom.MantisResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('mantis.mojom.MantisProcessor_Segmentation_ResponseParams');

/** @record */
mantis.mojom.MantisProcessor_Segmentation_ResponseParams = class {
  constructor() {
    /** @export { !mantis.mojom.MantisResult } */
    this.result;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisProcessor_ClassifyImageSafety_ParamsSpec.$,
    'MantisProcessor_ClassifyImageSafety_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('mantis.mojom.MantisProcessor_ClassifyImageSafety_Params');

/** @record */
mantis.mojom.MantisProcessor_ClassifyImageSafety_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.image;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisProcessor_ClassifyImageSafety_ResponseParamsSpec.$,
    'MantisProcessor_ClassifyImageSafety_ResponseParams',
    [
      mojo.internal.StructField(
        'verdict', 0,
        0,
        mantis.mojom.SafetyClassifierVerdictSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('mantis.mojom.MantisProcessor_ClassifyImageSafety_ResponseParams');

/** @record */
mantis.mojom.MantisProcessor_ClassifyImageSafety_ResponseParams = class {
  constructor() {
    /** @export { !mantis.mojom.SafetyClassifierVerdict } */
    this.verdict;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisProcessor_Outpainting_ParamsSpec.$,
    'MantisProcessor_Outpainting_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mask', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'seed', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('mantis.mojom.MantisProcessor_Outpainting_Params');

/** @record */
mantis.mojom.MantisProcessor_Outpainting_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.image;
    /** @export { !Array<!number> } */
    this.mask;
    /** @export { !number } */
    this.seed;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisProcessor_Outpainting_ResponseParamsSpec.$,
    'MantisProcessor_Outpainting_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mantis.mojom.MantisResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('mantis.mojom.MantisProcessor_Outpainting_ResponseParams');

/** @record */
mantis.mojom.MantisProcessor_Outpainting_ResponseParams = class {
  constructor() {
    /** @export { !mantis.mojom.MantisResult } */
    this.result;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisProcessor_InferSegmentationMode_ParamsSpec.$,
    'MantisProcessor_InferSegmentationMode_Params',
    [
      mojo.internal.StructField(
        'gesture', 0,
        0,
        mojo.internal.Array(mantis.mojom.TouchPointSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('mantis.mojom.MantisProcessor_InferSegmentationMode_Params');

/** @record */
mantis.mojom.MantisProcessor_InferSegmentationMode_Params = class {
  constructor() {
    /** @export { !Array<!mantis.mojom.TouchPoint> } */
    this.gesture;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisProcessor_InferSegmentationMode_ResponseParamsSpec.$,
    'MantisProcessor_InferSegmentationMode_ResponseParams',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        mantis.mojom.SegmentationModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('mantis.mojom.MantisProcessor_InferSegmentationMode_ResponseParams');

/** @record */
mantis.mojom.MantisProcessor_InferSegmentationMode_ResponseParams = class {
  constructor() {
    /** @export { !mantis.mojom.SegmentationMode } */
    this.mode;
  }
};

goog.provide('mantis.mojom.MantisResult');


mojo.internal.Union(
    mantis.mojom.MantisResultSpec.$, 'MantisResult',
    {
      'error': {
        'ordinal': 0,
        'type': mantis.mojom.MantisErrorSpec.$,
      },
      'resultImage': {
        'ordinal': 1,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
      },
    });

/**
 * @typedef { {
 *   error: (!mantis.mojom.MantisError|undefined),
 *   resultImage: (!Array<!number>|undefined),
 * } }
 */
mantis.mojom.MantisResult;
