// chromeos/ash/components/mantis/mojom/mantis_processor.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/ash/components/mantis/mojom/mantis_processor.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('mantis.mojom');


  var MantisError = {};
  MantisError.kUnknownError = 0;
  MantisError.kProcessorNotInitialized = 1;
  MantisError.kInputError = 2;
  MantisError.kProcessFailed = 3;
  MantisError.kMissingSegmenter = 4;
  MantisError.kInputSafetyError = 5;
  MantisError.kOutputSafetyError = 6;
  MantisError.kPromptSafetyError = 7;
  MantisError.MIN_VALUE = 0;
  MantisError.MAX_VALUE = 7;
  MantisError.DEFAULT_VALUE = 0;

  MantisError.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  MantisError.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  MantisError.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SafetyClassifierVerdict = {};
  SafetyClassifierVerdict.kPass = 0;
  SafetyClassifierVerdict.kFail = 1;
  SafetyClassifierVerdict.kFailedText = 2;
  SafetyClassifierVerdict.kFailedImage = 3;
  SafetyClassifierVerdict.kServiceNotAvailable = 4;
  SafetyClassifierVerdict.kNoInternetConnection = 5;
  SafetyClassifierVerdict.MIN_VALUE = 0;
  SafetyClassifierVerdict.MAX_VALUE = 5;
  SafetyClassifierVerdict.DEFAULT_VALUE = 1;

  SafetyClassifierVerdict.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  SafetyClassifierVerdict.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  SafetyClassifierVerdict.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SegmentationMode = {};
  SegmentationMode.kScribble = 0;
  SegmentationMode.kLasso = 1;
  SegmentationMode.MIN_VALUE = 0;
  SegmentationMode.MAX_VALUE = 1;
  SegmentationMode.DEFAULT_VALUE = 0;

  SegmentationMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  SegmentationMode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  SegmentationMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function TouchPoint(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TouchPoint.prototype.initDefaults_ = function() {
    this.x = 0;
    this.y = 0;
  };
  TouchPoint.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TouchPoint.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  TouchPoint.encodedSize = codec.kStructHeaderSize + 8;

  TouchPoint.decode = function(decoder) {
    var packed;
    var val = new TouchPoint();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.x =
        decoder.decodeStruct(codec.Float);
    val.y =
        decoder.decodeStruct(codec.Float);
    return val;
  };

  TouchPoint.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TouchPoint.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.x);
    encoder.encodeStruct(codec.Float, val.y);
  };
  function MantisProcessor_Inpainting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisProcessor_Inpainting_Params.prototype.initDefaults_ = function() {
    this.image = null;
    this.mask = null;
    this.seed = 0;
  };
  MantisProcessor_Inpainting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisProcessor_Inpainting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_Inpainting_Params.image
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_Inpainting_Params.mask
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MantisProcessor_Inpainting_Params.encodedSize = codec.kStructHeaderSize + 24;

  MantisProcessor_Inpainting_Params.decode = function(decoder) {
    var packed;
    var val = new MantisProcessor_Inpainting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.image =
        decoder.decodeArrayPointer(codec.Uint8);
    val.mask =
        decoder.decodeArrayPointer(codec.Uint8);
    val.seed =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MantisProcessor_Inpainting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisProcessor_Inpainting_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.image);
    encoder.encodeArrayPointer(codec.Uint8, val.mask);
    encoder.encodeStruct(codec.Uint32, val.seed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MantisProcessor_Inpainting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisProcessor_Inpainting_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  MantisProcessor_Inpainting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisProcessor_Inpainting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_Inpainting_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, MantisResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisProcessor_Inpainting_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  MantisProcessor_Inpainting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MantisProcessor_Inpainting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(MantisResult);
    return val;
  };

  MantisProcessor_Inpainting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisProcessor_Inpainting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(MantisResult, val.result);
  };
  function MantisProcessor_GenerativeFill_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisProcessor_GenerativeFill_Params.prototype.initDefaults_ = function() {
    this.image = null;
    this.mask = null;
    this.seed = 0;
    this.prompt = null;
  };
  MantisProcessor_GenerativeFill_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisProcessor_GenerativeFill_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_GenerativeFill_Params.image
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_GenerativeFill_Params.mask
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate MantisProcessor_GenerativeFill_Params.prompt
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisProcessor_GenerativeFill_Params.encodedSize = codec.kStructHeaderSize + 32;

  MantisProcessor_GenerativeFill_Params.decode = function(decoder) {
    var packed;
    var val = new MantisProcessor_GenerativeFill_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.image =
        decoder.decodeArrayPointer(codec.Uint8);
    val.mask =
        decoder.decodeArrayPointer(codec.Uint8);
    val.seed =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.prompt =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MantisProcessor_GenerativeFill_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisProcessor_GenerativeFill_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.image);
    encoder.encodeArrayPointer(codec.Uint8, val.mask);
    encoder.encodeStruct(codec.Uint32, val.seed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.prompt);
  };
  function MantisProcessor_GenerativeFill_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisProcessor_GenerativeFill_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  MantisProcessor_GenerativeFill_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisProcessor_GenerativeFill_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_GenerativeFill_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, MantisResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisProcessor_GenerativeFill_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  MantisProcessor_GenerativeFill_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MantisProcessor_GenerativeFill_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(MantisResult);
    return val;
  };

  MantisProcessor_GenerativeFill_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisProcessor_GenerativeFill_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(MantisResult, val.result);
  };
  function MantisProcessor_Segmentation_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisProcessor_Segmentation_Params.prototype.initDefaults_ = function() {
    this.image = null;
    this.prior = null;
  };
  MantisProcessor_Segmentation_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisProcessor_Segmentation_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_Segmentation_Params.image
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_Segmentation_Params.prior
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisProcessor_Segmentation_Params.encodedSize = codec.kStructHeaderSize + 16;

  MantisProcessor_Segmentation_Params.decode = function(decoder) {
    var packed;
    var val = new MantisProcessor_Segmentation_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.image =
        decoder.decodeArrayPointer(codec.Uint8);
    val.prior =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  MantisProcessor_Segmentation_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisProcessor_Segmentation_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.image);
    encoder.encodeArrayPointer(codec.Uint8, val.prior);
  };
  function MantisProcessor_Segmentation_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisProcessor_Segmentation_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  MantisProcessor_Segmentation_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisProcessor_Segmentation_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_Segmentation_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, MantisResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisProcessor_Segmentation_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  MantisProcessor_Segmentation_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MantisProcessor_Segmentation_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(MantisResult);
    return val;
  };

  MantisProcessor_Segmentation_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisProcessor_Segmentation_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(MantisResult, val.result);
  };
  function MantisProcessor_ClassifyImageSafety_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisProcessor_ClassifyImageSafety_Params.prototype.initDefaults_ = function() {
    this.image = null;
  };
  MantisProcessor_ClassifyImageSafety_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisProcessor_ClassifyImageSafety_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_ClassifyImageSafety_Params.image
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisProcessor_ClassifyImageSafety_Params.encodedSize = codec.kStructHeaderSize + 8;

  MantisProcessor_ClassifyImageSafety_Params.decode = function(decoder) {
    var packed;
    var val = new MantisProcessor_ClassifyImageSafety_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.image =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  MantisProcessor_ClassifyImageSafety_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisProcessor_ClassifyImageSafety_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.image);
  };
  function MantisProcessor_ClassifyImageSafety_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisProcessor_ClassifyImageSafety_ResponseParams.prototype.initDefaults_ = function() {
    this.verdict = 0;
  };
  MantisProcessor_ClassifyImageSafety_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisProcessor_ClassifyImageSafety_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_ClassifyImageSafety_ResponseParams.verdict
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SafetyClassifierVerdict);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisProcessor_ClassifyImageSafety_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MantisProcessor_ClassifyImageSafety_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MantisProcessor_ClassifyImageSafety_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.verdict =
        decoder.decodeStruct(new codec.Enum(SafetyClassifierVerdict));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MantisProcessor_ClassifyImageSafety_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisProcessor_ClassifyImageSafety_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.verdict);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MantisProcessor_Outpainting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisProcessor_Outpainting_Params.prototype.initDefaults_ = function() {
    this.image = null;
    this.mask = null;
    this.seed = 0;
  };
  MantisProcessor_Outpainting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisProcessor_Outpainting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_Outpainting_Params.image
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_Outpainting_Params.mask
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MantisProcessor_Outpainting_Params.encodedSize = codec.kStructHeaderSize + 24;

  MantisProcessor_Outpainting_Params.decode = function(decoder) {
    var packed;
    var val = new MantisProcessor_Outpainting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.image =
        decoder.decodeArrayPointer(codec.Uint8);
    val.mask =
        decoder.decodeArrayPointer(codec.Uint8);
    val.seed =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MantisProcessor_Outpainting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisProcessor_Outpainting_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.image);
    encoder.encodeArrayPointer(codec.Uint8, val.mask);
    encoder.encodeStruct(codec.Uint32, val.seed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MantisProcessor_Outpainting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisProcessor_Outpainting_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  MantisProcessor_Outpainting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisProcessor_Outpainting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_Outpainting_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, MantisResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisProcessor_Outpainting_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  MantisProcessor_Outpainting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MantisProcessor_Outpainting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(MantisResult);
    return val;
  };

  MantisProcessor_Outpainting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisProcessor_Outpainting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(MantisResult, val.result);
  };
  function MantisProcessor_InferSegmentationMode_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisProcessor_InferSegmentationMode_Params.prototype.initDefaults_ = function() {
    this.gesture = null;
  };
  MantisProcessor_InferSegmentationMode_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisProcessor_InferSegmentationMode_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_InferSegmentationMode_Params.gesture
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(TouchPoint), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisProcessor_InferSegmentationMode_Params.encodedSize = codec.kStructHeaderSize + 8;

  MantisProcessor_InferSegmentationMode_Params.decode = function(decoder) {
    var packed;
    var val = new MantisProcessor_InferSegmentationMode_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.gesture =
        decoder.decodeArrayPointer(new codec.PointerTo(TouchPoint));
    return val;
  };

  MantisProcessor_InferSegmentationMode_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisProcessor_InferSegmentationMode_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(TouchPoint), val.gesture);
  };
  function MantisProcessor_InferSegmentationMode_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisProcessor_InferSegmentationMode_ResponseParams.prototype.initDefaults_ = function() {
    this.mode = 0;
  };
  MantisProcessor_InferSegmentationMode_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisProcessor_InferSegmentationMode_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisProcessor_InferSegmentationMode_ResponseParams.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SegmentationMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisProcessor_InferSegmentationMode_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MantisProcessor_InferSegmentationMode_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MantisProcessor_InferSegmentationMode_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(SegmentationMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MantisProcessor_InferSegmentationMode_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisProcessor_InferSegmentationMode_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function MantisResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  MantisResult.Tags = {
    error: 0,
    resultImage: 1,
  };

  MantisResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  MantisResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "error",
        "resultImage",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a MantisResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(MantisResult.prototype, "error", {
    get: function() {
      if (this.$tag != MantisResult.Tags.error) {
        throw new ReferenceError(
            "MantisResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = MantisResult.Tags.error;
      this.$data = value;
    }
  });
  Object.defineProperty(MantisResult.prototype, "resultImage", {
    get: function() {
      if (this.$tag != MantisResult.Tags.resultImage) {
        throw new ReferenceError(
            "MantisResult.resultImage is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = MantisResult.Tags.resultImage;
      this.$data = value;
    }
  });


    MantisResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case MantisResult.Tags.error:
          encoder.encodeStruct(codec.Int32, val.error);
          break;
        case MantisResult.Tags.resultImage:
          encoder.encodeArrayPointer(codec.Uint8, val.resultImage);
          break;
      }
      encoder.align();
    };


    MantisResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new MantisResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case MantisResult.Tags.error:
          result.error = decoder.decodeStruct(new codec.Enum(MantisError));
          break;
        case MantisResult.Tags.resultImage:
          result.resultImage = decoder.decodeArrayPointer(codec.Uint8);
          break;
      }
      decoder.align();

      return result;
    };


    MantisResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case MantisResult.Tags.error:
          

    // validate MantisResult.error
    err = messageValidator.validateEnum(data_offset, MantisError);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case MantisResult.Tags.resultImage:
          

    // validate MantisResult.resultImage
    err = messageValidator.validateArrayPointer(data_offset, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  MantisResult.encodedSize = 16;
  var kMantisProcessor_Inpainting_Name = 0;
  var kMantisProcessor_GenerativeFill_Name = 1;
  var kMantisProcessor_Segmentation_Name = 2;
  var kMantisProcessor_ClassifyImageSafety_Name = 3;
  var kMantisProcessor_Outpainting_Name = 4;
  var kMantisProcessor_InferSegmentationMode_Name = 5;

  function MantisProcessorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MantisProcessor,
                                                   handleOrPtrInfo);
  }

  function MantisProcessorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MantisProcessor, associatedInterfacePtrInfo);
  }

  MantisProcessorAssociatedPtr.prototype =
      Object.create(MantisProcessorPtr.prototype);
  MantisProcessorAssociatedPtr.prototype.constructor =
      MantisProcessorAssociatedPtr;

  function MantisProcessorProxy(receiver) {
    this.receiver_ = receiver;
  }
  MantisProcessorPtr.prototype.inpainting = function() {
    return MantisProcessorProxy.prototype.inpainting
        .apply(this.ptr.getProxy(), arguments);
  };

  MantisProcessorProxy.prototype.inpainting = function(image, mask, seed) {
    var params_ = new MantisProcessor_Inpainting_Params();
    params_.image = image;
    params_.mask = mask;
    params_.seed = seed;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMantisProcessor_Inpainting_Name,
          codec.align(MantisProcessor_Inpainting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MantisProcessor_Inpainting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MantisProcessor_Inpainting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MantisProcessorPtr.prototype.generativeFill = function() {
    return MantisProcessorProxy.prototype.generativeFill
        .apply(this.ptr.getProxy(), arguments);
  };

  MantisProcessorProxy.prototype.generativeFill = function(image, mask, seed, prompt) {
    var params_ = new MantisProcessor_GenerativeFill_Params();
    params_.image = image;
    params_.mask = mask;
    params_.seed = seed;
    params_.prompt = prompt;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMantisProcessor_GenerativeFill_Name,
          codec.align(MantisProcessor_GenerativeFill_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MantisProcessor_GenerativeFill_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MantisProcessor_GenerativeFill_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MantisProcessorPtr.prototype.segmentation = function() {
    return MantisProcessorProxy.prototype.segmentation
        .apply(this.ptr.getProxy(), arguments);
  };

  MantisProcessorProxy.prototype.segmentation = function(image, prior) {
    var params_ = new MantisProcessor_Segmentation_Params();
    params_.image = image;
    params_.prior = prior;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMantisProcessor_Segmentation_Name,
          codec.align(MantisProcessor_Segmentation_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MantisProcessor_Segmentation_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MantisProcessor_Segmentation_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MantisProcessorPtr.prototype.classifyImageSafety = function() {
    return MantisProcessorProxy.prototype.classifyImageSafety
        .apply(this.ptr.getProxy(), arguments);
  };

  MantisProcessorProxy.prototype.classifyImageSafety = function(image) {
    var params_ = new MantisProcessor_ClassifyImageSafety_Params();
    params_.image = image;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMantisProcessor_ClassifyImageSafety_Name,
          codec.align(MantisProcessor_ClassifyImageSafety_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MantisProcessor_ClassifyImageSafety_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MantisProcessor_ClassifyImageSafety_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MantisProcessorPtr.prototype.outpainting = function() {
    return MantisProcessorProxy.prototype.outpainting
        .apply(this.ptr.getProxy(), arguments);
  };

  MantisProcessorProxy.prototype.outpainting = function(image, mask, seed) {
    var params_ = new MantisProcessor_Outpainting_Params();
    params_.image = image;
    params_.mask = mask;
    params_.seed = seed;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMantisProcessor_Outpainting_Name,
          codec.align(MantisProcessor_Outpainting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MantisProcessor_Outpainting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MantisProcessor_Outpainting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MantisProcessorPtr.prototype.inferSegmentationMode = function() {
    return MantisProcessorProxy.prototype.inferSegmentationMode
        .apply(this.ptr.getProxy(), arguments);
  };

  MantisProcessorProxy.prototype.inferSegmentationMode = function(gesture) {
    var params_ = new MantisProcessor_InferSegmentationMode_Params();
    params_.gesture = gesture;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMantisProcessor_InferSegmentationMode_Name,
          codec.align(MantisProcessor_InferSegmentationMode_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MantisProcessor_InferSegmentationMode_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MantisProcessor_InferSegmentationMode_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function MantisProcessorStub(delegate) {
    this.delegate_ = delegate;
  }
  MantisProcessorStub.prototype.inpainting = function(image, mask, seed) {
    return this.delegate_ && this.delegate_.inpainting && this.delegate_.inpainting(image, mask, seed);
  }
  MantisProcessorStub.prototype.generativeFill = function(image, mask, seed, prompt) {
    return this.delegate_ && this.delegate_.generativeFill && this.delegate_.generativeFill(image, mask, seed, prompt);
  }
  MantisProcessorStub.prototype.segmentation = function(image, prior) {
    return this.delegate_ && this.delegate_.segmentation && this.delegate_.segmentation(image, prior);
  }
  MantisProcessorStub.prototype.classifyImageSafety = function(image) {
    return this.delegate_ && this.delegate_.classifyImageSafety && this.delegate_.classifyImageSafety(image);
  }
  MantisProcessorStub.prototype.outpainting = function(image, mask, seed) {
    return this.delegate_ && this.delegate_.outpainting && this.delegate_.outpainting(image, mask, seed);
  }
  MantisProcessorStub.prototype.inferSegmentationMode = function(gesture) {
    return this.delegate_ && this.delegate_.inferSegmentationMode && this.delegate_.inferSegmentationMode(gesture);
  }

  MantisProcessorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  MantisProcessorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMantisProcessor_Inpainting_Name:
      var params = reader.decodeStruct(MantisProcessor_Inpainting_Params);
      this.inpainting(params.image, params.mask, params.seed).then(function(response) {
        var responseParams =
            new MantisProcessor_Inpainting_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMantisProcessor_Inpainting_Name,
            codec.align(MantisProcessor_Inpainting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MantisProcessor_Inpainting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMantisProcessor_GenerativeFill_Name:
      var params = reader.decodeStruct(MantisProcessor_GenerativeFill_Params);
      this.generativeFill(params.image, params.mask, params.seed, params.prompt).then(function(response) {
        var responseParams =
            new MantisProcessor_GenerativeFill_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMantisProcessor_GenerativeFill_Name,
            codec.align(MantisProcessor_GenerativeFill_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MantisProcessor_GenerativeFill_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMantisProcessor_Segmentation_Name:
      var params = reader.decodeStruct(MantisProcessor_Segmentation_Params);
      this.segmentation(params.image, params.prior).then(function(response) {
        var responseParams =
            new MantisProcessor_Segmentation_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMantisProcessor_Segmentation_Name,
            codec.align(MantisProcessor_Segmentation_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MantisProcessor_Segmentation_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMantisProcessor_ClassifyImageSafety_Name:
      var params = reader.decodeStruct(MantisProcessor_ClassifyImageSafety_Params);
      this.classifyImageSafety(params.image).then(function(response) {
        var responseParams =
            new MantisProcessor_ClassifyImageSafety_ResponseParams();
        responseParams.verdict = response.verdict;
        var builder = new codec.MessageV1Builder(
            kMantisProcessor_ClassifyImageSafety_Name,
            codec.align(MantisProcessor_ClassifyImageSafety_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MantisProcessor_ClassifyImageSafety_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMantisProcessor_Outpainting_Name:
      var params = reader.decodeStruct(MantisProcessor_Outpainting_Params);
      this.outpainting(params.image, params.mask, params.seed).then(function(response) {
        var responseParams =
            new MantisProcessor_Outpainting_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMantisProcessor_Outpainting_Name,
            codec.align(MantisProcessor_Outpainting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MantisProcessor_Outpainting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMantisProcessor_InferSegmentationMode_Name:
      var params = reader.decodeStruct(MantisProcessor_InferSegmentationMode_Params);
      this.inferSegmentationMode(params.gesture).then(function(response) {
        var responseParams =
            new MantisProcessor_InferSegmentationMode_ResponseParams();
        responseParams.mode = response.mode;
        var builder = new codec.MessageV1Builder(
            kMantisProcessor_InferSegmentationMode_Name,
            codec.align(MantisProcessor_InferSegmentationMode_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MantisProcessor_InferSegmentationMode_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateMantisProcessorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMantisProcessor_Inpainting_Name:
        if (message.expectsResponse())
          paramsClass = MantisProcessor_Inpainting_Params;
      break;
      case kMantisProcessor_GenerativeFill_Name:
        if (message.expectsResponse())
          paramsClass = MantisProcessor_GenerativeFill_Params;
      break;
      case kMantisProcessor_Segmentation_Name:
        if (message.expectsResponse())
          paramsClass = MantisProcessor_Segmentation_Params;
      break;
      case kMantisProcessor_ClassifyImageSafety_Name:
        if (message.expectsResponse())
          paramsClass = MantisProcessor_ClassifyImageSafety_Params;
      break;
      case kMantisProcessor_Outpainting_Name:
        if (message.expectsResponse())
          paramsClass = MantisProcessor_Outpainting_Params;
      break;
      case kMantisProcessor_InferSegmentationMode_Name:
        if (message.expectsResponse())
          paramsClass = MantisProcessor_InferSegmentationMode_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMantisProcessorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kMantisProcessor_Inpainting_Name:
        if (message.isResponse())
          paramsClass = MantisProcessor_Inpainting_ResponseParams;
        break;
      case kMantisProcessor_GenerativeFill_Name:
        if (message.isResponse())
          paramsClass = MantisProcessor_GenerativeFill_ResponseParams;
        break;
      case kMantisProcessor_Segmentation_Name:
        if (message.isResponse())
          paramsClass = MantisProcessor_Segmentation_ResponseParams;
        break;
      case kMantisProcessor_ClassifyImageSafety_Name:
        if (message.isResponse())
          paramsClass = MantisProcessor_ClassifyImageSafety_ResponseParams;
        break;
      case kMantisProcessor_Outpainting_Name:
        if (message.isResponse())
          paramsClass = MantisProcessor_Outpainting_ResponseParams;
        break;
      case kMantisProcessor_InferSegmentationMode_Name:
        if (message.isResponse())
          paramsClass = MantisProcessor_InferSegmentationMode_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var MantisProcessor = {
    name: 'mantis.mojom.MantisProcessor',
    kVersion: 7,
    ptrClass: MantisProcessorPtr,
    proxyClass: MantisProcessorProxy,
    stubClass: MantisProcessorStub,
    validateRequest: validateMantisProcessorRequest,
    validateResponse: validateMantisProcessorResponse,
  };
  MantisProcessorStub.prototype.validator = validateMantisProcessorRequest;
  MantisProcessorProxy.prototype.validator = validateMantisProcessorResponse;
  exports.MantisError = MantisError;
  exports.SafetyClassifierVerdict = SafetyClassifierVerdict;
  exports.SegmentationMode = SegmentationMode;
  exports.TouchPoint = TouchPoint;
  exports.MantisResult = MantisResult;
  exports.MantisProcessor = MantisProcessor;
  exports.MantisProcessorPtr = MantisProcessorPtr;
  exports.MantisProcessorAssociatedPtr = MantisProcessorAssociatedPtr;
})();