// chromeos/ash/components/mantis/mojom/mantis_processor.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MantisErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MantisError = {
  
  kUnknownError: 0,
  kProcessorNotInitialized: 1,
  kInputError: 2,
  kProcessFailed: 3,
  kMissingSegmenter: 4,
  kInputSafetyError: 5,
  kOutputSafetyError: 6,
  kPromptSafetyError: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SafetyClassifierVerdictSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SafetyClassifierVerdict = {
  
  kPass: 0,
  kFail: 1,
  kFailedText: 2,
  kFailedImage: 3,
  kServiceNotAvailable: 4,
  kNoInternetConnection: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SegmentationModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SegmentationMode = {
  
  kScribble: 0,
  kLasso: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MantisProcessorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'mantis.mojom.MantisProcessor', scope);
  }
}

/** @interface */
export class MantisProcessorInterface {
  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } mask
   * @param { !number } seed
   * @return {!Promise<{
        result: !MantisResult,
   *  }>}
   */

  inpainting(image, mask, seed) {}
  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } mask
   * @param { !number } seed
   * @param { !string } prompt
   * @return {!Promise<{
        result: !MantisResult,
   *  }>}
   */

  generativeFill(image, mask, seed, prompt) {}
  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } prior
   * @return {!Promise<{
        result: !MantisResult,
   *  }>}
   */

  segmentation(image, prior) {}
  
  /**
   * @param { !Array<!number> } image
   * @return {!Promise<{
        verdict: !SafetyClassifierVerdict,
   *  }>}
   */

  classifyImageSafety(image) {}
  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } mask
   * @param { !number } seed
   * @return {!Promise<{
        result: !MantisResult,
   *  }>}
   */

  outpainting(image, mask, seed) {}
  
  /**
   * @param { !Array<!TouchPoint> } gesture
   * @return {!Promise<{
        mode: !SegmentationMode,
   *  }>}
   */

  inferSegmentationMode(gesture) {}
}

/**
 * @implements { MantisProcessorInterface }
 */
export class MantisProcessorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MantisProcessorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MantisProcessorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MantisProcessorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } mask
   * @param { !number } seed
   * @return {!Promise<{
        result: !MantisResult,
   *  }>}
   */

  inpainting(
      image,
      mask,
      seed) {
    return this.proxy.sendMessage(
        0,
        MantisProcessor_Inpainting_ParamsSpec.$,
        MantisProcessor_Inpainting_ResponseParamsSpec.$,
        [
          image,
          mask,
          seed
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } mask
   * @param { !number } seed
   * @param { !string } prompt
   * @return {!Promise<{
        result: !MantisResult,
   *  }>}
   */

  generativeFill(
      image,
      mask,
      seed,
      prompt) {
    return this.proxy.sendMessage(
        1,
        MantisProcessor_GenerativeFill_ParamsSpec.$,
        MantisProcessor_GenerativeFill_ResponseParamsSpec.$,
        [
          image,
          mask,
          seed,
          prompt
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } prior
   * @return {!Promise<{
        result: !MantisResult,
   *  }>}
   */

  segmentation(
      image,
      prior) {
    return this.proxy.sendMessage(
        2,
        MantisProcessor_Segmentation_ParamsSpec.$,
        MantisProcessor_Segmentation_ResponseParamsSpec.$,
        [
          image,
          prior
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } image
   * @return {!Promise<{
        verdict: !SafetyClassifierVerdict,
   *  }>}
   */

  classifyImageSafety(
      image) {
    return this.proxy.sendMessage(
        3,
        MantisProcessor_ClassifyImageSafety_ParamsSpec.$,
        MantisProcessor_ClassifyImageSafety_ResponseParamsSpec.$,
        [
          image
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } image
   * @param { !Array<!number> } mask
   * @param { !number } seed
   * @return {!Promise<{
        result: !MantisResult,
   *  }>}
   */

  outpainting(
      image,
      mask,
      seed) {
    return this.proxy.sendMessage(
        4,
        MantisProcessor_Outpainting_ParamsSpec.$,
        MantisProcessor_Outpainting_ResponseParamsSpec.$,
        [
          image,
          mask,
          seed
        ],
        false);
  }

  
  /**
   * @param { !Array<!TouchPoint> } gesture
   * @return {!Promise<{
        mode: !SegmentationMode,
   *  }>}
   */

  inferSegmentationMode(
      gesture) {
    return this.proxy.sendMessage(
        5,
        MantisProcessor_InferSegmentationMode_ParamsSpec.$,
        MantisProcessor_InferSegmentationMode_ResponseParamsSpec.$,
        [
          gesture
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MantisProcessor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MantisProcessorReceiver {
  /**
   * @param {!MantisProcessorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MantisProcessorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MantisProcessorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MantisProcessorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MantisProcessor_Inpainting_ParamsSpec.$,
        MantisProcessor_Inpainting_ResponseParamsSpec.$,
        impl.inpainting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MantisProcessor_GenerativeFill_ParamsSpec.$,
        MantisProcessor_GenerativeFill_ResponseParamsSpec.$,
        impl.generativeFill.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MantisProcessor_Segmentation_ParamsSpec.$,
        MantisProcessor_Segmentation_ResponseParamsSpec.$,
        impl.segmentation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MantisProcessor_ClassifyImageSafety_ParamsSpec.$,
        MantisProcessor_ClassifyImageSafety_ResponseParamsSpec.$,
        impl.classifyImageSafety.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MantisProcessor_Outpainting_ParamsSpec.$,
        MantisProcessor_Outpainting_ResponseParamsSpec.$,
        impl.outpainting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MantisProcessor_InferSegmentationMode_ParamsSpec.$,
        MantisProcessor_InferSegmentationMode_ResponseParamsSpec.$,
        impl.inferSegmentationMode.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MantisProcessor {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "mantis.mojom.MantisProcessor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MantisProcessorRemote}
   */
  static getRemote() {
    let remote = new MantisProcessorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MantisProcessor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MantisProcessorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MantisProcessorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MantisProcessorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.inpainting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MantisProcessor_Inpainting_ParamsSpec.$,
        MantisProcessor_Inpainting_ResponseParamsSpec.$,
        this.inpainting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.generativeFill =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MantisProcessor_GenerativeFill_ParamsSpec.$,
        MantisProcessor_GenerativeFill_ResponseParamsSpec.$,
        this.generativeFill.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.segmentation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MantisProcessor_Segmentation_ParamsSpec.$,
        MantisProcessor_Segmentation_ResponseParamsSpec.$,
        this.segmentation.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.classifyImageSafety =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MantisProcessor_ClassifyImageSafety_ParamsSpec.$,
        MantisProcessor_ClassifyImageSafety_ResponseParamsSpec.$,
        this.classifyImageSafety.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.outpainting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MantisProcessor_Outpainting_ParamsSpec.$,
        MantisProcessor_Outpainting_ResponseParamsSpec.$,
        this.outpainting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.inferSegmentationMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MantisProcessor_InferSegmentationMode_ParamsSpec.$,
        MantisProcessor_InferSegmentationMode_ResponseParamsSpec.$,
        this.inferSegmentationMode.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TouchPointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisProcessor_Inpainting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisProcessor_Inpainting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisProcessor_GenerativeFill_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisProcessor_GenerativeFill_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisProcessor_Segmentation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisProcessor_Segmentation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisProcessor_ClassifyImageSafety_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisProcessor_ClassifyImageSafety_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisProcessor_Outpainting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisProcessor_Outpainting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisProcessor_InferSegmentationMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisProcessor_InferSegmentationMode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const MantisResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    TouchPointSpec.$,
    'TouchPoint',
    [
      mojo.internal.StructField(
        'x', 0,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'y', 4,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TouchPoint {
  constructor() {
    /** @type { !number } */
    this.x;
    /** @type { !number } */
    this.y;
  }
}



mojo.internal.Struct(
    MantisProcessor_Inpainting_ParamsSpec.$,
    'MantisProcessor_Inpainting_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mask', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'seed', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MantisProcessor_Inpainting_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.image;
    /** @type { !Array<!number> } */
    this.mask;
    /** @type { !number } */
    this.seed;
  }
}



mojo.internal.Struct(
    MantisProcessor_Inpainting_ResponseParamsSpec.$,
    'MantisProcessor_Inpainting_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        MantisResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MantisProcessor_Inpainting_ResponseParams {
  constructor() {
    /** @type { !MantisResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MantisProcessor_GenerativeFill_ParamsSpec.$,
    'MantisProcessor_GenerativeFill_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mask', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'seed', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'prompt', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class MantisProcessor_GenerativeFill_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.image;
    /** @type { !Array<!number> } */
    this.mask;
    /** @type { !number } */
    this.seed;
    /** @type { !string } */
    this.prompt;
  }
}



mojo.internal.Struct(
    MantisProcessor_GenerativeFill_ResponseParamsSpec.$,
    'MantisProcessor_GenerativeFill_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        MantisResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MantisProcessor_GenerativeFill_ResponseParams {
  constructor() {
    /** @type { !MantisResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MantisProcessor_Segmentation_ParamsSpec.$,
    'MantisProcessor_Segmentation_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'prior', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MantisProcessor_Segmentation_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.image;
    /** @type { !Array<!number> } */
    this.prior;
  }
}



mojo.internal.Struct(
    MantisProcessor_Segmentation_ResponseParamsSpec.$,
    'MantisProcessor_Segmentation_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        MantisResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MantisProcessor_Segmentation_ResponseParams {
  constructor() {
    /** @type { !MantisResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MantisProcessor_ClassifyImageSafety_ParamsSpec.$,
    'MantisProcessor_ClassifyImageSafety_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MantisProcessor_ClassifyImageSafety_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.image;
  }
}



mojo.internal.Struct(
    MantisProcessor_ClassifyImageSafety_ResponseParamsSpec.$,
    'MantisProcessor_ClassifyImageSafety_ResponseParams',
    [
      mojo.internal.StructField(
        'verdict', 0,
        0,
        SafetyClassifierVerdictSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MantisProcessor_ClassifyImageSafety_ResponseParams {
  constructor() {
    /** @type { !SafetyClassifierVerdict } */
    this.verdict;
  }
}



mojo.internal.Struct(
    MantisProcessor_Outpainting_ParamsSpec.$,
    'MantisProcessor_Outpainting_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mask', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'seed', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MantisProcessor_Outpainting_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.image;
    /** @type { !Array<!number> } */
    this.mask;
    /** @type { !number } */
    this.seed;
  }
}



mojo.internal.Struct(
    MantisProcessor_Outpainting_ResponseParamsSpec.$,
    'MantisProcessor_Outpainting_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        MantisResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MantisProcessor_Outpainting_ResponseParams {
  constructor() {
    /** @type { !MantisResult } */
    this.result;
  }
}



mojo.internal.Struct(
    MantisProcessor_InferSegmentationMode_ParamsSpec.$,
    'MantisProcessor_InferSegmentationMode_Params',
    [
      mojo.internal.StructField(
        'gesture', 0,
        0,
        mojo.internal.Array(TouchPointSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MantisProcessor_InferSegmentationMode_Params {
  constructor() {
    /** @type { !Array<!TouchPoint> } */
    this.gesture;
  }
}



mojo.internal.Struct(
    MantisProcessor_InferSegmentationMode_ResponseParamsSpec.$,
    'MantisProcessor_InferSegmentationMode_ResponseParams',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        SegmentationModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MantisProcessor_InferSegmentationMode_ResponseParams {
  constructor() {
    /** @type { !SegmentationMode } */
    this.mode;
  }
}

mojo.internal.Union(
    MantisResultSpec.$, 'MantisResult',
    {
      'error': {
        'ordinal': 0,
        'type': MantisErrorSpec.$,
      },
      'resultImage': {
        'ordinal': 1,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
      },
    });

/**
 * @typedef { {
 *   error: (!MantisError|undefined),
 *   resultImage: (!Array<!number>|undefined),
 * } }
 */
export const MantisResult = {};
