// chromeos/ash/components/mantis/mojom/mantis_service.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mantis.mojom.MantisProcessor');
goog.require('chromeos.machineLearning.mojom.TextClassifier');
goog.require('mojoBase.mojom.Uuid');




goog.provide('mantis.mojom.MantisFeatureStatus');
goog.provide('mantis.mojom.MantisFeatureStatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mantis.mojom.MantisFeatureStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mantis.mojom.MantisFeatureStatus = {
  
  kDeviceNotSupported: 0,
  kARCVMDisabled: 1,
  kAvailable: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('mantis.mojom.InitializeResult');
goog.provide('mantis.mojom.InitializeResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mantis.mojom.InitializeResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mantis.mojom.InitializeResult = {
  
  kSuccess: 0,
  kGpuBlocked: 1,
  kFailedToLoadLibrary: 2,
  kFailedToLoadSafetyService: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



goog.provide('mantis.mojom.PlatformModelProgressObserver');
goog.provide('mantis.mojom.PlatformModelProgressObserverReceiver');
goog.provide('mantis.mojom.PlatformModelProgressObserverCallbackRouter');
goog.provide('mantis.mojom.PlatformModelProgressObserverInterface');
goog.provide('mantis.mojom.PlatformModelProgressObserverRemote');
goog.provide('mantis.mojom.PlatformModelProgressObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
mantis.mojom.PlatformModelProgressObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        mantis.mojom.PlatformModelProgressObserver.$interfaceName,
        scope);
  }
};

/** @interface */
mantis.mojom.PlatformModelProgressObserverInterface = class {
  
  /**
   * @param { !number } progress
   */

  progress(progress) {}
};

/**
 * @export
 * @implements { mantis.mojom.PlatformModelProgressObserverInterface }
 */
mantis.mojom.PlatformModelProgressObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!mantis.mojom.PlatformModelProgressObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          mantis.mojom.PlatformModelProgressObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!mantis.mojom.PlatformModelProgressObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } progress
   */

  progress(
      progress) {
    this.proxy.sendMessage(
        0,
        mantis.mojom.PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        [
          progress
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PlatformModelProgressObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
mantis.mojom.PlatformModelProgressObserverReceiver = class {
  /**
   * @param {!mantis.mojom.PlatformModelProgressObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!mantis.mojom.PlatformModelProgressObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        mantis.mojom.PlatformModelProgressObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mantis.mojom.PlatformModelProgressObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        mantis.mojom.PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        impl.progress.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
mantis.mojom.PlatformModelProgressObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "mantis.mojom.PlatformModelProgressObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!mantis.mojom.PlatformModelProgressObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new mantis.mojom.PlatformModelProgressObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PlatformModelProgressObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
mantis.mojom.PlatformModelProgressObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      mantis.mojom.PlatformModelProgressObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mantis.mojom.PlatformModelProgressObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.progress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        mantis.mojom.PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        this.progress.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('mantis.mojom.MantisService');
goog.provide('mantis.mojom.MantisServiceReceiver');
goog.provide('mantis.mojom.MantisServiceCallbackRouter');
goog.provide('mantis.mojom.MantisServiceInterface');
goog.provide('mantis.mojom.MantisServiceRemote');
goog.provide('mantis.mojom.MantisServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
mantis.mojom.MantisServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        mantis.mojom.MantisService.$interfaceName,
        scope);
  }
};

/** @interface */
mantis.mojom.MantisServiceInterface = class {
  
  /**
   * @return {!Promise<{
        status: !mantis.mojom.MantisFeatureStatus,
   *  }>}
   */

  getMantisFeatureStatus() {}
  
  /**
   * @param { ?mantis.mojom.PlatformModelProgressObserverRemote } progressObserver
   * @param { !mantis.mojom.MantisProcessorPendingReceiver } processor
   * @param { ?mojoBase.mojom.Uuid } dlcUuid
   * @param { ?chromeos.machineLearning.mojom.TextClassifierRemote } textClassifier
   * @return {!Promise<{
        result: !mantis.mojom.InitializeResult,
   *  }>}
   */

  initialize(progressObserver, processor, dlcUuid, textClassifier) {}
};

/**
 * @export
 * @implements { mantis.mojom.MantisServiceInterface }
 */
mantis.mojom.MantisServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!mantis.mojom.MantisServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          mantis.mojom.MantisServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!mantis.mojom.MantisServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        status: !mantis.mojom.MantisFeatureStatus,
   *  }>}
   */

  getMantisFeatureStatus() {
    return this.proxy.sendMessage(
        1,
        mantis.mojom.MantisService_GetMantisFeatureStatus_ParamsSpec.$,
        mantis.mojom.MantisService_GetMantisFeatureStatus_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { ?mantis.mojom.PlatformModelProgressObserverRemote } progressObserver
   * @param { !mantis.mojom.MantisProcessorPendingReceiver } processor
   * @param { ?mojoBase.mojom.Uuid } dlcUuid
   * @param { ?chromeos.machineLearning.mojom.TextClassifierRemote } textClassifier
   * @return {!Promise<{
        result: !mantis.mojom.InitializeResult,
   *  }>}
   */

  initialize(
      progressObserver,
      processor,
      dlcUuid,
      textClassifier) {
    return this.proxy.sendMessage(
        0,
        mantis.mojom.MantisService_Initialize_ParamsSpec.$,
        mantis.mojom.MantisService_Initialize_ResponseParamsSpec.$,
        [
          progressObserver,
          processor,
          dlcUuid,
          textClassifier
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MantisService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
mantis.mojom.MantisServiceReceiver = class {
  /**
   * @param {!mantis.mojom.MantisServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!mantis.mojom.MantisServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        mantis.mojom.MantisServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mantis.mojom.MantisServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        1,
        mantis.mojom.MantisService_GetMantisFeatureStatus_ParamsSpec.$,
        mantis.mojom.MantisService_GetMantisFeatureStatus_ResponseParamsSpec.$,
        impl.getMantisFeatureStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        0,
        mantis.mojom.MantisService_Initialize_ParamsSpec.$,
        mantis.mojom.MantisService_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
mantis.mojom.MantisService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "mantis.mojom.MantisService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!mantis.mojom.MantisServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new mantis.mojom.MantisServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MantisService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
mantis.mojom.MantisServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      mantis.mojom.MantisServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mantis.mojom.MantisServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getMantisFeatureStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        mantis.mojom.MantisService_GetMantisFeatureStatus_ParamsSpec.$,
        mantis.mojom.MantisService_GetMantisFeatureStatus_ResponseParamsSpec.$,
        this.getMantisFeatureStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        mantis.mojom.MantisService_Initialize_ParamsSpec.$,
        mantis.mojom.MantisService_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('mantis.mojom.PlatformModelProgressObserver_Progress_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.PlatformModelProgressObserver_Progress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisService_GetMantisFeatureStatus_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisService_GetMantisFeatureStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisService_GetMantisFeatureStatus_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisService_GetMantisFeatureStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisService_Initialize_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisService_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('mantis.mojom.MantisService_Initialize_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mantis.mojom.MantisService_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    mantis.mojom.PlatformModelProgressObserver_Progress_ParamsSpec.$,
    'PlatformModelProgressObserver_Progress_Params',
    [
      mojo.internal.StructField(
        'progress', 0,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('mantis.mojom.PlatformModelProgressObserver_Progress_Params');

/** @record */
mantis.mojom.PlatformModelProgressObserver_Progress_Params = class {
  constructor() {
    /** @export { !number } */
    this.progress;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisService_GetMantisFeatureStatus_ParamsSpec.$,
    'MantisService_GetMantisFeatureStatus_Params',
    [
    ],
    [[0, 8],]);



goog.provide('mantis.mojom.MantisService_GetMantisFeatureStatus_Params');

/** @record */
mantis.mojom.MantisService_GetMantisFeatureStatus_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisService_GetMantisFeatureStatus_ResponseParamsSpec.$,
    'MantisService_GetMantisFeatureStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mantis.mojom.MantisFeatureStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('mantis.mojom.MantisService_GetMantisFeatureStatus_ResponseParams');

/** @record */
mantis.mojom.MantisService_GetMantisFeatureStatus_ResponseParams = class {
  constructor() {
    /** @export { !mantis.mojom.MantisFeatureStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisService_Initialize_ParamsSpec.$,
    'MantisService_Initialize_Params',
    [
      mojo.internal.StructField(
        'progressObserver', 0,
        0,
        mojo.internal.InterfaceProxy(mantis.mojom.PlatformModelProgressObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'processor', 8,
        0,
        mojo.internal.InterfaceRequest(mantis.mojom.MantisProcessorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dlcUuid', 16,
        0,
        mojoBase.mojom.UuidSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textClassifier', 24,
        0,
        mojo.internal.InterfaceProxy(chromeos.machineLearning.mojom.TextClassifierRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[3, 32],[4, 40],]);



goog.provide('mantis.mojom.MantisService_Initialize_Params');

/** @record */
mantis.mojom.MantisService_Initialize_Params = class {
  constructor() {
    /** @export { (mantis.mojom.PlatformModelProgressObserverRemote|undefined) } */
    this.progressObserver;
    /** @export { !mantis.mojom.MantisProcessorPendingReceiver } */
    this.processor;
    /** @export { (mojoBase.mojom.Uuid|undefined) } */
    this.dlcUuid;
    /** @export { (chromeos.machineLearning.mojom.TextClassifierRemote|undefined) } */
    this.textClassifier;
  }
};



mojo.internal.Struct(
    mantis.mojom.MantisService_Initialize_ResponseParamsSpec.$,
    'MantisService_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mantis.mojom.InitializeResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('mantis.mojom.MantisService_Initialize_ResponseParams');

/** @record */
mantis.mojom.MantisService_Initialize_ResponseParams = class {
  constructor() {
    /** @export { !mantis.mojom.InitializeResult } */
    this.result;
  }
};

