// chromeos/ash/components/mantis/mojom/mantis_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/ash/components/mantis/mojom/mantis_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('mantis.mojom');
  var mantis_processor$ =
      mojo.internal.exposeNamespace('mantis.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/ash/components/mantis/mojom/mantis_processor.mojom', 'mantis_processor.mojom.js');
  }
  var text_classifier$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/text_classifier.mojom', '../../../../services/machine_learning/public/mojom/text_classifier.mojom.js');
  }
  var uuid$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/uuid.mojom', '../../../../../mojo/public/mojom/base/uuid.mojom.js');
  }


  var MantisFeatureStatus = {};
  MantisFeatureStatus.kDeviceNotSupported = 0;
  MantisFeatureStatus.kARCVMDisabled = 1;
  MantisFeatureStatus.kAvailable = 2;
  MantisFeatureStatus.MIN_VALUE = 0;
  MantisFeatureStatus.MAX_VALUE = 2;
  MantisFeatureStatus.DEFAULT_VALUE = 0;

  MantisFeatureStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  MantisFeatureStatus.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  MantisFeatureStatus.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var InitializeResult = {};
  InitializeResult.kSuccess = 0;
  InitializeResult.kGpuBlocked = 1;
  InitializeResult.kFailedToLoadLibrary = 2;
  InitializeResult.kFailedToLoadSafetyService = 3;
  InitializeResult.MIN_VALUE = 0;
  InitializeResult.MAX_VALUE = 3;
  InitializeResult.DEFAULT_VALUE = 2;

  InitializeResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  InitializeResult.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  InitializeResult.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function PlatformModelProgressObserver_Progress_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PlatformModelProgressObserver_Progress_Params.prototype.initDefaults_ = function() {
    this.progress = 0;
  };
  PlatformModelProgressObserver_Progress_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PlatformModelProgressObserver_Progress_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PlatformModelProgressObserver_Progress_Params.encodedSize = codec.kStructHeaderSize + 8;

  PlatformModelProgressObserver_Progress_Params.decode = function(decoder) {
    var packed;
    var val = new PlatformModelProgressObserver_Progress_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.progress =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  PlatformModelProgressObserver_Progress_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PlatformModelProgressObserver_Progress_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.progress);
  };
  function MantisService_GetMantisFeatureStatus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisService_GetMantisFeatureStatus_Params.prototype.initDefaults_ = function() {
  };
  MantisService_GetMantisFeatureStatus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisService_GetMantisFeatureStatus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisService_GetMantisFeatureStatus_Params.encodedSize = codec.kStructHeaderSize + 0;

  MantisService_GetMantisFeatureStatus_Params.decode = function(decoder) {
    var packed;
    var val = new MantisService_GetMantisFeatureStatus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MantisService_GetMantisFeatureStatus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisService_GetMantisFeatureStatus_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MantisService_GetMantisFeatureStatus_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisService_GetMantisFeatureStatus_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  MantisService_GetMantisFeatureStatus_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisService_GetMantisFeatureStatus_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisService_GetMantisFeatureStatus_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MantisFeatureStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisService_GetMantisFeatureStatus_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MantisService_GetMantisFeatureStatus_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MantisService_GetMantisFeatureStatus_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(MantisFeatureStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MantisService_GetMantisFeatureStatus_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisService_GetMantisFeatureStatus_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MantisService_Initialize_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisService_Initialize_Params.prototype.initDefaults_ = function() {
    this.progressObserver = new PlatformModelProgressObserverPtr();
    this.processor = new bindings.InterfaceRequest();
    this.dlcUuid = null;
    this.textClassifier = new text_classifier$.TextClassifierPtr();
  };
  MantisService_Initialize_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisService_Initialize_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 3, numBytes: 32},
      {version: 4, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisService_Initialize_Params.progressObserver
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisService_Initialize_Params.processor
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;



    // version check MantisService_Initialize_Params.dlcUuid
    if (!messageValidator.isFieldInStructVersion(offset, 3))
      return validator.validationError.NONE;
    // validate MantisService_Initialize_Params.dlcUuid
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, uuid$.Uuid, true);
    if (err !== validator.validationError.NONE)
        return err;



    // version check MantisService_Initialize_Params.textClassifier
    if (!messageValidator.isFieldInStructVersion(offset, 4))
      return validator.validationError.NONE;
    // validate MantisService_Initialize_Params.textClassifier
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 24, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisService_Initialize_Params.encodedSize = codec.kStructHeaderSize + 32;

  MantisService_Initialize_Params.decode = function(decoder) {
    var packed;
    var val = new MantisService_Initialize_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.progressObserver =
        decoder.decodeStruct(new codec.NullableInterface(PlatformModelProgressObserverPtr));
    val.processor =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 3) {
      val.dlcUuid =
          decoder.decodeStructPointer(uuid$.Uuid);
    } else {
      val.dlcUuid = null;
    }
    if (version >= 4) {
      val.textClassifier =
          decoder.decodeStruct(new codec.NullableInterface(text_classifier$.TextClassifierPtr));
    } else {
      val.textClassifier = null;
    }
    return val;
  };

  MantisService_Initialize_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisService_Initialize_Params.encodedSize);
    encoder.writeUint32(4);
    encoder.encodeStruct(new codec.NullableInterface(PlatformModelProgressObserverPtr), val.progressObserver);
    encoder.encodeStruct(codec.InterfaceRequest, val.processor);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(uuid$.Uuid, val.dlcUuid);
    encoder.encodeStruct(new codec.NullableInterface(text_classifier$.TextClassifierPtr), val.textClassifier);
  };
  function MantisService_Initialize_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MantisService_Initialize_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  MantisService_Initialize_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MantisService_Initialize_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MantisService_Initialize_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, InitializeResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MantisService_Initialize_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MantisService_Initialize_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MantisService_Initialize_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(InitializeResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MantisService_Initialize_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MantisService_Initialize_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kPlatformModelProgressObserver_Progress_Name = 0;

  function PlatformModelProgressObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PlatformModelProgressObserver,
                                                   handleOrPtrInfo);
  }

  function PlatformModelProgressObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PlatformModelProgressObserver, associatedInterfacePtrInfo);
  }

  PlatformModelProgressObserverAssociatedPtr.prototype =
      Object.create(PlatformModelProgressObserverPtr.prototype);
  PlatformModelProgressObserverAssociatedPtr.prototype.constructor =
      PlatformModelProgressObserverAssociatedPtr;

  function PlatformModelProgressObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  PlatformModelProgressObserverPtr.prototype.progress = function() {
    return PlatformModelProgressObserverProxy.prototype.progress
        .apply(this.ptr.getProxy(), arguments);
  };

  PlatformModelProgressObserverProxy.prototype.progress = function(progress) {
    var params_ = new PlatformModelProgressObserver_Progress_Params();
    params_.progress = progress;
    var builder = new codec.MessageV0Builder(
        kPlatformModelProgressObserver_Progress_Name,
        codec.align(PlatformModelProgressObserver_Progress_Params.encodedSize));
    builder.encodeStruct(PlatformModelProgressObserver_Progress_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PlatformModelProgressObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  PlatformModelProgressObserverStub.prototype.progress = function(progress) {
    return this.delegate_ && this.delegate_.progress && this.delegate_.progress(progress);
  }

  PlatformModelProgressObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPlatformModelProgressObserver_Progress_Name:
      var params = reader.decodeStruct(PlatformModelProgressObserver_Progress_Params);
      this.progress(params.progress);
      return true;
    default:
      return false;
    }
  };

  PlatformModelProgressObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validatePlatformModelProgressObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPlatformModelProgressObserver_Progress_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PlatformModelProgressObserver_Progress_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePlatformModelProgressObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var PlatformModelProgressObserver = {
    name: 'mantis.mojom.PlatformModelProgressObserver',
    kVersion: 0,
    ptrClass: PlatformModelProgressObserverPtr,
    proxyClass: PlatformModelProgressObserverProxy,
    stubClass: PlatformModelProgressObserverStub,
    validateRequest: validatePlatformModelProgressObserverRequest,
    validateResponse: null,
  };
  PlatformModelProgressObserverStub.prototype.validator = validatePlatformModelProgressObserverRequest;
  PlatformModelProgressObserverProxy.prototype.validator = null;
  var kMantisService_GetMantisFeatureStatus_Name = 1;
  var kMantisService_Initialize_Name = 0;

  function MantisServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MantisService,
                                                   handleOrPtrInfo);
  }

  function MantisServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MantisService, associatedInterfacePtrInfo);
  }

  MantisServiceAssociatedPtr.prototype =
      Object.create(MantisServicePtr.prototype);
  MantisServiceAssociatedPtr.prototype.constructor =
      MantisServiceAssociatedPtr;

  function MantisServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  MantisServicePtr.prototype.getMantisFeatureStatus = function() {
    return MantisServiceProxy.prototype.getMantisFeatureStatus
        .apply(this.ptr.getProxy(), arguments);
  };

  MantisServiceProxy.prototype.getMantisFeatureStatus = function() {
    var params_ = new MantisService_GetMantisFeatureStatus_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMantisService_GetMantisFeatureStatus_Name,
          codec.align(MantisService_GetMantisFeatureStatus_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MantisService_GetMantisFeatureStatus_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MantisService_GetMantisFeatureStatus_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MantisServicePtr.prototype.initialize = function() {
    return MantisServiceProxy.prototype.initialize
        .apply(this.ptr.getProxy(), arguments);
  };

  MantisServiceProxy.prototype.initialize = function(progressObserver, processor, dlcUuid, textClassifier) {
    var params_ = new MantisService_Initialize_Params();
    params_.progressObserver = progressObserver;
    params_.processor = processor;
    params_.dlcUuid = dlcUuid;
    params_.textClassifier = textClassifier;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMantisService_Initialize_Name,
          codec.align(MantisService_Initialize_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MantisService_Initialize_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MantisService_Initialize_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function MantisServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  MantisServiceStub.prototype.getMantisFeatureStatus = function() {
    return this.delegate_ && this.delegate_.getMantisFeatureStatus && this.delegate_.getMantisFeatureStatus();
  }
  MantisServiceStub.prototype.initialize = function(progressObserver, processor, dlcUuid, textClassifier) {
    return this.delegate_ && this.delegate_.initialize && this.delegate_.initialize(progressObserver, processor, dlcUuid, textClassifier);
  }

  MantisServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  MantisServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMantisService_GetMantisFeatureStatus_Name:
      var params = reader.decodeStruct(MantisService_GetMantisFeatureStatus_Params);
      this.getMantisFeatureStatus().then(function(response) {
        var responseParams =
            new MantisService_GetMantisFeatureStatus_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kMantisService_GetMantisFeatureStatus_Name,
            codec.align(MantisService_GetMantisFeatureStatus_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MantisService_GetMantisFeatureStatus_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMantisService_Initialize_Name:
      var params = reader.decodeStruct(MantisService_Initialize_Params);
      this.initialize(params.progressObserver, params.processor, params.dlcUuid, params.textClassifier).then(function(response) {
        var responseParams =
            new MantisService_Initialize_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kMantisService_Initialize_Name,
            codec.align(MantisService_Initialize_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MantisService_Initialize_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateMantisServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMantisService_GetMantisFeatureStatus_Name:
        if (message.expectsResponse())
          paramsClass = MantisService_GetMantisFeatureStatus_Params;
      break;
      case kMantisService_Initialize_Name:
        if (message.expectsResponse())
          paramsClass = MantisService_Initialize_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMantisServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kMantisService_GetMantisFeatureStatus_Name:
        if (message.isResponse())
          paramsClass = MantisService_GetMantisFeatureStatus_ResponseParams;
        break;
      case kMantisService_Initialize_Name:
        if (message.isResponse())
          paramsClass = MantisService_Initialize_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var MantisService = {
    name: 'mantis.mojom.MantisService',
    kVersion: 4,
    ptrClass: MantisServicePtr,
    proxyClass: MantisServiceProxy,
    stubClass: MantisServiceStub,
    validateRequest: validateMantisServiceRequest,
    validateResponse: validateMantisServiceResponse,
  };
  MantisServiceStub.prototype.validator = validateMantisServiceRequest;
  MantisServiceProxy.prototype.validator = validateMantisServiceResponse;
  exports.MantisFeatureStatus = MantisFeatureStatus;
  exports.InitializeResult = InitializeResult;
  exports.PlatformModelProgressObserver = PlatformModelProgressObserver;
  exports.PlatformModelProgressObserverPtr = PlatformModelProgressObserverPtr;
  exports.PlatformModelProgressObserverAssociatedPtr = PlatformModelProgressObserverAssociatedPtr;
  exports.MantisService = MantisService;
  exports.MantisServicePtr = MantisServicePtr;
  exports.MantisServiceAssociatedPtr = MantisServiceAssociatedPtr;
})();