// chromeos/ash/components/mantis/mojom/mantis_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Uuid as mojoBase_mojom_Uuid,
  UuidSpec as mojoBase_mojom_UuidSpec
} from '../../../../../mojo/public/mojom/base/uuid.mojom.m.js';

import {
  TextClassifierRemote as chromeos_machineLearning_mojom_TextClassifierRemote,
  TextClassifierPendingReceiver as chromeos_machineLearning_mojom_TextClassifierPendingReceiver
} from '../../../../services/machine_learning/public/mojom/text_classifier.mojom.m.js';

import {
  MantisProcessorRemote as mantis_mojom_MantisProcessorRemote,
  MantisProcessorPendingReceiver as mantis_mojom_MantisProcessorPendingReceiver
} from './mantis_processor.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MantisFeatureStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MantisFeatureStatus = {
  
  kDeviceNotSupported: 0,
  kARCVMDisabled: 1,
  kAvailable: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const InitializeResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const InitializeResult = {
  
  kSuccess: 0,
  kGpuBlocked: 1,
  kFailedToLoadLibrary: 2,
  kFailedToLoadSafetyService: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PlatformModelProgressObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'mantis.mojom.PlatformModelProgressObserver', scope);
  }
}

/** @interface */
export class PlatformModelProgressObserverInterface {
  
  /**
   * @param { !number } progress
   */

  progress(progress) {}
}

/**
 * @implements { PlatformModelProgressObserverInterface }
 */
export class PlatformModelProgressObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PlatformModelProgressObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PlatformModelProgressObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PlatformModelProgressObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } progress
   */

  progress(
      progress) {
    this.proxy.sendMessage(
        0,
        PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        [
          progress
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PlatformModelProgressObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PlatformModelProgressObserverReceiver {
  /**
   * @param {!PlatformModelProgressObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PlatformModelProgressObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PlatformModelProgressObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PlatformModelProgressObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        impl.progress.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PlatformModelProgressObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "mantis.mojom.PlatformModelProgressObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PlatformModelProgressObserverRemote}
   */
  static getRemote() {
    let remote = new PlatformModelProgressObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PlatformModelProgressObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PlatformModelProgressObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PlatformModelProgressObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PlatformModelProgressObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.progress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PlatformModelProgressObserver_Progress_ParamsSpec.$,
        null,
        this.progress.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MantisServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'mantis.mojom.MantisService', scope);
  }
}

/** @interface */
export class MantisServiceInterface {
  
  /**
   * @return {!Promise<{
        status: !MantisFeatureStatus,
   *  }>}
   */

  getMantisFeatureStatus() {}
  
  /**
   * @param { ?PlatformModelProgressObserverRemote } progressObserver
   * @param { !mantis_mojom_MantisProcessorPendingReceiver } processor
   * @param { ?mojoBase_mojom_Uuid } dlcUuid
   * @param { ?chromeos_machineLearning_mojom_TextClassifierRemote } textClassifier
   * @return {!Promise<{
        result: !InitializeResult,
   *  }>}
   */

  initialize(progressObserver, processor, dlcUuid, textClassifier) {}
}

/**
 * @implements { MantisServiceInterface }
 */
export class MantisServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MantisServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MantisServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MantisServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        status: !MantisFeatureStatus,
   *  }>}
   */

  getMantisFeatureStatus() {
    return this.proxy.sendMessage(
        1,
        MantisService_GetMantisFeatureStatus_ParamsSpec.$,
        MantisService_GetMantisFeatureStatus_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { ?PlatformModelProgressObserverRemote } progressObserver
   * @param { !mantis_mojom_MantisProcessorPendingReceiver } processor
   * @param { ?mojoBase_mojom_Uuid } dlcUuid
   * @param { ?chromeos_machineLearning_mojom_TextClassifierRemote } textClassifier
   * @return {!Promise<{
        result: !InitializeResult,
   *  }>}
   */

  initialize(
      progressObserver,
      processor,
      dlcUuid,
      textClassifier) {
    return this.proxy.sendMessage(
        0,
        MantisService_Initialize_ParamsSpec.$,
        MantisService_Initialize_ResponseParamsSpec.$,
        [
          progressObserver,
          processor,
          dlcUuid,
          textClassifier
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MantisService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MantisServiceReceiver {
  /**
   * @param {!MantisServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MantisServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MantisServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MantisServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        1,
        MantisService_GetMantisFeatureStatus_ParamsSpec.$,
        MantisService_GetMantisFeatureStatus_ResponseParamsSpec.$,
        impl.getMantisFeatureStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        0,
        MantisService_Initialize_ParamsSpec.$,
        MantisService_Initialize_ResponseParamsSpec.$,
        impl.initialize.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MantisService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "mantis.mojom.MantisService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MantisServiceRemote}
   */
  static getRemote() {
    let remote = new MantisServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MantisService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MantisServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MantisServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MantisServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getMantisFeatureStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MantisService_GetMantisFeatureStatus_ParamsSpec.$,
        MantisService_GetMantisFeatureStatus_ResponseParamsSpec.$,
        this.getMantisFeatureStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initialize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MantisService_Initialize_ParamsSpec.$,
        MantisService_Initialize_ResponseParamsSpec.$,
        this.initialize.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlatformModelProgressObserver_Progress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisService_GetMantisFeatureStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisService_GetMantisFeatureStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisService_Initialize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MantisService_Initialize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PlatformModelProgressObserver_Progress_ParamsSpec.$,
    'PlatformModelProgressObserver_Progress_Params',
    [
      mojo.internal.StructField(
        'progress', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PlatformModelProgressObserver_Progress_Params {
  constructor() {
    /** @type { !number } */
    this.progress;
  }
}



mojo.internal.Struct(
    MantisService_GetMantisFeatureStatus_ParamsSpec.$,
    'MantisService_GetMantisFeatureStatus_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MantisService_GetMantisFeatureStatus_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MantisService_GetMantisFeatureStatus_ResponseParamsSpec.$,
    'MantisService_GetMantisFeatureStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        MantisFeatureStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MantisService_GetMantisFeatureStatus_ResponseParams {
  constructor() {
    /** @type { !MantisFeatureStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    MantisService_Initialize_ParamsSpec.$,
    'MantisService_Initialize_Params',
    [
      mojo.internal.StructField(
        'progressObserver', 0,
        0,
        mojo.internal.InterfaceProxy(PlatformModelProgressObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'processor', 8,
        0,
        mojo.internal.InterfaceRequest(mantis_mojom_MantisProcessorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dlcUuid', 16,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        true /* nullable */,
        3,
      ),
      mojo.internal.StructField(
        'textClassifier', 24,
        0,
        mojo.internal.InterfaceProxy(chromeos_machineLearning_mojom_TextClassifierRemote),
        null,
        true /* nullable */,
        4,
      ),
    ],
    [[0, 24],[3, 32],[4, 40],]);



/**
 * @record
 */
export class MantisService_Initialize_Params {
  constructor() {
    /** @type { (PlatformModelProgressObserverRemote|undefined) } */
    this.progressObserver;
    /** @type { !mantis_mojom_MantisProcessorPendingReceiver } */
    this.processor;
    /** @type { (mojoBase_mojom_Uuid|undefined) } */
    this.dlcUuid;
    /** @type { (chromeos_machineLearning_mojom_TextClassifierRemote|undefined) } */
    this.textClassifier;
  }
}



mojo.internal.Struct(
    MantisService_Initialize_ResponseParamsSpec.$,
    'MantisService_Initialize_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        InitializeResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MantisService_Initialize_ResponseParams {
  constructor() {
    /** @type { !InitializeResult } */
    this.result;
  }
}

