// chromeos/ash/services/ime/public/mojom/connection_factory.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('ash.ime.mojom.InputMethod');
goog.require('ash.ime.mojom.InputMethodHost');
goog.require('ash.ime.mojom.JpUnused');
goog.require('ash.ime.mojom.InputMethodSettings');






goog.provide('ash.ime.mojom.ConnectionFactory');
goog.provide('ash.ime.mojom.ConnectionFactoryReceiver');
goog.provide('ash.ime.mojom.ConnectionFactoryCallbackRouter');
goog.provide('ash.ime.mojom.ConnectionFactoryInterface');
goog.provide('ash.ime.mojom.ConnectionFactoryRemote');
goog.provide('ash.ime.mojom.ConnectionFactoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.ime.mojom.ConnectionFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.ime.mojom.ConnectionFactory.$interfaceName,
        scope);
  }
};

/** @interface */
ash.ime.mojom.ConnectionFactoryInterface = class {
  
  /**
   * @param { !string } imeSpec
   * @param { !Object } inputMethod
   * @param { !Object } inputMethodHost
   * @param { ?ash.ime.mojom.InputMethodSettings } settings
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  connectToInputMethod(imeSpec, inputMethod, inputMethodHost, settings) {}
  
  /**
   * @param { !Object } unused
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  unused(unused) {}
};

/**
 * @export
 * @implements { ash.ime.mojom.ConnectionFactoryInterface }
 */
ash.ime.mojom.ConnectionFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.ime.mojom.ConnectionFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.ime.mojom.ConnectionFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.ime.mojom.ConnectionFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } imeSpec
   * @param { !Object } inputMethod
   * @param { !Object } inputMethodHost
   * @param { ?ash.ime.mojom.InputMethodSettings } settings
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  connectToInputMethod(
      imeSpec,
      inputMethod,
      inputMethodHost,
      settings) {
    return this.proxy.sendMessage(
        0,
        ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ParamsSpec.$,
        ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ResponseParamsSpec.$,
        [
          imeSpec,
          inputMethod,
          inputMethodHost,
          settings
        ],
        false);
  }

  
  /**
   * @param { !Object } unused
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  unused(
      unused) {
    return this.proxy.sendMessage(
        1,
        ash.ime.mojom.ConnectionFactory_Unused_ParamsSpec.$,
        ash.ime.mojom.ConnectionFactory_Unused_ResponseParamsSpec.$,
        [
          unused
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ConnectionFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.ime.mojom.ConnectionFactoryReceiver = class {
  /**
   * @param {!ash.ime.mojom.ConnectionFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.ime.mojom.ConnectionFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.ime.mojom.ConnectionFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.ConnectionFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ParamsSpec.$,
        ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ResponseParamsSpec.$,
        impl.connectToInputMethod.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.ime.mojom.ConnectionFactory_Unused_ParamsSpec.$,
        ash.ime.mojom.ConnectionFactory_Unused_ResponseParamsSpec.$,
        impl.unused.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.ime.mojom.ConnectionFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.ConnectionFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.ime.mojom.ConnectionFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.ime.mojom.ConnectionFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ConnectionFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.ime.mojom.ConnectionFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.ime.mojom.ConnectionFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.ConnectionFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connectToInputMethod =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ParamsSpec.$,
        ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ResponseParamsSpec.$,
        this.connectToInputMethod.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unused =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.ime.mojom.ConnectionFactory_Unused_ParamsSpec.$,
        ash.ime.mojom.ConnectionFactory_Unused_ResponseParamsSpec.$,
        this.unused.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.ConnectionFactory_Unused_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.ConnectionFactory_Unused_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.ConnectionFactory_Unused_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.ConnectionFactory_Unused_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ParamsSpec.$,
    'ConnectionFactory_ConnectToInputMethod_Params',
    [
      mojo.internal.StructField(
        'imeSpec', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputMethod', 8,
        0,
        mojo.internal.AssociatedInterfaceRequest(ash.ime.mojom.InputMethodPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputMethodHost', 12,
        0,
        mojo.internal.AssociatedInterfaceProxy(ash.ime.mojom.InputMethodHostRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'settings', 24,
        0,
        ash.ime.mojom.InputMethodSettingsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],[2, 48],]);



goog.provide('ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_Params');

/** @record */
ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_Params = class {
  constructor() {
    /** @export { !string } */
    this.imeSpec;
    /** @export { !Object } */
    this.inputMethod;
    /** @export { !Object } */
    this.inputMethodHost;
    /** @export { (ash.ime.mojom.InputMethodSettings|undefined) } */
    this.settings;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ResponseParamsSpec.$,
    'ConnectionFactory_ConnectToInputMethod_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ResponseParams');

/** @record */
ash.ime.mojom.ConnectionFactory_ConnectToInputMethod_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.ConnectionFactory_Unused_ParamsSpec.$,
    'ConnectionFactory_Unused_Params',
    [
      mojo.internal.StructField(
        'unused', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(ash.ime.mojom.JpUnusedPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.ConnectionFactory_Unused_Params');

/** @record */
ash.ime.mojom.ConnectionFactory_Unused_Params = class {
  constructor() {
    /** @export { !Object } */
    this.unused;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.ConnectionFactory_Unused_ResponseParamsSpec.$,
    'ConnectionFactory_Unused_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.ConnectionFactory_Unused_ResponseParams');

/** @record */
ash.ime.mojom.ConnectionFactory_Unused_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};

