// chromeos/ash/services/ime/public/mojom/connection_factory.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/ash/services/ime/public/mojom/connection_factory.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ash.ime.mojom');
  var input_method$ =
      mojo.internal.exposeNamespace('ash.ime.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/ash/services/ime/public/mojom/input_method.mojom', 'input_method.mojom.js');
  }
  var input_method_host$ =
      mojo.internal.exposeNamespace('ash.ime.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/ash/services/ime/public/mojom/input_method_host.mojom', 'input_method_host.mojom.js');
  }
  var japanese_settings$ =
      mojo.internal.exposeNamespace('ash.ime.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/ash/services/ime/public/mojom/japanese_settings.mojom', 'japanese_settings.mojom.js');
  }



  function ConnectionFactory_ConnectToInputMethod_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ConnectionFactory_ConnectToInputMethod_Params.prototype.initDefaults_ = function() {
    this.imeSpec = null;
    this.inputMethod = new associatedBindings.AssociatedInterfaceRequest();
    this.inputMethodHost = new associatedBindings.AssociatedInterfacePtrInfo();
    this.settings = null;
  };
  ConnectionFactory_ConnectToInputMethod_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ConnectionFactory_ConnectToInputMethod_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32},
      {version: 2, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ConnectionFactory_ConnectToInputMethod_Params.imeSpec
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ConnectionFactory_ConnectToInputMethod_Params.inputMethod
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ConnectionFactory_ConnectToInputMethod_Params.inputMethodHost
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 12, false);
    if (err !== validator.validationError.NONE)
        return err;



    // version check ConnectionFactory_ConnectToInputMethod_Params.settings
    if (!messageValidator.isFieldInStructVersion(offset, 2))
      return validator.validationError.NONE;
    // validate ConnectionFactory_ConnectToInputMethod_Params.settings
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 24, input_method$.InputMethodSettings, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ConnectionFactory_ConnectToInputMethod_Params.encodedSize = codec.kStructHeaderSize + 40;

  ConnectionFactory_ConnectToInputMethod_Params.decode = function(decoder) {
    var packed;
    var val = new ConnectionFactory_ConnectToInputMethod_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.imeSpec =
        decoder.decodeStruct(codec.String);
    val.inputMethod =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.inputMethodHost =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 2) {
      val.settings =
          decoder.decodeStruct(input_method$.InputMethodSettings);
    } else {
      val.settings = null;
    }
    return val;
  };

  ConnectionFactory_ConnectToInputMethod_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ConnectionFactory_ConnectToInputMethod_Params.encodedSize);
    encoder.writeUint32(2);
    encoder.encodeStruct(codec.String, val.imeSpec);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.inputMethod);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.inputMethodHost);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(input_method$.InputMethodSettings, val.settings);
  };
  function ConnectionFactory_ConnectToInputMethod_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ConnectionFactory_ConnectToInputMethod_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  ConnectionFactory_ConnectToInputMethod_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ConnectionFactory_ConnectToInputMethod_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ConnectionFactory_ConnectToInputMethod_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ConnectionFactory_ConnectToInputMethod_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ConnectionFactory_ConnectToInputMethod_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ConnectionFactory_ConnectToInputMethod_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ConnectionFactory_ConnectToInputMethod_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ConnectionFactory_Unused_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ConnectionFactory_Unused_Params.prototype.initDefaults_ = function() {
    this.unused = new associatedBindings.AssociatedInterfaceRequest();
  };
  ConnectionFactory_Unused_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ConnectionFactory_Unused_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ConnectionFactory_Unused_Params.unused
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ConnectionFactory_Unused_Params.encodedSize = codec.kStructHeaderSize + 8;

  ConnectionFactory_Unused_Params.decode = function(decoder) {
    var packed;
    var val = new ConnectionFactory_Unused_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.unused =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ConnectionFactory_Unused_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ConnectionFactory_Unused_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.unused);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ConnectionFactory_Unused_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ConnectionFactory_Unused_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  ConnectionFactory_Unused_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ConnectionFactory_Unused_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ConnectionFactory_Unused_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  ConnectionFactory_Unused_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ConnectionFactory_Unused_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ConnectionFactory_Unused_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ConnectionFactory_Unused_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kConnectionFactory_ConnectToInputMethod_Name = 0;
  var kConnectionFactory_Unused_Name = 1;

  function ConnectionFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ConnectionFactory,
                                                   handleOrPtrInfo);
  }

  function ConnectionFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ConnectionFactory, associatedInterfacePtrInfo);
  }

  ConnectionFactoryAssociatedPtr.prototype =
      Object.create(ConnectionFactoryPtr.prototype);
  ConnectionFactoryAssociatedPtr.prototype.constructor =
      ConnectionFactoryAssociatedPtr;

  function ConnectionFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  ConnectionFactoryPtr.prototype.connectToInputMethod = function() {
    return ConnectionFactoryProxy.prototype.connectToInputMethod
        .apply(this.ptr.getProxy(), arguments);
  };

  ConnectionFactoryProxy.prototype.connectToInputMethod = function(imeSpec, inputMethod, inputMethodHost, settings) {
    var params_ = new ConnectionFactory_ConnectToInputMethod_Params();
    params_.imeSpec = imeSpec;
    params_.inputMethod = inputMethod;
    params_.inputMethodHost = inputMethodHost;
    params_.settings = settings;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kConnectionFactory_ConnectToInputMethod_Name,
          codec.align(ConnectionFactory_ConnectToInputMethod_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(ConnectionFactory_ConnectToInputMethod_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ConnectionFactory_ConnectToInputMethod_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ConnectionFactoryPtr.prototype.unused = function() {
    return ConnectionFactoryProxy.prototype.unused
        .apply(this.ptr.getProxy(), arguments);
  };

  ConnectionFactoryProxy.prototype.unused = function(unused) {
    var params_ = new ConnectionFactory_Unused_Params();
    params_.unused = unused;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kConnectionFactory_Unused_Name,
          codec.align(ConnectionFactory_Unused_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(ConnectionFactory_Unused_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ConnectionFactory_Unused_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function ConnectionFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  ConnectionFactoryStub.prototype.connectToInputMethod = function(imeSpec, inputMethod, inputMethodHost, settings) {
    return this.delegate_ && this.delegate_.connectToInputMethod && this.delegate_.connectToInputMethod(imeSpec, inputMethod, inputMethodHost, settings);
  }
  ConnectionFactoryStub.prototype.unused = function(unused) {
    return this.delegate_ && this.delegate_.unused && this.delegate_.unused(unused);
  }

  ConnectionFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  ConnectionFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kConnectionFactory_ConnectToInputMethod_Name:
      var params = reader.decodeStruct(ConnectionFactory_ConnectToInputMethod_Params);
      this.connectToInputMethod(params.imeSpec, params.inputMethod, params.inputMethodHost, params.settings).then(function(response) {
        var responseParams =
            new ConnectionFactory_ConnectToInputMethod_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV2Builder(
            kConnectionFactory_ConnectToInputMethod_Name,
            codec.align(ConnectionFactory_ConnectToInputMethod_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(ConnectionFactory_ConnectToInputMethod_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kConnectionFactory_Unused_Name:
      var params = reader.decodeStruct(ConnectionFactory_Unused_Params);
      this.unused(params.unused).then(function(response) {
        var responseParams =
            new ConnectionFactory_Unused_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV2Builder(
            kConnectionFactory_Unused_Name,
            codec.align(ConnectionFactory_Unused_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(ConnectionFactory_Unused_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateConnectionFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kConnectionFactory_ConnectToInputMethod_Name:
        if (message.expectsResponse())
          paramsClass = ConnectionFactory_ConnectToInputMethod_Params;
      break;
      case kConnectionFactory_Unused_Name:
        if (message.expectsResponse())
          paramsClass = ConnectionFactory_Unused_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateConnectionFactoryResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kConnectionFactory_ConnectToInputMethod_Name:
        if (message.isResponse())
          paramsClass = ConnectionFactory_ConnectToInputMethod_ResponseParams;
        break;
      case kConnectionFactory_Unused_Name:
        if (message.isResponse())
          paramsClass = ConnectionFactory_Unused_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var ConnectionFactory = {
    name: 'ash.ime.mojom.ConnectionFactory',
    kVersion: 3,
    ptrClass: ConnectionFactoryPtr,
    proxyClass: ConnectionFactoryProxy,
    stubClass: ConnectionFactoryStub,
    validateRequest: validateConnectionFactoryRequest,
    validateResponse: validateConnectionFactoryResponse,
  };
  ConnectionFactoryStub.prototype.validator = validateConnectionFactoryRequest;
  ConnectionFactoryProxy.prototype.validator = validateConnectionFactoryResponse;
  exports.ConnectionFactory = ConnectionFactory;
  exports.ConnectionFactoryPtr = ConnectionFactoryPtr;
  exports.ConnectionFactoryAssociatedPtr = ConnectionFactoryAssociatedPtr;
})();