// chromeos/ash/services/ime/public/mojom/connection_factory.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../../mojo/public/js/bindings.js';

import {
  InputMethodRemote as ash_ime_mojom_InputMethodRemote,
  InputMethodPendingReceiver as ash_ime_mojom_InputMethodPendingReceiver,
  InputMethodSettings as ash_ime_mojom_InputMethodSettings,
  InputMethodSettingsSpec as ash_ime_mojom_InputMethodSettingsSpec
} from './input_method.mojom.m.js';

import {
  InputMethodHostRemote as ash_ime_mojom_InputMethodHostRemote,
  InputMethodHostPendingReceiver as ash_ime_mojom_InputMethodHostPendingReceiver
} from './input_method_host.mojom.m.js';

import {
  JpUnusedRemote as ash_ime_mojom_JpUnusedRemote,
  JpUnusedPendingReceiver as ash_ime_mojom_JpUnusedPendingReceiver
} from './japanese_settings.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ConnectionFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.ime.mojom.ConnectionFactory', scope);
  }
}

/** @interface */
export class ConnectionFactoryInterface {
  
  /**
   * @param { !string } imeSpec
   * @param { !Object } inputMethod
   * @param { !Object } inputMethodHost
   * @param { ?ash_ime_mojom_InputMethodSettings } settings
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  connectToInputMethod(imeSpec, inputMethod, inputMethodHost, settings) {}
  
  /**
   * @param { !Object } unused
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  unused(unused) {}
}

/**
 * @implements { ConnectionFactoryInterface }
 */
export class ConnectionFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ConnectionFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ConnectionFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ConnectionFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } imeSpec
   * @param { !Object } inputMethod
   * @param { !Object } inputMethodHost
   * @param { ?ash_ime_mojom_InputMethodSettings } settings
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  connectToInputMethod(
      imeSpec,
      inputMethod,
      inputMethodHost,
      settings) {
    return this.proxy.sendMessage(
        0,
        ConnectionFactory_ConnectToInputMethod_ParamsSpec.$,
        ConnectionFactory_ConnectToInputMethod_ResponseParamsSpec.$,
        [
          imeSpec,
          inputMethod,
          inputMethodHost,
          settings
        ],
        false);
  }

  
  /**
   * @param { !Object } unused
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  unused(
      unused) {
    return this.proxy.sendMessage(
        1,
        ConnectionFactory_Unused_ParamsSpec.$,
        ConnectionFactory_Unused_ResponseParamsSpec.$,
        [
          unused
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ConnectionFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ConnectionFactoryReceiver {
  /**
   * @param {!ConnectionFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ConnectionFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ConnectionFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ConnectionFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ConnectionFactory_ConnectToInputMethod_ParamsSpec.$,
        ConnectionFactory_ConnectToInputMethod_ResponseParamsSpec.$,
        impl.connectToInputMethod.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ConnectionFactory_Unused_ParamsSpec.$,
        ConnectionFactory_Unused_ResponseParamsSpec.$,
        impl.unused.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ConnectionFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.ConnectionFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ConnectionFactoryRemote}
   */
  static getRemote() {
    let remote = new ConnectionFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ConnectionFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ConnectionFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ConnectionFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ConnectionFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connectToInputMethod =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ConnectionFactory_ConnectToInputMethod_ParamsSpec.$,
        ConnectionFactory_ConnectToInputMethod_ResponseParamsSpec.$,
        this.connectToInputMethod.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unused =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ConnectionFactory_Unused_ParamsSpec.$,
        ConnectionFactory_Unused_ResponseParamsSpec.$,
        this.unused.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ConnectionFactory_ConnectToInputMethod_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ConnectionFactory_ConnectToInputMethod_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ConnectionFactory_Unused_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ConnectionFactory_Unused_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ConnectionFactory_ConnectToInputMethod_ParamsSpec.$,
    'ConnectionFactory_ConnectToInputMethod_Params',
    [
      mojo.internal.StructField(
        'imeSpec', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputMethod', 8,
        0,
        mojo.internal.AssociatedInterfaceRequest(ash_ime_mojom_InputMethodPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputMethodHost', 12,
        0,
        mojo.internal.AssociatedInterfaceProxy(ash_ime_mojom_InputMethodHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'settings', 24,
        0,
        ash_ime_mojom_InputMethodSettingsSpec.$,
        null,
        true /* nullable */,
        2,
      ),
    ],
    [[0, 32],[2, 48],]);



/**
 * @record
 */
export class ConnectionFactory_ConnectToInputMethod_Params {
  constructor() {
    /** @type { !string } */
    this.imeSpec;
    /** @type { !Object } */
    this.inputMethod;
    /** @type { !Object } */
    this.inputMethodHost;
    /** @type { (ash_ime_mojom_InputMethodSettings|undefined) } */
    this.settings;
  }
}



mojo.internal.Struct(
    ConnectionFactory_ConnectToInputMethod_ResponseParamsSpec.$,
    'ConnectionFactory_ConnectToInputMethod_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ConnectionFactory_ConnectToInputMethod_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    ConnectionFactory_Unused_ParamsSpec.$,
    'ConnectionFactory_Unused_Params',
    [
      mojo.internal.StructField(
        'unused', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(ash_ime_mojom_JpUnusedPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ConnectionFactory_Unused_Params {
  constructor() {
    /** @type { !Object } */
    this.unused;
  }
}



mojo.internal.Struct(
    ConnectionFactory_Unused_ResponseParamsSpec.$,
    'ConnectionFactory_Unused_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ConnectionFactory_Unused_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}

