// chromeos/ash/services/ime/public/mojom/ime_service.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('ash.ime.mojom.ConnectionFactory');
goog.require('ash.ime.mojom.InputChannel');
goog.require('ash.ime.mojom.InputMethodUserDataService');
goog.require('mojoBase.mojom.FilePath');
goog.require('url.mojom.Url');






goog.provide('ash.ime.mojom.InputEngineManager');
goog.provide('ash.ime.mojom.InputEngineManagerReceiver');
goog.provide('ash.ime.mojom.InputEngineManagerCallbackRouter');
goog.provide('ash.ime.mojom.InputEngineManagerInterface');
goog.provide('ash.ime.mojom.InputEngineManagerRemote');
goog.provide('ash.ime.mojom.InputEngineManagerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.ime.mojom.InputEngineManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.ime.mojom.InputEngineManager.$interfaceName,
        scope);
  }
};

/** @interface */
ash.ime.mojom.InputEngineManagerInterface = class {
  
  /**
   * @param { !string } imeSpec
   * @param { !ash.ime.mojom.InputChannelPendingReceiver } toEngineRequest
   * @param { !ash.ime.mojom.InputChannelRemote } fromEngine
   * @param { !Array<!number> } extra
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  connectToImeEngine(imeSpec, toEngineRequest, fromEngine, extra) {}
  
  /**
   * @param { !ash.ime.mojom.ConnectionFactoryPendingReceiver } connectionFactory
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initializeConnectionFactory(connectionFactory) {}
};

/**
 * @export
 * @implements { ash.ime.mojom.InputEngineManagerInterface }
 */
ash.ime.mojom.InputEngineManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.ime.mojom.InputEngineManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.ime.mojom.InputEngineManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.ime.mojom.InputEngineManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } imeSpec
   * @param { !ash.ime.mojom.InputChannelPendingReceiver } toEngineRequest
   * @param { !ash.ime.mojom.InputChannelRemote } fromEngine
   * @param { !Array<!number> } extra
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  connectToImeEngine(
      imeSpec,
      toEngineRequest,
      fromEngine,
      extra) {
    return this.proxy.sendMessage(
        0,
        ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ParamsSpec.$,
        ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ResponseParamsSpec.$,
        [
          imeSpec,
          toEngineRequest,
          fromEngine,
          extra
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.ConnectionFactoryPendingReceiver } connectionFactory
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initializeConnectionFactory(
      connectionFactory) {
    return this.proxy.sendMessage(
        1,
        ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ParamsSpec.$,
        ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ResponseParamsSpec.$,
        [
          connectionFactory
        ],
        false);
  }
};

/**
 * An object which receives request messages for the InputEngineManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.ime.mojom.InputEngineManagerReceiver = class {
  /**
   * @param {!ash.ime.mojom.InputEngineManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.ime.mojom.InputEngineManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.ime.mojom.InputEngineManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.InputEngineManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ParamsSpec.$,
        ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ResponseParamsSpec.$,
        impl.connectToImeEngine.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ParamsSpec.$,
        ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ResponseParamsSpec.$,
        impl.initializeConnectionFactory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.ime.mojom.InputEngineManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.InputEngineManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.ime.mojom.InputEngineManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.ime.mojom.InputEngineManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the InputEngineManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.ime.mojom.InputEngineManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.ime.mojom.InputEngineManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.InputEngineManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connectToImeEngine =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ParamsSpec.$,
        ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ResponseParamsSpec.$,
        this.connectToImeEngine.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initializeConnectionFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ParamsSpec.$,
        ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ResponseParamsSpec.$,
        this.initializeConnectionFactory.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('ash.ime.mojom.PlatformAccessProvider');
goog.provide('ash.ime.mojom.PlatformAccessProviderReceiver');
goog.provide('ash.ime.mojom.PlatformAccessProviderCallbackRouter');
goog.provide('ash.ime.mojom.PlatformAccessProviderInterface');
goog.provide('ash.ime.mojom.PlatformAccessProviderRemote');
goog.provide('ash.ime.mojom.PlatformAccessProviderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.ime.mojom.PlatformAccessProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.ime.mojom.PlatformAccessProvider.$interfaceName,
        scope);
  }
};

/** @interface */
ash.ime.mojom.PlatformAccessProviderInterface = class {
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !mojoBase.mojom.FilePath } filePath
   * @return {!Promise<{
        filePath: !mojoBase.mojom.FilePath,
   *  }>}
   */

  downloadImeFileTo(url, filePath) {}
};

/**
 * @export
 * @implements { ash.ime.mojom.PlatformAccessProviderInterface }
 */
ash.ime.mojom.PlatformAccessProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.ime.mojom.PlatformAccessProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.ime.mojom.PlatformAccessProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.ime.mojom.PlatformAccessProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !mojoBase.mojom.FilePath } filePath
   * @return {!Promise<{
        filePath: !mojoBase.mojom.FilePath,
   *  }>}
   */

  downloadImeFileTo(
      url,
      filePath) {
    return this.proxy.sendMessage(
        0,
        ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ParamsSpec.$,
        ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ResponseParamsSpec.$,
        [
          url,
          filePath
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PlatformAccessProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.ime.mojom.PlatformAccessProviderReceiver = class {
  /**
   * @param {!ash.ime.mojom.PlatformAccessProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.ime.mojom.PlatformAccessProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.ime.mojom.PlatformAccessProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.PlatformAccessProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ParamsSpec.$,
        ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ResponseParamsSpec.$,
        impl.downloadImeFileTo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.ime.mojom.PlatformAccessProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.PlatformAccessProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.ime.mojom.PlatformAccessProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.ime.mojom.PlatformAccessProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PlatformAccessProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.ime.mojom.PlatformAccessProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.ime.mojom.PlatformAccessProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.PlatformAccessProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.downloadImeFileTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ParamsSpec.$,
        ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ResponseParamsSpec.$,
        this.downloadImeFileTo.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('ash.ime.mojom.ImeService');
goog.provide('ash.ime.mojom.ImeServiceReceiver');
goog.provide('ash.ime.mojom.ImeServiceCallbackRouter');
goog.provide('ash.ime.mojom.ImeServiceInterface');
goog.provide('ash.ime.mojom.ImeServiceRemote');
goog.provide('ash.ime.mojom.ImeServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.ime.mojom.ImeServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.ime.mojom.ImeService.$interfaceName,
        scope);
  }
};

/** @interface */
ash.ime.mojom.ImeServiceInterface = class {
  
  /**
   * @param { !ash.ime.mojom.PlatformAccessProviderRemote } provider
   */

  setPlatformAccessProvider(provider) {}
  
  /**
   * @param { !ash.ime.mojom.InputEngineManagerPendingReceiver } receiver
   */

  bindInputEngineManager(receiver) {}
  
  /**
   * @param { !ash.ime.mojom.InputMethodUserDataServicePendingReceiver } receiver
   */

  bindInputMethodUserDataService(receiver) {}
};

/**
 * @export
 * @implements { ash.ime.mojom.ImeServiceInterface }
 */
ash.ime.mojom.ImeServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.ime.mojom.ImeServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.ime.mojom.ImeServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.ime.mojom.ImeServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.ime.mojom.PlatformAccessProviderRemote } provider
   */

  setPlatformAccessProvider(
      provider) {
    this.proxy.sendMessage(
        0,
        ash.ime.mojom.ImeService_SetPlatformAccessProvider_ParamsSpec.$,
        null,
        [
          provider
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.InputEngineManagerPendingReceiver } receiver
   */

  bindInputEngineManager(
      receiver) {
    this.proxy.sendMessage(
        1,
        ash.ime.mojom.ImeService_BindInputEngineManager_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.InputMethodUserDataServicePendingReceiver } receiver
   */

  bindInputMethodUserDataService(
      receiver) {
    this.proxy.sendMessage(
        2,
        ash.ime.mojom.ImeService_BindInputMethodUserDataService_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ImeService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.ime.mojom.ImeServiceReceiver = class {
  /**
   * @param {!ash.ime.mojom.ImeServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.ime.mojom.ImeServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.ime.mojom.ImeServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.ImeServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.ImeService_SetPlatformAccessProvider_ParamsSpec.$,
        null,
        impl.setPlatformAccessProvider.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.ime.mojom.ImeService_BindInputEngineManager_ParamsSpec.$,
        null,
        impl.bindInputEngineManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.ime.mojom.ImeService_BindInputMethodUserDataService_ParamsSpec.$,
        null,
        impl.bindInputMethodUserDataService.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.ime.mojom.ImeService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.ImeService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.ime.mojom.ImeServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.ime.mojom.ImeServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ImeService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.ime.mojom.ImeServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.ime.mojom.ImeServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.ImeServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPlatformAccessProvider =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.ImeService_SetPlatformAccessProvider_ParamsSpec.$,
        null,
        this.setPlatformAccessProvider.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindInputEngineManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.ime.mojom.ImeService_BindInputEngineManager_ParamsSpec.$,
        null,
        this.bindInputEngineManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindInputMethodUserDataService =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.ime.mojom.ImeService_BindInputMethodUserDataService_ParamsSpec.$,
        null,
        this.bindInputMethodUserDataService.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.ImeService_SetPlatformAccessProvider_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.ImeService_SetPlatformAccessProvider_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.ImeService_BindInputEngineManager_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.ImeService_BindInputEngineManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.ImeService_BindInputMethodUserDataService_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.ImeService_BindInputMethodUserDataService_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ParamsSpec.$,
    'InputEngineManager_ConnectToImeEngine_Params',
    [
      mojo.internal.StructField(
        'imeSpec', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'toEngineRequest', 8,
        0,
        mojo.internal.InterfaceRequest(ash.ime.mojom.InputChannelPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fromEngine', 12,
        0,
        mojo.internal.InterfaceProxy(ash.ime.mojom.InputChannelRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extra', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('ash.ime.mojom.InputEngineManager_ConnectToImeEngine_Params');

/** @record */
ash.ime.mojom.InputEngineManager_ConnectToImeEngine_Params = class {
  constructor() {
    /** @export { !string } */
    this.imeSpec;
    /** @export { !ash.ime.mojom.InputChannelPendingReceiver } */
    this.toEngineRequest;
    /** @export { !ash.ime.mojom.InputChannelRemote } */
    this.fromEngine;
    /** @export { !Array<!number> } */
    this.extra;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ResponseParamsSpec.$,
    'InputEngineManager_ConnectToImeEngine_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ResponseParams');

/** @record */
ash.ime.mojom.InputEngineManager_ConnectToImeEngine_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ParamsSpec.$,
    'InputEngineManager_InitializeConnectionFactory_Params',
    [
      mojo.internal.StructField(
        'connectionFactory', 0,
        0,
        mojo.internal.InterfaceRequest(ash.ime.mojom.ConnectionFactoryPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_Params');

/** @record */
ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.ConnectionFactoryPendingReceiver } */
    this.connectionFactory;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ResponseParamsSpec.$,
    'InputEngineManager_InitializeConnectionFactory_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ResponseParams');

/** @record */
ash.ime.mojom.InputEngineManager_InitializeConnectionFactory_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ParamsSpec.$,
    'PlatformAccessProvider_DownloadImeFileTo_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filePath', 8,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_Params');

/** @record */
ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !mojoBase.mojom.FilePath } */
    this.filePath;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ResponseParamsSpec.$,
    'PlatformAccessProvider_DownloadImeFileTo_ResponseParams',
    [
      mojo.internal.StructField(
        'filePath', 0,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ResponseParams');

/** @record */
ash.ime.mojom.PlatformAccessProvider_DownloadImeFileTo_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FilePath } */
    this.filePath;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.ImeService_SetPlatformAccessProvider_ParamsSpec.$,
    'ImeService_SetPlatformAccessProvider_Params',
    [
      mojo.internal.StructField(
        'provider', 0,
        0,
        mojo.internal.InterfaceProxy(ash.ime.mojom.PlatformAccessProviderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.ImeService_SetPlatformAccessProvider_Params');

/** @record */
ash.ime.mojom.ImeService_SetPlatformAccessProvider_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.PlatformAccessProviderRemote } */
    this.provider;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.ImeService_BindInputEngineManager_ParamsSpec.$,
    'ImeService_BindInputEngineManager_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(ash.ime.mojom.InputEngineManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.ImeService_BindInputEngineManager_Params');

/** @record */
ash.ime.mojom.ImeService_BindInputEngineManager_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.InputEngineManagerPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.ImeService_BindInputMethodUserDataService_ParamsSpec.$,
    'ImeService_BindInputMethodUserDataService_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(ash.ime.mojom.InputMethodUserDataServicePendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.ImeService_BindInputMethodUserDataService_Params');

/** @record */
ash.ime.mojom.ImeService_BindInputMethodUserDataService_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.InputMethodUserDataServicePendingReceiver } */
    this.receiver;
  }
};

