// chromeos/ash/services/ime/public/mojom/ime_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/ash/services/ime/public/mojom/ime_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ash.ime.mojom');
  var connection_factory$ =
      mojo.internal.exposeNamespace('ash.ime.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/ash/services/ime/public/mojom/connection_factory.mojom', 'connection_factory.mojom.js');
  }
  var input_engine$ =
      mojo.internal.exposeNamespace('ash.ime.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/ash/services/ime/public/mojom/input_engine.mojom', 'input_engine.mojom.js');
  }
  var input_method$ =
      mojo.internal.exposeNamespace('ash.ime.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/ash/services/ime/public/mojom/input_method.mojom', 'input_method.mojom.js');
  }
  var input_method_host$ =
      mojo.internal.exposeNamespace('ash.ime.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/ash/services/ime/public/mojom/input_method_host.mojom', 'input_method_host.mojom.js');
  }
  var input_method_user_data$ =
      mojo.internal.exposeNamespace('ash.ime.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/ash/services/ime/public/mojom/input_method_user_data.mojom', 'input_method_user_data.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../../url/mojom/url.mojom.js');
  }
  var sandbox$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/sandbox.mojom', '../../../../../../sandbox/policy/mojom/sandbox.mojom.js');
  }



  function InputEngineManager_ConnectToImeEngine_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputEngineManager_ConnectToImeEngine_Params.prototype.initDefaults_ = function() {
    this.imeSpec = null;
    this.toEngineRequest = new bindings.InterfaceRequest();
    this.fromEngine = new input_engine$.InputChannelPtr();
    this.extra = null;
  };
  InputEngineManager_ConnectToImeEngine_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputEngineManager_ConnectToImeEngine_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputEngineManager_ConnectToImeEngine_Params.imeSpec
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputEngineManager_ConnectToImeEngine_Params.toEngineRequest
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputEngineManager_ConnectToImeEngine_Params.fromEngine
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputEngineManager_ConnectToImeEngine_Params.extra
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputEngineManager_ConnectToImeEngine_Params.encodedSize = codec.kStructHeaderSize + 32;

  InputEngineManager_ConnectToImeEngine_Params.decode = function(decoder) {
    var packed;
    var val = new InputEngineManager_ConnectToImeEngine_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.imeSpec =
        decoder.decodeStruct(codec.String);
    val.toEngineRequest =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.fromEngine =
        decoder.decodeStruct(new codec.Interface(input_engine$.InputChannelPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.extra =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  InputEngineManager_ConnectToImeEngine_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputEngineManager_ConnectToImeEngine_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.imeSpec);
    encoder.encodeStruct(codec.InterfaceRequest, val.toEngineRequest);
    encoder.encodeStruct(new codec.Interface(input_engine$.InputChannelPtr), val.fromEngine);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.extra);
  };
  function InputEngineManager_ConnectToImeEngine_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputEngineManager_ConnectToImeEngine_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  InputEngineManager_ConnectToImeEngine_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputEngineManager_ConnectToImeEngine_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  InputEngineManager_ConnectToImeEngine_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  InputEngineManager_ConnectToImeEngine_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new InputEngineManager_ConnectToImeEngine_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InputEngineManager_ConnectToImeEngine_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputEngineManager_ConnectToImeEngine_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function InputEngineManager_InitializeConnectionFactory_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputEngineManager_InitializeConnectionFactory_Params.prototype.initDefaults_ = function() {
    this.connectionFactory = new bindings.InterfaceRequest();
  };
  InputEngineManager_InitializeConnectionFactory_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputEngineManager_InitializeConnectionFactory_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputEngineManager_InitializeConnectionFactory_Params.connectionFactory
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputEngineManager_InitializeConnectionFactory_Params.encodedSize = codec.kStructHeaderSize + 8;

  InputEngineManager_InitializeConnectionFactory_Params.decode = function(decoder) {
    var packed;
    var val = new InputEngineManager_InitializeConnectionFactory_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.connectionFactory =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InputEngineManager_InitializeConnectionFactory_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputEngineManager_InitializeConnectionFactory_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.connectionFactory);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function InputEngineManager_InitializeConnectionFactory_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputEngineManager_InitializeConnectionFactory_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  InputEngineManager_InitializeConnectionFactory_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputEngineManager_InitializeConnectionFactory_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  InputEngineManager_InitializeConnectionFactory_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  InputEngineManager_InitializeConnectionFactory_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new InputEngineManager_InitializeConnectionFactory_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InputEngineManager_InitializeConnectionFactory_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputEngineManager_InitializeConnectionFactory_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PlatformAccessProvider_DownloadImeFileTo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PlatformAccessProvider_DownloadImeFileTo_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.filePath = null;
  };
  PlatformAccessProvider_DownloadImeFileTo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PlatformAccessProvider_DownloadImeFileTo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PlatformAccessProvider_DownloadImeFileTo_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PlatformAccessProvider_DownloadImeFileTo_Params.filePath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PlatformAccessProvider_DownloadImeFileTo_Params.encodedSize = codec.kStructHeaderSize + 16;

  PlatformAccessProvider_DownloadImeFileTo_Params.decode = function(decoder) {
    var packed;
    var val = new PlatformAccessProvider_DownloadImeFileTo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.filePath =
        decoder.decodeStructPointer(file_path$.FilePath);
    return val;
  };

  PlatformAccessProvider_DownloadImeFileTo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PlatformAccessProvider_DownloadImeFileTo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(file_path$.FilePath, val.filePath);
  };
  function PlatformAccessProvider_DownloadImeFileTo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PlatformAccessProvider_DownloadImeFileTo_ResponseParams.prototype.initDefaults_ = function() {
    this.filePath = null;
  };
  PlatformAccessProvider_DownloadImeFileTo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PlatformAccessProvider_DownloadImeFileTo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PlatformAccessProvider_DownloadImeFileTo_ResponseParams.filePath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PlatformAccessProvider_DownloadImeFileTo_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PlatformAccessProvider_DownloadImeFileTo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PlatformAccessProvider_DownloadImeFileTo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filePath =
        decoder.decodeStructPointer(file_path$.FilePath);
    return val;
  };

  PlatformAccessProvider_DownloadImeFileTo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PlatformAccessProvider_DownloadImeFileTo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.filePath);
  };
  function ImeService_SetPlatformAccessProvider_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImeService_SetPlatformAccessProvider_Params.prototype.initDefaults_ = function() {
    this.provider = new PlatformAccessProviderPtr();
  };
  ImeService_SetPlatformAccessProvider_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImeService_SetPlatformAccessProvider_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImeService_SetPlatformAccessProvider_Params.provider
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImeService_SetPlatformAccessProvider_Params.encodedSize = codec.kStructHeaderSize + 8;

  ImeService_SetPlatformAccessProvider_Params.decode = function(decoder) {
    var packed;
    var val = new ImeService_SetPlatformAccessProvider_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.provider =
        decoder.decodeStruct(new codec.Interface(PlatformAccessProviderPtr));
    return val;
  };

  ImeService_SetPlatformAccessProvider_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImeService_SetPlatformAccessProvider_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(PlatformAccessProviderPtr), val.provider);
  };
  function ImeService_BindInputEngineManager_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImeService_BindInputEngineManager_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  ImeService_BindInputEngineManager_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImeService_BindInputEngineManager_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImeService_BindInputEngineManager_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImeService_BindInputEngineManager_Params.encodedSize = codec.kStructHeaderSize + 8;

  ImeService_BindInputEngineManager_Params.decode = function(decoder) {
    var packed;
    var val = new ImeService_BindInputEngineManager_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ImeService_BindInputEngineManager_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImeService_BindInputEngineManager_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ImeService_BindInputMethodUserDataService_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImeService_BindInputMethodUserDataService_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  ImeService_BindInputMethodUserDataService_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImeService_BindInputMethodUserDataService_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImeService_BindInputMethodUserDataService_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImeService_BindInputMethodUserDataService_Params.encodedSize = codec.kStructHeaderSize + 8;

  ImeService_BindInputMethodUserDataService_Params.decode = function(decoder) {
    var packed;
    var val = new ImeService_BindInputMethodUserDataService_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ImeService_BindInputMethodUserDataService_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImeService_BindInputMethodUserDataService_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kInputEngineManager_ConnectToImeEngine_Name = 0;
  var kInputEngineManager_InitializeConnectionFactory_Name = 1;

  function InputEngineManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(InputEngineManager,
                                                   handleOrPtrInfo);
  }

  function InputEngineManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        InputEngineManager, associatedInterfacePtrInfo);
  }

  InputEngineManagerAssociatedPtr.prototype =
      Object.create(InputEngineManagerPtr.prototype);
  InputEngineManagerAssociatedPtr.prototype.constructor =
      InputEngineManagerAssociatedPtr;

  function InputEngineManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  InputEngineManagerPtr.prototype.connectToImeEngine = function() {
    return InputEngineManagerProxy.prototype.connectToImeEngine
        .apply(this.ptr.getProxy(), arguments);
  };

  InputEngineManagerProxy.prototype.connectToImeEngine = function(imeSpec, toEngineRequest, fromEngine, extra) {
    var params_ = new InputEngineManager_ConnectToImeEngine_Params();
    params_.imeSpec = imeSpec;
    params_.toEngineRequest = toEngineRequest;
    params_.fromEngine = fromEngine;
    params_.extra = extra;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kInputEngineManager_ConnectToImeEngine_Name,
          codec.align(InputEngineManager_ConnectToImeEngine_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(InputEngineManager_ConnectToImeEngine_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(InputEngineManager_ConnectToImeEngine_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  InputEngineManagerPtr.prototype.initializeConnectionFactory = function() {
    return InputEngineManagerProxy.prototype.initializeConnectionFactory
        .apply(this.ptr.getProxy(), arguments);
  };

  InputEngineManagerProxy.prototype.initializeConnectionFactory = function(connectionFactory) {
    var params_ = new InputEngineManager_InitializeConnectionFactory_Params();
    params_.connectionFactory = connectionFactory;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kInputEngineManager_InitializeConnectionFactory_Name,
          codec.align(InputEngineManager_InitializeConnectionFactory_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(InputEngineManager_InitializeConnectionFactory_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(InputEngineManager_InitializeConnectionFactory_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function InputEngineManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  InputEngineManagerStub.prototype.connectToImeEngine = function(imeSpec, toEngineRequest, fromEngine, extra) {
    return this.delegate_ && this.delegate_.connectToImeEngine && this.delegate_.connectToImeEngine(imeSpec, toEngineRequest, fromEngine, extra);
  }
  InputEngineManagerStub.prototype.initializeConnectionFactory = function(connectionFactory) {
    return this.delegate_ && this.delegate_.initializeConnectionFactory && this.delegate_.initializeConnectionFactory(connectionFactory);
  }

  InputEngineManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  InputEngineManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kInputEngineManager_ConnectToImeEngine_Name:
      var params = reader.decodeStruct(InputEngineManager_ConnectToImeEngine_Params);
      this.connectToImeEngine(params.imeSpec, params.toEngineRequest, params.fromEngine, params.extra).then(function(response) {
        var responseParams =
            new InputEngineManager_ConnectToImeEngine_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kInputEngineManager_ConnectToImeEngine_Name,
            codec.align(InputEngineManager_ConnectToImeEngine_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(InputEngineManager_ConnectToImeEngine_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kInputEngineManager_InitializeConnectionFactory_Name:
      var params = reader.decodeStruct(InputEngineManager_InitializeConnectionFactory_Params);
      this.initializeConnectionFactory(params.connectionFactory).then(function(response) {
        var responseParams =
            new InputEngineManager_InitializeConnectionFactory_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kInputEngineManager_InitializeConnectionFactory_Name,
            codec.align(InputEngineManager_InitializeConnectionFactory_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(InputEngineManager_InitializeConnectionFactory_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateInputEngineManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kInputEngineManager_ConnectToImeEngine_Name:
        if (message.expectsResponse())
          paramsClass = InputEngineManager_ConnectToImeEngine_Params;
      break;
      case kInputEngineManager_InitializeConnectionFactory_Name:
        if (message.expectsResponse())
          paramsClass = InputEngineManager_InitializeConnectionFactory_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateInputEngineManagerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kInputEngineManager_ConnectToImeEngine_Name:
        if (message.isResponse())
          paramsClass = InputEngineManager_ConnectToImeEngine_ResponseParams;
        break;
      case kInputEngineManager_InitializeConnectionFactory_Name:
        if (message.isResponse())
          paramsClass = InputEngineManager_InitializeConnectionFactory_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var InputEngineManager = {
    name: 'ash.ime.mojom.InputEngineManager',
    kVersion: 0,
    ptrClass: InputEngineManagerPtr,
    proxyClass: InputEngineManagerProxy,
    stubClass: InputEngineManagerStub,
    validateRequest: validateInputEngineManagerRequest,
    validateResponse: validateInputEngineManagerResponse,
  };
  InputEngineManagerStub.prototype.validator = validateInputEngineManagerRequest;
  InputEngineManagerProxy.prototype.validator = validateInputEngineManagerResponse;
  var kPlatformAccessProvider_DownloadImeFileTo_Name = 0;

  function PlatformAccessProviderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PlatformAccessProvider,
                                                   handleOrPtrInfo);
  }

  function PlatformAccessProviderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PlatformAccessProvider, associatedInterfacePtrInfo);
  }

  PlatformAccessProviderAssociatedPtr.prototype =
      Object.create(PlatformAccessProviderPtr.prototype);
  PlatformAccessProviderAssociatedPtr.prototype.constructor =
      PlatformAccessProviderAssociatedPtr;

  function PlatformAccessProviderProxy(receiver) {
    this.receiver_ = receiver;
  }
  PlatformAccessProviderPtr.prototype.downloadImeFileTo = function() {
    return PlatformAccessProviderProxy.prototype.downloadImeFileTo
        .apply(this.ptr.getProxy(), arguments);
  };

  PlatformAccessProviderProxy.prototype.downloadImeFileTo = function(url, filePath) {
    var params_ = new PlatformAccessProvider_DownloadImeFileTo_Params();
    params_.url = url;
    params_.filePath = filePath;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPlatformAccessProvider_DownloadImeFileTo_Name,
          codec.align(PlatformAccessProvider_DownloadImeFileTo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PlatformAccessProvider_DownloadImeFileTo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PlatformAccessProvider_DownloadImeFileTo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function PlatformAccessProviderStub(delegate) {
    this.delegate_ = delegate;
  }
  PlatformAccessProviderStub.prototype.downloadImeFileTo = function(url, filePath) {
    return this.delegate_ && this.delegate_.downloadImeFileTo && this.delegate_.downloadImeFileTo(url, filePath);
  }

  PlatformAccessProviderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  PlatformAccessProviderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPlatformAccessProvider_DownloadImeFileTo_Name:
      var params = reader.decodeStruct(PlatformAccessProvider_DownloadImeFileTo_Params);
      this.downloadImeFileTo(params.url, params.filePath).then(function(response) {
        var responseParams =
            new PlatformAccessProvider_DownloadImeFileTo_ResponseParams();
        responseParams.filePath = response.filePath;
        var builder = new codec.MessageV1Builder(
            kPlatformAccessProvider_DownloadImeFileTo_Name,
            codec.align(PlatformAccessProvider_DownloadImeFileTo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PlatformAccessProvider_DownloadImeFileTo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validatePlatformAccessProviderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPlatformAccessProvider_DownloadImeFileTo_Name:
        if (message.expectsResponse())
          paramsClass = PlatformAccessProvider_DownloadImeFileTo_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePlatformAccessProviderResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kPlatformAccessProvider_DownloadImeFileTo_Name:
        if (message.isResponse())
          paramsClass = PlatformAccessProvider_DownloadImeFileTo_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var PlatformAccessProvider = {
    name: 'ash.ime.mojom.PlatformAccessProvider',
    kVersion: 0,
    ptrClass: PlatformAccessProviderPtr,
    proxyClass: PlatformAccessProviderProxy,
    stubClass: PlatformAccessProviderStub,
    validateRequest: validatePlatformAccessProviderRequest,
    validateResponse: validatePlatformAccessProviderResponse,
  };
  PlatformAccessProviderStub.prototype.validator = validatePlatformAccessProviderRequest;
  PlatformAccessProviderProxy.prototype.validator = validatePlatformAccessProviderResponse;
  var kImeService_SetPlatformAccessProvider_Name = 0;
  var kImeService_BindInputEngineManager_Name = 1;
  var kImeService_BindInputMethodUserDataService_Name = 2;

  function ImeServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ImeService,
                                                   handleOrPtrInfo);
  }

  function ImeServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ImeService, associatedInterfacePtrInfo);
  }

  ImeServiceAssociatedPtr.prototype =
      Object.create(ImeServicePtr.prototype);
  ImeServiceAssociatedPtr.prototype.constructor =
      ImeServiceAssociatedPtr;

  function ImeServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  ImeServicePtr.prototype.setPlatformAccessProvider = function() {
    return ImeServiceProxy.prototype.setPlatformAccessProvider
        .apply(this.ptr.getProxy(), arguments);
  };

  ImeServiceProxy.prototype.setPlatformAccessProvider = function(provider) {
    var params_ = new ImeService_SetPlatformAccessProvider_Params();
    params_.provider = provider;
    var builder = new codec.MessageV0Builder(
        kImeService_SetPlatformAccessProvider_Name,
        codec.align(ImeService_SetPlatformAccessProvider_Params.encodedSize));
    builder.encodeStruct(ImeService_SetPlatformAccessProvider_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ImeServicePtr.prototype.bindInputEngineManager = function() {
    return ImeServiceProxy.prototype.bindInputEngineManager
        .apply(this.ptr.getProxy(), arguments);
  };

  ImeServiceProxy.prototype.bindInputEngineManager = function(receiver) {
    var params_ = new ImeService_BindInputEngineManager_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kImeService_BindInputEngineManager_Name,
        codec.align(ImeService_BindInputEngineManager_Params.encodedSize));
    builder.encodeStruct(ImeService_BindInputEngineManager_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ImeServicePtr.prototype.bindInputMethodUserDataService = function() {
    return ImeServiceProxy.prototype.bindInputMethodUserDataService
        .apply(this.ptr.getProxy(), arguments);
  };

  ImeServiceProxy.prototype.bindInputMethodUserDataService = function(receiver) {
    var params_ = new ImeService_BindInputMethodUserDataService_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kImeService_BindInputMethodUserDataService_Name,
        codec.align(ImeService_BindInputMethodUserDataService_Params.encodedSize));
    builder.encodeStruct(ImeService_BindInputMethodUserDataService_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ImeServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  ImeServiceStub.prototype.setPlatformAccessProvider = function(provider) {
    return this.delegate_ && this.delegate_.setPlatformAccessProvider && this.delegate_.setPlatformAccessProvider(provider);
  }
  ImeServiceStub.prototype.bindInputEngineManager = function(receiver) {
    return this.delegate_ && this.delegate_.bindInputEngineManager && this.delegate_.bindInputEngineManager(receiver);
  }
  ImeServiceStub.prototype.bindInputMethodUserDataService = function(receiver) {
    return this.delegate_ && this.delegate_.bindInputMethodUserDataService && this.delegate_.bindInputMethodUserDataService(receiver);
  }

  ImeServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kImeService_SetPlatformAccessProvider_Name:
      var params = reader.decodeStruct(ImeService_SetPlatformAccessProvider_Params);
      this.setPlatformAccessProvider(params.provider);
      return true;
    case kImeService_BindInputEngineManager_Name:
      var params = reader.decodeStruct(ImeService_BindInputEngineManager_Params);
      this.bindInputEngineManager(params.receiver);
      return true;
    case kImeService_BindInputMethodUserDataService_Name:
      var params = reader.decodeStruct(ImeService_BindInputMethodUserDataService_Params);
      this.bindInputMethodUserDataService(params.receiver);
      return true;
    default:
      return false;
    }
  };

  ImeServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateImeServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kImeService_SetPlatformAccessProvider_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ImeService_SetPlatformAccessProvider_Params;
      break;
      case kImeService_BindInputEngineManager_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ImeService_BindInputEngineManager_Params;
      break;
      case kImeService_BindInputMethodUserDataService_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ImeService_BindInputMethodUserDataService_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateImeServiceResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ImeService = {
    name: 'ash.ime.mojom.ImeService',
    kVersion: 0,
    ptrClass: ImeServicePtr,
    proxyClass: ImeServiceProxy,
    stubClass: ImeServiceStub,
    validateRequest: validateImeServiceRequest,
    validateResponse: null,
  };
  ImeServiceStub.prototype.validator = validateImeServiceRequest;
  ImeServiceProxy.prototype.validator = null;
  exports.InputEngineManager = InputEngineManager;
  exports.InputEngineManagerPtr = InputEngineManagerPtr;
  exports.InputEngineManagerAssociatedPtr = InputEngineManagerAssociatedPtr;
  exports.PlatformAccessProvider = PlatformAccessProvider;
  exports.PlatformAccessProviderPtr = PlatformAccessProviderPtr;
  exports.PlatformAccessProviderAssociatedPtr = PlatformAccessProviderAssociatedPtr;
  exports.ImeService = ImeService;
  exports.ImeServicePtr = ImeServicePtr;
  exports.ImeServiceAssociatedPtr = ImeServiceAssociatedPtr;
})();