// chromeos/ash/services/ime/public/mojom/ime_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../../mojo/public/js/bindings.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../../url/mojom/url.mojom.m.js';

import {
  ConnectionFactoryRemote as ash_ime_mojom_ConnectionFactoryRemote,
  ConnectionFactoryPendingReceiver as ash_ime_mojom_ConnectionFactoryPendingReceiver
} from './connection_factory.mojom.m.js';

import {
  InputChannelRemote as ash_ime_mojom_InputChannelRemote,
  InputChannelPendingReceiver as ash_ime_mojom_InputChannelPendingReceiver
} from './input_engine.mojom.m.js';

import {
  InputMethodUserDataServiceRemote as ash_ime_mojom_InputMethodUserDataServiceRemote,
  InputMethodUserDataServicePendingReceiver as ash_ime_mojom_InputMethodUserDataServicePendingReceiver
} from './input_method_user_data.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class InputEngineManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.ime.mojom.InputEngineManager', scope);
  }
}

/** @interface */
export class InputEngineManagerInterface {
  
  /**
   * @param { !string } imeSpec
   * @param { !ash_ime_mojom_InputChannelPendingReceiver } toEngineRequest
   * @param { !ash_ime_mojom_InputChannelRemote } fromEngine
   * @param { !Array<!number> } extra
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  connectToImeEngine(imeSpec, toEngineRequest, fromEngine, extra) {}
  
  /**
   * @param { !ash_ime_mojom_ConnectionFactoryPendingReceiver } connectionFactory
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initializeConnectionFactory(connectionFactory) {}
}

/**
 * @implements { InputEngineManagerInterface }
 */
export class InputEngineManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!InputEngineManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          InputEngineManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!InputEngineManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } imeSpec
   * @param { !ash_ime_mojom_InputChannelPendingReceiver } toEngineRequest
   * @param { !ash_ime_mojom_InputChannelRemote } fromEngine
   * @param { !Array<!number> } extra
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  connectToImeEngine(
      imeSpec,
      toEngineRequest,
      fromEngine,
      extra) {
    return this.proxy.sendMessage(
        0,
        InputEngineManager_ConnectToImeEngine_ParamsSpec.$,
        InputEngineManager_ConnectToImeEngine_ResponseParamsSpec.$,
        [
          imeSpec,
          toEngineRequest,
          fromEngine,
          extra
        ],
        false);
  }

  
  /**
   * @param { !ash_ime_mojom_ConnectionFactoryPendingReceiver } connectionFactory
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  initializeConnectionFactory(
      connectionFactory) {
    return this.proxy.sendMessage(
        1,
        InputEngineManager_InitializeConnectionFactory_ParamsSpec.$,
        InputEngineManager_InitializeConnectionFactory_ResponseParamsSpec.$,
        [
          connectionFactory
        ],
        false);
  }
}

/**
 * An object which receives request messages for the InputEngineManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InputEngineManagerReceiver {
  /**
   * @param {!InputEngineManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!InputEngineManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        InputEngineManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InputEngineManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        InputEngineManager_ConnectToImeEngine_ParamsSpec.$,
        InputEngineManager_ConnectToImeEngine_ResponseParamsSpec.$,
        impl.connectToImeEngine.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        InputEngineManager_InitializeConnectionFactory_ParamsSpec.$,
        InputEngineManager_InitializeConnectionFactory_ResponseParamsSpec.$,
        impl.initializeConnectionFactory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class InputEngineManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.InputEngineManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!InputEngineManagerRemote}
   */
  static getRemote() {
    let remote = new InputEngineManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the InputEngineManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InputEngineManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      InputEngineManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InputEngineManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connectToImeEngine =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        InputEngineManager_ConnectToImeEngine_ParamsSpec.$,
        InputEngineManager_ConnectToImeEngine_ResponseParamsSpec.$,
        this.connectToImeEngine.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.initializeConnectionFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        InputEngineManager_InitializeConnectionFactory_ParamsSpec.$,
        InputEngineManager_InitializeConnectionFactory_ResponseParamsSpec.$,
        this.initializeConnectionFactory.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PlatformAccessProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.ime.mojom.PlatformAccessProvider', scope);
  }
}

/** @interface */
export class PlatformAccessProviderInterface {
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_FilePath } filePath
   * @return {!Promise<{
        filePath: !mojoBase_mojom_FilePath,
   *  }>}
   */

  downloadImeFileTo(url, filePath) {}
}

/**
 * @implements { PlatformAccessProviderInterface }
 */
export class PlatformAccessProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PlatformAccessProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PlatformAccessProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PlatformAccessProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_FilePath } filePath
   * @return {!Promise<{
        filePath: !mojoBase_mojom_FilePath,
   *  }>}
   */

  downloadImeFileTo(
      url,
      filePath) {
    return this.proxy.sendMessage(
        0,
        PlatformAccessProvider_DownloadImeFileTo_ParamsSpec.$,
        PlatformAccessProvider_DownloadImeFileTo_ResponseParamsSpec.$,
        [
          url,
          filePath
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PlatformAccessProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PlatformAccessProviderReceiver {
  /**
   * @param {!PlatformAccessProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PlatformAccessProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PlatformAccessProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PlatformAccessProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PlatformAccessProvider_DownloadImeFileTo_ParamsSpec.$,
        PlatformAccessProvider_DownloadImeFileTo_ResponseParamsSpec.$,
        impl.downloadImeFileTo.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PlatformAccessProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.PlatformAccessProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PlatformAccessProviderRemote}
   */
  static getRemote() {
    let remote = new PlatformAccessProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PlatformAccessProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PlatformAccessProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PlatformAccessProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PlatformAccessProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.downloadImeFileTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PlatformAccessProvider_DownloadImeFileTo_ParamsSpec.$,
        PlatformAccessProvider_DownloadImeFileTo_ResponseParamsSpec.$,
        this.downloadImeFileTo.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ImeServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.ime.mojom.ImeService', scope);
  }
}

/** @interface */
export class ImeServiceInterface {
  
  /**
   * @param { !PlatformAccessProviderRemote } provider
   */

  setPlatformAccessProvider(provider) {}
  
  /**
   * @param { !InputEngineManagerPendingReceiver } receiver
   */

  bindInputEngineManager(receiver) {}
  
  /**
   * @param { !ash_ime_mojom_InputMethodUserDataServicePendingReceiver } receiver
   */

  bindInputMethodUserDataService(receiver) {}
}

/**
 * @implements { ImeServiceInterface }
 */
export class ImeServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ImeServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ImeServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ImeServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PlatformAccessProviderRemote } provider
   */

  setPlatformAccessProvider(
      provider) {
    this.proxy.sendMessage(
        0,
        ImeService_SetPlatformAccessProvider_ParamsSpec.$,
        null,
        [
          provider
        ],
        false);
  }

  
  /**
   * @param { !InputEngineManagerPendingReceiver } receiver
   */

  bindInputEngineManager(
      receiver) {
    this.proxy.sendMessage(
        1,
        ImeService_BindInputEngineManager_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !ash_ime_mojom_InputMethodUserDataServicePendingReceiver } receiver
   */

  bindInputMethodUserDataService(
      receiver) {
    this.proxy.sendMessage(
        2,
        ImeService_BindInputMethodUserDataService_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ImeService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ImeServiceReceiver {
  /**
   * @param {!ImeServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ImeServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ImeServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ImeServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ImeService_SetPlatformAccessProvider_ParamsSpec.$,
        null,
        impl.setPlatformAccessProvider.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ImeService_BindInputEngineManager_ParamsSpec.$,
        null,
        impl.bindInputEngineManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ImeService_BindInputMethodUserDataService_ParamsSpec.$,
        null,
        impl.bindInputMethodUserDataService.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ImeService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.ImeService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ImeServiceRemote}
   */
  static getRemote() {
    let remote = new ImeServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ImeService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ImeServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ImeServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ImeServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPlatformAccessProvider =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ImeService_SetPlatformAccessProvider_ParamsSpec.$,
        null,
        this.setPlatformAccessProvider.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindInputEngineManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ImeService_BindInputEngineManager_ParamsSpec.$,
        null,
        this.bindInputEngineManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindInputMethodUserDataService =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ImeService_BindInputMethodUserDataService_ParamsSpec.$,
        null,
        this.bindInputMethodUserDataService.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputEngineManager_ConnectToImeEngine_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputEngineManager_ConnectToImeEngine_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputEngineManager_InitializeConnectionFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputEngineManager_InitializeConnectionFactory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlatformAccessProvider_DownloadImeFileTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlatformAccessProvider_DownloadImeFileTo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImeService_SetPlatformAccessProvider_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImeService_BindInputEngineManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImeService_BindInputMethodUserDataService_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    InputEngineManager_ConnectToImeEngine_ParamsSpec.$,
    'InputEngineManager_ConnectToImeEngine_Params',
    [
      mojo.internal.StructField(
        'imeSpec', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'toEngineRequest', 8,
        0,
        mojo.internal.InterfaceRequest(ash_ime_mojom_InputChannelPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fromEngine', 12,
        0,
        mojo.internal.InterfaceProxy(ash_ime_mojom_InputChannelRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'extra', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class InputEngineManager_ConnectToImeEngine_Params {
  constructor() {
    /** @type { !string } */
    this.imeSpec;
    /** @type { !ash_ime_mojom_InputChannelPendingReceiver } */
    this.toEngineRequest;
    /** @type { !ash_ime_mojom_InputChannelRemote } */
    this.fromEngine;
    /** @type { !Array<!number> } */
    this.extra;
  }
}



mojo.internal.Struct(
    InputEngineManager_ConnectToImeEngine_ResponseParamsSpec.$,
    'InputEngineManager_ConnectToImeEngine_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputEngineManager_ConnectToImeEngine_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    InputEngineManager_InitializeConnectionFactory_ParamsSpec.$,
    'InputEngineManager_InitializeConnectionFactory_Params',
    [
      mojo.internal.StructField(
        'connectionFactory', 0,
        0,
        mojo.internal.InterfaceRequest(ash_ime_mojom_ConnectionFactoryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputEngineManager_InitializeConnectionFactory_Params {
  constructor() {
    /** @type { !ash_ime_mojom_ConnectionFactoryPendingReceiver } */
    this.connectionFactory;
  }
}



mojo.internal.Struct(
    InputEngineManager_InitializeConnectionFactory_ResponseParamsSpec.$,
    'InputEngineManager_InitializeConnectionFactory_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputEngineManager_InitializeConnectionFactory_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    PlatformAccessProvider_DownloadImeFileTo_ParamsSpec.$,
    'PlatformAccessProvider_DownloadImeFileTo_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filePath', 8,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PlatformAccessProvider_DownloadImeFileTo_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !mojoBase_mojom_FilePath } */
    this.filePath;
  }
}



mojo.internal.Struct(
    PlatformAccessProvider_DownloadImeFileTo_ResponseParamsSpec.$,
    'PlatformAccessProvider_DownloadImeFileTo_ResponseParams',
    [
      mojo.internal.StructField(
        'filePath', 0,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PlatformAccessProvider_DownloadImeFileTo_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_FilePath } */
    this.filePath;
  }
}



mojo.internal.Struct(
    ImeService_SetPlatformAccessProvider_ParamsSpec.$,
    'ImeService_SetPlatformAccessProvider_Params',
    [
      mojo.internal.StructField(
        'provider', 0,
        0,
        mojo.internal.InterfaceProxy(PlatformAccessProviderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ImeService_SetPlatformAccessProvider_Params {
  constructor() {
    /** @type { !PlatformAccessProviderRemote } */
    this.provider;
  }
}



mojo.internal.Struct(
    ImeService_BindInputEngineManager_ParamsSpec.$,
    'ImeService_BindInputEngineManager_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(InputEngineManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ImeService_BindInputEngineManager_Params {
  constructor() {
    /** @type { !InputEngineManagerPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    ImeService_BindInputMethodUserDataService_ParamsSpec.$,
    'ImeService_BindInputMethodUserDataService_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(ash_ime_mojom_InputMethodUserDataServicePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ImeService_BindInputMethodUserDataService_Params {
  constructor() {
    /** @type { !ash_ime_mojom_InputMethodUserDataServicePendingReceiver } */
    this.receiver;
  }
}

