// chromeos/ash/services/ime/public/mojom/input_engine.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/ash/services/ime/public/mojom/input_engine.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ash.ime.mojom');



  function InputChannel_ProcessMessage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputChannel_ProcessMessage_Params.prototype.initDefaults_ = function() {
    this.message = null;
  };
  InputChannel_ProcessMessage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputChannel_ProcessMessage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputChannel_ProcessMessage_Params.message
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputChannel_ProcessMessage_Params.encodedSize = codec.kStructHeaderSize + 8;

  InputChannel_ProcessMessage_Params.decode = function(decoder) {
    var packed;
    var val = new InputChannel_ProcessMessage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.message =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  InputChannel_ProcessMessage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputChannel_ProcessMessage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.message);
  };
  function InputChannel_ProcessMessage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputChannel_ProcessMessage_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  InputChannel_ProcessMessage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputChannel_ProcessMessage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputChannel_ProcessMessage_ResponseParams.result
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputChannel_ProcessMessage_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  InputChannel_ProcessMessage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new InputChannel_ProcessMessage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  InputChannel_ProcessMessage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputChannel_ProcessMessage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.result);
  };
  var kInputChannel_ProcessMessage_Name = 0;

  function InputChannelPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(InputChannel,
                                                   handleOrPtrInfo);
  }

  function InputChannelAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        InputChannel, associatedInterfacePtrInfo);
  }

  InputChannelAssociatedPtr.prototype =
      Object.create(InputChannelPtr.prototype);
  InputChannelAssociatedPtr.prototype.constructor =
      InputChannelAssociatedPtr;

  function InputChannelProxy(receiver) {
    this.receiver_ = receiver;
  }
  InputChannelPtr.prototype.processMessage = function() {
    return InputChannelProxy.prototype.processMessage
        .apply(this.ptr.getProxy(), arguments);
  };

  InputChannelProxy.prototype.processMessage = function(message) {
    var params_ = new InputChannel_ProcessMessage_Params();
    params_.message = message;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kInputChannel_ProcessMessage_Name,
          codec.align(InputChannel_ProcessMessage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(InputChannel_ProcessMessage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(InputChannel_ProcessMessage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function InputChannelStub(delegate) {
    this.delegate_ = delegate;
  }
  InputChannelStub.prototype.processMessage = function(message) {
    return this.delegate_ && this.delegate_.processMessage && this.delegate_.processMessage(message);
  }

  InputChannelStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  InputChannelStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kInputChannel_ProcessMessage_Name:
      var params = reader.decodeStruct(InputChannel_ProcessMessage_Params);
      this.processMessage(params.message).then(function(response) {
        var responseParams =
            new InputChannel_ProcessMessage_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kInputChannel_ProcessMessage_Name,
            codec.align(InputChannel_ProcessMessage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(InputChannel_ProcessMessage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateInputChannelRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kInputChannel_ProcessMessage_Name:
        if (message.expectsResponse())
          paramsClass = InputChannel_ProcessMessage_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateInputChannelResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kInputChannel_ProcessMessage_Name:
        if (message.isResponse())
          paramsClass = InputChannel_ProcessMessage_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var InputChannel = {
    name: 'ash.ime.mojom.InputChannel',
    kVersion: 0,
    ptrClass: InputChannelPtr,
    proxyClass: InputChannelProxy,
    stubClass: InputChannelStub,
    validateRequest: validateInputChannelRequest,
    validateResponse: validateInputChannelResponse,
  };
  InputChannelStub.prototype.validator = validateInputChannelRequest;
  InputChannelProxy.prototype.validator = validateInputChannelResponse;
  exports.InputChannel = InputChannel;
  exports.InputChannelPtr = InputChannelPtr;
  exports.InputChannelAssociatedPtr = InputChannelAssociatedPtr;
})();