// chromeos/ash/services/ime/public/mojom/input_engine.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class InputChannelPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.ime.mojom.InputChannel', scope);
  }
}

/** @interface */
export class InputChannelInterface {
  
  /**
   * @param { !Array<!number> } message
   * @return {!Promise<{
        result: !Array<!number>,
   *  }>}
   */

  processMessage(message) {}
}

/**
 * @implements { InputChannelInterface }
 */
export class InputChannelRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!InputChannelPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          InputChannelPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!InputChannelPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } message
   * @return {!Promise<{
        result: !Array<!number>,
   *  }>}
   */

  processMessage(
      message) {
    return this.proxy.sendMessage(
        0,
        InputChannel_ProcessMessage_ParamsSpec.$,
        InputChannel_ProcessMessage_ResponseParamsSpec.$,
        [
          message
        ],
        false);
  }
}

/**
 * An object which receives request messages for the InputChannel
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InputChannelReceiver {
  /**
   * @param {!InputChannelInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!InputChannelRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        InputChannelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InputChannelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        InputChannel_ProcessMessage_ParamsSpec.$,
        InputChannel_ProcessMessage_ResponseParamsSpec.$,
        impl.processMessage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class InputChannel {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.InputChannel";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!InputChannelRemote}
   */
  static getRemote() {
    let remote = new InputChannelRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the InputChannel
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InputChannelCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      InputChannelRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InputChannelRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.processMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        InputChannel_ProcessMessage_ParamsSpec.$,
        InputChannel_ProcessMessage_ResponseParamsSpec.$,
        this.processMessage.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputChannel_ProcessMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputChannel_ProcessMessage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    InputChannel_ProcessMessage_ParamsSpec.$,
    'InputChannel_ProcessMessage_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputChannel_ProcessMessage_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.message;
  }
}



mojo.internal.Struct(
    InputChannel_ProcessMessage_ResponseParamsSpec.$,
    'InputChannel_ProcessMessage_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputChannel_ProcessMessage_ResponseParams {
  constructor() {
    /** @type { !Array<!number> } */
    this.result;
  }
}

