// chromeos/ash/services/ime/public/mojom/input_method.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('ash.ime.mojom.JpUnusedStruct');




goog.provide('ash.ime.mojom.KeyEventType');
goog.provide('ash.ime.mojom.KeyEventTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.KeyEventTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.KeyEventType = {
  
  kKeyDown: 0,
  kKeyUp: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('ash.ime.mojom.NamedDomKey');
goog.provide('ash.ime.mojom.NamedDomKeySpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.NamedDomKeySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.NamedDomKey = {
  
  kOther: 0,
  kAlt: 1,
  kAltGraph: 2,
  kCapsLock: 3,
  kControl: 4,
  kShift: 5,
  kEnter: 6,
  kBackspace: 7,
  kEscape: 10,
  kHangeulMode: 8,
  kHanjaMode: 9,
  kArrowDown: 11,
  kArrowLeft: 12,
  kArrowRight: 13,
  kArrowUp: 14,
  kPageDown: 15,
  kPageUp: 16,
  kTab: 17,
  kF1: 18,
  kF2: 19,
  kF3: 20,
  kF4: 21,
  kF5: 22,
  kF6: 23,
  kF7: 24,
  kF8: 25,
  kF9: 26,
  kF10: 27,
  kF11: 28,
  kF12: 29,
  kBrowserBack: 30,
  kBrowserForward: 31,
  kBrowserRefresh: 32,
  kZoomToggle: 33,
  kLaunchMyComputer: 34,
  kBrightnessDown: 35,
  kBrightnessUp: 36,
  kAudioVolumeMute: 37,
  kAudioVolumeDown: 38,
  kAudioVolumeUp: 39,
  kDelete: 40,
  kNumLock: 41,
  MIN_VALUE: 0,
  MAX_VALUE: 41,
};

goog.provide('ash.ime.mojom.DomCode');
goog.provide('ash.ime.mojom.DomCodeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.DomCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.DomCode = {
  
  kOther: 0,
  kBackquote: 1,
  kBackslash: 2,
  kBracketLeft: 3,
  kBracketRight: 4,
  kComma: 5,
  kDigit0: 6,
  kDigit1: 7,
  kDigit2: 8,
  kDigit3: 9,
  kDigit4: 10,
  kDigit5: 11,
  kDigit6: 12,
  kDigit7: 13,
  kDigit8: 14,
  kDigit9: 15,
  kEqual: 16,
  kIntlBackslash: 17,
  kIntlRo: 18,
  kIntlYen: 19,
  kKeyA: 20,
  kKeyB: 21,
  kKeyC: 22,
  kKeyD: 23,
  kKeyE: 24,
  kKeyF: 25,
  kKeyG: 26,
  kKeyH: 27,
  kKeyI: 28,
  kKeyJ: 29,
  kKeyK: 30,
  kKeyL: 31,
  kKeyM: 32,
  kKeyN: 33,
  kKeyO: 34,
  kKeyP: 35,
  kKeyQ: 36,
  kKeyR: 37,
  kKeyS: 38,
  kKeyT: 39,
  kKeyU: 40,
  kKeyV: 41,
  kKeyW: 42,
  kKeyX: 43,
  kKeyY: 44,
  kKeyZ: 45,
  kMinus: 46,
  kPeriod: 47,
  kQuote: 48,
  kSemicolon: 49,
  kSlash: 50,
  kBackspace: 51,
  kEnter: 52,
  kSpace: 53,
  kAltLeft: 54,
  kAltRight: 55,
  kShiftLeft: 56,
  kShiftRight: 57,
  kControlLeft: 58,
  kControlRight: 59,
  kCapsLock: 60,
  kEscape: 61,
  kTab: 62,
  kNumpadMultiply: 63,
  kKanaMode: 64,
  kPageUp: 65,
  kEnd: 66,
  kDelete: 67,
  kHome: 68,
  kPageDown: 69,
  kArrowUp: 70,
  kArrowLeft: 71,
  kArrowRight: 72,
  kArrowDown: 73,
  kNumpad0: 74,
  kNumpad1: 75,
  kNumpad2: 76,
  kNumpad3: 77,
  kNumpad4: 78,
  kNumpad5: 79,
  kNumpad6: 80,
  kNumpad7: 81,
  kNumpad8: 82,
  kNumpad9: 83,
  kNumpadSubtract: 84,
  kNumpadAdd: 85,
  kNumpadDecimal: 86,
  kNumpadEnter: 87,
  kNumpadDivide: 88,
  MIN_VALUE: 0,
  MAX_VALUE: 88,
};

goog.provide('ash.ime.mojom.KeyEventResult');
goog.provide('ash.ime.mojom.KeyEventResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.KeyEventResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.KeyEventResult = {
  
  kNeedsHandlingBySystem: 0,
  kConsumedByIme: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('ash.ime.mojom.InputFieldType');
goog.provide('ash.ime.mojom.InputFieldTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.InputFieldTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.InputFieldType = {
  
  kNoIME: 0,
  kText: 1,
  kSearch: 2,
  kTelephone: 3,
  kURL: 4,
  kEmail: 5,
  kNumber: 6,
  kPassword: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

goog.provide('ash.ime.mojom.AutocorrectMode');
goog.provide('ash.ime.mojom.AutocorrectModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.AutocorrectModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.AutocorrectMode = {
  
  kDisabled: 0,
  kEnabled: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('ash.ime.mojom.PersonalizationMode');
goog.provide('ash.ime.mojom.PersonalizationModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.PersonalizationModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.PersonalizationMode = {
  
  kDisabled: 0,
  kEnabled: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('ash.ime.mojom.TextPredictionMode');
goog.provide('ash.ime.mojom.TextPredictionModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.TextPredictionModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.TextPredictionMode = {
  
  kDisabled: 0,
  kEnabled: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('ash.ime.mojom.KoreanLayout');
goog.provide('ash.ime.mojom.KoreanLayoutSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.KoreanLayoutSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.KoreanLayout = {
  
  kDubeolsik: 0,
  kDubeolsikOldHangeul: 1,
  kSebeolsik390: 2,
  kSebeolsikFinal: 3,
  kSebeolsikNoShift: 4,
  kSebeolsikOldHangeul: 5,
  kDeprecatedSebeolsikDubeol: 6,
  kDeprecatedRomaja: 7,
  kDeprecatedAhnmatae: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};

goog.provide('ash.ime.mojom.PinyinLayout');
goog.provide('ash.ime.mojom.PinyinLayoutSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.PinyinLayoutSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.PinyinLayout = {
  
  kUsQwerty: 0,
  kDvorak: 1,
  kColemak: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('ash.ime.mojom.ZhuyinLayout');
goog.provide('ash.ime.mojom.ZhuyinLayoutSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.ZhuyinLayoutSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.ZhuyinLayout = {
  
  kStandard: 0,
  kIbm: 1,
  kEten: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('ash.ime.mojom.ZhuyinSelectionKeys');
goog.provide('ash.ime.mojom.ZhuyinSelectionKeysSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.ZhuyinSelectionKeysSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.ZhuyinSelectionKeys = {
  
  k1234567890: 0,
  kAsdfghjkl: 1,
  kAsdfzxcv89: 2,
  kAsdfjkl789: 3,
  k1234Qweras: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

goog.provide('ash.ime.mojom.ChineseLanguageMode');
goog.provide('ash.ime.mojom.ChineseLanguageModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.ChineseLanguageModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.ChineseLanguageMode = {
  
  kChinese: 0,
  kRaw: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('ash.ime.mojom.JapaneseInputMode');
goog.provide('ash.ime.mojom.JapaneseInputModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.JapaneseInputModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.JapaneseInputMode = {
  
  kHiragana: 0,
  kKatakana: 1,
  kWideLatin: 2,
  kHalfWidthKatakana: 3,
  kLatin: 4,
  kDirectInput: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

goog.provide('ash.ime.mojom.SuggestionMode');
goog.provide('ash.ime.mojom.SuggestionModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.SuggestionModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.SuggestionMode = {
  
  kUnknown: 0,
  kCompletion: 1,
  kPrediction: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('ash.ime.mojom.SuggestionType');
goog.provide('ash.ime.mojom.SuggestionTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.SuggestionTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.SuggestionType = {
  
  kUnknown: 0,
  kAssistivePersonalInfo: 1,
  kAssistiveEmoji: 2,
  kMultiWord: 3,
  kGrammar: 4,
  kLongpressDiacritic: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

goog.provide('ash.ime.mojom.AssistiveWindowType');
goog.provide('ash.ime.mojom.AssistiveWindowTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.AssistiveWindowTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.AssistiveWindowType = {
  
  kHidden: 0,
  kUndo: 1,
  kEmojiSuggestion: 2,
  kPersonalInfoSuggestion: 3,
  kGrammarSuggestion: 4,
  kMultiWordSuggestion: 5,
  kLongpressDiacriticsSuggestion: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};

goog.provide('ash.ime.mojom.AutocorrectSuggestionProvider');
goog.provide('ash.ime.mojom.AutocorrectSuggestionProviderSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.AutocorrectSuggestionProviderSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.AutocorrectSuggestionProvider = {
  
  kUnknown: 0,
  kUsEnglishPrebundled: 1,
  kUsEnglishDownloaded: 2,
  kUsEnglish840: 3,
  kUsEnglish840V2: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



goog.provide('ash.ime.mojom.InputMethod');
goog.provide('ash.ime.mojom.InputMethodReceiver');
goog.provide('ash.ime.mojom.InputMethodCallbackRouter');
goog.provide('ash.ime.mojom.InputMethodInterface');
goog.provide('ash.ime.mojom.InputMethodRemote');
goog.provide('ash.ime.mojom.InputMethodPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.ime.mojom.InputMethodPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.ime.mojom.InputMethod.$interfaceName,
        scope);
  }
};

/** @interface */
ash.ime.mojom.InputMethodInterface = class {
  
  /**
   * @param { !ash.ime.mojom.InputFieldInfo } inputFieldInfo
   * @param { ?ash.ime.mojom.InputMethodSettings } settings
   */

  onFocusDeprecated(inputFieldInfo, settings) {}
  
  /**
   * @param { !ash.ime.mojom.InputFieldInfo } inputFieldInfo
   * @param { ?ash.ime.mojom.InputMethodSettings } deprecatedSettings
   * @return {!Promise<{
        success: !boolean,
        metadata: ?ash.ime.mojom.InputMethodMetadata,
   *  }>}
   */

  onFocus(inputFieldInfo, deprecatedSettings) {}
  
  /**
   */

  onBlur() {}
  
  /**
   * @param { !ash.ime.mojom.PhysicalKeyEvent } event
   * @return {!Promise<{
        result: !ash.ime.mojom.KeyEventResult,
   *  }>}
   */

  processKeyEvent(event) {}
  
  /**
   * @param { !string } text
   * @param { !number } offset
   * @param { !ash.ime.mojom.SelectionRange } selectionRange
   */

  onSurroundingTextChanged(text, offset, selectionRange) {}
  
  /**
   */

  onCompositionCanceledBySystem() {}
  
  /**
   * @param { !number } selectedCandidateIndex
   */

  onCandidateSelected(selectedCandidateIndex) {}
  
  /**
   * @param { !ash.ime.mojom.InputMethodQuickSettings } settings
   */

  onQuickSettingsUpdated(settings) {}
  
  /**
   * @return {!Promise<{
        ready: !boolean,
   *  }>}
   */

  isReadyForTesting() {}
  
  /**
   * @param { !ash.ime.mojom.AssistiveWindow } window
   */

  onAssistiveWindowChanged(window) {}
};

/**
 * @export
 * @implements { ash.ime.mojom.InputMethodInterface }
 */
ash.ime.mojom.InputMethodRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.ime.mojom.InputMethodPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.ime.mojom.InputMethodPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.ime.mojom.InputMethodPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.ime.mojom.InputFieldInfo } inputFieldInfo
   * @param { ?ash.ime.mojom.InputMethodSettings } settings
   */

  onFocusDeprecated(
      inputFieldInfo,
      settings) {
    this.proxy.sendMessage(
        0,
        ash.ime.mojom.InputMethod_OnFocusDeprecated_ParamsSpec.$,
        null,
        [
          inputFieldInfo,
          settings
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.InputFieldInfo } inputFieldInfo
   * @param { ?ash.ime.mojom.InputMethodSettings } deprecatedSettings
   * @return {!Promise<{
        success: !boolean,
        metadata: ?ash.ime.mojom.InputMethodMetadata,
   *  }>}
   */

  onFocus(
      inputFieldInfo,
      deprecatedSettings) {
    return this.proxy.sendMessage(
        6,
        ash.ime.mojom.InputMethod_OnFocus_ParamsSpec.$,
        ash.ime.mojom.InputMethod_OnFocus_ResponseParamsSpec.$,
        [
          inputFieldInfo,
          deprecatedSettings
        ],
        false);
  }

  
  /**
   */

  onBlur() {
    this.proxy.sendMessage(
        1,
        ash.ime.mojom.InputMethod_OnBlur_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.PhysicalKeyEvent } event
   * @return {!Promise<{
        result: !ash.ime.mojom.KeyEventResult,
   *  }>}
   */

  processKeyEvent(
      event) {
    return this.proxy.sendMessage(
        2,
        ash.ime.mojom.InputMethod_ProcessKeyEvent_ParamsSpec.$,
        ash.ime.mojom.InputMethod_ProcessKeyEvent_ResponseParamsSpec.$,
        [
          event
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @param { !number } offset
   * @param { !ash.ime.mojom.SelectionRange } selectionRange
   */

  onSurroundingTextChanged(
      text,
      offset,
      selectionRange) {
    this.proxy.sendMessage(
        3,
        ash.ime.mojom.InputMethod_OnSurroundingTextChanged_ParamsSpec.$,
        null,
        [
          text,
          offset,
          selectionRange
        ],
        false);
  }

  
  /**
   */

  onCompositionCanceledBySystem() {
    this.proxy.sendMessage(
        4,
        ash.ime.mojom.InputMethod_OnCompositionCanceledBySystem_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } selectedCandidateIndex
   */

  onCandidateSelected(
      selectedCandidateIndex) {
    this.proxy.sendMessage(
        5,
        ash.ime.mojom.InputMethod_OnCandidateSelected_ParamsSpec.$,
        null,
        [
          selectedCandidateIndex
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.InputMethodQuickSettings } settings
   */

  onQuickSettingsUpdated(
      settings) {
    this.proxy.sendMessage(
        7,
        ash.ime.mojom.InputMethod_OnQuickSettingsUpdated_ParamsSpec.$,
        null,
        [
          settings
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        ready: !boolean,
   *  }>}
   */

  isReadyForTesting() {
    return this.proxy.sendMessage(
        8,
        ash.ime.mojom.InputMethod_IsReadyForTesting_ParamsSpec.$,
        ash.ime.mojom.InputMethod_IsReadyForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.AssistiveWindow } window
   */

  onAssistiveWindowChanged(
      window) {
    this.proxy.sendMessage(
        9,
        ash.ime.mojom.InputMethod_OnAssistiveWindowChanged_ParamsSpec.$,
        null,
        [
          window
        ],
        false);
  }
};

/**
 * An object which receives request messages for the InputMethod
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.ime.mojom.InputMethodReceiver = class {
  /**
   * @param {!ash.ime.mojom.InputMethodInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.ime.mojom.InputMethodRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.ime.mojom.InputMethodRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.InputMethodRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.InputMethod_OnFocusDeprecated_ParamsSpec.$,
        null,
        impl.onFocusDeprecated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ash.ime.mojom.InputMethod_OnFocus_ParamsSpec.$,
        ash.ime.mojom.InputMethod_OnFocus_ResponseParamsSpec.$,
        impl.onFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.ime.mojom.InputMethod_OnBlur_ParamsSpec.$,
        null,
        impl.onBlur.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.ime.mojom.InputMethod_ProcessKeyEvent_ParamsSpec.$,
        ash.ime.mojom.InputMethod_ProcessKeyEvent_ResponseParamsSpec.$,
        impl.processKeyEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ash.ime.mojom.InputMethod_OnSurroundingTextChanged_ParamsSpec.$,
        null,
        impl.onSurroundingTextChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ash.ime.mojom.InputMethod_OnCompositionCanceledBySystem_ParamsSpec.$,
        null,
        impl.onCompositionCanceledBySystem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ash.ime.mojom.InputMethod_OnCandidateSelected_ParamsSpec.$,
        null,
        impl.onCandidateSelected.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ash.ime.mojom.InputMethod_OnQuickSettingsUpdated_ParamsSpec.$,
        null,
        impl.onQuickSettingsUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        ash.ime.mojom.InputMethod_IsReadyForTesting_ParamsSpec.$,
        ash.ime.mojom.InputMethod_IsReadyForTesting_ResponseParamsSpec.$,
        impl.isReadyForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        ash.ime.mojom.InputMethod_OnAssistiveWindowChanged_ParamsSpec.$,
        null,
        impl.onAssistiveWindowChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.ime.mojom.InputMethod = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.InputMethod";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.ime.mojom.InputMethodRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.ime.mojom.InputMethodRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the InputMethod
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.ime.mojom.InputMethodCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.ime.mojom.InputMethodRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.InputMethodRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFocusDeprecated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.InputMethod_OnFocusDeprecated_ParamsSpec.$,
        null,
        this.onFocusDeprecated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ash.ime.mojom.InputMethod_OnFocus_ParamsSpec.$,
        ash.ime.mojom.InputMethod_OnFocus_ResponseParamsSpec.$,
        this.onFocus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBlur =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.ime.mojom.InputMethod_OnBlur_ParamsSpec.$,
        null,
        this.onBlur.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.processKeyEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.ime.mojom.InputMethod_ProcessKeyEvent_ParamsSpec.$,
        ash.ime.mojom.InputMethod_ProcessKeyEvent_ResponseParamsSpec.$,
        this.processKeyEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSurroundingTextChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ash.ime.mojom.InputMethod_OnSurroundingTextChanged_ParamsSpec.$,
        null,
        this.onSurroundingTextChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCompositionCanceledBySystem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ash.ime.mojom.InputMethod_OnCompositionCanceledBySystem_ParamsSpec.$,
        null,
        this.onCompositionCanceledBySystem.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCandidateSelected =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ash.ime.mojom.InputMethod_OnCandidateSelected_ParamsSpec.$,
        null,
        this.onCandidateSelected.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onQuickSettingsUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ash.ime.mojom.InputMethod_OnQuickSettingsUpdated_ParamsSpec.$,
        null,
        this.onQuickSettingsUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isReadyForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        ash.ime.mojom.InputMethod_IsReadyForTesting_ParamsSpec.$,
        ash.ime.mojom.InputMethod_IsReadyForTesting_ResponseParamsSpec.$,
        this.isReadyForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAssistiveWindowChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        ash.ime.mojom.InputMethod_OnAssistiveWindowChanged_ParamsSpec.$,
        null,
        this.onAssistiveWindowChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('ash.ime.mojom.ModifierStateSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.ModifierStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.PhysicalKeyEventSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.PhysicalKeyEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.SelectionRangeSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.SelectionRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputFieldInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputFieldInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.KoreanSettingsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.KoreanSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.LatinSettingsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.LatinSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.FuzzyPinyinSettingsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.FuzzyPinyinSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.PinyinSettingsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.PinyinSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.JapaneseSettingsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.JapaneseSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.ZhuyinSettingsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.ZhuyinSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.ChineseQuickSettingsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.ChineseQuickSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.JapaneseQuickSettingsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.JapaneseQuickSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.SuggestionCandidateSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.SuggestionCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodMetadataSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.AssistiveWindowSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.AssistiveWindowSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.VietnameseTelexSettingsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.VietnameseTelexSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.VietnameseVniSettingsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.VietnameseVniSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethod_OnFocusDeprecated_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethod_OnFocusDeprecated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethod_OnFocus_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethod_OnFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethod_OnFocus_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethod_OnFocus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethod_OnBlur_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethod_OnBlur_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethod_ProcessKeyEvent_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethod_ProcessKeyEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethod_ProcessKeyEvent_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethod_ProcessKeyEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethod_OnSurroundingTextChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethod_OnSurroundingTextChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethod_OnCompositionCanceledBySystem_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethod_OnCompositionCanceledBySystem_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethod_OnCandidateSelected_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethod_OnCandidateSelected_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethod_OnQuickSettingsUpdated_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethod_OnQuickSettingsUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethod_IsReadyForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethod_IsReadyForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethod_IsReadyForTesting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethod_IsReadyForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethod_OnAssistiveWindowChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethod_OnAssistiveWindowChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.DomKeySpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.DomKeySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodSettingsSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.InputMethodSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodQuickSettingsSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.InputMethodQuickSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ash.ime.mojom.ModifierStateSpec.$,
    'ModifierState',
    [
      mojo.internal.StructField(
        'alt', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'altGraph', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'capsLock', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'control', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'meta', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shift', 0,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.ModifierState');

/** @record */
ash.ime.mojom.ModifierState = class {
  constructor() {
    /** @export { !boolean } */
    this.alt;
    /** @export { !boolean } */
    this.altGraph;
    /** @export { !boolean } */
    this.capsLock;
    /** @export { !boolean } */
    this.control;
    /** @export { !boolean } */
    this.meta;
    /** @export { !boolean } */
    this.shift;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.PhysicalKeyEventSpec.$,
    'PhysicalKeyEvent',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        ash.ime.mojom.KeyEventTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'key', 8,
        0,
        ash.ime.mojom.DomKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'code', 4,
        0,
        ash.ime.mojom.DomCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'modifierState', 24,
        0,
        ash.ime.mojom.ModifierStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('ash.ime.mojom.PhysicalKeyEvent');

/** @record */
ash.ime.mojom.PhysicalKeyEvent = class {
  constructor() {
    /** @export { !ash.ime.mojom.KeyEventType } */
    this.type;
    /** @export { !ash.ime.mojom.DomKey } */
    this.key;
    /** @export { !ash.ime.mojom.DomCode } */
    this.code;
    /** @export { !ash.ime.mojom.ModifierState } */
    this.modifierState;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.SelectionRangeSpec.$,
    'SelectionRange',
    [
      mojo.internal.StructField(
        'anchor', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'focus', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.SelectionRange');

/** @record */
ash.ime.mojom.SelectionRange = class {
  constructor() {
    /** @export { !number } */
    this.anchor;
    /** @export { !number } */
    this.focus;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputFieldInfoSpec.$,
    'InputFieldInfo',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        ash.ime.mojom.InputFieldTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'autocorrect', 4,
        0,
        ash.ime.mojom.AutocorrectModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'personalization', 8,
        0,
        ash.ime.mojom.PersonalizationModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textPrediction', 12,
        0,
        ash.ime.mojom.TextPredictionModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[10, 24],]);



goog.provide('ash.ime.mojom.InputFieldInfo');

/** @record */
ash.ime.mojom.InputFieldInfo = class {
  constructor() {
    /** @export { !ash.ime.mojom.InputFieldType } */
    this.type;
    /** @export { !ash.ime.mojom.AutocorrectMode } */
    this.autocorrect;
    /** @export { !ash.ime.mojom.PersonalizationMode } */
    this.personalization;
    /** @export { !ash.ime.mojom.TextPredictionMode } */
    this.textPrediction;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.KoreanSettingsSpec.$,
    'KoreanSettings',
    [
      mojo.internal.StructField(
        'inputMultipleSyllables', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'layout', 4,
        0,
        ash.ime.mojom.KoreanLayoutSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.KoreanSettings');

/** @record */
ash.ime.mojom.KoreanSettings = class {
  constructor() {
    /** @export { !boolean } */
    this.inputMultipleSyllables;
    /** @export { !ash.ime.mojom.KoreanLayout } */
    this.layout;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.LatinSettingsSpec.$,
    'LatinSettings',
    [
      mojo.internal.StructField(
        'autocorrect', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'predictiveWriting', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[5, 16],]);



goog.provide('ash.ime.mojom.LatinSettings');

/** @record */
ash.ime.mojom.LatinSettings = class {
  constructor() {
    /** @export { !boolean } */
    this.autocorrect;
    /** @export { !boolean } */
    this.predictiveWriting;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.FuzzyPinyinSettingsSpec.$,
    'FuzzyPinyinSettings',
    [
      mojo.internal.StructField(
        'anAng', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enEng', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ianIang', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'kG', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rL', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'uanUang', 0,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cCh', 0,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fH', 0,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inIng', 1,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lN', 1,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sSh', 1,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'zZh', 1,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.FuzzyPinyinSettings');

/** @record */
ash.ime.mojom.FuzzyPinyinSettings = class {
  constructor() {
    /** @export { !boolean } */
    this.anAng;
    /** @export { !boolean } */
    this.enEng;
    /** @export { !boolean } */
    this.ianIang;
    /** @export { !boolean } */
    this.kG;
    /** @export { !boolean } */
    this.rL;
    /** @export { !boolean } */
    this.uanUang;
    /** @export { !boolean } */
    this.cCh;
    /** @export { !boolean } */
    this.fH;
    /** @export { !boolean } */
    this.inIng;
    /** @export { !boolean } */
    this.lN;
    /** @export { !boolean } */
    this.sSh;
    /** @export { !boolean } */
    this.zZh;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.PinyinSettingsSpec.$,
    'PinyinSettings',
    [
      mojo.internal.StructField(
        'fuzzyPinyin', 0,
        0,
        ash.ime.mojom.FuzzyPinyinSettingsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'layout', 8,
        0,
        ash.ime.mojom.PinyinLayoutSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'useHyphenAndEqualsToPageCandidates', 12,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'useCommaAndPeriodToPageCandidates', 12,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'defaultToChinese', 12,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'defaultToFullWidthCharacters', 12,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'defaultToFullWidthPunctuation', 12,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 8],[6, 24],]);



goog.provide('ash.ime.mojom.PinyinSettings');

/** @record */
ash.ime.mojom.PinyinSettings = class {
  constructor() {
    /** @export { (ash.ime.mojom.FuzzyPinyinSettings|undefined) } */
    this.fuzzyPinyin;
    /** @export { !ash.ime.mojom.PinyinLayout } */
    this.layout;
    /** @export { !boolean } */
    this.useHyphenAndEqualsToPageCandidates;
    /** @export { !boolean } */
    this.useCommaAndPeriodToPageCandidates;
    /** @export { !boolean } */
    this.defaultToChinese;
    /** @export { !boolean } */
    this.defaultToFullWidthCharacters;
    /** @export { !boolean } */
    this.defaultToFullWidthPunctuation;
  }
};


goog.provide('ash.ime.mojom.JapaneseSettings_InputMode');
goog.provide('ash.ime.mojom.JapaneseSettingsSpec.InputModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.JapaneseSettingsSpec.InputModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.JapaneseSettings_InputMode = {
  
  kUnspecified: 0,
  kRomaji: 1,
  kKana: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('ash.ime.mojom.JapaneseSettings_PunctuationStyle');
goog.provide('ash.ime.mojom.JapaneseSettingsSpec.PunctuationStyleSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.JapaneseSettingsSpec.PunctuationStyleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.JapaneseSettings_PunctuationStyle = {
  
  kUnspecified: 0,
  kKutenTouten: 1,
  kCommaPeriod: 2,
  kKutenPeriod: 3,
  kCommaTouten: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

goog.provide('ash.ime.mojom.JapaneseSettings_SymbolStyle');
goog.provide('ash.ime.mojom.JapaneseSettingsSpec.SymbolStyleSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.JapaneseSettingsSpec.SymbolStyleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.JapaneseSettings_SymbolStyle = {
  
  kUnspecified: 0,
  kCornerBracketMiddleDot: 1,
  kSquareBracketSlash: 2,
  kCornerBracketSlash: 3,
  kSquareBracketMiddleDot: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

goog.provide('ash.ime.mojom.JapaneseSettings_SpaceInputStyle');
goog.provide('ash.ime.mojom.JapaneseSettingsSpec.SpaceInputStyleSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.JapaneseSettingsSpec.SpaceInputStyleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.JapaneseSettings_SpaceInputStyle = {
  
  kUnspecified: 0,
  kInputMode: 1,
  kFullWidth: 2,
  kHalfWidth: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('ash.ime.mojom.JapaneseSettings_SelectionShortcut');
goog.provide('ash.ime.mojom.JapaneseSettingsSpec.SelectionShortcutSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.JapaneseSettingsSpec.SelectionShortcutSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.JapaneseSettings_SelectionShortcut = {
  
  kUnspecified: 0,
  kDigits123456789: 1,
  kAsdfghjkl: 2,
  kNoShortcut: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('ash.ime.mojom.JapaneseSettings_KeymapStyle');
goog.provide('ash.ime.mojom.JapaneseSettingsSpec.KeymapStyleSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.JapaneseSettingsSpec.KeymapStyleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.JapaneseSettings_KeymapStyle = {
  
  kUnspecified: 0,
  kCustom: 1,
  kAtok: 2,
  kMsime: 3,
  kKotoeri: 4,
  kMobile: 5,
  kChromeos: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};

goog.provide('ash.ime.mojom.JapaneseSettings_ShiftKeyModeStyle');
goog.provide('ash.ime.mojom.JapaneseSettingsSpec.ShiftKeyModeStyleSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.JapaneseSettingsSpec.ShiftKeyModeStyleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.JapaneseSettings_ShiftKeyModeStyle = {
  
  kUnspecified: 0,
  kOff: 1,
  kAlphanumeric: 2,
  kKatakana: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


mojo.internal.Struct(
    ash.ime.mojom.JapaneseSettingsSpec.$,
    'JapaneseSettings',
    [
      mojo.internal.StructField(
        'unused', 0,
        0,
        ash.ime.mojom.JpUnusedStructSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputMode', 8,
        0,
        ash.ime.mojom.JapaneseSettingsSpec.InputModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'punctuationStyle', 12,
        0,
        ash.ime.mojom.JapaneseSettingsSpec.PunctuationStyleSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'symbolStyle', 16,
        0,
        ash.ime.mojom.JapaneseSettingsSpec.SymbolStyleSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'spaceInputStyle', 20,
        0,
        ash.ime.mojom.JapaneseSettingsSpec.SpaceInputStyleSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selectionShortcut', 24,
        0,
        ash.ime.mojom.JapaneseSettingsSpec.SelectionShortcutSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keymapStyle', 28,
        0,
        ash.ime.mojom.JapaneseSettingsSpec.KeymapStyleSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'automaticallySwitchToHalfwidth', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shiftKeyModeStyle', 36,
        0,
        ash.ime.mojom.JapaneseSettingsSpec.ShiftKeyModeStyleSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'useInputHistory', 32,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'useSystemDictionary', 32,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numberOfSuggestions', 40,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'disablePersonalizedSuggestions', 32,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unused2', 32,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[22, 56],]);



goog.provide('ash.ime.mojom.JapaneseSettings');

/** @record */
ash.ime.mojom.JapaneseSettings = class {
  constructor() {
    /** @export { (ash.ime.mojom.JpUnusedStruct|undefined) } */
    this.unused;
    /** @export { !ash.ime.mojom.JapaneseSettings_InputMode } */
    this.inputMode;
    /** @export { !ash.ime.mojom.JapaneseSettings_PunctuationStyle } */
    this.punctuationStyle;
    /** @export { !ash.ime.mojom.JapaneseSettings_SymbolStyle } */
    this.symbolStyle;
    /** @export { !ash.ime.mojom.JapaneseSettings_SpaceInputStyle } */
    this.spaceInputStyle;
    /** @export { !ash.ime.mojom.JapaneseSettings_SelectionShortcut } */
    this.selectionShortcut;
    /** @export { !ash.ime.mojom.JapaneseSettings_KeymapStyle } */
    this.keymapStyle;
    /** @export { !boolean } */
    this.automaticallySwitchToHalfwidth;
    /** @export { !ash.ime.mojom.JapaneseSettings_ShiftKeyModeStyle } */
    this.shiftKeyModeStyle;
    /** @export { !boolean } */
    this.useInputHistory;
    /** @export { !boolean } */
    this.useSystemDictionary;
    /** @export { !number } */
    this.numberOfSuggestions;
    /** @export { !boolean } */
    this.disablePersonalizedSuggestions;
    /** @export { !boolean } */
    this.unused2;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.ZhuyinSettingsSpec.$,
    'ZhuyinSettings',
    [
      mojo.internal.StructField(
        'layout', 0,
        0,
        ash.ime.mojom.ZhuyinLayoutSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selectionKeys', 4,
        0,
        ash.ime.mojom.ZhuyinSelectionKeysSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pageSize', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 8],[7, 24],]);



goog.provide('ash.ime.mojom.ZhuyinSettings');

/** @record */
ash.ime.mojom.ZhuyinSettings = class {
  constructor() {
    /** @export { !ash.ime.mojom.ZhuyinLayout } */
    this.layout;
    /** @export { !ash.ime.mojom.ZhuyinSelectionKeys } */
    this.selectionKeys;
    /** @export { !number } */
    this.pageSize;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.ChineseQuickSettingsSpec.$,
    'ChineseQuickSettings',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        ash.ime.mojom.ChineseLanguageModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fullWidthCharacters', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fullWidthPunctuation', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.ChineseQuickSettings');

/** @record */
ash.ime.mojom.ChineseQuickSettings = class {
  constructor() {
    /** @export { !ash.ime.mojom.ChineseLanguageMode } */
    this.mode;
    /** @export { !boolean } */
    this.fullWidthCharacters;
    /** @export { !boolean } */
    this.fullWidthPunctuation;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.JapaneseQuickSettingsSpec.$,
    'JapaneseQuickSettings',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        ash.ime.mojom.JapaneseInputModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.JapaneseQuickSettings');

/** @record */
ash.ime.mojom.JapaneseQuickSettings = class {
  constructor() {
    /** @export { !ash.ime.mojom.JapaneseInputMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.SuggestionCandidateSpec.$,
    'SuggestionCandidate',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        ash.ime.mojom.SuggestionModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 4,
        0,
        ash.ime.mojom.SuggestionTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'confirmedLength', 16,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[13, 32],]);



goog.provide('ash.ime.mojom.SuggestionCandidate');

/** @record */
ash.ime.mojom.SuggestionCandidate = class {
  constructor() {
    /** @export { !ash.ime.mojom.SuggestionMode } */
    this.mode;
    /** @export { !ash.ime.mojom.SuggestionType } */
    this.type;
    /** @export { !string } */
    this.text;
    /** @export { !number } */
    this.confirmedLength;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodMetadataSpec.$,
    'InputMethodMetadata',
    [
      mojo.internal.StructField(
        'autocorrectSuggestionProvider', 0,
        0,
        ash.ime.mojom.AutocorrectSuggestionProviderSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodMetadata');

/** @record */
ash.ime.mojom.InputMethodMetadata = class {
  constructor() {
    /** @export { !ash.ime.mojom.AutocorrectSuggestionProvider } */
    this.autocorrectSuggestionProvider;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.AssistiveWindowSpec.$,
    'AssistiveWindow',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        ash.ime.mojom.AssistiveWindowTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'candidates', 8,
        0,
        mojo.internal.Array(ash.ime.mojom.SuggestionCandidateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ash.ime.mojom.AssistiveWindow');

/** @record */
ash.ime.mojom.AssistiveWindow = class {
  constructor() {
    /** @export { !ash.ime.mojom.AssistiveWindowType } */
    this.type;
    /** @export { !Array<!ash.ime.mojom.SuggestionCandidate> } */
    this.candidates;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.VietnameseTelexSettingsSpec.$,
    'VietnameseTelexSettings',
    [
      mojo.internal.StructField(
        'allowFlexibleDiacritics', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newStyleToneMarkPlacement', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableInsertDoubleHornOnUo', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableWForUHornShortcut', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'showUnderlineForCompositionText', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[20, 16],]);



goog.provide('ash.ime.mojom.VietnameseTelexSettings');

/** @record */
ash.ime.mojom.VietnameseTelexSettings = class {
  constructor() {
    /** @export { !boolean } */
    this.allowFlexibleDiacritics;
    /** @export { !boolean } */
    this.newStyleToneMarkPlacement;
    /** @export { !boolean } */
    this.enableInsertDoubleHornOnUo;
    /** @export { !boolean } */
    this.enableWForUHornShortcut;
    /** @export { !boolean } */
    this.showUnderlineForCompositionText;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.VietnameseVniSettingsSpec.$,
    'VietnameseVniSettings',
    [
      mojo.internal.StructField(
        'allowFlexibleDiacritics', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newStyleToneMarkPlacement', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enableInsertDoubleHornOnUo', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'showUnderlineForCompositionText', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[20, 16],]);



goog.provide('ash.ime.mojom.VietnameseVniSettings');

/** @record */
ash.ime.mojom.VietnameseVniSettings = class {
  constructor() {
    /** @export { !boolean } */
    this.allowFlexibleDiacritics;
    /** @export { !boolean } */
    this.newStyleToneMarkPlacement;
    /** @export { !boolean } */
    this.enableInsertDoubleHornOnUo;
    /** @export { !boolean } */
    this.showUnderlineForCompositionText;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethod_OnFocusDeprecated_ParamsSpec.$,
    'InputMethod_OnFocusDeprecated_Params',
    [
      mojo.internal.StructField(
        'inputFieldInfo', 0,
        0,
        ash.ime.mojom.InputFieldInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'settings', 8,
        0,
        ash.ime.mojom.InputMethodSettingsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[4, 32],]);



goog.provide('ash.ime.mojom.InputMethod_OnFocusDeprecated_Params');

/** @record */
ash.ime.mojom.InputMethod_OnFocusDeprecated_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.InputFieldInfo } */
    this.inputFieldInfo;
    /** @export { (ash.ime.mojom.InputMethodSettings|undefined) } */
    this.settings;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethod_OnFocus_ParamsSpec.$,
    'InputMethod_OnFocus_Params',
    [
      mojo.internal.StructField(
        'inputFieldInfo', 0,
        0,
        ash.ime.mojom.InputFieldInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deprecatedSettings', 8,
        0,
        ash.ime.mojom.InputMethodSettingsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('ash.ime.mojom.InputMethod_OnFocus_Params');

/** @record */
ash.ime.mojom.InputMethod_OnFocus_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.InputFieldInfo } */
    this.inputFieldInfo;
    /** @export { (ash.ime.mojom.InputMethodSettings|undefined) } */
    this.deprecatedSettings;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethod_OnFocus_ResponseParamsSpec.$,
    'InputMethod_OnFocus_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'metadata', 8,
        0,
        ash.ime.mojom.InputMethodMetadataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[17, 24],]);



goog.provide('ash.ime.mojom.InputMethod_OnFocus_ResponseParams');

/** @record */
ash.ime.mojom.InputMethod_OnFocus_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { (ash.ime.mojom.InputMethodMetadata|undefined) } */
    this.metadata;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethod_OnBlur_ParamsSpec.$,
    'InputMethod_OnBlur_Params',
    [
    ],
    [[0, 8],]);



goog.provide('ash.ime.mojom.InputMethod_OnBlur_Params');

/** @record */
ash.ime.mojom.InputMethod_OnBlur_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethod_ProcessKeyEvent_ParamsSpec.$,
    'InputMethod_ProcessKeyEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        ash.ime.mojom.PhysicalKeyEventSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethod_ProcessKeyEvent_Params');

/** @record */
ash.ime.mojom.InputMethod_ProcessKeyEvent_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.PhysicalKeyEvent } */
    this.event;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethod_ProcessKeyEvent_ResponseParamsSpec.$,
    'InputMethod_ProcessKeyEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ash.ime.mojom.KeyEventResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethod_ProcessKeyEvent_ResponseParams');

/** @record */
ash.ime.mojom.InputMethod_ProcessKeyEvent_ResponseParams = class {
  constructor() {
    /** @export { !ash.ime.mojom.KeyEventResult } */
    this.result;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethod_OnSurroundingTextChanged_ParamsSpec.$,
    'InputMethod_OnSurroundingTextChanged_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'offset', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selectionRange', 16,
        0,
        ash.ime.mojom.SelectionRangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('ash.ime.mojom.InputMethod_OnSurroundingTextChanged_Params');

/** @record */
ash.ime.mojom.InputMethod_OnSurroundingTextChanged_Params = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { !number } */
    this.offset;
    /** @export { !ash.ime.mojom.SelectionRange } */
    this.selectionRange;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethod_OnCompositionCanceledBySystem_ParamsSpec.$,
    'InputMethod_OnCompositionCanceledBySystem_Params',
    [
    ],
    [[0, 8],]);



goog.provide('ash.ime.mojom.InputMethod_OnCompositionCanceledBySystem_Params');

/** @record */
ash.ime.mojom.InputMethod_OnCompositionCanceledBySystem_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethod_OnCandidateSelected_ParamsSpec.$,
    'InputMethod_OnCandidateSelected_Params',
    [
      mojo.internal.StructField(
        'selectedCandidateIndex', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethod_OnCandidateSelected_Params');

/** @record */
ash.ime.mojom.InputMethod_OnCandidateSelected_Params = class {
  constructor() {
    /** @export { !number } */
    this.selectedCandidateIndex;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethod_OnQuickSettingsUpdated_ParamsSpec.$,
    'InputMethod_OnQuickSettingsUpdated_Params',
    [
      mojo.internal.StructField(
        'settings', 0,
        0,
        ash.ime.mojom.InputMethodQuickSettingsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ash.ime.mojom.InputMethod_OnQuickSettingsUpdated_Params');

/** @record */
ash.ime.mojom.InputMethod_OnQuickSettingsUpdated_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.InputMethodQuickSettings } */
    this.settings;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethod_IsReadyForTesting_ParamsSpec.$,
    'InputMethod_IsReadyForTesting_Params',
    [
    ],
    [[0, 8],]);



goog.provide('ash.ime.mojom.InputMethod_IsReadyForTesting_Params');

/** @record */
ash.ime.mojom.InputMethod_IsReadyForTesting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethod_IsReadyForTesting_ResponseParamsSpec.$,
    'InputMethod_IsReadyForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'ready', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethod_IsReadyForTesting_ResponseParams');

/** @record */
ash.ime.mojom.InputMethod_IsReadyForTesting_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.ready;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethod_OnAssistiveWindowChanged_ParamsSpec.$,
    'InputMethod_OnAssistiveWindowChanged_Params',
    [
      mojo.internal.StructField(
        'window', 0,
        0,
        ash.ime.mojom.AssistiveWindowSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethod_OnAssistiveWindowChanged_Params');

/** @record */
ash.ime.mojom.InputMethod_OnAssistiveWindowChanged_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.AssistiveWindow } */
    this.window;
  }
};

goog.provide('ash.ime.mojom.DomKey');


mojo.internal.Union(
    ash.ime.mojom.DomKeySpec.$, 'DomKey',
    {
      'namedKey': {
        'ordinal': 0,
        'type': ash.ime.mojom.NamedDomKeySpec.$,
      },
      'codepoint': {
        'ordinal': 1,
        'type': mojo.internal.Uint32,
      },
    });

/**
 * @typedef { {
 *   namedKey: (!ash.ime.mojom.NamedDomKey|undefined),
 *   codepoint: (!number|undefined),
 * } }
 */
ash.ime.mojom.DomKey;
goog.provide('ash.ime.mojom.InputMethodSettings');


mojo.internal.Union(
    ash.ime.mojom.InputMethodSettingsSpec.$, 'InputMethodSettings',
    {
      'koreanSettings': {
        'ordinal': 0,
        'type': ash.ime.mojom.KoreanSettingsSpec.$,
      },
      'latinSettings': {
        'ordinal': 1,
        'type': ash.ime.mojom.LatinSettingsSpec.$,
      },
      'pinyinSettings': {
        'ordinal': 2,
        'type': ash.ime.mojom.PinyinSettingsSpec.$,
      },
      'zhuyinSettings': {
        'ordinal': 3,
        'type': ash.ime.mojom.ZhuyinSettingsSpec.$,
      },
      'nullSettings': {
        'ordinal': 4,
        'type': mojo.internal.Bool,
      },
      'japaneseSettings': {
        'ordinal': 5,
        'type': ash.ime.mojom.JapaneseSettingsSpec.$,
      },
      'vietnameseTelexSettings': {
        'ordinal': 6,
        'type': ash.ime.mojom.VietnameseTelexSettingsSpec.$,
      },
      'vietnameseVniSettings': {
        'ordinal': 7,
        'type': ash.ime.mojom.VietnameseVniSettingsSpec.$,
      },
    });

/**
 * @typedef { {
 *   koreanSettings: (!ash.ime.mojom.KoreanSettings|undefined),
 *   latinSettings: (!ash.ime.mojom.LatinSettings|undefined),
 *   pinyinSettings: (!ash.ime.mojom.PinyinSettings|undefined),
 *   zhuyinSettings: (!ash.ime.mojom.ZhuyinSettings|undefined),
 *   nullSettings: (!boolean|undefined),
 *   japaneseSettings: (!ash.ime.mojom.JapaneseSettings|undefined),
 *   vietnameseTelexSettings: (!ash.ime.mojom.VietnameseTelexSettings|undefined),
 *   vietnameseVniSettings: (!ash.ime.mojom.VietnameseVniSettings|undefined),
 * } }
 */
ash.ime.mojom.InputMethodSettings;
goog.provide('ash.ime.mojom.InputMethodQuickSettings');


mojo.internal.Union(
    ash.ime.mojom.InputMethodQuickSettingsSpec.$, 'InputMethodQuickSettings',
    {
      'chineseSettings': {
        'ordinal': 0,
        'type': ash.ime.mojom.ChineseQuickSettingsSpec.$,
      },
      'japaneseSettings': {
        'ordinal': 1,
        'type': ash.ime.mojom.JapaneseQuickSettingsSpec.$,
      },
    });

/**
 * @typedef { {
 *   chineseSettings: (!ash.ime.mojom.ChineseQuickSettings|undefined),
 *   japaneseSettings: (!ash.ime.mojom.JapaneseQuickSettings|undefined),
 * } }
 */
ash.ime.mojom.InputMethodQuickSettings;
