// chromeos/ash/services/ime/public/mojom/input_method.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/ash/services/ime/public/mojom/input_method.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ash.ime.mojom');
  var japanese_settings$ =
      mojo.internal.exposeNamespace('ash.ime.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/ash/services/ime/public/mojom/japanese_settings.mojom', 'japanese_settings.mojom.js');
  }


  var KeyEventType = {};
  KeyEventType.kKeyDown = 0;
  KeyEventType.kKeyUp = 1;
  KeyEventType.MIN_VALUE = 0;
  KeyEventType.MAX_VALUE = 1;
  KeyEventType.DEFAULT_VALUE = 0;

  KeyEventType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  KeyEventType.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  KeyEventType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var NamedDomKey = {};
  NamedDomKey.kOther = 0;
  NamedDomKey.kAlt = 1;
  NamedDomKey.kAltGraph = 2;
  NamedDomKey.kCapsLock = 3;
  NamedDomKey.kControl = 4;
  NamedDomKey.kShift = 5;
  NamedDomKey.kEnter = 6;
  NamedDomKey.kBackspace = 7;
  NamedDomKey.kEscape = 10;
  NamedDomKey.kHangeulMode = 8;
  NamedDomKey.kHanjaMode = 9;
  NamedDomKey.kArrowDown = 11;
  NamedDomKey.kArrowLeft = 12;
  NamedDomKey.kArrowRight = 13;
  NamedDomKey.kArrowUp = 14;
  NamedDomKey.kPageDown = 15;
  NamedDomKey.kPageUp = 16;
  NamedDomKey.kTab = 17;
  NamedDomKey.kF1 = 18;
  NamedDomKey.kF2 = 19;
  NamedDomKey.kF3 = 20;
  NamedDomKey.kF4 = 21;
  NamedDomKey.kF5 = 22;
  NamedDomKey.kF6 = 23;
  NamedDomKey.kF7 = 24;
  NamedDomKey.kF8 = 25;
  NamedDomKey.kF9 = 26;
  NamedDomKey.kF10 = 27;
  NamedDomKey.kF11 = 28;
  NamedDomKey.kF12 = 29;
  NamedDomKey.kBrowserBack = 30;
  NamedDomKey.kBrowserForward = 31;
  NamedDomKey.kBrowserRefresh = 32;
  NamedDomKey.kZoomToggle = 33;
  NamedDomKey.kLaunchMyComputer = 34;
  NamedDomKey.kBrightnessDown = 35;
  NamedDomKey.kBrightnessUp = 36;
  NamedDomKey.kAudioVolumeMute = 37;
  NamedDomKey.kAudioVolumeDown = 38;
  NamedDomKey.kAudioVolumeUp = 39;
  NamedDomKey.kDelete = 40;
  NamedDomKey.kNumLock = 41;
  NamedDomKey.MIN_VALUE = 0;
  NamedDomKey.MAX_VALUE = 41;
  NamedDomKey.DEFAULT_VALUE = 0;

  NamedDomKey.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
      return true;
    }
    return false;
  };

  NamedDomKey.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  NamedDomKey.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var DomCode = {};
  DomCode.kOther = 0;
  DomCode.kBackquote = 1;
  DomCode.kBackslash = 2;
  DomCode.kBracketLeft = 3;
  DomCode.kBracketRight = 4;
  DomCode.kComma = 5;
  DomCode.kDigit0 = 6;
  DomCode.kDigit1 = 7;
  DomCode.kDigit2 = 8;
  DomCode.kDigit3 = 9;
  DomCode.kDigit4 = 10;
  DomCode.kDigit5 = 11;
  DomCode.kDigit6 = 12;
  DomCode.kDigit7 = 13;
  DomCode.kDigit8 = 14;
  DomCode.kDigit9 = 15;
  DomCode.kEqual = 16;
  DomCode.kIntlBackslash = 17;
  DomCode.kIntlRo = 18;
  DomCode.kIntlYen = 19;
  DomCode.kKeyA = 20;
  DomCode.kKeyB = 21;
  DomCode.kKeyC = 22;
  DomCode.kKeyD = 23;
  DomCode.kKeyE = 24;
  DomCode.kKeyF = 25;
  DomCode.kKeyG = 26;
  DomCode.kKeyH = 27;
  DomCode.kKeyI = 28;
  DomCode.kKeyJ = 29;
  DomCode.kKeyK = 30;
  DomCode.kKeyL = 31;
  DomCode.kKeyM = 32;
  DomCode.kKeyN = 33;
  DomCode.kKeyO = 34;
  DomCode.kKeyP = 35;
  DomCode.kKeyQ = 36;
  DomCode.kKeyR = 37;
  DomCode.kKeyS = 38;
  DomCode.kKeyT = 39;
  DomCode.kKeyU = 40;
  DomCode.kKeyV = 41;
  DomCode.kKeyW = 42;
  DomCode.kKeyX = 43;
  DomCode.kKeyY = 44;
  DomCode.kKeyZ = 45;
  DomCode.kMinus = 46;
  DomCode.kPeriod = 47;
  DomCode.kQuote = 48;
  DomCode.kSemicolon = 49;
  DomCode.kSlash = 50;
  DomCode.kBackspace = 51;
  DomCode.kEnter = 52;
  DomCode.kSpace = 53;
  DomCode.kAltLeft = 54;
  DomCode.kAltRight = 55;
  DomCode.kShiftLeft = 56;
  DomCode.kShiftRight = 57;
  DomCode.kControlLeft = 58;
  DomCode.kControlRight = 59;
  DomCode.kCapsLock = 60;
  DomCode.kEscape = 61;
  DomCode.kTab = 62;
  DomCode.kNumpadMultiply = 63;
  DomCode.kKanaMode = 64;
  DomCode.kPageUp = 65;
  DomCode.kEnd = 66;
  DomCode.kDelete = 67;
  DomCode.kHome = 68;
  DomCode.kPageDown = 69;
  DomCode.kArrowUp = 70;
  DomCode.kArrowLeft = 71;
  DomCode.kArrowRight = 72;
  DomCode.kArrowDown = 73;
  DomCode.kNumpad0 = 74;
  DomCode.kNumpad1 = 75;
  DomCode.kNumpad2 = 76;
  DomCode.kNumpad3 = 77;
  DomCode.kNumpad4 = 78;
  DomCode.kNumpad5 = 79;
  DomCode.kNumpad6 = 80;
  DomCode.kNumpad7 = 81;
  DomCode.kNumpad8 = 82;
  DomCode.kNumpad9 = 83;
  DomCode.kNumpadSubtract = 84;
  DomCode.kNumpadAdd = 85;
  DomCode.kNumpadDecimal = 86;
  DomCode.kNumpadEnter = 87;
  DomCode.kNumpadDivide = 88;
  DomCode.MIN_VALUE = 0;
  DomCode.MAX_VALUE = 88;
  DomCode.DEFAULT_VALUE = 0;

  DomCode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 61:
    case 62:
    case 63:
    case 64:
    case 65:
    case 66:
    case 67:
    case 68:
    case 69:
    case 70:
    case 71:
    case 72:
    case 73:
    case 74:
    case 75:
    case 76:
    case 77:
    case 78:
    case 79:
    case 80:
    case 81:
    case 82:
    case 83:
    case 84:
    case 85:
    case 86:
    case 87:
    case 88:
      return true;
    }
    return false;
  };

  DomCode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  DomCode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var KeyEventResult = {};
  KeyEventResult.kNeedsHandlingBySystem = 0;
  KeyEventResult.kConsumedByIme = 1;
  KeyEventResult.MIN_VALUE = 0;
  KeyEventResult.MAX_VALUE = 1;
  KeyEventResult.DEFAULT_VALUE = 0;

  KeyEventResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  KeyEventResult.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  KeyEventResult.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var InputFieldType = {};
  InputFieldType.kNoIME = 0;
  InputFieldType.kText = 1;
  InputFieldType.kSearch = 2;
  InputFieldType.kTelephone = 3;
  InputFieldType.kURL = 4;
  InputFieldType.kEmail = 5;
  InputFieldType.kNumber = 6;
  InputFieldType.kPassword = 7;
  InputFieldType.MIN_VALUE = 0;
  InputFieldType.MAX_VALUE = 7;

  InputFieldType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  InputFieldType.toKnownEnumValue = function(value) {
    return value;
  };

  InputFieldType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AutocorrectMode = {};
  AutocorrectMode.kDisabled = 0;
  AutocorrectMode.kEnabled = 1;
  AutocorrectMode.MIN_VALUE = 0;
  AutocorrectMode.MAX_VALUE = 1;
  AutocorrectMode.DEFAULT_VALUE = 0;

  AutocorrectMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  AutocorrectMode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  AutocorrectMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var PersonalizationMode = {};
  PersonalizationMode.kDisabled = 0;
  PersonalizationMode.kEnabled = 1;
  PersonalizationMode.MIN_VALUE = 0;
  PersonalizationMode.MAX_VALUE = 1;

  PersonalizationMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  PersonalizationMode.toKnownEnumValue = function(value) {
    return value;
  };

  PersonalizationMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var TextPredictionMode = {};
  TextPredictionMode.kDisabled = 0;
  TextPredictionMode.kEnabled = 1;
  TextPredictionMode.MIN_VALUE = 0;
  TextPredictionMode.MAX_VALUE = 1;
  TextPredictionMode.DEFAULT_VALUE = 0;

  TextPredictionMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  TextPredictionMode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  TextPredictionMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var KoreanLayout = {};
  KoreanLayout.kDubeolsik = 0;
  KoreanLayout.kDubeolsikOldHangeul = 1;
  KoreanLayout.kSebeolsik390 = 2;
  KoreanLayout.kSebeolsikFinal = 3;
  KoreanLayout.kSebeolsikNoShift = 4;
  KoreanLayout.kSebeolsikOldHangeul = 5;
  KoreanLayout.kDeprecatedSebeolsikDubeol = 6;
  KoreanLayout.kDeprecatedRomaja = 7;
  KoreanLayout.kDeprecatedAhnmatae = 8;
  KoreanLayout.MIN_VALUE = 0;
  KoreanLayout.MAX_VALUE = 8;
  KoreanLayout.DEFAULT_VALUE = 0;

  KoreanLayout.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
      return true;
    }
    return false;
  };

  KoreanLayout.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  KoreanLayout.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var PinyinLayout = {};
  PinyinLayout.kUsQwerty = 0;
  PinyinLayout.kDvorak = 1;
  PinyinLayout.kColemak = 2;
  PinyinLayout.MIN_VALUE = 0;
  PinyinLayout.MAX_VALUE = 2;
  PinyinLayout.DEFAULT_VALUE = 0;

  PinyinLayout.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  PinyinLayout.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  PinyinLayout.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ZhuyinLayout = {};
  ZhuyinLayout.kStandard = 0;
  ZhuyinLayout.kIbm = 1;
  ZhuyinLayout.kEten = 2;
  ZhuyinLayout.MIN_VALUE = 0;
  ZhuyinLayout.MAX_VALUE = 2;
  ZhuyinLayout.DEFAULT_VALUE = 0;

  ZhuyinLayout.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ZhuyinLayout.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  ZhuyinLayout.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ZhuyinSelectionKeys = {};
  ZhuyinSelectionKeys.k1234567890 = 0;
  ZhuyinSelectionKeys.kAsdfghjkl = 1;
  ZhuyinSelectionKeys.kAsdfzxcv89 = 2;
  ZhuyinSelectionKeys.kAsdfjkl789 = 3;
  ZhuyinSelectionKeys.k1234Qweras = 4;
  ZhuyinSelectionKeys.MIN_VALUE = 0;
  ZhuyinSelectionKeys.MAX_VALUE = 4;
  ZhuyinSelectionKeys.DEFAULT_VALUE = 0;

  ZhuyinSelectionKeys.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  ZhuyinSelectionKeys.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  ZhuyinSelectionKeys.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ChineseLanguageMode = {};
  ChineseLanguageMode.kChinese = 0;
  ChineseLanguageMode.kRaw = 1;
  ChineseLanguageMode.MIN_VALUE = 0;
  ChineseLanguageMode.MAX_VALUE = 1;
  ChineseLanguageMode.DEFAULT_VALUE = 0;

  ChineseLanguageMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ChineseLanguageMode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  ChineseLanguageMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var JapaneseInputMode = {};
  JapaneseInputMode.kHiragana = 0;
  JapaneseInputMode.kKatakana = 1;
  JapaneseInputMode.kWideLatin = 2;
  JapaneseInputMode.kHalfWidthKatakana = 3;
  JapaneseInputMode.kLatin = 4;
  JapaneseInputMode.kDirectInput = 5;
  JapaneseInputMode.MIN_VALUE = 0;
  JapaneseInputMode.MAX_VALUE = 5;
  JapaneseInputMode.DEFAULT_VALUE = 0;

  JapaneseInputMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  JapaneseInputMode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  JapaneseInputMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SuggestionMode = {};
  SuggestionMode.kUnknown = 0;
  SuggestionMode.kCompletion = 1;
  SuggestionMode.kPrediction = 2;
  SuggestionMode.MIN_VALUE = 0;
  SuggestionMode.MAX_VALUE = 2;
  SuggestionMode.DEFAULT_VALUE = 0;

  SuggestionMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SuggestionMode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  SuggestionMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SuggestionType = {};
  SuggestionType.kUnknown = 0;
  SuggestionType.kAssistivePersonalInfo = 1;
  SuggestionType.kAssistiveEmoji = 2;
  SuggestionType.kMultiWord = 3;
  SuggestionType.kGrammar = 4;
  SuggestionType.kLongpressDiacritic = 5;
  SuggestionType.MIN_VALUE = 0;
  SuggestionType.MAX_VALUE = 5;
  SuggestionType.DEFAULT_VALUE = 0;

  SuggestionType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  SuggestionType.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  SuggestionType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AssistiveWindowType = {};
  AssistiveWindowType.kHidden = 0;
  AssistiveWindowType.kUndo = 1;
  AssistiveWindowType.kEmojiSuggestion = 2;
  AssistiveWindowType.kPersonalInfoSuggestion = 3;
  AssistiveWindowType.kGrammarSuggestion = 4;
  AssistiveWindowType.kMultiWordSuggestion = 5;
  AssistiveWindowType.kLongpressDiacriticsSuggestion = 6;
  AssistiveWindowType.MIN_VALUE = 0;
  AssistiveWindowType.MAX_VALUE = 6;
  AssistiveWindowType.DEFAULT_VALUE = 0;

  AssistiveWindowType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  AssistiveWindowType.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  AssistiveWindowType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AutocorrectSuggestionProvider = {};
  AutocorrectSuggestionProvider.kUnknown = 0;
  AutocorrectSuggestionProvider.kUsEnglishPrebundled = 1;
  AutocorrectSuggestionProvider.kUsEnglishDownloaded = 2;
  AutocorrectSuggestionProvider.kUsEnglish840 = 3;
  AutocorrectSuggestionProvider.kUsEnglish840V2 = 4;
  AutocorrectSuggestionProvider.MIN_VALUE = 0;
  AutocorrectSuggestionProvider.MAX_VALUE = 4;
  AutocorrectSuggestionProvider.DEFAULT_VALUE = 0;

  AutocorrectSuggestionProvider.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  AutocorrectSuggestionProvider.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  AutocorrectSuggestionProvider.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ModifierState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ModifierState.prototype.initDefaults_ = function() {
    this.alt = false;
    this.altGraph = false;
    this.capsLock = false;
    this.control = false;
    this.meta = false;
    this.shift = false;
  };
  ModifierState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ModifierState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;







    return validator.validationError.NONE;
  };

  ModifierState.encodedSize = codec.kStructHeaderSize + 8;

  ModifierState.decode = function(decoder) {
    var packed;
    var val = new ModifierState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.alt = (packed >> 0) & 1 ? true : false;
    val.altGraph = (packed >> 1) & 1 ? true : false;
    val.capsLock = (packed >> 2) & 1 ? true : false;
    val.control = (packed >> 3) & 1 ? true : false;
    val.meta = (packed >> 4) & 1 ? true : false;
    val.shift = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ModifierState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ModifierState.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.alt & 1) << 0
    packed |= (val.altGraph & 1) << 1
    packed |= (val.capsLock & 1) << 2
    packed |= (val.control & 1) << 3
    packed |= (val.meta & 1) << 4
    packed |= (val.shift & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PhysicalKeyEvent(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PhysicalKeyEvent.prototype.initDefaults_ = function() {
    this.type = 0;
    this.code = 0;
    this.key = null;
    this.modifierState = null;
  };
  PhysicalKeyEvent.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PhysicalKeyEvent.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PhysicalKeyEvent.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, KeyEventType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PhysicalKeyEvent.key
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, DomKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PhysicalKeyEvent.code
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, DomCode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PhysicalKeyEvent.modifierState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, ModifierState, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PhysicalKeyEvent.encodedSize = codec.kStructHeaderSize + 32;

  PhysicalKeyEvent.decode = function(decoder) {
    var packed;
    var val = new PhysicalKeyEvent();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(KeyEventType));
    val.code =
        decoder.decodeStruct(new codec.Enum(DomCode));
    val.key =
        decoder.decodeStruct(DomKey);
    val.modifierState =
        decoder.decodeStructPointer(ModifierState);
    return val;
  };

  PhysicalKeyEvent.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PhysicalKeyEvent.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Int32, val.code);
    encoder.encodeStruct(DomKey, val.key);
    encoder.encodeStructPointer(ModifierState, val.modifierState);
  };
  function SelectionRange(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SelectionRange.prototype.initDefaults_ = function() {
    this.anchor = 0;
    this.focus = 0;
  };
  SelectionRange.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SelectionRange.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SelectionRange.encodedSize = codec.kStructHeaderSize + 8;

  SelectionRange.decode = function(decoder) {
    var packed;
    var val = new SelectionRange();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.anchor =
        decoder.decodeStruct(codec.Uint32);
    val.focus =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  SelectionRange.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SelectionRange.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.anchor);
    encoder.encodeStruct(codec.Uint32, val.focus);
  };
  function InputFieldInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputFieldInfo.prototype.initDefaults_ = function() {
    this.type = 0;
    this.autocorrect = 0;
    this.personalization = 0;
    this.textPrediction = 0;
  };
  InputFieldInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputFieldInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 10, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputFieldInfo.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, InputFieldType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputFieldInfo.autocorrect
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, AutocorrectMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputFieldInfo.personalization
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, PersonalizationMode);
    if (err !== validator.validationError.NONE)
        return err;



    // version check InputFieldInfo.textPrediction
    if (!messageValidator.isFieldInStructVersion(offset, 10))
      return validator.validationError.NONE;
    // validate InputFieldInfo.textPrediction
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, TextPredictionMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputFieldInfo.encodedSize = codec.kStructHeaderSize + 16;

  InputFieldInfo.decode = function(decoder) {
    var packed;
    var val = new InputFieldInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(InputFieldType));
    val.autocorrect =
        decoder.decodeStruct(new codec.Enum(AutocorrectMode));
    val.personalization =
        decoder.decodeStruct(new codec.Enum(PersonalizationMode));
    if (version >= 10) {
      val.textPrediction =
          decoder.decodeStruct(new codec.Enum(TextPredictionMode));
    } else {
      val.textPrediction = null;
    }
    return val;
  };

  InputFieldInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputFieldInfo.encodedSize);
    encoder.writeUint32(10);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.Int32, val.autocorrect);
    encoder.encodeStruct(codec.Int32, val.personalization);
    encoder.encodeStruct(codec.Int32, val.textPrediction);
  };
  function KoreanSettings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  KoreanSettings.prototype.initDefaults_ = function() {
    this.inputMultipleSyllables = false;
    this.layout = 0;
  };
  KoreanSettings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  KoreanSettings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate KoreanSettings.layout
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, KoreanLayout);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  KoreanSettings.encodedSize = codec.kStructHeaderSize + 8;

  KoreanSettings.decode = function(decoder) {
    var packed;
    var val = new KoreanSettings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.inputMultipleSyllables = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.layout =
        decoder.decodeStruct(new codec.Enum(KoreanLayout));
    return val;
  };

  KoreanSettings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(KoreanSettings.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.inputMultipleSyllables & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.layout);
  };
  function LatinSettings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LatinSettings.prototype.initDefaults_ = function() {
    this.autocorrect = false;
    this.predictiveWriting = false;
  };
  LatinSettings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LatinSettings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 5, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  LatinSettings.encodedSize = codec.kStructHeaderSize + 8;

  LatinSettings.decode = function(decoder) {
    var packed;
    var val = new LatinSettings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.autocorrect = (packed >> 0) & 1 ? true : false;
    val.predictiveWriting = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LatinSettings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LatinSettings.encodedSize);
    encoder.writeUint32(5);
    packed = 0;
    packed |= (val.autocorrect & 1) << 0
    packed |= (val.predictiveWriting & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FuzzyPinyinSettings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FuzzyPinyinSettings.prototype.initDefaults_ = function() {
    this.anAng = false;
    this.enEng = false;
    this.ianIang = false;
    this.kG = false;
    this.rL = false;
    this.uanUang = false;
    this.cCh = false;
    this.fH = false;
    this.inIng = false;
    this.lN = false;
    this.sSh = false;
    this.zZh = false;
  };
  FuzzyPinyinSettings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FuzzyPinyinSettings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;













    return validator.validationError.NONE;
  };

  FuzzyPinyinSettings.encodedSize = codec.kStructHeaderSize + 8;

  FuzzyPinyinSettings.decode = function(decoder) {
    var packed;
    var val = new FuzzyPinyinSettings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.anAng = (packed >> 0) & 1 ? true : false;
    val.enEng = (packed >> 1) & 1 ? true : false;
    val.ianIang = (packed >> 2) & 1 ? true : false;
    val.kG = (packed >> 3) & 1 ? true : false;
    val.rL = (packed >> 4) & 1 ? true : false;
    val.uanUang = (packed >> 5) & 1 ? true : false;
    val.cCh = (packed >> 6) & 1 ? true : false;
    val.fH = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.inIng = (packed >> 0) & 1 ? true : false;
    val.lN = (packed >> 1) & 1 ? true : false;
    val.sSh = (packed >> 2) & 1 ? true : false;
    val.zZh = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FuzzyPinyinSettings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FuzzyPinyinSettings.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.anAng & 1) << 0
    packed |= (val.enEng & 1) << 1
    packed |= (val.ianIang & 1) << 2
    packed |= (val.kG & 1) << 3
    packed |= (val.rL & 1) << 4
    packed |= (val.uanUang & 1) << 5
    packed |= (val.cCh & 1) << 6
    packed |= (val.fH & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.inIng & 1) << 0
    packed |= (val.lN & 1) << 1
    packed |= (val.sSh & 1) << 2
    packed |= (val.zZh & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PinyinSettings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PinyinSettings.prototype.initDefaults_ = function() {
    this.fuzzyPinyin = null;
    this.layout = 0;
    this.useHyphenAndEqualsToPageCandidates = false;
    this.useCommaAndPeriodToPageCandidates = false;
    this.defaultToChinese = false;
    this.defaultToFullWidthCharacters = false;
    this.defaultToFullWidthPunctuation = false;
  };
  PinyinSettings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PinyinSettings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8},
      {version: 6, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // version check PinyinSettings.fuzzyPinyin
    if (!messageValidator.isFieldInStructVersion(offset, 6))
      return validator.validationError.NONE;
    // validate PinyinSettings.fuzzyPinyin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, FuzzyPinyinSettings, true);
    if (err !== validator.validationError.NONE)
        return err;



    // version check PinyinSettings.layout
    if (!messageValidator.isFieldInStructVersion(offset, 6))
      return validator.validationError.NONE;
    // validate PinyinSettings.layout
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, PinyinLayout);
    if (err !== validator.validationError.NONE)
        return err;






    return validator.validationError.NONE;
  };

  PinyinSettings.encodedSize = codec.kStructHeaderSize + 16;

  PinyinSettings.decode = function(decoder) {
    var packed;
    var val = new PinyinSettings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    if (version >= 6) {
      val.fuzzyPinyin =
          decoder.decodeStructPointer(FuzzyPinyinSettings);
    } else {
      val.fuzzyPinyin = null;
    }
    if (version >= 6) {
      val.layout =
          decoder.decodeStruct(new codec.Enum(PinyinLayout));
    } else {
      val.layout = null;
    }
    packed = decoder.readUint8();
    val.useHyphenAndEqualsToPageCandidates = (packed >> 0) & 1 ? true : false;
    val.useCommaAndPeriodToPageCandidates = (packed >> 1) & 1 ? true : false;
    val.defaultToChinese = (packed >> 2) & 1 ? true : false;
    val.defaultToFullWidthCharacters = (packed >> 3) & 1 ? true : false;
    val.defaultToFullWidthPunctuation = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PinyinSettings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PinyinSettings.encodedSize);
    encoder.writeUint32(6);
    encoder.encodeStructPointer(FuzzyPinyinSettings, val.fuzzyPinyin);
    encoder.encodeStruct(codec.Int32, val.layout);
    packed = 0;
    packed |= (val.useHyphenAndEqualsToPageCandidates & 1) << 0
    packed |= (val.useCommaAndPeriodToPageCandidates & 1) << 1
    packed |= (val.defaultToChinese & 1) << 2
    packed |= (val.defaultToFullWidthCharacters & 1) << 3
    packed |= (val.defaultToFullWidthPunctuation & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function JapaneseSettings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  JapaneseSettings.InputMode = {};
  JapaneseSettings.InputMode.kUnspecified = 0;
  JapaneseSettings.InputMode.kRomaji = 1;
  JapaneseSettings.InputMode.kKana = 2;
  JapaneseSettings.InputMode.MIN_VALUE = 0;
  JapaneseSettings.InputMode.MAX_VALUE = 2;
  JapaneseSettings.InputMode.DEFAULT_VALUE = 0;

  JapaneseSettings.InputMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  JapaneseSettings.InputMode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  JapaneseSettings.InputMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  JapaneseSettings.PunctuationStyle = {};
  JapaneseSettings.PunctuationStyle.kUnspecified = 0;
  JapaneseSettings.PunctuationStyle.kKutenTouten = 1;
  JapaneseSettings.PunctuationStyle.kCommaPeriod = 2;
  JapaneseSettings.PunctuationStyle.kKutenPeriod = 3;
  JapaneseSettings.PunctuationStyle.kCommaTouten = 4;
  JapaneseSettings.PunctuationStyle.MIN_VALUE = 0;
  JapaneseSettings.PunctuationStyle.MAX_VALUE = 4;
  JapaneseSettings.PunctuationStyle.DEFAULT_VALUE = 0;

  JapaneseSettings.PunctuationStyle.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  JapaneseSettings.PunctuationStyle.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  JapaneseSettings.PunctuationStyle.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  JapaneseSettings.SymbolStyle = {};
  JapaneseSettings.SymbolStyle.kUnspecified = 0;
  JapaneseSettings.SymbolStyle.kCornerBracketMiddleDot = 1;
  JapaneseSettings.SymbolStyle.kSquareBracketSlash = 2;
  JapaneseSettings.SymbolStyle.kCornerBracketSlash = 3;
  JapaneseSettings.SymbolStyle.kSquareBracketMiddleDot = 4;
  JapaneseSettings.SymbolStyle.MIN_VALUE = 0;
  JapaneseSettings.SymbolStyle.MAX_VALUE = 4;
  JapaneseSettings.SymbolStyle.DEFAULT_VALUE = 0;

  JapaneseSettings.SymbolStyle.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  JapaneseSettings.SymbolStyle.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  JapaneseSettings.SymbolStyle.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  JapaneseSettings.SpaceInputStyle = {};
  JapaneseSettings.SpaceInputStyle.kUnspecified = 0;
  JapaneseSettings.SpaceInputStyle.kInputMode = 1;
  JapaneseSettings.SpaceInputStyle.kFullWidth = 2;
  JapaneseSettings.SpaceInputStyle.kHalfWidth = 3;
  JapaneseSettings.SpaceInputStyle.MIN_VALUE = 0;
  JapaneseSettings.SpaceInputStyle.MAX_VALUE = 3;
  JapaneseSettings.SpaceInputStyle.DEFAULT_VALUE = 0;

  JapaneseSettings.SpaceInputStyle.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  JapaneseSettings.SpaceInputStyle.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  JapaneseSettings.SpaceInputStyle.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  JapaneseSettings.SelectionShortcut = {};
  JapaneseSettings.SelectionShortcut.kUnspecified = 0;
  JapaneseSettings.SelectionShortcut.kDigits123456789 = 1;
  JapaneseSettings.SelectionShortcut.kAsdfghjkl = 2;
  JapaneseSettings.SelectionShortcut.kNoShortcut = 3;
  JapaneseSettings.SelectionShortcut.MIN_VALUE = 0;
  JapaneseSettings.SelectionShortcut.MAX_VALUE = 3;
  JapaneseSettings.SelectionShortcut.DEFAULT_VALUE = 0;

  JapaneseSettings.SelectionShortcut.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  JapaneseSettings.SelectionShortcut.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  JapaneseSettings.SelectionShortcut.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  JapaneseSettings.KeymapStyle = {};
  JapaneseSettings.KeymapStyle.kUnspecified = 0;
  JapaneseSettings.KeymapStyle.kCustom = 1;
  JapaneseSettings.KeymapStyle.kAtok = 2;
  JapaneseSettings.KeymapStyle.kMsime = 3;
  JapaneseSettings.KeymapStyle.kKotoeri = 4;
  JapaneseSettings.KeymapStyle.kMobile = 5;
  JapaneseSettings.KeymapStyle.kChromeos = 6;
  JapaneseSettings.KeymapStyle.MIN_VALUE = 0;
  JapaneseSettings.KeymapStyle.MAX_VALUE = 6;
  JapaneseSettings.KeymapStyle.DEFAULT_VALUE = 0;

  JapaneseSettings.KeymapStyle.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  JapaneseSettings.KeymapStyle.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  JapaneseSettings.KeymapStyle.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  JapaneseSettings.ShiftKeyModeStyle = {};
  JapaneseSettings.ShiftKeyModeStyle.kUnspecified = 0;
  JapaneseSettings.ShiftKeyModeStyle.kOff = 1;
  JapaneseSettings.ShiftKeyModeStyle.kAlphanumeric = 2;
  JapaneseSettings.ShiftKeyModeStyle.kKatakana = 3;
  JapaneseSettings.ShiftKeyModeStyle.MIN_VALUE = 0;
  JapaneseSettings.ShiftKeyModeStyle.MAX_VALUE = 3;
  JapaneseSettings.ShiftKeyModeStyle.DEFAULT_VALUE = 0;

  JapaneseSettings.ShiftKeyModeStyle.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  JapaneseSettings.ShiftKeyModeStyle.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  JapaneseSettings.ShiftKeyModeStyle.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  JapaneseSettings.prototype.initDefaults_ = function() {
    this.unused = null;
    this.inputMode = 0;
    this.punctuationStyle = 0;
    this.symbolStyle = 0;
    this.spaceInputStyle = 0;
    this.selectionShortcut = 0;
    this.keymapStyle = 0;
    this.automaticallySwitchToHalfwidth = false;
    this.useInputHistory = false;
    this.useSystemDictionary = false;
    this.disablePersonalizedSuggestions = false;
    this.unused2 = false;
    this.shiftKeyModeStyle = 0;
    this.numberOfSuggestions = 0;
  };
  JapaneseSettings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  JapaneseSettings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 22, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate JapaneseSettings.unused
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, japanese_settings$.JpUnusedStruct, true);
    if (err !== validator.validationError.NONE)
        return err;



    // version check JapaneseSettings.inputMode
    if (!messageValidator.isFieldInStructVersion(offset, 22))
      return validator.validationError.NONE;
    // validate JapaneseSettings.inputMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, JapaneseSettings.InputMode);
    if (err !== validator.validationError.NONE)
        return err;



    // version check JapaneseSettings.punctuationStyle
    if (!messageValidator.isFieldInStructVersion(offset, 22))
      return validator.validationError.NONE;
    // validate JapaneseSettings.punctuationStyle
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, JapaneseSettings.PunctuationStyle);
    if (err !== validator.validationError.NONE)
        return err;



    // version check JapaneseSettings.symbolStyle
    if (!messageValidator.isFieldInStructVersion(offset, 22))
      return validator.validationError.NONE;
    // validate JapaneseSettings.symbolStyle
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, JapaneseSettings.SymbolStyle);
    if (err !== validator.validationError.NONE)
        return err;



    // version check JapaneseSettings.spaceInputStyle
    if (!messageValidator.isFieldInStructVersion(offset, 22))
      return validator.validationError.NONE;
    // validate JapaneseSettings.spaceInputStyle
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, JapaneseSettings.SpaceInputStyle);
    if (err !== validator.validationError.NONE)
        return err;



    // version check JapaneseSettings.selectionShortcut
    if (!messageValidator.isFieldInStructVersion(offset, 22))
      return validator.validationError.NONE;
    // validate JapaneseSettings.selectionShortcut
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, JapaneseSettings.SelectionShortcut);
    if (err !== validator.validationError.NONE)
        return err;



    // version check JapaneseSettings.keymapStyle
    if (!messageValidator.isFieldInStructVersion(offset, 22))
      return validator.validationError.NONE;
    // validate JapaneseSettings.keymapStyle
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 28, JapaneseSettings.KeymapStyle);
    if (err !== validator.validationError.NONE)
        return err;




    // version check JapaneseSettings.shiftKeyModeStyle
    if (!messageValidator.isFieldInStructVersion(offset, 22))
      return validator.validationError.NONE;
    // validate JapaneseSettings.shiftKeyModeStyle
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, JapaneseSettings.ShiftKeyModeStyle);
    if (err !== validator.validationError.NONE)
        return err;






    return validator.validationError.NONE;
  };

  JapaneseSettings.encodedSize = codec.kStructHeaderSize + 48;

  JapaneseSettings.decode = function(decoder) {
    var packed;
    var val = new JapaneseSettings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.unused =
        decoder.decodeStructPointer(japanese_settings$.JpUnusedStruct);
    if (version >= 22) {
      val.inputMode =
          decoder.decodeStruct(new codec.Enum(JapaneseSettings.InputMode));
    } else {
      val.inputMode = null;
    }
    if (version >= 22) {
      val.punctuationStyle =
          decoder.decodeStruct(new codec.Enum(JapaneseSettings.PunctuationStyle));
    } else {
      val.punctuationStyle = null;
    }
    if (version >= 22) {
      val.symbolStyle =
          decoder.decodeStruct(new codec.Enum(JapaneseSettings.SymbolStyle));
    } else {
      val.symbolStyle = null;
    }
    if (version >= 22) {
      val.spaceInputStyle =
          decoder.decodeStruct(new codec.Enum(JapaneseSettings.SpaceInputStyle));
    } else {
      val.spaceInputStyle = null;
    }
    if (version >= 22) {
      val.selectionShortcut =
          decoder.decodeStruct(new codec.Enum(JapaneseSettings.SelectionShortcut));
    } else {
      val.selectionShortcut = null;
    }
    if (version >= 22) {
      val.keymapStyle =
          decoder.decodeStruct(new codec.Enum(JapaneseSettings.KeymapStyle));
    } else {
      val.keymapStyle = null;
    }
    packed = decoder.readUint8();
    val.automaticallySwitchToHalfwidth = (packed >> 0) & 1 ? true : false;
    val.useInputHistory = (packed >> 1) & 1 ? true : false;
    val.useSystemDictionary = (packed >> 2) & 1 ? true : false;
    val.disablePersonalizedSuggestions = (packed >> 3) & 1 ? true : false;
    val.unused2 = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 22) {
      val.shiftKeyModeStyle =
          decoder.decodeStruct(new codec.Enum(JapaneseSettings.ShiftKeyModeStyle));
    } else {
      val.shiftKeyModeStyle = null;
    }
    if (version >= 22) {
      val.numberOfSuggestions =
          decoder.decodeStruct(codec.Uint32);
    } else {
      val.numberOfSuggestions = null;
    }
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  JapaneseSettings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(JapaneseSettings.encodedSize);
    encoder.writeUint32(22);
    encoder.encodeStructPointer(japanese_settings$.JpUnusedStruct, val.unused);
    encoder.encodeStruct(codec.Int32, val.inputMode);
    encoder.encodeStruct(codec.Int32, val.punctuationStyle);
    encoder.encodeStruct(codec.Int32, val.symbolStyle);
    encoder.encodeStruct(codec.Int32, val.spaceInputStyle);
    encoder.encodeStruct(codec.Int32, val.selectionShortcut);
    encoder.encodeStruct(codec.Int32, val.keymapStyle);
    packed = 0;
    packed |= (val.automaticallySwitchToHalfwidth & 1) << 0
    packed |= (val.useInputHistory & 1) << 1
    packed |= (val.useSystemDictionary & 1) << 2
    packed |= (val.disablePersonalizedSuggestions & 1) << 3
    packed |= (val.unused2 & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.shiftKeyModeStyle);
    encoder.encodeStruct(codec.Uint32, val.numberOfSuggestions);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ZhuyinSettings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ZhuyinSettings.prototype.initDefaults_ = function() {
    this.layout = 0;
    this.selectionKeys = 0;
    this.pageSize = 0;
  };
  ZhuyinSettings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ZhuyinSettings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8},
      {version: 7, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // version check ZhuyinSettings.layout
    if (!messageValidator.isFieldInStructVersion(offset, 7))
      return validator.validationError.NONE;
    // validate ZhuyinSettings.layout
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ZhuyinLayout);
    if (err !== validator.validationError.NONE)
        return err;



    // version check ZhuyinSettings.selectionKeys
    if (!messageValidator.isFieldInStructVersion(offset, 7))
      return validator.validationError.NONE;
    // validate ZhuyinSettings.selectionKeys
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, ZhuyinSelectionKeys);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ZhuyinSettings.encodedSize = codec.kStructHeaderSize + 16;

  ZhuyinSettings.decode = function(decoder) {
    var packed;
    var val = new ZhuyinSettings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    if (version >= 7) {
      val.layout =
          decoder.decodeStruct(new codec.Enum(ZhuyinLayout));
    } else {
      val.layout = null;
    }
    if (version >= 7) {
      val.selectionKeys =
          decoder.decodeStruct(new codec.Enum(ZhuyinSelectionKeys));
    } else {
      val.selectionKeys = null;
    }
    if (version >= 7) {
      val.pageSize =
          decoder.decodeStruct(codec.Uint32);
    } else {
      val.pageSize = null;
    }
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ZhuyinSettings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ZhuyinSettings.encodedSize);
    encoder.writeUint32(7);
    encoder.encodeStruct(codec.Int32, val.layout);
    encoder.encodeStruct(codec.Int32, val.selectionKeys);
    encoder.encodeStruct(codec.Uint32, val.pageSize);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ChineseQuickSettings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ChineseQuickSettings.prototype.initDefaults_ = function() {
    this.mode = 0;
    this.fullWidthCharacters = false;
    this.fullWidthPunctuation = false;
  };
  ChineseQuickSettings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ChineseQuickSettings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ChineseQuickSettings.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ChineseLanguageMode);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ChineseQuickSettings.encodedSize = codec.kStructHeaderSize + 8;

  ChineseQuickSettings.decode = function(decoder) {
    var packed;
    var val = new ChineseQuickSettings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(ChineseLanguageMode));
    packed = decoder.readUint8();
    val.fullWidthCharacters = (packed >> 0) & 1 ? true : false;
    val.fullWidthPunctuation = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ChineseQuickSettings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ChineseQuickSettings.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    packed = 0;
    packed |= (val.fullWidthCharacters & 1) << 0
    packed |= (val.fullWidthPunctuation & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function JapaneseQuickSettings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  JapaneseQuickSettings.prototype.initDefaults_ = function() {
    this.mode = 0;
  };
  JapaneseQuickSettings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  JapaneseQuickSettings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate JapaneseQuickSettings.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, JapaneseInputMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  JapaneseQuickSettings.encodedSize = codec.kStructHeaderSize + 8;

  JapaneseQuickSettings.decode = function(decoder) {
    var packed;
    var val = new JapaneseQuickSettings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(JapaneseInputMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  JapaneseQuickSettings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(JapaneseQuickSettings.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SuggestionCandidate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SuggestionCandidate.prototype.initDefaults_ = function() {
    this.mode = 0;
    this.type = 0;
    this.text = null;
    this.confirmedLength = 0;
  };
  SuggestionCandidate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SuggestionCandidate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 13, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SuggestionCandidate.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SuggestionMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SuggestionCandidate.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, SuggestionType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SuggestionCandidate.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SuggestionCandidate.encodedSize = codec.kStructHeaderSize + 24;

  SuggestionCandidate.decode = function(decoder) {
    var packed;
    var val = new SuggestionCandidate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(SuggestionMode));
    val.type =
        decoder.decodeStruct(new codec.Enum(SuggestionType));
    val.text =
        decoder.decodeStruct(codec.String);
    if (version >= 13) {
      val.confirmedLength =
          decoder.decodeStruct(codec.Int32);
    } else {
      val.confirmedLength = null;
    }
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SuggestionCandidate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SuggestionCandidate.encodedSize);
    encoder.writeUint32(13);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStruct(codec.Int32, val.confirmedLength);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function InputMethodMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodMetadata.prototype.initDefaults_ = function() {
    this.autocorrectSuggestionProvider = 0;
  };
  InputMethodMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodMetadata.autocorrectSuggestionProvider
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AutocorrectSuggestionProvider);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodMetadata.encodedSize = codec.kStructHeaderSize + 8;

  InputMethodMetadata.decode = function(decoder) {
    var packed;
    var val = new InputMethodMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.autocorrectSuggestionProvider =
        decoder.decodeStruct(new codec.Enum(AutocorrectSuggestionProvider));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InputMethodMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.autocorrectSuggestionProvider);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AssistiveWindow(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AssistiveWindow.prototype.initDefaults_ = function() {
    this.type = 0;
    this.candidates = null;
  };
  AssistiveWindow.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AssistiveWindow.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AssistiveWindow.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AssistiveWindowType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AssistiveWindow.candidates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(SuggestionCandidate), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AssistiveWindow.encodedSize = codec.kStructHeaderSize + 16;

  AssistiveWindow.decode = function(decoder) {
    var packed;
    var val = new AssistiveWindow();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(AssistiveWindowType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.candidates =
        decoder.decodeArrayPointer(new codec.PointerTo(SuggestionCandidate));
    return val;
  };

  AssistiveWindow.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AssistiveWindow.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(SuggestionCandidate), val.candidates);
  };
  function VietnameseTelexSettings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VietnameseTelexSettings.prototype.initDefaults_ = function() {
    this.allowFlexibleDiacritics = false;
    this.newStyleToneMarkPlacement = false;
    this.enableInsertDoubleHornOnUo = false;
    this.enableWForUHornShortcut = false;
    this.showUnderlineForCompositionText = false;
  };
  VietnameseTelexSettings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VietnameseTelexSettings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 20, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    return validator.validationError.NONE;
  };

  VietnameseTelexSettings.encodedSize = codec.kStructHeaderSize + 8;

  VietnameseTelexSettings.decode = function(decoder) {
    var packed;
    var val = new VietnameseTelexSettings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.allowFlexibleDiacritics = (packed >> 0) & 1 ? true : false;
    val.newStyleToneMarkPlacement = (packed >> 1) & 1 ? true : false;
    val.enableInsertDoubleHornOnUo = (packed >> 2) & 1 ? true : false;
    val.enableWForUHornShortcut = (packed >> 3) & 1 ? true : false;
    val.showUnderlineForCompositionText = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VietnameseTelexSettings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VietnameseTelexSettings.encodedSize);
    encoder.writeUint32(20);
    packed = 0;
    packed |= (val.allowFlexibleDiacritics & 1) << 0
    packed |= (val.newStyleToneMarkPlacement & 1) << 1
    packed |= (val.enableInsertDoubleHornOnUo & 1) << 2
    packed |= (val.enableWForUHornShortcut & 1) << 3
    packed |= (val.showUnderlineForCompositionText & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function VietnameseVniSettings(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VietnameseVniSettings.prototype.initDefaults_ = function() {
    this.allowFlexibleDiacritics = false;
    this.newStyleToneMarkPlacement = false;
    this.enableInsertDoubleHornOnUo = false;
    this.showUnderlineForCompositionText = false;
  };
  VietnameseVniSettings.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VietnameseVniSettings.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 20, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  VietnameseVniSettings.encodedSize = codec.kStructHeaderSize + 8;

  VietnameseVniSettings.decode = function(decoder) {
    var packed;
    var val = new VietnameseVniSettings();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.allowFlexibleDiacritics = (packed >> 0) & 1 ? true : false;
    val.newStyleToneMarkPlacement = (packed >> 1) & 1 ? true : false;
    val.enableInsertDoubleHornOnUo = (packed >> 2) & 1 ? true : false;
    val.showUnderlineForCompositionText = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VietnameseVniSettings.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VietnameseVniSettings.encodedSize);
    encoder.writeUint32(20);
    packed = 0;
    packed |= (val.allowFlexibleDiacritics & 1) << 0
    packed |= (val.newStyleToneMarkPlacement & 1) << 1
    packed |= (val.enableInsertDoubleHornOnUo & 1) << 2
    packed |= (val.showUnderlineForCompositionText & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function InputMethod_OnFocusDeprecated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethod_OnFocusDeprecated_Params.prototype.initDefaults_ = function() {
    this.inputFieldInfo = null;
    this.settings = null;
  };
  InputMethod_OnFocusDeprecated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethod_OnFocusDeprecated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 4, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethod_OnFocusDeprecated_Params.inputFieldInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, InputFieldInfo, false);
    if (err !== validator.validationError.NONE)
        return err;



    // version check InputMethod_OnFocusDeprecated_Params.settings
    if (!messageValidator.isFieldInStructVersion(offset, 4))
      return validator.validationError.NONE;
    // validate InputMethod_OnFocusDeprecated_Params.settings
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, InputMethodSettings, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethod_OnFocusDeprecated_Params.encodedSize = codec.kStructHeaderSize + 24;

  InputMethod_OnFocusDeprecated_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethod_OnFocusDeprecated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.inputFieldInfo =
        decoder.decodeStructPointer(InputFieldInfo);
    if (version >= 4) {
      val.settings =
          decoder.decodeStruct(InputMethodSettings);
    } else {
      val.settings = null;
    }
    return val;
  };

  InputMethod_OnFocusDeprecated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethod_OnFocusDeprecated_Params.encodedSize);
    encoder.writeUint32(4);
    encoder.encodeStructPointer(InputFieldInfo, val.inputFieldInfo);
    encoder.encodeStruct(InputMethodSettings, val.settings);
  };
  function InputMethod_OnFocus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethod_OnFocus_Params.prototype.initDefaults_ = function() {
    this.inputFieldInfo = null;
    this.deprecatedSettings = null;
  };
  InputMethod_OnFocus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethod_OnFocus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethod_OnFocus_Params.inputFieldInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, InputFieldInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethod_OnFocus_Params.deprecatedSettings
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, InputMethodSettings, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethod_OnFocus_Params.encodedSize = codec.kStructHeaderSize + 24;

  InputMethod_OnFocus_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethod_OnFocus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.inputFieldInfo =
        decoder.decodeStructPointer(InputFieldInfo);
    val.deprecatedSettings =
        decoder.decodeStruct(InputMethodSettings);
    return val;
  };

  InputMethod_OnFocus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethod_OnFocus_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(InputFieldInfo, val.inputFieldInfo);
    encoder.encodeStruct(InputMethodSettings, val.deprecatedSettings);
  };
  function InputMethod_OnFocus_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethod_OnFocus_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
    this.metadata = null;
  };
  InputMethod_OnFocus_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethod_OnFocus_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 17, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // version check InputMethod_OnFocus_ResponseParams.metadata
    if (!messageValidator.isFieldInStructVersion(offset, 17))
      return validator.validationError.NONE;
    // validate InputMethod_OnFocus_ResponseParams.metadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, InputMethodMetadata, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethod_OnFocus_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  InputMethod_OnFocus_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new InputMethod_OnFocus_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 17) {
      val.metadata =
          decoder.decodeStructPointer(InputMethodMetadata);
    } else {
      val.metadata = null;
    }
    return val;
  };

  InputMethod_OnFocus_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethod_OnFocus_ResponseParams.encodedSize);
    encoder.writeUint32(17);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(InputMethodMetadata, val.metadata);
  };
  function InputMethod_OnBlur_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethod_OnBlur_Params.prototype.initDefaults_ = function() {
  };
  InputMethod_OnBlur_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethod_OnBlur_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethod_OnBlur_Params.encodedSize = codec.kStructHeaderSize + 0;

  InputMethod_OnBlur_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethod_OnBlur_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  InputMethod_OnBlur_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethod_OnBlur_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function InputMethod_ProcessKeyEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethod_ProcessKeyEvent_Params.prototype.initDefaults_ = function() {
    this.event = null;
  };
  InputMethod_ProcessKeyEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethod_ProcessKeyEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethod_ProcessKeyEvent_Params.event
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PhysicalKeyEvent, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethod_ProcessKeyEvent_Params.encodedSize = codec.kStructHeaderSize + 8;

  InputMethod_ProcessKeyEvent_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethod_ProcessKeyEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.event =
        decoder.decodeStructPointer(PhysicalKeyEvent);
    return val;
  };

  InputMethod_ProcessKeyEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethod_ProcessKeyEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PhysicalKeyEvent, val.event);
  };
  function InputMethod_ProcessKeyEvent_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethod_ProcessKeyEvent_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  InputMethod_ProcessKeyEvent_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethod_ProcessKeyEvent_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethod_ProcessKeyEvent_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, KeyEventResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethod_ProcessKeyEvent_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  InputMethod_ProcessKeyEvent_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new InputMethod_ProcessKeyEvent_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(KeyEventResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InputMethod_ProcessKeyEvent_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethod_ProcessKeyEvent_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function InputMethod_OnSurroundingTextChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethod_OnSurroundingTextChanged_Params.prototype.initDefaults_ = function() {
    this.text = null;
    this.offset = 0;
    this.selectionRange = null;
  };
  InputMethod_OnSurroundingTextChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethod_OnSurroundingTextChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethod_OnSurroundingTextChanged_Params.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate InputMethod_OnSurroundingTextChanged_Params.selectionRange
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, SelectionRange, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethod_OnSurroundingTextChanged_Params.encodedSize = codec.kStructHeaderSize + 24;

  InputMethod_OnSurroundingTextChanged_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethod_OnSurroundingTextChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.offset =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.selectionRange =
        decoder.decodeStructPointer(SelectionRange);
    return val;
  };

  InputMethod_OnSurroundingTextChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethod_OnSurroundingTextChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStruct(codec.Uint32, val.offset);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(SelectionRange, val.selectionRange);
  };
  function InputMethod_OnCompositionCanceledBySystem_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethod_OnCompositionCanceledBySystem_Params.prototype.initDefaults_ = function() {
  };
  InputMethod_OnCompositionCanceledBySystem_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethod_OnCompositionCanceledBySystem_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethod_OnCompositionCanceledBySystem_Params.encodedSize = codec.kStructHeaderSize + 0;

  InputMethod_OnCompositionCanceledBySystem_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethod_OnCompositionCanceledBySystem_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  InputMethod_OnCompositionCanceledBySystem_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethod_OnCompositionCanceledBySystem_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function InputMethod_OnCandidateSelected_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethod_OnCandidateSelected_Params.prototype.initDefaults_ = function() {
    this.selectedCandidateIndex = 0;
  };
  InputMethod_OnCandidateSelected_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethod_OnCandidateSelected_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  InputMethod_OnCandidateSelected_Params.encodedSize = codec.kStructHeaderSize + 8;

  InputMethod_OnCandidateSelected_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethod_OnCandidateSelected_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.selectedCandidateIndex =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InputMethod_OnCandidateSelected_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethod_OnCandidateSelected_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.selectedCandidateIndex);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function InputMethod_OnQuickSettingsUpdated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethod_OnQuickSettingsUpdated_Params.prototype.initDefaults_ = function() {
    this.settings = null;
  };
  InputMethod_OnQuickSettingsUpdated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethod_OnQuickSettingsUpdated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethod_OnQuickSettingsUpdated_Params.settings
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, InputMethodQuickSettings, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethod_OnQuickSettingsUpdated_Params.encodedSize = codec.kStructHeaderSize + 16;

  InputMethod_OnQuickSettingsUpdated_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethod_OnQuickSettingsUpdated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.settings =
        decoder.decodeStruct(InputMethodQuickSettings);
    return val;
  };

  InputMethod_OnQuickSettingsUpdated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethod_OnQuickSettingsUpdated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(InputMethodQuickSettings, val.settings);
  };
  function InputMethod_IsReadyForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethod_IsReadyForTesting_Params.prototype.initDefaults_ = function() {
  };
  InputMethod_IsReadyForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethod_IsReadyForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethod_IsReadyForTesting_Params.encodedSize = codec.kStructHeaderSize + 0;

  InputMethod_IsReadyForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethod_IsReadyForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  InputMethod_IsReadyForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethod_IsReadyForTesting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function InputMethod_IsReadyForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethod_IsReadyForTesting_ResponseParams.prototype.initDefaults_ = function() {
    this.ready = false;
  };
  InputMethod_IsReadyForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethod_IsReadyForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  InputMethod_IsReadyForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  InputMethod_IsReadyForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new InputMethod_IsReadyForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.ready = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InputMethod_IsReadyForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethod_IsReadyForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.ready & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function InputMethod_OnAssistiveWindowChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethod_OnAssistiveWindowChanged_Params.prototype.initDefaults_ = function() {
    this.window = null;
  };
  InputMethod_OnAssistiveWindowChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethod_OnAssistiveWindowChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethod_OnAssistiveWindowChanged_Params.window
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AssistiveWindow, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethod_OnAssistiveWindowChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  InputMethod_OnAssistiveWindowChanged_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethod_OnAssistiveWindowChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.window =
        decoder.decodeStructPointer(AssistiveWindow);
    return val;
  };

  InputMethod_OnAssistiveWindowChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethod_OnAssistiveWindowChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AssistiveWindow, val.window);
  };

  function DomKey(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  DomKey.Tags = {
    namedKey: 0,
    codepoint: 1,
  };

  DomKey.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  DomKey.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "namedKey",
        "codepoint",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a DomKey member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(DomKey.prototype, "namedKey", {
    get: function() {
      if (this.$tag != DomKey.Tags.namedKey) {
        throw new ReferenceError(
            "DomKey.namedKey is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DomKey.Tags.namedKey;
      this.$data = value;
    }
  });
  Object.defineProperty(DomKey.prototype, "codepoint", {
    get: function() {
      if (this.$tag != DomKey.Tags.codepoint) {
        throw new ReferenceError(
            "DomKey.codepoint is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = DomKey.Tags.codepoint;
      this.$data = value;
    }
  });


    DomKey.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case DomKey.Tags.namedKey:
          encoder.encodeStruct(codec.Int32, val.namedKey);
          break;
        case DomKey.Tags.codepoint:
          encoder.encodeStruct(codec.Uint32, val.codepoint);
          break;
      }
      encoder.align();
    };


    DomKey.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new DomKey();
      var tag = decoder.readUint32();
      switch (tag) {
        case DomKey.Tags.namedKey:
          result.namedKey = decoder.decodeStruct(new codec.Enum(NamedDomKey));
          break;
        case DomKey.Tags.codepoint:
          result.codepoint = decoder.decodeStruct(codec.Uint32);
          break;
      }
      decoder.align();

      return result;
    };


    DomKey.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case DomKey.Tags.namedKey:
          

    // validate DomKey.namedKey
    err = messageValidator.validateEnum(data_offset, NamedDomKey);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case DomKey.Tags.codepoint:
          

          break;
      }

      return validator.validationError.NONE;
    };

  DomKey.encodedSize = 16;

  function InputMethodSettings(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  InputMethodSettings.Tags = {
    koreanSettings: 0,
    latinSettings: 1,
    pinyinSettings: 2,
    zhuyinSettings: 3,
    nullSettings: 4,
    japaneseSettings: 5,
    vietnameseTelexSettings: 6,
    vietnameseVniSettings: 7,
  };

  InputMethodSettings.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  InputMethodSettings.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "koreanSettings",
        "latinSettings",
        "pinyinSettings",
        "zhuyinSettings",
        "nullSettings",
        "japaneseSettings",
        "vietnameseTelexSettings",
        "vietnameseVniSettings",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a InputMethodSettings member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(InputMethodSettings.prototype, "koreanSettings", {
    get: function() {
      if (this.$tag != InputMethodSettings.Tags.koreanSettings) {
        throw new ReferenceError(
            "InputMethodSettings.koreanSettings is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputMethodSettings.Tags.koreanSettings;
      this.$data = value;
    }
  });
  Object.defineProperty(InputMethodSettings.prototype, "latinSettings", {
    get: function() {
      if (this.$tag != InputMethodSettings.Tags.latinSettings) {
        throw new ReferenceError(
            "InputMethodSettings.latinSettings is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputMethodSettings.Tags.latinSettings;
      this.$data = value;
    }
  });
  Object.defineProperty(InputMethodSettings.prototype, "pinyinSettings", {
    get: function() {
      if (this.$tag != InputMethodSettings.Tags.pinyinSettings) {
        throw new ReferenceError(
            "InputMethodSettings.pinyinSettings is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputMethodSettings.Tags.pinyinSettings;
      this.$data = value;
    }
  });
  Object.defineProperty(InputMethodSettings.prototype, "zhuyinSettings", {
    get: function() {
      if (this.$tag != InputMethodSettings.Tags.zhuyinSettings) {
        throw new ReferenceError(
            "InputMethodSettings.zhuyinSettings is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputMethodSettings.Tags.zhuyinSettings;
      this.$data = value;
    }
  });
  Object.defineProperty(InputMethodSettings.prototype, "nullSettings", {
    get: function() {
      if (this.$tag != InputMethodSettings.Tags.nullSettings) {
        throw new ReferenceError(
            "InputMethodSettings.nullSettings is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputMethodSettings.Tags.nullSettings;
      this.$data = value;
    }
  });
  Object.defineProperty(InputMethodSettings.prototype, "japaneseSettings", {
    get: function() {
      if (this.$tag != InputMethodSettings.Tags.japaneseSettings) {
        throw new ReferenceError(
            "InputMethodSettings.japaneseSettings is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputMethodSettings.Tags.japaneseSettings;
      this.$data = value;
    }
  });
  Object.defineProperty(InputMethodSettings.prototype, "vietnameseTelexSettings", {
    get: function() {
      if (this.$tag != InputMethodSettings.Tags.vietnameseTelexSettings) {
        throw new ReferenceError(
            "InputMethodSettings.vietnameseTelexSettings is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputMethodSettings.Tags.vietnameseTelexSettings;
      this.$data = value;
    }
  });
  Object.defineProperty(InputMethodSettings.prototype, "vietnameseVniSettings", {
    get: function() {
      if (this.$tag != InputMethodSettings.Tags.vietnameseVniSettings) {
        throw new ReferenceError(
            "InputMethodSettings.vietnameseVniSettings is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputMethodSettings.Tags.vietnameseVniSettings;
      this.$data = value;
    }
  });


    InputMethodSettings.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case InputMethodSettings.Tags.koreanSettings:
          encoder.encodeStructPointer(KoreanSettings, val.koreanSettings);
          break;
        case InputMethodSettings.Tags.latinSettings:
          encoder.encodeStructPointer(LatinSettings, val.latinSettings);
          break;
        case InputMethodSettings.Tags.pinyinSettings:
          encoder.encodeStructPointer(PinyinSettings, val.pinyinSettings);
          break;
        case InputMethodSettings.Tags.zhuyinSettings:
          encoder.encodeStructPointer(ZhuyinSettings, val.zhuyinSettings);
          break;
        case InputMethodSettings.Tags.nullSettings:
          encoder.writeUint8(val.nullSettings ? 1 : 0);
          break;
        case InputMethodSettings.Tags.japaneseSettings:
          encoder.encodeStructPointer(JapaneseSettings, val.japaneseSettings);
          break;
        case InputMethodSettings.Tags.vietnameseTelexSettings:
          encoder.encodeStructPointer(VietnameseTelexSettings, val.vietnameseTelexSettings);
          break;
        case InputMethodSettings.Tags.vietnameseVniSettings:
          encoder.encodeStructPointer(VietnameseVniSettings, val.vietnameseVniSettings);
          break;
      }
      encoder.align();
    };


    InputMethodSettings.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new InputMethodSettings();
      var tag = decoder.readUint32();
      switch (tag) {
        case InputMethodSettings.Tags.koreanSettings:
          result.koreanSettings = decoder.decodeStructPointer(KoreanSettings);
          break;
        case InputMethodSettings.Tags.latinSettings:
          result.latinSettings = decoder.decodeStructPointer(LatinSettings);
          break;
        case InputMethodSettings.Tags.pinyinSettings:
          result.pinyinSettings = decoder.decodeStructPointer(PinyinSettings);
          break;
        case InputMethodSettings.Tags.zhuyinSettings:
          result.zhuyinSettings = decoder.decodeStructPointer(ZhuyinSettings);
          break;
        case InputMethodSettings.Tags.nullSettings:
          result.nullSettings = decoder.readUint8() ? true : false;
          break;
        case InputMethodSettings.Tags.japaneseSettings:
          result.japaneseSettings = decoder.decodeStructPointer(JapaneseSettings);
          break;
        case InputMethodSettings.Tags.vietnameseTelexSettings:
          result.vietnameseTelexSettings = decoder.decodeStructPointer(VietnameseTelexSettings);
          break;
        case InputMethodSettings.Tags.vietnameseVniSettings:
          result.vietnameseVniSettings = decoder.decodeStructPointer(VietnameseVniSettings);
          break;
      }
      decoder.align();

      return result;
    };


    InputMethodSettings.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case InputMethodSettings.Tags.koreanSettings:
          

    // validate InputMethodSettings.koreanSettings
    err = messageValidator.validateStructPointer(data_offset, KoreanSettings, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case InputMethodSettings.Tags.latinSettings:
          

    // validate InputMethodSettings.latinSettings
    err = messageValidator.validateStructPointer(data_offset, LatinSettings, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case InputMethodSettings.Tags.pinyinSettings:
          

    // validate InputMethodSettings.pinyinSettings
    err = messageValidator.validateStructPointer(data_offset, PinyinSettings, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case InputMethodSettings.Tags.zhuyinSettings:
          

    // validate InputMethodSettings.zhuyinSettings
    err = messageValidator.validateStructPointer(data_offset, ZhuyinSettings, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case InputMethodSettings.Tags.nullSettings:
          

          break;
        case InputMethodSettings.Tags.japaneseSettings:
          

    // validate InputMethodSettings.japaneseSettings
    err = messageValidator.validateStructPointer(data_offset, JapaneseSettings, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case InputMethodSettings.Tags.vietnameseTelexSettings:
          

    // validate InputMethodSettings.vietnameseTelexSettings
    err = messageValidator.validateStructPointer(data_offset, VietnameseTelexSettings, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case InputMethodSettings.Tags.vietnameseVniSettings:
          

    // validate InputMethodSettings.vietnameseVniSettings
    err = messageValidator.validateStructPointer(data_offset, VietnameseVniSettings, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  InputMethodSettings.encodedSize = 16;

  function InputMethodQuickSettings(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  InputMethodQuickSettings.Tags = {
    chineseSettings: 0,
    japaneseSettings: 1,
  };

  InputMethodQuickSettings.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  InputMethodQuickSettings.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "chineseSettings",
        "japaneseSettings",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a InputMethodQuickSettings member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(InputMethodQuickSettings.prototype, "chineseSettings", {
    get: function() {
      if (this.$tag != InputMethodQuickSettings.Tags.chineseSettings) {
        throw new ReferenceError(
            "InputMethodQuickSettings.chineseSettings is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputMethodQuickSettings.Tags.chineseSettings;
      this.$data = value;
    }
  });
  Object.defineProperty(InputMethodQuickSettings.prototype, "japaneseSettings", {
    get: function() {
      if (this.$tag != InputMethodQuickSettings.Tags.japaneseSettings) {
        throw new ReferenceError(
            "InputMethodQuickSettings.japaneseSettings is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = InputMethodQuickSettings.Tags.japaneseSettings;
      this.$data = value;
    }
  });


    InputMethodQuickSettings.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case InputMethodQuickSettings.Tags.chineseSettings:
          encoder.encodeStructPointer(ChineseQuickSettings, val.chineseSettings);
          break;
        case InputMethodQuickSettings.Tags.japaneseSettings:
          encoder.encodeStructPointer(JapaneseQuickSettings, val.japaneseSettings);
          break;
      }
      encoder.align();
    };


    InputMethodQuickSettings.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new InputMethodQuickSettings();
      var tag = decoder.readUint32();
      switch (tag) {
        case InputMethodQuickSettings.Tags.chineseSettings:
          result.chineseSettings = decoder.decodeStructPointer(ChineseQuickSettings);
          break;
        case InputMethodQuickSettings.Tags.japaneseSettings:
          result.japaneseSettings = decoder.decodeStructPointer(JapaneseQuickSettings);
          break;
      }
      decoder.align();

      return result;
    };


    InputMethodQuickSettings.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case InputMethodQuickSettings.Tags.chineseSettings:
          

    // validate InputMethodQuickSettings.chineseSettings
    err = messageValidator.validateStructPointer(data_offset, ChineseQuickSettings, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case InputMethodQuickSettings.Tags.japaneseSettings:
          

    // validate InputMethodQuickSettings.japaneseSettings
    err = messageValidator.validateStructPointer(data_offset, JapaneseQuickSettings, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  InputMethodQuickSettings.encodedSize = 16;
  var kInputMethod_OnFocusDeprecated_Name = 0;
  var kInputMethod_OnFocus_Name = 6;
  var kInputMethod_OnBlur_Name = 1;
  var kInputMethod_ProcessKeyEvent_Name = 2;
  var kInputMethod_OnSurroundingTextChanged_Name = 3;
  var kInputMethod_OnCompositionCanceledBySystem_Name = 4;
  var kInputMethod_OnCandidateSelected_Name = 5;
  var kInputMethod_OnQuickSettingsUpdated_Name = 7;
  var kInputMethod_IsReadyForTesting_Name = 8;
  var kInputMethod_OnAssistiveWindowChanged_Name = 9;

  function InputMethodPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(InputMethod,
                                                   handleOrPtrInfo);
  }

  function InputMethodAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        InputMethod, associatedInterfacePtrInfo);
  }

  InputMethodAssociatedPtr.prototype =
      Object.create(InputMethodPtr.prototype);
  InputMethodAssociatedPtr.prototype.constructor =
      InputMethodAssociatedPtr;

  function InputMethodProxy(receiver) {
    this.receiver_ = receiver;
  }
  InputMethodPtr.prototype.onFocusDeprecated = function() {
    return InputMethodProxy.prototype.onFocusDeprecated
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodProxy.prototype.onFocusDeprecated = function(inputFieldInfo, settings) {
    var params_ = new InputMethod_OnFocusDeprecated_Params();
    params_.inputFieldInfo = inputFieldInfo;
    params_.settings = settings;
    var builder = new codec.MessageV0Builder(
        kInputMethod_OnFocusDeprecated_Name,
        codec.align(InputMethod_OnFocusDeprecated_Params.encodedSize));
    builder.encodeStruct(InputMethod_OnFocusDeprecated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodPtr.prototype.onFocus = function() {
    return InputMethodProxy.prototype.onFocus
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodProxy.prototype.onFocus = function(inputFieldInfo, deprecatedSettings) {
    var params_ = new InputMethod_OnFocus_Params();
    params_.inputFieldInfo = inputFieldInfo;
    params_.deprecatedSettings = deprecatedSettings;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kInputMethod_OnFocus_Name,
          codec.align(InputMethod_OnFocus_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(InputMethod_OnFocus_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(InputMethod_OnFocus_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  InputMethodPtr.prototype.onBlur = function() {
    return InputMethodProxy.prototype.onBlur
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodProxy.prototype.onBlur = function() {
    var params_ = new InputMethod_OnBlur_Params();
    var builder = new codec.MessageV0Builder(
        kInputMethod_OnBlur_Name,
        codec.align(InputMethod_OnBlur_Params.encodedSize));
    builder.encodeStruct(InputMethod_OnBlur_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodPtr.prototype.processKeyEvent = function() {
    return InputMethodProxy.prototype.processKeyEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodProxy.prototype.processKeyEvent = function(event) {
    var params_ = new InputMethod_ProcessKeyEvent_Params();
    params_.event = event;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kInputMethod_ProcessKeyEvent_Name,
          codec.align(InputMethod_ProcessKeyEvent_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(InputMethod_ProcessKeyEvent_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(InputMethod_ProcessKeyEvent_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  InputMethodPtr.prototype.onSurroundingTextChanged = function() {
    return InputMethodProxy.prototype.onSurroundingTextChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodProxy.prototype.onSurroundingTextChanged = function(text, offset, selectionRange) {
    var params_ = new InputMethod_OnSurroundingTextChanged_Params();
    params_.text = text;
    params_.offset = offset;
    params_.selectionRange = selectionRange;
    var builder = new codec.MessageV0Builder(
        kInputMethod_OnSurroundingTextChanged_Name,
        codec.align(InputMethod_OnSurroundingTextChanged_Params.encodedSize));
    builder.encodeStruct(InputMethod_OnSurroundingTextChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodPtr.prototype.onCompositionCanceledBySystem = function() {
    return InputMethodProxy.prototype.onCompositionCanceledBySystem
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodProxy.prototype.onCompositionCanceledBySystem = function() {
    var params_ = new InputMethod_OnCompositionCanceledBySystem_Params();
    var builder = new codec.MessageV0Builder(
        kInputMethod_OnCompositionCanceledBySystem_Name,
        codec.align(InputMethod_OnCompositionCanceledBySystem_Params.encodedSize));
    builder.encodeStruct(InputMethod_OnCompositionCanceledBySystem_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodPtr.prototype.onCandidateSelected = function() {
    return InputMethodProxy.prototype.onCandidateSelected
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodProxy.prototype.onCandidateSelected = function(selectedCandidateIndex) {
    var params_ = new InputMethod_OnCandidateSelected_Params();
    params_.selectedCandidateIndex = selectedCandidateIndex;
    var builder = new codec.MessageV0Builder(
        kInputMethod_OnCandidateSelected_Name,
        codec.align(InputMethod_OnCandidateSelected_Params.encodedSize));
    builder.encodeStruct(InputMethod_OnCandidateSelected_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodPtr.prototype.onQuickSettingsUpdated = function() {
    return InputMethodProxy.prototype.onQuickSettingsUpdated
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodProxy.prototype.onQuickSettingsUpdated = function(settings) {
    var params_ = new InputMethod_OnQuickSettingsUpdated_Params();
    params_.settings = settings;
    var builder = new codec.MessageV0Builder(
        kInputMethod_OnQuickSettingsUpdated_Name,
        codec.align(InputMethod_OnQuickSettingsUpdated_Params.encodedSize));
    builder.encodeStruct(InputMethod_OnQuickSettingsUpdated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodPtr.prototype.isReadyForTesting = function() {
    return InputMethodProxy.prototype.isReadyForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodProxy.prototype.isReadyForTesting = function() {
    var params_ = new InputMethod_IsReadyForTesting_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kInputMethod_IsReadyForTesting_Name,
          codec.align(InputMethod_IsReadyForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(InputMethod_IsReadyForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(InputMethod_IsReadyForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  InputMethodPtr.prototype.onAssistiveWindowChanged = function() {
    return InputMethodProxy.prototype.onAssistiveWindowChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodProxy.prototype.onAssistiveWindowChanged = function(window) {
    var params_ = new InputMethod_OnAssistiveWindowChanged_Params();
    params_.window = window;
    var builder = new codec.MessageV0Builder(
        kInputMethod_OnAssistiveWindowChanged_Name,
        codec.align(InputMethod_OnAssistiveWindowChanged_Params.encodedSize));
    builder.encodeStruct(InputMethod_OnAssistiveWindowChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function InputMethodStub(delegate) {
    this.delegate_ = delegate;
  }
  InputMethodStub.prototype.onFocusDeprecated = function(inputFieldInfo, settings) {
    return this.delegate_ && this.delegate_.onFocusDeprecated && this.delegate_.onFocusDeprecated(inputFieldInfo, settings);
  }
  InputMethodStub.prototype.onFocus = function(inputFieldInfo, deprecatedSettings) {
    return this.delegate_ && this.delegate_.onFocus && this.delegate_.onFocus(inputFieldInfo, deprecatedSettings);
  }
  InputMethodStub.prototype.onBlur = function() {
    return this.delegate_ && this.delegate_.onBlur && this.delegate_.onBlur();
  }
  InputMethodStub.prototype.processKeyEvent = function(event) {
    return this.delegate_ && this.delegate_.processKeyEvent && this.delegate_.processKeyEvent(event);
  }
  InputMethodStub.prototype.onSurroundingTextChanged = function(text, offset, selectionRange) {
    return this.delegate_ && this.delegate_.onSurroundingTextChanged && this.delegate_.onSurroundingTextChanged(text, offset, selectionRange);
  }
  InputMethodStub.prototype.onCompositionCanceledBySystem = function() {
    return this.delegate_ && this.delegate_.onCompositionCanceledBySystem && this.delegate_.onCompositionCanceledBySystem();
  }
  InputMethodStub.prototype.onCandidateSelected = function(selectedCandidateIndex) {
    return this.delegate_ && this.delegate_.onCandidateSelected && this.delegate_.onCandidateSelected(selectedCandidateIndex);
  }
  InputMethodStub.prototype.onQuickSettingsUpdated = function(settings) {
    return this.delegate_ && this.delegate_.onQuickSettingsUpdated && this.delegate_.onQuickSettingsUpdated(settings);
  }
  InputMethodStub.prototype.isReadyForTesting = function() {
    return this.delegate_ && this.delegate_.isReadyForTesting && this.delegate_.isReadyForTesting();
  }
  InputMethodStub.prototype.onAssistiveWindowChanged = function(window) {
    return this.delegate_ && this.delegate_.onAssistiveWindowChanged && this.delegate_.onAssistiveWindowChanged(window);
  }

  InputMethodStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kInputMethod_OnFocusDeprecated_Name:
      var params = reader.decodeStruct(InputMethod_OnFocusDeprecated_Params);
      this.onFocusDeprecated(params.inputFieldInfo, params.settings);
      return true;
    case kInputMethod_OnBlur_Name:
      var params = reader.decodeStruct(InputMethod_OnBlur_Params);
      this.onBlur();
      return true;
    case kInputMethod_OnSurroundingTextChanged_Name:
      var params = reader.decodeStruct(InputMethod_OnSurroundingTextChanged_Params);
      this.onSurroundingTextChanged(params.text, params.offset, params.selectionRange);
      return true;
    case kInputMethod_OnCompositionCanceledBySystem_Name:
      var params = reader.decodeStruct(InputMethod_OnCompositionCanceledBySystem_Params);
      this.onCompositionCanceledBySystem();
      return true;
    case kInputMethod_OnCandidateSelected_Name:
      var params = reader.decodeStruct(InputMethod_OnCandidateSelected_Params);
      this.onCandidateSelected(params.selectedCandidateIndex);
      return true;
    case kInputMethod_OnQuickSettingsUpdated_Name:
      var params = reader.decodeStruct(InputMethod_OnQuickSettingsUpdated_Params);
      this.onQuickSettingsUpdated(params.settings);
      return true;
    case kInputMethod_OnAssistiveWindowChanged_Name:
      var params = reader.decodeStruct(InputMethod_OnAssistiveWindowChanged_Params);
      this.onAssistiveWindowChanged(params.window);
      return true;
    default:
      return false;
    }
  };

  InputMethodStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kInputMethod_OnFocus_Name:
      var params = reader.decodeStruct(InputMethod_OnFocus_Params);
      this.onFocus(params.inputFieldInfo, params.deprecatedSettings).then(function(response) {
        var responseParams =
            new InputMethod_OnFocus_ResponseParams();
        responseParams.success = response.success;
        responseParams.metadata = response.metadata;
        var builder = new codec.MessageV1Builder(
            kInputMethod_OnFocus_Name,
            codec.align(InputMethod_OnFocus_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(InputMethod_OnFocus_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kInputMethod_ProcessKeyEvent_Name:
      var params = reader.decodeStruct(InputMethod_ProcessKeyEvent_Params);
      this.processKeyEvent(params.event).then(function(response) {
        var responseParams =
            new InputMethod_ProcessKeyEvent_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kInputMethod_ProcessKeyEvent_Name,
            codec.align(InputMethod_ProcessKeyEvent_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(InputMethod_ProcessKeyEvent_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kInputMethod_IsReadyForTesting_Name:
      var params = reader.decodeStruct(InputMethod_IsReadyForTesting_Params);
      this.isReadyForTesting().then(function(response) {
        var responseParams =
            new InputMethod_IsReadyForTesting_ResponseParams();
        responseParams.ready = response.ready;
        var builder = new codec.MessageV1Builder(
            kInputMethod_IsReadyForTesting_Name,
            codec.align(InputMethod_IsReadyForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(InputMethod_IsReadyForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateInputMethodRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kInputMethod_OnFocusDeprecated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethod_OnFocusDeprecated_Params;
      break;
      case kInputMethod_OnFocus_Name:
        if (message.expectsResponse())
          paramsClass = InputMethod_OnFocus_Params;
      break;
      case kInputMethod_OnBlur_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethod_OnBlur_Params;
      break;
      case kInputMethod_ProcessKeyEvent_Name:
        if (message.expectsResponse())
          paramsClass = InputMethod_ProcessKeyEvent_Params;
      break;
      case kInputMethod_OnSurroundingTextChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethod_OnSurroundingTextChanged_Params;
      break;
      case kInputMethod_OnCompositionCanceledBySystem_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethod_OnCompositionCanceledBySystem_Params;
      break;
      case kInputMethod_OnCandidateSelected_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethod_OnCandidateSelected_Params;
      break;
      case kInputMethod_OnQuickSettingsUpdated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethod_OnQuickSettingsUpdated_Params;
      break;
      case kInputMethod_IsReadyForTesting_Name:
        if (message.expectsResponse())
          paramsClass = InputMethod_IsReadyForTesting_Params;
      break;
      case kInputMethod_OnAssistiveWindowChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethod_OnAssistiveWindowChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateInputMethodResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kInputMethod_OnFocus_Name:
        if (message.isResponse())
          paramsClass = InputMethod_OnFocus_ResponseParams;
        break;
      case kInputMethod_ProcessKeyEvent_Name:
        if (message.isResponse())
          paramsClass = InputMethod_ProcessKeyEvent_ResponseParams;
        break;
      case kInputMethod_IsReadyForTesting_Name:
        if (message.isResponse())
          paramsClass = InputMethod_IsReadyForTesting_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var InputMethod = {
    name: 'ash.ime.mojom.InputMethod',
    kVersion: 17,
    ptrClass: InputMethodPtr,
    proxyClass: InputMethodProxy,
    stubClass: InputMethodStub,
    validateRequest: validateInputMethodRequest,
    validateResponse: validateInputMethodResponse,
  };
  InputMethodStub.prototype.validator = validateInputMethodRequest;
  InputMethodProxy.prototype.validator = validateInputMethodResponse;
  exports.KeyEventType = KeyEventType;
  exports.NamedDomKey = NamedDomKey;
  exports.DomCode = DomCode;
  exports.KeyEventResult = KeyEventResult;
  exports.InputFieldType = InputFieldType;
  exports.AutocorrectMode = AutocorrectMode;
  exports.PersonalizationMode = PersonalizationMode;
  exports.TextPredictionMode = TextPredictionMode;
  exports.KoreanLayout = KoreanLayout;
  exports.PinyinLayout = PinyinLayout;
  exports.ZhuyinLayout = ZhuyinLayout;
  exports.ZhuyinSelectionKeys = ZhuyinSelectionKeys;
  exports.ChineseLanguageMode = ChineseLanguageMode;
  exports.JapaneseInputMode = JapaneseInputMode;
  exports.SuggestionMode = SuggestionMode;
  exports.SuggestionType = SuggestionType;
  exports.AssistiveWindowType = AssistiveWindowType;
  exports.AutocorrectSuggestionProvider = AutocorrectSuggestionProvider;
  exports.ModifierState = ModifierState;
  exports.PhysicalKeyEvent = PhysicalKeyEvent;
  exports.SelectionRange = SelectionRange;
  exports.InputFieldInfo = InputFieldInfo;
  exports.KoreanSettings = KoreanSettings;
  exports.LatinSettings = LatinSettings;
  exports.FuzzyPinyinSettings = FuzzyPinyinSettings;
  exports.PinyinSettings = PinyinSettings;
  exports.JapaneseSettings = JapaneseSettings;
  exports.ZhuyinSettings = ZhuyinSettings;
  exports.ChineseQuickSettings = ChineseQuickSettings;
  exports.JapaneseQuickSettings = JapaneseQuickSettings;
  exports.SuggestionCandidate = SuggestionCandidate;
  exports.InputMethodMetadata = InputMethodMetadata;
  exports.AssistiveWindow = AssistiveWindow;
  exports.VietnameseTelexSettings = VietnameseTelexSettings;
  exports.VietnameseVniSettings = VietnameseVniSettings;
  exports.DomKey = DomKey;
  exports.InputMethodSettings = InputMethodSettings;
  exports.InputMethodQuickSettings = InputMethodQuickSettings;
  exports.InputMethod = InputMethod;
  exports.InputMethodPtr = InputMethodPtr;
  exports.InputMethodAssociatedPtr = InputMethodAssociatedPtr;
})();