// chromeos/ash/services/ime/public/mojom/input_method.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../../mojo/public/js/bindings.js';

import {
  JpUnusedStruct as ash_ime_mojom_JpUnusedStruct,
  JpUnusedStructSpec as ash_ime_mojom_JpUnusedStructSpec
} from './japanese_settings.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const KeyEventTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const KeyEventType = {
  
  kKeyDown: 0,
  kKeyUp: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const NamedDomKeySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const NamedDomKey = {
  
  kOther: 0,
  kAlt: 1,
  kAltGraph: 2,
  kCapsLock: 3,
  kControl: 4,
  kShift: 5,
  kEnter: 6,
  kBackspace: 7,
  kEscape: 10,
  kHangeulMode: 8,
  kHanjaMode: 9,
  kArrowDown: 11,
  kArrowLeft: 12,
  kArrowRight: 13,
  kArrowUp: 14,
  kPageDown: 15,
  kPageUp: 16,
  kTab: 17,
  kF1: 18,
  kF2: 19,
  kF3: 20,
  kF4: 21,
  kF5: 22,
  kF6: 23,
  kF7: 24,
  kF8: 25,
  kF9: 26,
  kF10: 27,
  kF11: 28,
  kF12: 29,
  kBrowserBack: 30,
  kBrowserForward: 31,
  kBrowserRefresh: 32,
  kZoomToggle: 33,
  kLaunchMyComputer: 34,
  kBrightnessDown: 35,
  kBrightnessUp: 36,
  kAudioVolumeMute: 37,
  kAudioVolumeDown: 38,
  kAudioVolumeUp: 39,
  kDelete: 40,
  kNumLock: 41,
  MIN_VALUE: 0,
  MAX_VALUE: 41,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DomCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DomCode = {
  
  kOther: 0,
  kBackquote: 1,
  kBackslash: 2,
  kBracketLeft: 3,
  kBracketRight: 4,
  kComma: 5,
  kDigit0: 6,
  kDigit1: 7,
  kDigit2: 8,
  kDigit3: 9,
  kDigit4: 10,
  kDigit5: 11,
  kDigit6: 12,
  kDigit7: 13,
  kDigit8: 14,
  kDigit9: 15,
  kEqual: 16,
  kIntlBackslash: 17,
  kIntlRo: 18,
  kIntlYen: 19,
  kKeyA: 20,
  kKeyB: 21,
  kKeyC: 22,
  kKeyD: 23,
  kKeyE: 24,
  kKeyF: 25,
  kKeyG: 26,
  kKeyH: 27,
  kKeyI: 28,
  kKeyJ: 29,
  kKeyK: 30,
  kKeyL: 31,
  kKeyM: 32,
  kKeyN: 33,
  kKeyO: 34,
  kKeyP: 35,
  kKeyQ: 36,
  kKeyR: 37,
  kKeyS: 38,
  kKeyT: 39,
  kKeyU: 40,
  kKeyV: 41,
  kKeyW: 42,
  kKeyX: 43,
  kKeyY: 44,
  kKeyZ: 45,
  kMinus: 46,
  kPeriod: 47,
  kQuote: 48,
  kSemicolon: 49,
  kSlash: 50,
  kBackspace: 51,
  kEnter: 52,
  kSpace: 53,
  kAltLeft: 54,
  kAltRight: 55,
  kShiftLeft: 56,
  kShiftRight: 57,
  kControlLeft: 58,
  kControlRight: 59,
  kCapsLock: 60,
  kEscape: 61,
  kTab: 62,
  kNumpadMultiply: 63,
  kKanaMode: 64,
  kPageUp: 65,
  kEnd: 66,
  kDelete: 67,
  kHome: 68,
  kPageDown: 69,
  kArrowUp: 70,
  kArrowLeft: 71,
  kArrowRight: 72,
  kArrowDown: 73,
  kNumpad0: 74,
  kNumpad1: 75,
  kNumpad2: 76,
  kNumpad3: 77,
  kNumpad4: 78,
  kNumpad5: 79,
  kNumpad6: 80,
  kNumpad7: 81,
  kNumpad8: 82,
  kNumpad9: 83,
  kNumpadSubtract: 84,
  kNumpadAdd: 85,
  kNumpadDecimal: 86,
  kNumpadEnter: 87,
  kNumpadDivide: 88,
  MIN_VALUE: 0,
  MAX_VALUE: 88,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const KeyEventResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const KeyEventResult = {
  
  kNeedsHandlingBySystem: 0,
  kConsumedByIme: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const InputFieldTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const InputFieldType = {
  
  kNoIME: 0,
  kText: 1,
  kSearch: 2,
  kTelephone: 3,
  kURL: 4,
  kEmail: 5,
  kNumber: 6,
  kPassword: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AutocorrectModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AutocorrectMode = {
  
  kDisabled: 0,
  kEnabled: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PersonalizationModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PersonalizationMode = {
  
  kDisabled: 0,
  kEnabled: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TextPredictionModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TextPredictionMode = {
  
  kDisabled: 0,
  kEnabled: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const KoreanLayoutSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const KoreanLayout = {
  
  kDubeolsik: 0,
  kDubeolsikOldHangeul: 1,
  kSebeolsik390: 2,
  kSebeolsikFinal: 3,
  kSebeolsikNoShift: 4,
  kSebeolsikOldHangeul: 5,
  kDeprecatedSebeolsikDubeol: 6,
  kDeprecatedRomaja: 7,
  kDeprecatedAhnmatae: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PinyinLayoutSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PinyinLayout = {
  
  kUsQwerty: 0,
  kDvorak: 1,
  kColemak: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ZhuyinLayoutSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ZhuyinLayout = {
  
  kStandard: 0,
  kIbm: 1,
  kEten: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ZhuyinSelectionKeysSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ZhuyinSelectionKeys = {
  
  k1234567890: 0,
  kAsdfghjkl: 1,
  kAsdfzxcv89: 2,
  kAsdfjkl789: 3,
  k1234Qweras: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ChineseLanguageModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ChineseLanguageMode = {
  
  kChinese: 0,
  kRaw: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const JapaneseInputModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const JapaneseInputMode = {
  
  kHiragana: 0,
  kKatakana: 1,
  kWideLatin: 2,
  kHalfWidthKatakana: 3,
  kLatin: 4,
  kDirectInput: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SuggestionModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SuggestionMode = {
  
  kUnknown: 0,
  kCompletion: 1,
  kPrediction: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SuggestionTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SuggestionType = {
  
  kUnknown: 0,
  kAssistivePersonalInfo: 1,
  kAssistiveEmoji: 2,
  kMultiWord: 3,
  kGrammar: 4,
  kLongpressDiacritic: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AssistiveWindowTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AssistiveWindowType = {
  
  kHidden: 0,
  kUndo: 1,
  kEmojiSuggestion: 2,
  kPersonalInfoSuggestion: 3,
  kGrammarSuggestion: 4,
  kMultiWordSuggestion: 5,
  kLongpressDiacriticsSuggestion: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AutocorrectSuggestionProviderSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AutocorrectSuggestionProvider = {
  
  kUnknown: 0,
  kUsEnglishPrebundled: 1,
  kUsEnglishDownloaded: 2,
  kUsEnglish840: 3,
  kUsEnglish840V2: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class InputMethodPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.ime.mojom.InputMethod', scope);
  }
}

/** @interface */
export class InputMethodInterface {
  
  /**
   * @param { !InputFieldInfo } inputFieldInfo
   * @param { ?InputMethodSettings } settings
   */

  onFocusDeprecated(inputFieldInfo, settings) {}
  
  /**
   * @param { !InputFieldInfo } inputFieldInfo
   * @param { ?InputMethodSettings } deprecatedSettings
   * @return {!Promise<{
        success: !boolean,
        metadata: ?InputMethodMetadata,
   *  }>}
   */

  onFocus(inputFieldInfo, deprecatedSettings) {}
  
  /**
   */

  onBlur() {}
  
  /**
   * @param { !PhysicalKeyEvent } event
   * @return {!Promise<{
        result: !KeyEventResult,
   *  }>}
   */

  processKeyEvent(event) {}
  
  /**
   * @param { !string } text
   * @param { !number } offset
   * @param { !SelectionRange } selectionRange
   */

  onSurroundingTextChanged(text, offset, selectionRange) {}
  
  /**
   */

  onCompositionCanceledBySystem() {}
  
  /**
   * @param { !number } selectedCandidateIndex
   */

  onCandidateSelected(selectedCandidateIndex) {}
  
  /**
   * @param { !InputMethodQuickSettings } settings
   */

  onQuickSettingsUpdated(settings) {}
  
  /**
   * @return {!Promise<{
        ready: !boolean,
   *  }>}
   */

  isReadyForTesting() {}
  
  /**
   * @param { !AssistiveWindow } window
   */

  onAssistiveWindowChanged(window) {}
}

/**
 * @implements { InputMethodInterface }
 */
export class InputMethodRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!InputMethodPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          InputMethodPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!InputMethodPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !InputFieldInfo } inputFieldInfo
   * @param { ?InputMethodSettings } settings
   */

  onFocusDeprecated(
      inputFieldInfo,
      settings) {
    this.proxy.sendMessage(
        0,
        InputMethod_OnFocusDeprecated_ParamsSpec.$,
        null,
        [
          inputFieldInfo,
          settings
        ],
        false);
  }

  
  /**
   * @param { !InputFieldInfo } inputFieldInfo
   * @param { ?InputMethodSettings } deprecatedSettings
   * @return {!Promise<{
        success: !boolean,
        metadata: ?InputMethodMetadata,
   *  }>}
   */

  onFocus(
      inputFieldInfo,
      deprecatedSettings) {
    return this.proxy.sendMessage(
        6,
        InputMethod_OnFocus_ParamsSpec.$,
        InputMethod_OnFocus_ResponseParamsSpec.$,
        [
          inputFieldInfo,
          deprecatedSettings
        ],
        false);
  }

  
  /**
   */

  onBlur() {
    this.proxy.sendMessage(
        1,
        InputMethod_OnBlur_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !PhysicalKeyEvent } event
   * @return {!Promise<{
        result: !KeyEventResult,
   *  }>}
   */

  processKeyEvent(
      event) {
    return this.proxy.sendMessage(
        2,
        InputMethod_ProcessKeyEvent_ParamsSpec.$,
        InputMethod_ProcessKeyEvent_ResponseParamsSpec.$,
        [
          event
        ],
        false);
  }

  
  /**
   * @param { !string } text
   * @param { !number } offset
   * @param { !SelectionRange } selectionRange
   */

  onSurroundingTextChanged(
      text,
      offset,
      selectionRange) {
    this.proxy.sendMessage(
        3,
        InputMethod_OnSurroundingTextChanged_ParamsSpec.$,
        null,
        [
          text,
          offset,
          selectionRange
        ],
        false);
  }

  
  /**
   */

  onCompositionCanceledBySystem() {
    this.proxy.sendMessage(
        4,
        InputMethod_OnCompositionCanceledBySystem_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } selectedCandidateIndex
   */

  onCandidateSelected(
      selectedCandidateIndex) {
    this.proxy.sendMessage(
        5,
        InputMethod_OnCandidateSelected_ParamsSpec.$,
        null,
        [
          selectedCandidateIndex
        ],
        false);
  }

  
  /**
   * @param { !InputMethodQuickSettings } settings
   */

  onQuickSettingsUpdated(
      settings) {
    this.proxy.sendMessage(
        7,
        InputMethod_OnQuickSettingsUpdated_ParamsSpec.$,
        null,
        [
          settings
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        ready: !boolean,
   *  }>}
   */

  isReadyForTesting() {
    return this.proxy.sendMessage(
        8,
        InputMethod_IsReadyForTesting_ParamsSpec.$,
        InputMethod_IsReadyForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !AssistiveWindow } window
   */

  onAssistiveWindowChanged(
      window) {
    this.proxy.sendMessage(
        9,
        InputMethod_OnAssistiveWindowChanged_ParamsSpec.$,
        null,
        [
          window
        ],
        false);
  }
}

/**
 * An object which receives request messages for the InputMethod
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InputMethodReceiver {
  /**
   * @param {!InputMethodInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!InputMethodRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        InputMethodRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InputMethodRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        InputMethod_OnFocusDeprecated_ParamsSpec.$,
        null,
        impl.onFocusDeprecated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        InputMethod_OnFocus_ParamsSpec.$,
        InputMethod_OnFocus_ResponseParamsSpec.$,
        impl.onFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        InputMethod_OnBlur_ParamsSpec.$,
        null,
        impl.onBlur.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        InputMethod_ProcessKeyEvent_ParamsSpec.$,
        InputMethod_ProcessKeyEvent_ResponseParamsSpec.$,
        impl.processKeyEvent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        InputMethod_OnSurroundingTextChanged_ParamsSpec.$,
        null,
        impl.onSurroundingTextChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        InputMethod_OnCompositionCanceledBySystem_ParamsSpec.$,
        null,
        impl.onCompositionCanceledBySystem.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        InputMethod_OnCandidateSelected_ParamsSpec.$,
        null,
        impl.onCandidateSelected.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        InputMethod_OnQuickSettingsUpdated_ParamsSpec.$,
        null,
        impl.onQuickSettingsUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        InputMethod_IsReadyForTesting_ParamsSpec.$,
        InputMethod_IsReadyForTesting_ResponseParamsSpec.$,
        impl.isReadyForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        InputMethod_OnAssistiveWindowChanged_ParamsSpec.$,
        null,
        impl.onAssistiveWindowChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class InputMethod {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.InputMethod";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!InputMethodRemote}
   */
  static getRemote() {
    let remote = new InputMethodRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the InputMethod
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InputMethodCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      InputMethodRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InputMethodRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFocusDeprecated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        InputMethod_OnFocusDeprecated_ParamsSpec.$,
        null,
        this.onFocusDeprecated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        InputMethod_OnFocus_ParamsSpec.$,
        InputMethod_OnFocus_ResponseParamsSpec.$,
        this.onFocus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onBlur =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        InputMethod_OnBlur_ParamsSpec.$,
        null,
        this.onBlur.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.processKeyEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        InputMethod_ProcessKeyEvent_ParamsSpec.$,
        InputMethod_ProcessKeyEvent_ResponseParamsSpec.$,
        this.processKeyEvent.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSurroundingTextChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        InputMethod_OnSurroundingTextChanged_ParamsSpec.$,
        null,
        this.onSurroundingTextChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCompositionCanceledBySystem =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        InputMethod_OnCompositionCanceledBySystem_ParamsSpec.$,
        null,
        this.onCompositionCanceledBySystem.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCandidateSelected =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        InputMethod_OnCandidateSelected_ParamsSpec.$,
        null,
        this.onCandidateSelected.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onQuickSettingsUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        InputMethod_OnQuickSettingsUpdated_ParamsSpec.$,
        null,
        this.onQuickSettingsUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isReadyForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        InputMethod_IsReadyForTesting_ParamsSpec.$,
        InputMethod_IsReadyForTesting_ResponseParamsSpec.$,
        this.isReadyForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAssistiveWindowChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        InputMethod_OnAssistiveWindowChanged_ParamsSpec.$,
        null,
        this.onAssistiveWindowChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ModifierStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PhysicalKeyEventSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SelectionRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputFieldInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KoreanSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LatinSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FuzzyPinyinSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PinyinSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const JapaneseSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ZhuyinSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ChineseQuickSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const JapaneseQuickSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SuggestionCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AssistiveWindowSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VietnameseTelexSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VietnameseVniSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethod_OnFocusDeprecated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethod_OnFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethod_OnFocus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethod_OnBlur_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethod_ProcessKeyEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethod_ProcessKeyEvent_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethod_OnSurroundingTextChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethod_OnCompositionCanceledBySystem_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethod_OnCandidateSelected_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethod_OnQuickSettingsUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethod_IsReadyForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethod_IsReadyForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethod_OnAssistiveWindowChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const DomKeySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const InputMethodSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const InputMethodQuickSettingsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ModifierStateSpec.$,
    'ModifierState',
    [
      mojo.internal.StructField(
        'alt', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'altGraph', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'capsLock', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'control', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'meta', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shift', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ModifierState {
  constructor() {
    /** @type { !boolean } */
    this.alt;
    /** @type { !boolean } */
    this.altGraph;
    /** @type { !boolean } */
    this.capsLock;
    /** @type { !boolean } */
    this.control;
    /** @type { !boolean } */
    this.meta;
    /** @type { !boolean } */
    this.shift;
  }
}



mojo.internal.Struct(
    PhysicalKeyEventSpec.$,
    'PhysicalKeyEvent',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        KeyEventTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'key', 8,
        0,
        DomKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'code', 4,
        0,
        DomCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'modifierState', 24,
        0,
        ModifierStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class PhysicalKeyEvent {
  constructor() {
    /** @type { !KeyEventType } */
    this.type;
    /** @type { !DomKey } */
    this.key;
    /** @type { !DomCode } */
    this.code;
    /** @type { !ModifierState } */
    this.modifierState;
  }
}



mojo.internal.Struct(
    SelectionRangeSpec.$,
    'SelectionRange',
    [
      mojo.internal.StructField(
        'anchor', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'focus', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SelectionRange {
  constructor() {
    /** @type { !number } */
    this.anchor;
    /** @type { !number } */
    this.focus;
  }
}



mojo.internal.Struct(
    InputFieldInfoSpec.$,
    'InputFieldInfo',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        InputFieldTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'autocorrect', 4,
        0,
        AutocorrectModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'personalization', 8,
        0,
        PersonalizationModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textPrediction', 12,
        0,
        TextPredictionModeSpec.$,
        0,
        false /* nullable */,
        10,
      ),
    ],
    [[0, 24],[10, 24],]);



/**
 * @record
 */
export class InputFieldInfo {
  constructor() {
    /** @type { !InputFieldType } */
    this.type;
    /** @type { !AutocorrectMode } */
    this.autocorrect;
    /** @type { !PersonalizationMode } */
    this.personalization;
    /** @type { !TextPredictionMode } */
    this.textPrediction;
  }
}



mojo.internal.Struct(
    KoreanSettingsSpec.$,
    'KoreanSettings',
    [
      mojo.internal.StructField(
        'inputMultipleSyllables', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'layout', 4,
        0,
        KoreanLayoutSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class KoreanSettings {
  constructor() {
    /** @type { !boolean } */
    this.inputMultipleSyllables;
    /** @type { !KoreanLayout } */
    this.layout;
  }
}



mojo.internal.Struct(
    LatinSettingsSpec.$,
    'LatinSettings',
    [
      mojo.internal.StructField(
        'autocorrect', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'predictiveWriting', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        5,
      ),
    ],
    [[0, 16],[5, 16],]);



/**
 * @record
 */
export class LatinSettings {
  constructor() {
    /** @type { !boolean } */
    this.autocorrect;
    /** @type { !boolean } */
    this.predictiveWriting;
  }
}



mojo.internal.Struct(
    FuzzyPinyinSettingsSpec.$,
    'FuzzyPinyinSettings',
    [
      mojo.internal.StructField(
        'anAng', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enEng', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ianIang', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'kG', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rL', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uanUang', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cCh', 0,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fH', 0,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inIng', 1,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lN', 1,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sSh', 1,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'zZh', 1,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FuzzyPinyinSettings {
  constructor() {
    /** @type { !boolean } */
    this.anAng;
    /** @type { !boolean } */
    this.enEng;
    /** @type { !boolean } */
    this.ianIang;
    /** @type { !boolean } */
    this.kG;
    /** @type { !boolean } */
    this.rL;
    /** @type { !boolean } */
    this.uanUang;
    /** @type { !boolean } */
    this.cCh;
    /** @type { !boolean } */
    this.fH;
    /** @type { !boolean } */
    this.inIng;
    /** @type { !boolean } */
    this.lN;
    /** @type { !boolean } */
    this.sSh;
    /** @type { !boolean } */
    this.zZh;
  }
}



mojo.internal.Struct(
    PinyinSettingsSpec.$,
    'PinyinSettings',
    [
      mojo.internal.StructField(
        'fuzzyPinyin', 0,
        0,
        FuzzyPinyinSettingsSpec.$,
        null,
        true /* nullable */,
        6,
      ),
      mojo.internal.StructField(
        'layout', 8,
        0,
        PinyinLayoutSpec.$,
        0,
        false /* nullable */,
        6,
      ),
      mojo.internal.StructField(
        'useHyphenAndEqualsToPageCandidates', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        6,
      ),
      mojo.internal.StructField(
        'useCommaAndPeriodToPageCandidates', 12,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        6,
      ),
      mojo.internal.StructField(
        'defaultToChinese', 12,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        6,
      ),
      mojo.internal.StructField(
        'defaultToFullWidthCharacters', 12,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        6,
      ),
      mojo.internal.StructField(
        'defaultToFullWidthPunctuation', 12,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        6,
      ),
    ],
    [[0, 8],[6, 24],]);



/**
 * @record
 */
export class PinyinSettings {
  constructor() {
    /** @type { (FuzzyPinyinSettings|undefined) } */
    this.fuzzyPinyin;
    /** @type { !PinyinLayout } */
    this.layout;
    /** @type { !boolean } */
    this.useHyphenAndEqualsToPageCandidates;
    /** @type { !boolean } */
    this.useCommaAndPeriodToPageCandidates;
    /** @type { !boolean } */
    this.defaultToChinese;
    /** @type { !boolean } */
    this.defaultToFullWidthCharacters;
    /** @type { !boolean } */
    this.defaultToFullWidthPunctuation;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const JapaneseSettings_InputModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const JapaneseSettings_InputMode = {
  
  kUnspecified: 0,
  kRomaji: 1,
  kKana: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const JapaneseSettings_PunctuationStyleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const JapaneseSettings_PunctuationStyle = {
  
  kUnspecified: 0,
  kKutenTouten: 1,
  kCommaPeriod: 2,
  kKutenPeriod: 3,
  kCommaTouten: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const JapaneseSettings_SymbolStyleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const JapaneseSettings_SymbolStyle = {
  
  kUnspecified: 0,
  kCornerBracketMiddleDot: 1,
  kSquareBracketSlash: 2,
  kCornerBracketSlash: 3,
  kSquareBracketMiddleDot: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const JapaneseSettings_SpaceInputStyleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const JapaneseSettings_SpaceInputStyle = {
  
  kUnspecified: 0,
  kInputMode: 1,
  kFullWidth: 2,
  kHalfWidth: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const JapaneseSettings_SelectionShortcutSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const JapaneseSettings_SelectionShortcut = {
  
  kUnspecified: 0,
  kDigits123456789: 1,
  kAsdfghjkl: 2,
  kNoShortcut: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const JapaneseSettings_KeymapStyleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const JapaneseSettings_KeymapStyle = {
  
  kUnspecified: 0,
  kCustom: 1,
  kAtok: 2,
  kMsime: 3,
  kKotoeri: 4,
  kMobile: 5,
  kChromeos: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const JapaneseSettings_ShiftKeyModeStyleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const JapaneseSettings_ShiftKeyModeStyle = {
  
  kUnspecified: 0,
  kOff: 1,
  kAlphanumeric: 2,
  kKatakana: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


mojo.internal.Struct(
    JapaneseSettingsSpec.$,
    'JapaneseSettings',
    [
      mojo.internal.StructField(
        'unused', 0,
        0,
        ash_ime_mojom_JpUnusedStructSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputMode', 8,
        0,
        JapaneseSettings_InputModeSpec.$,
        0,
        false /* nullable */,
        22,
      ),
      mojo.internal.StructField(
        'punctuationStyle', 12,
        0,
        JapaneseSettings_PunctuationStyleSpec.$,
        0,
        false /* nullable */,
        22,
      ),
      mojo.internal.StructField(
        'symbolStyle', 16,
        0,
        JapaneseSettings_SymbolStyleSpec.$,
        0,
        false /* nullable */,
        22,
      ),
      mojo.internal.StructField(
        'spaceInputStyle', 20,
        0,
        JapaneseSettings_SpaceInputStyleSpec.$,
        0,
        false /* nullable */,
        22,
      ),
      mojo.internal.StructField(
        'selectionShortcut', 24,
        0,
        JapaneseSettings_SelectionShortcutSpec.$,
        0,
        false /* nullable */,
        22,
      ),
      mojo.internal.StructField(
        'keymapStyle', 28,
        0,
        JapaneseSettings_KeymapStyleSpec.$,
        0,
        false /* nullable */,
        22,
      ),
      mojo.internal.StructField(
        'automaticallySwitchToHalfwidth', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        22,
      ),
      mojo.internal.StructField(
        'shiftKeyModeStyle', 36,
        0,
        JapaneseSettings_ShiftKeyModeStyleSpec.$,
        0,
        false /* nullable */,
        22,
      ),
      mojo.internal.StructField(
        'useInputHistory', 32,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        22,
      ),
      mojo.internal.StructField(
        'useSystemDictionary', 32,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        22,
      ),
      mojo.internal.StructField(
        'numberOfSuggestions', 40,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        22,
      ),
      mojo.internal.StructField(
        'disablePersonalizedSuggestions', 32,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        22,
      ),
      mojo.internal.StructField(
        'unused2', 32,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        22,
      ),
    ],
    [[0, 16],[22, 56],]);



/**
 * @record
 */
export class JapaneseSettings {
  constructor() {
    /** @type { (ash_ime_mojom_JpUnusedStruct|undefined) } */
    this.unused;
    /** @type { !JapaneseSettings_InputMode } */
    this.inputMode;
    /** @type { !JapaneseSettings_PunctuationStyle } */
    this.punctuationStyle;
    /** @type { !JapaneseSettings_SymbolStyle } */
    this.symbolStyle;
    /** @type { !JapaneseSettings_SpaceInputStyle } */
    this.spaceInputStyle;
    /** @type { !JapaneseSettings_SelectionShortcut } */
    this.selectionShortcut;
    /** @type { !JapaneseSettings_KeymapStyle } */
    this.keymapStyle;
    /** @type { !boolean } */
    this.automaticallySwitchToHalfwidth;
    /** @type { !JapaneseSettings_ShiftKeyModeStyle } */
    this.shiftKeyModeStyle;
    /** @type { !boolean } */
    this.useInputHistory;
    /** @type { !boolean } */
    this.useSystemDictionary;
    /** @type { !number } */
    this.numberOfSuggestions;
    /** @type { !boolean } */
    this.disablePersonalizedSuggestions;
    /** @type { !boolean } */
    this.unused2;
  }
}



mojo.internal.Struct(
    ZhuyinSettingsSpec.$,
    'ZhuyinSettings',
    [
      mojo.internal.StructField(
        'layout', 0,
        0,
        ZhuyinLayoutSpec.$,
        0,
        false /* nullable */,
        7,
      ),
      mojo.internal.StructField(
        'selectionKeys', 4,
        0,
        ZhuyinSelectionKeysSpec.$,
        0,
        false /* nullable */,
        7,
      ),
      mojo.internal.StructField(
        'pageSize', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        7,
      ),
    ],
    [[0, 8],[7, 24],]);



/**
 * @record
 */
export class ZhuyinSettings {
  constructor() {
    /** @type { !ZhuyinLayout } */
    this.layout;
    /** @type { !ZhuyinSelectionKeys } */
    this.selectionKeys;
    /** @type { !number } */
    this.pageSize;
  }
}



mojo.internal.Struct(
    ChineseQuickSettingsSpec.$,
    'ChineseQuickSettings',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        ChineseLanguageModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fullWidthCharacters', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fullWidthPunctuation', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ChineseQuickSettings {
  constructor() {
    /** @type { !ChineseLanguageMode } */
    this.mode;
    /** @type { !boolean } */
    this.fullWidthCharacters;
    /** @type { !boolean } */
    this.fullWidthPunctuation;
  }
}



mojo.internal.Struct(
    JapaneseQuickSettingsSpec.$,
    'JapaneseQuickSettings',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        JapaneseInputModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class JapaneseQuickSettings {
  constructor() {
    /** @type { !JapaneseInputMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    SuggestionCandidateSpec.$,
    'SuggestionCandidate',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        SuggestionModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 4,
        0,
        SuggestionTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'confirmedLength', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        13,
      ),
    ],
    [[0, 24],[13, 32],]);



/**
 * @record
 */
export class SuggestionCandidate {
  constructor() {
    /** @type { !SuggestionMode } */
    this.mode;
    /** @type { !SuggestionType } */
    this.type;
    /** @type { !string } */
    this.text;
    /** @type { !number } */
    this.confirmedLength;
  }
}



mojo.internal.Struct(
    InputMethodMetadataSpec.$,
    'InputMethodMetadata',
    [
      mojo.internal.StructField(
        'autocorrectSuggestionProvider', 0,
        0,
        AutocorrectSuggestionProviderSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodMetadata {
  constructor() {
    /** @type { !AutocorrectSuggestionProvider } */
    this.autocorrectSuggestionProvider;
  }
}



mojo.internal.Struct(
    AssistiveWindowSpec.$,
    'AssistiveWindow',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        AssistiveWindowTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'candidates', 8,
        0,
        mojo.internal.Array(SuggestionCandidateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AssistiveWindow {
  constructor() {
    /** @type { !AssistiveWindowType } */
    this.type;
    /** @type { !Array<!SuggestionCandidate> } */
    this.candidates;
  }
}



mojo.internal.Struct(
    VietnameseTelexSettingsSpec.$,
    'VietnameseTelexSettings',
    [
      mojo.internal.StructField(
        'allowFlexibleDiacritics', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newStyleToneMarkPlacement', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableInsertDoubleHornOnUo', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableWForUHornShortcut', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'showUnderlineForCompositionText', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        20,
      ),
    ],
    [[0, 16],[20, 16],]);



/**
 * @record
 */
export class VietnameseTelexSettings {
  constructor() {
    /** @type { !boolean } */
    this.allowFlexibleDiacritics;
    /** @type { !boolean } */
    this.newStyleToneMarkPlacement;
    /** @type { !boolean } */
    this.enableInsertDoubleHornOnUo;
    /** @type { !boolean } */
    this.enableWForUHornShortcut;
    /** @type { !boolean } */
    this.showUnderlineForCompositionText;
  }
}



mojo.internal.Struct(
    VietnameseVniSettingsSpec.$,
    'VietnameseVniSettings',
    [
      mojo.internal.StructField(
        'allowFlexibleDiacritics', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newStyleToneMarkPlacement', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableInsertDoubleHornOnUo', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'showUnderlineForCompositionText', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        20,
      ),
    ],
    [[0, 16],[20, 16],]);



/**
 * @record
 */
export class VietnameseVniSettings {
  constructor() {
    /** @type { !boolean } */
    this.allowFlexibleDiacritics;
    /** @type { !boolean } */
    this.newStyleToneMarkPlacement;
    /** @type { !boolean } */
    this.enableInsertDoubleHornOnUo;
    /** @type { !boolean } */
    this.showUnderlineForCompositionText;
  }
}



mojo.internal.Struct(
    InputMethod_OnFocusDeprecated_ParamsSpec.$,
    'InputMethod_OnFocusDeprecated_Params',
    [
      mojo.internal.StructField(
        'inputFieldInfo', 0,
        0,
        InputFieldInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'settings', 8,
        0,
        InputMethodSettingsSpec.$,
        null,
        true /* nullable */,
        4,
      ),
    ],
    [[0, 16],[4, 32],]);



/**
 * @record
 */
export class InputMethod_OnFocusDeprecated_Params {
  constructor() {
    /** @type { !InputFieldInfo } */
    this.inputFieldInfo;
    /** @type { (InputMethodSettings|undefined) } */
    this.settings;
  }
}



mojo.internal.Struct(
    InputMethod_OnFocus_ParamsSpec.$,
    'InputMethod_OnFocus_Params',
    [
      mojo.internal.StructField(
        'inputFieldInfo', 0,
        0,
        InputFieldInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deprecatedSettings', 8,
        0,
        InputMethodSettingsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class InputMethod_OnFocus_Params {
  constructor() {
    /** @type { !InputFieldInfo } */
    this.inputFieldInfo;
    /** @type { (InputMethodSettings|undefined) } */
    this.deprecatedSettings;
  }
}



mojo.internal.Struct(
    InputMethod_OnFocus_ResponseParamsSpec.$,
    'InputMethod_OnFocus_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metadata', 8,
        0,
        InputMethodMetadataSpec.$,
        null,
        true /* nullable */,
        17,
      ),
    ],
    [[0, 16],[17, 24],]);



/**
 * @record
 */
export class InputMethod_OnFocus_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { (InputMethodMetadata|undefined) } */
    this.metadata;
  }
}



mojo.internal.Struct(
    InputMethod_OnBlur_ParamsSpec.$,
    'InputMethod_OnBlur_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class InputMethod_OnBlur_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    InputMethod_ProcessKeyEvent_ParamsSpec.$,
    'InputMethod_ProcessKeyEvent_Params',
    [
      mojo.internal.StructField(
        'event', 0,
        0,
        PhysicalKeyEventSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethod_ProcessKeyEvent_Params {
  constructor() {
    /** @type { !PhysicalKeyEvent } */
    this.event;
  }
}



mojo.internal.Struct(
    InputMethod_ProcessKeyEvent_ResponseParamsSpec.$,
    'InputMethod_ProcessKeyEvent_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        KeyEventResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethod_ProcessKeyEvent_ResponseParams {
  constructor() {
    /** @type { !KeyEventResult } */
    this.result;
  }
}



mojo.internal.Struct(
    InputMethod_OnSurroundingTextChanged_ParamsSpec.$,
    'InputMethod_OnSurroundingTextChanged_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'offset', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selectionRange', 16,
        0,
        SelectionRangeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class InputMethod_OnSurroundingTextChanged_Params {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { !number } */
    this.offset;
    /** @type { !SelectionRange } */
    this.selectionRange;
  }
}



mojo.internal.Struct(
    InputMethod_OnCompositionCanceledBySystem_ParamsSpec.$,
    'InputMethod_OnCompositionCanceledBySystem_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class InputMethod_OnCompositionCanceledBySystem_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    InputMethod_OnCandidateSelected_ParamsSpec.$,
    'InputMethod_OnCandidateSelected_Params',
    [
      mojo.internal.StructField(
        'selectedCandidateIndex', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethod_OnCandidateSelected_Params {
  constructor() {
    /** @type { !number } */
    this.selectedCandidateIndex;
  }
}



mojo.internal.Struct(
    InputMethod_OnQuickSettingsUpdated_ParamsSpec.$,
    'InputMethod_OnQuickSettingsUpdated_Params',
    [
      mojo.internal.StructField(
        'settings', 0,
        0,
        InputMethodQuickSettingsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputMethod_OnQuickSettingsUpdated_Params {
  constructor() {
    /** @type { !InputMethodQuickSettings } */
    this.settings;
  }
}



mojo.internal.Struct(
    InputMethod_IsReadyForTesting_ParamsSpec.$,
    'InputMethod_IsReadyForTesting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class InputMethod_IsReadyForTesting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    InputMethod_IsReadyForTesting_ResponseParamsSpec.$,
    'InputMethod_IsReadyForTesting_ResponseParams',
    [
      mojo.internal.StructField(
        'ready', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethod_IsReadyForTesting_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.ready;
  }
}



mojo.internal.Struct(
    InputMethod_OnAssistiveWindowChanged_ParamsSpec.$,
    'InputMethod_OnAssistiveWindowChanged_Params',
    [
      mojo.internal.StructField(
        'window', 0,
        0,
        AssistiveWindowSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethod_OnAssistiveWindowChanged_Params {
  constructor() {
    /** @type { !AssistiveWindow } */
    this.window;
  }
}

mojo.internal.Union(
    DomKeySpec.$, 'DomKey',
    {
      'namedKey': {
        'ordinal': 0,
        'type': NamedDomKeySpec.$,
      },
      'codepoint': {
        'ordinal': 1,
        'type': mojo.internal.Uint32,
      },
    });

/**
 * @typedef { {
 *   namedKey: (!NamedDomKey|undefined),
 *   codepoint: (!number|undefined),
 * } }
 */
export const DomKey = {};
mojo.internal.Union(
    InputMethodSettingsSpec.$, 'InputMethodSettings',
    {
      'koreanSettings': {
        'ordinal': 0,
        'type': KoreanSettingsSpec.$,
      },
      'latinSettings': {
        'ordinal': 1,
        'type': LatinSettingsSpec.$,
      },
      'pinyinSettings': {
        'ordinal': 2,
        'type': PinyinSettingsSpec.$,
      },
      'zhuyinSettings': {
        'ordinal': 3,
        'type': ZhuyinSettingsSpec.$,
      },
      'nullSettings': {
        'ordinal': 4,
        'type': mojo.internal.Bool,
      },
      'japaneseSettings': {
        'ordinal': 5,
        'type': JapaneseSettingsSpec.$,
      },
      'vietnameseTelexSettings': {
        'ordinal': 6,
        'type': VietnameseTelexSettingsSpec.$,
      },
      'vietnameseVniSettings': {
        'ordinal': 7,
        'type': VietnameseVniSettingsSpec.$,
      },
    });

/**
 * @typedef { {
 *   koreanSettings: (!KoreanSettings|undefined),
 *   latinSettings: (!LatinSettings|undefined),
 *   pinyinSettings: (!PinyinSettings|undefined),
 *   zhuyinSettings: (!ZhuyinSettings|undefined),
 *   nullSettings: (!boolean|undefined),
 *   japaneseSettings: (!JapaneseSettings|undefined),
 *   vietnameseTelexSettings: (!VietnameseTelexSettings|undefined),
 *   vietnameseVniSettings: (!VietnameseVniSettings|undefined),
 * } }
 */
export const InputMethodSettings = {};
mojo.internal.Union(
    InputMethodQuickSettingsSpec.$, 'InputMethodQuickSettings',
    {
      'chineseSettings': {
        'ordinal': 0,
        'type': ChineseQuickSettingsSpec.$,
      },
      'japaneseSettings': {
        'ordinal': 1,
        'type': JapaneseQuickSettingsSpec.$,
      },
    });

/**
 * @typedef { {
 *   chineseSettings: (!ChineseQuickSettings|undefined),
 *   japaneseSettings: (!JapaneseQuickSettings|undefined),
 * } }
 */
export const InputMethodQuickSettings = {};
