// chromeos/ash/services/ime/public/mojom/input_method_host.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('ash.ime.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.CommitTextCursorBehaviorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.CommitTextCursorBehavior = {
  
  kMoveCursorAfterText: 0,
  kMoveCursorBeforeText: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.CompositionSpanStyleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.CompositionSpanStyle = {
  
  kDefault: 0,
  kNone: 1,
  kHighlight: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.InputMethodApiOperationSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.InputMethodApiOperation = {
  
  kUnknown: 0,
  kCommitText: 1,
  kSetCompositionText: 2,
  kDeleteSurroundingText: 3,
  kReplaceSurroundingText: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.KoreanActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.KoreanAction = {
  
  kUnknown: 0,
  kHanjaKey: 1,
  kHangeulKey: 2,
  kComposeOutOfOrder: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.HistogramBucketTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.ime.mojom.HistogramBucketType = {
  
  kExponential: 0,
  kLinear: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.ime.mojom.InputMethodHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.ime.mojom.InputMethodHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.ime.mojom.InputMethodHostInterface }
 */
ash.ime.mojom.InputMethodHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.ime.mojom.InputMethodHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.ime.mojom.InputMethodHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.ime.mojom.InputMethodHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } text
   * @param { !ash.ime.mojom.CommitTextCursorBehavior } cursorBehavior
   */

  commitText(
      text,
      cursorBehavior) {
    this.proxy.sendMessage(
        0,
        ash.ime.mojom.InputMethodHost_CommitText_ParamsSpec.$,
        null,
        [
          text,
          cursorBehavior
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } text
   * @param { !Array<!ash.ime.mojom.CompositionSpan> } spans
   */

  dEPRECATEDSetComposition(
      text,
      spans) {
    this.proxy.sendMessage(
        1,
        ash.ime.mojom.InputMethodHost_DEPRECATED_SetComposition_ParamsSpec.$,
        null,
        [
          text,
          spans
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } text
   * @param { !Array<!ash.ime.mojom.CompositionSpan> } spans
   * @param { !number } newCursorPosition
   */

  setComposition(
      text,
      spans,
      newCursorPosition) {
    this.proxy.sendMessage(
        12,
        ash.ime.mojom.InputMethodHost_SetComposition_ParamsSpec.$,
        null,
        [
          text,
          spans,
          newCursorPosition
        ],
        false);
  }

  
  /**
   * @param { !number } startIndex
   * @param { !number } endIndex
   */

  setCompositionRange(
      startIndex,
      endIndex) {
    this.proxy.sendMessage(
        2,
        ash.ime.mojom.InputMethodHost_SetCompositionRange_ParamsSpec.$,
        null,
        [
          startIndex,
          endIndex
        ],
        false);
  }

  
  /**
   */

  finishComposition() {
    this.proxy.sendMessage(
        3,
        ash.ime.mojom.InputMethodHost_FinishComposition_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } numBeforeCursor
   * @param { !number } numAfterCursor
   */

  deleteSurroundingText(
      numBeforeCursor,
      numAfterCursor) {
    this.proxy.sendMessage(
        4,
        ash.ime.mojom.InputMethodHost_DeleteSurroundingText_ParamsSpec.$,
        null,
        [
          numBeforeCursor,
          numAfterCursor
        ],
        false);
  }

  
  /**
   * @param { !number } numBeforeCursor
   * @param { !number } numAfterCursor
   * @param { !mojoBase.mojom.String16 } text
   */

  replaceSurroundingText(
      numBeforeCursor,
      numAfterCursor,
      text) {
    this.proxy.sendMessage(
        16,
        ash.ime.mojom.InputMethodHost_ReplaceSurroundingText_ParamsSpec.$,
        null,
        [
          numBeforeCursor,
          numAfterCursor,
          text
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.AutocorrectSpan } autocorrectSpan
   */

  handleAutocorrect(
      autocorrectSpan) {
    this.proxy.sendMessage(
        5,
        ash.ime.mojom.InputMethodHost_HandleAutocorrect_ParamsSpec.$,
        null,
        [
          autocorrectSpan
        ],
        false);
  }

  
  /**
   * @param { !Array<!ash.ime.mojom.SuggestionCandidate> } suggestions
   * @param { ?ash.ime.mojom.SuggestionsTextContext } context
   */

  displaySuggestions(
      suggestions,
      context) {
    this.proxy.sendMessage(
        6,
        ash.ime.mojom.InputMethodHost_DisplaySuggestions_ParamsSpec.$,
        null,
        [
          suggestions,
          context
        ],
        false);
  }

  
  /**
   * @param { ?ash.ime.mojom.CandidatesWindow } window
   */

  updateCandidatesWindow(
      window) {
    this.proxy.sendMessage(
        9,
        ash.ime.mojom.InputMethodHost_UpdateCandidatesWindow_ParamsSpec.$,
        null,
        [
          window
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.SuggestionsRequest } request
   * @return {!Promise<{
        response: !ash.ime.mojom.SuggestionsResponse,
   *  }>}
   */

  requestSuggestions(
      request) {
    return this.proxy.sendMessage(
        7,
        ash.ime.mojom.InputMethodHost_RequestSuggestions_ParamsSpec.$,
        ash.ime.mojom.InputMethodHost_RequestSuggestions_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.InputMethodQuickSettings } settings
   */

  updateQuickSettings(
      settings) {
    this.proxy.sendMessage(
        13,
        ash.ime.mojom.InputMethodHost_UpdateQuickSettings_ParamsSpec.$,
        null,
        [
          settings
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.UkmEntry } entry
   */

  recordUkm(
      entry) {
    this.proxy.sendMessage(
        8,
        ash.ime.mojom.InputMethodHost_RecordUkm_ParamsSpec.$,
        null,
        [
          entry
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.KoreanAction } action
   */

  dEPRECATEDReportKoreanAction(
      action) {
    this.proxy.sendMessage(
        10,
        ash.ime.mojom.InputMethodHost_DEPRECATED_ReportKoreanAction_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.KoreanSettings } settings
   */

  dEPRECATEDReportKoreanSettings(
      settings) {
    this.proxy.sendMessage(
        11,
        ash.ime.mojom.InputMethodHost_DEPRECATED_ReportKoreanSettings_ParamsSpec.$,
        null,
        [
          settings
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.SuggestionMode } mode
   */

  dEPRECATEDReportSuggestionOpportunity(
      mode) {
    this.proxy.sendMessage(
        14,
        ash.ime.mojom.InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_ParamsSpec.$,
        null,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !ash.ime.mojom.BucketedHistogram } histogram
   * @param { !number } value
   */

  dEPRECATEDReportHistogramSample(
      histogram,
      value) {
    this.proxy.sendMessage(
        15,
        ash.ime.mojom.InputMethodHost_DEPRECATED_ReportHistogramSample_ParamsSpec.$,
        null,
        [
          histogram,
          value
        ],
        false);
  }
};

/**
 * An object which receives request messages for the InputMethodHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.ime.mojom.InputMethodHostReceiver = class {
  /**
   * @param {!ash.ime.mojom.InputMethodHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.ime.mojom.InputMethodHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.ime.mojom.InputMethodHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.InputMethodHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.InputMethodHost_CommitText_ParamsSpec.$,
        null,
        impl.commitText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.ime.mojom.InputMethodHost_DEPRECATED_SetComposition_ParamsSpec.$,
        null,
        impl.dEPRECATEDSetComposition.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        ash.ime.mojom.InputMethodHost_SetComposition_ParamsSpec.$,
        null,
        impl.setComposition.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.ime.mojom.InputMethodHost_SetCompositionRange_ParamsSpec.$,
        null,
        impl.setCompositionRange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ash.ime.mojom.InputMethodHost_FinishComposition_ParamsSpec.$,
        null,
        impl.finishComposition.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ash.ime.mojom.InputMethodHost_DeleteSurroundingText_ParamsSpec.$,
        null,
        impl.deleteSurroundingText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        ash.ime.mojom.InputMethodHost_ReplaceSurroundingText_ParamsSpec.$,
        null,
        impl.replaceSurroundingText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ash.ime.mojom.InputMethodHost_HandleAutocorrect_ParamsSpec.$,
        null,
        impl.handleAutocorrect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ash.ime.mojom.InputMethodHost_DisplaySuggestions_ParamsSpec.$,
        null,
        impl.displaySuggestions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        ash.ime.mojom.InputMethodHost_UpdateCandidatesWindow_ParamsSpec.$,
        null,
        impl.updateCandidatesWindow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ash.ime.mojom.InputMethodHost_RequestSuggestions_ParamsSpec.$,
        ash.ime.mojom.InputMethodHost_RequestSuggestions_ResponseParamsSpec.$,
        impl.requestSuggestions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        ash.ime.mojom.InputMethodHost_UpdateQuickSettings_ParamsSpec.$,
        null,
        impl.updateQuickSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        ash.ime.mojom.InputMethodHost_RecordUkm_ParamsSpec.$,
        null,
        impl.recordUkm.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        ash.ime.mojom.InputMethodHost_DEPRECATED_ReportKoreanAction_ParamsSpec.$,
        null,
        impl.dEPRECATEDReportKoreanAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        ash.ime.mojom.InputMethodHost_DEPRECATED_ReportKoreanSettings_ParamsSpec.$,
        null,
        impl.dEPRECATEDReportKoreanSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        ash.ime.mojom.InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_ParamsSpec.$,
        null,
        impl.dEPRECATEDReportSuggestionOpportunity.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        ash.ime.mojom.InputMethodHost_DEPRECATED_ReportHistogramSample_ParamsSpec.$,
        null,
        impl.dEPRECATEDReportHistogramSample.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.ime.mojom.InputMethodHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.InputMethodHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.ime.mojom.InputMethodHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.ime.mojom.InputMethodHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the InputMethodHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.ime.mojom.InputMethodHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.ime.mojom.InputMethodHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.InputMethodHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.commitText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.InputMethodHost_CommitText_ParamsSpec.$,
        null,
        this.commitText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dEPRECATEDSetComposition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.ime.mojom.InputMethodHost_DEPRECATED_SetComposition_ParamsSpec.$,
        null,
        this.dEPRECATEDSetComposition.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setComposition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        ash.ime.mojom.InputMethodHost_SetComposition_ParamsSpec.$,
        null,
        this.setComposition.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCompositionRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.ime.mojom.InputMethodHost_SetCompositionRange_ParamsSpec.$,
        null,
        this.setCompositionRange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.finishComposition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ash.ime.mojom.InputMethodHost_FinishComposition_ParamsSpec.$,
        null,
        this.finishComposition.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteSurroundingText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ash.ime.mojom.InputMethodHost_DeleteSurroundingText_ParamsSpec.$,
        null,
        this.deleteSurroundingText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replaceSurroundingText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        ash.ime.mojom.InputMethodHost_ReplaceSurroundingText_ParamsSpec.$,
        null,
        this.replaceSurroundingText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.handleAutocorrect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ash.ime.mojom.InputMethodHost_HandleAutocorrect_ParamsSpec.$,
        null,
        this.handleAutocorrect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.displaySuggestions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ash.ime.mojom.InputMethodHost_DisplaySuggestions_ParamsSpec.$,
        null,
        this.displaySuggestions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateCandidatesWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        ash.ime.mojom.InputMethodHost_UpdateCandidatesWindow_ParamsSpec.$,
        null,
        this.updateCandidatesWindow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestSuggestions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ash.ime.mojom.InputMethodHost_RequestSuggestions_ParamsSpec.$,
        ash.ime.mojom.InputMethodHost_RequestSuggestions_ResponseParamsSpec.$,
        this.requestSuggestions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateQuickSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        ash.ime.mojom.InputMethodHost_UpdateQuickSettings_ParamsSpec.$,
        null,
        this.updateQuickSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.recordUkm =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        ash.ime.mojom.InputMethodHost_RecordUkm_ParamsSpec.$,
        null,
        this.recordUkm.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dEPRECATEDReportKoreanAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        ash.ime.mojom.InputMethodHost_DEPRECATED_ReportKoreanAction_ParamsSpec.$,
        null,
        this.dEPRECATEDReportKoreanAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dEPRECATEDReportKoreanSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        ash.ime.mojom.InputMethodHost_DEPRECATED_ReportKoreanSettings_ParamsSpec.$,
        null,
        this.dEPRECATEDReportKoreanSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dEPRECATEDReportSuggestionOpportunity =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        ash.ime.mojom.InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_ParamsSpec.$,
        null,
        this.dEPRECATEDReportSuggestionOpportunity.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dEPRECATEDReportHistogramSample =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        ash.ime.mojom.InputMethodHost_DEPRECATED_ReportHistogramSample_ParamsSpec.$,
        null,
        this.dEPRECATEDReportHistogramSample.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.CompositionSpanSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.TextRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.AutocorrectSpanSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.CompletionCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.SuggestionsRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.SuggestionsResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.SuggestionsTextContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.NonCompliantApiMetricSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.CandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.HighlightedCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.CandidatesWindowSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.BucketedHistogramSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_CommitText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_DEPRECATED_SetComposition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_SetComposition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_SetCompositionRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_FinishComposition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_DeleteSurroundingText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_ReplaceSurroundingText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_HandleAutocorrect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_DisplaySuggestions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_UpdateCandidatesWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_RequestSuggestions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_RequestSuggestions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_UpdateQuickSettings_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_RecordUkm_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_DEPRECATED_ReportKoreanAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_DEPRECATED_ReportKoreanSettings_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodHost_DEPRECATED_ReportHistogramSample_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.UkmEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ash.ime.mojom.CompositionSpanSpec.$,
    'CompositionSpan',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'style', 8,
        0,
        ash.ime.mojom.CompositionSpanStyleSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.ime.mojom.CompositionSpan = class {
  constructor() {
    /** @export { !number } */
    this.start;
    /** @export { !number } */
    this.end;
    /** @export { !ash.ime.mojom.CompositionSpanStyle } */
    this.style;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.TextRangeSpec.$,
    'TextRange',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.ime.mojom.TextRange = class {
  constructor() {
    /** @export { !number } */
    this.start;
    /** @export { !number } */
    this.end;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.AutocorrectSpanSpec.$,
    'AutocorrectSpan',
    [
      mojo.internal.StructField(
        'autocorrectRange', 0,
        0,
        ash.ime.mojom.TextRangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'originalText', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentText', 16,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
ash.ime.mojom.AutocorrectSpan = class {
  constructor() {
    /** @export { !ash.ime.mojom.TextRange } */
    this.autocorrectRange;
    /** @export { !mojoBase.mojom.String16 } */
    this.originalText;
    /** @export { !mojoBase.mojom.String16 } */
    this.currentText;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.CompletionCandidateSpec.$,
    'CompletionCandidate',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'normalizedScore', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.ime.mojom.CompletionCandidate = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { !number } */
    this.normalizedScore;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.SuggestionsRequestSpec.$,
    'SuggestionsRequest',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        ash.ime.mojom.SuggestionModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'completionCandidates', 16,
        0,
        mojo.internal.Array(ash.ime.mojom.CompletionCandidateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
ash.ime.mojom.SuggestionsRequest = class {
  constructor() {
    /** @export { !ash.ime.mojom.SuggestionMode } */
    this.mode;
    /** @export { !string } */
    this.text;
    /** @export { !Array<!ash.ime.mojom.CompletionCandidate> } */
    this.completionCandidates;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.SuggestionsResponseSpec.$,
    'SuggestionsResponse',
    [
      mojo.internal.StructField(
        'candidates', 0,
        0,
        mojo.internal.Array(ash.ime.mojom.SuggestionCandidateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.ime.mojom.SuggestionsResponse = class {
  constructor() {
    /** @export { !Array<!ash.ime.mojom.SuggestionCandidate> } */
    this.candidates;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.SuggestionsTextContextSpec.$,
    'SuggestionsTextContext',
    [
      mojo.internal.StructField(
        'lastNChars', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'surroundingTextLength', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.ime.mojom.SuggestionsTextContext = class {
  constructor() {
    /** @export { !string } */
    this.lastNChars;
    /** @export { !number } */
    this.surroundingTextLength;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.NonCompliantApiMetricSpec.$,
    'NonCompliantApiMetric',
    [
      mojo.internal.StructField(
        'nonCompliantOperation', 0,
        0,
        ash.ime.mojom.InputMethodApiOperationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.ime.mojom.NonCompliantApiMetric = class {
  constructor() {
    /** @export { !ash.ime.mojom.InputMethodApiOperation } */
    this.nonCompliantOperation;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.CandidateSpec.$,
    'Candidate',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'annotation', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
ash.ime.mojom.Candidate = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { (string|undefined) } */
    this.label;
    /** @export { (string|undefined) } */
    this.annotation;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.HighlightedCandidateSpec.$,
    'HighlightedCandidate',
    [
      mojo.internal.StructField(
        'index', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.ime.mojom.HighlightedCandidate = class {
  constructor() {
    /** @export { !number } */
    this.index;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.CandidatesWindowSpec.$,
    'CandidatesWindow',
    [
      mojo.internal.StructField(
        'candidates', 0,
        0,
        mojo.internal.Array(ash.ime.mojom.CandidateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dEPRECATEDHighlightedCandidate', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'auxiliaryText', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'highlightedCandidate', 24,
        0,
        ash.ime.mojom.HighlightedCandidateSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[4, 32],[6, 40],]);





/** @record */
ash.ime.mojom.CandidatesWindow = class {
  constructor() {
    /** @export { !Array<!ash.ime.mojom.Candidate> } */
    this.candidates;
    /** @export { !number } */
    this.dEPRECATEDHighlightedCandidate;
    /** @export { (string|undefined) } */
    this.auxiliaryText;
    /** @export { (ash.ime.mojom.HighlightedCandidate|undefined) } */
    this.highlightedCandidate;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.BucketedHistogramSpec.$,
    'BucketedHistogram',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bucketType', 8,
        0,
        ash.ime.mojom.HistogramBucketTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'minimum', 12,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maximum', 14,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bucketCount', 16,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
ash.ime.mojom.BucketedHistogram = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !ash.ime.mojom.HistogramBucketType } */
    this.bucketType;
    /** @export { !number } */
    this.minimum;
    /** @export { !number } */
    this.maximum;
    /** @export { !number } */
    this.bucketCount;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_CommitText_ParamsSpec.$,
    'InputMethodHost_CommitText_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cursorBehavior', 8,
        0,
        ash.ime.mojom.CommitTextCursorBehaviorSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.ime.mojom.InputMethodHost_CommitText_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.text;
    /** @export { !ash.ime.mojom.CommitTextCursorBehavior } */
    this.cursorBehavior;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_DEPRECATED_SetComposition_ParamsSpec.$,
    'InputMethodHost_DEPRECATED_SetComposition_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'spans', 8,
        0,
        mojo.internal.Array(ash.ime.mojom.CompositionSpanSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.ime.mojom.InputMethodHost_DEPRECATED_SetComposition_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.text;
    /** @export { !Array<!ash.ime.mojom.CompositionSpan> } */
    this.spans;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_SetComposition_ParamsSpec.$,
    'InputMethodHost_SetComposition_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'spans', 8,
        0,
        mojo.internal.Array(ash.ime.mojom.CompositionSpanSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newCursorPosition', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
ash.ime.mojom.InputMethodHost_SetComposition_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.text;
    /** @export { !Array<!ash.ime.mojom.CompositionSpan> } */
    this.spans;
    /** @export { !number } */
    this.newCursorPosition;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_SetCompositionRange_ParamsSpec.$,
    'InputMethodHost_SetCompositionRange_Params',
    [
      mojo.internal.StructField(
        'startIndex', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endIndex', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.ime.mojom.InputMethodHost_SetCompositionRange_Params = class {
  constructor() {
    /** @export { !number } */
    this.startIndex;
    /** @export { !number } */
    this.endIndex;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_FinishComposition_ParamsSpec.$,
    'InputMethodHost_FinishComposition_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.ime.mojom.InputMethodHost_FinishComposition_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_DeleteSurroundingText_ParamsSpec.$,
    'InputMethodHost_DeleteSurroundingText_Params',
    [
      mojo.internal.StructField(
        'numBeforeCursor', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numAfterCursor', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.ime.mojom.InputMethodHost_DeleteSurroundingText_Params = class {
  constructor() {
    /** @export { !number } */
    this.numBeforeCursor;
    /** @export { !number } */
    this.numAfterCursor;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_ReplaceSurroundingText_ParamsSpec.$,
    'InputMethodHost_ReplaceSurroundingText_Params',
    [
      mojo.internal.StructField(
        'numBeforeCursor', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numAfterCursor', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.ime.mojom.InputMethodHost_ReplaceSurroundingText_Params = class {
  constructor() {
    /** @export { !number } */
    this.numBeforeCursor;
    /** @export { !number } */
    this.numAfterCursor;
    /** @export { !mojoBase.mojom.String16 } */
    this.text;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_HandleAutocorrect_ParamsSpec.$,
    'InputMethodHost_HandleAutocorrect_Params',
    [
      mojo.internal.StructField(
        'autocorrectSpan', 0,
        0,
        ash.ime.mojom.AutocorrectSpanSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.ime.mojom.InputMethodHost_HandleAutocorrect_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.AutocorrectSpan } */
    this.autocorrectSpan;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_DisplaySuggestions_ParamsSpec.$,
    'InputMethodHost_DisplaySuggestions_Params',
    [
      mojo.internal.StructField(
        'suggestions', 0,
        0,
        mojo.internal.Array(ash.ime.mojom.SuggestionCandidateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        ash.ime.mojom.SuggestionsTextContextSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[10, 24],]);





/** @record */
ash.ime.mojom.InputMethodHost_DisplaySuggestions_Params = class {
  constructor() {
    /** @export { !Array<!ash.ime.mojom.SuggestionCandidate> } */
    this.suggestions;
    /** @export { (ash.ime.mojom.SuggestionsTextContext|undefined) } */
    this.context;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_UpdateCandidatesWindow_ParamsSpec.$,
    'InputMethodHost_UpdateCandidatesWindow_Params',
    [
      mojo.internal.StructField(
        'window', 0,
        0,
        ash.ime.mojom.CandidatesWindowSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.ime.mojom.InputMethodHost_UpdateCandidatesWindow_Params = class {
  constructor() {
    /** @export { (ash.ime.mojom.CandidatesWindow|undefined) } */
    this.window;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_RequestSuggestions_ParamsSpec.$,
    'InputMethodHost_RequestSuggestions_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        ash.ime.mojom.SuggestionsRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.ime.mojom.InputMethodHost_RequestSuggestions_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.SuggestionsRequest } */
    this.request;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_RequestSuggestions_ResponseParamsSpec.$,
    'InputMethodHost_RequestSuggestions_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        ash.ime.mojom.SuggestionsResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.ime.mojom.InputMethodHost_RequestSuggestions_ResponseParams = class {
  constructor() {
    /** @export { !ash.ime.mojom.SuggestionsResponse } */
    this.response;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_UpdateQuickSettings_ParamsSpec.$,
    'InputMethodHost_UpdateQuickSettings_Params',
    [
      mojo.internal.StructField(
        'settings', 0,
        0,
        ash.ime.mojom.InputMethodQuickSettingsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.ime.mojom.InputMethodHost_UpdateQuickSettings_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.InputMethodQuickSettings } */
    this.settings;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_RecordUkm_ParamsSpec.$,
    'InputMethodHost_RecordUkm_Params',
    [
      mojo.internal.StructField(
        'entry', 0,
        0,
        ash.ime.mojom.UkmEntrySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.ime.mojom.InputMethodHost_RecordUkm_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.UkmEntry } */
    this.entry;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_DEPRECATED_ReportKoreanAction_ParamsSpec.$,
    'InputMethodHost_DEPRECATED_ReportKoreanAction_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        ash.ime.mojom.KoreanActionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.ime.mojom.InputMethodHost_DEPRECATED_ReportKoreanAction_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.KoreanAction } */
    this.action;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_DEPRECATED_ReportKoreanSettings_ParamsSpec.$,
    'InputMethodHost_DEPRECATED_ReportKoreanSettings_Params',
    [
      mojo.internal.StructField(
        'settings', 0,
        0,
        ash.ime.mojom.KoreanSettingsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.ime.mojom.InputMethodHost_DEPRECATED_ReportKoreanSettings_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.KoreanSettings } */
    this.settings;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_ParamsSpec.$,
    'InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        ash.ime.mojom.SuggestionModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.ime.mojom.InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.SuggestionMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodHost_DEPRECATED_ReportHistogramSample_ParamsSpec.$,
    'InputMethodHost_DEPRECATED_ReportHistogramSample_Params',
    [
      mojo.internal.StructField(
        'histogram', 0,
        0,
        ash.ime.mojom.BucketedHistogramSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.ime.mojom.InputMethodHost_DEPRECATED_ReportHistogramSample_Params = class {
  constructor() {
    /** @export { !ash.ime.mojom.BucketedHistogram } */
    this.histogram;
    /** @export { !number } */
    this.value;
  }
};



mojo.internal.Union(
    ash.ime.mojom.UkmEntrySpec.$, 'UkmEntry',
    {
      'nonCompliantApi': {
        'ordinal': 0,
        'type': ash.ime.mojom.NonCompliantApiMetricSpec.$,
      },
    });

/**
 * @typedef { {
 *   nonCompliantApi: (!ash.ime.mojom.NonCompliantApiMetric|undefined),
 * } }
 */
ash.ime.mojom.UkmEntry;
