// chromeos/ash/services/ime/public/mojom/input_method_host.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/ash/services/ime/public/mojom/input_method_host.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ash.ime.mojom');
  var input_method$ =
      mojo.internal.exposeNamespace('ash.ime.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/ash/services/ime/public/mojom/input_method.mojom', 'input_method.mojom.js');
  }
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../../mojo/public/mojom/base/string16.mojom.js');
  }


  var CommitTextCursorBehavior = {};
  CommitTextCursorBehavior.kMoveCursorAfterText = 0;
  CommitTextCursorBehavior.kMoveCursorBeforeText = 1;
  CommitTextCursorBehavior.MIN_VALUE = 0;
  CommitTextCursorBehavior.MAX_VALUE = 1;
  CommitTextCursorBehavior.DEFAULT_VALUE = 0;

  CommitTextCursorBehavior.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  CommitTextCursorBehavior.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  CommitTextCursorBehavior.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CompositionSpanStyle = {};
  CompositionSpanStyle.kDefault = 0;
  CompositionSpanStyle.kNone = 1;
  CompositionSpanStyle.kHighlight = 2;
  CompositionSpanStyle.MIN_VALUE = 0;
  CompositionSpanStyle.MAX_VALUE = 2;
  CompositionSpanStyle.DEFAULT_VALUE = 0;

  CompositionSpanStyle.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CompositionSpanStyle.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  CompositionSpanStyle.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var InputMethodApiOperation = {};
  InputMethodApiOperation.kUnknown = 0;
  InputMethodApiOperation.kCommitText = 1;
  InputMethodApiOperation.kSetCompositionText = 2;
  InputMethodApiOperation.kDeleteSurroundingText = 3;
  InputMethodApiOperation.kReplaceSurroundingText = 4;
  InputMethodApiOperation.MIN_VALUE = 0;
  InputMethodApiOperation.MAX_VALUE = 4;
  InputMethodApiOperation.DEFAULT_VALUE = 0;

  InputMethodApiOperation.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  InputMethodApiOperation.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  InputMethodApiOperation.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var KoreanAction = {};
  KoreanAction.kUnknown = 0;
  KoreanAction.kHanjaKey = 1;
  KoreanAction.kHangeulKey = 2;
  KoreanAction.kComposeOutOfOrder = 3;
  KoreanAction.MIN_VALUE = 0;
  KoreanAction.MAX_VALUE = 3;
  KoreanAction.DEFAULT_VALUE = 0;

  KoreanAction.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  KoreanAction.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  KoreanAction.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var HistogramBucketType = {};
  HistogramBucketType.kExponential = 0;
  HistogramBucketType.kLinear = 1;
  HistogramBucketType.MIN_VALUE = 0;
  HistogramBucketType.MAX_VALUE = 1;
  HistogramBucketType.DEFAULT_VALUE = 0;

  HistogramBucketType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  HistogramBucketType.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  HistogramBucketType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function CompositionSpan(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositionSpan.prototype.initDefaults_ = function() {
    this.start = 0;
    this.end = 0;
    this.style = 0;
  };
  CompositionSpan.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositionSpan.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate CompositionSpan.style
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, CompositionSpanStyle);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CompositionSpan.encodedSize = codec.kStructHeaderSize + 16;

  CompositionSpan.decode = function(decoder) {
    var packed;
    var val = new CompositionSpan();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.start =
        decoder.decodeStruct(codec.Uint32);
    val.end =
        decoder.decodeStruct(codec.Uint32);
    val.style =
        decoder.decodeStruct(new codec.Enum(CompositionSpanStyle));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CompositionSpan.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositionSpan.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.start);
    encoder.encodeStruct(codec.Uint32, val.end);
    encoder.encodeStruct(codec.Int32, val.style);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TextRange(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextRange.prototype.initDefaults_ = function() {
    this.start = 0;
    this.end = 0;
  };
  TextRange.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextRange.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  TextRange.encodedSize = codec.kStructHeaderSize + 8;

  TextRange.decode = function(decoder) {
    var packed;
    var val = new TextRange();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.start =
        decoder.decodeStruct(codec.Uint32);
    val.end =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  TextRange.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextRange.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.start);
    encoder.encodeStruct(codec.Uint32, val.end);
  };
  function AutocorrectSpan(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AutocorrectSpan.prototype.initDefaults_ = function() {
    this.autocorrectRange = null;
    this.originalText = null;
    this.currentText = null;
  };
  AutocorrectSpan.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AutocorrectSpan.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AutocorrectSpan.autocorrectRange
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, TextRange, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AutocorrectSpan.originalText
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AutocorrectSpan.currentText
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AutocorrectSpan.encodedSize = codec.kStructHeaderSize + 24;

  AutocorrectSpan.decode = function(decoder) {
    var packed;
    var val = new AutocorrectSpan();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.autocorrectRange =
        decoder.decodeStructPointer(TextRange);
    val.originalText =
        decoder.decodeStructPointer(string16$.String16);
    val.currentText =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  AutocorrectSpan.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AutocorrectSpan.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(TextRange, val.autocorrectRange);
    encoder.encodeStructPointer(string16$.String16, val.originalText);
    encoder.encodeStructPointer(string16$.String16, val.currentText);
  };
  function CompletionCandidate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompletionCandidate.prototype.initDefaults_ = function() {
    this.text = null;
    this.normalizedScore = 0;
  };
  CompletionCandidate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompletionCandidate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompletionCandidate.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CompletionCandidate.encodedSize = codec.kStructHeaderSize + 16;

  CompletionCandidate.decode = function(decoder) {
    var packed;
    var val = new CompletionCandidate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.normalizedScore =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CompletionCandidate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompletionCandidate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStruct(codec.Float, val.normalizedScore);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SuggestionsRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SuggestionsRequest.prototype.initDefaults_ = function() {
    this.mode = 0;
    this.text = null;
    this.completionCandidates = null;
  };
  SuggestionsRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SuggestionsRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SuggestionsRequest.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, input_method$.SuggestionMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SuggestionsRequest.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SuggestionsRequest.completionCandidates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(CompletionCandidate), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SuggestionsRequest.encodedSize = codec.kStructHeaderSize + 24;

  SuggestionsRequest.decode = function(decoder) {
    var packed;
    var val = new SuggestionsRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(input_method$.SuggestionMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.text =
        decoder.decodeStruct(codec.String);
    val.completionCandidates =
        decoder.decodeArrayPointer(new codec.PointerTo(CompletionCandidate));
    return val;
  };

  SuggestionsRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SuggestionsRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeArrayPointer(new codec.PointerTo(CompletionCandidate), val.completionCandidates);
  };
  function SuggestionsResponse(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SuggestionsResponse.prototype.initDefaults_ = function() {
    this.candidates = null;
  };
  SuggestionsResponse.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SuggestionsResponse.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SuggestionsResponse.candidates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(input_method$.SuggestionCandidate), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SuggestionsResponse.encodedSize = codec.kStructHeaderSize + 8;

  SuggestionsResponse.decode = function(decoder) {
    var packed;
    var val = new SuggestionsResponse();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.candidates =
        decoder.decodeArrayPointer(new codec.PointerTo(input_method$.SuggestionCandidate));
    return val;
  };

  SuggestionsResponse.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SuggestionsResponse.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(input_method$.SuggestionCandidate), val.candidates);
  };
  function SuggestionsTextContext(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SuggestionsTextContext.prototype.initDefaults_ = function() {
    this.lastNChars = null;
    this.surroundingTextLength = 0;
  };
  SuggestionsTextContext.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SuggestionsTextContext.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SuggestionsTextContext.lastNChars
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SuggestionsTextContext.encodedSize = codec.kStructHeaderSize + 16;

  SuggestionsTextContext.decode = function(decoder) {
    var packed;
    var val = new SuggestionsTextContext();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lastNChars =
        decoder.decodeStruct(codec.String);
    val.surroundingTextLength =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SuggestionsTextContext.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SuggestionsTextContext.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.lastNChars);
    encoder.encodeStruct(codec.Uint32, val.surroundingTextLength);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NonCompliantApiMetric(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NonCompliantApiMetric.prototype.initDefaults_ = function() {
    this.nonCompliantOperation = 0;
  };
  NonCompliantApiMetric.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NonCompliantApiMetric.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NonCompliantApiMetric.nonCompliantOperation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, InputMethodApiOperation);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NonCompliantApiMetric.encodedSize = codec.kStructHeaderSize + 8;

  NonCompliantApiMetric.decode = function(decoder) {
    var packed;
    var val = new NonCompliantApiMetric();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.nonCompliantOperation =
        decoder.decodeStruct(new codec.Enum(InputMethodApiOperation));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NonCompliantApiMetric.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NonCompliantApiMetric.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.nonCompliantOperation);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Candidate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Candidate.prototype.initDefaults_ = function() {
    this.text = null;
    this.label = null;
    this.annotation = null;
  };
  Candidate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Candidate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Candidate.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate Candidate.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate Candidate.annotation
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Candidate.encodedSize = codec.kStructHeaderSize + 24;

  Candidate.decode = function(decoder) {
    var packed;
    var val = new Candidate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.label =
        decoder.decodeStruct(codec.String);
    val.annotation =
        decoder.decodeStruct(codec.String);
    return val;
  };

  Candidate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Candidate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeStruct(codec.String, val.annotation);
  };
  function HighlightedCandidate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HighlightedCandidate.prototype.initDefaults_ = function() {
    this.index = 0;
  };
  HighlightedCandidate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HighlightedCandidate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  HighlightedCandidate.encodedSize = codec.kStructHeaderSize + 8;

  HighlightedCandidate.decode = function(decoder) {
    var packed;
    var val = new HighlightedCandidate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.index =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  HighlightedCandidate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HighlightedCandidate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.index);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CandidatesWindow(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CandidatesWindow.prototype.initDefaults_ = function() {
    this.candidates = null;
    this.dEPRECATEDHighlightedCandidate = 0;
    this.auxiliaryText = null;
    this.highlightedCandidate = null;
  };
  CandidatesWindow.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CandidatesWindow.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 4, numBytes: 32},
      {version: 6, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CandidatesWindow.candidates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(Candidate), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;




    // version check CandidatesWindow.auxiliaryText
    if (!messageValidator.isFieldInStructVersion(offset, 4))
      return validator.validationError.NONE;
    // validate CandidatesWindow.auxiliaryText
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;



    // version check CandidatesWindow.highlightedCandidate
    if (!messageValidator.isFieldInStructVersion(offset, 6))
      return validator.validationError.NONE;
    // validate CandidatesWindow.highlightedCandidate
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, HighlightedCandidate, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CandidatesWindow.encodedSize = codec.kStructHeaderSize + 32;

  CandidatesWindow.decode = function(decoder) {
    var packed;
    var val = new CandidatesWindow();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.candidates =
        decoder.decodeArrayPointer(new codec.PointerTo(Candidate));
    val.dEPRECATEDHighlightedCandidate =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 4) {
      val.auxiliaryText =
          decoder.decodeStruct(codec.String);
    } else {
      val.auxiliaryText = null;
    }
    if (version >= 6) {
      val.highlightedCandidate =
          decoder.decodeStructPointer(HighlightedCandidate);
    } else {
      val.highlightedCandidate = null;
    }
    return val;
  };

  CandidatesWindow.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CandidatesWindow.encodedSize);
    encoder.writeUint32(6);
    encoder.encodeArrayPointer(new codec.PointerTo(Candidate), val.candidates);
    encoder.encodeStruct(codec.Uint32, val.dEPRECATEDHighlightedCandidate);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.auxiliaryText);
    encoder.encodeStructPointer(HighlightedCandidate, val.highlightedCandidate);
  };
  function BucketedHistogram(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BucketedHistogram.prototype.initDefaults_ = function() {
    this.name = null;
    this.bucketType = 0;
    this.minimum = 0;
    this.maximum = 0;
    this.bucketCount = 0;
  };
  BucketedHistogram.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BucketedHistogram.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketedHistogram.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BucketedHistogram.bucketType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, HistogramBucketType);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  BucketedHistogram.encodedSize = codec.kStructHeaderSize + 24;

  BucketedHistogram.decode = function(decoder) {
    var packed;
    var val = new BucketedHistogram();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.bucketType =
        decoder.decodeStruct(new codec.Enum(HistogramBucketType));
    val.minimum =
        decoder.decodeStruct(codec.Uint16);
    val.maximum =
        decoder.decodeStruct(codec.Uint16);
    val.bucketCount =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BucketedHistogram.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BucketedHistogram.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.Int32, val.bucketType);
    encoder.encodeStruct(codec.Uint16, val.minimum);
    encoder.encodeStruct(codec.Uint16, val.maximum);
    encoder.encodeStruct(codec.Uint16, val.bucketCount);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function InputMethodHost_CommitText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_CommitText_Params.prototype.initDefaults_ = function() {
    this.text = null;
    this.cursorBehavior = 0;
  };
  InputMethodHost_CommitText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_CommitText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_CommitText_Params.text
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_CommitText_Params.cursorBehavior
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, CommitTextCursorBehavior);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_CommitText_Params.encodedSize = codec.kStructHeaderSize + 16;

  InputMethodHost_CommitText_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_CommitText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStructPointer(string16$.String16);
    val.cursorBehavior =
        decoder.decodeStruct(new codec.Enum(CommitTextCursorBehavior));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InputMethodHost_CommitText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_CommitText_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.text);
    encoder.encodeStruct(codec.Int32, val.cursorBehavior);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function InputMethodHost_DEPRECATED_SetComposition_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_DEPRECATED_SetComposition_Params.prototype.initDefaults_ = function() {
    this.text = null;
    this.spans = null;
  };
  InputMethodHost_DEPRECATED_SetComposition_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_DEPRECATED_SetComposition_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_DEPRECATED_SetComposition_Params.text
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_DEPRECATED_SetComposition_Params.spans
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(CompositionSpan), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_DEPRECATED_SetComposition_Params.encodedSize = codec.kStructHeaderSize + 16;

  InputMethodHost_DEPRECATED_SetComposition_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_DEPRECATED_SetComposition_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStructPointer(string16$.String16);
    val.spans =
        decoder.decodeArrayPointer(new codec.PointerTo(CompositionSpan));
    return val;
  };

  InputMethodHost_DEPRECATED_SetComposition_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_DEPRECATED_SetComposition_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.text);
    encoder.encodeArrayPointer(new codec.PointerTo(CompositionSpan), val.spans);
  };
  function InputMethodHost_SetComposition_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_SetComposition_Params.prototype.initDefaults_ = function() {
    this.text = null;
    this.spans = null;
    this.newCursorPosition = 0;
  };
  InputMethodHost_SetComposition_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_SetComposition_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_SetComposition_Params.text
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_SetComposition_Params.spans
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(CompositionSpan), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  InputMethodHost_SetComposition_Params.encodedSize = codec.kStructHeaderSize + 24;

  InputMethodHost_SetComposition_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_SetComposition_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStructPointer(string16$.String16);
    val.spans =
        decoder.decodeArrayPointer(new codec.PointerTo(CompositionSpan));
    val.newCursorPosition =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InputMethodHost_SetComposition_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_SetComposition_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.text);
    encoder.encodeArrayPointer(new codec.PointerTo(CompositionSpan), val.spans);
    encoder.encodeStruct(codec.Uint32, val.newCursorPosition);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function InputMethodHost_SetCompositionRange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_SetCompositionRange_Params.prototype.initDefaults_ = function() {
    this.startIndex = 0;
    this.endIndex = 0;
  };
  InputMethodHost_SetCompositionRange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_SetCompositionRange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  InputMethodHost_SetCompositionRange_Params.encodedSize = codec.kStructHeaderSize + 8;

  InputMethodHost_SetCompositionRange_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_SetCompositionRange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startIndex =
        decoder.decodeStruct(codec.Uint32);
    val.endIndex =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  InputMethodHost_SetCompositionRange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_SetCompositionRange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.startIndex);
    encoder.encodeStruct(codec.Uint32, val.endIndex);
  };
  function InputMethodHost_FinishComposition_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_FinishComposition_Params.prototype.initDefaults_ = function() {
  };
  InputMethodHost_FinishComposition_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_FinishComposition_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_FinishComposition_Params.encodedSize = codec.kStructHeaderSize + 0;

  InputMethodHost_FinishComposition_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_FinishComposition_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  InputMethodHost_FinishComposition_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_FinishComposition_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function InputMethodHost_DeleteSurroundingText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_DeleteSurroundingText_Params.prototype.initDefaults_ = function() {
    this.numBeforeCursor = 0;
    this.numAfterCursor = 0;
  };
  InputMethodHost_DeleteSurroundingText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_DeleteSurroundingText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  InputMethodHost_DeleteSurroundingText_Params.encodedSize = codec.kStructHeaderSize + 8;

  InputMethodHost_DeleteSurroundingText_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_DeleteSurroundingText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.numBeforeCursor =
        decoder.decodeStruct(codec.Uint32);
    val.numAfterCursor =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  InputMethodHost_DeleteSurroundingText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_DeleteSurroundingText_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.numBeforeCursor);
    encoder.encodeStruct(codec.Uint32, val.numAfterCursor);
  };
  function InputMethodHost_ReplaceSurroundingText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_ReplaceSurroundingText_Params.prototype.initDefaults_ = function() {
    this.numBeforeCursor = 0;
    this.numAfterCursor = 0;
    this.text = null;
  };
  InputMethodHost_ReplaceSurroundingText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_ReplaceSurroundingText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate InputMethodHost_ReplaceSurroundingText_Params.text
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_ReplaceSurroundingText_Params.encodedSize = codec.kStructHeaderSize + 16;

  InputMethodHost_ReplaceSurroundingText_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_ReplaceSurroundingText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.numBeforeCursor =
        decoder.decodeStruct(codec.Uint32);
    val.numAfterCursor =
        decoder.decodeStruct(codec.Uint32);
    val.text =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  InputMethodHost_ReplaceSurroundingText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_ReplaceSurroundingText_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.numBeforeCursor);
    encoder.encodeStruct(codec.Uint32, val.numAfterCursor);
    encoder.encodeStructPointer(string16$.String16, val.text);
  };
  function InputMethodHost_HandleAutocorrect_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_HandleAutocorrect_Params.prototype.initDefaults_ = function() {
    this.autocorrectSpan = null;
  };
  InputMethodHost_HandleAutocorrect_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_HandleAutocorrect_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_HandleAutocorrect_Params.autocorrectSpan
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AutocorrectSpan, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_HandleAutocorrect_Params.encodedSize = codec.kStructHeaderSize + 8;

  InputMethodHost_HandleAutocorrect_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_HandleAutocorrect_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.autocorrectSpan =
        decoder.decodeStructPointer(AutocorrectSpan);
    return val;
  };

  InputMethodHost_HandleAutocorrect_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_HandleAutocorrect_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AutocorrectSpan, val.autocorrectSpan);
  };
  function InputMethodHost_DisplaySuggestions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_DisplaySuggestions_Params.prototype.initDefaults_ = function() {
    this.suggestions = null;
    this.context = null;
  };
  InputMethodHost_DisplaySuggestions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_DisplaySuggestions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 10, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_DisplaySuggestions_Params.suggestions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(input_method$.SuggestionCandidate), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // version check InputMethodHost_DisplaySuggestions_Params.context
    if (!messageValidator.isFieldInStructVersion(offset, 10))
      return validator.validationError.NONE;
    // validate InputMethodHost_DisplaySuggestions_Params.context
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, SuggestionsTextContext, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_DisplaySuggestions_Params.encodedSize = codec.kStructHeaderSize + 16;

  InputMethodHost_DisplaySuggestions_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_DisplaySuggestions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.suggestions =
        decoder.decodeArrayPointer(new codec.PointerTo(input_method$.SuggestionCandidate));
    if (version >= 10) {
      val.context =
          decoder.decodeStructPointer(SuggestionsTextContext);
    } else {
      val.context = null;
    }
    return val;
  };

  InputMethodHost_DisplaySuggestions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_DisplaySuggestions_Params.encodedSize);
    encoder.writeUint32(10);
    encoder.encodeArrayPointer(new codec.PointerTo(input_method$.SuggestionCandidate), val.suggestions);
    encoder.encodeStructPointer(SuggestionsTextContext, val.context);
  };
  function InputMethodHost_UpdateCandidatesWindow_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_UpdateCandidatesWindow_Params.prototype.initDefaults_ = function() {
    this.window = null;
  };
  InputMethodHost_UpdateCandidatesWindow_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_UpdateCandidatesWindow_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_UpdateCandidatesWindow_Params.window
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, CandidatesWindow, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_UpdateCandidatesWindow_Params.encodedSize = codec.kStructHeaderSize + 8;

  InputMethodHost_UpdateCandidatesWindow_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_UpdateCandidatesWindow_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.window =
        decoder.decodeStructPointer(CandidatesWindow);
    return val;
  };

  InputMethodHost_UpdateCandidatesWindow_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_UpdateCandidatesWindow_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(CandidatesWindow, val.window);
  };
  function InputMethodHost_RequestSuggestions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_RequestSuggestions_Params.prototype.initDefaults_ = function() {
    this.request = null;
  };
  InputMethodHost_RequestSuggestions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_RequestSuggestions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_RequestSuggestions_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SuggestionsRequest, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_RequestSuggestions_Params.encodedSize = codec.kStructHeaderSize + 8;

  InputMethodHost_RequestSuggestions_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_RequestSuggestions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(SuggestionsRequest);
    return val;
  };

  InputMethodHost_RequestSuggestions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_RequestSuggestions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SuggestionsRequest, val.request);
  };
  function InputMethodHost_RequestSuggestions_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_RequestSuggestions_ResponseParams.prototype.initDefaults_ = function() {
    this.response = null;
  };
  InputMethodHost_RequestSuggestions_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_RequestSuggestions_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_RequestSuggestions_ResponseParams.response
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SuggestionsResponse, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_RequestSuggestions_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  InputMethodHost_RequestSuggestions_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_RequestSuggestions_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.response =
        decoder.decodeStructPointer(SuggestionsResponse);
    return val;
  };

  InputMethodHost_RequestSuggestions_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_RequestSuggestions_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SuggestionsResponse, val.response);
  };
  function InputMethodHost_UpdateQuickSettings_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_UpdateQuickSettings_Params.prototype.initDefaults_ = function() {
    this.settings = null;
  };
  InputMethodHost_UpdateQuickSettings_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_UpdateQuickSettings_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_UpdateQuickSettings_Params.settings
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, input_method$.InputMethodQuickSettings, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_UpdateQuickSettings_Params.encodedSize = codec.kStructHeaderSize + 16;

  InputMethodHost_UpdateQuickSettings_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_UpdateQuickSettings_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.settings =
        decoder.decodeStruct(input_method$.InputMethodQuickSettings);
    return val;
  };

  InputMethodHost_UpdateQuickSettings_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_UpdateQuickSettings_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(input_method$.InputMethodQuickSettings, val.settings);
  };
  function InputMethodHost_RecordUkm_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_RecordUkm_Params.prototype.initDefaults_ = function() {
    this.entry = null;
  };
  InputMethodHost_RecordUkm_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_RecordUkm_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_RecordUkm_Params.entry
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, UkmEntry, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_RecordUkm_Params.encodedSize = codec.kStructHeaderSize + 16;

  InputMethodHost_RecordUkm_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_RecordUkm_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.entry =
        decoder.decodeStruct(UkmEntry);
    return val;
  };

  InputMethodHost_RecordUkm_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_RecordUkm_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(UkmEntry, val.entry);
  };
  function InputMethodHost_DEPRECATED_ReportKoreanAction_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_DEPRECATED_ReportKoreanAction_Params.prototype.initDefaults_ = function() {
    this.action = 0;
  };
  InputMethodHost_DEPRECATED_ReportKoreanAction_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_DEPRECATED_ReportKoreanAction_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_DEPRECATED_ReportKoreanAction_Params.action
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, KoreanAction);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_DEPRECATED_ReportKoreanAction_Params.encodedSize = codec.kStructHeaderSize + 8;

  InputMethodHost_DEPRECATED_ReportKoreanAction_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_DEPRECATED_ReportKoreanAction_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.action =
        decoder.decodeStruct(new codec.Enum(KoreanAction));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InputMethodHost_DEPRECATED_ReportKoreanAction_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_DEPRECATED_ReportKoreanAction_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.action);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function InputMethodHost_DEPRECATED_ReportKoreanSettings_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_DEPRECATED_ReportKoreanSettings_Params.prototype.initDefaults_ = function() {
    this.settings = null;
  };
  InputMethodHost_DEPRECATED_ReportKoreanSettings_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_DEPRECATED_ReportKoreanSettings_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_DEPRECATED_ReportKoreanSettings_Params.settings
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, input_method$.KoreanSettings, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_DEPRECATED_ReportKoreanSettings_Params.encodedSize = codec.kStructHeaderSize + 8;

  InputMethodHost_DEPRECATED_ReportKoreanSettings_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_DEPRECATED_ReportKoreanSettings_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.settings =
        decoder.decodeStructPointer(input_method$.KoreanSettings);
    return val;
  };

  InputMethodHost_DEPRECATED_ReportKoreanSettings_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_DEPRECATED_ReportKoreanSettings_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(input_method$.KoreanSettings, val.settings);
  };
  function InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params.prototype.initDefaults_ = function() {
    this.mode = 0;
  };
  InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, input_method$.SuggestionMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params.encodedSize = codec.kStructHeaderSize + 8;

  InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(input_method$.SuggestionMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function InputMethodHost_DEPRECATED_ReportHistogramSample_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InputMethodHost_DEPRECATED_ReportHistogramSample_Params.prototype.initDefaults_ = function() {
    this.histogram = null;
    this.value = 0;
  };
  InputMethodHost_DEPRECATED_ReportHistogramSample_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InputMethodHost_DEPRECATED_ReportHistogramSample_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InputMethodHost_DEPRECATED_ReportHistogramSample_Params.histogram
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, BucketedHistogram, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  InputMethodHost_DEPRECATED_ReportHistogramSample_Params.encodedSize = codec.kStructHeaderSize + 16;

  InputMethodHost_DEPRECATED_ReportHistogramSample_Params.decode = function(decoder) {
    var packed;
    var val = new InputMethodHost_DEPRECATED_ReportHistogramSample_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.histogram =
        decoder.decodeStructPointer(BucketedHistogram);
    val.value =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  InputMethodHost_DEPRECATED_ReportHistogramSample_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InputMethodHost_DEPRECATED_ReportHistogramSample_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(BucketedHistogram, val.histogram);
    encoder.encodeStruct(codec.Uint16, val.value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function UkmEntry(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  UkmEntry.Tags = {
    nonCompliantApi: 0,
  };

  UkmEntry.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  UkmEntry.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "nonCompliantApi",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a UkmEntry member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(UkmEntry.prototype, "nonCompliantApi", {
    get: function() {
      if (this.$tag != UkmEntry.Tags.nonCompliantApi) {
        throw new ReferenceError(
            "UkmEntry.nonCompliantApi is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = UkmEntry.Tags.nonCompliantApi;
      this.$data = value;
    }
  });


    UkmEntry.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case UkmEntry.Tags.nonCompliantApi:
          encoder.encodeStructPointer(NonCompliantApiMetric, val.nonCompliantApi);
          break;
      }
      encoder.align();
    };


    UkmEntry.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new UkmEntry();
      var tag = decoder.readUint32();
      switch (tag) {
        case UkmEntry.Tags.nonCompliantApi:
          result.nonCompliantApi = decoder.decodeStructPointer(NonCompliantApiMetric);
          break;
      }
      decoder.align();

      return result;
    };


    UkmEntry.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case UkmEntry.Tags.nonCompliantApi:
          

    // validate UkmEntry.nonCompliantApi
    err = messageValidator.validateStructPointer(data_offset, NonCompliantApiMetric, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  UkmEntry.encodedSize = 16;
  var kInputMethodHost_CommitText_Name = 0;
  var kInputMethodHost_DEPRECATED_SetComposition_Name = 1;
  var kInputMethodHost_SetComposition_Name = 12;
  var kInputMethodHost_SetCompositionRange_Name = 2;
  var kInputMethodHost_FinishComposition_Name = 3;
  var kInputMethodHost_DeleteSurroundingText_Name = 4;
  var kInputMethodHost_ReplaceSurroundingText_Name = 16;
  var kInputMethodHost_HandleAutocorrect_Name = 5;
  var kInputMethodHost_DisplaySuggestions_Name = 6;
  var kInputMethodHost_UpdateCandidatesWindow_Name = 9;
  var kInputMethodHost_RequestSuggestions_Name = 7;
  var kInputMethodHost_UpdateQuickSettings_Name = 13;
  var kInputMethodHost_RecordUkm_Name = 8;
  var kInputMethodHost_DEPRECATED_ReportKoreanAction_Name = 10;
  var kInputMethodHost_DEPRECATED_ReportKoreanSettings_Name = 11;
  var kInputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Name = 14;
  var kInputMethodHost_DEPRECATED_ReportHistogramSample_Name = 15;

  function InputMethodHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(InputMethodHost,
                                                   handleOrPtrInfo);
  }

  function InputMethodHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        InputMethodHost, associatedInterfacePtrInfo);
  }

  InputMethodHostAssociatedPtr.prototype =
      Object.create(InputMethodHostPtr.prototype);
  InputMethodHostAssociatedPtr.prototype.constructor =
      InputMethodHostAssociatedPtr;

  function InputMethodHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  InputMethodHostPtr.prototype.commitText = function() {
    return InputMethodHostProxy.prototype.commitText
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.commitText = function(text, cursorBehavior) {
    var params_ = new InputMethodHost_CommitText_Params();
    params_.text = text;
    params_.cursorBehavior = cursorBehavior;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_CommitText_Name,
        codec.align(InputMethodHost_CommitText_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_CommitText_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.dEPRECATEDSetComposition = function() {
    return InputMethodHostProxy.prototype.dEPRECATEDSetComposition
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.dEPRECATEDSetComposition = function(text, spans) {
    var params_ = new InputMethodHost_DEPRECATED_SetComposition_Params();
    params_.text = text;
    params_.spans = spans;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_DEPRECATED_SetComposition_Name,
        codec.align(InputMethodHost_DEPRECATED_SetComposition_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_DEPRECATED_SetComposition_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.setComposition = function() {
    return InputMethodHostProxy.prototype.setComposition
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.setComposition = function(text, spans, newCursorPosition) {
    var params_ = new InputMethodHost_SetComposition_Params();
    params_.text = text;
    params_.spans = spans;
    params_.newCursorPosition = newCursorPosition;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_SetComposition_Name,
        codec.align(InputMethodHost_SetComposition_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_SetComposition_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.setCompositionRange = function() {
    return InputMethodHostProxy.prototype.setCompositionRange
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.setCompositionRange = function(startIndex, endIndex) {
    var params_ = new InputMethodHost_SetCompositionRange_Params();
    params_.startIndex = startIndex;
    params_.endIndex = endIndex;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_SetCompositionRange_Name,
        codec.align(InputMethodHost_SetCompositionRange_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_SetCompositionRange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.finishComposition = function() {
    return InputMethodHostProxy.prototype.finishComposition
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.finishComposition = function() {
    var params_ = new InputMethodHost_FinishComposition_Params();
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_FinishComposition_Name,
        codec.align(InputMethodHost_FinishComposition_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_FinishComposition_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.deleteSurroundingText = function() {
    return InputMethodHostProxy.prototype.deleteSurroundingText
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.deleteSurroundingText = function(numBeforeCursor, numAfterCursor) {
    var params_ = new InputMethodHost_DeleteSurroundingText_Params();
    params_.numBeforeCursor = numBeforeCursor;
    params_.numAfterCursor = numAfterCursor;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_DeleteSurroundingText_Name,
        codec.align(InputMethodHost_DeleteSurroundingText_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_DeleteSurroundingText_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.replaceSurroundingText = function() {
    return InputMethodHostProxy.prototype.replaceSurroundingText
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.replaceSurroundingText = function(numBeforeCursor, numAfterCursor, text) {
    var params_ = new InputMethodHost_ReplaceSurroundingText_Params();
    params_.numBeforeCursor = numBeforeCursor;
    params_.numAfterCursor = numAfterCursor;
    params_.text = text;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_ReplaceSurroundingText_Name,
        codec.align(InputMethodHost_ReplaceSurroundingText_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_ReplaceSurroundingText_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.handleAutocorrect = function() {
    return InputMethodHostProxy.prototype.handleAutocorrect
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.handleAutocorrect = function(autocorrectSpan) {
    var params_ = new InputMethodHost_HandleAutocorrect_Params();
    params_.autocorrectSpan = autocorrectSpan;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_HandleAutocorrect_Name,
        codec.align(InputMethodHost_HandleAutocorrect_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_HandleAutocorrect_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.displaySuggestions = function() {
    return InputMethodHostProxy.prototype.displaySuggestions
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.displaySuggestions = function(suggestions, context) {
    var params_ = new InputMethodHost_DisplaySuggestions_Params();
    params_.suggestions = suggestions;
    params_.context = context;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_DisplaySuggestions_Name,
        codec.align(InputMethodHost_DisplaySuggestions_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_DisplaySuggestions_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.updateCandidatesWindow = function() {
    return InputMethodHostProxy.prototype.updateCandidatesWindow
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.updateCandidatesWindow = function(window) {
    var params_ = new InputMethodHost_UpdateCandidatesWindow_Params();
    params_.window = window;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_UpdateCandidatesWindow_Name,
        codec.align(InputMethodHost_UpdateCandidatesWindow_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_UpdateCandidatesWindow_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.requestSuggestions = function() {
    return InputMethodHostProxy.prototype.requestSuggestions
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.requestSuggestions = function(request) {
    var params_ = new InputMethodHost_RequestSuggestions_Params();
    params_.request = request;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kInputMethodHost_RequestSuggestions_Name,
          codec.align(InputMethodHost_RequestSuggestions_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(InputMethodHost_RequestSuggestions_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(InputMethodHost_RequestSuggestions_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  InputMethodHostPtr.prototype.updateQuickSettings = function() {
    return InputMethodHostProxy.prototype.updateQuickSettings
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.updateQuickSettings = function(settings) {
    var params_ = new InputMethodHost_UpdateQuickSettings_Params();
    params_.settings = settings;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_UpdateQuickSettings_Name,
        codec.align(InputMethodHost_UpdateQuickSettings_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_UpdateQuickSettings_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.recordUkm = function() {
    return InputMethodHostProxy.prototype.recordUkm
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.recordUkm = function(entry) {
    var params_ = new InputMethodHost_RecordUkm_Params();
    params_.entry = entry;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_RecordUkm_Name,
        codec.align(InputMethodHost_RecordUkm_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_RecordUkm_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.dEPRECATEDReportKoreanAction = function() {
    return InputMethodHostProxy.prototype.dEPRECATEDReportKoreanAction
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.dEPRECATEDReportKoreanAction = function(action) {
    var params_ = new InputMethodHost_DEPRECATED_ReportKoreanAction_Params();
    params_.action = action;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_DEPRECATED_ReportKoreanAction_Name,
        codec.align(InputMethodHost_DEPRECATED_ReportKoreanAction_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_DEPRECATED_ReportKoreanAction_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.dEPRECATEDReportKoreanSettings = function() {
    return InputMethodHostProxy.prototype.dEPRECATEDReportKoreanSettings
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.dEPRECATEDReportKoreanSettings = function(settings) {
    var params_ = new InputMethodHost_DEPRECATED_ReportKoreanSettings_Params();
    params_.settings = settings;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_DEPRECATED_ReportKoreanSettings_Name,
        codec.align(InputMethodHost_DEPRECATED_ReportKoreanSettings_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_DEPRECATED_ReportKoreanSettings_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.dEPRECATEDReportSuggestionOpportunity = function() {
    return InputMethodHostProxy.prototype.dEPRECATEDReportSuggestionOpportunity
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.dEPRECATEDReportSuggestionOpportunity = function(mode) {
    var params_ = new InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params();
    params_.mode = mode;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Name,
        codec.align(InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  InputMethodHostPtr.prototype.dEPRECATEDReportHistogramSample = function() {
    return InputMethodHostProxy.prototype.dEPRECATEDReportHistogramSample
        .apply(this.ptr.getProxy(), arguments);
  };

  InputMethodHostProxy.prototype.dEPRECATEDReportHistogramSample = function(histogram, value) {
    var params_ = new InputMethodHost_DEPRECATED_ReportHistogramSample_Params();
    params_.histogram = histogram;
    params_.value = value;
    var builder = new codec.MessageV0Builder(
        kInputMethodHost_DEPRECATED_ReportHistogramSample_Name,
        codec.align(InputMethodHost_DEPRECATED_ReportHistogramSample_Params.encodedSize));
    builder.encodeStruct(InputMethodHost_DEPRECATED_ReportHistogramSample_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function InputMethodHostStub(delegate) {
    this.delegate_ = delegate;
  }
  InputMethodHostStub.prototype.commitText = function(text, cursorBehavior) {
    return this.delegate_ && this.delegate_.commitText && this.delegate_.commitText(text, cursorBehavior);
  }
  InputMethodHostStub.prototype.dEPRECATEDSetComposition = function(text, spans) {
    return this.delegate_ && this.delegate_.dEPRECATEDSetComposition && this.delegate_.dEPRECATEDSetComposition(text, spans);
  }
  InputMethodHostStub.prototype.setComposition = function(text, spans, newCursorPosition) {
    return this.delegate_ && this.delegate_.setComposition && this.delegate_.setComposition(text, spans, newCursorPosition);
  }
  InputMethodHostStub.prototype.setCompositionRange = function(startIndex, endIndex) {
    return this.delegate_ && this.delegate_.setCompositionRange && this.delegate_.setCompositionRange(startIndex, endIndex);
  }
  InputMethodHostStub.prototype.finishComposition = function() {
    return this.delegate_ && this.delegate_.finishComposition && this.delegate_.finishComposition();
  }
  InputMethodHostStub.prototype.deleteSurroundingText = function(numBeforeCursor, numAfterCursor) {
    return this.delegate_ && this.delegate_.deleteSurroundingText && this.delegate_.deleteSurroundingText(numBeforeCursor, numAfterCursor);
  }
  InputMethodHostStub.prototype.replaceSurroundingText = function(numBeforeCursor, numAfterCursor, text) {
    return this.delegate_ && this.delegate_.replaceSurroundingText && this.delegate_.replaceSurroundingText(numBeforeCursor, numAfterCursor, text);
  }
  InputMethodHostStub.prototype.handleAutocorrect = function(autocorrectSpan) {
    return this.delegate_ && this.delegate_.handleAutocorrect && this.delegate_.handleAutocorrect(autocorrectSpan);
  }
  InputMethodHostStub.prototype.displaySuggestions = function(suggestions, context) {
    return this.delegate_ && this.delegate_.displaySuggestions && this.delegate_.displaySuggestions(suggestions, context);
  }
  InputMethodHostStub.prototype.updateCandidatesWindow = function(window) {
    return this.delegate_ && this.delegate_.updateCandidatesWindow && this.delegate_.updateCandidatesWindow(window);
  }
  InputMethodHostStub.prototype.requestSuggestions = function(request) {
    return this.delegate_ && this.delegate_.requestSuggestions && this.delegate_.requestSuggestions(request);
  }
  InputMethodHostStub.prototype.updateQuickSettings = function(settings) {
    return this.delegate_ && this.delegate_.updateQuickSettings && this.delegate_.updateQuickSettings(settings);
  }
  InputMethodHostStub.prototype.recordUkm = function(entry) {
    return this.delegate_ && this.delegate_.recordUkm && this.delegate_.recordUkm(entry);
  }
  InputMethodHostStub.prototype.dEPRECATEDReportKoreanAction = function(action) {
    return this.delegate_ && this.delegate_.dEPRECATEDReportKoreanAction && this.delegate_.dEPRECATEDReportKoreanAction(action);
  }
  InputMethodHostStub.prototype.dEPRECATEDReportKoreanSettings = function(settings) {
    return this.delegate_ && this.delegate_.dEPRECATEDReportKoreanSettings && this.delegate_.dEPRECATEDReportKoreanSettings(settings);
  }
  InputMethodHostStub.prototype.dEPRECATEDReportSuggestionOpportunity = function(mode) {
    return this.delegate_ && this.delegate_.dEPRECATEDReportSuggestionOpportunity && this.delegate_.dEPRECATEDReportSuggestionOpportunity(mode);
  }
  InputMethodHostStub.prototype.dEPRECATEDReportHistogramSample = function(histogram, value) {
    return this.delegate_ && this.delegate_.dEPRECATEDReportHistogramSample && this.delegate_.dEPRECATEDReportHistogramSample(histogram, value);
  }

  InputMethodHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kInputMethodHost_CommitText_Name:
      var params = reader.decodeStruct(InputMethodHost_CommitText_Params);
      this.commitText(params.text, params.cursorBehavior);
      return true;
    case kInputMethodHost_DEPRECATED_SetComposition_Name:
      var params = reader.decodeStruct(InputMethodHost_DEPRECATED_SetComposition_Params);
      this.dEPRECATEDSetComposition(params.text, params.spans);
      return true;
    case kInputMethodHost_SetComposition_Name:
      var params = reader.decodeStruct(InputMethodHost_SetComposition_Params);
      this.setComposition(params.text, params.spans, params.newCursorPosition);
      return true;
    case kInputMethodHost_SetCompositionRange_Name:
      var params = reader.decodeStruct(InputMethodHost_SetCompositionRange_Params);
      this.setCompositionRange(params.startIndex, params.endIndex);
      return true;
    case kInputMethodHost_FinishComposition_Name:
      var params = reader.decodeStruct(InputMethodHost_FinishComposition_Params);
      this.finishComposition();
      return true;
    case kInputMethodHost_DeleteSurroundingText_Name:
      var params = reader.decodeStruct(InputMethodHost_DeleteSurroundingText_Params);
      this.deleteSurroundingText(params.numBeforeCursor, params.numAfterCursor);
      return true;
    case kInputMethodHost_ReplaceSurroundingText_Name:
      var params = reader.decodeStruct(InputMethodHost_ReplaceSurroundingText_Params);
      this.replaceSurroundingText(params.numBeforeCursor, params.numAfterCursor, params.text);
      return true;
    case kInputMethodHost_HandleAutocorrect_Name:
      var params = reader.decodeStruct(InputMethodHost_HandleAutocorrect_Params);
      this.handleAutocorrect(params.autocorrectSpan);
      return true;
    case kInputMethodHost_DisplaySuggestions_Name:
      var params = reader.decodeStruct(InputMethodHost_DisplaySuggestions_Params);
      this.displaySuggestions(params.suggestions, params.context);
      return true;
    case kInputMethodHost_UpdateCandidatesWindow_Name:
      var params = reader.decodeStruct(InputMethodHost_UpdateCandidatesWindow_Params);
      this.updateCandidatesWindow(params.window);
      return true;
    case kInputMethodHost_UpdateQuickSettings_Name:
      var params = reader.decodeStruct(InputMethodHost_UpdateQuickSettings_Params);
      this.updateQuickSettings(params.settings);
      return true;
    case kInputMethodHost_RecordUkm_Name:
      var params = reader.decodeStruct(InputMethodHost_RecordUkm_Params);
      this.recordUkm(params.entry);
      return true;
    case kInputMethodHost_DEPRECATED_ReportKoreanAction_Name:
      var params = reader.decodeStruct(InputMethodHost_DEPRECATED_ReportKoreanAction_Params);
      this.dEPRECATEDReportKoreanAction(params.action);
      return true;
    case kInputMethodHost_DEPRECATED_ReportKoreanSettings_Name:
      var params = reader.decodeStruct(InputMethodHost_DEPRECATED_ReportKoreanSettings_Params);
      this.dEPRECATEDReportKoreanSettings(params.settings);
      return true;
    case kInputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Name:
      var params = reader.decodeStruct(InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params);
      this.dEPRECATEDReportSuggestionOpportunity(params.mode);
      return true;
    case kInputMethodHost_DEPRECATED_ReportHistogramSample_Name:
      var params = reader.decodeStruct(InputMethodHost_DEPRECATED_ReportHistogramSample_Params);
      this.dEPRECATEDReportHistogramSample(params.histogram, params.value);
      return true;
    default:
      return false;
    }
  };

  InputMethodHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kInputMethodHost_RequestSuggestions_Name:
      var params = reader.decodeStruct(InputMethodHost_RequestSuggestions_Params);
      this.requestSuggestions(params.request).then(function(response) {
        var responseParams =
            new InputMethodHost_RequestSuggestions_ResponseParams();
        responseParams.response = response.response;
        var builder = new codec.MessageV1Builder(
            kInputMethodHost_RequestSuggestions_Name,
            codec.align(InputMethodHost_RequestSuggestions_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(InputMethodHost_RequestSuggestions_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateInputMethodHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kInputMethodHost_CommitText_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_CommitText_Params;
      break;
      case kInputMethodHost_DEPRECATED_SetComposition_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_DEPRECATED_SetComposition_Params;
      break;
      case kInputMethodHost_SetComposition_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_SetComposition_Params;
      break;
      case kInputMethodHost_SetCompositionRange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_SetCompositionRange_Params;
      break;
      case kInputMethodHost_FinishComposition_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_FinishComposition_Params;
      break;
      case kInputMethodHost_DeleteSurroundingText_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_DeleteSurroundingText_Params;
      break;
      case kInputMethodHost_ReplaceSurroundingText_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_ReplaceSurroundingText_Params;
      break;
      case kInputMethodHost_HandleAutocorrect_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_HandleAutocorrect_Params;
      break;
      case kInputMethodHost_DisplaySuggestions_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_DisplaySuggestions_Params;
      break;
      case kInputMethodHost_UpdateCandidatesWindow_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_UpdateCandidatesWindow_Params;
      break;
      case kInputMethodHost_RequestSuggestions_Name:
        if (message.expectsResponse())
          paramsClass = InputMethodHost_RequestSuggestions_Params;
      break;
      case kInputMethodHost_UpdateQuickSettings_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_UpdateQuickSettings_Params;
      break;
      case kInputMethodHost_RecordUkm_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_RecordUkm_Params;
      break;
      case kInputMethodHost_DEPRECATED_ReportKoreanAction_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_DEPRECATED_ReportKoreanAction_Params;
      break;
      case kInputMethodHost_DEPRECATED_ReportKoreanSettings_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_DEPRECATED_ReportKoreanSettings_Params;
      break;
      case kInputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params;
      break;
      case kInputMethodHost_DEPRECATED_ReportHistogramSample_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = InputMethodHost_DEPRECATED_ReportHistogramSample_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateInputMethodHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kInputMethodHost_RequestSuggestions_Name:
        if (message.isResponse())
          paramsClass = InputMethodHost_RequestSuggestions_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var InputMethodHost = {
    name: 'ash.ime.mojom.InputMethodHost',
    kVersion: 11,
    ptrClass: InputMethodHostPtr,
    proxyClass: InputMethodHostProxy,
    stubClass: InputMethodHostStub,
    validateRequest: validateInputMethodHostRequest,
    validateResponse: validateInputMethodHostResponse,
  };
  InputMethodHostStub.prototype.validator = validateInputMethodHostRequest;
  InputMethodHostProxy.prototype.validator = validateInputMethodHostResponse;
  exports.CommitTextCursorBehavior = CommitTextCursorBehavior;
  exports.CompositionSpanStyle = CompositionSpanStyle;
  exports.InputMethodApiOperation = InputMethodApiOperation;
  exports.KoreanAction = KoreanAction;
  exports.HistogramBucketType = HistogramBucketType;
  exports.CompositionSpan = CompositionSpan;
  exports.TextRange = TextRange;
  exports.AutocorrectSpan = AutocorrectSpan;
  exports.CompletionCandidate = CompletionCandidate;
  exports.SuggestionsRequest = SuggestionsRequest;
  exports.SuggestionsResponse = SuggestionsResponse;
  exports.SuggestionsTextContext = SuggestionsTextContext;
  exports.NonCompliantApiMetric = NonCompliantApiMetric;
  exports.Candidate = Candidate;
  exports.HighlightedCandidate = HighlightedCandidate;
  exports.CandidatesWindow = CandidatesWindow;
  exports.BucketedHistogram = BucketedHistogram;
  exports.UkmEntry = UkmEntry;
  exports.InputMethodHost = InputMethodHost;
  exports.InputMethodHostPtr = InputMethodHostPtr;
  exports.InputMethodHostAssociatedPtr = InputMethodHostAssociatedPtr;
})();