// chromeos/ash/services/ime/public/mojom/input_method_host.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  SuggestionMode as ash_ime_mojom_SuggestionMode,
  SuggestionModeSpec as ash_ime_mojom_SuggestionModeSpec,
  KoreanSettings as ash_ime_mojom_KoreanSettings,
  KoreanSettingsSpec as ash_ime_mojom_KoreanSettingsSpec,
  SuggestionCandidate as ash_ime_mojom_SuggestionCandidate,
  SuggestionCandidateSpec as ash_ime_mojom_SuggestionCandidateSpec,
  InputMethodQuickSettings as ash_ime_mojom_InputMethodQuickSettings,
  InputMethodQuickSettingsSpec as ash_ime_mojom_InputMethodQuickSettingsSpec
} from './input_method.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CommitTextCursorBehaviorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CommitTextCursorBehavior = {
  
  kMoveCursorAfterText: 0,
  kMoveCursorBeforeText: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CompositionSpanStyleSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CompositionSpanStyle = {
  
  kDefault: 0,
  kNone: 1,
  kHighlight: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const InputMethodApiOperationSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const InputMethodApiOperation = {
  
  kUnknown: 0,
  kCommitText: 1,
  kSetCompositionText: 2,
  kDeleteSurroundingText: 3,
  kReplaceSurroundingText: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const KoreanActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const KoreanAction = {
  
  kUnknown: 0,
  kHanjaKey: 1,
  kHangeulKey: 2,
  kComposeOutOfOrder: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const HistogramBucketTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const HistogramBucketType = {
  
  kExponential: 0,
  kLinear: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class InputMethodHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.ime.mojom.InputMethodHost', scope);
  }
}

/** @interface */
export class InputMethodHostInterface {
  
  /**
   * @param { !mojoBase_mojom_String16 } text
   * @param { !CommitTextCursorBehavior } cursorBehavior
   */

  commitText(text, cursorBehavior) {}
  
  /**
   * @param { !mojoBase_mojom_String16 } text
   * @param { !Array<!CompositionSpan> } spans
   */

  dEPRECATEDSetComposition(text, spans) {}
  
  /**
   * @param { !mojoBase_mojom_String16 } text
   * @param { !Array<!CompositionSpan> } spans
   * @param { !number } newCursorPosition
   */

  setComposition(text, spans, newCursorPosition) {}
  
  /**
   * @param { !number } startIndex
   * @param { !number } endIndex
   */

  setCompositionRange(startIndex, endIndex) {}
  
  /**
   */

  finishComposition() {}
  
  /**
   * @param { !number } numBeforeCursor
   * @param { !number } numAfterCursor
   */

  deleteSurroundingText(numBeforeCursor, numAfterCursor) {}
  
  /**
   * @param { !number } numBeforeCursor
   * @param { !number } numAfterCursor
   * @param { !mojoBase_mojom_String16 } text
   */

  replaceSurroundingText(numBeforeCursor, numAfterCursor, text) {}
  
  /**
   * @param { !AutocorrectSpan } autocorrectSpan
   */

  handleAutocorrect(autocorrectSpan) {}
  
  /**
   * @param { !Array<!ash_ime_mojom_SuggestionCandidate> } suggestions
   * @param { ?SuggestionsTextContext } context
   */

  displaySuggestions(suggestions, context) {}
  
  /**
   * @param { ?CandidatesWindow } window
   */

  updateCandidatesWindow(window) {}
  
  /**
   * @param { !SuggestionsRequest } request
   * @return {!Promise<{
        response: !SuggestionsResponse,
   *  }>}
   */

  requestSuggestions(request) {}
  
  /**
   * @param { !ash_ime_mojom_InputMethodQuickSettings } settings
   */

  updateQuickSettings(settings) {}
  
  /**
   * @param { !UkmEntry } entry
   */

  recordUkm(entry) {}
  
  /**
   * @param { !KoreanAction } action
   */

  dEPRECATEDReportKoreanAction(action) {}
  
  /**
   * @param { !ash_ime_mojom_KoreanSettings } settings
   */

  dEPRECATEDReportKoreanSettings(settings) {}
  
  /**
   * @param { !ash_ime_mojom_SuggestionMode } mode
   */

  dEPRECATEDReportSuggestionOpportunity(mode) {}
  
  /**
   * @param { !BucketedHistogram } histogram
   * @param { !number } value
   */

  dEPRECATEDReportHistogramSample(histogram, value) {}
}

/**
 * @implements { InputMethodHostInterface }
 */
export class InputMethodHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!InputMethodHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          InputMethodHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!InputMethodHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } text
   * @param { !CommitTextCursorBehavior } cursorBehavior
   */

  commitText(
      text,
      cursorBehavior) {
    this.proxy.sendMessage(
        0,
        InputMethodHost_CommitText_ParamsSpec.$,
        null,
        [
          text,
          cursorBehavior
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } text
   * @param { !Array<!CompositionSpan> } spans
   */

  dEPRECATEDSetComposition(
      text,
      spans) {
    this.proxy.sendMessage(
        1,
        InputMethodHost_DEPRECATED_SetComposition_ParamsSpec.$,
        null,
        [
          text,
          spans
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } text
   * @param { !Array<!CompositionSpan> } spans
   * @param { !number } newCursorPosition
   */

  setComposition(
      text,
      spans,
      newCursorPosition) {
    this.proxy.sendMessage(
        12,
        InputMethodHost_SetComposition_ParamsSpec.$,
        null,
        [
          text,
          spans,
          newCursorPosition
        ],
        false);
  }

  
  /**
   * @param { !number } startIndex
   * @param { !number } endIndex
   */

  setCompositionRange(
      startIndex,
      endIndex) {
    this.proxy.sendMessage(
        2,
        InputMethodHost_SetCompositionRange_ParamsSpec.$,
        null,
        [
          startIndex,
          endIndex
        ],
        false);
  }

  
  /**
   */

  finishComposition() {
    this.proxy.sendMessage(
        3,
        InputMethodHost_FinishComposition_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } numBeforeCursor
   * @param { !number } numAfterCursor
   */

  deleteSurroundingText(
      numBeforeCursor,
      numAfterCursor) {
    this.proxy.sendMessage(
        4,
        InputMethodHost_DeleteSurroundingText_ParamsSpec.$,
        null,
        [
          numBeforeCursor,
          numAfterCursor
        ],
        false);
  }

  
  /**
   * @param { !number } numBeforeCursor
   * @param { !number } numAfterCursor
   * @param { !mojoBase_mojom_String16 } text
   */

  replaceSurroundingText(
      numBeforeCursor,
      numAfterCursor,
      text) {
    this.proxy.sendMessage(
        16,
        InputMethodHost_ReplaceSurroundingText_ParamsSpec.$,
        null,
        [
          numBeforeCursor,
          numAfterCursor,
          text
        ],
        false);
  }

  
  /**
   * @param { !AutocorrectSpan } autocorrectSpan
   */

  handleAutocorrect(
      autocorrectSpan) {
    this.proxy.sendMessage(
        5,
        InputMethodHost_HandleAutocorrect_ParamsSpec.$,
        null,
        [
          autocorrectSpan
        ],
        false);
  }

  
  /**
   * @param { !Array<!ash_ime_mojom_SuggestionCandidate> } suggestions
   * @param { ?SuggestionsTextContext } context
   */

  displaySuggestions(
      suggestions,
      context) {
    this.proxy.sendMessage(
        6,
        InputMethodHost_DisplaySuggestions_ParamsSpec.$,
        null,
        [
          suggestions,
          context
        ],
        false);
  }

  
  /**
   * @param { ?CandidatesWindow } window
   */

  updateCandidatesWindow(
      window) {
    this.proxy.sendMessage(
        9,
        InputMethodHost_UpdateCandidatesWindow_ParamsSpec.$,
        null,
        [
          window
        ],
        false);
  }

  
  /**
   * @param { !SuggestionsRequest } request
   * @return {!Promise<{
        response: !SuggestionsResponse,
   *  }>}
   */

  requestSuggestions(
      request) {
    return this.proxy.sendMessage(
        7,
        InputMethodHost_RequestSuggestions_ParamsSpec.$,
        InputMethodHost_RequestSuggestions_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }

  
  /**
   * @param { !ash_ime_mojom_InputMethodQuickSettings } settings
   */

  updateQuickSettings(
      settings) {
    this.proxy.sendMessage(
        13,
        InputMethodHost_UpdateQuickSettings_ParamsSpec.$,
        null,
        [
          settings
        ],
        false);
  }

  
  /**
   * @param { !UkmEntry } entry
   */

  recordUkm(
      entry) {
    this.proxy.sendMessage(
        8,
        InputMethodHost_RecordUkm_ParamsSpec.$,
        null,
        [
          entry
        ],
        false);
  }

  
  /**
   * @param { !KoreanAction } action
   */

  dEPRECATEDReportKoreanAction(
      action) {
    this.proxy.sendMessage(
        10,
        InputMethodHost_DEPRECATED_ReportKoreanAction_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  
  /**
   * @param { !ash_ime_mojom_KoreanSettings } settings
   */

  dEPRECATEDReportKoreanSettings(
      settings) {
    this.proxy.sendMessage(
        11,
        InputMethodHost_DEPRECATED_ReportKoreanSettings_ParamsSpec.$,
        null,
        [
          settings
        ],
        false);
  }

  
  /**
   * @param { !ash_ime_mojom_SuggestionMode } mode
   */

  dEPRECATEDReportSuggestionOpportunity(
      mode) {
    this.proxy.sendMessage(
        14,
        InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_ParamsSpec.$,
        null,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !BucketedHistogram } histogram
   * @param { !number } value
   */

  dEPRECATEDReportHistogramSample(
      histogram,
      value) {
    this.proxy.sendMessage(
        15,
        InputMethodHost_DEPRECATED_ReportHistogramSample_ParamsSpec.$,
        null,
        [
          histogram,
          value
        ],
        false);
  }
}

/**
 * An object which receives request messages for the InputMethodHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InputMethodHostReceiver {
  /**
   * @param {!InputMethodHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!InputMethodHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        InputMethodHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InputMethodHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        InputMethodHost_CommitText_ParamsSpec.$,
        null,
        impl.commitText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        InputMethodHost_DEPRECATED_SetComposition_ParamsSpec.$,
        null,
        impl.dEPRECATEDSetComposition.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        InputMethodHost_SetComposition_ParamsSpec.$,
        null,
        impl.setComposition.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        InputMethodHost_SetCompositionRange_ParamsSpec.$,
        null,
        impl.setCompositionRange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        InputMethodHost_FinishComposition_ParamsSpec.$,
        null,
        impl.finishComposition.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        InputMethodHost_DeleteSurroundingText_ParamsSpec.$,
        null,
        impl.deleteSurroundingText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        InputMethodHost_ReplaceSurroundingText_ParamsSpec.$,
        null,
        impl.replaceSurroundingText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        InputMethodHost_HandleAutocorrect_ParamsSpec.$,
        null,
        impl.handleAutocorrect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        InputMethodHost_DisplaySuggestions_ParamsSpec.$,
        null,
        impl.displaySuggestions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        InputMethodHost_UpdateCandidatesWindow_ParamsSpec.$,
        null,
        impl.updateCandidatesWindow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        InputMethodHost_RequestSuggestions_ParamsSpec.$,
        InputMethodHost_RequestSuggestions_ResponseParamsSpec.$,
        impl.requestSuggestions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        InputMethodHost_UpdateQuickSettings_ParamsSpec.$,
        null,
        impl.updateQuickSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        InputMethodHost_RecordUkm_ParamsSpec.$,
        null,
        impl.recordUkm.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        InputMethodHost_DEPRECATED_ReportKoreanAction_ParamsSpec.$,
        null,
        impl.dEPRECATEDReportKoreanAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        InputMethodHost_DEPRECATED_ReportKoreanSettings_ParamsSpec.$,
        null,
        impl.dEPRECATEDReportKoreanSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_ParamsSpec.$,
        null,
        impl.dEPRECATEDReportSuggestionOpportunity.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        InputMethodHost_DEPRECATED_ReportHistogramSample_ParamsSpec.$,
        null,
        impl.dEPRECATEDReportHistogramSample.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class InputMethodHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.InputMethodHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!InputMethodHostRemote}
   */
  static getRemote() {
    let remote = new InputMethodHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the InputMethodHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InputMethodHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      InputMethodHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InputMethodHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.commitText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        InputMethodHost_CommitText_ParamsSpec.$,
        null,
        this.commitText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dEPRECATEDSetComposition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        InputMethodHost_DEPRECATED_SetComposition_ParamsSpec.$,
        null,
        this.dEPRECATEDSetComposition.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setComposition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        InputMethodHost_SetComposition_ParamsSpec.$,
        null,
        this.setComposition.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCompositionRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        InputMethodHost_SetCompositionRange_ParamsSpec.$,
        null,
        this.setCompositionRange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.finishComposition =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        InputMethodHost_FinishComposition_ParamsSpec.$,
        null,
        this.finishComposition.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteSurroundingText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        InputMethodHost_DeleteSurroundingText_ParamsSpec.$,
        null,
        this.deleteSurroundingText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.replaceSurroundingText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        InputMethodHost_ReplaceSurroundingText_ParamsSpec.$,
        null,
        this.replaceSurroundingText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.handleAutocorrect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        InputMethodHost_HandleAutocorrect_ParamsSpec.$,
        null,
        this.handleAutocorrect.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.displaySuggestions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        InputMethodHost_DisplaySuggestions_ParamsSpec.$,
        null,
        this.displaySuggestions.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateCandidatesWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        InputMethodHost_UpdateCandidatesWindow_ParamsSpec.$,
        null,
        this.updateCandidatesWindow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestSuggestions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        InputMethodHost_RequestSuggestions_ParamsSpec.$,
        InputMethodHost_RequestSuggestions_ResponseParamsSpec.$,
        this.requestSuggestions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateQuickSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        InputMethodHost_UpdateQuickSettings_ParamsSpec.$,
        null,
        this.updateQuickSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.recordUkm =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        InputMethodHost_RecordUkm_ParamsSpec.$,
        null,
        this.recordUkm.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dEPRECATEDReportKoreanAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        InputMethodHost_DEPRECATED_ReportKoreanAction_ParamsSpec.$,
        null,
        this.dEPRECATEDReportKoreanAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dEPRECATEDReportKoreanSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        InputMethodHost_DEPRECATED_ReportKoreanSettings_ParamsSpec.$,
        null,
        this.dEPRECATEDReportKoreanSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dEPRECATEDReportSuggestionOpportunity =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_ParamsSpec.$,
        null,
        this.dEPRECATEDReportSuggestionOpportunity.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dEPRECATEDReportHistogramSample =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        InputMethodHost_DEPRECATED_ReportHistogramSample_ParamsSpec.$,
        null,
        this.dEPRECATEDReportHistogramSample.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompositionSpanSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextRangeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AutocorrectSpanSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CompletionCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SuggestionsRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SuggestionsResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SuggestionsTextContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NonCompliantApiMetricSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HighlightedCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CandidatesWindowSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BucketedHistogramSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_CommitText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_DEPRECATED_SetComposition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_SetComposition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_SetCompositionRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_FinishComposition_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_DeleteSurroundingText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_ReplaceSurroundingText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_HandleAutocorrect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_DisplaySuggestions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_UpdateCandidatesWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_RequestSuggestions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_RequestSuggestions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_UpdateQuickSettings_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_RecordUkm_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_DEPRECATED_ReportKoreanAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_DEPRECATED_ReportKoreanSettings_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodHost_DEPRECATED_ReportHistogramSample_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const UkmEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CompositionSpanSpec.$,
    'CompositionSpan',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'style', 8,
        0,
        CompositionSpanStyleSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CompositionSpan {
  constructor() {
    /** @type { !number } */
    this.start;
    /** @type { !number } */
    this.end;
    /** @type { !CompositionSpanStyle } */
    this.style;
  }
}



mojo.internal.Struct(
    TextRangeSpec.$,
    'TextRange',
    [
      mojo.internal.StructField(
        'start', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'end', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextRange {
  constructor() {
    /** @type { !number } */
    this.start;
    /** @type { !number } */
    this.end;
  }
}



mojo.internal.Struct(
    AutocorrectSpanSpec.$,
    'AutocorrectSpan',
    [
      mojo.internal.StructField(
        'autocorrectRange', 0,
        0,
        TextRangeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'originalText', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentText', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AutocorrectSpan {
  constructor() {
    /** @type { !TextRange } */
    this.autocorrectRange;
    /** @type { !mojoBase_mojom_String16 } */
    this.originalText;
    /** @type { !mojoBase_mojom_String16 } */
    this.currentText;
  }
}



mojo.internal.Struct(
    CompletionCandidateSpec.$,
    'CompletionCandidate',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'normalizedScore', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CompletionCandidate {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { !number } */
    this.normalizedScore;
  }
}



mojo.internal.Struct(
    SuggestionsRequestSpec.$,
    'SuggestionsRequest',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        ash_ime_mojom_SuggestionModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'completionCandidates', 16,
        0,
        mojo.internal.Array(CompletionCandidateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SuggestionsRequest {
  constructor() {
    /** @type { !ash_ime_mojom_SuggestionMode } */
    this.mode;
    /** @type { !string } */
    this.text;
    /** @type { !Array<!CompletionCandidate> } */
    this.completionCandidates;
  }
}



mojo.internal.Struct(
    SuggestionsResponseSpec.$,
    'SuggestionsResponse',
    [
      mojo.internal.StructField(
        'candidates', 0,
        0,
        mojo.internal.Array(ash_ime_mojom_SuggestionCandidateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SuggestionsResponse {
  constructor() {
    /** @type { !Array<!ash_ime_mojom_SuggestionCandidate> } */
    this.candidates;
  }
}



mojo.internal.Struct(
    SuggestionsTextContextSpec.$,
    'SuggestionsTextContext',
    [
      mojo.internal.StructField(
        'lastNChars', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'surroundingTextLength', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SuggestionsTextContext {
  constructor() {
    /** @type { !string } */
    this.lastNChars;
    /** @type { !number } */
    this.surroundingTextLength;
  }
}



mojo.internal.Struct(
    NonCompliantApiMetricSpec.$,
    'NonCompliantApiMetric',
    [
      mojo.internal.StructField(
        'nonCompliantOperation', 0,
        0,
        InputMethodApiOperationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NonCompliantApiMetric {
  constructor() {
    /** @type { !InputMethodApiOperation } */
    this.nonCompliantOperation;
  }
}



mojo.internal.Struct(
    CandidateSpec.$,
    'Candidate',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'annotation', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class Candidate {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { (string|undefined) } */
    this.label;
    /** @type { (string|undefined) } */
    this.annotation;
  }
}



mojo.internal.Struct(
    HighlightedCandidateSpec.$,
    'HighlightedCandidate',
    [
      mojo.internal.StructField(
        'index', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HighlightedCandidate {
  constructor() {
    /** @type { !number } */
    this.index;
  }
}



mojo.internal.Struct(
    CandidatesWindowSpec.$,
    'CandidatesWindow',
    [
      mojo.internal.StructField(
        'candidates', 0,
        0,
        mojo.internal.Array(CandidateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dEPRECATEDHighlightedCandidate', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'auxiliaryText', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        4,
      ),
      mojo.internal.StructField(
        'highlightedCandidate', 24,
        0,
        HighlightedCandidateSpec.$,
        null,
        true /* nullable */,
        6,
      ),
    ],
    [[0, 24],[4, 32],[6, 40],]);



/**
 * @record
 */
export class CandidatesWindow {
  constructor() {
    /** @type { !Array<!Candidate> } */
    this.candidates;
    /** @type { !number } */
    this.dEPRECATEDHighlightedCandidate;
    /** @type { (string|undefined) } */
    this.auxiliaryText;
    /** @type { (HighlightedCandidate|undefined) } */
    this.highlightedCandidate;
  }
}



mojo.internal.Struct(
    BucketedHistogramSpec.$,
    'BucketedHistogram',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bucketType', 8,
        0,
        HistogramBucketTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minimum', 12,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maximum', 14,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bucketCount', 16,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class BucketedHistogram {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !HistogramBucketType } */
    this.bucketType;
    /** @type { !number } */
    this.minimum;
    /** @type { !number } */
    this.maximum;
    /** @type { !number } */
    this.bucketCount;
  }
}



mojo.internal.Struct(
    InputMethodHost_CommitText_ParamsSpec.$,
    'InputMethodHost_CommitText_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cursorBehavior', 8,
        0,
        CommitTextCursorBehaviorSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputMethodHost_CommitText_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.text;
    /** @type { !CommitTextCursorBehavior } */
    this.cursorBehavior;
  }
}



mojo.internal.Struct(
    InputMethodHost_DEPRECATED_SetComposition_ParamsSpec.$,
    'InputMethodHost_DEPRECATED_SetComposition_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'spans', 8,
        0,
        mojo.internal.Array(CompositionSpanSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputMethodHost_DEPRECATED_SetComposition_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.text;
    /** @type { !Array<!CompositionSpan> } */
    this.spans;
  }
}



mojo.internal.Struct(
    InputMethodHost_SetComposition_ParamsSpec.$,
    'InputMethodHost_SetComposition_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'spans', 8,
        0,
        mojo.internal.Array(CompositionSpanSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newCursorPosition', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class InputMethodHost_SetComposition_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.text;
    /** @type { !Array<!CompositionSpan> } */
    this.spans;
    /** @type { !number } */
    this.newCursorPosition;
  }
}



mojo.internal.Struct(
    InputMethodHost_SetCompositionRange_ParamsSpec.$,
    'InputMethodHost_SetCompositionRange_Params',
    [
      mojo.internal.StructField(
        'startIndex', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endIndex', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodHost_SetCompositionRange_Params {
  constructor() {
    /** @type { !number } */
    this.startIndex;
    /** @type { !number } */
    this.endIndex;
  }
}



mojo.internal.Struct(
    InputMethodHost_FinishComposition_ParamsSpec.$,
    'InputMethodHost_FinishComposition_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class InputMethodHost_FinishComposition_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    InputMethodHost_DeleteSurroundingText_ParamsSpec.$,
    'InputMethodHost_DeleteSurroundingText_Params',
    [
      mojo.internal.StructField(
        'numBeforeCursor', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numAfterCursor', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodHost_DeleteSurroundingText_Params {
  constructor() {
    /** @type { !number } */
    this.numBeforeCursor;
    /** @type { !number } */
    this.numAfterCursor;
  }
}



mojo.internal.Struct(
    InputMethodHost_ReplaceSurroundingText_ParamsSpec.$,
    'InputMethodHost_ReplaceSurroundingText_Params',
    [
      mojo.internal.StructField(
        'numBeforeCursor', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numAfterCursor', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputMethodHost_ReplaceSurroundingText_Params {
  constructor() {
    /** @type { !number } */
    this.numBeforeCursor;
    /** @type { !number } */
    this.numAfterCursor;
    /** @type { !mojoBase_mojom_String16 } */
    this.text;
  }
}



mojo.internal.Struct(
    InputMethodHost_HandleAutocorrect_ParamsSpec.$,
    'InputMethodHost_HandleAutocorrect_Params',
    [
      mojo.internal.StructField(
        'autocorrectSpan', 0,
        0,
        AutocorrectSpanSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodHost_HandleAutocorrect_Params {
  constructor() {
    /** @type { !AutocorrectSpan } */
    this.autocorrectSpan;
  }
}



mojo.internal.Struct(
    InputMethodHost_DisplaySuggestions_ParamsSpec.$,
    'InputMethodHost_DisplaySuggestions_Params',
    [
      mojo.internal.StructField(
        'suggestions', 0,
        0,
        mojo.internal.Array(ash_ime_mojom_SuggestionCandidateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'context', 8,
        0,
        SuggestionsTextContextSpec.$,
        null,
        true /* nullable */,
        10,
      ),
    ],
    [[0, 16],[10, 24],]);



/**
 * @record
 */
export class InputMethodHost_DisplaySuggestions_Params {
  constructor() {
    /** @type { !Array<!ash_ime_mojom_SuggestionCandidate> } */
    this.suggestions;
    /** @type { (SuggestionsTextContext|undefined) } */
    this.context;
  }
}



mojo.internal.Struct(
    InputMethodHost_UpdateCandidatesWindow_ParamsSpec.$,
    'InputMethodHost_UpdateCandidatesWindow_Params',
    [
      mojo.internal.StructField(
        'window', 0,
        0,
        CandidatesWindowSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodHost_UpdateCandidatesWindow_Params {
  constructor() {
    /** @type { (CandidatesWindow|undefined) } */
    this.window;
  }
}



mojo.internal.Struct(
    InputMethodHost_RequestSuggestions_ParamsSpec.$,
    'InputMethodHost_RequestSuggestions_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        SuggestionsRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodHost_RequestSuggestions_Params {
  constructor() {
    /** @type { !SuggestionsRequest } */
    this.request;
  }
}



mojo.internal.Struct(
    InputMethodHost_RequestSuggestions_ResponseParamsSpec.$,
    'InputMethodHost_RequestSuggestions_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        SuggestionsResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodHost_RequestSuggestions_ResponseParams {
  constructor() {
    /** @type { !SuggestionsResponse } */
    this.response;
  }
}



mojo.internal.Struct(
    InputMethodHost_UpdateQuickSettings_ParamsSpec.$,
    'InputMethodHost_UpdateQuickSettings_Params',
    [
      mojo.internal.StructField(
        'settings', 0,
        0,
        ash_ime_mojom_InputMethodQuickSettingsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputMethodHost_UpdateQuickSettings_Params {
  constructor() {
    /** @type { !ash_ime_mojom_InputMethodQuickSettings } */
    this.settings;
  }
}



mojo.internal.Struct(
    InputMethodHost_RecordUkm_ParamsSpec.$,
    'InputMethodHost_RecordUkm_Params',
    [
      mojo.internal.StructField(
        'entry', 0,
        0,
        UkmEntrySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputMethodHost_RecordUkm_Params {
  constructor() {
    /** @type { !UkmEntry } */
    this.entry;
  }
}



mojo.internal.Struct(
    InputMethodHost_DEPRECATED_ReportKoreanAction_ParamsSpec.$,
    'InputMethodHost_DEPRECATED_ReportKoreanAction_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        KoreanActionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodHost_DEPRECATED_ReportKoreanAction_Params {
  constructor() {
    /** @type { !KoreanAction } */
    this.action;
  }
}



mojo.internal.Struct(
    InputMethodHost_DEPRECATED_ReportKoreanSettings_ParamsSpec.$,
    'InputMethodHost_DEPRECATED_ReportKoreanSettings_Params',
    [
      mojo.internal.StructField(
        'settings', 0,
        0,
        ash_ime_mojom_KoreanSettingsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodHost_DEPRECATED_ReportKoreanSettings_Params {
  constructor() {
    /** @type { !ash_ime_mojom_KoreanSettings } */
    this.settings;
  }
}



mojo.internal.Struct(
    InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_ParamsSpec.$,
    'InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        ash_ime_mojom_SuggestionModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodHost_DEPRECATED_ReportSuggestionOpportunity_Params {
  constructor() {
    /** @type { !ash_ime_mojom_SuggestionMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    InputMethodHost_DEPRECATED_ReportHistogramSample_ParamsSpec.$,
    'InputMethodHost_DEPRECATED_ReportHistogramSample_Params',
    [
      mojo.internal.StructField(
        'histogram', 0,
        0,
        BucketedHistogramSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputMethodHost_DEPRECATED_ReportHistogramSample_Params {
  constructor() {
    /** @type { !BucketedHistogram } */
    this.histogram;
    /** @type { !number } */
    this.value;
  }
}

mojo.internal.Union(
    UkmEntrySpec.$, 'UkmEntry',
    {
      'nonCompliantApi': {
        'ordinal': 0,
        'type': NonCompliantApiMetricSpec.$,
      },
    });

/**
 * @typedef { {
 *   nonCompliantApi: (!NonCompliantApiMetric|undefined),
 * } }
 */
export const UkmEntry = {};
