// chromeos/ash/services/ime/public/mojom/input_method_user_data.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.BigString');
goog.require('ash.ime.mojom.JapaneseDictionary');
goog.require('ash.ime.mojom.JapaneseDictionaryEntry');
goog.require('ash.ime.mojom.JapaneseLegacyConfig');






goog.provide('ash.ime.mojom.InputMethodUserDataService');
goog.provide('ash.ime.mojom.InputMethodUserDataServiceReceiver');
goog.provide('ash.ime.mojom.InputMethodUserDataServiceCallbackRouter');
goog.provide('ash.ime.mojom.InputMethodUserDataServiceInterface');
goog.provide('ash.ime.mojom.InputMethodUserDataServiceRemote');
goog.provide('ash.ime.mojom.InputMethodUserDataServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.ime.mojom.InputMethodUserDataServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.ime.mojom.InputMethodUserDataService.$interfaceName,
        scope);
  }
};

/** @interface */
ash.ime.mojom.InputMethodUserDataServiceInterface = class {
  
  /**
   * @return {!Promise<{
        response: !ash.ime.mojom.JapaneseLegacyConfigResponse,
   *  }>}
   */

  fetchJapaneseLegacyConfig() {}
  
  /**
   * @return {!Promise<{
        response: !ash.ime.mojom.JapaneseDictionaryResponse,
   *  }>}
   */

  fetchJapaneseDictionary() {}
  
  /**
   * @param { !bigint } dictId
   * @param { !ash.ime.mojom.JapaneseDictionaryEntry } entry
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  addJapaneseDictionaryEntry(dictId, entry) {}
  
  /**
   * @param { !bigint } dictId
   * @param { !number } entryIndex
   * @param { !ash.ime.mojom.JapaneseDictionaryEntry } entry
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  editJapaneseDictionaryEntry(dictId, entryIndex, entry) {}
  
  /**
   * @param { !bigint } dictId
   * @param { !number } entryIndex
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  deleteJapaneseDictionaryEntry(dictId, entryIndex) {}
  
  /**
   * @param { !string } dictionaryName
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  createJapaneseDictionary(dictionaryName) {}
  
  /**
   * @param { !bigint } dictId
   * @param { !string } dictionaryName
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  renameJapaneseDictionary(dictId, dictionaryName) {}
  
  /**
   * @param { !bigint } dictId
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  deleteJapaneseDictionary(dictId) {}
  
  /**
   * @param { !bigint } dictId
   * @return {!Promise<{
        result: !mojoBase.mojom.BigString,
   *  }>}
   */

  exportJapaneseDictionary(dictId) {}
  
  /**
   * @param { !bigint } dictId
   * @param { !mojoBase.mojom.BigString } tsvData
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  importJapaneseDictionary(dictId, tsvData) {}
  
  /**
   * @param { !boolean } clearConversionHistory
   * @param { !boolean } clearSuggestionHistory
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  clearJapanesePersonalizationData(clearConversionHistory, clearSuggestionHistory) {}
};

/**
 * @export
 * @implements { ash.ime.mojom.InputMethodUserDataServiceInterface }
 */
ash.ime.mojom.InputMethodUserDataServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.ime.mojom.InputMethodUserDataServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.ime.mojom.InputMethodUserDataServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.ime.mojom.InputMethodUserDataServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        response: !ash.ime.mojom.JapaneseLegacyConfigResponse,
   *  }>}
   */

  fetchJapaneseLegacyConfig() {
    return this.proxy.sendMessage(
        0,
        ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        response: !ash.ime.mojom.JapaneseDictionaryResponse,
   *  }>}
   */

  fetchJapaneseDictionary() {
    return this.proxy.sendMessage(
        1,
        ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @param { !ash.ime.mojom.JapaneseDictionaryEntry } entry
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  addJapaneseDictionaryEntry(
      dictId,
      entry) {
    return this.proxy.sendMessage(
        2,
        ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec.$,
        [
          dictId,
          entry
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @param { !number } entryIndex
   * @param { !ash.ime.mojom.JapaneseDictionaryEntry } entry
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  editJapaneseDictionaryEntry(
      dictId,
      entryIndex,
      entry) {
    return this.proxy.sendMessage(
        3,
        ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec.$,
        [
          dictId,
          entryIndex,
          entry
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @param { !number } entryIndex
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  deleteJapaneseDictionaryEntry(
      dictId,
      entryIndex) {
    return this.proxy.sendMessage(
        4,
        ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec.$,
        [
          dictId,
          entryIndex
        ],
        false);
  }

  
  /**
   * @param { !string } dictionaryName
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  createJapaneseDictionary(
      dictionaryName) {
    return this.proxy.sendMessage(
        5,
        ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec.$,
        [
          dictionaryName
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @param { !string } dictionaryName
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  renameJapaneseDictionary(
      dictId,
      dictionaryName) {
    return this.proxy.sendMessage(
        6,
        ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec.$,
        [
          dictId,
          dictionaryName
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  deleteJapaneseDictionary(
      dictId) {
    return this.proxy.sendMessage(
        7,
        ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec.$,
        [
          dictId
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @return {!Promise<{
        result: !mojoBase.mojom.BigString,
   *  }>}
   */

  exportJapaneseDictionary(
      dictId) {
    return this.proxy.sendMessage(
        8,
        ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec.$,
        [
          dictId
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @param { !mojoBase.mojom.BigString } tsvData
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  importJapaneseDictionary(
      dictId,
      tsvData) {
    return this.proxy.sendMessage(
        9,
        ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec.$,
        [
          dictId,
          tsvData
        ],
        false);
  }

  
  /**
   * @param { !boolean } clearConversionHistory
   * @param { !boolean } clearSuggestionHistory
   * @return {!Promise<{
        status: !ash.ime.mojom.Status,
   *  }>}
   */

  clearJapanesePersonalizationData(
      clearConversionHistory,
      clearSuggestionHistory) {
    return this.proxy.sendMessage(
        10,
        ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec.$,
        [
          clearConversionHistory,
          clearSuggestionHistory
        ],
        false);
  }
};

/**
 * An object which receives request messages for the InputMethodUserDataService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.ime.mojom.InputMethodUserDataServiceReceiver = class {
  /**
   * @param {!ash.ime.mojom.InputMethodUserDataServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.ime.mojom.InputMethodUserDataServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.ime.mojom.InputMethodUserDataServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.InputMethodUserDataServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec.$,
        impl.fetchJapaneseLegacyConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec.$,
        impl.fetchJapaneseDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec.$,
        impl.addJapaneseDictionaryEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec.$,
        impl.editJapaneseDictionaryEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec.$,
        impl.deleteJapaneseDictionaryEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec.$,
        impl.createJapaneseDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec.$,
        impl.renameJapaneseDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec.$,
        impl.deleteJapaneseDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec.$,
        impl.exportJapaneseDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec.$,
        impl.importJapaneseDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec.$,
        impl.clearJapanesePersonalizationData.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.ime.mojom.InputMethodUserDataService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.InputMethodUserDataService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.ime.mojom.InputMethodUserDataServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.ime.mojom.InputMethodUserDataServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the InputMethodUserDataService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.ime.mojom.InputMethodUserDataServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.ime.mojom.InputMethodUserDataServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.ime.mojom.InputMethodUserDataServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fetchJapaneseLegacyConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec.$,
        this.fetchJapaneseLegacyConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fetchJapaneseDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec.$,
        this.fetchJapaneseDictionary.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addJapaneseDictionaryEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec.$,
        this.addJapaneseDictionaryEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.editJapaneseDictionaryEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec.$,
        this.editJapaneseDictionaryEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteJapaneseDictionaryEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec.$,
        this.deleteJapaneseDictionaryEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createJapaneseDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec.$,
        this.createJapaneseDictionary.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.renameJapaneseDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec.$,
        this.renameJapaneseDictionary.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteJapaneseDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec.$,
        this.deleteJapaneseDictionary.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.exportJapaneseDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec.$,
        this.exportJapaneseDictionary.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.importJapaneseDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec.$,
        this.importJapaneseDictionary.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearJapanesePersonalizationData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec.$,
        ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec.$,
        this.clearJapanesePersonalizationData.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('ash.ime.mojom.StatusSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.StatusSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.JapaneseLegacyConfigResponseSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.JapaneseLegacyConfigResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ash.ime.mojom.JapaneseDictionaryResponseSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
ash.ime.mojom.JapaneseDictionaryResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ash.ime.mojom.StatusSpec.$,
    'Status',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ash.ime.mojom.Status');

/** @record */
ash.ime.mojom.Status = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { (string|undefined) } */
    this.reason;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec.$,
    'InputMethodUserDataService_FetchJapaneseLegacyConfig_Params',
    [
    ],
    [[0, 8],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_Params');

/** @record */
ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec.$,
    'InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        ash.ime.mojom.JapaneseLegacyConfigResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParams');

/** @record */
ash.ime.mojom.InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParams = class {
  constructor() {
    /** @export { !ash.ime.mojom.JapaneseLegacyConfigResponse } */
    this.response;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec.$,
    'InputMethodUserDataService_FetchJapaneseDictionary_Params',
    [
    ],
    [[0, 8],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_Params');

/** @record */
ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec.$,
    'InputMethodUserDataService_FetchJapaneseDictionary_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        ash.ime.mojom.JapaneseDictionaryResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ResponseParams');

/** @record */
ash.ime.mojom.InputMethodUserDataService_FetchJapaneseDictionary_ResponseParams = class {
  constructor() {
    /** @export { !ash.ime.mojom.JapaneseDictionaryResponse } */
    this.response;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec.$,
    'InputMethodUserDataService_AddJapaneseDictionaryEntry_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'entry', 8,
        0,
        ash.ime.mojom.JapaneseDictionaryEntrySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_Params');

/** @record */
ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.dictId;
    /** @export { !ash.ime.mojom.JapaneseDictionaryEntry } */
    this.entry;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec.$,
    'InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ash.ime.mojom.StatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParams');

/** @record */
ash.ime.mojom.InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParams = class {
  constructor() {
    /** @export { !ash.ime.mojom.Status } */
    this.status;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec.$,
    'InputMethodUserDataService_EditJapaneseDictionaryEntry_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'entryIndex', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'entry', 16,
        0,
        ash.ime.mojom.JapaneseDictionaryEntrySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_Params');

/** @record */
ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.dictId;
    /** @export { !number } */
    this.entryIndex;
    /** @export { !ash.ime.mojom.JapaneseDictionaryEntry } */
    this.entry;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec.$,
    'InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ash.ime.mojom.StatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParams');

/** @record */
ash.ime.mojom.InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParams = class {
  constructor() {
    /** @export { !ash.ime.mojom.Status } */
    this.status;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec.$,
    'InputMethodUserDataService_DeleteJapaneseDictionaryEntry_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'entryIndex', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_Params');

/** @record */
ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.dictId;
    /** @export { !number } */
    this.entryIndex;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec.$,
    'InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ash.ime.mojom.StatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParams');

/** @record */
ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParams = class {
  constructor() {
    /** @export { !ash.ime.mojom.Status } */
    this.status;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec.$,
    'InputMethodUserDataService_CreateJapaneseDictionary_Params',
    [
      mojo.internal.StructField(
        'dictionaryName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_Params');

/** @record */
ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_Params = class {
  constructor() {
    /** @export { !string } */
    this.dictionaryName;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec.$,
    'InputMethodUserDataService_CreateJapaneseDictionary_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ash.ime.mojom.StatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ResponseParams');

/** @record */
ash.ime.mojom.InputMethodUserDataService_CreateJapaneseDictionary_ResponseParams = class {
  constructor() {
    /** @export { !ash.ime.mojom.Status } */
    this.status;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec.$,
    'InputMethodUserDataService_RenameJapaneseDictionary_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'dictionaryName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_Params');

/** @record */
ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.dictId;
    /** @export { !string } */
    this.dictionaryName;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec.$,
    'InputMethodUserDataService_RenameJapaneseDictionary_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ash.ime.mojom.StatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ResponseParams');

/** @record */
ash.ime.mojom.InputMethodUserDataService_RenameJapaneseDictionary_ResponseParams = class {
  constructor() {
    /** @export { !ash.ime.mojom.Status } */
    this.status;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec.$,
    'InputMethodUserDataService_DeleteJapaneseDictionary_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_Params');

/** @record */
ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.dictId;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec.$,
    'InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ash.ime.mojom.StatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParams');

/** @record */
ash.ime.mojom.InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParams = class {
  constructor() {
    /** @export { !ash.ime.mojom.Status } */
    this.status;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec.$,
    'InputMethodUserDataService_ExportJapaneseDictionary_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_Params');

/** @record */
ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.dictId;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec.$,
    'InputMethodUserDataService_ExportJapaneseDictionary_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase.mojom.BigStringSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ResponseParams');

/** @record */
ash.ime.mojom.InputMethodUserDataService_ExportJapaneseDictionary_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.BigString } */
    this.result;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec.$,
    'InputMethodUserDataService_ImportJapaneseDictionary_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tsvData', 8,
        0,
        mojoBase.mojom.BigStringSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_Params');

/** @record */
ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.dictId;
    /** @export { !mojoBase.mojom.BigString } */
    this.tsvData;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec.$,
    'InputMethodUserDataService_ImportJapaneseDictionary_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ash.ime.mojom.StatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ResponseParams');

/** @record */
ash.ime.mojom.InputMethodUserDataService_ImportJapaneseDictionary_ResponseParams = class {
  constructor() {
    /** @export { !ash.ime.mojom.Status } */
    this.status;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec.$,
    'InputMethodUserDataService_ClearJapanesePersonalizationData_Params',
    [
      mojo.internal.StructField(
        'clearConversionHistory', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clearSuggestionHistory', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_Params');

/** @record */
ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.clearConversionHistory;
    /** @export { !boolean } */
    this.clearSuggestionHistory;
  }
};



mojo.internal.Struct(
    ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec.$,
    'InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ash.ime.mojom.StatusSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParams');

/** @record */
ash.ime.mojom.InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParams = class {
  constructor() {
    /** @export { !ash.ime.mojom.Status } */
    this.status;
  }
};

goog.provide('ash.ime.mojom.JapaneseLegacyConfigResponse');


mojo.internal.Union(
    ash.ime.mojom.JapaneseLegacyConfigResponseSpec.$, 'JapaneseLegacyConfigResponse',
    {
      'errorReason': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'response': {
        'ordinal': 1,
        'type': ash.ime.mojom.JapaneseLegacyConfigSpec.$,
      },
    });

/**
 * @typedef { {
 *   errorReason: (!string|undefined),
 *   response: (!ash.ime.mojom.JapaneseLegacyConfig|undefined),
 * } }
 */
ash.ime.mojom.JapaneseLegacyConfigResponse;
goog.provide('ash.ime.mojom.JapaneseDictionaryResponse');


mojo.internal.Union(
    ash.ime.mojom.JapaneseDictionaryResponseSpec.$, 'JapaneseDictionaryResponse',
    {
      'errorReason': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'dictionaries': {
        'ordinal': 1,
        'type': mojo.internal.Array(ash.ime.mojom.JapaneseDictionarySpec.$, false),
      },
    });

/**
 * @typedef { {
 *   errorReason: (!string|undefined),
 *   dictionaries: (!Array<!ash.ime.mojom.JapaneseDictionary>|undefined),
 * } }
 */
ash.ime.mojom.JapaneseDictionaryResponse;
