// chromeos/ash/services/ime/public/mojom/input_method_user_data.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../../mojo/public/js/bindings.js';

import {
  BigString as mojoBase_mojom_BigString,
  BigStringSpec as mojoBase_mojom_BigStringSpec
} from '../../../../../../mojo/public/mojom/base/big_string.mojom.m.js';

import {
  JapaneseDictionary as ash_ime_mojom_JapaneseDictionary,
  JapaneseDictionarySpec as ash_ime_mojom_JapaneseDictionarySpec,
  JapaneseDictionaryEntry as ash_ime_mojom_JapaneseDictionaryEntry,
  JapaneseDictionaryEntrySpec as ash_ime_mojom_JapaneseDictionaryEntrySpec
} from './user_data_japanese_dictionary.mojom.m.js';

import {
  JapaneseLegacyConfig as ash_ime_mojom_JapaneseLegacyConfig,
  JapaneseLegacyConfigSpec as ash_ime_mojom_JapaneseLegacyConfigSpec
} from './user_data_japanese_legacy_config.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class InputMethodUserDataServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.ime.mojom.InputMethodUserDataService', scope);
  }
}

/** @interface */
export class InputMethodUserDataServiceInterface {
  
  /**
   * @return {!Promise<{
        response: !JapaneseLegacyConfigResponse,
   *  }>}
   */

  fetchJapaneseLegacyConfig() {}
  
  /**
   * @return {!Promise<{
        response: !JapaneseDictionaryResponse,
   *  }>}
   */

  fetchJapaneseDictionary() {}
  
  /**
   * @param { !bigint } dictId
   * @param { !ash_ime_mojom_JapaneseDictionaryEntry } entry
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  addJapaneseDictionaryEntry(dictId, entry) {}
  
  /**
   * @param { !bigint } dictId
   * @param { !number } entryIndex
   * @param { !ash_ime_mojom_JapaneseDictionaryEntry } entry
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  editJapaneseDictionaryEntry(dictId, entryIndex, entry) {}
  
  /**
   * @param { !bigint } dictId
   * @param { !number } entryIndex
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  deleteJapaneseDictionaryEntry(dictId, entryIndex) {}
  
  /**
   * @param { !string } dictionaryName
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  createJapaneseDictionary(dictionaryName) {}
  
  /**
   * @param { !bigint } dictId
   * @param { !string } dictionaryName
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  renameJapaneseDictionary(dictId, dictionaryName) {}
  
  /**
   * @param { !bigint } dictId
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  deleteJapaneseDictionary(dictId) {}
  
  /**
   * @param { !bigint } dictId
   * @return {!Promise<{
        result: !mojoBase_mojom_BigString,
   *  }>}
   */

  exportJapaneseDictionary(dictId) {}
  
  /**
   * @param { !bigint } dictId
   * @param { !mojoBase_mojom_BigString } tsvData
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  importJapaneseDictionary(dictId, tsvData) {}
  
  /**
   * @param { !boolean } clearConversionHistory
   * @param { !boolean } clearSuggestionHistory
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  clearJapanesePersonalizationData(clearConversionHistory, clearSuggestionHistory) {}
}

/**
 * @implements { InputMethodUserDataServiceInterface }
 */
export class InputMethodUserDataServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!InputMethodUserDataServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          InputMethodUserDataServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!InputMethodUserDataServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        response: !JapaneseLegacyConfigResponse,
   *  }>}
   */

  fetchJapaneseLegacyConfig() {
    return this.proxy.sendMessage(
        0,
        InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec.$,
        InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        response: !JapaneseDictionaryResponse,
   *  }>}
   */

  fetchJapaneseDictionary() {
    return this.proxy.sendMessage(
        1,
        InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @param { !ash_ime_mojom_JapaneseDictionaryEntry } entry
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  addJapaneseDictionaryEntry(
      dictId,
      entry) {
    return this.proxy.sendMessage(
        2,
        InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec.$,
        InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec.$,
        [
          dictId,
          entry
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @param { !number } entryIndex
   * @param { !ash_ime_mojom_JapaneseDictionaryEntry } entry
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  editJapaneseDictionaryEntry(
      dictId,
      entryIndex,
      entry) {
    return this.proxy.sendMessage(
        3,
        InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec.$,
        InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec.$,
        [
          dictId,
          entryIndex,
          entry
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @param { !number } entryIndex
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  deleteJapaneseDictionaryEntry(
      dictId,
      entryIndex) {
    return this.proxy.sendMessage(
        4,
        InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec.$,
        InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec.$,
        [
          dictId,
          entryIndex
        ],
        false);
  }

  
  /**
   * @param { !string } dictionaryName
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  createJapaneseDictionary(
      dictionaryName) {
    return this.proxy.sendMessage(
        5,
        InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec.$,
        [
          dictionaryName
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @param { !string } dictionaryName
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  renameJapaneseDictionary(
      dictId,
      dictionaryName) {
    return this.proxy.sendMessage(
        6,
        InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec.$,
        [
          dictId,
          dictionaryName
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  deleteJapaneseDictionary(
      dictId) {
    return this.proxy.sendMessage(
        7,
        InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec.$,
        [
          dictId
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @return {!Promise<{
        result: !mojoBase_mojom_BigString,
   *  }>}
   */

  exportJapaneseDictionary(
      dictId) {
    return this.proxy.sendMessage(
        8,
        InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec.$,
        [
          dictId
        ],
        false);
  }

  
  /**
   * @param { !bigint } dictId
   * @param { !mojoBase_mojom_BigString } tsvData
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  importJapaneseDictionary(
      dictId,
      tsvData) {
    return this.proxy.sendMessage(
        9,
        InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec.$,
        [
          dictId,
          tsvData
        ],
        false);
  }

  
  /**
   * @param { !boolean } clearConversionHistory
   * @param { !boolean } clearSuggestionHistory
   * @return {!Promise<{
        status: !Status,
   *  }>}
   */

  clearJapanesePersonalizationData(
      clearConversionHistory,
      clearSuggestionHistory) {
    return this.proxy.sendMessage(
        10,
        InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec.$,
        InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec.$,
        [
          clearConversionHistory,
          clearSuggestionHistory
        ],
        false);
  }
}

/**
 * An object which receives request messages for the InputMethodUserDataService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InputMethodUserDataServiceReceiver {
  /**
   * @param {!InputMethodUserDataServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!InputMethodUserDataServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        InputMethodUserDataServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InputMethodUserDataServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec.$,
        InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec.$,
        impl.fetchJapaneseLegacyConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec.$,
        impl.fetchJapaneseDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec.$,
        InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec.$,
        impl.addJapaneseDictionaryEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec.$,
        InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec.$,
        impl.editJapaneseDictionaryEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec.$,
        InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec.$,
        impl.deleteJapaneseDictionaryEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec.$,
        impl.createJapaneseDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec.$,
        impl.renameJapaneseDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec.$,
        impl.deleteJapaneseDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec.$,
        impl.exportJapaneseDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec.$,
        impl.importJapaneseDictionary.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec.$,
        InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec.$,
        impl.clearJapanesePersonalizationData.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class InputMethodUserDataService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.ime.mojom.InputMethodUserDataService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!InputMethodUserDataServiceRemote}
   */
  static getRemote() {
    let remote = new InputMethodUserDataServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the InputMethodUserDataService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InputMethodUserDataServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      InputMethodUserDataServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!InputMethodUserDataServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fetchJapaneseLegacyConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec.$,
        InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec.$,
        this.fetchJapaneseLegacyConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.fetchJapaneseDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec.$,
        this.fetchJapaneseDictionary.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addJapaneseDictionaryEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec.$,
        InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec.$,
        this.addJapaneseDictionaryEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.editJapaneseDictionaryEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec.$,
        InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec.$,
        this.editJapaneseDictionaryEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteJapaneseDictionaryEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec.$,
        InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec.$,
        this.deleteJapaneseDictionaryEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createJapaneseDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec.$,
        this.createJapaneseDictionary.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.renameJapaneseDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec.$,
        this.renameJapaneseDictionary.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteJapaneseDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec.$,
        this.deleteJapaneseDictionary.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.exportJapaneseDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec.$,
        this.exportJapaneseDictionary.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.importJapaneseDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec.$,
        InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec.$,
        this.importJapaneseDictionary.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearJapanesePersonalizationData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec.$,
        InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec.$,
        this.clearJapanesePersonalizationData.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StatusSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const JapaneseLegacyConfigResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const JapaneseDictionaryResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    StatusSpec.$,
    'Status',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reason', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Status {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { (string|undefined) } */
    this.reason;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_FetchJapaneseLegacyConfig_ParamsSpec.$,
    'InputMethodUserDataService_FetchJapaneseLegacyConfig_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class InputMethodUserDataService_FetchJapaneseLegacyConfig_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParamsSpec.$,
    'InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        JapaneseLegacyConfigResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputMethodUserDataService_FetchJapaneseLegacyConfig_ResponseParams {
  constructor() {
    /** @type { !JapaneseLegacyConfigResponse } */
    this.response;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_FetchJapaneseDictionary_ParamsSpec.$,
    'InputMethodUserDataService_FetchJapaneseDictionary_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class InputMethodUserDataService_FetchJapaneseDictionary_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_FetchJapaneseDictionary_ResponseParamsSpec.$,
    'InputMethodUserDataService_FetchJapaneseDictionary_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        JapaneseDictionaryResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputMethodUserDataService_FetchJapaneseDictionary_ResponseParams {
  constructor() {
    /** @type { !JapaneseDictionaryResponse } */
    this.response;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_AddJapaneseDictionaryEntry_ParamsSpec.$,
    'InputMethodUserDataService_AddJapaneseDictionaryEntry_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'entry', 8,
        0,
        ash_ime_mojom_JapaneseDictionaryEntrySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputMethodUserDataService_AddJapaneseDictionaryEntry_Params {
  constructor() {
    /** @type { !bigint } */
    this.dictId;
    /** @type { !ash_ime_mojom_JapaneseDictionaryEntry } */
    this.entry;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParamsSpec.$,
    'InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        StatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodUserDataService_AddJapaneseDictionaryEntry_ResponseParams {
  constructor() {
    /** @type { !Status } */
    this.status;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_EditJapaneseDictionaryEntry_ParamsSpec.$,
    'InputMethodUserDataService_EditJapaneseDictionaryEntry_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'entryIndex', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'entry', 16,
        0,
        ash_ime_mojom_JapaneseDictionaryEntrySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class InputMethodUserDataService_EditJapaneseDictionaryEntry_Params {
  constructor() {
    /** @type { !bigint } */
    this.dictId;
    /** @type { !number } */
    this.entryIndex;
    /** @type { !ash_ime_mojom_JapaneseDictionaryEntry } */
    this.entry;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParamsSpec.$,
    'InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        StatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodUserDataService_EditJapaneseDictionaryEntry_ResponseParams {
  constructor() {
    /** @type { !Status } */
    this.status;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ParamsSpec.$,
    'InputMethodUserDataService_DeleteJapaneseDictionaryEntry_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'entryIndex', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputMethodUserDataService_DeleteJapaneseDictionaryEntry_Params {
  constructor() {
    /** @type { !bigint } */
    this.dictId;
    /** @type { !number } */
    this.entryIndex;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParamsSpec.$,
    'InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        StatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodUserDataService_DeleteJapaneseDictionaryEntry_ResponseParams {
  constructor() {
    /** @type { !Status } */
    this.status;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_CreateJapaneseDictionary_ParamsSpec.$,
    'InputMethodUserDataService_CreateJapaneseDictionary_Params',
    [
      mojo.internal.StructField(
        'dictionaryName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodUserDataService_CreateJapaneseDictionary_Params {
  constructor() {
    /** @type { !string } */
    this.dictionaryName;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_CreateJapaneseDictionary_ResponseParamsSpec.$,
    'InputMethodUserDataService_CreateJapaneseDictionary_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        StatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodUserDataService_CreateJapaneseDictionary_ResponseParams {
  constructor() {
    /** @type { !Status } */
    this.status;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_RenameJapaneseDictionary_ParamsSpec.$,
    'InputMethodUserDataService_RenameJapaneseDictionary_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dictionaryName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputMethodUserDataService_RenameJapaneseDictionary_Params {
  constructor() {
    /** @type { !bigint } */
    this.dictId;
    /** @type { !string } */
    this.dictionaryName;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_RenameJapaneseDictionary_ResponseParamsSpec.$,
    'InputMethodUserDataService_RenameJapaneseDictionary_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        StatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodUserDataService_RenameJapaneseDictionary_ResponseParams {
  constructor() {
    /** @type { !Status } */
    this.status;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_DeleteJapaneseDictionary_ParamsSpec.$,
    'InputMethodUserDataService_DeleteJapaneseDictionary_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodUserDataService_DeleteJapaneseDictionary_Params {
  constructor() {
    /** @type { !bigint } */
    this.dictId;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParamsSpec.$,
    'InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        StatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodUserDataService_DeleteJapaneseDictionary_ResponseParams {
  constructor() {
    /** @type { !Status } */
    this.status;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_ExportJapaneseDictionary_ParamsSpec.$,
    'InputMethodUserDataService_ExportJapaneseDictionary_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodUserDataService_ExportJapaneseDictionary_Params {
  constructor() {
    /** @type { !bigint } */
    this.dictId;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_ExportJapaneseDictionary_ResponseParamsSpec.$,
    'InputMethodUserDataService_ExportJapaneseDictionary_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojoBase_mojom_BigStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodUserDataService_ExportJapaneseDictionary_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_BigString } */
    this.result;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_ImportJapaneseDictionary_ParamsSpec.$,
    'InputMethodUserDataService_ImportJapaneseDictionary_Params',
    [
      mojo.internal.StructField(
        'dictId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tsvData', 8,
        0,
        mojoBase_mojom_BigStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class InputMethodUserDataService_ImportJapaneseDictionary_Params {
  constructor() {
    /** @type { !bigint } */
    this.dictId;
    /** @type { !mojoBase_mojom_BigString } */
    this.tsvData;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_ImportJapaneseDictionary_ResponseParamsSpec.$,
    'InputMethodUserDataService_ImportJapaneseDictionary_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        StatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodUserDataService_ImportJapaneseDictionary_ResponseParams {
  constructor() {
    /** @type { !Status } */
    this.status;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_ClearJapanesePersonalizationData_ParamsSpec.$,
    'InputMethodUserDataService_ClearJapanesePersonalizationData_Params',
    [
      mojo.internal.StructField(
        'clearConversionHistory', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clearSuggestionHistory', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodUserDataService_ClearJapanesePersonalizationData_Params {
  constructor() {
    /** @type { !boolean } */
    this.clearConversionHistory;
    /** @type { !boolean } */
    this.clearSuggestionHistory;
  }
}



mojo.internal.Struct(
    InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParamsSpec.$,
    'InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        StatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class InputMethodUserDataService_ClearJapanesePersonalizationData_ResponseParams {
  constructor() {
    /** @type { !Status } */
    this.status;
  }
}

mojo.internal.Union(
    JapaneseLegacyConfigResponseSpec.$, 'JapaneseLegacyConfigResponse',
    {
      'errorReason': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'response': {
        'ordinal': 1,
        'type': ash_ime_mojom_JapaneseLegacyConfigSpec.$,
      },
    });

/**
 * @typedef { {
 *   errorReason: (!string|undefined),
 *   response: (!ash_ime_mojom_JapaneseLegacyConfig|undefined),
 * } }
 */
export const JapaneseLegacyConfigResponse = {};
mojo.internal.Union(
    JapaneseDictionaryResponseSpec.$, 'JapaneseDictionaryResponse',
    {
      'errorReason': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'dictionaries': {
        'ordinal': 1,
        'type': mojo.internal.Array(ash_ime_mojom_JapaneseDictionarySpec.$, false),
      },
    });

/**
 * @typedef { {
 *   errorReason: (!string|undefined),
 *   dictionaries: (!Array<!ash_ime_mojom_JapaneseDictionary>|undefined),
 * } }
 */
export const JapaneseDictionaryResponse = {};
