// chromeos/ash/services/ime/public/mojom/user_data_japanese_dictionary.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/ash/services/ime/public/mojom/user_data_japanese_dictionary.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ash.ime.mojom');


  var JpPosType = {};
  JpPosType.kNoPos = 0;
  JpPosType.kNoun = 1;
  JpPosType.kAbbreviation = 2;
  JpPosType.kSuggestionOnly = 3;
  JpPosType.kProperNoun = 4;
  JpPosType.kPersonalName = 5;
  JpPosType.kFamilyName = 6;
  JpPosType.kFirstName = 7;
  JpPosType.kOrganizationName = 8;
  JpPosType.kPlaceName = 9;
  JpPosType.kSaIrregularConjugationNoun = 10;
  JpPosType.kAdjectiveVerbalNoun = 11;
  JpPosType.kNumber = 12;
  JpPosType.kAlphabet = 13;
  JpPosType.kSymbol = 14;
  JpPosType.kEmoticon = 15;
  JpPosType.kAdverb = 16;
  JpPosType.kPrenounAdjectival = 17;
  JpPosType.kConjunction = 18;
  JpPosType.kInterjection = 19;
  JpPosType.kPrefix = 20;
  JpPosType.kCounterSuffix = 21;
  JpPosType.kGenericSuffix = 22;
  JpPosType.kPersonNameSuffix = 23;
  JpPosType.kPlaceNameSuffix = 24;
  JpPosType.kWaGroup1Verb = 25;
  JpPosType.kKaGroup1Verb = 26;
  JpPosType.kSaGroup1Verb = 27;
  JpPosType.kTaGroup1Verb = 28;
  JpPosType.kNaGroup1Verb = 29;
  JpPosType.kMaGroup1Verb = 30;
  JpPosType.kRaGroup1Verb = 31;
  JpPosType.kGaGroup1Verb = 32;
  JpPosType.kBaGroup1Verb = 33;
  JpPosType.kHaGroup1Verb = 34;
  JpPosType.kGroup2Verb = 35;
  JpPosType.kKuruGroup3Verb = 36;
  JpPosType.kSuruGroup3Verb = 37;
  JpPosType.kZuruGroup3Verb = 38;
  JpPosType.kRuGroup3Verb = 39;
  JpPosType.kAdjective = 40;
  JpPosType.kSentenceEndingParticle = 41;
  JpPosType.kPunctuation = 42;
  JpPosType.kFreeStandingWord = 43;
  JpPosType.kSuppressionWord = 44;
  JpPosType.MIN_VALUE = 0;
  JpPosType.MAX_VALUE = 44;

  JpPosType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 30:
    case 31:
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
    case 38:
    case 39:
    case 40:
    case 41:
    case 42:
    case 43:
    case 44:
      return true;
    }
    return false;
  };

  JpPosType.toKnownEnumValue = function(value) {
    return value;
  };

  JpPosType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function JapaneseDictionaryEntry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  JapaneseDictionaryEntry.prototype.initDefaults_ = function() {
    this.key = null;
    this.value = null;
    this.pos = 0;
    this.comment = null;
  };
  JapaneseDictionaryEntry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  JapaneseDictionaryEntry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate JapaneseDictionaryEntry.key
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate JapaneseDictionaryEntry.value
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate JapaneseDictionaryEntry.pos
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, JpPosType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate JapaneseDictionaryEntry.comment
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  JapaneseDictionaryEntry.encodedSize = codec.kStructHeaderSize + 32;

  JapaneseDictionaryEntry.decode = function(decoder) {
    var packed;
    var val = new JapaneseDictionaryEntry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.key =
        decoder.decodeStruct(codec.String);
    val.value =
        decoder.decodeStruct(codec.String);
    val.pos =
        decoder.decodeStruct(new codec.Enum(JpPosType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.comment =
        decoder.decodeStruct(codec.String);
    return val;
  };

  JapaneseDictionaryEntry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(JapaneseDictionaryEntry.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.key);
    encoder.encodeStruct(codec.String, val.value);
    encoder.encodeStruct(codec.Int32, val.pos);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.comment);
  };
  function JapaneseDictionary(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  JapaneseDictionary.prototype.initDefaults_ = function() {
    this.id = 0;
    this.name = null;
    this.entries = null;
  };
  JapaneseDictionary.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  JapaneseDictionary.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate JapaneseDictionary.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate JapaneseDictionary.entries
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(JapaneseDictionaryEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  JapaneseDictionary.encodedSize = codec.kStructHeaderSize + 24;

  JapaneseDictionary.decode = function(decoder) {
    var packed;
    var val = new JapaneseDictionary();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Uint64);
    val.name =
        decoder.decodeStruct(codec.String);
    val.entries =
        decoder.decodeArrayPointer(new codec.PointerTo(JapaneseDictionaryEntry));
    return val;
  };

  JapaneseDictionary.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(JapaneseDictionary.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.id);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeArrayPointer(new codec.PointerTo(JapaneseDictionaryEntry), val.entries);
  };
  exports.JpPosType = JpPosType;
  exports.JapaneseDictionaryEntry = JapaneseDictionaryEntry;
  exports.JapaneseDictionary = JapaneseDictionary;
})();