// chromeos/ash/services/orca/public/mojom/orca_service.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('ash.orca.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.orca.mojom.PresetTextQueryTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.orca.mojom.PresetTextQueryType = {
  
  kUnknown: 0,
  kShorten: 1,
  kElaborate: 2,
  kRephrase: 3,
  kFormalize: 4,
  kEmojify: 5,
  kProofread: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.orca.mojom.MetricEventSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.orca.mojom.MetricEvent = {
  
  kUnknown: 0,
  kRefineRequest: 1,
  kFeedbackThumbsUp: 2,
  kFeedbackThumbsDown: 3,
  kReturnToPreviousSuggestions: 4,
  kWebUIRequest: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.orca.mojom.TextQueryErrorCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.orca.mojom.TextQueryErrorCode = {
  
  kUnknown: 0,
  kInvalidArgument: 1,
  kResourceExhausted: 2,
  kBackendFailure: 3,
  kNoInternetConnection: 4,
  kUnsupportedLanguage: 5,
  kBlockedOutputs: 6,
  kRestrictedRegion: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.orca.mojom.EditorClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.orca.mojom.EditorClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.orca.mojom.EditorClientInterface }
 */
ash.orca.mojom.EditorClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.orca.mojom.EditorClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.orca.mojom.EditorClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.orca.mojom.EditorClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        textQueries: !Array<!ash.orca.mojom.PresetTextQuery>,
   *  }>}
   */

  getPresetTextQueries() {
    return this.proxy.sendMessage(
        0,
        ash.orca.mojom.EditorClient_GetPresetTextQueries_ParamsSpec.$,
        ash.orca.mojom.EditorClient_GetPresetTextQueries_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } textQueryId
   * @param { ?string } textOverride
   * @return {!Promise<{
        response: !ash.orca.mojom.TextQueryResponse,
   *  }>}
   */

  requestPresetRewrite(
      textQueryId,
      textOverride) {
    return this.proxy.sendMessage(
        1,
        ash.orca.mojom.EditorClient_RequestPresetRewrite_ParamsSpec.$,
        ash.orca.mojom.EditorClient_RequestPresetRewrite_ResponseParamsSpec.$,
        [
          textQueryId,
          textOverride
        ],
        false);
  }

  
  /**
   * @param { !string } input
   * @param { ?string } textOverride
   * @return {!Promise<{
        response: !ash.orca.mojom.TextQueryResponse,
   *  }>}
   */

  requestFreeformRewrite(
      input,
      textOverride) {
    return this.proxy.sendMessage(
        2,
        ash.orca.mojom.EditorClient_RequestFreeformRewrite_ParamsSpec.$,
        ash.orca.mojom.EditorClient_RequestFreeformRewrite_ResponseParamsSpec.$,
        [
          input,
          textOverride
        ],
        false);
  }

  
  /**
   * @param { !string } input
   * @return {!Promise<{
        response: !ash.orca.mojom.TextQueryResponse,
   *  }>}
   */

  requestFreeformWrite(
      input) {
    return this.proxy.sendMessage(
        3,
        ash.orca.mojom.EditorClient_RequestFreeformWrite_ParamsSpec.$,
        ash.orca.mojom.EditorClient_RequestFreeformWrite_ResponseParamsSpec.$,
        [
          input
        ],
        false);
  }

  
  /**
   * @param { !string } text
   */

  insertText(
      text) {
    this.proxy.sendMessage(
        4,
        ash.orca.mojom.EditorClient_InsertText_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }

  
  /**
   */

  approveConsent() {
    this.proxy.sendMessage(
        5,
        ash.orca.mojom.EditorClient_ApproveConsent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  declineConsent() {
    this.proxy.sendMessage(
        6,
        ash.orca.mojom.EditorClient_DeclineConsent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  dismissConsent() {
    this.proxy.sendMessage(
        7,
        ash.orca.mojom.EditorClient_DismissConsent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   */

  openUrlInNewWindow(
      url) {
    this.proxy.sendMessage(
        8,
        ash.orca.mojom.EditorClient_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  
  /**
   */

  showUI() {
    this.proxy.sendMessage(
        9,
        ash.orca.mojom.EditorClient_ShowUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  closeUI() {
    this.proxy.sendMessage(
        10,
        ash.orca.mojom.EditorClient_CloseUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } text
   */

  appendText(
      text) {
    this.proxy.sendMessage(
        11,
        ash.orca.mojom.EditorClient_AppendText_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !string } resultId
   * @return {!Promise<{
        preview: !Object<!string, !string>,
   *  }>}
   */

  previewFeedback(
      resultId) {
    return this.proxy.sendMessage(
        12,
        ash.orca.mojom.EditorClient_PreviewFeedback_ParamsSpec.$,
        ash.orca.mojom.EditorClient_PreviewFeedback_ResponseParamsSpec.$,
        [
          resultId
        ],
        false);
  }

  
  /**
   * @param { !string } resultId
   * @param { !string } userDescription
   */

  submitFeedback(
      resultId,
      userDescription) {
    this.proxy.sendMessage(
        13,
        ash.orca.mojom.EditorClient_SubmitFeedback_ParamsSpec.$,
        null,
        [
          resultId,
          userDescription
        ],
        false);
  }

  
  /**
   * @param { !ash.orca.mojom.TriggerContext } triggerContext
   */

  onTrigger(
      triggerContext) {
    this.proxy.sendMessage(
        14,
        ash.orca.mojom.EditorClient_OnTrigger_ParamsSpec.$,
        null,
        [
          triggerContext
        ],
        false);
  }

  
  /**
   * @param { !ash.orca.mojom.MetricEvent } metricEvent
   */

  emitMetricEvent(
      metricEvent) {
    this.proxy.sendMessage(
        15,
        ash.orca.mojom.EditorClient_EmitMetricEvent_ParamsSpec.$,
        null,
        [
          metricEvent
        ],
        false);
  }
};

/**
 * An object which receives request messages for the EditorClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.orca.mojom.EditorClientReceiver = class {
  /**
   * @param {!ash.orca.mojom.EditorClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.orca.mojom.EditorClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.orca.mojom.EditorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.orca.mojom.EditorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.orca.mojom.EditorClient_GetPresetTextQueries_ParamsSpec.$,
        ash.orca.mojom.EditorClient_GetPresetTextQueries_ResponseParamsSpec.$,
        impl.getPresetTextQueries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.orca.mojom.EditorClient_RequestPresetRewrite_ParamsSpec.$,
        ash.orca.mojom.EditorClient_RequestPresetRewrite_ResponseParamsSpec.$,
        impl.requestPresetRewrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.orca.mojom.EditorClient_RequestFreeformRewrite_ParamsSpec.$,
        ash.orca.mojom.EditorClient_RequestFreeformRewrite_ResponseParamsSpec.$,
        impl.requestFreeformRewrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ash.orca.mojom.EditorClient_RequestFreeformWrite_ParamsSpec.$,
        ash.orca.mojom.EditorClient_RequestFreeformWrite_ResponseParamsSpec.$,
        impl.requestFreeformWrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ash.orca.mojom.EditorClient_InsertText_ParamsSpec.$,
        null,
        impl.insertText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ash.orca.mojom.EditorClient_ApproveConsent_ParamsSpec.$,
        null,
        impl.approveConsent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ash.orca.mojom.EditorClient_DeclineConsent_ParamsSpec.$,
        null,
        impl.declineConsent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ash.orca.mojom.EditorClient_DismissConsent_ParamsSpec.$,
        null,
        impl.dismissConsent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        ash.orca.mojom.EditorClient_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        impl.openUrlInNewWindow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        ash.orca.mojom.EditorClient_ShowUI_ParamsSpec.$,
        null,
        impl.showUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        ash.orca.mojom.EditorClient_CloseUI_ParamsSpec.$,
        null,
        impl.closeUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        ash.orca.mojom.EditorClient_AppendText_ParamsSpec.$,
        null,
        impl.appendText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        ash.orca.mojom.EditorClient_PreviewFeedback_ParamsSpec.$,
        ash.orca.mojom.EditorClient_PreviewFeedback_ResponseParamsSpec.$,
        impl.previewFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        ash.orca.mojom.EditorClient_SubmitFeedback_ParamsSpec.$,
        null,
        impl.submitFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        ash.orca.mojom.EditorClient_OnTrigger_ParamsSpec.$,
        null,
        impl.onTrigger.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        ash.orca.mojom.EditorClient_EmitMetricEvent_ParamsSpec.$,
        null,
        impl.emitMetricEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.orca.mojom.EditorClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.orca.mojom.EditorClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.orca.mojom.EditorClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.orca.mojom.EditorClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the EditorClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.orca.mojom.EditorClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.orca.mojom.EditorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.orca.mojom.EditorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPresetTextQueries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.orca.mojom.EditorClient_GetPresetTextQueries_ParamsSpec.$,
        ash.orca.mojom.EditorClient_GetPresetTextQueries_ResponseParamsSpec.$,
        this.getPresetTextQueries.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPresetRewrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.orca.mojom.EditorClient_RequestPresetRewrite_ParamsSpec.$,
        ash.orca.mojom.EditorClient_RequestPresetRewrite_ResponseParamsSpec.$,
        this.requestPresetRewrite.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestFreeformRewrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.orca.mojom.EditorClient_RequestFreeformRewrite_ParamsSpec.$,
        ash.orca.mojom.EditorClient_RequestFreeformRewrite_ResponseParamsSpec.$,
        this.requestFreeformRewrite.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestFreeformWrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ash.orca.mojom.EditorClient_RequestFreeformWrite_ParamsSpec.$,
        ash.orca.mojom.EditorClient_RequestFreeformWrite_ResponseParamsSpec.$,
        this.requestFreeformWrite.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.insertText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ash.orca.mojom.EditorClient_InsertText_ParamsSpec.$,
        null,
        this.insertText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.approveConsent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ash.orca.mojom.EditorClient_ApproveConsent_ParamsSpec.$,
        null,
        this.approveConsent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.declineConsent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ash.orca.mojom.EditorClient_DeclineConsent_ParamsSpec.$,
        null,
        this.declineConsent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dismissConsent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ash.orca.mojom.EditorClient_DismissConsent_ParamsSpec.$,
        null,
        this.dismissConsent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openUrlInNewWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        ash.orca.mojom.EditorClient_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        this.openUrlInNewWindow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        ash.orca.mojom.EditorClient_ShowUI_ParamsSpec.$,
        null,
        this.showUI.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        ash.orca.mojom.EditorClient_CloseUI_ParamsSpec.$,
        null,
        this.closeUI.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.appendText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        ash.orca.mojom.EditorClient_AppendText_ParamsSpec.$,
        null,
        this.appendText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.previewFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        ash.orca.mojom.EditorClient_PreviewFeedback_ParamsSpec.$,
        ash.orca.mojom.EditorClient_PreviewFeedback_ResponseParamsSpec.$,
        this.previewFeedback.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submitFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        ash.orca.mojom.EditorClient_SubmitFeedback_ParamsSpec.$,
        null,
        this.submitFeedback.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTrigger =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        ash.orca.mojom.EditorClient_OnTrigger_ParamsSpec.$,
        null,
        this.onTrigger.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.emitMetricEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        ash.orca.mojom.EditorClient_EmitMetricEvent_ParamsSpec.$,
        null,
        this.emitMetricEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.orca.mojom.EditorClientConnectorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.orca.mojom.EditorClientConnector.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.orca.mojom.EditorClientConnectorInterface }
 */
ash.orca.mojom.EditorClientConnectorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.orca.mojom.EditorClientConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.orca.mojom.EditorClientConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.orca.mojom.EditorClientConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.orca.mojom.EditorClientPendingReceiver } editorClient
   */

  bindEditorClient(
      editorClient) {
    this.proxy.sendMessage(
        0,
        ash.orca.mojom.EditorClientConnector_BindEditorClient_ParamsSpec.$,
        null,
        [
          editorClient
        ],
        false);
  }
};

/**
 * An object which receives request messages for the EditorClientConnector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.orca.mojom.EditorClientConnectorReceiver = class {
  /**
   * @param {!ash.orca.mojom.EditorClientConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.orca.mojom.EditorClientConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.orca.mojom.EditorClientConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.orca.mojom.EditorClientConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.orca.mojom.EditorClientConnector_BindEditorClient_ParamsSpec.$,
        null,
        impl.bindEditorClient.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.orca.mojom.EditorClientConnector = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.orca.mojom.EditorClientConnector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.orca.mojom.EditorClientConnectorRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.orca.mojom.EditorClientConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the EditorClientConnector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.orca.mojom.EditorClientConnectorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.orca.mojom.EditorClientConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.orca.mojom.EditorClientConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindEditorClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.orca.mojom.EditorClientConnector_BindEditorClient_ParamsSpec.$,
        null,
        this.bindEditorClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.orca.mojom.EditorEventSinkPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.orca.mojom.EditorEventSink.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.orca.mojom.EditorEventSinkInterface }
 */
ash.orca.mojom.EditorEventSinkRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.orca.mojom.EditorEventSinkPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.orca.mojom.EditorEventSinkPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.orca.mojom.EditorEventSinkPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.orca.mojom.Context } context
   */

  onContextUpdated(
      context) {
    this.proxy.sendMessage(
        0,
        ash.orca.mojom.EditorEventSink_OnContextUpdated_ParamsSpec.$,
        null,
        [
          context
        ],
        false);
  }
};

/**
 * An object which receives request messages for the EditorEventSink
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.orca.mojom.EditorEventSinkReceiver = class {
  /**
   * @param {!ash.orca.mojom.EditorEventSinkInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.orca.mojom.EditorEventSinkRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.orca.mojom.EditorEventSinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.orca.mojom.EditorEventSinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.orca.mojom.EditorEventSink_OnContextUpdated_ParamsSpec.$,
        null,
        impl.onContextUpdated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.orca.mojom.EditorEventSink = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.orca.mojom.EditorEventSink";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.orca.mojom.EditorEventSinkRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.orca.mojom.EditorEventSinkRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the EditorEventSink
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.orca.mojom.EditorEventSinkCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.orca.mojom.EditorEventSinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.orca.mojom.EditorEventSinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onContextUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.orca.mojom.EditorEventSink_OnContextUpdated_ParamsSpec.$,
        null,
        this.onContextUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.orca.mojom.SystemActuatorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.orca.mojom.SystemActuator.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.orca.mojom.SystemActuatorInterface }
 */
ash.orca.mojom.SystemActuatorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.orca.mojom.SystemActuatorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.orca.mojom.SystemActuatorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.orca.mojom.SystemActuatorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } text
   */

  insertText(
      text) {
    this.proxy.sendMessage(
        0,
        ash.orca.mojom.SystemActuator_InsertText_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }

  
  /**
   */

  approveConsent() {
    this.proxy.sendMessage(
        1,
        ash.orca.mojom.SystemActuator_ApproveConsent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  declineConsent() {
    this.proxy.sendMessage(
        2,
        ash.orca.mojom.SystemActuator_DeclineConsent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   */

  openUrlInNewWindow(
      url) {
    this.proxy.sendMessage(
        3,
        ash.orca.mojom.SystemActuator_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  
  /**
   */

  showUI() {
    this.proxy.sendMessage(
        4,
        ash.orca.mojom.SystemActuator_ShowUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  closeUI() {
    this.proxy.sendMessage(
        5,
        ash.orca.mojom.SystemActuator_CloseUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } description
   */

  submitFeedback(
      description) {
    this.proxy.sendMessage(
        6,
        ash.orca.mojom.SystemActuator_SubmitFeedback_ParamsSpec.$,
        null,
        [
          description
        ],
        false);
  }

  
  /**
   * @param { !ash.orca.mojom.TriggerContext } triggerContext
   */

  onTrigger(
      triggerContext) {
    this.proxy.sendMessage(
        7,
        ash.orca.mojom.SystemActuator_OnTrigger_ParamsSpec.$,
        null,
        [
          triggerContext
        ],
        false);
  }

  
  /**
   * @param { !ash.orca.mojom.MetricEvent } metricEvent
   */

  emitMetricEvent(
      metricEvent) {
    this.proxy.sendMessage(
        8,
        ash.orca.mojom.SystemActuator_EmitMetricEvent_ParamsSpec.$,
        null,
        [
          metricEvent
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SystemActuator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.orca.mojom.SystemActuatorReceiver = class {
  /**
   * @param {!ash.orca.mojom.SystemActuatorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.orca.mojom.SystemActuatorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.orca.mojom.SystemActuatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.orca.mojom.SystemActuatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.orca.mojom.SystemActuator_InsertText_ParamsSpec.$,
        null,
        impl.insertText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.orca.mojom.SystemActuator_ApproveConsent_ParamsSpec.$,
        null,
        impl.approveConsent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.orca.mojom.SystemActuator_DeclineConsent_ParamsSpec.$,
        null,
        impl.declineConsent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ash.orca.mojom.SystemActuator_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        impl.openUrlInNewWindow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ash.orca.mojom.SystemActuator_ShowUI_ParamsSpec.$,
        null,
        impl.showUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ash.orca.mojom.SystemActuator_CloseUI_ParamsSpec.$,
        null,
        impl.closeUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ash.orca.mojom.SystemActuator_SubmitFeedback_ParamsSpec.$,
        null,
        impl.submitFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ash.orca.mojom.SystemActuator_OnTrigger_ParamsSpec.$,
        null,
        impl.onTrigger.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        ash.orca.mojom.SystemActuator_EmitMetricEvent_ParamsSpec.$,
        null,
        impl.emitMetricEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.orca.mojom.SystemActuator = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.orca.mojom.SystemActuator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.orca.mojom.SystemActuatorRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.orca.mojom.SystemActuatorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SystemActuator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.orca.mojom.SystemActuatorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.orca.mojom.SystemActuatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.orca.mojom.SystemActuatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.insertText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.orca.mojom.SystemActuator_InsertText_ParamsSpec.$,
        null,
        this.insertText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.approveConsent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.orca.mojom.SystemActuator_ApproveConsent_ParamsSpec.$,
        null,
        this.approveConsent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.declineConsent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.orca.mojom.SystemActuator_DeclineConsent_ParamsSpec.$,
        null,
        this.declineConsent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openUrlInNewWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ash.orca.mojom.SystemActuator_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        this.openUrlInNewWindow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ash.orca.mojom.SystemActuator_ShowUI_ParamsSpec.$,
        null,
        this.showUI.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ash.orca.mojom.SystemActuator_CloseUI_ParamsSpec.$,
        null,
        this.closeUI.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submitFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ash.orca.mojom.SystemActuator_SubmitFeedback_ParamsSpec.$,
        null,
        this.submitFeedback.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTrigger =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ash.orca.mojom.SystemActuator_OnTrigger_ParamsSpec.$,
        null,
        this.onTrigger.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.emitMetricEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        ash.orca.mojom.SystemActuator_EmitMetricEvent_ParamsSpec.$,
        null,
        this.emitMetricEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.orca.mojom.TextQueryProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.orca.mojom.TextQueryProvider.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.orca.mojom.TextQueryProviderInterface }
 */
ash.orca.mojom.TextQueryProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.orca.mojom.TextQueryProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.orca.mojom.TextQueryProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.orca.mojom.TextQueryProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.orca.mojom.TextQueryRequest } request
   * @return {!Promise<{
        response: !ash.orca.mojom.TextQueryResponse,
   *  }>}
   */

  process(
      request) {
    return this.proxy.sendMessage(
        0,
        ash.orca.mojom.TextQueryProvider_Process_ParamsSpec.$,
        ash.orca.mojom.TextQueryProvider_Process_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TextQueryProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.orca.mojom.TextQueryProviderReceiver = class {
  /**
   * @param {!ash.orca.mojom.TextQueryProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.orca.mojom.TextQueryProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.orca.mojom.TextQueryProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.orca.mojom.TextQueryProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.orca.mojom.TextQueryProvider_Process_ParamsSpec.$,
        ash.orca.mojom.TextQueryProvider_Process_ResponseParamsSpec.$,
        impl.process.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.orca.mojom.TextQueryProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.orca.mojom.TextQueryProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.orca.mojom.TextQueryProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.orca.mojom.TextQueryProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TextQueryProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.orca.mojom.TextQueryProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.orca.mojom.TextQueryProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.orca.mojom.TextQueryProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.process =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.orca.mojom.TextQueryProvider_Process_ParamsSpec.$,
        ash.orca.mojom.TextQueryProvider_Process_ResponseParamsSpec.$,
        this.process.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.orca.mojom.OrcaServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.orca.mojom.OrcaService.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.orca.mojom.OrcaServiceInterface }
 */
ash.orca.mojom.OrcaServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.orca.mojom.OrcaServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.orca.mojom.OrcaServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.orca.mojom.OrcaServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } systemActuator
   * @param { !Object } textQueryProvider
   * @param { !Object } clientConnector
   * @param { !Object } eventSink
   * @param { ?ash.orca.mojom.EditorConfig } editorConfig
   */

  bindEditor(
      systemActuator,
      textQueryProvider,
      clientConnector,
      eventSink,
      editorConfig) {
    this.proxy.sendMessage(
        0,
        ash.orca.mojom.OrcaService_BindEditor_ParamsSpec.$,
        null,
        [
          systemActuator,
          textQueryProvider,
          clientConnector,
          eventSink,
          editorConfig
        ],
        false);
  }
};

/**
 * An object which receives request messages for the OrcaService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.orca.mojom.OrcaServiceReceiver = class {
  /**
   * @param {!ash.orca.mojom.OrcaServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.orca.mojom.OrcaServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.orca.mojom.OrcaServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.orca.mojom.OrcaServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.orca.mojom.OrcaService_BindEditor_ParamsSpec.$,
        null,
        impl.bindEditor.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.orca.mojom.OrcaService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.orca.mojom.OrcaService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.orca.mojom.OrcaServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.orca.mojom.OrcaServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the OrcaService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.orca.mojom.OrcaServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.orca.mojom.OrcaServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.orca.mojom.OrcaServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindEditor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.orca.mojom.OrcaService_BindEditor_ParamsSpec.$,
        null,
        this.bindEditor.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.PresetTextQuerySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.TextQueryRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.TextQueryResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.TextQueryErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.SurroundingTextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.ContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.TriggerContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_GetPresetTextQueries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_GetPresetTextQueries_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_RequestPresetRewrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_RequestPresetRewrite_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_RequestFreeformRewrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_RequestFreeformRewrite_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_RequestFreeformWrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_RequestFreeformWrite_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_InsertText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_ApproveConsent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_DeclineConsent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_DismissConsent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_OpenUrlInNewWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_ShowUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_CloseUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_AppendText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_PreviewFeedback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_PreviewFeedback_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_SubmitFeedback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_OnTrigger_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClient_EmitMetricEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorClientConnector_BindEditorClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.EditorEventSink_OnContextUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.SystemActuator_InsertText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.SystemActuator_ApproveConsent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.SystemActuator_DeclineConsent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.SystemActuator_OpenUrlInNewWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.SystemActuator_ShowUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.SystemActuator_CloseUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.SystemActuator_SubmitFeedback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.SystemActuator_OnTrigger_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.SystemActuator_EmitMetricEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.TextQueryProvider_Process_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.TextQueryProvider_Process_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.orca.mojom.OrcaService_BindEditor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
ash.orca.mojom.TextQueryResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ash.orca.mojom.PresetTextQuerySpec.$,
    'PresetTextQuery',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'description', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 24,
        0,
        ash.orca.mojom.PresetTextQueryTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
ash.orca.mojom.PresetTextQuery = class {
  constructor() {
    /** @export { !string } */
    this.id;
    /** @export { !string } */
    this.label;
    /** @export { !string } */
    this.description;
    /** @export { !ash.orca.mojom.PresetTextQueryType } */
    this.type;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.TextQueryRequestSpec.$,
    'TextQueryRequest',
    [
      mojo.internal.StructField(
        'textQueryId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'version', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'parameters', 16,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
ash.orca.mojom.TextQueryRequest = class {
  constructor() {
    /** @export { !string } */
    this.textQueryId;
    /** @export { !string } */
    this.version;
    /** @export { !Object<!string, !string> } */
    this.parameters;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.TextQueryResultSpec.$,
    'TextQueryResult',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.orca.mojom.TextQueryResult = class {
  constructor() {
    /** @export { !string } */
    this.id;
    /** @export { !string } */
    this.text;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.TextQueryErrorSpec.$,
    'TextQueryError',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        ash.orca.mojom.TextQueryErrorCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.orca.mojom.TextQueryError = class {
  constructor() {
    /** @export { !ash.orca.mojom.TextQueryErrorCode } */
    this.code;
    /** @export { !string } */
    this.message;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.SurroundingTextSpec.$,
    'SurroundingText',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'range', 8,
        0,
        gfx.mojom.RangeSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.orca.mojom.SurroundingText = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { !gfx.mojom.Range } */
    this.range;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.ContextSpec.$,
    'Context',
    [
      mojo.internal.StructField(
        'surroundingText', 0,
        0,
        ash.orca.mojom.SurroundingTextSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.Context = class {
  constructor() {
    /** @export { !ash.orca.mojom.SurroundingText } */
    this.surroundingText;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorConfigSpec.$,
    'EditorConfig',
    [
      mojo.internal.StructField(
        'allowedQueryTypes', 0,
        0,
        mojo.internal.Array(ash.orca.mojom.PresetTextQueryTypeSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'languageCode', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[12, 24],]);





/** @record */
ash.orca.mojom.EditorConfig = class {
  constructor() {
    /** @export { !Array<!ash.orca.mojom.PresetTextQueryType> } */
    this.allowedQueryTypes;
    /** @export { (string|undefined) } */
    this.languageCode;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.TriggerContextSpec.$,
    'TriggerContext',
    [
      mojo.internal.StructField(
        'freeformSelected', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'presetTypeSelected', 4,
        0,
        ash.orca.mojom.PresetTextQueryTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.TriggerContext = class {
  constructor() {
    /** @export { !boolean } */
    this.freeformSelected;
    /** @export { !ash.orca.mojom.PresetTextQueryType } */
    this.presetTypeSelected;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_GetPresetTextQueries_ParamsSpec.$,
    'EditorClient_GetPresetTextQueries_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.orca.mojom.EditorClient_GetPresetTextQueries_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_GetPresetTextQueries_ResponseParamsSpec.$,
    'EditorClient_GetPresetTextQueries_ResponseParams',
    [
      mojo.internal.StructField(
        'textQueries', 0,
        0,
        mojo.internal.Array(ash.orca.mojom.PresetTextQuerySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.EditorClient_GetPresetTextQueries_ResponseParams = class {
  constructor() {
    /** @export { !Array<!ash.orca.mojom.PresetTextQuery> } */
    this.textQueries;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_RequestPresetRewrite_ParamsSpec.$,
    'EditorClient_RequestPresetRewrite_Params',
    [
      mojo.internal.StructField(
        'textQueryId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textOverride', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.orca.mojom.EditorClient_RequestPresetRewrite_Params = class {
  constructor() {
    /** @export { !string } */
    this.textQueryId;
    /** @export { (string|undefined) } */
    this.textOverride;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_RequestPresetRewrite_ResponseParamsSpec.$,
    'EditorClient_RequestPresetRewrite_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        ash.orca.mojom.TextQueryResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.orca.mojom.EditorClient_RequestPresetRewrite_ResponseParams = class {
  constructor() {
    /** @export { !ash.orca.mojom.TextQueryResponse } */
    this.response;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_RequestFreeformRewrite_ParamsSpec.$,
    'EditorClient_RequestFreeformRewrite_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textOverride', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.orca.mojom.EditorClient_RequestFreeformRewrite_Params = class {
  constructor() {
    /** @export { !string } */
    this.input;
    /** @export { (string|undefined) } */
    this.textOverride;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_RequestFreeformRewrite_ResponseParamsSpec.$,
    'EditorClient_RequestFreeformRewrite_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        ash.orca.mojom.TextQueryResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.orca.mojom.EditorClient_RequestFreeformRewrite_ResponseParams = class {
  constructor() {
    /** @export { !ash.orca.mojom.TextQueryResponse } */
    this.response;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_RequestFreeformWrite_ParamsSpec.$,
    'EditorClient_RequestFreeformWrite_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.EditorClient_RequestFreeformWrite_Params = class {
  constructor() {
    /** @export { !string } */
    this.input;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_RequestFreeformWrite_ResponseParamsSpec.$,
    'EditorClient_RequestFreeformWrite_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        ash.orca.mojom.TextQueryResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.orca.mojom.EditorClient_RequestFreeformWrite_ResponseParams = class {
  constructor() {
    /** @export { !ash.orca.mojom.TextQueryResponse } */
    this.response;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_InsertText_ParamsSpec.$,
    'EditorClient_InsertText_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.EditorClient_InsertText_Params = class {
  constructor() {
    /** @export { !string } */
    this.text;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_ApproveConsent_ParamsSpec.$,
    'EditorClient_ApproveConsent_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.orca.mojom.EditorClient_ApproveConsent_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_DeclineConsent_ParamsSpec.$,
    'EditorClient_DeclineConsent_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.orca.mojom.EditorClient_DeclineConsent_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_DismissConsent_ParamsSpec.$,
    'EditorClient_DismissConsent_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.orca.mojom.EditorClient_DismissConsent_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_OpenUrlInNewWindow_ParamsSpec.$,
    'EditorClient_OpenUrlInNewWindow_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.EditorClient_OpenUrlInNewWindow_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_ShowUI_ParamsSpec.$,
    'EditorClient_ShowUI_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.orca.mojom.EditorClient_ShowUI_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_CloseUI_ParamsSpec.$,
    'EditorClient_CloseUI_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.orca.mojom.EditorClient_CloseUI_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_AppendText_ParamsSpec.$,
    'EditorClient_AppendText_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.EditorClient_AppendText_Params = class {
  constructor() {
    /** @export { !string } */
    this.text;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_PreviewFeedback_ParamsSpec.$,
    'EditorClient_PreviewFeedback_Params',
    [
      mojo.internal.StructField(
        'resultId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.EditorClient_PreviewFeedback_Params = class {
  constructor() {
    /** @export { !string } */
    this.resultId;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_PreviewFeedback_ResponseParamsSpec.$,
    'EditorClient_PreviewFeedback_ResponseParams',
    [
      mojo.internal.StructField(
        'preview', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.EditorClient_PreviewFeedback_ResponseParams = class {
  constructor() {
    /** @export { !Object<!string, !string> } */
    this.preview;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_SubmitFeedback_ParamsSpec.$,
    'EditorClient_SubmitFeedback_Params',
    [
      mojo.internal.StructField(
        'resultId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'userDescription', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.orca.mojom.EditorClient_SubmitFeedback_Params = class {
  constructor() {
    /** @export { !string } */
    this.resultId;
    /** @export { !string } */
    this.userDescription;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_OnTrigger_ParamsSpec.$,
    'EditorClient_OnTrigger_Params',
    [
      mojo.internal.StructField(
        'triggerContext', 0,
        0,
        ash.orca.mojom.TriggerContextSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.EditorClient_OnTrigger_Params = class {
  constructor() {
    /** @export { !ash.orca.mojom.TriggerContext } */
    this.triggerContext;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClient_EmitMetricEvent_ParamsSpec.$,
    'EditorClient_EmitMetricEvent_Params',
    [
      mojo.internal.StructField(
        'metricEvent', 0,
        0,
        ash.orca.mojom.MetricEventSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.EditorClient_EmitMetricEvent_Params = class {
  constructor() {
    /** @export { !ash.orca.mojom.MetricEvent } */
    this.metricEvent;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorClientConnector_BindEditorClient_ParamsSpec.$,
    'EditorClientConnector_BindEditorClient_Params',
    [
      mojo.internal.StructField(
        'editorClient', 0,
        0,
        mojo.internal.InterfaceRequest(ash.orca.mojom.EditorClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.EditorClientConnector_BindEditorClient_Params = class {
  constructor() {
    /** @export { !ash.orca.mojom.EditorClientPendingReceiver } */
    this.editorClient;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.EditorEventSink_OnContextUpdated_ParamsSpec.$,
    'EditorEventSink_OnContextUpdated_Params',
    [
      mojo.internal.StructField(
        'context', 0,
        0,
        ash.orca.mojom.ContextSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.EditorEventSink_OnContextUpdated_Params = class {
  constructor() {
    /** @export { !ash.orca.mojom.Context } */
    this.context;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.SystemActuator_InsertText_ParamsSpec.$,
    'SystemActuator_InsertText_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.SystemActuator_InsertText_Params = class {
  constructor() {
    /** @export { !string } */
    this.text;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.SystemActuator_ApproveConsent_ParamsSpec.$,
    'SystemActuator_ApproveConsent_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.orca.mojom.SystemActuator_ApproveConsent_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.orca.mojom.SystemActuator_DeclineConsent_ParamsSpec.$,
    'SystemActuator_DeclineConsent_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.orca.mojom.SystemActuator_DeclineConsent_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.orca.mojom.SystemActuator_OpenUrlInNewWindow_ParamsSpec.$,
    'SystemActuator_OpenUrlInNewWindow_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.SystemActuator_OpenUrlInNewWindow_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.SystemActuator_ShowUI_ParamsSpec.$,
    'SystemActuator_ShowUI_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.orca.mojom.SystemActuator_ShowUI_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.orca.mojom.SystemActuator_CloseUI_ParamsSpec.$,
    'SystemActuator_CloseUI_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.orca.mojom.SystemActuator_CloseUI_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.orca.mojom.SystemActuator_SubmitFeedback_ParamsSpec.$,
    'SystemActuator_SubmitFeedback_Params',
    [
      mojo.internal.StructField(
        'description', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.SystemActuator_SubmitFeedback_Params = class {
  constructor() {
    /** @export { !string } */
    this.description;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.SystemActuator_OnTrigger_ParamsSpec.$,
    'SystemActuator_OnTrigger_Params',
    [
      mojo.internal.StructField(
        'triggerContext', 0,
        0,
        ash.orca.mojom.TriggerContextSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.SystemActuator_OnTrigger_Params = class {
  constructor() {
    /** @export { !ash.orca.mojom.TriggerContext } */
    this.triggerContext;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.SystemActuator_EmitMetricEvent_ParamsSpec.$,
    'SystemActuator_EmitMetricEvent_Params',
    [
      mojo.internal.StructField(
        'metricEvent', 0,
        0,
        ash.orca.mojom.MetricEventSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.SystemActuator_EmitMetricEvent_Params = class {
  constructor() {
    /** @export { !ash.orca.mojom.MetricEvent } */
    this.metricEvent;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.TextQueryProvider_Process_ParamsSpec.$,
    'TextQueryProvider_Process_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        ash.orca.mojom.TextQueryRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.orca.mojom.TextQueryProvider_Process_Params = class {
  constructor() {
    /** @export { !ash.orca.mojom.TextQueryRequest } */
    this.request;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.TextQueryProvider_Process_ResponseParamsSpec.$,
    'TextQueryProvider_Process_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        ash.orca.mojom.TextQueryResponseSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.orca.mojom.TextQueryProvider_Process_ResponseParams = class {
  constructor() {
    /** @export { !ash.orca.mojom.TextQueryResponse } */
    this.response;
  }
};



mojo.internal.Struct(
    ash.orca.mojom.OrcaService_BindEditor_ParamsSpec.$,
    'OrcaService_BindEditor_Params',
    [
      mojo.internal.StructField(
        'systemActuator', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(ash.orca.mojom.SystemActuatorRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textQueryProvider', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(ash.orca.mojom.TextQueryProviderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientConnector', 16,
        0,
        mojo.internal.AssociatedInterfaceRequest(ash.orca.mojom.EditorClientConnectorPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventSink', 20,
        0,
        mojo.internal.AssociatedInterfaceRequest(ash.orca.mojom.EditorEventSinkPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'editorConfig', 24,
        0,
        ash.orca.mojom.EditorConfigSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],[9, 40],]);





/** @record */
ash.orca.mojom.OrcaService_BindEditor_Params = class {
  constructor() {
    /** @export { !Object } */
    this.systemActuator;
    /** @export { !Object } */
    this.textQueryProvider;
    /** @export { !Object } */
    this.clientConnector;
    /** @export { !Object } */
    this.eventSink;
    /** @export { (ash.orca.mojom.EditorConfig|undefined) } */
    this.editorConfig;
  }
};



mojo.internal.Union(
    ash.orca.mojom.TextQueryResponseSpec.$, 'TextQueryResponse',
    {
      'results': {
        'ordinal': 0,
        'type': mojo.internal.Array(ash.orca.mojom.TextQueryResultSpec.$, false),
      },
      'error': {
        'ordinal': 1,
        'type': ash.orca.mojom.TextQueryErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   results: (!Array<!ash.orca.mojom.TextQueryResult>|undefined),
 *   error: (!ash.orca.mojom.TextQueryError|undefined),
 * } }
 */
ash.orca.mojom.TextQueryResponse;
