// chromeos/ash/services/orca/public/mojom/orca_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/ash/services/orca/public/mojom/orca_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ash.orca.mojom');
  var sandbox$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/sandbox.mojom', '../../../../../../sandbox/policy/mojom/sandbox.mojom.js');
  }
  var range$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/range/mojom/range.mojom', '../../../../../../ui/gfx/range/mojom/range.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../../url/mojom/url.mojom.js');
  }


  var PresetTextQueryType = {};
  PresetTextQueryType.kUnknown = 0;
  PresetTextQueryType.kShorten = 1;
  PresetTextQueryType.kElaborate = 2;
  PresetTextQueryType.kRephrase = 3;
  PresetTextQueryType.kFormalize = 4;
  PresetTextQueryType.kEmojify = 5;
  PresetTextQueryType.kProofread = 6;
  PresetTextQueryType.MIN_VALUE = 0;
  PresetTextQueryType.MAX_VALUE = 6;
  PresetTextQueryType.DEFAULT_VALUE = 0;

  PresetTextQueryType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  PresetTextQueryType.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  PresetTextQueryType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MetricEvent = {};
  MetricEvent.kUnknown = 0;
  MetricEvent.kRefineRequest = 1;
  MetricEvent.kFeedbackThumbsUp = 2;
  MetricEvent.kFeedbackThumbsDown = 3;
  MetricEvent.kReturnToPreviousSuggestions = 4;
  MetricEvent.kWebUIRequest = 5;
  MetricEvent.MIN_VALUE = 0;
  MetricEvent.MAX_VALUE = 5;
  MetricEvent.DEFAULT_VALUE = 0;

  MetricEvent.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  MetricEvent.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  MetricEvent.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var TextQueryErrorCode = {};
  TextQueryErrorCode.kUnknown = 0;
  TextQueryErrorCode.kInvalidArgument = 1;
  TextQueryErrorCode.kResourceExhausted = 2;
  TextQueryErrorCode.kBackendFailure = 3;
  TextQueryErrorCode.kNoInternetConnection = 4;
  TextQueryErrorCode.kUnsupportedLanguage = 5;
  TextQueryErrorCode.kBlockedOutputs = 6;
  TextQueryErrorCode.kRestrictedRegion = 7;
  TextQueryErrorCode.MIN_VALUE = 0;
  TextQueryErrorCode.MAX_VALUE = 7;
  TextQueryErrorCode.DEFAULT_VALUE = 0;

  TextQueryErrorCode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  TextQueryErrorCode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  TextQueryErrorCode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function PresetTextQuery(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PresetTextQuery.prototype.initDefaults_ = function() {
    this.id = null;
    this.label = null;
    this.description = null;
    this.type = 0;
  };
  PresetTextQuery.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PresetTextQuery.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PresetTextQuery.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PresetTextQuery.label
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PresetTextQuery.description
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PresetTextQuery.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, PresetTextQueryType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PresetTextQuery.encodedSize = codec.kStructHeaderSize + 32;

  PresetTextQuery.decode = function(decoder) {
    var packed;
    var val = new PresetTextQuery();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.String);
    val.label =
        decoder.decodeStruct(codec.String);
    val.description =
        decoder.decodeStruct(codec.String);
    val.type =
        decoder.decodeStruct(new codec.Enum(PresetTextQueryType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PresetTextQuery.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PresetTextQuery.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.id);
    encoder.encodeStruct(codec.String, val.label);
    encoder.encodeStruct(codec.String, val.description);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TextQueryRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextQueryRequest.prototype.initDefaults_ = function() {
    this.textQueryId = null;
    this.version = null;
    this.parameters = null;
  };
  TextQueryRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextQueryRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextQueryRequest.textQueryId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextQueryRequest.version
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextQueryRequest.parameters
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 16, false, codec.String, codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextQueryRequest.encodedSize = codec.kStructHeaderSize + 24;

  TextQueryRequest.decode = function(decoder) {
    var packed;
    var val = new TextQueryRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.textQueryId =
        decoder.decodeStruct(codec.String);
    val.version =
        decoder.decodeStruct(codec.String);
    val.parameters =
        decoder.decodeMapPointer(codec.String, codec.String);
    return val;
  };

  TextQueryRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextQueryRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.textQueryId);
    encoder.encodeStruct(codec.String, val.version);
    encoder.encodeMapPointer(codec.String, codec.String, val.parameters);
  };
  function TextQueryResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextQueryResult.prototype.initDefaults_ = function() {
    this.id = null;
    this.text = null;
  };
  TextQueryResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextQueryResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextQueryResult.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextQueryResult.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextQueryResult.encodedSize = codec.kStructHeaderSize + 16;

  TextQueryResult.decode = function(decoder) {
    var packed;
    var val = new TextQueryResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.String);
    val.text =
        decoder.decodeStruct(codec.String);
    return val;
  };

  TextQueryResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextQueryResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.id);
    encoder.encodeStruct(codec.String, val.text);
  };
  function TextQueryError(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextQueryError.prototype.initDefaults_ = function() {
    this.code = 0;
    this.message = null;
  };
  TextQueryError.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextQueryError.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextQueryError.code
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, TextQueryErrorCode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextQueryError.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextQueryError.encodedSize = codec.kStructHeaderSize + 16;

  TextQueryError.decode = function(decoder) {
    var packed;
    var val = new TextQueryError();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.code =
        decoder.decodeStruct(new codec.Enum(TextQueryErrorCode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.message =
        decoder.decodeStruct(codec.String);
    return val;
  };

  TextQueryError.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextQueryError.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.code);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.message);
  };
  function SurroundingText(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SurroundingText.prototype.initDefaults_ = function() {
    this.text = null;
    this.range = null;
  };
  SurroundingText.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SurroundingText.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SurroundingText.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SurroundingText.range
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, range$.Range, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SurroundingText.encodedSize = codec.kStructHeaderSize + 16;

  SurroundingText.decode = function(decoder) {
    var packed;
    var val = new SurroundingText();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.range =
        decoder.decodeStructPointer(range$.Range);
    return val;
  };

  SurroundingText.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SurroundingText.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStructPointer(range$.Range, val.range);
  };
  function Context(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Context.prototype.initDefaults_ = function() {
    this.surroundingText = null;
  };
  Context.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Context.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Context.surroundingText
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SurroundingText, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Context.encodedSize = codec.kStructHeaderSize + 8;

  Context.decode = function(decoder) {
    var packed;
    var val = new Context();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.surroundingText =
        decoder.decodeStructPointer(SurroundingText);
    return val;
  };

  Context.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Context.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SurroundingText, val.surroundingText);
  };
  function EditorConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorConfig.prototype.initDefaults_ = function() {
    this.allowedQueryTypes = null;
    this.languageCode = null;
  };
  EditorConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 12, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorConfig.allowedQueryTypes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(PresetTextQueryType), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // version check EditorConfig.languageCode
    if (!messageValidator.isFieldInStructVersion(offset, 12))
      return validator.validationError.NONE;
    // validate EditorConfig.languageCode
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorConfig.encodedSize = codec.kStructHeaderSize + 16;

  EditorConfig.decode = function(decoder) {
    var packed;
    var val = new EditorConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.allowedQueryTypes =
        decoder.decodeArrayPointer(new codec.Enum(PresetTextQueryType));
    if (version >= 12) {
      val.languageCode =
          decoder.decodeStruct(codec.String);
    } else {
      val.languageCode = null;
    }
    return val;
  };

  EditorConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorConfig.encodedSize);
    encoder.writeUint32(12);
    encoder.encodeArrayPointer(new codec.Enum(PresetTextQueryType), val.allowedQueryTypes);
    encoder.encodeStruct(codec.String, val.languageCode);
  };
  function TriggerContext(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TriggerContext.prototype.initDefaults_ = function() {
    this.freeformSelected = false;
    this.presetTypeSelected = 0;
  };
  TriggerContext.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TriggerContext.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate TriggerContext.presetTypeSelected
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, PresetTextQueryType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TriggerContext.encodedSize = codec.kStructHeaderSize + 8;

  TriggerContext.decode = function(decoder) {
    var packed;
    var val = new TriggerContext();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.freeformSelected = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.presetTypeSelected =
        decoder.decodeStruct(new codec.Enum(PresetTextQueryType));
    return val;
  };

  TriggerContext.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TriggerContext.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.freeformSelected & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.presetTypeSelected);
  };
  function EditorClient_GetPresetTextQueries_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_GetPresetTextQueries_Params.prototype.initDefaults_ = function() {
  };
  EditorClient_GetPresetTextQueries_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_GetPresetTextQueries_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_GetPresetTextQueries_Params.encodedSize = codec.kStructHeaderSize + 0;

  EditorClient_GetPresetTextQueries_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_GetPresetTextQueries_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  EditorClient_GetPresetTextQueries_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_GetPresetTextQueries_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function EditorClient_GetPresetTextQueries_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_GetPresetTextQueries_ResponseParams.prototype.initDefaults_ = function() {
    this.textQueries = null;
  };
  EditorClient_GetPresetTextQueries_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_GetPresetTextQueries_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_GetPresetTextQueries_ResponseParams.textQueries
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(PresetTextQuery), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_GetPresetTextQueries_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  EditorClient_GetPresetTextQueries_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new EditorClient_GetPresetTextQueries_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.textQueries =
        decoder.decodeArrayPointer(new codec.PointerTo(PresetTextQuery));
    return val;
  };

  EditorClient_GetPresetTextQueries_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_GetPresetTextQueries_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(PresetTextQuery), val.textQueries);
  };
  function EditorClient_RequestPresetRewrite_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_RequestPresetRewrite_Params.prototype.initDefaults_ = function() {
    this.textQueryId = null;
    this.textOverride = null;
  };
  EditorClient_RequestPresetRewrite_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_RequestPresetRewrite_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_RequestPresetRewrite_Params.textQueryId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_RequestPresetRewrite_Params.textOverride
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_RequestPresetRewrite_Params.encodedSize = codec.kStructHeaderSize + 16;

  EditorClient_RequestPresetRewrite_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_RequestPresetRewrite_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.textQueryId =
        decoder.decodeStruct(codec.String);
    val.textOverride =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EditorClient_RequestPresetRewrite_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_RequestPresetRewrite_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.textQueryId);
    encoder.encodeStruct(codec.String, val.textOverride);
  };
  function EditorClient_RequestPresetRewrite_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_RequestPresetRewrite_ResponseParams.prototype.initDefaults_ = function() {
    this.response = null;
  };
  EditorClient_RequestPresetRewrite_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_RequestPresetRewrite_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_RequestPresetRewrite_ResponseParams.response
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, TextQueryResponse, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_RequestPresetRewrite_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  EditorClient_RequestPresetRewrite_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new EditorClient_RequestPresetRewrite_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.response =
        decoder.decodeStruct(TextQueryResponse);
    return val;
  };

  EditorClient_RequestPresetRewrite_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_RequestPresetRewrite_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(TextQueryResponse, val.response);
  };
  function EditorClient_RequestFreeformRewrite_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_RequestFreeformRewrite_Params.prototype.initDefaults_ = function() {
    this.input = null;
    this.textOverride = null;
  };
  EditorClient_RequestFreeformRewrite_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_RequestFreeformRewrite_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_RequestFreeformRewrite_Params.input
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_RequestFreeformRewrite_Params.textOverride
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_RequestFreeformRewrite_Params.encodedSize = codec.kStructHeaderSize + 16;

  EditorClient_RequestFreeformRewrite_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_RequestFreeformRewrite_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStruct(codec.String);
    val.textOverride =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EditorClient_RequestFreeformRewrite_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_RequestFreeformRewrite_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.input);
    encoder.encodeStruct(codec.String, val.textOverride);
  };
  function EditorClient_RequestFreeformRewrite_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_RequestFreeformRewrite_ResponseParams.prototype.initDefaults_ = function() {
    this.response = null;
  };
  EditorClient_RequestFreeformRewrite_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_RequestFreeformRewrite_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_RequestFreeformRewrite_ResponseParams.response
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, TextQueryResponse, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_RequestFreeformRewrite_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  EditorClient_RequestFreeformRewrite_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new EditorClient_RequestFreeformRewrite_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.response =
        decoder.decodeStruct(TextQueryResponse);
    return val;
  };

  EditorClient_RequestFreeformRewrite_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_RequestFreeformRewrite_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(TextQueryResponse, val.response);
  };
  function EditorClient_RequestFreeformWrite_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_RequestFreeformWrite_Params.prototype.initDefaults_ = function() {
    this.input = null;
  };
  EditorClient_RequestFreeformWrite_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_RequestFreeformWrite_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_RequestFreeformWrite_Params.input
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_RequestFreeformWrite_Params.encodedSize = codec.kStructHeaderSize + 8;

  EditorClient_RequestFreeformWrite_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_RequestFreeformWrite_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EditorClient_RequestFreeformWrite_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_RequestFreeformWrite_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.input);
  };
  function EditorClient_RequestFreeformWrite_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_RequestFreeformWrite_ResponseParams.prototype.initDefaults_ = function() {
    this.response = null;
  };
  EditorClient_RequestFreeformWrite_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_RequestFreeformWrite_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_RequestFreeformWrite_ResponseParams.response
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, TextQueryResponse, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_RequestFreeformWrite_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  EditorClient_RequestFreeformWrite_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new EditorClient_RequestFreeformWrite_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.response =
        decoder.decodeStruct(TextQueryResponse);
    return val;
  };

  EditorClient_RequestFreeformWrite_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_RequestFreeformWrite_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(TextQueryResponse, val.response);
  };
  function EditorClient_InsertText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_InsertText_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  EditorClient_InsertText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_InsertText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_InsertText_Params.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_InsertText_Params.encodedSize = codec.kStructHeaderSize + 8;

  EditorClient_InsertText_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_InsertText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EditorClient_InsertText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_InsertText_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
  };
  function EditorClient_ApproveConsent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_ApproveConsent_Params.prototype.initDefaults_ = function() {
  };
  EditorClient_ApproveConsent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_ApproveConsent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_ApproveConsent_Params.encodedSize = codec.kStructHeaderSize + 0;

  EditorClient_ApproveConsent_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_ApproveConsent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  EditorClient_ApproveConsent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_ApproveConsent_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function EditorClient_DeclineConsent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_DeclineConsent_Params.prototype.initDefaults_ = function() {
  };
  EditorClient_DeclineConsent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_DeclineConsent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_DeclineConsent_Params.encodedSize = codec.kStructHeaderSize + 0;

  EditorClient_DeclineConsent_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_DeclineConsent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  EditorClient_DeclineConsent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_DeclineConsent_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function EditorClient_DismissConsent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_DismissConsent_Params.prototype.initDefaults_ = function() {
  };
  EditorClient_DismissConsent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_DismissConsent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_DismissConsent_Params.encodedSize = codec.kStructHeaderSize + 0;

  EditorClient_DismissConsent_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_DismissConsent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  EditorClient_DismissConsent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_DismissConsent_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function EditorClient_OpenUrlInNewWindow_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_OpenUrlInNewWindow_Params.prototype.initDefaults_ = function() {
    this.url = null;
  };
  EditorClient_OpenUrlInNewWindow_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_OpenUrlInNewWindow_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_OpenUrlInNewWindow_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_OpenUrlInNewWindow_Params.encodedSize = codec.kStructHeaderSize + 8;

  EditorClient_OpenUrlInNewWindow_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_OpenUrlInNewWindow_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  EditorClient_OpenUrlInNewWindow_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_OpenUrlInNewWindow_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
  };
  function EditorClient_ShowUI_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_ShowUI_Params.prototype.initDefaults_ = function() {
  };
  EditorClient_ShowUI_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_ShowUI_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_ShowUI_Params.encodedSize = codec.kStructHeaderSize + 0;

  EditorClient_ShowUI_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_ShowUI_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  EditorClient_ShowUI_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_ShowUI_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function EditorClient_CloseUI_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_CloseUI_Params.prototype.initDefaults_ = function() {
  };
  EditorClient_CloseUI_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_CloseUI_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_CloseUI_Params.encodedSize = codec.kStructHeaderSize + 0;

  EditorClient_CloseUI_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_CloseUI_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  EditorClient_CloseUI_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_CloseUI_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function EditorClient_AppendText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_AppendText_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  EditorClient_AppendText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_AppendText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_AppendText_Params.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_AppendText_Params.encodedSize = codec.kStructHeaderSize + 8;

  EditorClient_AppendText_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_AppendText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EditorClient_AppendText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_AppendText_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
  };
  function EditorClient_PreviewFeedback_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_PreviewFeedback_Params.prototype.initDefaults_ = function() {
    this.resultId = null;
  };
  EditorClient_PreviewFeedback_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_PreviewFeedback_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_PreviewFeedback_Params.resultId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_PreviewFeedback_Params.encodedSize = codec.kStructHeaderSize + 8;

  EditorClient_PreviewFeedback_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_PreviewFeedback_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.resultId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EditorClient_PreviewFeedback_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_PreviewFeedback_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.resultId);
  };
  function EditorClient_PreviewFeedback_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_PreviewFeedback_ResponseParams.prototype.initDefaults_ = function() {
    this.preview = null;
  };
  EditorClient_PreviewFeedback_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_PreviewFeedback_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_PreviewFeedback_ResponseParams.preview
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, codec.String, codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_PreviewFeedback_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  EditorClient_PreviewFeedback_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new EditorClient_PreviewFeedback_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.preview =
        decoder.decodeMapPointer(codec.String, codec.String);
    return val;
  };

  EditorClient_PreviewFeedback_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_PreviewFeedback_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(codec.String, codec.String, val.preview);
  };
  function EditorClient_SubmitFeedback_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_SubmitFeedback_Params.prototype.initDefaults_ = function() {
    this.resultId = null;
    this.userDescription = null;
  };
  EditorClient_SubmitFeedback_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_SubmitFeedback_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_SubmitFeedback_Params.resultId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_SubmitFeedback_Params.userDescription
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_SubmitFeedback_Params.encodedSize = codec.kStructHeaderSize + 16;

  EditorClient_SubmitFeedback_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_SubmitFeedback_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.resultId =
        decoder.decodeStruct(codec.String);
    val.userDescription =
        decoder.decodeStruct(codec.String);
    return val;
  };

  EditorClient_SubmitFeedback_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_SubmitFeedback_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.resultId);
    encoder.encodeStruct(codec.String, val.userDescription);
  };
  function EditorClient_OnTrigger_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_OnTrigger_Params.prototype.initDefaults_ = function() {
    this.triggerContext = null;
  };
  EditorClient_OnTrigger_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_OnTrigger_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_OnTrigger_Params.triggerContext
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, TriggerContext, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_OnTrigger_Params.encodedSize = codec.kStructHeaderSize + 8;

  EditorClient_OnTrigger_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_OnTrigger_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.triggerContext =
        decoder.decodeStructPointer(TriggerContext);
    return val;
  };

  EditorClient_OnTrigger_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_OnTrigger_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(TriggerContext, val.triggerContext);
  };
  function EditorClient_EmitMetricEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClient_EmitMetricEvent_Params.prototype.initDefaults_ = function() {
    this.metricEvent = 0;
  };
  EditorClient_EmitMetricEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClient_EmitMetricEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClient_EmitMetricEvent_Params.metricEvent
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MetricEvent);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClient_EmitMetricEvent_Params.encodedSize = codec.kStructHeaderSize + 8;

  EditorClient_EmitMetricEvent_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClient_EmitMetricEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.metricEvent =
        decoder.decodeStruct(new codec.Enum(MetricEvent));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  EditorClient_EmitMetricEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClient_EmitMetricEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.metricEvent);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EditorClientConnector_BindEditorClient_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorClientConnector_BindEditorClient_Params.prototype.initDefaults_ = function() {
    this.editorClient = new bindings.InterfaceRequest();
  };
  EditorClientConnector_BindEditorClient_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorClientConnector_BindEditorClient_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorClientConnector_BindEditorClient_Params.editorClient
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorClientConnector_BindEditorClient_Params.encodedSize = codec.kStructHeaderSize + 8;

  EditorClientConnector_BindEditorClient_Params.decode = function(decoder) {
    var packed;
    var val = new EditorClientConnector_BindEditorClient_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.editorClient =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  EditorClientConnector_BindEditorClient_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorClientConnector_BindEditorClient_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.editorClient);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function EditorEventSink_OnContextUpdated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EditorEventSink_OnContextUpdated_Params.prototype.initDefaults_ = function() {
    this.context = null;
  };
  EditorEventSink_OnContextUpdated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EditorEventSink_OnContextUpdated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate EditorEventSink_OnContextUpdated_Params.context
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, Context, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EditorEventSink_OnContextUpdated_Params.encodedSize = codec.kStructHeaderSize + 8;

  EditorEventSink_OnContextUpdated_Params.decode = function(decoder) {
    var packed;
    var val = new EditorEventSink_OnContextUpdated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.context =
        decoder.decodeStructPointer(Context);
    return val;
  };

  EditorEventSink_OnContextUpdated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EditorEventSink_OnContextUpdated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(Context, val.context);
  };
  function SystemActuator_InsertText_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemActuator_InsertText_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  SystemActuator_InsertText_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemActuator_InsertText_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SystemActuator_InsertText_Params.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SystemActuator_InsertText_Params.encodedSize = codec.kStructHeaderSize + 8;

  SystemActuator_InsertText_Params.decode = function(decoder) {
    var packed;
    var val = new SystemActuator_InsertText_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SystemActuator_InsertText_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemActuator_InsertText_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
  };
  function SystemActuator_ApproveConsent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemActuator_ApproveConsent_Params.prototype.initDefaults_ = function() {
  };
  SystemActuator_ApproveConsent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemActuator_ApproveConsent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SystemActuator_ApproveConsent_Params.encodedSize = codec.kStructHeaderSize + 0;

  SystemActuator_ApproveConsent_Params.decode = function(decoder) {
    var packed;
    var val = new SystemActuator_ApproveConsent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SystemActuator_ApproveConsent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemActuator_ApproveConsent_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SystemActuator_DeclineConsent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemActuator_DeclineConsent_Params.prototype.initDefaults_ = function() {
  };
  SystemActuator_DeclineConsent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemActuator_DeclineConsent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SystemActuator_DeclineConsent_Params.encodedSize = codec.kStructHeaderSize + 0;

  SystemActuator_DeclineConsent_Params.decode = function(decoder) {
    var packed;
    var val = new SystemActuator_DeclineConsent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SystemActuator_DeclineConsent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemActuator_DeclineConsent_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SystemActuator_OpenUrlInNewWindow_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemActuator_OpenUrlInNewWindow_Params.prototype.initDefaults_ = function() {
    this.url = null;
  };
  SystemActuator_OpenUrlInNewWindow_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemActuator_OpenUrlInNewWindow_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SystemActuator_OpenUrlInNewWindow_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SystemActuator_OpenUrlInNewWindow_Params.encodedSize = codec.kStructHeaderSize + 8;

  SystemActuator_OpenUrlInNewWindow_Params.decode = function(decoder) {
    var packed;
    var val = new SystemActuator_OpenUrlInNewWindow_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  SystemActuator_OpenUrlInNewWindow_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemActuator_OpenUrlInNewWindow_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
  };
  function SystemActuator_ShowUI_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemActuator_ShowUI_Params.prototype.initDefaults_ = function() {
  };
  SystemActuator_ShowUI_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemActuator_ShowUI_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SystemActuator_ShowUI_Params.encodedSize = codec.kStructHeaderSize + 0;

  SystemActuator_ShowUI_Params.decode = function(decoder) {
    var packed;
    var val = new SystemActuator_ShowUI_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SystemActuator_ShowUI_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemActuator_ShowUI_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SystemActuator_CloseUI_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemActuator_CloseUI_Params.prototype.initDefaults_ = function() {
  };
  SystemActuator_CloseUI_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemActuator_CloseUI_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SystemActuator_CloseUI_Params.encodedSize = codec.kStructHeaderSize + 0;

  SystemActuator_CloseUI_Params.decode = function(decoder) {
    var packed;
    var val = new SystemActuator_CloseUI_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SystemActuator_CloseUI_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemActuator_CloseUI_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SystemActuator_SubmitFeedback_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemActuator_SubmitFeedback_Params.prototype.initDefaults_ = function() {
    this.description = null;
  };
  SystemActuator_SubmitFeedback_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemActuator_SubmitFeedback_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SystemActuator_SubmitFeedback_Params.description
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SystemActuator_SubmitFeedback_Params.encodedSize = codec.kStructHeaderSize + 8;

  SystemActuator_SubmitFeedback_Params.decode = function(decoder) {
    var packed;
    var val = new SystemActuator_SubmitFeedback_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.description =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SystemActuator_SubmitFeedback_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemActuator_SubmitFeedback_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.description);
  };
  function SystemActuator_OnTrigger_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemActuator_OnTrigger_Params.prototype.initDefaults_ = function() {
    this.triggerContext = null;
  };
  SystemActuator_OnTrigger_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemActuator_OnTrigger_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SystemActuator_OnTrigger_Params.triggerContext
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, TriggerContext, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SystemActuator_OnTrigger_Params.encodedSize = codec.kStructHeaderSize + 8;

  SystemActuator_OnTrigger_Params.decode = function(decoder) {
    var packed;
    var val = new SystemActuator_OnTrigger_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.triggerContext =
        decoder.decodeStructPointer(TriggerContext);
    return val;
  };

  SystemActuator_OnTrigger_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemActuator_OnTrigger_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(TriggerContext, val.triggerContext);
  };
  function SystemActuator_EmitMetricEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemActuator_EmitMetricEvent_Params.prototype.initDefaults_ = function() {
    this.metricEvent = 0;
  };
  SystemActuator_EmitMetricEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemActuator_EmitMetricEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SystemActuator_EmitMetricEvent_Params.metricEvent
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MetricEvent);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SystemActuator_EmitMetricEvent_Params.encodedSize = codec.kStructHeaderSize + 8;

  SystemActuator_EmitMetricEvent_Params.decode = function(decoder) {
    var packed;
    var val = new SystemActuator_EmitMetricEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.metricEvent =
        decoder.decodeStruct(new codec.Enum(MetricEvent));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SystemActuator_EmitMetricEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemActuator_EmitMetricEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.metricEvent);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TextQueryProvider_Process_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextQueryProvider_Process_Params.prototype.initDefaults_ = function() {
    this.request = null;
  };
  TextQueryProvider_Process_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextQueryProvider_Process_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextQueryProvider_Process_Params.request
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, TextQueryRequest, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextQueryProvider_Process_Params.encodedSize = codec.kStructHeaderSize + 8;

  TextQueryProvider_Process_Params.decode = function(decoder) {
    var packed;
    var val = new TextQueryProvider_Process_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.request =
        decoder.decodeStructPointer(TextQueryRequest);
    return val;
  };

  TextQueryProvider_Process_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextQueryProvider_Process_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(TextQueryRequest, val.request);
  };
  function TextQueryProvider_Process_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextQueryProvider_Process_ResponseParams.prototype.initDefaults_ = function() {
    this.response = null;
  };
  TextQueryProvider_Process_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextQueryProvider_Process_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextQueryProvider_Process_ResponseParams.response
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, TextQueryResponse, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextQueryProvider_Process_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  TextQueryProvider_Process_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new TextQueryProvider_Process_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.response =
        decoder.decodeStruct(TextQueryResponse);
    return val;
  };

  TextQueryProvider_Process_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextQueryProvider_Process_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(TextQueryResponse, val.response);
  };
  function OrcaService_BindEditor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OrcaService_BindEditor_Params.prototype.initDefaults_ = function() {
    this.systemActuator = new associatedBindings.AssociatedInterfacePtrInfo();
    this.textQueryProvider = new associatedBindings.AssociatedInterfacePtrInfo();
    this.clientConnector = new associatedBindings.AssociatedInterfaceRequest();
    this.eventSink = new associatedBindings.AssociatedInterfaceRequest();
    this.editorConfig = null;
  };
  OrcaService_BindEditor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OrcaService_BindEditor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32},
      {version: 9, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OrcaService_BindEditor_Params.systemActuator
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OrcaService_BindEditor_Params.textQueryProvider
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OrcaService_BindEditor_Params.clientConnector
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate OrcaService_BindEditor_Params.eventSink
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 20, false)
    if (err !== validator.validationError.NONE)
        return err;



    // version check OrcaService_BindEditor_Params.editorConfig
    if (!messageValidator.isFieldInStructVersion(offset, 9))
      return validator.validationError.NONE;
    // validate OrcaService_BindEditor_Params.editorConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, EditorConfig, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OrcaService_BindEditor_Params.encodedSize = codec.kStructHeaderSize + 32;

  OrcaService_BindEditor_Params.decode = function(decoder) {
    var packed;
    var val = new OrcaService_BindEditor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.systemActuator =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.textQueryProvider =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    val.clientConnector =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.eventSink =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    if (version >= 9) {
      val.editorConfig =
          decoder.decodeStructPointer(EditorConfig);
    } else {
      val.editorConfig = null;
    }
    return val;
  };

  OrcaService_BindEditor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OrcaService_BindEditor_Params.encodedSize);
    encoder.writeUint32(9);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.systemActuator);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.textQueryProvider);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.clientConnector);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.eventSink);
    encoder.encodeStructPointer(EditorConfig, val.editorConfig);
  };

  function TextQueryResponse(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  TextQueryResponse.Tags = {
    results: 0,
    error: 1,
  };

  TextQueryResponse.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  TextQueryResponse.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "results",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a TextQueryResponse member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(TextQueryResponse.prototype, "results", {
    get: function() {
      if (this.$tag != TextQueryResponse.Tags.results) {
        throw new ReferenceError(
            "TextQueryResponse.results is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TextQueryResponse.Tags.results;
      this.$data = value;
    }
  });
  Object.defineProperty(TextQueryResponse.prototype, "error", {
    get: function() {
      if (this.$tag != TextQueryResponse.Tags.error) {
        throw new ReferenceError(
            "TextQueryResponse.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TextQueryResponse.Tags.error;
      this.$data = value;
    }
  });


    TextQueryResponse.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case TextQueryResponse.Tags.results:
          encoder.encodeArrayPointer(new codec.PointerTo(TextQueryResult), val.results);
          break;
        case TextQueryResponse.Tags.error:
          encoder.encodeStructPointer(TextQueryError, val.error);
          break;
      }
      encoder.align();
    };


    TextQueryResponse.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new TextQueryResponse();
      var tag = decoder.readUint32();
      switch (tag) {
        case TextQueryResponse.Tags.results:
          result.results = decoder.decodeArrayPointer(new codec.PointerTo(TextQueryResult));
          break;
        case TextQueryResponse.Tags.error:
          result.error = decoder.decodeStructPointer(TextQueryError);
          break;
      }
      decoder.align();

      return result;
    };


    TextQueryResponse.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case TextQueryResponse.Tags.results:
          

    // validate TextQueryResponse.results
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(TextQueryResult), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TextQueryResponse.Tags.error:
          

    // validate TextQueryResponse.error
    err = messageValidator.validateStructPointer(data_offset, TextQueryError, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  TextQueryResponse.encodedSize = 16;
  var kEditorClient_GetPresetTextQueries_Name = 0;
  var kEditorClient_RequestPresetRewrite_Name = 1;
  var kEditorClient_RequestFreeformRewrite_Name = 2;
  var kEditorClient_RequestFreeformWrite_Name = 3;
  var kEditorClient_InsertText_Name = 4;
  var kEditorClient_ApproveConsent_Name = 5;
  var kEditorClient_DeclineConsent_Name = 6;
  var kEditorClient_DismissConsent_Name = 7;
  var kEditorClient_OpenUrlInNewWindow_Name = 8;
  var kEditorClient_ShowUI_Name = 9;
  var kEditorClient_CloseUI_Name = 10;
  var kEditorClient_AppendText_Name = 11;
  var kEditorClient_PreviewFeedback_Name = 12;
  var kEditorClient_SubmitFeedback_Name = 13;
  var kEditorClient_OnTrigger_Name = 14;
  var kEditorClient_EmitMetricEvent_Name = 15;

  function EditorClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(EditorClient,
                                                   handleOrPtrInfo);
  }

  function EditorClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        EditorClient, associatedInterfacePtrInfo);
  }

  EditorClientAssociatedPtr.prototype =
      Object.create(EditorClientPtr.prototype);
  EditorClientAssociatedPtr.prototype.constructor =
      EditorClientAssociatedPtr;

  function EditorClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  EditorClientPtr.prototype.getPresetTextQueries = function() {
    return EditorClientProxy.prototype.getPresetTextQueries
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.getPresetTextQueries = function() {
    var params_ = new EditorClient_GetPresetTextQueries_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kEditorClient_GetPresetTextQueries_Name,
          codec.align(EditorClient_GetPresetTextQueries_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(EditorClient_GetPresetTextQueries_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(EditorClient_GetPresetTextQueries_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  EditorClientPtr.prototype.requestPresetRewrite = function() {
    return EditorClientProxy.prototype.requestPresetRewrite
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.requestPresetRewrite = function(textQueryId, textOverride) {
    var params_ = new EditorClient_RequestPresetRewrite_Params();
    params_.textQueryId = textQueryId;
    params_.textOverride = textOverride;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kEditorClient_RequestPresetRewrite_Name,
          codec.align(EditorClient_RequestPresetRewrite_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(EditorClient_RequestPresetRewrite_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(EditorClient_RequestPresetRewrite_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  EditorClientPtr.prototype.requestFreeformRewrite = function() {
    return EditorClientProxy.prototype.requestFreeformRewrite
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.requestFreeformRewrite = function(input, textOverride) {
    var params_ = new EditorClient_RequestFreeformRewrite_Params();
    params_.input = input;
    params_.textOverride = textOverride;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kEditorClient_RequestFreeformRewrite_Name,
          codec.align(EditorClient_RequestFreeformRewrite_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(EditorClient_RequestFreeformRewrite_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(EditorClient_RequestFreeformRewrite_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  EditorClientPtr.prototype.requestFreeformWrite = function() {
    return EditorClientProxy.prototype.requestFreeformWrite
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.requestFreeformWrite = function(input) {
    var params_ = new EditorClient_RequestFreeformWrite_Params();
    params_.input = input;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kEditorClient_RequestFreeformWrite_Name,
          codec.align(EditorClient_RequestFreeformWrite_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(EditorClient_RequestFreeformWrite_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(EditorClient_RequestFreeformWrite_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  EditorClientPtr.prototype.insertText = function() {
    return EditorClientProxy.prototype.insertText
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.insertText = function(text) {
    var params_ = new EditorClient_InsertText_Params();
    params_.text = text;
    var builder = new codec.MessageV0Builder(
        kEditorClient_InsertText_Name,
        codec.align(EditorClient_InsertText_Params.encodedSize));
    builder.encodeStruct(EditorClient_InsertText_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EditorClientPtr.prototype.approveConsent = function() {
    return EditorClientProxy.prototype.approveConsent
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.approveConsent = function() {
    var params_ = new EditorClient_ApproveConsent_Params();
    var builder = new codec.MessageV0Builder(
        kEditorClient_ApproveConsent_Name,
        codec.align(EditorClient_ApproveConsent_Params.encodedSize));
    builder.encodeStruct(EditorClient_ApproveConsent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EditorClientPtr.prototype.declineConsent = function() {
    return EditorClientProxy.prototype.declineConsent
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.declineConsent = function() {
    var params_ = new EditorClient_DeclineConsent_Params();
    var builder = new codec.MessageV0Builder(
        kEditorClient_DeclineConsent_Name,
        codec.align(EditorClient_DeclineConsent_Params.encodedSize));
    builder.encodeStruct(EditorClient_DeclineConsent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EditorClientPtr.prototype.dismissConsent = function() {
    return EditorClientProxy.prototype.dismissConsent
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.dismissConsent = function() {
    var params_ = new EditorClient_DismissConsent_Params();
    var builder = new codec.MessageV0Builder(
        kEditorClient_DismissConsent_Name,
        codec.align(EditorClient_DismissConsent_Params.encodedSize));
    builder.encodeStruct(EditorClient_DismissConsent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EditorClientPtr.prototype.openUrlInNewWindow = function() {
    return EditorClientProxy.prototype.openUrlInNewWindow
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.openUrlInNewWindow = function(url) {
    var params_ = new EditorClient_OpenUrlInNewWindow_Params();
    params_.url = url;
    var builder = new codec.MessageV0Builder(
        kEditorClient_OpenUrlInNewWindow_Name,
        codec.align(EditorClient_OpenUrlInNewWindow_Params.encodedSize));
    builder.encodeStruct(EditorClient_OpenUrlInNewWindow_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EditorClientPtr.prototype.showUI = function() {
    return EditorClientProxy.prototype.showUI
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.showUI = function() {
    var params_ = new EditorClient_ShowUI_Params();
    var builder = new codec.MessageV0Builder(
        kEditorClient_ShowUI_Name,
        codec.align(EditorClient_ShowUI_Params.encodedSize));
    builder.encodeStruct(EditorClient_ShowUI_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EditorClientPtr.prototype.closeUI = function() {
    return EditorClientProxy.prototype.closeUI
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.closeUI = function() {
    var params_ = new EditorClient_CloseUI_Params();
    var builder = new codec.MessageV0Builder(
        kEditorClient_CloseUI_Name,
        codec.align(EditorClient_CloseUI_Params.encodedSize));
    builder.encodeStruct(EditorClient_CloseUI_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EditorClientPtr.prototype.appendText = function() {
    return EditorClientProxy.prototype.appendText
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.appendText = function(text) {
    var params_ = new EditorClient_AppendText_Params();
    params_.text = text;
    var builder = new codec.MessageV0Builder(
        kEditorClient_AppendText_Name,
        codec.align(EditorClient_AppendText_Params.encodedSize));
    builder.encodeStruct(EditorClient_AppendText_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EditorClientPtr.prototype.previewFeedback = function() {
    return EditorClientProxy.prototype.previewFeedback
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.previewFeedback = function(resultId) {
    var params_ = new EditorClient_PreviewFeedback_Params();
    params_.resultId = resultId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kEditorClient_PreviewFeedback_Name,
          codec.align(EditorClient_PreviewFeedback_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(EditorClient_PreviewFeedback_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(EditorClient_PreviewFeedback_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  EditorClientPtr.prototype.submitFeedback = function() {
    return EditorClientProxy.prototype.submitFeedback
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.submitFeedback = function(resultId, userDescription) {
    var params_ = new EditorClient_SubmitFeedback_Params();
    params_.resultId = resultId;
    params_.userDescription = userDescription;
    var builder = new codec.MessageV0Builder(
        kEditorClient_SubmitFeedback_Name,
        codec.align(EditorClient_SubmitFeedback_Params.encodedSize));
    builder.encodeStruct(EditorClient_SubmitFeedback_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EditorClientPtr.prototype.onTrigger = function() {
    return EditorClientProxy.prototype.onTrigger
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.onTrigger = function(triggerContext) {
    var params_ = new EditorClient_OnTrigger_Params();
    params_.triggerContext = triggerContext;
    var builder = new codec.MessageV0Builder(
        kEditorClient_OnTrigger_Name,
        codec.align(EditorClient_OnTrigger_Params.encodedSize));
    builder.encodeStruct(EditorClient_OnTrigger_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  EditorClientPtr.prototype.emitMetricEvent = function() {
    return EditorClientProxy.prototype.emitMetricEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientProxy.prototype.emitMetricEvent = function(metricEvent) {
    var params_ = new EditorClient_EmitMetricEvent_Params();
    params_.metricEvent = metricEvent;
    var builder = new codec.MessageV0Builder(
        kEditorClient_EmitMetricEvent_Name,
        codec.align(EditorClient_EmitMetricEvent_Params.encodedSize));
    builder.encodeStruct(EditorClient_EmitMetricEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function EditorClientStub(delegate) {
    this.delegate_ = delegate;
  }
  EditorClientStub.prototype.getPresetTextQueries = function() {
    return this.delegate_ && this.delegate_.getPresetTextQueries && this.delegate_.getPresetTextQueries();
  }
  EditorClientStub.prototype.requestPresetRewrite = function(textQueryId, textOverride) {
    return this.delegate_ && this.delegate_.requestPresetRewrite && this.delegate_.requestPresetRewrite(textQueryId, textOverride);
  }
  EditorClientStub.prototype.requestFreeformRewrite = function(input, textOverride) {
    return this.delegate_ && this.delegate_.requestFreeformRewrite && this.delegate_.requestFreeformRewrite(input, textOverride);
  }
  EditorClientStub.prototype.requestFreeformWrite = function(input) {
    return this.delegate_ && this.delegate_.requestFreeformWrite && this.delegate_.requestFreeformWrite(input);
  }
  EditorClientStub.prototype.insertText = function(text) {
    return this.delegate_ && this.delegate_.insertText && this.delegate_.insertText(text);
  }
  EditorClientStub.prototype.approveConsent = function() {
    return this.delegate_ && this.delegate_.approveConsent && this.delegate_.approveConsent();
  }
  EditorClientStub.prototype.declineConsent = function() {
    return this.delegate_ && this.delegate_.declineConsent && this.delegate_.declineConsent();
  }
  EditorClientStub.prototype.dismissConsent = function() {
    return this.delegate_ && this.delegate_.dismissConsent && this.delegate_.dismissConsent();
  }
  EditorClientStub.prototype.openUrlInNewWindow = function(url) {
    return this.delegate_ && this.delegate_.openUrlInNewWindow && this.delegate_.openUrlInNewWindow(url);
  }
  EditorClientStub.prototype.showUI = function() {
    return this.delegate_ && this.delegate_.showUI && this.delegate_.showUI();
  }
  EditorClientStub.prototype.closeUI = function() {
    return this.delegate_ && this.delegate_.closeUI && this.delegate_.closeUI();
  }
  EditorClientStub.prototype.appendText = function(text) {
    return this.delegate_ && this.delegate_.appendText && this.delegate_.appendText(text);
  }
  EditorClientStub.prototype.previewFeedback = function(resultId) {
    return this.delegate_ && this.delegate_.previewFeedback && this.delegate_.previewFeedback(resultId);
  }
  EditorClientStub.prototype.submitFeedback = function(resultId, userDescription) {
    return this.delegate_ && this.delegate_.submitFeedback && this.delegate_.submitFeedback(resultId, userDescription);
  }
  EditorClientStub.prototype.onTrigger = function(triggerContext) {
    return this.delegate_ && this.delegate_.onTrigger && this.delegate_.onTrigger(triggerContext);
  }
  EditorClientStub.prototype.emitMetricEvent = function(metricEvent) {
    return this.delegate_ && this.delegate_.emitMetricEvent && this.delegate_.emitMetricEvent(metricEvent);
  }

  EditorClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kEditorClient_InsertText_Name:
      var params = reader.decodeStruct(EditorClient_InsertText_Params);
      this.insertText(params.text);
      return true;
    case kEditorClient_ApproveConsent_Name:
      var params = reader.decodeStruct(EditorClient_ApproveConsent_Params);
      this.approveConsent();
      return true;
    case kEditorClient_DeclineConsent_Name:
      var params = reader.decodeStruct(EditorClient_DeclineConsent_Params);
      this.declineConsent();
      return true;
    case kEditorClient_DismissConsent_Name:
      var params = reader.decodeStruct(EditorClient_DismissConsent_Params);
      this.dismissConsent();
      return true;
    case kEditorClient_OpenUrlInNewWindow_Name:
      var params = reader.decodeStruct(EditorClient_OpenUrlInNewWindow_Params);
      this.openUrlInNewWindow(params.url);
      return true;
    case kEditorClient_ShowUI_Name:
      var params = reader.decodeStruct(EditorClient_ShowUI_Params);
      this.showUI();
      return true;
    case kEditorClient_CloseUI_Name:
      var params = reader.decodeStruct(EditorClient_CloseUI_Params);
      this.closeUI();
      return true;
    case kEditorClient_AppendText_Name:
      var params = reader.decodeStruct(EditorClient_AppendText_Params);
      this.appendText(params.text);
      return true;
    case kEditorClient_SubmitFeedback_Name:
      var params = reader.decodeStruct(EditorClient_SubmitFeedback_Params);
      this.submitFeedback(params.resultId, params.userDescription);
      return true;
    case kEditorClient_OnTrigger_Name:
      var params = reader.decodeStruct(EditorClient_OnTrigger_Params);
      this.onTrigger(params.triggerContext);
      return true;
    case kEditorClient_EmitMetricEvent_Name:
      var params = reader.decodeStruct(EditorClient_EmitMetricEvent_Params);
      this.emitMetricEvent(params.metricEvent);
      return true;
    default:
      return false;
    }
  };

  EditorClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kEditorClient_GetPresetTextQueries_Name:
      var params = reader.decodeStruct(EditorClient_GetPresetTextQueries_Params);
      this.getPresetTextQueries().then(function(response) {
        var responseParams =
            new EditorClient_GetPresetTextQueries_ResponseParams();
        responseParams.textQueries = response.textQueries;
        var builder = new codec.MessageV1Builder(
            kEditorClient_GetPresetTextQueries_Name,
            codec.align(EditorClient_GetPresetTextQueries_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(EditorClient_GetPresetTextQueries_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kEditorClient_RequestPresetRewrite_Name:
      var params = reader.decodeStruct(EditorClient_RequestPresetRewrite_Params);
      this.requestPresetRewrite(params.textQueryId, params.textOverride).then(function(response) {
        var responseParams =
            new EditorClient_RequestPresetRewrite_ResponseParams();
        responseParams.response = response.response;
        var builder = new codec.MessageV1Builder(
            kEditorClient_RequestPresetRewrite_Name,
            codec.align(EditorClient_RequestPresetRewrite_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(EditorClient_RequestPresetRewrite_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kEditorClient_RequestFreeformRewrite_Name:
      var params = reader.decodeStruct(EditorClient_RequestFreeformRewrite_Params);
      this.requestFreeformRewrite(params.input, params.textOverride).then(function(response) {
        var responseParams =
            new EditorClient_RequestFreeformRewrite_ResponseParams();
        responseParams.response = response.response;
        var builder = new codec.MessageV1Builder(
            kEditorClient_RequestFreeformRewrite_Name,
            codec.align(EditorClient_RequestFreeformRewrite_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(EditorClient_RequestFreeformRewrite_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kEditorClient_RequestFreeformWrite_Name:
      var params = reader.decodeStruct(EditorClient_RequestFreeformWrite_Params);
      this.requestFreeformWrite(params.input).then(function(response) {
        var responseParams =
            new EditorClient_RequestFreeformWrite_ResponseParams();
        responseParams.response = response.response;
        var builder = new codec.MessageV1Builder(
            kEditorClient_RequestFreeformWrite_Name,
            codec.align(EditorClient_RequestFreeformWrite_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(EditorClient_RequestFreeformWrite_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kEditorClient_PreviewFeedback_Name:
      var params = reader.decodeStruct(EditorClient_PreviewFeedback_Params);
      this.previewFeedback(params.resultId).then(function(response) {
        var responseParams =
            new EditorClient_PreviewFeedback_ResponseParams();
        responseParams.preview = response.preview;
        var builder = new codec.MessageV1Builder(
            kEditorClient_PreviewFeedback_Name,
            codec.align(EditorClient_PreviewFeedback_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(EditorClient_PreviewFeedback_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateEditorClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kEditorClient_GetPresetTextQueries_Name:
        if (message.expectsResponse())
          paramsClass = EditorClient_GetPresetTextQueries_Params;
      break;
      case kEditorClient_RequestPresetRewrite_Name:
        if (message.expectsResponse())
          paramsClass = EditorClient_RequestPresetRewrite_Params;
      break;
      case kEditorClient_RequestFreeformRewrite_Name:
        if (message.expectsResponse())
          paramsClass = EditorClient_RequestFreeformRewrite_Params;
      break;
      case kEditorClient_RequestFreeformWrite_Name:
        if (message.expectsResponse())
          paramsClass = EditorClient_RequestFreeformWrite_Params;
      break;
      case kEditorClient_InsertText_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EditorClient_InsertText_Params;
      break;
      case kEditorClient_ApproveConsent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EditorClient_ApproveConsent_Params;
      break;
      case kEditorClient_DeclineConsent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EditorClient_DeclineConsent_Params;
      break;
      case kEditorClient_DismissConsent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EditorClient_DismissConsent_Params;
      break;
      case kEditorClient_OpenUrlInNewWindow_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EditorClient_OpenUrlInNewWindow_Params;
      break;
      case kEditorClient_ShowUI_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EditorClient_ShowUI_Params;
      break;
      case kEditorClient_CloseUI_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EditorClient_CloseUI_Params;
      break;
      case kEditorClient_AppendText_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EditorClient_AppendText_Params;
      break;
      case kEditorClient_PreviewFeedback_Name:
        if (message.expectsResponse())
          paramsClass = EditorClient_PreviewFeedback_Params;
      break;
      case kEditorClient_SubmitFeedback_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EditorClient_SubmitFeedback_Params;
      break;
      case kEditorClient_OnTrigger_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EditorClient_OnTrigger_Params;
      break;
      case kEditorClient_EmitMetricEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EditorClient_EmitMetricEvent_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateEditorClientResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kEditorClient_GetPresetTextQueries_Name:
        if (message.isResponse())
          paramsClass = EditorClient_GetPresetTextQueries_ResponseParams;
        break;
      case kEditorClient_RequestPresetRewrite_Name:
        if (message.isResponse())
          paramsClass = EditorClient_RequestPresetRewrite_ResponseParams;
        break;
      case kEditorClient_RequestFreeformRewrite_Name:
        if (message.isResponse())
          paramsClass = EditorClient_RequestFreeformRewrite_ResponseParams;
        break;
      case kEditorClient_RequestFreeformWrite_Name:
        if (message.isResponse())
          paramsClass = EditorClient_RequestFreeformWrite_ResponseParams;
        break;
      case kEditorClient_PreviewFeedback_Name:
        if (message.isResponse())
          paramsClass = EditorClient_PreviewFeedback_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var EditorClient = {
    name: 'ash.orca.mojom.EditorClient',
    kVersion: 11,
    ptrClass: EditorClientPtr,
    proxyClass: EditorClientProxy,
    stubClass: EditorClientStub,
    validateRequest: validateEditorClientRequest,
    validateResponse: validateEditorClientResponse,
  };
  EditorClientStub.prototype.validator = validateEditorClientRequest;
  EditorClientProxy.prototype.validator = validateEditorClientResponse;
  var kEditorClientConnector_BindEditorClient_Name = 0;

  function EditorClientConnectorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(EditorClientConnector,
                                                   handleOrPtrInfo);
  }

  function EditorClientConnectorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        EditorClientConnector, associatedInterfacePtrInfo);
  }

  EditorClientConnectorAssociatedPtr.prototype =
      Object.create(EditorClientConnectorPtr.prototype);
  EditorClientConnectorAssociatedPtr.prototype.constructor =
      EditorClientConnectorAssociatedPtr;

  function EditorClientConnectorProxy(receiver) {
    this.receiver_ = receiver;
  }
  EditorClientConnectorPtr.prototype.bindEditorClient = function() {
    return EditorClientConnectorProxy.prototype.bindEditorClient
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorClientConnectorProxy.prototype.bindEditorClient = function(editorClient) {
    var params_ = new EditorClientConnector_BindEditorClient_Params();
    params_.editorClient = editorClient;
    var builder = new codec.MessageV0Builder(
        kEditorClientConnector_BindEditorClient_Name,
        codec.align(EditorClientConnector_BindEditorClient_Params.encodedSize));
    builder.encodeStruct(EditorClientConnector_BindEditorClient_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function EditorClientConnectorStub(delegate) {
    this.delegate_ = delegate;
  }
  EditorClientConnectorStub.prototype.bindEditorClient = function(editorClient) {
    return this.delegate_ && this.delegate_.bindEditorClient && this.delegate_.bindEditorClient(editorClient);
  }

  EditorClientConnectorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kEditorClientConnector_BindEditorClient_Name:
      var params = reader.decodeStruct(EditorClientConnector_BindEditorClient_Params);
      this.bindEditorClient(params.editorClient);
      return true;
    default:
      return false;
    }
  };

  EditorClientConnectorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateEditorClientConnectorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kEditorClientConnector_BindEditorClient_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EditorClientConnector_BindEditorClient_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateEditorClientConnectorResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var EditorClientConnector = {
    name: 'ash.orca.mojom.EditorClientConnector',
    kVersion: 0,
    ptrClass: EditorClientConnectorPtr,
    proxyClass: EditorClientConnectorProxy,
    stubClass: EditorClientConnectorStub,
    validateRequest: validateEditorClientConnectorRequest,
    validateResponse: null,
  };
  EditorClientConnectorStub.prototype.validator = validateEditorClientConnectorRequest;
  EditorClientConnectorProxy.prototype.validator = null;
  var kEditorEventSink_OnContextUpdated_Name = 0;

  function EditorEventSinkPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(EditorEventSink,
                                                   handleOrPtrInfo);
  }

  function EditorEventSinkAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        EditorEventSink, associatedInterfacePtrInfo);
  }

  EditorEventSinkAssociatedPtr.prototype =
      Object.create(EditorEventSinkPtr.prototype);
  EditorEventSinkAssociatedPtr.prototype.constructor =
      EditorEventSinkAssociatedPtr;

  function EditorEventSinkProxy(receiver) {
    this.receiver_ = receiver;
  }
  EditorEventSinkPtr.prototype.onContextUpdated = function() {
    return EditorEventSinkProxy.prototype.onContextUpdated
        .apply(this.ptr.getProxy(), arguments);
  };

  EditorEventSinkProxy.prototype.onContextUpdated = function(context) {
    var params_ = new EditorEventSink_OnContextUpdated_Params();
    params_.context = context;
    var builder = new codec.MessageV0Builder(
        kEditorEventSink_OnContextUpdated_Name,
        codec.align(EditorEventSink_OnContextUpdated_Params.encodedSize));
    builder.encodeStruct(EditorEventSink_OnContextUpdated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function EditorEventSinkStub(delegate) {
    this.delegate_ = delegate;
  }
  EditorEventSinkStub.prototype.onContextUpdated = function(context) {
    return this.delegate_ && this.delegate_.onContextUpdated && this.delegate_.onContextUpdated(context);
  }

  EditorEventSinkStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kEditorEventSink_OnContextUpdated_Name:
      var params = reader.decodeStruct(EditorEventSink_OnContextUpdated_Params);
      this.onContextUpdated(params.context);
      return true;
    default:
      return false;
    }
  };

  EditorEventSinkStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateEditorEventSinkRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kEditorEventSink_OnContextUpdated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = EditorEventSink_OnContextUpdated_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateEditorEventSinkResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var EditorEventSink = {
    name: 'ash.orca.mojom.EditorEventSink',
    kVersion: 0,
    ptrClass: EditorEventSinkPtr,
    proxyClass: EditorEventSinkProxy,
    stubClass: EditorEventSinkStub,
    validateRequest: validateEditorEventSinkRequest,
    validateResponse: null,
  };
  EditorEventSinkStub.prototype.validator = validateEditorEventSinkRequest;
  EditorEventSinkProxy.prototype.validator = null;
  var kSystemActuator_InsertText_Name = 0;
  var kSystemActuator_ApproveConsent_Name = 1;
  var kSystemActuator_DeclineConsent_Name = 2;
  var kSystemActuator_OpenUrlInNewWindow_Name = 3;
  var kSystemActuator_ShowUI_Name = 4;
  var kSystemActuator_CloseUI_Name = 5;
  var kSystemActuator_SubmitFeedback_Name = 6;
  var kSystemActuator_OnTrigger_Name = 7;
  var kSystemActuator_EmitMetricEvent_Name = 8;

  function SystemActuatorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SystemActuator,
                                                   handleOrPtrInfo);
  }

  function SystemActuatorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SystemActuator, associatedInterfacePtrInfo);
  }

  SystemActuatorAssociatedPtr.prototype =
      Object.create(SystemActuatorPtr.prototype);
  SystemActuatorAssociatedPtr.prototype.constructor =
      SystemActuatorAssociatedPtr;

  function SystemActuatorProxy(receiver) {
    this.receiver_ = receiver;
  }
  SystemActuatorPtr.prototype.insertText = function() {
    return SystemActuatorProxy.prototype.insertText
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemActuatorProxy.prototype.insertText = function(text) {
    var params_ = new SystemActuator_InsertText_Params();
    params_.text = text;
    var builder = new codec.MessageV0Builder(
        kSystemActuator_InsertText_Name,
        codec.align(SystemActuator_InsertText_Params.encodedSize));
    builder.encodeStruct(SystemActuator_InsertText_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SystemActuatorPtr.prototype.approveConsent = function() {
    return SystemActuatorProxy.prototype.approveConsent
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemActuatorProxy.prototype.approveConsent = function() {
    var params_ = new SystemActuator_ApproveConsent_Params();
    var builder = new codec.MessageV0Builder(
        kSystemActuator_ApproveConsent_Name,
        codec.align(SystemActuator_ApproveConsent_Params.encodedSize));
    builder.encodeStruct(SystemActuator_ApproveConsent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SystemActuatorPtr.prototype.declineConsent = function() {
    return SystemActuatorProxy.prototype.declineConsent
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemActuatorProxy.prototype.declineConsent = function() {
    var params_ = new SystemActuator_DeclineConsent_Params();
    var builder = new codec.MessageV0Builder(
        kSystemActuator_DeclineConsent_Name,
        codec.align(SystemActuator_DeclineConsent_Params.encodedSize));
    builder.encodeStruct(SystemActuator_DeclineConsent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SystemActuatorPtr.prototype.openUrlInNewWindow = function() {
    return SystemActuatorProxy.prototype.openUrlInNewWindow
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemActuatorProxy.prototype.openUrlInNewWindow = function(url) {
    var params_ = new SystemActuator_OpenUrlInNewWindow_Params();
    params_.url = url;
    var builder = new codec.MessageV0Builder(
        kSystemActuator_OpenUrlInNewWindow_Name,
        codec.align(SystemActuator_OpenUrlInNewWindow_Params.encodedSize));
    builder.encodeStruct(SystemActuator_OpenUrlInNewWindow_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SystemActuatorPtr.prototype.showUI = function() {
    return SystemActuatorProxy.prototype.showUI
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemActuatorProxy.prototype.showUI = function() {
    var params_ = new SystemActuator_ShowUI_Params();
    var builder = new codec.MessageV0Builder(
        kSystemActuator_ShowUI_Name,
        codec.align(SystemActuator_ShowUI_Params.encodedSize));
    builder.encodeStruct(SystemActuator_ShowUI_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SystemActuatorPtr.prototype.closeUI = function() {
    return SystemActuatorProxy.prototype.closeUI
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemActuatorProxy.prototype.closeUI = function() {
    var params_ = new SystemActuator_CloseUI_Params();
    var builder = new codec.MessageV0Builder(
        kSystemActuator_CloseUI_Name,
        codec.align(SystemActuator_CloseUI_Params.encodedSize));
    builder.encodeStruct(SystemActuator_CloseUI_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SystemActuatorPtr.prototype.submitFeedback = function() {
    return SystemActuatorProxy.prototype.submitFeedback
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemActuatorProxy.prototype.submitFeedback = function(description) {
    var params_ = new SystemActuator_SubmitFeedback_Params();
    params_.description = description;
    var builder = new codec.MessageV0Builder(
        kSystemActuator_SubmitFeedback_Name,
        codec.align(SystemActuator_SubmitFeedback_Params.encodedSize));
    builder.encodeStruct(SystemActuator_SubmitFeedback_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SystemActuatorPtr.prototype.onTrigger = function() {
    return SystemActuatorProxy.prototype.onTrigger
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemActuatorProxy.prototype.onTrigger = function(triggerContext) {
    var params_ = new SystemActuator_OnTrigger_Params();
    params_.triggerContext = triggerContext;
    var builder = new codec.MessageV0Builder(
        kSystemActuator_OnTrigger_Name,
        codec.align(SystemActuator_OnTrigger_Params.encodedSize));
    builder.encodeStruct(SystemActuator_OnTrigger_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SystemActuatorPtr.prototype.emitMetricEvent = function() {
    return SystemActuatorProxy.prototype.emitMetricEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemActuatorProxy.prototype.emitMetricEvent = function(metricEvent) {
    var params_ = new SystemActuator_EmitMetricEvent_Params();
    params_.metricEvent = metricEvent;
    var builder = new codec.MessageV0Builder(
        kSystemActuator_EmitMetricEvent_Name,
        codec.align(SystemActuator_EmitMetricEvent_Params.encodedSize));
    builder.encodeStruct(SystemActuator_EmitMetricEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SystemActuatorStub(delegate) {
    this.delegate_ = delegate;
  }
  SystemActuatorStub.prototype.insertText = function(text) {
    return this.delegate_ && this.delegate_.insertText && this.delegate_.insertText(text);
  }
  SystemActuatorStub.prototype.approveConsent = function() {
    return this.delegate_ && this.delegate_.approveConsent && this.delegate_.approveConsent();
  }
  SystemActuatorStub.prototype.declineConsent = function() {
    return this.delegate_ && this.delegate_.declineConsent && this.delegate_.declineConsent();
  }
  SystemActuatorStub.prototype.openUrlInNewWindow = function(url) {
    return this.delegate_ && this.delegate_.openUrlInNewWindow && this.delegate_.openUrlInNewWindow(url);
  }
  SystemActuatorStub.prototype.showUI = function() {
    return this.delegate_ && this.delegate_.showUI && this.delegate_.showUI();
  }
  SystemActuatorStub.prototype.closeUI = function() {
    return this.delegate_ && this.delegate_.closeUI && this.delegate_.closeUI();
  }
  SystemActuatorStub.prototype.submitFeedback = function(description) {
    return this.delegate_ && this.delegate_.submitFeedback && this.delegate_.submitFeedback(description);
  }
  SystemActuatorStub.prototype.onTrigger = function(triggerContext) {
    return this.delegate_ && this.delegate_.onTrigger && this.delegate_.onTrigger(triggerContext);
  }
  SystemActuatorStub.prototype.emitMetricEvent = function(metricEvent) {
    return this.delegate_ && this.delegate_.emitMetricEvent && this.delegate_.emitMetricEvent(metricEvent);
  }

  SystemActuatorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSystemActuator_InsertText_Name:
      var params = reader.decodeStruct(SystemActuator_InsertText_Params);
      this.insertText(params.text);
      return true;
    case kSystemActuator_ApproveConsent_Name:
      var params = reader.decodeStruct(SystemActuator_ApproveConsent_Params);
      this.approveConsent();
      return true;
    case kSystemActuator_DeclineConsent_Name:
      var params = reader.decodeStruct(SystemActuator_DeclineConsent_Params);
      this.declineConsent();
      return true;
    case kSystemActuator_OpenUrlInNewWindow_Name:
      var params = reader.decodeStruct(SystemActuator_OpenUrlInNewWindow_Params);
      this.openUrlInNewWindow(params.url);
      return true;
    case kSystemActuator_ShowUI_Name:
      var params = reader.decodeStruct(SystemActuator_ShowUI_Params);
      this.showUI();
      return true;
    case kSystemActuator_CloseUI_Name:
      var params = reader.decodeStruct(SystemActuator_CloseUI_Params);
      this.closeUI();
      return true;
    case kSystemActuator_SubmitFeedback_Name:
      var params = reader.decodeStruct(SystemActuator_SubmitFeedback_Params);
      this.submitFeedback(params.description);
      return true;
    case kSystemActuator_OnTrigger_Name:
      var params = reader.decodeStruct(SystemActuator_OnTrigger_Params);
      this.onTrigger(params.triggerContext);
      return true;
    case kSystemActuator_EmitMetricEvent_Name:
      var params = reader.decodeStruct(SystemActuator_EmitMetricEvent_Params);
      this.emitMetricEvent(params.metricEvent);
      return true;
    default:
      return false;
    }
  };

  SystemActuatorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSystemActuatorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSystemActuator_InsertText_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SystemActuator_InsertText_Params;
      break;
      case kSystemActuator_ApproveConsent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SystemActuator_ApproveConsent_Params;
      break;
      case kSystemActuator_DeclineConsent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SystemActuator_DeclineConsent_Params;
      break;
      case kSystemActuator_OpenUrlInNewWindow_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SystemActuator_OpenUrlInNewWindow_Params;
      break;
      case kSystemActuator_ShowUI_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SystemActuator_ShowUI_Params;
      break;
      case kSystemActuator_CloseUI_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SystemActuator_CloseUI_Params;
      break;
      case kSystemActuator_SubmitFeedback_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SystemActuator_SubmitFeedback_Params;
      break;
      case kSystemActuator_OnTrigger_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SystemActuator_OnTrigger_Params;
      break;
      case kSystemActuator_EmitMetricEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SystemActuator_EmitMetricEvent_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSystemActuatorResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SystemActuator = {
    name: 'ash.orca.mojom.SystemActuator',
    kVersion: 11,
    ptrClass: SystemActuatorPtr,
    proxyClass: SystemActuatorProxy,
    stubClass: SystemActuatorStub,
    validateRequest: validateSystemActuatorRequest,
    validateResponse: null,
  };
  SystemActuatorStub.prototype.validator = validateSystemActuatorRequest;
  SystemActuatorProxy.prototype.validator = null;
  var kTextQueryProvider_Process_Name = 0;

  function TextQueryProviderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(TextQueryProvider,
                                                   handleOrPtrInfo);
  }

  function TextQueryProviderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        TextQueryProvider, associatedInterfacePtrInfo);
  }

  TextQueryProviderAssociatedPtr.prototype =
      Object.create(TextQueryProviderPtr.prototype);
  TextQueryProviderAssociatedPtr.prototype.constructor =
      TextQueryProviderAssociatedPtr;

  function TextQueryProviderProxy(receiver) {
    this.receiver_ = receiver;
  }
  TextQueryProviderPtr.prototype.process = function() {
    return TextQueryProviderProxy.prototype.process
        .apply(this.ptr.getProxy(), arguments);
  };

  TextQueryProviderProxy.prototype.process = function(request) {
    var params_ = new TextQueryProvider_Process_Params();
    params_.request = request;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kTextQueryProvider_Process_Name,
          codec.align(TextQueryProvider_Process_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(TextQueryProvider_Process_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(TextQueryProvider_Process_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function TextQueryProviderStub(delegate) {
    this.delegate_ = delegate;
  }
  TextQueryProviderStub.prototype.process = function(request) {
    return this.delegate_ && this.delegate_.process && this.delegate_.process(request);
  }

  TextQueryProviderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  TextQueryProviderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTextQueryProvider_Process_Name:
      var params = reader.decodeStruct(TextQueryProvider_Process_Params);
      this.process(params.request).then(function(response) {
        var responseParams =
            new TextQueryProvider_Process_ResponseParams();
        responseParams.response = response.response;
        var builder = new codec.MessageV1Builder(
            kTextQueryProvider_Process_Name,
            codec.align(TextQueryProvider_Process_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(TextQueryProvider_Process_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateTextQueryProviderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kTextQueryProvider_Process_Name:
        if (message.expectsResponse())
          paramsClass = TextQueryProvider_Process_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateTextQueryProviderResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kTextQueryProvider_Process_Name:
        if (message.isResponse())
          paramsClass = TextQueryProvider_Process_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var TextQueryProvider = {
    name: 'ash.orca.mojom.TextQueryProvider',
    kVersion: 0,
    ptrClass: TextQueryProviderPtr,
    proxyClass: TextQueryProviderProxy,
    stubClass: TextQueryProviderStub,
    validateRequest: validateTextQueryProviderRequest,
    validateResponse: validateTextQueryProviderResponse,
  };
  TextQueryProviderStub.prototype.validator = validateTextQueryProviderRequest;
  TextQueryProviderProxy.prototype.validator = validateTextQueryProviderResponse;
  var kOrcaService_BindEditor_Name = 0;

  function OrcaServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(OrcaService,
                                                   handleOrPtrInfo);
  }

  function OrcaServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        OrcaService, associatedInterfacePtrInfo);
  }

  OrcaServiceAssociatedPtr.prototype =
      Object.create(OrcaServicePtr.prototype);
  OrcaServiceAssociatedPtr.prototype.constructor =
      OrcaServiceAssociatedPtr;

  function OrcaServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  OrcaServicePtr.prototype.bindEditor = function() {
    return OrcaServiceProxy.prototype.bindEditor
        .apply(this.ptr.getProxy(), arguments);
  };

  OrcaServiceProxy.prototype.bindEditor = function(systemActuator, textQueryProvider, clientConnector, eventSink, editorConfig) {
    var params_ = new OrcaService_BindEditor_Params();
    params_.systemActuator = systemActuator;
    params_.textQueryProvider = textQueryProvider;
    params_.clientConnector = clientConnector;
    params_.eventSink = eventSink;
    params_.editorConfig = editorConfig;
    var builder = new codec.MessageV2Builder(
        kOrcaService_BindEditor_Name,
        codec.align(OrcaService_BindEditor_Params.encodedSize));
    builder.setPayload(OrcaService_BindEditor_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function OrcaServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  OrcaServiceStub.prototype.bindEditor = function(systemActuator, textQueryProvider, clientConnector, eventSink, editorConfig) {
    return this.delegate_ && this.delegate_.bindEditor && this.delegate_.bindEditor(systemActuator, textQueryProvider, clientConnector, eventSink, editorConfig);
  }

  OrcaServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kOrcaService_BindEditor_Name:
      var params = reader.decodeStruct(OrcaService_BindEditor_Params);
      this.bindEditor(params.systemActuator, params.textQueryProvider, params.clientConnector, params.eventSink, params.editorConfig);
      return true;
    default:
      return false;
    }
  };

  OrcaServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateOrcaServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kOrcaService_BindEditor_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = OrcaService_BindEditor_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateOrcaServiceResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var OrcaService = {
    name: 'ash.orca.mojom.OrcaService',
    kVersion: 9,
    ptrClass: OrcaServicePtr,
    proxyClass: OrcaServiceProxy,
    stubClass: OrcaServiceStub,
    validateRequest: validateOrcaServiceRequest,
    validateResponse: null,
  };
  OrcaServiceStub.prototype.validator = validateOrcaServiceRequest;
  OrcaServiceProxy.prototype.validator = null;
  exports.PresetTextQueryType = PresetTextQueryType;
  exports.MetricEvent = MetricEvent;
  exports.TextQueryErrorCode = TextQueryErrorCode;
  exports.PresetTextQuery = PresetTextQuery;
  exports.TextQueryRequest = TextQueryRequest;
  exports.TextQueryResult = TextQueryResult;
  exports.TextQueryError = TextQueryError;
  exports.SurroundingText = SurroundingText;
  exports.Context = Context;
  exports.EditorConfig = EditorConfig;
  exports.TriggerContext = TriggerContext;
  exports.TextQueryResponse = TextQueryResponse;
  exports.EditorClient = EditorClient;
  exports.EditorClientPtr = EditorClientPtr;
  exports.EditorClientAssociatedPtr = EditorClientAssociatedPtr;
  exports.EditorClientConnector = EditorClientConnector;
  exports.EditorClientConnectorPtr = EditorClientConnectorPtr;
  exports.EditorClientConnectorAssociatedPtr = EditorClientConnectorAssociatedPtr;
  exports.EditorEventSink = EditorEventSink;
  exports.EditorEventSinkPtr = EditorEventSinkPtr;
  exports.EditorEventSinkAssociatedPtr = EditorEventSinkAssociatedPtr;
  exports.SystemActuator = SystemActuator;
  exports.SystemActuatorPtr = SystemActuatorPtr;
  exports.SystemActuatorAssociatedPtr = SystemActuatorAssociatedPtr;
  exports.TextQueryProvider = TextQueryProvider;
  exports.TextQueryProviderPtr = TextQueryProviderPtr;
  exports.TextQueryProviderAssociatedPtr = TextQueryProviderAssociatedPtr;
  exports.OrcaService = OrcaService;
  exports.OrcaServicePtr = OrcaServicePtr;
  exports.OrcaServiceAssociatedPtr = OrcaServiceAssociatedPtr;
})();