// chromeos/ash/services/orca/public/mojom/orca_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../../mojo/public/js/bindings.js';

import {
  Range as gfx_mojom_Range,
  RangeSpec as gfx_mojom_RangeSpec
} from '../../../../../../ui/gfx/range/mojom/range.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../../url/mojom/url.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const PresetTextQueryTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const PresetTextQueryType = {
  
  kUnknown: 0,
  kShorten: 1,
  kElaborate: 2,
  kRephrase: 3,
  kFormalize: 4,
  kEmojify: 5,
  kProofread: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MetricEventSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MetricEvent = {
  
  kUnknown: 0,
  kRefineRequest: 1,
  kFeedbackThumbsUp: 2,
  kFeedbackThumbsDown: 3,
  kReturnToPreviousSuggestions: 4,
  kWebUIRequest: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TextQueryErrorCodeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TextQueryErrorCode = {
  
  kUnknown: 0,
  kInvalidArgument: 1,
  kResourceExhausted: 2,
  kBackendFailure: 3,
  kNoInternetConnection: 4,
  kUnsupportedLanguage: 5,
  kBlockedOutputs: 6,
  kRestrictedRegion: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class EditorClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.orca.mojom.EditorClient', scope);
  }
}

/** @interface */
export class EditorClientInterface {
  
  /**
   * @return {!Promise<{
        textQueries: !Array<!PresetTextQuery>,
   *  }>}
   */

  getPresetTextQueries() {}
  
  /**
   * @param { !string } textQueryId
   * @param { ?string } textOverride
   * @return {!Promise<{
        response: !TextQueryResponse,
   *  }>}
   */

  requestPresetRewrite(textQueryId, textOverride) {}
  
  /**
   * @param { !string } input
   * @param { ?string } textOverride
   * @return {!Promise<{
        response: !TextQueryResponse,
   *  }>}
   */

  requestFreeformRewrite(input, textOverride) {}
  
  /**
   * @param { !string } input
   * @return {!Promise<{
        response: !TextQueryResponse,
   *  }>}
   */

  requestFreeformWrite(input) {}
  
  /**
   * @param { !string } text
   */

  insertText(text) {}
  
  /**
   */

  approveConsent() {}
  
  /**
   */

  declineConsent() {}
  
  /**
   */

  dismissConsent() {}
  
  /**
   * @param { !url_mojom_Url } url
   */

  openUrlInNewWindow(url) {}
  
  /**
   */

  showUI() {}
  
  /**
   */

  closeUI() {}
  
  /**
   * @param { !string } text
   */

  appendText(text) {}
  
  /**
   * @param { !string } resultId
   * @return {!Promise<{
        preview: !Object<!string, !string>,
   *  }>}
   */

  previewFeedback(resultId) {}
  
  /**
   * @param { !string } resultId
   * @param { !string } userDescription
   */

  submitFeedback(resultId, userDescription) {}
  
  /**
   * @param { !TriggerContext } triggerContext
   */

  onTrigger(triggerContext) {}
  
  /**
   * @param { !MetricEvent } metricEvent
   */

  emitMetricEvent(metricEvent) {}
}

/**
 * @implements { EditorClientInterface }
 */
export class EditorClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!EditorClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          EditorClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!EditorClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        textQueries: !Array<!PresetTextQuery>,
   *  }>}
   */

  getPresetTextQueries() {
    return this.proxy.sendMessage(
        0,
        EditorClient_GetPresetTextQueries_ParamsSpec.$,
        EditorClient_GetPresetTextQueries_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } textQueryId
   * @param { ?string } textOverride
   * @return {!Promise<{
        response: !TextQueryResponse,
   *  }>}
   */

  requestPresetRewrite(
      textQueryId,
      textOverride) {
    return this.proxy.sendMessage(
        1,
        EditorClient_RequestPresetRewrite_ParamsSpec.$,
        EditorClient_RequestPresetRewrite_ResponseParamsSpec.$,
        [
          textQueryId,
          textOverride
        ],
        false);
  }

  
  /**
   * @param { !string } input
   * @param { ?string } textOverride
   * @return {!Promise<{
        response: !TextQueryResponse,
   *  }>}
   */

  requestFreeformRewrite(
      input,
      textOverride) {
    return this.proxy.sendMessage(
        2,
        EditorClient_RequestFreeformRewrite_ParamsSpec.$,
        EditorClient_RequestFreeformRewrite_ResponseParamsSpec.$,
        [
          input,
          textOverride
        ],
        false);
  }

  
  /**
   * @param { !string } input
   * @return {!Promise<{
        response: !TextQueryResponse,
   *  }>}
   */

  requestFreeformWrite(
      input) {
    return this.proxy.sendMessage(
        3,
        EditorClient_RequestFreeformWrite_ParamsSpec.$,
        EditorClient_RequestFreeformWrite_ResponseParamsSpec.$,
        [
          input
        ],
        false);
  }

  
  /**
   * @param { !string } text
   */

  insertText(
      text) {
    this.proxy.sendMessage(
        4,
        EditorClient_InsertText_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }

  
  /**
   */

  approveConsent() {
    this.proxy.sendMessage(
        5,
        EditorClient_ApproveConsent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  declineConsent() {
    this.proxy.sendMessage(
        6,
        EditorClient_DeclineConsent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  dismissConsent() {
    this.proxy.sendMessage(
        7,
        EditorClient_DismissConsent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   */

  openUrlInNewWindow(
      url) {
    this.proxy.sendMessage(
        8,
        EditorClient_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  
  /**
   */

  showUI() {
    this.proxy.sendMessage(
        9,
        EditorClient_ShowUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  closeUI() {
    this.proxy.sendMessage(
        10,
        EditorClient_CloseUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } text
   */

  appendText(
      text) {
    this.proxy.sendMessage(
        11,
        EditorClient_AppendText_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }

  
  /**
   * @param { !string } resultId
   * @return {!Promise<{
        preview: !Object<!string, !string>,
   *  }>}
   */

  previewFeedback(
      resultId) {
    return this.proxy.sendMessage(
        12,
        EditorClient_PreviewFeedback_ParamsSpec.$,
        EditorClient_PreviewFeedback_ResponseParamsSpec.$,
        [
          resultId
        ],
        false);
  }

  
  /**
   * @param { !string } resultId
   * @param { !string } userDescription
   */

  submitFeedback(
      resultId,
      userDescription) {
    this.proxy.sendMessage(
        13,
        EditorClient_SubmitFeedback_ParamsSpec.$,
        null,
        [
          resultId,
          userDescription
        ],
        false);
  }

  
  /**
   * @param { !TriggerContext } triggerContext
   */

  onTrigger(
      triggerContext) {
    this.proxy.sendMessage(
        14,
        EditorClient_OnTrigger_ParamsSpec.$,
        null,
        [
          triggerContext
        ],
        false);
  }

  
  /**
   * @param { !MetricEvent } metricEvent
   */

  emitMetricEvent(
      metricEvent) {
    this.proxy.sendMessage(
        15,
        EditorClient_EmitMetricEvent_ParamsSpec.$,
        null,
        [
          metricEvent
        ],
        false);
  }
}

/**
 * An object which receives request messages for the EditorClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class EditorClientReceiver {
  /**
   * @param {!EditorClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!EditorClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        EditorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EditorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        EditorClient_GetPresetTextQueries_ParamsSpec.$,
        EditorClient_GetPresetTextQueries_ResponseParamsSpec.$,
        impl.getPresetTextQueries.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        EditorClient_RequestPresetRewrite_ParamsSpec.$,
        EditorClient_RequestPresetRewrite_ResponseParamsSpec.$,
        impl.requestPresetRewrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        EditorClient_RequestFreeformRewrite_ParamsSpec.$,
        EditorClient_RequestFreeformRewrite_ResponseParamsSpec.$,
        impl.requestFreeformRewrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        EditorClient_RequestFreeformWrite_ParamsSpec.$,
        EditorClient_RequestFreeformWrite_ResponseParamsSpec.$,
        impl.requestFreeformWrite.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        EditorClient_InsertText_ParamsSpec.$,
        null,
        impl.insertText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        EditorClient_ApproveConsent_ParamsSpec.$,
        null,
        impl.approveConsent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        EditorClient_DeclineConsent_ParamsSpec.$,
        null,
        impl.declineConsent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        EditorClient_DismissConsent_ParamsSpec.$,
        null,
        impl.dismissConsent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        EditorClient_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        impl.openUrlInNewWindow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        EditorClient_ShowUI_ParamsSpec.$,
        null,
        impl.showUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        EditorClient_CloseUI_ParamsSpec.$,
        null,
        impl.closeUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        EditorClient_AppendText_ParamsSpec.$,
        null,
        impl.appendText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        EditorClient_PreviewFeedback_ParamsSpec.$,
        EditorClient_PreviewFeedback_ResponseParamsSpec.$,
        impl.previewFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        EditorClient_SubmitFeedback_ParamsSpec.$,
        null,
        impl.submitFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        EditorClient_OnTrigger_ParamsSpec.$,
        null,
        impl.onTrigger.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        EditorClient_EmitMetricEvent_ParamsSpec.$,
        null,
        impl.emitMetricEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class EditorClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.orca.mojom.EditorClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!EditorClientRemote}
   */
  static getRemote() {
    let remote = new EditorClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the EditorClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class EditorClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      EditorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EditorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPresetTextQueries =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        EditorClient_GetPresetTextQueries_ParamsSpec.$,
        EditorClient_GetPresetTextQueries_ResponseParamsSpec.$,
        this.getPresetTextQueries.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPresetRewrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        EditorClient_RequestPresetRewrite_ParamsSpec.$,
        EditorClient_RequestPresetRewrite_ResponseParamsSpec.$,
        this.requestPresetRewrite.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestFreeformRewrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        EditorClient_RequestFreeformRewrite_ParamsSpec.$,
        EditorClient_RequestFreeformRewrite_ResponseParamsSpec.$,
        this.requestFreeformRewrite.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestFreeformWrite =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        EditorClient_RequestFreeformWrite_ParamsSpec.$,
        EditorClient_RequestFreeformWrite_ResponseParamsSpec.$,
        this.requestFreeformWrite.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.insertText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        EditorClient_InsertText_ParamsSpec.$,
        null,
        this.insertText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.approveConsent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        EditorClient_ApproveConsent_ParamsSpec.$,
        null,
        this.approveConsent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.declineConsent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        EditorClient_DeclineConsent_ParamsSpec.$,
        null,
        this.declineConsent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dismissConsent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        EditorClient_DismissConsent_ParamsSpec.$,
        null,
        this.dismissConsent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openUrlInNewWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        EditorClient_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        this.openUrlInNewWindow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        EditorClient_ShowUI_ParamsSpec.$,
        null,
        this.showUI.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        EditorClient_CloseUI_ParamsSpec.$,
        null,
        this.closeUI.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.appendText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        EditorClient_AppendText_ParamsSpec.$,
        null,
        this.appendText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.previewFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        EditorClient_PreviewFeedback_ParamsSpec.$,
        EditorClient_PreviewFeedback_ResponseParamsSpec.$,
        this.previewFeedback.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submitFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        EditorClient_SubmitFeedback_ParamsSpec.$,
        null,
        this.submitFeedback.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTrigger =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        EditorClient_OnTrigger_ParamsSpec.$,
        null,
        this.onTrigger.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.emitMetricEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        EditorClient_EmitMetricEvent_ParamsSpec.$,
        null,
        this.emitMetricEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class EditorClientConnectorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.orca.mojom.EditorClientConnector', scope);
  }
}

/** @interface */
export class EditorClientConnectorInterface {
  
  /**
   * @param { !EditorClientPendingReceiver } editorClient
   */

  bindEditorClient(editorClient) {}
}

/**
 * @implements { EditorClientConnectorInterface }
 */
export class EditorClientConnectorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!EditorClientConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          EditorClientConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!EditorClientConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !EditorClientPendingReceiver } editorClient
   */

  bindEditorClient(
      editorClient) {
    this.proxy.sendMessage(
        0,
        EditorClientConnector_BindEditorClient_ParamsSpec.$,
        null,
        [
          editorClient
        ],
        false);
  }
}

/**
 * An object which receives request messages for the EditorClientConnector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class EditorClientConnectorReceiver {
  /**
   * @param {!EditorClientConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!EditorClientConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        EditorClientConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EditorClientConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        EditorClientConnector_BindEditorClient_ParamsSpec.$,
        null,
        impl.bindEditorClient.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class EditorClientConnector {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.orca.mojom.EditorClientConnector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!EditorClientConnectorRemote}
   */
  static getRemote() {
    let remote = new EditorClientConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the EditorClientConnector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class EditorClientConnectorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      EditorClientConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EditorClientConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindEditorClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        EditorClientConnector_BindEditorClient_ParamsSpec.$,
        null,
        this.bindEditorClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class EditorEventSinkPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.orca.mojom.EditorEventSink', scope);
  }
}

/** @interface */
export class EditorEventSinkInterface {
  
  /**
   * @param { !Context } context
   */

  onContextUpdated(context) {}
}

/**
 * @implements { EditorEventSinkInterface }
 */
export class EditorEventSinkRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!EditorEventSinkPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          EditorEventSinkPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!EditorEventSinkPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Context } context
   */

  onContextUpdated(
      context) {
    this.proxy.sendMessage(
        0,
        EditorEventSink_OnContextUpdated_ParamsSpec.$,
        null,
        [
          context
        ],
        false);
  }
}

/**
 * An object which receives request messages for the EditorEventSink
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class EditorEventSinkReceiver {
  /**
   * @param {!EditorEventSinkInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!EditorEventSinkRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        EditorEventSinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EditorEventSinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        EditorEventSink_OnContextUpdated_ParamsSpec.$,
        null,
        impl.onContextUpdated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class EditorEventSink {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.orca.mojom.EditorEventSink";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!EditorEventSinkRemote}
   */
  static getRemote() {
    let remote = new EditorEventSinkRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the EditorEventSink
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class EditorEventSinkCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      EditorEventSinkRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!EditorEventSinkRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onContextUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        EditorEventSink_OnContextUpdated_ParamsSpec.$,
        null,
        this.onContextUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SystemActuatorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.orca.mojom.SystemActuator', scope);
  }
}

/** @interface */
export class SystemActuatorInterface {
  
  /**
   * @param { !string } text
   */

  insertText(text) {}
  
  /**
   */

  approveConsent() {}
  
  /**
   */

  declineConsent() {}
  
  /**
   * @param { !url_mojom_Url } url
   */

  openUrlInNewWindow(url) {}
  
  /**
   */

  showUI() {}
  
  /**
   */

  closeUI() {}
  
  /**
   * @param { !string } description
   */

  submitFeedback(description) {}
  
  /**
   * @param { !TriggerContext } triggerContext
   */

  onTrigger(triggerContext) {}
  
  /**
   * @param { !MetricEvent } metricEvent
   */

  emitMetricEvent(metricEvent) {}
}

/**
 * @implements { SystemActuatorInterface }
 */
export class SystemActuatorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SystemActuatorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SystemActuatorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SystemActuatorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } text
   */

  insertText(
      text) {
    this.proxy.sendMessage(
        0,
        SystemActuator_InsertText_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }

  
  /**
   */

  approveConsent() {
    this.proxy.sendMessage(
        1,
        SystemActuator_ApproveConsent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  declineConsent() {
    this.proxy.sendMessage(
        2,
        SystemActuator_DeclineConsent_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   */

  openUrlInNewWindow(
      url) {
    this.proxy.sendMessage(
        3,
        SystemActuator_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  
  /**
   */

  showUI() {
    this.proxy.sendMessage(
        4,
        SystemActuator_ShowUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  closeUI() {
    this.proxy.sendMessage(
        5,
        SystemActuator_CloseUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } description
   */

  submitFeedback(
      description) {
    this.proxy.sendMessage(
        6,
        SystemActuator_SubmitFeedback_ParamsSpec.$,
        null,
        [
          description
        ],
        false);
  }

  
  /**
   * @param { !TriggerContext } triggerContext
   */

  onTrigger(
      triggerContext) {
    this.proxy.sendMessage(
        7,
        SystemActuator_OnTrigger_ParamsSpec.$,
        null,
        [
          triggerContext
        ],
        false);
  }

  
  /**
   * @param { !MetricEvent } metricEvent
   */

  emitMetricEvent(
      metricEvent) {
    this.proxy.sendMessage(
        8,
        SystemActuator_EmitMetricEvent_ParamsSpec.$,
        null,
        [
          metricEvent
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SystemActuator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SystemActuatorReceiver {
  /**
   * @param {!SystemActuatorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SystemActuatorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SystemActuatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SystemActuatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SystemActuator_InsertText_ParamsSpec.$,
        null,
        impl.insertText.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SystemActuator_ApproveConsent_ParamsSpec.$,
        null,
        impl.approveConsent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SystemActuator_DeclineConsent_ParamsSpec.$,
        null,
        impl.declineConsent.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SystemActuator_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        impl.openUrlInNewWindow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        SystemActuator_ShowUI_ParamsSpec.$,
        null,
        impl.showUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        SystemActuator_CloseUI_ParamsSpec.$,
        null,
        impl.closeUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        SystemActuator_SubmitFeedback_ParamsSpec.$,
        null,
        impl.submitFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        SystemActuator_OnTrigger_ParamsSpec.$,
        null,
        impl.onTrigger.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        SystemActuator_EmitMetricEvent_ParamsSpec.$,
        null,
        impl.emitMetricEvent.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SystemActuator {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.orca.mojom.SystemActuator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SystemActuatorRemote}
   */
  static getRemote() {
    let remote = new SystemActuatorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SystemActuator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SystemActuatorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SystemActuatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SystemActuatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.insertText =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SystemActuator_InsertText_ParamsSpec.$,
        null,
        this.insertText.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.approveConsent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SystemActuator_ApproveConsent_ParamsSpec.$,
        null,
        this.approveConsent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.declineConsent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SystemActuator_DeclineConsent_ParamsSpec.$,
        null,
        this.declineConsent.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openUrlInNewWindow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SystemActuator_OpenUrlInNewWindow_ParamsSpec.$,
        null,
        this.openUrlInNewWindow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SystemActuator_ShowUI_ParamsSpec.$,
        null,
        this.showUI.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.closeUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        SystemActuator_CloseUI_ParamsSpec.$,
        null,
        this.closeUI.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submitFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        SystemActuator_SubmitFeedback_ParamsSpec.$,
        null,
        this.submitFeedback.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTrigger =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        SystemActuator_OnTrigger_ParamsSpec.$,
        null,
        this.onTrigger.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.emitMetricEvent =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        SystemActuator_EmitMetricEvent_ParamsSpec.$,
        null,
        this.emitMetricEvent.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TextQueryProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.orca.mojom.TextQueryProvider', scope);
  }
}

/** @interface */
export class TextQueryProviderInterface {
  
  /**
   * @param { !TextQueryRequest } request
   * @return {!Promise<{
        response: !TextQueryResponse,
   *  }>}
   */

  process(request) {}
}

/**
 * @implements { TextQueryProviderInterface }
 */
export class TextQueryProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TextQueryProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TextQueryProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TextQueryProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !TextQueryRequest } request
   * @return {!Promise<{
        response: !TextQueryResponse,
   *  }>}
   */

  process(
      request) {
    return this.proxy.sendMessage(
        0,
        TextQueryProvider_Process_ParamsSpec.$,
        TextQueryProvider_Process_ResponseParamsSpec.$,
        [
          request
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TextQueryProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextQueryProviderReceiver {
  /**
   * @param {!TextQueryProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TextQueryProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TextQueryProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextQueryProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TextQueryProvider_Process_ParamsSpec.$,
        TextQueryProvider_Process_ResponseParamsSpec.$,
        impl.process.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TextQueryProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.orca.mojom.TextQueryProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TextQueryProviderRemote}
   */
  static getRemote() {
    let remote = new TextQueryProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TextQueryProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextQueryProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TextQueryProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TextQueryProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.process =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TextQueryProvider_Process_ParamsSpec.$,
        TextQueryProvider_Process_ResponseParamsSpec.$,
        this.process.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class OrcaServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.orca.mojom.OrcaService', scope);
  }
}

/** @interface */
export class OrcaServiceInterface {
  
  /**
   * @param { !Object } systemActuator
   * @param { !Object } textQueryProvider
   * @param { !Object } clientConnector
   * @param { !Object } eventSink
   * @param { ?EditorConfig } editorConfig
   */

  bindEditor(systemActuator, textQueryProvider, clientConnector, eventSink, editorConfig) {}
}

/**
 * @implements { OrcaServiceInterface }
 */
export class OrcaServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!OrcaServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          OrcaServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!OrcaServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } systemActuator
   * @param { !Object } textQueryProvider
   * @param { !Object } clientConnector
   * @param { !Object } eventSink
   * @param { ?EditorConfig } editorConfig
   */

  bindEditor(
      systemActuator,
      textQueryProvider,
      clientConnector,
      eventSink,
      editorConfig) {
    this.proxy.sendMessage(
        0,
        OrcaService_BindEditor_ParamsSpec.$,
        null,
        [
          systemActuator,
          textQueryProvider,
          clientConnector,
          eventSink,
          editorConfig
        ],
        false);
  }
}

/**
 * An object which receives request messages for the OrcaService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OrcaServiceReceiver {
  /**
   * @param {!OrcaServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!OrcaServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        OrcaServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OrcaServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        OrcaService_BindEditor_ParamsSpec.$,
        null,
        impl.bindEditor.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class OrcaService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.orca.mojom.OrcaService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!OrcaServiceRemote}
   */
  static getRemote() {
    let remote = new OrcaServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the OrcaService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OrcaServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      OrcaServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!OrcaServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindEditor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        OrcaService_BindEditor_ParamsSpec.$,
        null,
        this.bindEditor.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PresetTextQuerySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextQueryRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextQueryResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextQueryErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SurroundingTextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TriggerContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_GetPresetTextQueries_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_GetPresetTextQueries_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_RequestPresetRewrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_RequestPresetRewrite_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_RequestFreeformRewrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_RequestFreeformRewrite_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_RequestFreeformWrite_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_RequestFreeformWrite_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_InsertText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_ApproveConsent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_DeclineConsent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_DismissConsent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_OpenUrlInNewWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_ShowUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_CloseUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_AppendText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_PreviewFeedback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_PreviewFeedback_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_SubmitFeedback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_OnTrigger_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClient_EmitMetricEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorClientConnector_BindEditorClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EditorEventSink_OnContextUpdated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemActuator_InsertText_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemActuator_ApproveConsent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemActuator_DeclineConsent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemActuator_OpenUrlInNewWindow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemActuator_ShowUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemActuator_CloseUI_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemActuator_SubmitFeedback_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemActuator_OnTrigger_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemActuator_EmitMetricEvent_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextQueryProvider_Process_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TextQueryProvider_Process_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OrcaService_BindEditor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const TextQueryResponseSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PresetTextQuerySpec.$,
    'PresetTextQuery',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'description', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 24,
        0,
        PresetTextQueryTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class PresetTextQuery {
  constructor() {
    /** @type { !string } */
    this.id;
    /** @type { !string } */
    this.label;
    /** @type { !string } */
    this.description;
    /** @type { !PresetTextQueryType } */
    this.type;
  }
}



mojo.internal.Struct(
    TextQueryRequestSpec.$,
    'TextQueryRequest',
    [
      mojo.internal.StructField(
        'textQueryId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'version', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'parameters', 16,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TextQueryRequest {
  constructor() {
    /** @type { !string } */
    this.textQueryId;
    /** @type { !string } */
    this.version;
    /** @type { !Object<!string, !string> } */
    this.parameters;
  }
}



mojo.internal.Struct(
    TextQueryResultSpec.$,
    'TextQueryResult',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'text', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TextQueryResult {
  constructor() {
    /** @type { !string } */
    this.id;
    /** @type { !string } */
    this.text;
  }
}



mojo.internal.Struct(
    TextQueryErrorSpec.$,
    'TextQueryError',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        TextQueryErrorCodeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TextQueryError {
  constructor() {
    /** @type { !TextQueryErrorCode } */
    this.code;
    /** @type { !string } */
    this.message;
  }
}



mojo.internal.Struct(
    SurroundingTextSpec.$,
    'SurroundingText',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'range', 8,
        0,
        gfx_mojom_RangeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SurroundingText {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { !gfx_mojom_Range } */
    this.range;
  }
}



mojo.internal.Struct(
    ContextSpec.$,
    'Context',
    [
      mojo.internal.StructField(
        'surroundingText', 0,
        0,
        SurroundingTextSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Context {
  constructor() {
    /** @type { !SurroundingText } */
    this.surroundingText;
  }
}



mojo.internal.Struct(
    EditorConfigSpec.$,
    'EditorConfig',
    [
      mojo.internal.StructField(
        'allowedQueryTypes', 0,
        0,
        mojo.internal.Array(PresetTextQueryTypeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'languageCode', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        12,
      ),
    ],
    [[0, 16],[12, 24],]);



/**
 * @record
 */
export class EditorConfig {
  constructor() {
    /** @type { !Array<!PresetTextQueryType> } */
    this.allowedQueryTypes;
    /** @type { (string|undefined) } */
    this.languageCode;
  }
}



mojo.internal.Struct(
    TriggerContextSpec.$,
    'TriggerContext',
    [
      mojo.internal.StructField(
        'freeformSelected', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'presetTypeSelected', 4,
        0,
        PresetTextQueryTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TriggerContext {
  constructor() {
    /** @type { !boolean } */
    this.freeformSelected;
    /** @type { !PresetTextQueryType } */
    this.presetTypeSelected;
  }
}



mojo.internal.Struct(
    EditorClient_GetPresetTextQueries_ParamsSpec.$,
    'EditorClient_GetPresetTextQueries_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class EditorClient_GetPresetTextQueries_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    EditorClient_GetPresetTextQueries_ResponseParamsSpec.$,
    'EditorClient_GetPresetTextQueries_ResponseParams',
    [
      mojo.internal.StructField(
        'textQueries', 0,
        0,
        mojo.internal.Array(PresetTextQuerySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EditorClient_GetPresetTextQueries_ResponseParams {
  constructor() {
    /** @type { !Array<!PresetTextQuery> } */
    this.textQueries;
  }
}



mojo.internal.Struct(
    EditorClient_RequestPresetRewrite_ParamsSpec.$,
    'EditorClient_RequestPresetRewrite_Params',
    [
      mojo.internal.StructField(
        'textQueryId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textOverride', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EditorClient_RequestPresetRewrite_Params {
  constructor() {
    /** @type { !string } */
    this.textQueryId;
    /** @type { (string|undefined) } */
    this.textOverride;
  }
}



mojo.internal.Struct(
    EditorClient_RequestPresetRewrite_ResponseParamsSpec.$,
    'EditorClient_RequestPresetRewrite_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        TextQueryResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EditorClient_RequestPresetRewrite_ResponseParams {
  constructor() {
    /** @type { !TextQueryResponse } */
    this.response;
  }
}



mojo.internal.Struct(
    EditorClient_RequestFreeformRewrite_ParamsSpec.$,
    'EditorClient_RequestFreeformRewrite_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textOverride', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EditorClient_RequestFreeformRewrite_Params {
  constructor() {
    /** @type { !string } */
    this.input;
    /** @type { (string|undefined) } */
    this.textOverride;
  }
}



mojo.internal.Struct(
    EditorClient_RequestFreeformRewrite_ResponseParamsSpec.$,
    'EditorClient_RequestFreeformRewrite_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        TextQueryResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EditorClient_RequestFreeformRewrite_ResponseParams {
  constructor() {
    /** @type { !TextQueryResponse } */
    this.response;
  }
}



mojo.internal.Struct(
    EditorClient_RequestFreeformWrite_ParamsSpec.$,
    'EditorClient_RequestFreeformWrite_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EditorClient_RequestFreeformWrite_Params {
  constructor() {
    /** @type { !string } */
    this.input;
  }
}



mojo.internal.Struct(
    EditorClient_RequestFreeformWrite_ResponseParamsSpec.$,
    'EditorClient_RequestFreeformWrite_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        TextQueryResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EditorClient_RequestFreeformWrite_ResponseParams {
  constructor() {
    /** @type { !TextQueryResponse } */
    this.response;
  }
}



mojo.internal.Struct(
    EditorClient_InsertText_ParamsSpec.$,
    'EditorClient_InsertText_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EditorClient_InsertText_Params {
  constructor() {
    /** @type { !string } */
    this.text;
  }
}



mojo.internal.Struct(
    EditorClient_ApproveConsent_ParamsSpec.$,
    'EditorClient_ApproveConsent_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class EditorClient_ApproveConsent_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    EditorClient_DeclineConsent_ParamsSpec.$,
    'EditorClient_DeclineConsent_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class EditorClient_DeclineConsent_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    EditorClient_DismissConsent_ParamsSpec.$,
    'EditorClient_DismissConsent_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class EditorClient_DismissConsent_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    EditorClient_OpenUrlInNewWindow_ParamsSpec.$,
    'EditorClient_OpenUrlInNewWindow_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EditorClient_OpenUrlInNewWindow_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    EditorClient_ShowUI_ParamsSpec.$,
    'EditorClient_ShowUI_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class EditorClient_ShowUI_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    EditorClient_CloseUI_ParamsSpec.$,
    'EditorClient_CloseUI_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class EditorClient_CloseUI_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    EditorClient_AppendText_ParamsSpec.$,
    'EditorClient_AppendText_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EditorClient_AppendText_Params {
  constructor() {
    /** @type { !string } */
    this.text;
  }
}



mojo.internal.Struct(
    EditorClient_PreviewFeedback_ParamsSpec.$,
    'EditorClient_PreviewFeedback_Params',
    [
      mojo.internal.StructField(
        'resultId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EditorClient_PreviewFeedback_Params {
  constructor() {
    /** @type { !string } */
    this.resultId;
  }
}



mojo.internal.Struct(
    EditorClient_PreviewFeedback_ResponseParamsSpec.$,
    'EditorClient_PreviewFeedback_ResponseParams',
    [
      mojo.internal.StructField(
        'preview', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EditorClient_PreviewFeedback_ResponseParams {
  constructor() {
    /** @type { !Object<!string, !string> } */
    this.preview;
  }
}



mojo.internal.Struct(
    EditorClient_SubmitFeedback_ParamsSpec.$,
    'EditorClient_SubmitFeedback_Params',
    [
      mojo.internal.StructField(
        'resultId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userDescription', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EditorClient_SubmitFeedback_Params {
  constructor() {
    /** @type { !string } */
    this.resultId;
    /** @type { !string } */
    this.userDescription;
  }
}



mojo.internal.Struct(
    EditorClient_OnTrigger_ParamsSpec.$,
    'EditorClient_OnTrigger_Params',
    [
      mojo.internal.StructField(
        'triggerContext', 0,
        0,
        TriggerContextSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EditorClient_OnTrigger_Params {
  constructor() {
    /** @type { !TriggerContext } */
    this.triggerContext;
  }
}



mojo.internal.Struct(
    EditorClient_EmitMetricEvent_ParamsSpec.$,
    'EditorClient_EmitMetricEvent_Params',
    [
      mojo.internal.StructField(
        'metricEvent', 0,
        0,
        MetricEventSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EditorClient_EmitMetricEvent_Params {
  constructor() {
    /** @type { !MetricEvent } */
    this.metricEvent;
  }
}



mojo.internal.Struct(
    EditorClientConnector_BindEditorClient_ParamsSpec.$,
    'EditorClientConnector_BindEditorClient_Params',
    [
      mojo.internal.StructField(
        'editorClient', 0,
        0,
        mojo.internal.InterfaceRequest(EditorClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EditorClientConnector_BindEditorClient_Params {
  constructor() {
    /** @type { !EditorClientPendingReceiver } */
    this.editorClient;
  }
}



mojo.internal.Struct(
    EditorEventSink_OnContextUpdated_ParamsSpec.$,
    'EditorEventSink_OnContextUpdated_Params',
    [
      mojo.internal.StructField(
        'context', 0,
        0,
        ContextSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class EditorEventSink_OnContextUpdated_Params {
  constructor() {
    /** @type { !Context } */
    this.context;
  }
}



mojo.internal.Struct(
    SystemActuator_InsertText_ParamsSpec.$,
    'SystemActuator_InsertText_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SystemActuator_InsertText_Params {
  constructor() {
    /** @type { !string } */
    this.text;
  }
}



mojo.internal.Struct(
    SystemActuator_ApproveConsent_ParamsSpec.$,
    'SystemActuator_ApproveConsent_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SystemActuator_ApproveConsent_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SystemActuator_DeclineConsent_ParamsSpec.$,
    'SystemActuator_DeclineConsent_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SystemActuator_DeclineConsent_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SystemActuator_OpenUrlInNewWindow_ParamsSpec.$,
    'SystemActuator_OpenUrlInNewWindow_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SystemActuator_OpenUrlInNewWindow_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
  }
}



mojo.internal.Struct(
    SystemActuator_ShowUI_ParamsSpec.$,
    'SystemActuator_ShowUI_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SystemActuator_ShowUI_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SystemActuator_CloseUI_ParamsSpec.$,
    'SystemActuator_CloseUI_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SystemActuator_CloseUI_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SystemActuator_SubmitFeedback_ParamsSpec.$,
    'SystemActuator_SubmitFeedback_Params',
    [
      mojo.internal.StructField(
        'description', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SystemActuator_SubmitFeedback_Params {
  constructor() {
    /** @type { !string } */
    this.description;
  }
}



mojo.internal.Struct(
    SystemActuator_OnTrigger_ParamsSpec.$,
    'SystemActuator_OnTrigger_Params',
    [
      mojo.internal.StructField(
        'triggerContext', 0,
        0,
        TriggerContextSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SystemActuator_OnTrigger_Params {
  constructor() {
    /** @type { !TriggerContext } */
    this.triggerContext;
  }
}



mojo.internal.Struct(
    SystemActuator_EmitMetricEvent_ParamsSpec.$,
    'SystemActuator_EmitMetricEvent_Params',
    [
      mojo.internal.StructField(
        'metricEvent', 0,
        0,
        MetricEventSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SystemActuator_EmitMetricEvent_Params {
  constructor() {
    /** @type { !MetricEvent } */
    this.metricEvent;
  }
}



mojo.internal.Struct(
    TextQueryProvider_Process_ParamsSpec.$,
    'TextQueryProvider_Process_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        TextQueryRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TextQueryProvider_Process_Params {
  constructor() {
    /** @type { !TextQueryRequest } */
    this.request;
  }
}



mojo.internal.Struct(
    TextQueryProvider_Process_ResponseParamsSpec.$,
    'TextQueryProvider_Process_ResponseParams',
    [
      mojo.internal.StructField(
        'response', 0,
        0,
        TextQueryResponseSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TextQueryProvider_Process_ResponseParams {
  constructor() {
    /** @type { !TextQueryResponse } */
    this.response;
  }
}



mojo.internal.Struct(
    OrcaService_BindEditor_ParamsSpec.$,
    'OrcaService_BindEditor_Params',
    [
      mojo.internal.StructField(
        'systemActuator', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(SystemActuatorRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textQueryProvider', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(TextQueryProviderRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientConnector', 16,
        0,
        mojo.internal.AssociatedInterfaceRequest(EditorClientConnectorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventSink', 20,
        0,
        mojo.internal.AssociatedInterfaceRequest(EditorEventSinkPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'editorConfig', 24,
        0,
        EditorConfigSpec.$,
        null,
        true /* nullable */,
        9,
      ),
    ],
    [[0, 32],[9, 40],]);



/**
 * @record
 */
export class OrcaService_BindEditor_Params {
  constructor() {
    /** @type { !Object } */
    this.systemActuator;
    /** @type { !Object } */
    this.textQueryProvider;
    /** @type { !Object } */
    this.clientConnector;
    /** @type { !Object } */
    this.eventSink;
    /** @type { (EditorConfig|undefined) } */
    this.editorConfig;
  }
}

mojo.internal.Union(
    TextQueryResponseSpec.$, 'TextQueryResponse',
    {
      'results': {
        'ordinal': 0,
        'type': mojo.internal.Array(TextQueryResultSpec.$, false),
      },
      'error': {
        'ordinal': 1,
        'type': TextQueryErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   results: (!Array<!TextQueryResult>|undefined),
 *   error: (!TextQueryError|undefined),
 * } }
 */
export const TextQueryResponse = {};
