// chromeos/components/remote_apps/mojom/remote_apps.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('chromeos.remoteApps.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppsPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.remoteApps.mojom.RemoteApps.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.remoteApps.mojom.RemoteAppsInterface }
 */
chromeos.remoteApps.mojom.RemoteAppsRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.remoteApps.mojom.RemoteAppsPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.remoteApps.mojom.RemoteAppsPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.remoteApps.mojom.RemoteAppsPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } name
   * @param { !boolean } addToFront
   * @return {!Promise<{
        result: !chromeos.remoteApps.mojom.AddFolderResult,
   *  }>}
   */

  addFolder(
      name,
      addToFront) {
    return this.proxy.sendMessage(
        0,
        chromeos.remoteApps.mojom.RemoteApps_AddFolder_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_AddFolder_ResponseParamsSpec.$,
        [
          name,
          addToFront
        ],
        false);
  }

  
  /**
   * @param { !string } sourceId
   * @param { !string } name
   * @param { !string } folderId
   * @param { !url.mojom.Url } iconUrl
   * @param { !boolean } addToFront
   * @return {!Promise<{
        result: !chromeos.remoteApps.mojom.AddAppResult,
   *  }>}
   */

  addApp(
      sourceId,
      name,
      folderId,
      iconUrl,
      addToFront) {
    return this.proxy.sendMessage(
        1,
        chromeos.remoteApps.mojom.RemoteApps_AddApp_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_AddApp_ResponseParamsSpec.$,
        [
          sourceId,
          name,
          folderId,
          iconUrl,
          addToFront
        ],
        false);
  }

  
  /**
   * @param { !string } appId
   * @return {!Promise<{
        error: ?string,
   *  }>}
   */

  deleteApp(
      appId) {
    return this.proxy.sendMessage(
        2,
        chromeos.remoteApps.mojom.RemoteApps_DeleteApp_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_DeleteApp_ResponseParamsSpec.$,
        [
          appId
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: ?string,
   *  }>}
   */

  sortLauncherWithRemoteAppsFirst() {
    return this.proxy.sendMessage(
        3,
        chromeos.remoteApps.mojom.RemoteApps_SortLauncherWithRemoteAppsFirst_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } appIds
   * @return {!Promise<{
        error: ?string,
   *  }>}
   */

  setPinnedApps(
      appIds) {
    return this.proxy.sendMessage(
        4,
        chromeos.remoteApps.mojom.RemoteApps_SetPinnedApps_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_SetPinnedApps_ResponseParamsSpec.$,
        [
          appIds
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RemoteApps
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppsReceiver = class {
  /**
   * @param {!chromeos.remoteApps.mojom.RemoteAppsInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.remoteApps.mojom.RemoteAppsRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.remoteApps.mojom.RemoteAppsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.remoteApps.mojom.RemoteAppsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.remoteApps.mojom.RemoteApps_AddFolder_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_AddFolder_ResponseParamsSpec.$,
        impl.addFolder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeos.remoteApps.mojom.RemoteApps_AddApp_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_AddApp_ResponseParamsSpec.$,
        impl.addApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        chromeos.remoteApps.mojom.RemoteApps_DeleteApp_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_DeleteApp_ResponseParamsSpec.$,
        impl.deleteApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        chromeos.remoteApps.mojom.RemoteApps_SortLauncherWithRemoteAppsFirst_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParamsSpec.$,
        impl.sortLauncherWithRemoteAppsFirst.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        chromeos.remoteApps.mojom.RemoteApps_SetPinnedApps_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_SetPinnedApps_ResponseParamsSpec.$,
        impl.setPinnedApps.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.remoteApps.mojom.RemoteApps = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.remote_apps.mojom.RemoteApps";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.remoteApps.mojom.RemoteAppsRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.remoteApps.mojom.RemoteAppsRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RemoteApps
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppsCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.remoteApps.mojom.RemoteAppsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.remoteApps.mojom.RemoteAppsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addFolder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.remoteApps.mojom.RemoteApps_AddFolder_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_AddFolder_ResponseParamsSpec.$,
        this.addFolder.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeos.remoteApps.mojom.RemoteApps_AddApp_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_AddApp_ResponseParamsSpec.$,
        this.addApp.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        chromeos.remoteApps.mojom.RemoteApps_DeleteApp_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_DeleteApp_ResponseParamsSpec.$,
        this.deleteApp.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sortLauncherWithRemoteAppsFirst =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        chromeos.remoteApps.mojom.RemoteApps_SortLauncherWithRemoteAppsFirst_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParamsSpec.$,
        this.sortLauncherWithRemoteAppsFirst.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPinnedApps =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        chromeos.remoteApps.mojom.RemoteApps_SetPinnedApps_ParamsSpec.$,
        chromeos.remoteApps.mojom.RemoteApps_SetPinnedApps_ResponseParamsSpec.$,
        this.setPinnedApps.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppsFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.remoteApps.mojom.RemoteAppsFactory.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.remoteApps.mojom.RemoteAppsFactoryInterface }
 */
chromeos.remoteApps.mojom.RemoteAppsFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.remoteApps.mojom.RemoteAppsFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.remoteApps.mojom.RemoteAppsFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.remoteApps.mojom.RemoteAppsFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } sourceId
   * @param { !chromeos.remoteApps.mojom.RemoteAppsPendingReceiver } remoteApps
   * @param { !chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote } observer
   */

  bindRemoteAppsAndAppLaunchObserver(
      sourceId,
      remoteApps,
      observer) {
    this.proxy.sendMessage(
        0,
        chromeos.remoteApps.mojom.RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_ParamsSpec.$,
        null,
        [
          sourceId,
          remoteApps,
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RemoteAppsFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppsFactoryReceiver = class {
  /**
   * @param {!chromeos.remoteApps.mojom.RemoteAppsFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.remoteApps.mojom.RemoteAppsFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.remoteApps.mojom.RemoteAppsFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.remoteApps.mojom.RemoteAppsFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.remoteApps.mojom.RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_ParamsSpec.$,
        null,
        impl.bindRemoteAppsAndAppLaunchObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.remoteApps.mojom.RemoteAppsFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.remote_apps.mojom.RemoteAppsFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.remoteApps.mojom.RemoteAppsFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.remoteApps.mojom.RemoteAppsFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RemoteAppsFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppsFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.remoteApps.mojom.RemoteAppsFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.remoteApps.mojom.RemoteAppsFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindRemoteAppsAndAppLaunchObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.remoteApps.mojom.RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_ParamsSpec.$,
        null,
        this.bindRemoteAppsAndAppLaunchObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppsLacrosBridgePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.remoteApps.mojom.RemoteAppsLacrosBridge.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.remoteApps.mojom.RemoteAppsLacrosBridgeInterface }
 */
chromeos.remoteApps.mojom.RemoteAppsLacrosBridgeRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.remoteApps.mojom.RemoteAppsLacrosBridgePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.remoteApps.mojom.RemoteAppsLacrosBridgePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.remoteApps.mojom.RemoteAppsLacrosBridgePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !chromeos.remoteApps.mojom.RemoteAppsPendingReceiver } remoteApps
   * @param { !chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote } observer
   */

  bindRemoteAppsAndAppLaunchObserverForLacros(
      remoteApps,
      observer) {
    this.proxy.sendMessage(
        0,
        chromeos.remoteApps.mojom.RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_ParamsSpec.$,
        null,
        [
          remoteApps,
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RemoteAppsLacrosBridge
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppsLacrosBridgeReceiver = class {
  /**
   * @param {!chromeos.remoteApps.mojom.RemoteAppsLacrosBridgeInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.remoteApps.mojom.RemoteAppsLacrosBridgeRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.remoteApps.mojom.RemoteAppsLacrosBridgeRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.remoteApps.mojom.RemoteAppsLacrosBridgeRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.remoteApps.mojom.RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_ParamsSpec.$,
        null,
        impl.bindRemoteAppsAndAppLaunchObserverForLacros.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.remoteApps.mojom.RemoteAppsLacrosBridge = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.remote_apps.mojom.RemoteAppsLacrosBridge";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.remoteApps.mojom.RemoteAppsLacrosBridgeRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.remoteApps.mojom.RemoteAppsLacrosBridgeRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RemoteAppsLacrosBridge
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppsLacrosBridgeCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.remoteApps.mojom.RemoteAppsLacrosBridgeRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.remoteApps.mojom.RemoteAppsLacrosBridgeRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindRemoteAppsAndAppLaunchObserverForLacros =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.remoteApps.mojom.RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_ParamsSpec.$,
        null,
        this.bindRemoteAppsAndAppLaunchObserverForLacros.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppLaunchObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.remoteApps.mojom.RemoteAppLaunchObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.remoteApps.mojom.RemoteAppLaunchObserverInterface }
 */
chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.remoteApps.mojom.RemoteAppLaunchObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.remoteApps.mojom.RemoteAppLaunchObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.remoteApps.mojom.RemoteAppLaunchObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } appId
   * @param { !string } sourceId
   */

  onRemoteAppLaunched(
      appId,
      sourceId) {
    this.proxy.sendMessage(
        0,
        chromeos.remoteApps.mojom.RemoteAppLaunchObserver_OnRemoteAppLaunched_ParamsSpec.$,
        null,
        [
          appId,
          sourceId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the RemoteAppLaunchObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppLaunchObserverReceiver = class {
  /**
   * @param {!chromeos.remoteApps.mojom.RemoteAppLaunchObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.remoteApps.mojom.RemoteAppLaunchObserver_OnRemoteAppLaunched_ParamsSpec.$,
        null,
        impl.onRemoteAppLaunched.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.remoteApps.mojom.RemoteAppLaunchObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.remote_apps.mojom.RemoteAppLaunchObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the RemoteAppLaunchObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppLaunchObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRemoteAppLaunched =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.remoteApps.mojom.RemoteAppLaunchObserver_OnRemoteAppLaunched_ParamsSpec.$,
        null,
        this.onRemoteAppLaunched.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.remoteApps.mojom.RemoteApps_AddFolder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.remoteApps.mojom.RemoteApps_AddFolder_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.remoteApps.mojom.RemoteApps_AddApp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.remoteApps.mojom.RemoteApps_AddApp_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.remoteApps.mojom.RemoteApps_DeleteApp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.remoteApps.mojom.RemoteApps_DeleteApp_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.remoteApps.mojom.RemoteApps_SortLauncherWithRemoteAppsFirst_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.remoteApps.mojom.RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.remoteApps.mojom.RemoteApps_SetPinnedApps_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.remoteApps.mojom.RemoteApps_SetPinnedApps_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.remoteApps.mojom.RemoteAppLaunchObserver_OnRemoteAppLaunched_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
chromeos.remoteApps.mojom.AddFolderResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
chromeos.remoteApps.mojom.AddAppResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.remoteApps.mojom.RemoteApps_AddFolder_ParamsSpec.$,
    'RemoteApps_AddFolder_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'addToFront', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.remoteApps.mojom.RemoteApps_AddFolder_Params = class {
  constructor() {
    /** @export { !string } */
    this.name;
    /** @export { !boolean } */
    this.addToFront;
  }
};



mojo.internal.Struct(
    chromeos.remoteApps.mojom.RemoteApps_AddFolder_ResponseParamsSpec.$,
    'RemoteApps_AddFolder_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.remoteApps.mojom.AddFolderResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.remoteApps.mojom.RemoteApps_AddFolder_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.remoteApps.mojom.AddFolderResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.remoteApps.mojom.RemoteApps_AddApp_ParamsSpec.$,
    'RemoteApps_AddApp_Params',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'folderId', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'iconUrl', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'addToFront', 32,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
chromeos.remoteApps.mojom.RemoteApps_AddApp_Params = class {
  constructor() {
    /** @export { !string } */
    this.sourceId;
    /** @export { !string } */
    this.name;
    /** @export { !string } */
    this.folderId;
    /** @export { !url.mojom.Url } */
    this.iconUrl;
    /** @export { !boolean } */
    this.addToFront;
  }
};



mojo.internal.Struct(
    chromeos.remoteApps.mojom.RemoteApps_AddApp_ResponseParamsSpec.$,
    'RemoteApps_AddApp_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.remoteApps.mojom.AddAppResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.remoteApps.mojom.RemoteApps_AddApp_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.remoteApps.mojom.AddAppResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.remoteApps.mojom.RemoteApps_DeleteApp_ParamsSpec.$,
    'RemoteApps_DeleteApp_Params',
    [
      mojo.internal.StructField(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.remoteApps.mojom.RemoteApps_DeleteApp_Params = class {
  constructor() {
    /** @export { !string } */
    this.appId;
  }
};



mojo.internal.Struct(
    chromeos.remoteApps.mojom.RemoteApps_DeleteApp_ResponseParamsSpec.$,
    'RemoteApps_DeleteApp_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.remoteApps.mojom.RemoteApps_DeleteApp_ResponseParams = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.error;
  }
};



mojo.internal.Struct(
    chromeos.remoteApps.mojom.RemoteApps_SortLauncherWithRemoteAppsFirst_ParamsSpec.$,
    'RemoteApps_SortLauncherWithRemoteAppsFirst_Params',
    [
    ],
    [[0, 8],]);





/** @record */
chromeos.remoteApps.mojom.RemoteApps_SortLauncherWithRemoteAppsFirst_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    chromeos.remoteApps.mojom.RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParamsSpec.$,
    'RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.remoteApps.mojom.RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.error;
  }
};



mojo.internal.Struct(
    chromeos.remoteApps.mojom.RemoteApps_SetPinnedApps_ParamsSpec.$,
    'RemoteApps_SetPinnedApps_Params',
    [
      mojo.internal.StructField(
        'appIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.remoteApps.mojom.RemoteApps_SetPinnedApps_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.appIds;
  }
};



mojo.internal.Struct(
    chromeos.remoteApps.mojom.RemoteApps_SetPinnedApps_ResponseParamsSpec.$,
    'RemoteApps_SetPinnedApps_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.remoteApps.mojom.RemoteApps_SetPinnedApps_ResponseParams = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.error;
  }
};



mojo.internal.Struct(
    chromeos.remoteApps.mojom.RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_ParamsSpec.$,
    'RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteApps', 8,
        0,
        mojo.internal.InterfaceRequest(chromeos.remoteApps.mojom.RemoteAppsPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceProxy(chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
chromeos.remoteApps.mojom.RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params = class {
  constructor() {
    /** @export { !string } */
    this.sourceId;
    /** @export { !chromeos.remoteApps.mojom.RemoteAppsPendingReceiver } */
    this.remoteApps;
    /** @export { !chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    chromeos.remoteApps.mojom.RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_ParamsSpec.$,
    'RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params',
    [
      mojo.internal.StructField(
        'remoteApps', 0,
        0,
        mojo.internal.InterfaceRequest(chromeos.remoteApps.mojom.RemoteAppsPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 4,
        0,
        mojo.internal.InterfaceProxy(chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.remoteApps.mojom.RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params = class {
  constructor() {
    /** @export { !chromeos.remoteApps.mojom.RemoteAppsPendingReceiver } */
    this.remoteApps;
    /** @export { !chromeos.remoteApps.mojom.RemoteAppLaunchObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    chromeos.remoteApps.mojom.RemoteAppLaunchObserver_OnRemoteAppLaunched_ParamsSpec.$,
    'RemoteAppLaunchObserver_OnRemoteAppLaunched_Params',
    [
      mojo.internal.StructField(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.remoteApps.mojom.RemoteAppLaunchObserver_OnRemoteAppLaunched_Params = class {
  constructor() {
    /** @export { !string } */
    this.appId;
    /** @export { !string } */
    this.sourceId;
  }
};



mojo.internal.Union(
    chromeos.remoteApps.mojom.AddFolderResultSpec.$, 'AddFolderResult',
    {
      'folderId': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'error': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   folderId: (!string|undefined),
 *   error: (!string|undefined),
 * } }
 */
chromeos.remoteApps.mojom.AddFolderResult;


mojo.internal.Union(
    chromeos.remoteApps.mojom.AddAppResultSpec.$, 'AddAppResult',
    {
      'appId': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'error': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   appId: (!string|undefined),
 *   error: (!string|undefined),
 * } }
 */
chromeos.remoteApps.mojom.AddAppResult;
