// chromeos/components/remote_apps/mojom/remote_apps.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/components/remote_apps/mojom/remote_apps.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.remoteApps.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }



  function RemoteApps_AddFolder_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteApps_AddFolder_Params.prototype.initDefaults_ = function() {
    this.name = null;
    this.addToFront = false;
  };
  RemoteApps_AddFolder_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteApps_AddFolder_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteApps_AddFolder_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemoteApps_AddFolder_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteApps_AddFolder_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteApps_AddFolder_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.addToFront = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteApps_AddFolder_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteApps_AddFolder_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    packed = 0;
    packed |= (val.addToFront & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteApps_AddFolder_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteApps_AddFolder_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  RemoteApps_AddFolder_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteApps_AddFolder_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteApps_AddFolder_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, AddFolderResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteApps_AddFolder_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  RemoteApps_AddFolder_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RemoteApps_AddFolder_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(AddFolderResult);
    return val;
  };

  RemoteApps_AddFolder_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteApps_AddFolder_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(AddFolderResult, val.result);
  };
  function RemoteApps_AddApp_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteApps_AddApp_Params.prototype.initDefaults_ = function() {
    this.sourceId = null;
    this.name = null;
    this.folderId = null;
    this.iconUrl = null;
    this.addToFront = false;
  };
  RemoteApps_AddApp_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteApps_AddApp_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteApps_AddApp_Params.sourceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteApps_AddApp_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteApps_AddApp_Params.folderId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteApps_AddApp_Params.iconUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemoteApps_AddApp_Params.encodedSize = codec.kStructHeaderSize + 40;

  RemoteApps_AddApp_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteApps_AddApp_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sourceId =
        decoder.decodeStruct(codec.String);
    val.name =
        decoder.decodeStruct(codec.String);
    val.folderId =
        decoder.decodeStruct(codec.String);
    val.iconUrl =
        decoder.decodeStructPointer(url$.Url);
    packed = decoder.readUint8();
    val.addToFront = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteApps_AddApp_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteApps_AddApp_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.sourceId);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.folderId);
    encoder.encodeStructPointer(url$.Url, val.iconUrl);
    packed = 0;
    packed |= (val.addToFront & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteApps_AddApp_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteApps_AddApp_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  RemoteApps_AddApp_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteApps_AddApp_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteApps_AddApp_ResponseParams.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, AddAppResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteApps_AddApp_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  RemoteApps_AddApp_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RemoteApps_AddApp_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(AddAppResult);
    return val;
  };

  RemoteApps_AddApp_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteApps_AddApp_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(AddAppResult, val.result);
  };
  function RemoteApps_DeleteApp_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteApps_DeleteApp_Params.prototype.initDefaults_ = function() {
    this.appId = null;
  };
  RemoteApps_DeleteApp_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteApps_DeleteApp_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteApps_DeleteApp_Params.appId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteApps_DeleteApp_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteApps_DeleteApp_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteApps_DeleteApp_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.appId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  RemoteApps_DeleteApp_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteApps_DeleteApp_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.appId);
  };
  function RemoteApps_DeleteApp_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteApps_DeleteApp_ResponseParams.prototype.initDefaults_ = function() {
    this.error = null;
  };
  RemoteApps_DeleteApp_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteApps_DeleteApp_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteApps_DeleteApp_ResponseParams.error
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteApps_DeleteApp_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  RemoteApps_DeleteApp_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RemoteApps_DeleteApp_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(codec.String);
    return val;
  };

  RemoteApps_DeleteApp_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteApps_DeleteApp_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.error);
  };
  function RemoteApps_SortLauncherWithRemoteAppsFirst_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteApps_SortLauncherWithRemoteAppsFirst_Params.prototype.initDefaults_ = function() {
  };
  RemoteApps_SortLauncherWithRemoteAppsFirst_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteApps_SortLauncherWithRemoteAppsFirst_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteApps_SortLauncherWithRemoteAppsFirst_Params.encodedSize = codec.kStructHeaderSize + 0;

  RemoteApps_SortLauncherWithRemoteAppsFirst_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteApps_SortLauncherWithRemoteAppsFirst_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  RemoteApps_SortLauncherWithRemoteAppsFirst_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteApps_SortLauncherWithRemoteAppsFirst_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams.prototype.initDefaults_ = function() {
    this.error = null;
  };
  RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams.error
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(codec.String);
    return val;
  };

  RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.error);
  };
  function RemoteApps_SetPinnedApps_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteApps_SetPinnedApps_Params.prototype.initDefaults_ = function() {
    this.appIds = null;
  };
  RemoteApps_SetPinnedApps_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteApps_SetPinnedApps_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteApps_SetPinnedApps_Params.appIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteApps_SetPinnedApps_Params.encodedSize = codec.kStructHeaderSize + 8;

  RemoteApps_SetPinnedApps_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteApps_SetPinnedApps_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.appIds =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  RemoteApps_SetPinnedApps_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteApps_SetPinnedApps_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.appIds);
  };
  function RemoteApps_SetPinnedApps_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteApps_SetPinnedApps_ResponseParams.prototype.initDefaults_ = function() {
    this.error = null;
  };
  RemoteApps_SetPinnedApps_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteApps_SetPinnedApps_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteApps_SetPinnedApps_ResponseParams.error
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteApps_SetPinnedApps_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  RemoteApps_SetPinnedApps_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new RemoteApps_SetPinnedApps_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.error =
        decoder.decodeStruct(codec.String);
    return val;
  };

  RemoteApps_SetPinnedApps_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteApps_SetPinnedApps_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.error);
  };
  function RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params.prototype.initDefaults_ = function() {
    this.sourceId = null;
    this.remoteApps = new bindings.InterfaceRequest();
    this.observer = new RemoteAppLaunchObserverPtr();
  };
  RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params.sourceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params.remoteApps
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params.encodedSize = codec.kStructHeaderSize + 24;

  RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sourceId =
        decoder.decodeStruct(codec.String);
    val.remoteApps =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.observer =
        decoder.decodeStruct(new codec.Interface(RemoteAppLaunchObserverPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.sourceId);
    encoder.encodeStruct(codec.InterfaceRequest, val.remoteApps);
    encoder.encodeStruct(new codec.Interface(RemoteAppLaunchObserverPtr), val.observer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params.prototype.initDefaults_ = function() {
    this.remoteApps = new bindings.InterfaceRequest();
    this.observer = new RemoteAppLaunchObserverPtr();
  };
  RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params.remoteApps
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.remoteApps =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.observer =
        decoder.decodeStruct(new codec.Interface(RemoteAppLaunchObserverPtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.remoteApps);
    encoder.encodeStruct(new codec.Interface(RemoteAppLaunchObserverPtr), val.observer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemoteAppLaunchObserver_OnRemoteAppLaunched_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteAppLaunchObserver_OnRemoteAppLaunched_Params.prototype.initDefaults_ = function() {
    this.appId = null;
    this.sourceId = null;
  };
  RemoteAppLaunchObserver_OnRemoteAppLaunched_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteAppLaunchObserver_OnRemoteAppLaunched_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteAppLaunchObserver_OnRemoteAppLaunched_Params.appId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteAppLaunchObserver_OnRemoteAppLaunched_Params.sourceId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteAppLaunchObserver_OnRemoteAppLaunched_Params.encodedSize = codec.kStructHeaderSize + 16;

  RemoteAppLaunchObserver_OnRemoteAppLaunched_Params.decode = function(decoder) {
    var packed;
    var val = new RemoteAppLaunchObserver_OnRemoteAppLaunched_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.appId =
        decoder.decodeStruct(codec.String);
    val.sourceId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  RemoteAppLaunchObserver_OnRemoteAppLaunched_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteAppLaunchObserver_OnRemoteAppLaunched_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.appId);
    encoder.encodeStruct(codec.String, val.sourceId);
  };

  function AddFolderResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  AddFolderResult.Tags = {
    folderId: 0,
    error: 1,
  };

  AddFolderResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  AddFolderResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "folderId",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a AddFolderResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(AddFolderResult.prototype, "folderId", {
    get: function() {
      if (this.$tag != AddFolderResult.Tags.folderId) {
        throw new ReferenceError(
            "AddFolderResult.folderId is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AddFolderResult.Tags.folderId;
      this.$data = value;
    }
  });
  Object.defineProperty(AddFolderResult.prototype, "error", {
    get: function() {
      if (this.$tag != AddFolderResult.Tags.error) {
        throw new ReferenceError(
            "AddFolderResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AddFolderResult.Tags.error;
      this.$data = value;
    }
  });


    AddFolderResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case AddFolderResult.Tags.folderId:
          encoder.encodeStruct(codec.String, val.folderId);
          break;
        case AddFolderResult.Tags.error:
          encoder.encodeStruct(codec.String, val.error);
          break;
      }
      encoder.align();
    };


    AddFolderResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new AddFolderResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case AddFolderResult.Tags.folderId:
          result.folderId = decoder.decodeStruct(codec.String);
          break;
        case AddFolderResult.Tags.error:
          result.error = decoder.decodeStruct(codec.String);
          break;
      }
      decoder.align();

      return result;
    };


    AddFolderResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case AddFolderResult.Tags.folderId:
          

    // validate AddFolderResult.folderId
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case AddFolderResult.Tags.error:
          

    // validate AddFolderResult.error
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  AddFolderResult.encodedSize = 16;

  function AddAppResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  AddAppResult.Tags = {
    appId: 0,
    error: 1,
  };

  AddAppResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  AddAppResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "appId",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a AddAppResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(AddAppResult.prototype, "appId", {
    get: function() {
      if (this.$tag != AddAppResult.Tags.appId) {
        throw new ReferenceError(
            "AddAppResult.appId is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AddAppResult.Tags.appId;
      this.$data = value;
    }
  });
  Object.defineProperty(AddAppResult.prototype, "error", {
    get: function() {
      if (this.$tag != AddAppResult.Tags.error) {
        throw new ReferenceError(
            "AddAppResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AddAppResult.Tags.error;
      this.$data = value;
    }
  });


    AddAppResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case AddAppResult.Tags.appId:
          encoder.encodeStruct(codec.String, val.appId);
          break;
        case AddAppResult.Tags.error:
          encoder.encodeStruct(codec.String, val.error);
          break;
      }
      encoder.align();
    };


    AddAppResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new AddAppResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case AddAppResult.Tags.appId:
          result.appId = decoder.decodeStruct(codec.String);
          break;
        case AddAppResult.Tags.error:
          result.error = decoder.decodeStruct(codec.String);
          break;
      }
      decoder.align();

      return result;
    };


    AddAppResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case AddAppResult.Tags.appId:
          

    // validate AddAppResult.appId
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case AddAppResult.Tags.error:
          

    // validate AddAppResult.error
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  AddAppResult.encodedSize = 16;
  var kRemoteApps_AddFolder_Name = 0;
  var kRemoteApps_AddApp_Name = 1;
  var kRemoteApps_DeleteApp_Name = 2;
  var kRemoteApps_SortLauncherWithRemoteAppsFirst_Name = 3;
  var kRemoteApps_SetPinnedApps_Name = 4;

  function RemoteAppsPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(RemoteApps,
                                                   handleOrPtrInfo);
  }

  function RemoteAppsAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        RemoteApps, associatedInterfacePtrInfo);
  }

  RemoteAppsAssociatedPtr.prototype =
      Object.create(RemoteAppsPtr.prototype);
  RemoteAppsAssociatedPtr.prototype.constructor =
      RemoteAppsAssociatedPtr;

  function RemoteAppsProxy(receiver) {
    this.receiver_ = receiver;
  }
  RemoteAppsPtr.prototype.addFolder = function() {
    return RemoteAppsProxy.prototype.addFolder
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteAppsProxy.prototype.addFolder = function(name, addToFront) {
    var params_ = new RemoteApps_AddFolder_Params();
    params_.name = name;
    params_.addToFront = addToFront;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRemoteApps_AddFolder_Name,
          codec.align(RemoteApps_AddFolder_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RemoteApps_AddFolder_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RemoteApps_AddFolder_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RemoteAppsPtr.prototype.addApp = function() {
    return RemoteAppsProxy.prototype.addApp
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteAppsProxy.prototype.addApp = function(sourceId, name, folderId, iconUrl, addToFront) {
    var params_ = new RemoteApps_AddApp_Params();
    params_.sourceId = sourceId;
    params_.name = name;
    params_.folderId = folderId;
    params_.iconUrl = iconUrl;
    params_.addToFront = addToFront;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRemoteApps_AddApp_Name,
          codec.align(RemoteApps_AddApp_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RemoteApps_AddApp_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RemoteApps_AddApp_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RemoteAppsPtr.prototype.deleteApp = function() {
    return RemoteAppsProxy.prototype.deleteApp
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteAppsProxy.prototype.deleteApp = function(appId) {
    var params_ = new RemoteApps_DeleteApp_Params();
    params_.appId = appId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRemoteApps_DeleteApp_Name,
          codec.align(RemoteApps_DeleteApp_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RemoteApps_DeleteApp_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RemoteApps_DeleteApp_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RemoteAppsPtr.prototype.sortLauncherWithRemoteAppsFirst = function() {
    return RemoteAppsProxy.prototype.sortLauncherWithRemoteAppsFirst
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteAppsProxy.prototype.sortLauncherWithRemoteAppsFirst = function() {
    var params_ = new RemoteApps_SortLauncherWithRemoteAppsFirst_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRemoteApps_SortLauncherWithRemoteAppsFirst_Name,
          codec.align(RemoteApps_SortLauncherWithRemoteAppsFirst_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RemoteApps_SortLauncherWithRemoteAppsFirst_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  RemoteAppsPtr.prototype.setPinnedApps = function() {
    return RemoteAppsProxy.prototype.setPinnedApps
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteAppsProxy.prototype.setPinnedApps = function(appIds) {
    var params_ = new RemoteApps_SetPinnedApps_Params();
    params_.appIds = appIds;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kRemoteApps_SetPinnedApps_Name,
          codec.align(RemoteApps_SetPinnedApps_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(RemoteApps_SetPinnedApps_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(RemoteApps_SetPinnedApps_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function RemoteAppsStub(delegate) {
    this.delegate_ = delegate;
  }
  RemoteAppsStub.prototype.addFolder = function(name, addToFront) {
    return this.delegate_ && this.delegate_.addFolder && this.delegate_.addFolder(name, addToFront);
  }
  RemoteAppsStub.prototype.addApp = function(sourceId, name, folderId, iconUrl, addToFront) {
    return this.delegate_ && this.delegate_.addApp && this.delegate_.addApp(sourceId, name, folderId, iconUrl, addToFront);
  }
  RemoteAppsStub.prototype.deleteApp = function(appId) {
    return this.delegate_ && this.delegate_.deleteApp && this.delegate_.deleteApp(appId);
  }
  RemoteAppsStub.prototype.sortLauncherWithRemoteAppsFirst = function() {
    return this.delegate_ && this.delegate_.sortLauncherWithRemoteAppsFirst && this.delegate_.sortLauncherWithRemoteAppsFirst();
  }
  RemoteAppsStub.prototype.setPinnedApps = function(appIds) {
    return this.delegate_ && this.delegate_.setPinnedApps && this.delegate_.setPinnedApps(appIds);
  }

  RemoteAppsStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  RemoteAppsStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRemoteApps_AddFolder_Name:
      var params = reader.decodeStruct(RemoteApps_AddFolder_Params);
      this.addFolder(params.name, params.addToFront).then(function(response) {
        var responseParams =
            new RemoteApps_AddFolder_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kRemoteApps_AddFolder_Name,
            codec.align(RemoteApps_AddFolder_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RemoteApps_AddFolder_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRemoteApps_AddApp_Name:
      var params = reader.decodeStruct(RemoteApps_AddApp_Params);
      this.addApp(params.sourceId, params.name, params.folderId, params.iconUrl, params.addToFront).then(function(response) {
        var responseParams =
            new RemoteApps_AddApp_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kRemoteApps_AddApp_Name,
            codec.align(RemoteApps_AddApp_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RemoteApps_AddApp_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRemoteApps_DeleteApp_Name:
      var params = reader.decodeStruct(RemoteApps_DeleteApp_Params);
      this.deleteApp(params.appId).then(function(response) {
        var responseParams =
            new RemoteApps_DeleteApp_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kRemoteApps_DeleteApp_Name,
            codec.align(RemoteApps_DeleteApp_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RemoteApps_DeleteApp_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRemoteApps_SortLauncherWithRemoteAppsFirst_Name:
      var params = reader.decodeStruct(RemoteApps_SortLauncherWithRemoteAppsFirst_Params);
      this.sortLauncherWithRemoteAppsFirst().then(function(response) {
        var responseParams =
            new RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kRemoteApps_SortLauncherWithRemoteAppsFirst_Name,
            codec.align(RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kRemoteApps_SetPinnedApps_Name:
      var params = reader.decodeStruct(RemoteApps_SetPinnedApps_Params);
      this.setPinnedApps(params.appIds).then(function(response) {
        var responseParams =
            new RemoteApps_SetPinnedApps_ResponseParams();
        responseParams.error = response.error;
        var builder = new codec.MessageV1Builder(
            kRemoteApps_SetPinnedApps_Name,
            codec.align(RemoteApps_SetPinnedApps_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(RemoteApps_SetPinnedApps_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateRemoteAppsRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRemoteApps_AddFolder_Name:
        if (message.expectsResponse())
          paramsClass = RemoteApps_AddFolder_Params;
      break;
      case kRemoteApps_AddApp_Name:
        if (message.expectsResponse())
          paramsClass = RemoteApps_AddApp_Params;
      break;
      case kRemoteApps_DeleteApp_Name:
        if (message.expectsResponse())
          paramsClass = RemoteApps_DeleteApp_Params;
      break;
      case kRemoteApps_SortLauncherWithRemoteAppsFirst_Name:
        if (message.expectsResponse())
          paramsClass = RemoteApps_SortLauncherWithRemoteAppsFirst_Params;
      break;
      case kRemoteApps_SetPinnedApps_Name:
        if (message.expectsResponse())
          paramsClass = RemoteApps_SetPinnedApps_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRemoteAppsResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kRemoteApps_AddFolder_Name:
        if (message.isResponse())
          paramsClass = RemoteApps_AddFolder_ResponseParams;
        break;
      case kRemoteApps_AddApp_Name:
        if (message.isResponse())
          paramsClass = RemoteApps_AddApp_ResponseParams;
        break;
      case kRemoteApps_DeleteApp_Name:
        if (message.isResponse())
          paramsClass = RemoteApps_DeleteApp_ResponseParams;
        break;
      case kRemoteApps_SortLauncherWithRemoteAppsFirst_Name:
        if (message.isResponse())
          paramsClass = RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams;
        break;
      case kRemoteApps_SetPinnedApps_Name:
        if (message.isResponse())
          paramsClass = RemoteApps_SetPinnedApps_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var RemoteApps = {
    name: 'chromeos.remote_apps.mojom.RemoteApps',
    kVersion: 2,
    ptrClass: RemoteAppsPtr,
    proxyClass: RemoteAppsProxy,
    stubClass: RemoteAppsStub,
    validateRequest: validateRemoteAppsRequest,
    validateResponse: validateRemoteAppsResponse,
  };
  RemoteAppsStub.prototype.validator = validateRemoteAppsRequest;
  RemoteAppsProxy.prototype.validator = validateRemoteAppsResponse;
  var kRemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Name = 0;

  function RemoteAppsFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(RemoteAppsFactory,
                                                   handleOrPtrInfo);
  }

  function RemoteAppsFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        RemoteAppsFactory, associatedInterfacePtrInfo);
  }

  RemoteAppsFactoryAssociatedPtr.prototype =
      Object.create(RemoteAppsFactoryPtr.prototype);
  RemoteAppsFactoryAssociatedPtr.prototype.constructor =
      RemoteAppsFactoryAssociatedPtr;

  function RemoteAppsFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  RemoteAppsFactoryPtr.prototype.bindRemoteAppsAndAppLaunchObserver = function() {
    return RemoteAppsFactoryProxy.prototype.bindRemoteAppsAndAppLaunchObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteAppsFactoryProxy.prototype.bindRemoteAppsAndAppLaunchObserver = function(sourceId, remoteApps, observer) {
    var params_ = new RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params();
    params_.sourceId = sourceId;
    params_.remoteApps = remoteApps;
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kRemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Name,
        codec.align(RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params.encodedSize));
    builder.encodeStruct(RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function RemoteAppsFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  RemoteAppsFactoryStub.prototype.bindRemoteAppsAndAppLaunchObserver = function(sourceId, remoteApps, observer) {
    return this.delegate_ && this.delegate_.bindRemoteAppsAndAppLaunchObserver && this.delegate_.bindRemoteAppsAndAppLaunchObserver(sourceId, remoteApps, observer);
  }

  RemoteAppsFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Name:
      var params = reader.decodeStruct(RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params);
      this.bindRemoteAppsAndAppLaunchObserver(params.sourceId, params.remoteApps, params.observer);
      return true;
    default:
      return false;
    }
  };

  RemoteAppsFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateRemoteAppsFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRemoteAppsFactoryResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var RemoteAppsFactory = {
    name: 'chromeos.remote_apps.mojom.RemoteAppsFactory',
    kVersion: 0,
    ptrClass: RemoteAppsFactoryPtr,
    proxyClass: RemoteAppsFactoryProxy,
    stubClass: RemoteAppsFactoryStub,
    validateRequest: validateRemoteAppsFactoryRequest,
    validateResponse: null,
  };
  RemoteAppsFactoryStub.prototype.validator = validateRemoteAppsFactoryRequest;
  RemoteAppsFactoryProxy.prototype.validator = null;
  var kRemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Name = 0;

  function RemoteAppsLacrosBridgePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(RemoteAppsLacrosBridge,
                                                   handleOrPtrInfo);
  }

  function RemoteAppsLacrosBridgeAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        RemoteAppsLacrosBridge, associatedInterfacePtrInfo);
  }

  RemoteAppsLacrosBridgeAssociatedPtr.prototype =
      Object.create(RemoteAppsLacrosBridgePtr.prototype);
  RemoteAppsLacrosBridgeAssociatedPtr.prototype.constructor =
      RemoteAppsLacrosBridgeAssociatedPtr;

  function RemoteAppsLacrosBridgeProxy(receiver) {
    this.receiver_ = receiver;
  }
  RemoteAppsLacrosBridgePtr.prototype.bindRemoteAppsAndAppLaunchObserverForLacros = function() {
    return RemoteAppsLacrosBridgeProxy.prototype.bindRemoteAppsAndAppLaunchObserverForLacros
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteAppsLacrosBridgeProxy.prototype.bindRemoteAppsAndAppLaunchObserverForLacros = function(remoteApps, observer) {
    var params_ = new RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params();
    params_.remoteApps = remoteApps;
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kRemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Name,
        codec.align(RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params.encodedSize));
    builder.encodeStruct(RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function RemoteAppsLacrosBridgeStub(delegate) {
    this.delegate_ = delegate;
  }
  RemoteAppsLacrosBridgeStub.prototype.bindRemoteAppsAndAppLaunchObserverForLacros = function(remoteApps, observer) {
    return this.delegate_ && this.delegate_.bindRemoteAppsAndAppLaunchObserverForLacros && this.delegate_.bindRemoteAppsAndAppLaunchObserverForLacros(remoteApps, observer);
  }

  RemoteAppsLacrosBridgeStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Name:
      var params = reader.decodeStruct(RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params);
      this.bindRemoteAppsAndAppLaunchObserverForLacros(params.remoteApps, params.observer);
      return true;
    default:
      return false;
    }
  };

  RemoteAppsLacrosBridgeStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateRemoteAppsLacrosBridgeRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRemoteAppsLacrosBridgeResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var RemoteAppsLacrosBridge = {
    name: 'chromeos.remote_apps.mojom.RemoteAppsLacrosBridge',
    kVersion: 0,
    ptrClass: RemoteAppsLacrosBridgePtr,
    proxyClass: RemoteAppsLacrosBridgeProxy,
    stubClass: RemoteAppsLacrosBridgeStub,
    validateRequest: validateRemoteAppsLacrosBridgeRequest,
    validateResponse: null,
  };
  RemoteAppsLacrosBridgeStub.prototype.validator = validateRemoteAppsLacrosBridgeRequest;
  RemoteAppsLacrosBridgeProxy.prototype.validator = null;
  var kRemoteAppLaunchObserver_OnRemoteAppLaunched_Name = 0;

  function RemoteAppLaunchObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(RemoteAppLaunchObserver,
                                                   handleOrPtrInfo);
  }

  function RemoteAppLaunchObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        RemoteAppLaunchObserver, associatedInterfacePtrInfo);
  }

  RemoteAppLaunchObserverAssociatedPtr.prototype =
      Object.create(RemoteAppLaunchObserverPtr.prototype);
  RemoteAppLaunchObserverAssociatedPtr.prototype.constructor =
      RemoteAppLaunchObserverAssociatedPtr;

  function RemoteAppLaunchObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  RemoteAppLaunchObserverPtr.prototype.onRemoteAppLaunched = function() {
    return RemoteAppLaunchObserverProxy.prototype.onRemoteAppLaunched
        .apply(this.ptr.getProxy(), arguments);
  };

  RemoteAppLaunchObserverProxy.prototype.onRemoteAppLaunched = function(appId, sourceId) {
    var params_ = new RemoteAppLaunchObserver_OnRemoteAppLaunched_Params();
    params_.appId = appId;
    params_.sourceId = sourceId;
    var builder = new codec.MessageV0Builder(
        kRemoteAppLaunchObserver_OnRemoteAppLaunched_Name,
        codec.align(RemoteAppLaunchObserver_OnRemoteAppLaunched_Params.encodedSize));
    builder.encodeStruct(RemoteAppLaunchObserver_OnRemoteAppLaunched_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function RemoteAppLaunchObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  RemoteAppLaunchObserverStub.prototype.onRemoteAppLaunched = function(appId, sourceId) {
    return this.delegate_ && this.delegate_.onRemoteAppLaunched && this.delegate_.onRemoteAppLaunched(appId, sourceId);
  }

  RemoteAppLaunchObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kRemoteAppLaunchObserver_OnRemoteAppLaunched_Name:
      var params = reader.decodeStruct(RemoteAppLaunchObserver_OnRemoteAppLaunched_Params);
      this.onRemoteAppLaunched(params.appId, params.sourceId);
      return true;
    default:
      return false;
    }
  };

  RemoteAppLaunchObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateRemoteAppLaunchObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kRemoteAppLaunchObserver_OnRemoteAppLaunched_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = RemoteAppLaunchObserver_OnRemoteAppLaunched_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateRemoteAppLaunchObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var RemoteAppLaunchObserver = {
    name: 'chromeos.remote_apps.mojom.RemoteAppLaunchObserver',
    kVersion: 0,
    ptrClass: RemoteAppLaunchObserverPtr,
    proxyClass: RemoteAppLaunchObserverProxy,
    stubClass: RemoteAppLaunchObserverStub,
    validateRequest: validateRemoteAppLaunchObserverRequest,
    validateResponse: null,
  };
  RemoteAppLaunchObserverStub.prototype.validator = validateRemoteAppLaunchObserverRequest;
  RemoteAppLaunchObserverProxy.prototype.validator = null;
  exports.AddFolderResult = AddFolderResult;
  exports.AddAppResult = AddAppResult;
  exports.RemoteApps = RemoteApps;
  exports.RemoteAppsPtr = RemoteAppsPtr;
  exports.RemoteAppsAssociatedPtr = RemoteAppsAssociatedPtr;
  exports.RemoteAppsFactory = RemoteAppsFactory;
  exports.RemoteAppsFactoryPtr = RemoteAppsFactoryPtr;
  exports.RemoteAppsFactoryAssociatedPtr = RemoteAppsFactoryAssociatedPtr;
  exports.RemoteAppsLacrosBridge = RemoteAppsLacrosBridge;
  exports.RemoteAppsLacrosBridgePtr = RemoteAppsLacrosBridgePtr;
  exports.RemoteAppsLacrosBridgeAssociatedPtr = RemoteAppsLacrosBridgeAssociatedPtr;
  exports.RemoteAppLaunchObserver = RemoteAppLaunchObserver;
  exports.RemoteAppLaunchObserverPtr = RemoteAppLaunchObserverPtr;
  exports.RemoteAppLaunchObserverAssociatedPtr = RemoteAppLaunchObserverAssociatedPtr;
})();