// chromeos/components/remote_apps/mojom/remote_apps.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RemoteAppsPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.remote_apps.mojom.RemoteApps', scope);
  }
}

/** @interface */
export class RemoteAppsInterface {
  
  /**
   * @param { !string } name
   * @param { !boolean } addToFront
   * @return {!Promise<{
        result: !AddFolderResult,
   *  }>}
   */

  addFolder(name, addToFront) {}
  
  /**
   * @param { !string } sourceId
   * @param { !string } name
   * @param { !string } folderId
   * @param { !url_mojom_Url } iconUrl
   * @param { !boolean } addToFront
   * @return {!Promise<{
        result: !AddAppResult,
   *  }>}
   */

  addApp(sourceId, name, folderId, iconUrl, addToFront) {}
  
  /**
   * @param { !string } appId
   * @return {!Promise<{
        error: ?string,
   *  }>}
   */

  deleteApp(appId) {}
  
  /**
   * @return {!Promise<{
        error: ?string,
   *  }>}
   */

  sortLauncherWithRemoteAppsFirst() {}
  
  /**
   * @param { !Array<!string> } appIds
   * @return {!Promise<{
        error: ?string,
   *  }>}
   */

  setPinnedApps(appIds) {}
}

/**
 * @implements { RemoteAppsInterface }
 */
export class RemoteAppsRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RemoteAppsPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RemoteAppsPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RemoteAppsPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } name
   * @param { !boolean } addToFront
   * @return {!Promise<{
        result: !AddFolderResult,
   *  }>}
   */

  addFolder(
      name,
      addToFront) {
    return this.proxy.sendMessage(
        0,
        RemoteApps_AddFolder_ParamsSpec.$,
        RemoteApps_AddFolder_ResponseParamsSpec.$,
        [
          name,
          addToFront
        ],
        false);
  }

  
  /**
   * @param { !string } sourceId
   * @param { !string } name
   * @param { !string } folderId
   * @param { !url_mojom_Url } iconUrl
   * @param { !boolean } addToFront
   * @return {!Promise<{
        result: !AddAppResult,
   *  }>}
   */

  addApp(
      sourceId,
      name,
      folderId,
      iconUrl,
      addToFront) {
    return this.proxy.sendMessage(
        1,
        RemoteApps_AddApp_ParamsSpec.$,
        RemoteApps_AddApp_ResponseParamsSpec.$,
        [
          sourceId,
          name,
          folderId,
          iconUrl,
          addToFront
        ],
        false);
  }

  
  /**
   * @param { !string } appId
   * @return {!Promise<{
        error: ?string,
   *  }>}
   */

  deleteApp(
      appId) {
    return this.proxy.sendMessage(
        2,
        RemoteApps_DeleteApp_ParamsSpec.$,
        RemoteApps_DeleteApp_ResponseParamsSpec.$,
        [
          appId
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: ?string,
   *  }>}
   */

  sortLauncherWithRemoteAppsFirst() {
    return this.proxy.sendMessage(
        3,
        RemoteApps_SortLauncherWithRemoteAppsFirst_ParamsSpec.$,
        RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } appIds
   * @return {!Promise<{
        error: ?string,
   *  }>}
   */

  setPinnedApps(
      appIds) {
    return this.proxy.sendMessage(
        4,
        RemoteApps_SetPinnedApps_ParamsSpec.$,
        RemoteApps_SetPinnedApps_ResponseParamsSpec.$,
        [
          appIds
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RemoteApps
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RemoteAppsReceiver {
  /**
   * @param {!RemoteAppsInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RemoteAppsRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RemoteAppsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteAppsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RemoteApps_AddFolder_ParamsSpec.$,
        RemoteApps_AddFolder_ResponseParamsSpec.$,
        impl.addFolder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        RemoteApps_AddApp_ParamsSpec.$,
        RemoteApps_AddApp_ResponseParamsSpec.$,
        impl.addApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        RemoteApps_DeleteApp_ParamsSpec.$,
        RemoteApps_DeleteApp_ResponseParamsSpec.$,
        impl.deleteApp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        RemoteApps_SortLauncherWithRemoteAppsFirst_ParamsSpec.$,
        RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParamsSpec.$,
        impl.sortLauncherWithRemoteAppsFirst.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        RemoteApps_SetPinnedApps_ParamsSpec.$,
        RemoteApps_SetPinnedApps_ResponseParamsSpec.$,
        impl.setPinnedApps.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RemoteApps {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.remote_apps.mojom.RemoteApps";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RemoteAppsRemote}
   */
  static getRemote() {
    let remote = new RemoteAppsRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RemoteApps
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RemoteAppsCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RemoteAppsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteAppsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addFolder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RemoteApps_AddFolder_ParamsSpec.$,
        RemoteApps_AddFolder_ResponseParamsSpec.$,
        this.addFolder.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        RemoteApps_AddApp_ParamsSpec.$,
        RemoteApps_AddApp_ResponseParamsSpec.$,
        this.addApp.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteApp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        RemoteApps_DeleteApp_ParamsSpec.$,
        RemoteApps_DeleteApp_ResponseParamsSpec.$,
        this.deleteApp.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sortLauncherWithRemoteAppsFirst =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        RemoteApps_SortLauncherWithRemoteAppsFirst_ParamsSpec.$,
        RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParamsSpec.$,
        this.sortLauncherWithRemoteAppsFirst.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPinnedApps =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        RemoteApps_SetPinnedApps_ParamsSpec.$,
        RemoteApps_SetPinnedApps_ResponseParamsSpec.$,
        this.setPinnedApps.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RemoteAppsFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.remote_apps.mojom.RemoteAppsFactory', scope);
  }
}

/** @interface */
export class RemoteAppsFactoryInterface {
  
  /**
   * @param { !string } sourceId
   * @param { !RemoteAppsPendingReceiver } remoteApps
   * @param { !RemoteAppLaunchObserverRemote } observer
   */

  bindRemoteAppsAndAppLaunchObserver(sourceId, remoteApps, observer) {}
}

/**
 * @implements { RemoteAppsFactoryInterface }
 */
export class RemoteAppsFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RemoteAppsFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RemoteAppsFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RemoteAppsFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } sourceId
   * @param { !RemoteAppsPendingReceiver } remoteApps
   * @param { !RemoteAppLaunchObserverRemote } observer
   */

  bindRemoteAppsAndAppLaunchObserver(
      sourceId,
      remoteApps,
      observer) {
    this.proxy.sendMessage(
        0,
        RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_ParamsSpec.$,
        null,
        [
          sourceId,
          remoteApps,
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RemoteAppsFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RemoteAppsFactoryReceiver {
  /**
   * @param {!RemoteAppsFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RemoteAppsFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RemoteAppsFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteAppsFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_ParamsSpec.$,
        null,
        impl.bindRemoteAppsAndAppLaunchObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RemoteAppsFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.remote_apps.mojom.RemoteAppsFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RemoteAppsFactoryRemote}
   */
  static getRemote() {
    let remote = new RemoteAppsFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RemoteAppsFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RemoteAppsFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RemoteAppsFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteAppsFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindRemoteAppsAndAppLaunchObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_ParamsSpec.$,
        null,
        this.bindRemoteAppsAndAppLaunchObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RemoteAppsLacrosBridgePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.remote_apps.mojom.RemoteAppsLacrosBridge', scope);
  }
}

/** @interface */
export class RemoteAppsLacrosBridgeInterface {
  
  /**
   * @param { !RemoteAppsPendingReceiver } remoteApps
   * @param { !RemoteAppLaunchObserverRemote } observer
   */

  bindRemoteAppsAndAppLaunchObserverForLacros(remoteApps, observer) {}
}

/**
 * @implements { RemoteAppsLacrosBridgeInterface }
 */
export class RemoteAppsLacrosBridgeRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RemoteAppsLacrosBridgePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RemoteAppsLacrosBridgePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RemoteAppsLacrosBridgePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !RemoteAppsPendingReceiver } remoteApps
   * @param { !RemoteAppLaunchObserverRemote } observer
   */

  bindRemoteAppsAndAppLaunchObserverForLacros(
      remoteApps,
      observer) {
    this.proxy.sendMessage(
        0,
        RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_ParamsSpec.$,
        null,
        [
          remoteApps,
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RemoteAppsLacrosBridge
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RemoteAppsLacrosBridgeReceiver {
  /**
   * @param {!RemoteAppsLacrosBridgeInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RemoteAppsLacrosBridgeRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RemoteAppsLacrosBridgeRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteAppsLacrosBridgeRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_ParamsSpec.$,
        null,
        impl.bindRemoteAppsAndAppLaunchObserverForLacros.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RemoteAppsLacrosBridge {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.remote_apps.mojom.RemoteAppsLacrosBridge";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RemoteAppsLacrosBridgeRemote}
   */
  static getRemote() {
    let remote = new RemoteAppsLacrosBridgeRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RemoteAppsLacrosBridge
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RemoteAppsLacrosBridgeCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RemoteAppsLacrosBridgeRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteAppsLacrosBridgeRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindRemoteAppsAndAppLaunchObserverForLacros =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_ParamsSpec.$,
        null,
        this.bindRemoteAppsAndAppLaunchObserverForLacros.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RemoteAppLaunchObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.remote_apps.mojom.RemoteAppLaunchObserver', scope);
  }
}

/** @interface */
export class RemoteAppLaunchObserverInterface {
  
  /**
   * @param { !string } appId
   * @param { !string } sourceId
   */

  onRemoteAppLaunched(appId, sourceId) {}
}

/**
 * @implements { RemoteAppLaunchObserverInterface }
 */
export class RemoteAppLaunchObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RemoteAppLaunchObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RemoteAppLaunchObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RemoteAppLaunchObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } appId
   * @param { !string } sourceId
   */

  onRemoteAppLaunched(
      appId,
      sourceId) {
    this.proxy.sendMessage(
        0,
        RemoteAppLaunchObserver_OnRemoteAppLaunched_ParamsSpec.$,
        null,
        [
          appId,
          sourceId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RemoteAppLaunchObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RemoteAppLaunchObserverReceiver {
  /**
   * @param {!RemoteAppLaunchObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RemoteAppLaunchObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RemoteAppLaunchObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteAppLaunchObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RemoteAppLaunchObserver_OnRemoteAppLaunched_ParamsSpec.$,
        null,
        impl.onRemoteAppLaunched.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RemoteAppLaunchObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.remote_apps.mojom.RemoteAppLaunchObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RemoteAppLaunchObserverRemote}
   */
  static getRemote() {
    let remote = new RemoteAppLaunchObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RemoteAppLaunchObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RemoteAppLaunchObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RemoteAppLaunchObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RemoteAppLaunchObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRemoteAppLaunched =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RemoteAppLaunchObserver_OnRemoteAppLaunched_ParamsSpec.$,
        null,
        this.onRemoteAppLaunched.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteApps_AddFolder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteApps_AddFolder_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteApps_AddApp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteApps_AddApp_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteApps_DeleteApp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteApps_DeleteApp_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteApps_SortLauncherWithRemoteAppsFirst_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteApps_SetPinnedApps_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteApps_SetPinnedApps_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemoteAppLaunchObserver_OnRemoteAppLaunched_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AddFolderResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AddAppResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    RemoteApps_AddFolder_ParamsSpec.$,
    'RemoteApps_AddFolder_Params',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'addToFront', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteApps_AddFolder_Params {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !boolean } */
    this.addToFront;
  }
}



mojo.internal.Struct(
    RemoteApps_AddFolder_ResponseParamsSpec.$,
    'RemoteApps_AddFolder_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        AddFolderResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteApps_AddFolder_ResponseParams {
  constructor() {
    /** @type { !AddFolderResult } */
    this.result;
  }
}



mojo.internal.Struct(
    RemoteApps_AddApp_ParamsSpec.$,
    'RemoteApps_AddApp_Params',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'folderId', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'iconUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'addToFront', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class RemoteApps_AddApp_Params {
  constructor() {
    /** @type { !string } */
    this.sourceId;
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.folderId;
    /** @type { !url_mojom_Url } */
    this.iconUrl;
    /** @type { !boolean } */
    this.addToFront;
  }
}



mojo.internal.Struct(
    RemoteApps_AddApp_ResponseParamsSpec.$,
    'RemoteApps_AddApp_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        AddAppResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteApps_AddApp_ResponseParams {
  constructor() {
    /** @type { !AddAppResult } */
    this.result;
  }
}



mojo.internal.Struct(
    RemoteApps_DeleteApp_ParamsSpec.$,
    'RemoteApps_DeleteApp_Params',
    [
      mojo.internal.StructField(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteApps_DeleteApp_Params {
  constructor() {
    /** @type { !string } */
    this.appId;
  }
}



mojo.internal.Struct(
    RemoteApps_DeleteApp_ResponseParamsSpec.$,
    'RemoteApps_DeleteApp_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteApps_DeleteApp_ResponseParams {
  constructor() {
    /** @type { (string|undefined) } */
    this.error;
  }
}



mojo.internal.Struct(
    RemoteApps_SortLauncherWithRemoteAppsFirst_ParamsSpec.$,
    'RemoteApps_SortLauncherWithRemoteAppsFirst_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class RemoteApps_SortLauncherWithRemoteAppsFirst_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParamsSpec.$,
    'RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteApps_SortLauncherWithRemoteAppsFirst_ResponseParams {
  constructor() {
    /** @type { (string|undefined) } */
    this.error;
  }
}



mojo.internal.Struct(
    RemoteApps_SetPinnedApps_ParamsSpec.$,
    'RemoteApps_SetPinnedApps_Params',
    [
      mojo.internal.StructField(
        'appIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteApps_SetPinnedApps_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.appIds;
  }
}



mojo.internal.Struct(
    RemoteApps_SetPinnedApps_ResponseParamsSpec.$,
    'RemoteApps_SetPinnedApps_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RemoteApps_SetPinnedApps_ResponseParams {
  constructor() {
    /** @type { (string|undefined) } */
    this.error;
  }
}



mojo.internal.Struct(
    RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_ParamsSpec.$,
    'RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteApps', 8,
        0,
        mojo.internal.InterfaceRequest(RemoteAppsPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceProxy(RemoteAppLaunchObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class RemoteAppsFactory_BindRemoteAppsAndAppLaunchObserver_Params {
  constructor() {
    /** @type { !string } */
    this.sourceId;
    /** @type { !RemoteAppsPendingReceiver } */
    this.remoteApps;
    /** @type { !RemoteAppLaunchObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_ParamsSpec.$,
    'RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params',
    [
      mojo.internal.StructField(
        'remoteApps', 0,
        0,
        mojo.internal.InterfaceRequest(RemoteAppsPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 4,
        0,
        mojo.internal.InterfaceProxy(RemoteAppLaunchObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteAppsLacrosBridge_BindRemoteAppsAndAppLaunchObserverForLacros_Params {
  constructor() {
    /** @type { !RemoteAppsPendingReceiver } */
    this.remoteApps;
    /** @type { !RemoteAppLaunchObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    RemoteAppLaunchObserver_OnRemoteAppLaunched_ParamsSpec.$,
    'RemoteAppLaunchObserver_OnRemoteAppLaunched_Params',
    [
      mojo.internal.StructField(
        'appId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RemoteAppLaunchObserver_OnRemoteAppLaunched_Params {
  constructor() {
    /** @type { !string } */
    this.appId;
    /** @type { !string } */
    this.sourceId;
  }
}

mojo.internal.Union(
    AddFolderResultSpec.$, 'AddFolderResult',
    {
      'folderId': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'error': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   folderId: (!string|undefined),
 *   error: (!string|undefined),
 * } }
 */
export const AddFolderResult = {};
mojo.internal.Union(
    AddAppResultSpec.$, 'AddAppResult',
    {
      'appId': {
        'ordinal': 0,
        'type': mojo.internal.String,
      },
      'error': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   appId: (!string|undefined),
 *   error: (!string|undefined),
 * } }
 */
export const AddAppResult = {};
