// chromeos/services/machine_learning/public/mojom/document_scanner.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('chromeos.machineLearning.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.DocumentScannerResultStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.DocumentScannerResultStatus = {
  
  OK: 0,
  ERROR: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.machineLearning.mojom.DocumentScannerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.machineLearning.mojom.DocumentScanner.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.machineLearning.mojom.DocumentScannerInterface }
 */
chromeos.machineLearning.mojom.DocumentScannerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.machineLearning.mojom.DocumentScannerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.machineLearning.mojom.DocumentScannerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.machineLearning.mojom.DocumentScannerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.ReadOnlySharedMemoryRegion } nv12Image
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.DetectCornersResult,
   *  }>}
   */

  detectCornersFromNV12Image(
      nv12Image) {
    return this.proxy.sendMessage(
        0,
        chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromNV12Image_ParamsSpec.$,
        chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromNV12Image_ResponseParamsSpec.$,
        [
          nv12Image
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.ReadOnlySharedMemoryRegion } jpegImage
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.DetectCornersResult,
   *  }>}
   */

  detectCornersFromJPEGImage(
      jpegImage) {
    return this.proxy.sendMessage(
        1,
        chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromJPEGImage_ParamsSpec.$,
        chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromJPEGImage_ResponseParamsSpec.$,
        [
          jpegImage
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.ReadOnlySharedMemoryRegion } jpegImage
   * @param { !Array<!gfx.mojom.PointF> } corners
   * @param { !chromeos.machineLearning.mojom.Rotation } rotation
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.DoPostProcessingResult,
   *  }>}
   */

  doPostProcessing(
      jpegImage,
      corners,
      rotation) {
    return this.proxy.sendMessage(
        2,
        chromeos.machineLearning.mojom.DocumentScanner_DoPostProcessing_ParamsSpec.$,
        chromeos.machineLearning.mojom.DocumentScanner_DoPostProcessing_ResponseParamsSpec.$,
        [
          jpegImage,
          corners,
          rotation
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DocumentScanner
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.machineLearning.mojom.DocumentScannerReceiver = class {
  /**
   * @param {!chromeos.machineLearning.mojom.DocumentScannerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.machineLearning.mojom.DocumentScannerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.machineLearning.mojom.DocumentScannerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.DocumentScannerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromNV12Image_ParamsSpec.$,
        chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromNV12Image_ResponseParamsSpec.$,
        impl.detectCornersFromNV12Image.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromJPEGImage_ParamsSpec.$,
        chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromJPEGImage_ResponseParamsSpec.$,
        impl.detectCornersFromJPEGImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        chromeos.machineLearning.mojom.DocumentScanner_DoPostProcessing_ParamsSpec.$,
        chromeos.machineLearning.mojom.DocumentScanner_DoPostProcessing_ResponseParamsSpec.$,
        impl.doPostProcessing.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.machineLearning.mojom.DocumentScanner = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.DocumentScanner";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.machineLearning.mojom.DocumentScannerRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.machineLearning.mojom.DocumentScannerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DocumentScanner
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.machineLearning.mojom.DocumentScannerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.machineLearning.mojom.DocumentScannerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.DocumentScannerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detectCornersFromNV12Image =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromNV12Image_ParamsSpec.$,
        chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromNV12Image_ResponseParamsSpec.$,
        this.detectCornersFromNV12Image.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detectCornersFromJPEGImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromJPEGImage_ParamsSpec.$,
        chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromJPEGImage_ResponseParamsSpec.$,
        this.detectCornersFromJPEGImage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.doPostProcessing =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        chromeos.machineLearning.mojom.DocumentScanner_DoPostProcessing_ParamsSpec.$,
        chromeos.machineLearning.mojom.DocumentScanner_DoPostProcessing_ResponseParamsSpec.$,
        this.doPostProcessing.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.DocumentScannerConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.DetectCornersResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.DoPostProcessingResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromNV12Image_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromNV12Image_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromJPEGImage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromJPEGImage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.DocumentScanner_DoPostProcessing_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.DocumentScanner_DoPostProcessing_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.machineLearning.mojom.DocumentScannerConfigSpec.$,
    'DocumentScannerConfig',
    [
      mojo.internal.StructField(
        'deprecatedLibraryDlcPath', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'libraryDlcPath', 8,
        0,
        mojoBase.mojom.FilePathSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],[1, 24],]);





/** @record */
chromeos.machineLearning.mojom.DocumentScannerConfig = class {
  constructor() {
    /** @export { !string } */
    this.deprecatedLibraryDlcPath;
    /** @export { (mojoBase.mojom.FilePath|undefined) } */
    this.libraryDlcPath;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.DetectCornersResultSpec.$,
    'DetectCornersResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        chromeos.machineLearning.mojom.DocumentScannerResultStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'corners', 8,
        0,
        mojo.internal.Array(gfx.mojom.PointFSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.DetectCornersResult = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.DocumentScannerResultStatus } */
    this.status;
    /** @export { !Array<!gfx.mojom.PointF> } */
    this.corners;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.DoPostProcessingResultSpec.$,
    'DoPostProcessingResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        chromeos.machineLearning.mojom.DocumentScannerResultStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'processedJpegImage', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.DoPostProcessingResult = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.DocumentScannerResultStatus } */
    this.status;
    /** @export { !Array<!number> } */
    this.processedJpegImage;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromNV12Image_ParamsSpec.$,
    'DocumentScanner_DetectCornersFromNV12Image_Params',
    [
      mojo.internal.StructField(
        'nv12Image', 0,
        0,
        mojoBase.mojom.ReadOnlySharedMemoryRegionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromNV12Image_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlySharedMemoryRegion } */
    this.nv12Image;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromNV12Image_ResponseParamsSpec.$,
    'DocumentScanner_DetectCornersFromNV12Image_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.DetectCornersResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromNV12Image_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.DetectCornersResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromJPEGImage_ParamsSpec.$,
    'DocumentScanner_DetectCornersFromJPEGImage_Params',
    [
      mojo.internal.StructField(
        'jpegImage', 0,
        0,
        mojoBase.mojom.ReadOnlySharedMemoryRegionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromJPEGImage_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlySharedMemoryRegion } */
    this.jpegImage;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromJPEGImage_ResponseParamsSpec.$,
    'DocumentScanner_DetectCornersFromJPEGImage_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.DetectCornersResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.DocumentScanner_DetectCornersFromJPEGImage_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.DetectCornersResult } */
    this.result;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.DocumentScanner_DoPostProcessing_ParamsSpec.$,
    'DocumentScanner_DoPostProcessing_Params',
    [
      mojo.internal.StructField(
        'jpegImage', 0,
        0,
        mojoBase.mojom.ReadOnlySharedMemoryRegionSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'corners', 8,
        0,
        mojo.internal.Array(gfx.mojom.PointFSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rotation', 16,
        0,
        chromeos.machineLearning.mojom.RotationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[1, 32],]);





/** @record */
chromeos.machineLearning.mojom.DocumentScanner_DoPostProcessing_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlySharedMemoryRegion } */
    this.jpegImage;
    /** @export { !Array<!gfx.mojom.PointF> } */
    this.corners;
    /** @export { !chromeos.machineLearning.mojom.Rotation } */
    this.rotation;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.DocumentScanner_DoPostProcessing_ResponseParamsSpec.$,
    'DocumentScanner_DoPostProcessing_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.DoPostProcessingResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.DocumentScanner_DoPostProcessing_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.DoPostProcessingResult } */
    this.result;
  }
};

