// chromeos/services/machine_learning/public/mojom/document_scanner.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/services/machine_learning/public/mojom/document_scanner.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  var document_scanner_param_types$ =
      mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'chromeos/services/machine_learning/public/mojom/document_scanner_param_types.mojom', 'document_scanner_param_types.mojom.js');
  }
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var shared_memory$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/shared_memory.mojom', '../../../../../mojo/public/mojom/base/shared_memory.mojom.js');
  }


  var DocumentScannerResultStatus = {};
  DocumentScannerResultStatus.OK = 0;
  DocumentScannerResultStatus.ERROR = 1;
  DocumentScannerResultStatus.MIN_VALUE = 0;
  DocumentScannerResultStatus.MAX_VALUE = 1;

  DocumentScannerResultStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  DocumentScannerResultStatus.toKnownEnumValue = function(value) {
    return value;
  };

  DocumentScannerResultStatus.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function DocumentScannerConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DocumentScannerConfig.prototype.initDefaults_ = function() {
    this.deprecatedLibraryDlcPath = null;
    this.libraryDlcPath = null;
  };
  DocumentScannerConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DocumentScannerConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 1, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentScannerConfig.deprecatedLibraryDlcPath
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // version check DocumentScannerConfig.libraryDlcPath
    if (!messageValidator.isFieldInStructVersion(offset, 1))
      return validator.validationError.NONE;
    // validate DocumentScannerConfig.libraryDlcPath
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file_path$.FilePath, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DocumentScannerConfig.encodedSize = codec.kStructHeaderSize + 16;

  DocumentScannerConfig.decode = function(decoder) {
    var packed;
    var val = new DocumentScannerConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deprecatedLibraryDlcPath =
        decoder.decodeStruct(codec.String);
    if (version >= 1) {
      val.libraryDlcPath =
          decoder.decodeStructPointer(file_path$.FilePath);
    } else {
      val.libraryDlcPath = null;
    }
    return val;
  };

  DocumentScannerConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DocumentScannerConfig.encodedSize);
    encoder.writeUint32(1);
    encoder.encodeStruct(codec.String, val.deprecatedLibraryDlcPath);
    encoder.encodeStructPointer(file_path$.FilePath, val.libraryDlcPath);
  };
  function DetectCornersResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DetectCornersResult.prototype.initDefaults_ = function() {
    this.status = 0;
    this.corners = null;
  };
  DetectCornersResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DetectCornersResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DetectCornersResult.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, DocumentScannerResultStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DetectCornersResult.corners
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(geometry$.PointF), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DetectCornersResult.encodedSize = codec.kStructHeaderSize + 16;

  DetectCornersResult.decode = function(decoder) {
    var packed;
    var val = new DetectCornersResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(DocumentScannerResultStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.corners =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.PointF));
    return val;
  };

  DetectCornersResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DetectCornersResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.PointF), val.corners);
  };
  function DoPostProcessingResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DoPostProcessingResult.prototype.initDefaults_ = function() {
    this.status = 0;
    this.processedJpegImage = null;
  };
  DoPostProcessingResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DoPostProcessingResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DoPostProcessingResult.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, DocumentScannerResultStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DoPostProcessingResult.processedJpegImage
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DoPostProcessingResult.encodedSize = codec.kStructHeaderSize + 16;

  DoPostProcessingResult.decode = function(decoder) {
    var packed;
    var val = new DoPostProcessingResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(DocumentScannerResultStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.processedJpegImage =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  DoPostProcessingResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DoPostProcessingResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint8, val.processedJpegImage);
  };
  function DocumentScanner_DetectCornersFromNV12Image_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DocumentScanner_DetectCornersFromNV12Image_Params.prototype.initDefaults_ = function() {
    this.nv12Image = null;
  };
  DocumentScanner_DetectCornersFromNV12Image_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DocumentScanner_DetectCornersFromNV12Image_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentScanner_DetectCornersFromNV12Image_Params.nv12Image
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_memory$.ReadOnlySharedMemoryRegion, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DocumentScanner_DetectCornersFromNV12Image_Params.encodedSize = codec.kStructHeaderSize + 8;

  DocumentScanner_DetectCornersFromNV12Image_Params.decode = function(decoder) {
    var packed;
    var val = new DocumentScanner_DetectCornersFromNV12Image_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.nv12Image =
        decoder.decodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion);
    return val;
  };

  DocumentScanner_DetectCornersFromNV12Image_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DocumentScanner_DetectCornersFromNV12Image_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion, val.nv12Image);
  };
  function DocumentScanner_DetectCornersFromNV12Image_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DocumentScanner_DetectCornersFromNV12Image_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  DocumentScanner_DetectCornersFromNV12Image_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DocumentScanner_DetectCornersFromNV12Image_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentScanner_DetectCornersFromNV12Image_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, DetectCornersResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DocumentScanner_DetectCornersFromNV12Image_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  DocumentScanner_DetectCornersFromNV12Image_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DocumentScanner_DetectCornersFromNV12Image_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(DetectCornersResult);
    return val;
  };

  DocumentScanner_DetectCornersFromNV12Image_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DocumentScanner_DetectCornersFromNV12Image_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(DetectCornersResult, val.result);
  };
  function DocumentScanner_DetectCornersFromJPEGImage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DocumentScanner_DetectCornersFromJPEGImage_Params.prototype.initDefaults_ = function() {
    this.jpegImage = null;
  };
  DocumentScanner_DetectCornersFromJPEGImage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DocumentScanner_DetectCornersFromJPEGImage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentScanner_DetectCornersFromJPEGImage_Params.jpegImage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_memory$.ReadOnlySharedMemoryRegion, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DocumentScanner_DetectCornersFromJPEGImage_Params.encodedSize = codec.kStructHeaderSize + 8;

  DocumentScanner_DetectCornersFromJPEGImage_Params.decode = function(decoder) {
    var packed;
    var val = new DocumentScanner_DetectCornersFromJPEGImage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.jpegImage =
        decoder.decodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion);
    return val;
  };

  DocumentScanner_DetectCornersFromJPEGImage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DocumentScanner_DetectCornersFromJPEGImage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion, val.jpegImage);
  };
  function DocumentScanner_DetectCornersFromJPEGImage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DocumentScanner_DetectCornersFromJPEGImage_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  DocumentScanner_DetectCornersFromJPEGImage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DocumentScanner_DetectCornersFromJPEGImage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentScanner_DetectCornersFromJPEGImage_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, DetectCornersResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DocumentScanner_DetectCornersFromJPEGImage_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  DocumentScanner_DetectCornersFromJPEGImage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DocumentScanner_DetectCornersFromJPEGImage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(DetectCornersResult);
    return val;
  };

  DocumentScanner_DetectCornersFromJPEGImage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DocumentScanner_DetectCornersFromJPEGImage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(DetectCornersResult, val.result);
  };
  function DocumentScanner_DoPostProcessing_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DocumentScanner_DoPostProcessing_Params.prototype.initDefaults_ = function() {
    this.jpegImage = null;
    this.corners = null;
    this.rotation = 0;
  };
  DocumentScanner_DoPostProcessing_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DocumentScanner_DoPostProcessing_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 1, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentScanner_DoPostProcessing_Params.jpegImage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, shared_memory$.ReadOnlySharedMemoryRegion, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentScanner_DoPostProcessing_Params.corners
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(geometry$.PointF), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // version check DocumentScanner_DoPostProcessing_Params.rotation
    if (!messageValidator.isFieldInStructVersion(offset, 1))
      return validator.validationError.NONE;
    // validate DocumentScanner_DoPostProcessing_Params.rotation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, document_scanner_param_types$.Rotation);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DocumentScanner_DoPostProcessing_Params.encodedSize = codec.kStructHeaderSize + 24;

  DocumentScanner_DoPostProcessing_Params.decode = function(decoder) {
    var packed;
    var val = new DocumentScanner_DoPostProcessing_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.jpegImage =
        decoder.decodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion);
    val.corners =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.PointF));
    if (version >= 1) {
      val.rotation =
          decoder.decodeStruct(new codec.Enum(document_scanner_param_types$.Rotation));
    } else {
      val.rotation = null;
    }
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DocumentScanner_DoPostProcessing_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DocumentScanner_DoPostProcessing_Params.encodedSize);
    encoder.writeUint32(1);
    encoder.encodeStructPointer(shared_memory$.ReadOnlySharedMemoryRegion, val.jpegImage);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.PointF), val.corners);
    encoder.encodeStruct(codec.Int32, val.rotation);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DocumentScanner_DoPostProcessing_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DocumentScanner_DoPostProcessing_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  DocumentScanner_DoPostProcessing_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DocumentScanner_DoPostProcessing_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentScanner_DoPostProcessing_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, DoPostProcessingResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DocumentScanner_DoPostProcessing_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  DocumentScanner_DoPostProcessing_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DocumentScanner_DoPostProcessing_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(DoPostProcessingResult);
    return val;
  };

  DocumentScanner_DoPostProcessing_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DocumentScanner_DoPostProcessing_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(DoPostProcessingResult, val.result);
  };
  var kDocumentScanner_DetectCornersFromNV12Image_Name = 0;
  var kDocumentScanner_DetectCornersFromJPEGImage_Name = 1;
  var kDocumentScanner_DoPostProcessing_Name = 2;

  function DocumentScannerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(DocumentScanner,
                                                   handleOrPtrInfo);
  }

  function DocumentScannerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        DocumentScanner, associatedInterfacePtrInfo);
  }

  DocumentScannerAssociatedPtr.prototype =
      Object.create(DocumentScannerPtr.prototype);
  DocumentScannerAssociatedPtr.prototype.constructor =
      DocumentScannerAssociatedPtr;

  function DocumentScannerProxy(receiver) {
    this.receiver_ = receiver;
  }
  DocumentScannerPtr.prototype.detectCornersFromNV12Image = function() {
    return DocumentScannerProxy.prototype.detectCornersFromNV12Image
        .apply(this.ptr.getProxy(), arguments);
  };

  DocumentScannerProxy.prototype.detectCornersFromNV12Image = function(nv12Image) {
    var params_ = new DocumentScanner_DetectCornersFromNV12Image_Params();
    params_.nv12Image = nv12Image;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDocumentScanner_DetectCornersFromNV12Image_Name,
          codec.align(DocumentScanner_DetectCornersFromNV12Image_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DocumentScanner_DetectCornersFromNV12Image_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DocumentScanner_DetectCornersFromNV12Image_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  DocumentScannerPtr.prototype.detectCornersFromJPEGImage = function() {
    return DocumentScannerProxy.prototype.detectCornersFromJPEGImage
        .apply(this.ptr.getProxy(), arguments);
  };

  DocumentScannerProxy.prototype.detectCornersFromJPEGImage = function(jpegImage) {
    var params_ = new DocumentScanner_DetectCornersFromJPEGImage_Params();
    params_.jpegImage = jpegImage;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDocumentScanner_DetectCornersFromJPEGImage_Name,
          codec.align(DocumentScanner_DetectCornersFromJPEGImage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DocumentScanner_DetectCornersFromJPEGImage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DocumentScanner_DetectCornersFromJPEGImage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  DocumentScannerPtr.prototype.doPostProcessing = function() {
    return DocumentScannerProxy.prototype.doPostProcessing
        .apply(this.ptr.getProxy(), arguments);
  };

  DocumentScannerProxy.prototype.doPostProcessing = function(jpegImage, corners, rotation) {
    var params_ = new DocumentScanner_DoPostProcessing_Params();
    params_.jpegImage = jpegImage;
    params_.corners = corners;
    params_.rotation = rotation;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDocumentScanner_DoPostProcessing_Name,
          codec.align(DocumentScanner_DoPostProcessing_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DocumentScanner_DoPostProcessing_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DocumentScanner_DoPostProcessing_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function DocumentScannerStub(delegate) {
    this.delegate_ = delegate;
  }
  DocumentScannerStub.prototype.detectCornersFromNV12Image = function(nv12Image) {
    return this.delegate_ && this.delegate_.detectCornersFromNV12Image && this.delegate_.detectCornersFromNV12Image(nv12Image);
  }
  DocumentScannerStub.prototype.detectCornersFromJPEGImage = function(jpegImage) {
    return this.delegate_ && this.delegate_.detectCornersFromJPEGImage && this.delegate_.detectCornersFromJPEGImage(jpegImage);
  }
  DocumentScannerStub.prototype.doPostProcessing = function(jpegImage, corners, rotation) {
    return this.delegate_ && this.delegate_.doPostProcessing && this.delegate_.doPostProcessing(jpegImage, corners, rotation);
  }

  DocumentScannerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  DocumentScannerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDocumentScanner_DetectCornersFromNV12Image_Name:
      var params = reader.decodeStruct(DocumentScanner_DetectCornersFromNV12Image_Params);
      this.detectCornersFromNV12Image(params.nv12Image).then(function(response) {
        var responseParams =
            new DocumentScanner_DetectCornersFromNV12Image_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kDocumentScanner_DetectCornersFromNV12Image_Name,
            codec.align(DocumentScanner_DetectCornersFromNV12Image_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DocumentScanner_DetectCornersFromNV12Image_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kDocumentScanner_DetectCornersFromJPEGImage_Name:
      var params = reader.decodeStruct(DocumentScanner_DetectCornersFromJPEGImage_Params);
      this.detectCornersFromJPEGImage(params.jpegImage).then(function(response) {
        var responseParams =
            new DocumentScanner_DetectCornersFromJPEGImage_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kDocumentScanner_DetectCornersFromJPEGImage_Name,
            codec.align(DocumentScanner_DetectCornersFromJPEGImage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DocumentScanner_DetectCornersFromJPEGImage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kDocumentScanner_DoPostProcessing_Name:
      var params = reader.decodeStruct(DocumentScanner_DoPostProcessing_Params);
      this.doPostProcessing(params.jpegImage, params.corners, params.rotation).then(function(response) {
        var responseParams =
            new DocumentScanner_DoPostProcessing_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kDocumentScanner_DoPostProcessing_Name,
            codec.align(DocumentScanner_DoPostProcessing_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DocumentScanner_DoPostProcessing_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateDocumentScannerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kDocumentScanner_DetectCornersFromNV12Image_Name:
        if (message.expectsResponse())
          paramsClass = DocumentScanner_DetectCornersFromNV12Image_Params;
      break;
      case kDocumentScanner_DetectCornersFromJPEGImage_Name:
        if (message.expectsResponse())
          paramsClass = DocumentScanner_DetectCornersFromJPEGImage_Params;
      break;
      case kDocumentScanner_DoPostProcessing_Name:
        if (message.expectsResponse())
          paramsClass = DocumentScanner_DoPostProcessing_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateDocumentScannerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kDocumentScanner_DetectCornersFromNV12Image_Name:
        if (message.isResponse())
          paramsClass = DocumentScanner_DetectCornersFromNV12Image_ResponseParams;
        break;
      case kDocumentScanner_DetectCornersFromJPEGImage_Name:
        if (message.isResponse())
          paramsClass = DocumentScanner_DetectCornersFromJPEGImage_ResponseParams;
        break;
      case kDocumentScanner_DoPostProcessing_Name:
        if (message.isResponse())
          paramsClass = DocumentScanner_DoPostProcessing_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var DocumentScanner = {
    name: 'chromeos.machine_learning.mojom.DocumentScanner',
    kVersion: 1,
    ptrClass: DocumentScannerPtr,
    proxyClass: DocumentScannerProxy,
    stubClass: DocumentScannerStub,
    validateRequest: validateDocumentScannerRequest,
    validateResponse: validateDocumentScannerResponse,
  };
  DocumentScannerStub.prototype.validator = validateDocumentScannerRequest;
  DocumentScannerProxy.prototype.validator = validateDocumentScannerResponse;
  exports.DocumentScannerResultStatus = DocumentScannerResultStatus;
  exports.DocumentScannerConfig = DocumentScannerConfig;
  exports.DetectCornersResult = DetectCornersResult;
  exports.DoPostProcessingResult = DoPostProcessingResult;
  exports.DocumentScanner = DocumentScanner;
  exports.DocumentScannerPtr = DocumentScannerPtr;
  exports.DocumentScannerAssociatedPtr = DocumentScannerAssociatedPtr;
})();