// chromeos/services/machine_learning/public/mojom/document_scanner.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  ReadOnlySharedMemoryRegion as mojoBase_mojom_ReadOnlySharedMemoryRegion,
  ReadOnlySharedMemoryRegionSpec as mojoBase_mojom_ReadOnlySharedMemoryRegionSpec
} from '../../../../../mojo/public/mojom/base/shared_memory.mojom.m.js';

import {
  PointF as gfx_mojom_PointF,
  PointFSpec as gfx_mojom_PointFSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Rotation as chromeos_machineLearning_mojom_Rotation,
  RotationSpec as chromeos_machineLearning_mojom_RotationSpec
} from './document_scanner_param_types.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DocumentScannerResultStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DocumentScannerResultStatus = {
  
  OK: 0,
  ERROR: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DocumentScannerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.machine_learning.mojom.DocumentScanner', scope);
  }
}

/** @interface */
export class DocumentScannerInterface {
  
  /**
   * @param { !mojoBase_mojom_ReadOnlySharedMemoryRegion } nv12Image
   * @return {!Promise<{
        result: !DetectCornersResult,
   *  }>}
   */

  detectCornersFromNV12Image(nv12Image) {}
  
  /**
   * @param { !mojoBase_mojom_ReadOnlySharedMemoryRegion } jpegImage
   * @return {!Promise<{
        result: !DetectCornersResult,
   *  }>}
   */

  detectCornersFromJPEGImage(jpegImage) {}
  
  /**
   * @param { !mojoBase_mojom_ReadOnlySharedMemoryRegion } jpegImage
   * @param { !Array<!gfx_mojom_PointF> } corners
   * @param { !chromeos_machineLearning_mojom_Rotation } rotation
   * @return {!Promise<{
        result: !DoPostProcessingResult,
   *  }>}
   */

  doPostProcessing(jpegImage, corners, rotation) {}
}

/**
 * @implements { DocumentScannerInterface }
 */
export class DocumentScannerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DocumentScannerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DocumentScannerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DocumentScannerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_ReadOnlySharedMemoryRegion } nv12Image
   * @return {!Promise<{
        result: !DetectCornersResult,
   *  }>}
   */

  detectCornersFromNV12Image(
      nv12Image) {
    return this.proxy.sendMessage(
        0,
        DocumentScanner_DetectCornersFromNV12Image_ParamsSpec.$,
        DocumentScanner_DetectCornersFromNV12Image_ResponseParamsSpec.$,
        [
          nv12Image
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_ReadOnlySharedMemoryRegion } jpegImage
   * @return {!Promise<{
        result: !DetectCornersResult,
   *  }>}
   */

  detectCornersFromJPEGImage(
      jpegImage) {
    return this.proxy.sendMessage(
        1,
        DocumentScanner_DetectCornersFromJPEGImage_ParamsSpec.$,
        DocumentScanner_DetectCornersFromJPEGImage_ResponseParamsSpec.$,
        [
          jpegImage
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_ReadOnlySharedMemoryRegion } jpegImage
   * @param { !Array<!gfx_mojom_PointF> } corners
   * @param { !chromeos_machineLearning_mojom_Rotation } rotation
   * @return {!Promise<{
        result: !DoPostProcessingResult,
   *  }>}
   */

  doPostProcessing(
      jpegImage,
      corners,
      rotation) {
    return this.proxy.sendMessage(
        2,
        DocumentScanner_DoPostProcessing_ParamsSpec.$,
        DocumentScanner_DoPostProcessing_ResponseParamsSpec.$,
        [
          jpegImage,
          corners,
          rotation
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DocumentScanner
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DocumentScannerReceiver {
  /**
   * @param {!DocumentScannerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DocumentScannerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DocumentScannerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DocumentScannerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DocumentScanner_DetectCornersFromNV12Image_ParamsSpec.$,
        DocumentScanner_DetectCornersFromNV12Image_ResponseParamsSpec.$,
        impl.detectCornersFromNV12Image.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DocumentScanner_DetectCornersFromJPEGImage_ParamsSpec.$,
        DocumentScanner_DetectCornersFromJPEGImage_ResponseParamsSpec.$,
        impl.detectCornersFromJPEGImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DocumentScanner_DoPostProcessing_ParamsSpec.$,
        DocumentScanner_DoPostProcessing_ResponseParamsSpec.$,
        impl.doPostProcessing.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DocumentScanner {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.DocumentScanner";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DocumentScannerRemote}
   */
  static getRemote() {
    let remote = new DocumentScannerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DocumentScanner
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DocumentScannerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DocumentScannerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DocumentScannerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detectCornersFromNV12Image =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DocumentScanner_DetectCornersFromNV12Image_ParamsSpec.$,
        DocumentScanner_DetectCornersFromNV12Image_ResponseParamsSpec.$,
        this.detectCornersFromNV12Image.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.detectCornersFromJPEGImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DocumentScanner_DetectCornersFromJPEGImage_ParamsSpec.$,
        DocumentScanner_DetectCornersFromJPEGImage_ResponseParamsSpec.$,
        this.detectCornersFromJPEGImage.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.doPostProcessing =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DocumentScanner_DoPostProcessing_ParamsSpec.$,
        DocumentScanner_DoPostProcessing_ResponseParamsSpec.$,
        this.doPostProcessing.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DocumentScannerConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DetectCornersResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DoPostProcessingResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DocumentScanner_DetectCornersFromNV12Image_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DocumentScanner_DetectCornersFromNV12Image_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DocumentScanner_DetectCornersFromJPEGImage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DocumentScanner_DetectCornersFromJPEGImage_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DocumentScanner_DoPostProcessing_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DocumentScanner_DoPostProcessing_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DocumentScannerConfigSpec.$,
    'DocumentScannerConfig',
    [
      mojo.internal.StructField(
        'deprecatedLibraryDlcPath', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'libraryDlcPath', 8,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        true /* nullable */,
        1,
      ),
    ],
    [[0, 16],[1, 24],]);



/**
 * @record
 */
export class DocumentScannerConfig {
  constructor() {
    /** @type { !string } */
    this.deprecatedLibraryDlcPath;
    /** @type { (mojoBase_mojom_FilePath|undefined) } */
    this.libraryDlcPath;
  }
}



mojo.internal.Struct(
    DetectCornersResultSpec.$,
    'DetectCornersResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        DocumentScannerResultStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'corners', 8,
        0,
        mojo.internal.Array(gfx_mojom_PointFSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DetectCornersResult {
  constructor() {
    /** @type { !DocumentScannerResultStatus } */
    this.status;
    /** @type { !Array<!gfx_mojom_PointF> } */
    this.corners;
  }
}



mojo.internal.Struct(
    DoPostProcessingResultSpec.$,
    'DoPostProcessingResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        DocumentScannerResultStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'processedJpegImage', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DoPostProcessingResult {
  constructor() {
    /** @type { !DocumentScannerResultStatus } */
    this.status;
    /** @type { !Array<!number> } */
    this.processedJpegImage;
  }
}



mojo.internal.Struct(
    DocumentScanner_DetectCornersFromNV12Image_ParamsSpec.$,
    'DocumentScanner_DetectCornersFromNV12Image_Params',
    [
      mojo.internal.StructField(
        'nv12Image', 0,
        0,
        mojoBase_mojom_ReadOnlySharedMemoryRegionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DocumentScanner_DetectCornersFromNV12Image_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlySharedMemoryRegion } */
    this.nv12Image;
  }
}



mojo.internal.Struct(
    DocumentScanner_DetectCornersFromNV12Image_ResponseParamsSpec.$,
    'DocumentScanner_DetectCornersFromNV12Image_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        DetectCornersResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DocumentScanner_DetectCornersFromNV12Image_ResponseParams {
  constructor() {
    /** @type { !DetectCornersResult } */
    this.result;
  }
}



mojo.internal.Struct(
    DocumentScanner_DetectCornersFromJPEGImage_ParamsSpec.$,
    'DocumentScanner_DetectCornersFromJPEGImage_Params',
    [
      mojo.internal.StructField(
        'jpegImage', 0,
        0,
        mojoBase_mojom_ReadOnlySharedMemoryRegionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DocumentScanner_DetectCornersFromJPEGImage_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlySharedMemoryRegion } */
    this.jpegImage;
  }
}



mojo.internal.Struct(
    DocumentScanner_DetectCornersFromJPEGImage_ResponseParamsSpec.$,
    'DocumentScanner_DetectCornersFromJPEGImage_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        DetectCornersResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DocumentScanner_DetectCornersFromJPEGImage_ResponseParams {
  constructor() {
    /** @type { !DetectCornersResult } */
    this.result;
  }
}



mojo.internal.Struct(
    DocumentScanner_DoPostProcessing_ParamsSpec.$,
    'DocumentScanner_DoPostProcessing_Params',
    [
      mojo.internal.StructField(
        'jpegImage', 0,
        0,
        mojoBase_mojom_ReadOnlySharedMemoryRegionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'corners', 8,
        0,
        mojo.internal.Array(gfx_mojom_PointFSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rotation', 16,
        0,
        chromeos_machineLearning_mojom_RotationSpec.$,
        0,
        false /* nullable */,
        1,
      ),
    ],
    [[0, 24],[1, 32],]);



/**
 * @record
 */
export class DocumentScanner_DoPostProcessing_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ReadOnlySharedMemoryRegion } */
    this.jpegImage;
    /** @type { !Array<!gfx_mojom_PointF> } */
    this.corners;
    /** @type { !chromeos_machineLearning_mojom_Rotation } */
    this.rotation;
  }
}



mojo.internal.Struct(
    DocumentScanner_DoPostProcessing_ResponseParamsSpec.$,
    'DocumentScanner_DoPostProcessing_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        DoPostProcessingResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DocumentScanner_DoPostProcessing_ResponseParams {
  constructor() {
    /** @type { !DoPostProcessingResult } */
    this.result;
  }
}

