// chromeos/services/machine_learning/public/mojom/grammar_checker.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('chromeos.machineLearning.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
chromeos.machineLearning.mojom.GrammarCheckerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        chromeos.machineLearning.mojom.GrammarChecker.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { chromeos.machineLearning.mojom.GrammarCheckerInterface }
 */
chromeos.machineLearning.mojom.GrammarCheckerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!chromeos.machineLearning.mojom.GrammarCheckerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          chromeos.machineLearning.mojom.GrammarCheckerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!chromeos.machineLearning.mojom.GrammarCheckerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !chromeos.machineLearning.mojom.GrammarCheckerQuery } query
   * @return {!Promise<{
        result: !chromeos.machineLearning.mojom.GrammarCheckerResult,
   *  }>}
   */

  check(
      query) {
    return this.proxy.sendMessage(
        0,
        chromeos.machineLearning.mojom.GrammarChecker_Check_ParamsSpec.$,
        chromeos.machineLearning.mojom.GrammarChecker_Check_ResponseParamsSpec.$,
        [
          query
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GrammarChecker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
chromeos.machineLearning.mojom.GrammarCheckerReceiver = class {
  /**
   * @param {!chromeos.machineLearning.mojom.GrammarCheckerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!chromeos.machineLearning.mojom.GrammarCheckerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        chromeos.machineLearning.mojom.GrammarCheckerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.GrammarCheckerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.GrammarChecker_Check_ParamsSpec.$,
        chromeos.machineLearning.mojom.GrammarChecker_Check_ResponseParamsSpec.$,
        impl.check.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
chromeos.machineLearning.mojom.GrammarChecker = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.GrammarChecker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!chromeos.machineLearning.mojom.GrammarCheckerRemote}
   * @export
   */
  static getRemote() {
    let remote = new chromeos.machineLearning.mojom.GrammarCheckerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the GrammarChecker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
chromeos.machineLearning.mojom.GrammarCheckerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      chromeos.machineLearning.mojom.GrammarCheckerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!chromeos.machineLearning.mojom.GrammarCheckerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.check =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        chromeos.machineLearning.mojom.GrammarChecker_Check_ParamsSpec.$,
        chromeos.machineLearning.mojom.GrammarChecker_Check_ResponseParamsSpec.$,
        this.check.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.GrammarCheckerQuerySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.GrammarCorrectionFragmentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.GrammarCheckerCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.GrammarCheckerResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.GrammarChecker_Check_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
chromeos.machineLearning.mojom.GrammarChecker_Check_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    chromeos.machineLearning.mojom.GrammarCheckerQuerySpec.$,
    'GrammarCheckerQuery',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'language', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.GrammarCheckerQuery = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { !string } */
    this.language;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.GrammarCorrectionFragmentSpec.$,
    'GrammarCorrectionFragment',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'length', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'replacement', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.GrammarCorrectionFragment = class {
  constructor() {
    /** @export { !number } */
    this.offset;
    /** @export { !number } */
    this.length;
    /** @export { !string } */
    this.replacement;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.GrammarCheckerCandidateSpec.$,
    'GrammarCheckerCandidate',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'score', 8,
        0,
        mojo.internal.Float,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'fragments', 16,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.GrammarCorrectionFragmentSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
chromeos.machineLearning.mojom.GrammarCheckerCandidate = class {
  constructor() {
    /** @export { !string } */
    this.text;
    /** @export { !number } */
    this.score;
    /** @export { !Array<!chromeos.machineLearning.mojom.GrammarCorrectionFragment> } */
    this.fragments;
  }
};



/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
chromeos.machineLearning.mojom.GrammarCheckerResultSpec.StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
chromeos.machineLearning.mojom.GrammarCheckerResult_Status = {
  
  OK: 0,
  ERROR: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    chromeos.machineLearning.mojom.GrammarCheckerResultSpec.$,
    'GrammarCheckerResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        chromeos.machineLearning.mojom.GrammarCheckerResultSpec.StatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'candidates', 8,
        0,
        mojo.internal.Array(chromeos.machineLearning.mojom.GrammarCheckerCandidateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
chromeos.machineLearning.mojom.GrammarCheckerResult = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.GrammarCheckerResult_Status } */
    this.status;
    /** @export { !Array<!chromeos.machineLearning.mojom.GrammarCheckerCandidate> } */
    this.candidates;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.GrammarChecker_Check_ParamsSpec.$,
    'GrammarChecker_Check_Params',
    [
      mojo.internal.StructField(
        'query', 0,
        0,
        chromeos.machineLearning.mojom.GrammarCheckerQuerySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.GrammarChecker_Check_Params = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.GrammarCheckerQuery } */
    this.query;
  }
};



mojo.internal.Struct(
    chromeos.machineLearning.mojom.GrammarChecker_Check_ResponseParamsSpec.$,
    'GrammarChecker_Check_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        chromeos.machineLearning.mojom.GrammarCheckerResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
chromeos.machineLearning.mojom.GrammarChecker_Check_ResponseParams = class {
  constructor() {
    /** @export { !chromeos.machineLearning.mojom.GrammarCheckerResult } */
    this.result;
  }
};

