// chromeos/services/machine_learning/public/mojom/grammar_checker.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'chromeos/services/machine_learning/public/mojom/grammar_checker.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('chromeos.machineLearning.mojom');



  function GrammarCheckerQuery(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GrammarCheckerQuery.prototype.initDefaults_ = function() {
    this.text = null;
    this.language = null;
  };
  GrammarCheckerQuery.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GrammarCheckerQuery.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GrammarCheckerQuery.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate GrammarCheckerQuery.language
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GrammarCheckerQuery.encodedSize = codec.kStructHeaderSize + 16;

  GrammarCheckerQuery.decode = function(decoder) {
    var packed;
    var val = new GrammarCheckerQuery();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.language =
        decoder.decodeStruct(codec.String);
    return val;
  };

  GrammarCheckerQuery.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GrammarCheckerQuery.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStruct(codec.String, val.language);
  };
  function GrammarCorrectionFragment(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GrammarCorrectionFragment.prototype.initDefaults_ = function() {
    this.offset = 0;
    this.length = 0;
    this.replacement = null;
  };
  GrammarCorrectionFragment.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GrammarCorrectionFragment.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate GrammarCorrectionFragment.replacement
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GrammarCorrectionFragment.encodedSize = codec.kStructHeaderSize + 16;

  GrammarCorrectionFragment.decode = function(decoder) {
    var packed;
    var val = new GrammarCorrectionFragment();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.offset =
        decoder.decodeStruct(codec.Uint32);
    val.length =
        decoder.decodeStruct(codec.Uint32);
    val.replacement =
        decoder.decodeStruct(codec.String);
    return val;
  };

  GrammarCorrectionFragment.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GrammarCorrectionFragment.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.offset);
    encoder.encodeStruct(codec.Uint32, val.length);
    encoder.encodeStruct(codec.String, val.replacement);
  };
  function GrammarCheckerCandidate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GrammarCheckerCandidate.prototype.initDefaults_ = function() {
    this.text = null;
    this.score = 0;
    this.fragments = null;
  };
  GrammarCheckerCandidate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GrammarCheckerCandidate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GrammarCheckerCandidate.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate GrammarCheckerCandidate.fragments
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(GrammarCorrectionFragment), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GrammarCheckerCandidate.encodedSize = codec.kStructHeaderSize + 24;

  GrammarCheckerCandidate.decode = function(decoder) {
    var packed;
    var val = new GrammarCheckerCandidate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.score =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.fragments =
        decoder.decodeArrayPointer(new codec.PointerTo(GrammarCorrectionFragment));
    return val;
  };

  GrammarCheckerCandidate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GrammarCheckerCandidate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStruct(codec.Float, val.score);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(GrammarCorrectionFragment), val.fragments);
  };
  function GrammarCheckerResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  GrammarCheckerResult.Status = {};
  GrammarCheckerResult.Status.OK = 0;
  GrammarCheckerResult.Status.ERROR = 1;
  GrammarCheckerResult.Status.MIN_VALUE = 0;
  GrammarCheckerResult.Status.MAX_VALUE = 1;

  GrammarCheckerResult.Status.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  GrammarCheckerResult.Status.toKnownEnumValue = function(value) {
    return value;
  };

  GrammarCheckerResult.Status.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  GrammarCheckerResult.prototype.initDefaults_ = function() {
    this.status = 0;
    this.candidates = null;
  };
  GrammarCheckerResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GrammarCheckerResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GrammarCheckerResult.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, GrammarCheckerResult.Status);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GrammarCheckerResult.candidates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(GrammarCheckerCandidate), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GrammarCheckerResult.encodedSize = codec.kStructHeaderSize + 16;

  GrammarCheckerResult.decode = function(decoder) {
    var packed;
    var val = new GrammarCheckerResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(GrammarCheckerResult.Status));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.candidates =
        decoder.decodeArrayPointer(new codec.PointerTo(GrammarCheckerCandidate));
    return val;
  };

  GrammarCheckerResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GrammarCheckerResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(GrammarCheckerCandidate), val.candidates);
  };
  function GrammarChecker_Check_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GrammarChecker_Check_Params.prototype.initDefaults_ = function() {
    this.query = null;
  };
  GrammarChecker_Check_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GrammarChecker_Check_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GrammarChecker_Check_Params.query
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, GrammarCheckerQuery, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GrammarChecker_Check_Params.encodedSize = codec.kStructHeaderSize + 8;

  GrammarChecker_Check_Params.decode = function(decoder) {
    var packed;
    var val = new GrammarChecker_Check_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.query =
        decoder.decodeStructPointer(GrammarCheckerQuery);
    return val;
  };

  GrammarChecker_Check_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GrammarChecker_Check_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(GrammarCheckerQuery, val.query);
  };
  function GrammarChecker_Check_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GrammarChecker_Check_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  GrammarChecker_Check_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GrammarChecker_Check_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GrammarChecker_Check_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, GrammarCheckerResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GrammarChecker_Check_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  GrammarChecker_Check_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new GrammarChecker_Check_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(GrammarCheckerResult);
    return val;
  };

  GrammarChecker_Check_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GrammarChecker_Check_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(GrammarCheckerResult, val.result);
  };
  var kGrammarChecker_Check_Name = 0;

  function GrammarCheckerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(GrammarChecker,
                                                   handleOrPtrInfo);
  }

  function GrammarCheckerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        GrammarChecker, associatedInterfacePtrInfo);
  }

  GrammarCheckerAssociatedPtr.prototype =
      Object.create(GrammarCheckerPtr.prototype);
  GrammarCheckerAssociatedPtr.prototype.constructor =
      GrammarCheckerAssociatedPtr;

  function GrammarCheckerProxy(receiver) {
    this.receiver_ = receiver;
  }
  GrammarCheckerPtr.prototype.check = function() {
    return GrammarCheckerProxy.prototype.check
        .apply(this.ptr.getProxy(), arguments);
  };

  GrammarCheckerProxy.prototype.check = function(query) {
    var params_ = new GrammarChecker_Check_Params();
    params_.query = query;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kGrammarChecker_Check_Name,
          codec.align(GrammarChecker_Check_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(GrammarChecker_Check_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(GrammarChecker_Check_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function GrammarCheckerStub(delegate) {
    this.delegate_ = delegate;
  }
  GrammarCheckerStub.prototype.check = function(query) {
    return this.delegate_ && this.delegate_.check && this.delegate_.check(query);
  }

  GrammarCheckerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  GrammarCheckerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kGrammarChecker_Check_Name:
      var params = reader.decodeStruct(GrammarChecker_Check_Params);
      this.check(params.query).then(function(response) {
        var responseParams =
            new GrammarChecker_Check_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kGrammarChecker_Check_Name,
            codec.align(GrammarChecker_Check_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(GrammarChecker_Check_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateGrammarCheckerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kGrammarChecker_Check_Name:
        if (message.expectsResponse())
          paramsClass = GrammarChecker_Check_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateGrammarCheckerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kGrammarChecker_Check_Name:
        if (message.isResponse())
          paramsClass = GrammarChecker_Check_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var GrammarChecker = {
    name: 'chromeos.machine_learning.mojom.GrammarChecker',
    kVersion: 0,
    ptrClass: GrammarCheckerPtr,
    proxyClass: GrammarCheckerProxy,
    stubClass: GrammarCheckerStub,
    validateRequest: validateGrammarCheckerRequest,
    validateResponse: validateGrammarCheckerResponse,
  };
  GrammarCheckerStub.prototype.validator = validateGrammarCheckerRequest;
  GrammarCheckerProxy.prototype.validator = validateGrammarCheckerResponse;
  exports.GrammarCheckerQuery = GrammarCheckerQuery;
  exports.GrammarCorrectionFragment = GrammarCorrectionFragment;
  exports.GrammarCheckerCandidate = GrammarCheckerCandidate;
  exports.GrammarCheckerResult = GrammarCheckerResult;
  exports.GrammarChecker = GrammarChecker;
  exports.GrammarCheckerPtr = GrammarCheckerPtr;
  exports.GrammarCheckerAssociatedPtr = GrammarCheckerAssociatedPtr;
})();