// chromeos/services/machine_learning/public/mojom/grammar_checker.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class GrammarCheckerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'chromeos.machine_learning.mojom.GrammarChecker', scope);
  }
}

/** @interface */
export class GrammarCheckerInterface {
  
  /**
   * @param { !GrammarCheckerQuery } query
   * @return {!Promise<{
        result: !GrammarCheckerResult,
   *  }>}
   */

  check(query) {}
}

/**
 * @implements { GrammarCheckerInterface }
 */
export class GrammarCheckerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!GrammarCheckerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GrammarCheckerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!GrammarCheckerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !GrammarCheckerQuery } query
   * @return {!Promise<{
        result: !GrammarCheckerResult,
   *  }>}
   */

  check(
      query) {
    return this.proxy.sendMessage(
        0,
        GrammarChecker_Check_ParamsSpec.$,
        GrammarChecker_Check_ResponseParamsSpec.$,
        [
          query
        ],
        false);
  }
}

/**
 * An object which receives request messages for the GrammarChecker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GrammarCheckerReceiver {
  /**
   * @param {!GrammarCheckerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!GrammarCheckerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GrammarCheckerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GrammarCheckerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GrammarChecker_Check_ParamsSpec.$,
        GrammarChecker_Check_ResponseParamsSpec.$,
        impl.check.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GrammarChecker {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "chromeos.machine_learning.mojom.GrammarChecker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!GrammarCheckerRemote}
   */
  static getRemote() {
    let remote = new GrammarCheckerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the GrammarChecker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GrammarCheckerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GrammarCheckerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GrammarCheckerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.check =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GrammarChecker_Check_ParamsSpec.$,
        GrammarChecker_Check_ResponseParamsSpec.$,
        this.check.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GrammarCheckerQuerySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GrammarCorrectionFragmentSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GrammarCheckerCandidateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GrammarCheckerResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GrammarChecker_Check_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GrammarChecker_Check_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    GrammarCheckerQuerySpec.$,
    'GrammarCheckerQuery',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'language', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class GrammarCheckerQuery {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { !string } */
    this.language;
  }
}



mojo.internal.Struct(
    GrammarCorrectionFragmentSpec.$,
    'GrammarCorrectionFragment',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'length', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'replacement', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class GrammarCorrectionFragment {
  constructor() {
    /** @type { !number } */
    this.offset;
    /** @type { !number } */
    this.length;
    /** @type { !string } */
    this.replacement;
  }
}



mojo.internal.Struct(
    GrammarCheckerCandidateSpec.$,
    'GrammarCheckerCandidate',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'score', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fragments', 16,
        0,
        mojo.internal.Array(GrammarCorrectionFragmentSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class GrammarCheckerCandidate {
  constructor() {
    /** @type { !string } */
    this.text;
    /** @type { !number } */
    this.score;
    /** @type { !Array<!GrammarCorrectionFragment> } */
    this.fragments;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const GrammarCheckerResult_StatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const GrammarCheckerResult_Status = {
  
  OK: 0,
  ERROR: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    GrammarCheckerResultSpec.$,
    'GrammarCheckerResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        GrammarCheckerResult_StatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'candidates', 8,
        0,
        mojo.internal.Array(GrammarCheckerCandidateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class GrammarCheckerResult {
  constructor() {
    /** @type { !GrammarCheckerResult_Status } */
    this.status;
    /** @type { !Array<!GrammarCheckerCandidate> } */
    this.candidates;
  }
}



mojo.internal.Struct(
    GrammarChecker_Check_ParamsSpec.$,
    'GrammarChecker_Check_Params',
    [
      mojo.internal.StructField(
        'query', 0,
        0,
        GrammarCheckerQuerySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GrammarChecker_Check_Params {
  constructor() {
    /** @type { !GrammarCheckerQuery } */
    this.query;
  }
}



mojo.internal.Struct(
    GrammarChecker_Check_ResponseParamsSpec.$,
    'GrammarChecker_Check_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        GrammarCheckerResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GrammarChecker_Check_ResponseParams {
  constructor() {
    /** @type { !GrammarCheckerResult } */
    this.result;
  }
}

